//AIM:Find the minimum transmitter power of microwave repeater operating
//at 10 GHz.
//Software version Scilab 5.5.2
//OS windows 7

clc;
clear;
//Let a series of microwave repeater links operate at 10 GHz and are
//used to relay television signals into a valley that is surrounded by 
//steep mountain ranges. Each repeater consists of a transmitter, 
//receiver antennas and associated equipment. The transmitting
// and receving antennas are identical horns with gain of 15 dB each.
//The repeaters are separated by 10 km. For acceptable signal to noise 
//ratio, the power received at each repeater must be greater than 10 nW.
//Loss due to ploarization mismatch should not exceed 3dB. Assuming 
//matched loads,we will compute the minimum transmitter power that should
//be used.
f=10*10^9;//Frequency
c=3*10^8;//Speed of light
Pr=10*10^-9;
lambda=c/f;//Computing the wavelength
disp('m',lambda,"Wavelength=")
Gdb=15;//(in dB)
G=10^(Gdb/10);
Gt=G;
Gr=G;
disp(Gt,"Gt=")
disp(Gr,"Gr=")
r=10*10^3;
adb=-3//in dB
a=10^(adb/10);
disp(a,"|aT*aR|^2=")
PLF=sqrt(a)
disp(PLF,"Dimensionless polarization loss factor(PLF)=")
b=(((lambda/(4*%pi*r))^2)*Gt*Gr*a);//b means calculation of Pr/Pt
disp(b,"Pr/Pt=")
Pt=Pr/b;
disp('W',Pt,"Minimum transmitter power=")
