//AIM: Design a rectangular microstrip antenna whose centre frequency is 2.4 GHz.
//Software version Scilab 5.5.2
//OS windows 7
clc;
clear;

fr=2.4*(10^9);
Er=4.4;//Dielectric constant of the substrate
h=1.6*(10^-3);//Height of the substrate
vo=3*(10^8);
W=(vo/(2*fr))*((2/(Er+1))^(1/2));
disp('m',W,"Width of patch=");
Ereff=((Er+1)/2)+(((Er-1)/2)*((1+12*(h/W)))^(-0.5));
disp(Ereff,"Ereff=");
x=W/h;
disp(x,"W/h=");
dL=((h*0.412)*(Ereff+0.3)*(x+0.264))/((Ereff-0.258)*(x+0.8));
disp('m',dL,"dL=");
L=(vo/(2*fr*(Ereff^0.5)))-(2*dL);
disp('m',L,"Length of patch=");
