//AIM:To design a broadside array
//Software version Scilab 5.5.2
//OS windows 7

clc;
//We will consider an array of four isotropic sources along z-axis separated by
// a distance of lambda/2 and a progressive phase shift alpha=0
//We will find:
//i)Null direction.
//ii)Direction to maxima.
//iii)Directions of sidelobe maxima.
//iv)Half power beamwidth.
//v)First null beam width.
//vi)Side lobe level.

clear;
//for ease of calculation taking lambda=1
lambda=1;
d=lambda/2;
n=4;//Since 4 isotropic point sources
alpha=0;//alpha=0 indicates broadside case
//(i) :To find Null direction
//For N=1
N=1;
ithetha01=int(acos(-N/2)*180/3.14);
thetha01=int(acos(N/2)*180/3.14);
//And for N=2
N=2;
ithetha02=int(acos(-N/2)*180/3.14);
thetha02=int(acos(N/2)*180/3.14);
disp('degrees',ithetha01,'degrees',thetha01,"Null direction for N=1 are ");
disp('degrees',ithetha02,'degrees',thetha02,"Null direction for N=2 are ");

//Taking N=3 onwards is not possible since N/2 is greater than 1 whose cos 
//inverse can not be determed

//(ii) : Calculating Directions of maxima:ithetham=acos(+-m*lam/d)
//taking m=0
m=0;
//hence
ithetham=acos(-0)*(180/3.14);
thetham=acos(0)*(180/3.14);
disp('degrees',thetham,'degrees',ithetham,"theta_m=");

//(iii) : Side lobe maxima:
//thethas=acos(+-((2s+1)λ/(2nd))   for S=1,2,....
//For S=1
S=1;
a=[(2*S+1)*lambda]/(2*n*d);
disp(a,'a=')
ithethas=acos(-a)*(180/3.14);
thethas=acos(a)*(180/3.14);
disp('degrees',ithethas,'degrees',thethas,"lobe maxima=");
//Values for S=2 onwards cannot be determined

//(iv) : Half power beamwidth.
//HPBW=2*(pi/2-acos((1.391*lam)/(pi*n*d))   hence
HPBW=2*(3.14/2-(acos(2*(1.391)/(4*3.14))))*180/3.14;
disp('degrees',HPBW,'HPBW=')

//(v) : First null beam width.
//FNBW=2*(3.14/2-acos((lam/(4*lam/2))
FNBW=2*(3.14/2-acos(2/n))*180/3.14;
disp('degrees',FNBW,'FNBW=')

//Side lobe level=((Maximum value of largest side lobe)/(Maximum value of major lobe))
SLL=20*log10(2/(3*3.14));
disp('dB',SLL,"Side lobe level (SLL)=");
