//AIM:To find the radiation efficiency in percentage of a single turn and 8 turns of small circular loop antenna.
//Software version Scilab 5.5.2
//OS windows 7
//Assume f=100MHz.The radius of the loop is a=λ/25, the radius of wire 
//is (d/2)=(10^-4)*λ and the turns are spaced 4*(10^-4)λ apart.Assume the wire of
//copper(sigma=5.7*(10^7) S/m) and the antenna is radiating in free space.
clc;
clear;
c=3*10^8;
f=100;//in MHz
lambda=c/(f*10^6);
disp('m',lambda,"λ=");
a=lambda/25;
disp('m',a,"radius=");
C=2*(%pi)*a;
disp(C,"circumference=");
d=(2*(10^(-4)))*lambda;//d is the diameter of the wire
disp('m',d,"diameter of wire=");
for N=list(1,8);//for single turn loop:N=1,8.
x=3430/((C^3)*(f^3.5)*N*d);//here x=RL/Rr
K=(1/(1+(x)))*100;
disp(N,"For N=");
disp(x,"RL/Rr=");
disp('%',K,"K=");
end;
