//fmincon demo
//Examples taken from https://in.mathworks.com/help/optim/ug/fmincon.html

//Demo 1
function y=fun1(x)
   y= 100*(x(2)-x(1)^2)^2 + (1-x(1))^2;
endfunction
x0 = [-1,2];
A = [1,2];
b = 1;

x = fmincon(fun1,x0,A,b)
disp(x)
//End of demo 1

halt('Press enter to continue')

//Demo 2
function z= fun2(x)
    z=100*(x(2)-x(1)^2)^2 + (1-x(1))^2;
endfunction
x0 = [0.5,0];
A = [1,2];
b = 1;
Aeq = [2,1];
beq = 1;

x = fmincon(fun2,x0,A,b,Aeq,beq)
disp(x)
//End of demo 2

halt('Press enter to continue')

//Demo 3
function a = fun3(x)
   a= 1+x(1)/(1+x(2)) - 3*x(1)*x(2) + x(2)*(1+x(1));
endfunction

lb = [0,0];
ub = [1,2];
A = [];
b = [];
Aeq = [];
beq = [];
x0 = [0.5,1];
//x = fmincon(fun3,x0,A,b,Aeq,beq,lb,ub)
//disp(x)
x0 = x0/5;
x = fmincon(fun3,x0,A,b,Aeq,beq,lb,ub)
disp(x)
//End of demo 3

halt('Press enter to continue')

//Demo 4

function bb=fun4(x)
    bb=100*(x(2)-x(1)^2)^2 + (1-x(1))^2;
endfunction

lb = [0,0.2];
ub = [0.5,0.8];
A = [];
b = [];
Aeq = [];
beq = [];
x0 = [1/4,1/4];

function [c,ceq] = circlecon(x)
c = (x(1)-1/3)^2 + (x(2)-1/3)^2 - (1/3)^2;
ceq = [];
endfunction

x = fmincon(fun4,x0,A,b,Aeq,beq,lb,ub,circlecon)
disp(x)


