//Viewing the Effects of Non-Linearity
VmaxPk = 2;       // Maximum operating voltage
Fi = 2000;        // Sinusoidal frequency of 2 kHz
Fs = 44.1e3;      // Sample rate of 44.1kHz
Tstop = 50e-3;    // Duration of sinusoid
t = 0:1/Fs:Tstop; // Input time vector

// Use the maximum allowable voltage of the amplifier
inputVmax = VmaxPk*sin(2*%pi*Fi*t);
//execute polyval
exec('./polyval.sci', -1)
//execute periodogram
exec('./periodogram.sci', -1)
//execute helperHarmonicDistortionAmplifier
exec('./helperHarmonicDistortionAmplifier.sci', -1)
outputVmax = helperHarmonicDistortionAmplifier(inputVmax);
halt('Press enter to show the plot');
//execute plot routine
scf(0);
plot(t, outputVmax);
xlabel('Time')
ylabel('Output Voltage');
title('Amplifier output');
halt('Press enter to display the periodogram');
//Plot Periodogram
samples=outputVmax;
nfft = size(samples,2);
win = window('kr',nfft, 38);
for i=1:size(samples,1)
  subplot(size(samples,1),1,i);
  [d,n]=periodogram(samples(i,:), win, nfft,Fs);
  scf(1);
  plot ([n], 10*log10 ([d]))
  title('spectrum before input attenuation');
end

//Quantifying Non-Linear Distortion
//thd ; snr; sinad

//Input Attenuation to Reduce Harmonic Distortion
halt('Press enter to display periodogram of the attenuated input');
inputVhalf = (VmaxPk/2) * sin(2*%pi*Fi*t);
outputVhalf = helperHarmonicDistortionAmplifier(inputVhalf);
samples=outputVhalf;
nfft = size(samples,2);
win = window('kr',nfft, 38);
for i=1:size(samples,1)
  subplot(size(samples,1),1,i);
  [d,n]=periodogram(samples(i,:), win, nfft,Fs);
  scf(2);
  plot ([n], 10*log10 ([d]));
  title('spectrum after input attenuation');
end
//Let's redo our metrics again, this time measuring the effect of lowering the input voltage.
//thdVhalf =
//
//  -72.0676
//
//
//snrVhalf =
//
//  124.8767
//
//
//sinadVhalf =
//
//   72.0676


