Fs = 500;                    // sample rate in Hz
N = 500;                     // number of signal samples
 //x noisy waveform
t = (0:N-1)/Fs;              // time vector

// Design a 70th order lowpass FIR filter with cutoff frequency of 75 Hz.

Fnorm = 75/(Fs/2);           // Normalized frequency
loadmatfile("x.mat");
loadmatfile("df_coefficients.mat");
exec("filtfilt.sci");
exec("grpdelay.sci");
exec("filter.sci");
df=df_coefficients;
scf(4);
plot(t,x)
//call octave
scf(0);
halt("Press enter to plot group delay");
[G,W]=grpdelay(df,2048,Fs)   // plot group delay
plot(W,round(G));
D = mean(grpdelay(df)); // filter delay in samples
halt("Press enter to plot the filtered signal");
y = filter(df,1,[x; zeros(D,1)]); // Append D zeros to the input data
y = y(D+1:$);                  // Shift data to compensate for delay
scf(1);
plot(t,x,t,y,'r','linewidth',1.5);
title('Filtered Waveforms');
xlabel('Time (s)')
legend('Original Noisy Signal','Filtered Signal');


//Compensating for Frequency-Dependent Delay

Fnorm = 75/(Fs/2); 
loadmatfile("./df_coefficients_freq.mat");
b=1;
a=1;
for i=[1:4]
    b=convol(b,df_coefficients_freq(i,1:3));
    a=convol(a,df_coefficients_freq(i,4:6));
end
//call octave
halt("Press enter to plot group delay");
[G,W]=grpdelay(b,a,2048,Fs);
scf(2);
plot(W,(G));
halt("Press enter to plot the filtered signal");
y1 = filter(b,a,x);    // non-linear phase filter - no delay compensation
y2 = filtfilt(b,a,x);  // zero-phase implementation - delay compensation

scf(3);
plot(t,x);
plot(t,y1,'r','linewidth',1.5);
plot(t,y2,'g','linewidth',1.5);
mtlb_axis([0.25 0.55 -1 1.5]);
title('Filtered Waveforms');
xlabel('Time (s)')
legend('Original Signal','Non-linear phase IIR output',...
  'Zero-phase IIR output');


//Removing Unwanted Spectral Content from a Signal

Fs = 44100; //Sample rate
y = wavread('noisymusic.wav');


