
//------------------------------------------------------------------------------
s = poly(0,'s');
sys = syslin('c',2.6/(1+62*s));
sys(1,2) = syslin('c',1.5/((1+23*s)*(1+62*s)));
sys(2,1) = syslin('c',1.4/((1+30*s)*(1+90*s)));
sys(2,2) = syslin('c',2.8/(1+90*s));
sys
u1 = idinput(2500,'rbs',[0 0.1],[-1 1])*0.5;
u2 = idinput(2500,'rbs',[0 0.2],[-1 1])*0.5;
u = [u1 u2];

sysd = ss2tf(dscr(sys,5));   // sampling time is 5 sec
//------------------------------------------------------------------------------
//Time domain difference Equation
h1temp1u1 = sysd(1,1).num*sysd(1,2).den;
h1temp1u2 = sysd(1,1).den*sysd(1,2).num;
h1temp1h1 = sysd(1,1).den*sysd(1,2).den;

h2temp2u1 = sysd(2,1).num*sysd(2,2).den;
h2temp2u2 = sysd(2,1).den*sysd(2,2).num;
h2temp2h2 = sysd(2,1).den*sysd(2,2).den;
//------------------------------------------------------------------------------
h1 = [0;0;0]; h2 = [0;0;0];
//u1 = [0;0;u1];u2 = [0;0;u2];
h1Coeffu1 = coeff(h1temp1u1);h1Coeffu2 = coeff(h1temp1u2);h1Coeffh1 = coeff(h1temp1h1);
h1Coeffu1 = h1Coeffu1(length(h1Coeffu1):-1:1);
h1Coeffu2 = h1Coeffu2(length(h1Coeffu2):-1:1);
h1Coeffh1 = h1Coeffh1(length(h1Coeffh1):-1:1);
h1Coeffh1 = -h1Coeffh1(2:$);

h2Coeffu1 = coeff(h2temp2u1);h2Coeffu2 = coeff(h2temp2u2);h2Coeffh2 = coeff(h2temp2h2);
h2Coeffu1 = h2Coeffu1(length(h2Coeffu1):-1:1);
h2Coeffu2 = h2Coeffu2(length(h2Coeffu2):-1:1);
h2Coeffh2 = h2Coeffh2(length(h2Coeffh2):-1:1);
h2Coeffh2 = -h2Coeffh2(2:$);

for ii = 4:length(u1)+1
    //pause
//    disp(ii)
    temp1 = h1Coeffu1(1)*u1(ii-1)+h1Coeffu1(2)*u1(ii-2)+h1Coeffu1(3)*u1(ii-3);
    temp2 = h1Coeffu2(1)*u2(ii-1)+h1Coeffu2(2)*u2(ii-2)+h1Coeffu2(3)*u2(ii-3);
    temp3 = h1Coeffh1(1)*h1(ii-1)+h1Coeffh1(2)*h1(ii-2)+h1Coeffh1(3)*h1(ii-3);
    h1 = [h1; temp1+temp2+temp3];
    
    temp11 = h2Coeffu1(1)*u1(ii-1)+h2Coeffu1(2)*u1(ii-2)+h2Coeffu1(3)*u1(ii-3);
    temp22 = h2Coeffu2(1)*u2(ii-1)+h2Coeffu2(2)*u2(ii-2)+h2Coeffu2(3)*u2(ii-3);
    temp33 = h2Coeffh2(1)*h2(ii-1)+h2Coeffh2(2)*h2(ii-2)+h2Coeffh2(3)*h2(ii-3);
    h2 = [h2; temp11+temp22+temp33];
end
h1 = h1(length(h1)-2499:$);
h2 = h2(length(h2)-2499:$);
savematfile('inputData.mat','u1','u2','h1','h2');
subplot(2,1,1);plot(h1);plot(u1,'m');xgrid
subplot(2,1,2);plot(h2);plot(u2,'m');xgrid
//plant modeling
plantDatah1u1 = [h1,u1];
arxh1u1 = arx(plantDatah1u1,[2,2,1])
plantDatah2u2 = [h2,u2];
arxh2u2 = arx(plantDatah2u2,[2,2,1])
figure;resid(plantDatah1u1,arxh1u1)
//------------------------------------------------------------------------------
   //https://scilab.io/water-tank-control-system/



//h1Coeffu1 = h1Coeffu1/h1Coeffh1(1,1);h1Coeffu2 = h1Coeffu2/h1Coeffh1(1,1); h1Coeffh1 = h1Coeffh1/h1Coeffh1(1,1);
