//clear
clc
   h01 = 12.4;    h02 = 12.7;
   h03 = 1.8;     h04 = 1.4;
   v01 = 3.0;     v02 = 3.0;
    k1 = 3.33;     k2 = 3.35;
gamma1 = 0.7;  gamma2 = 0.6;
    A1 = 28;       A3 = 28;
    A2 = 32;       A4 = 32;
    a1 = 0.071;    a3 = 0.071;
    a2 = 0.057;    a4 = 0.057;
    kc = 0.50;      g = 981;
     //
    CMat = [0.5,0,0,0;0,0.5,0,0];
    exec('idinput.sci',-1)
    t0 = 0;
    Ts = 5;
    u1 = idinput(2500,'prbs',[0.01 0.1],[-1 1])*0.5;
    u2 = idinput(2500,'prbs',[0.1 0.2],[-1 1])*0.5;
    uu = [u1 u2]+2;
function dh = quadtank(t,u)
    dh(1) = -(a1/A1) * sqrt(abs(2*g*u(1))) + (a3/A1)*sqrt(abs(2*g*u(3))) + gamma1*k1*uData1/A1;
    dh(2) = -(a1/A2) * sqrt(abs(2*g*u(2))) + (a4/A2)*sqrt(abs(2*g*u(4))) + gamma2*k2*uData2/A2;
    dh(3) = -(a3/A3) * sqrt(abs(2*g*u(3))) + (1 - gamma2)*k2*uData2/A3;
    dh(4) = -(a4/A4) * sqrt(abs(2*g*u(4))) + (1 - gamma1)*k1*uData1/A4;
endfunction
//    rand("uniform")
    h0 = [h01 h02 h03 h04]';
    tempH = [];
    tempH = [tempH h0];
    
    for ii = 2 : size(uu,'r')
        //ii
        uData = uu(ii-1,:);
        uData1 = uData(1);uData2 = uData(2);
        y = ode(h0,t0,[Ts],quadtank);
        h0 = y(:,$) + rand(4,1);// adding noise grand(4,1,"nor",0,1);//
        tempH = [tempH h0];
    end
    
    timeLength = (0:length(u1)-1)*Ts;
    figure;
    clf()
    subplot(2,2,1);plot(timeLength,tempH(1,:));xgrid;xtitle('','Time','h1 (cm)')
    subplot(2,2,2);plot(timeLength,tempH(2,:));xgrid;xtitle('','Time','h2 (cm)')
    subplot(2,2,3);plot(timeLength,tempH(3,:));xgrid;xtitle('','Time','h3 (cm)')
    subplot(2,2,4);plot(timeLength,tempH(4,:));xgrid;xtitle('','Time','h4 (cm)')
    
    yData = CMat * tempH;
    figure;
    clf()
    subplot(2,1,1);plot(timeLength,yData(1,:));xgrid;xtitle('','Time','h1 (cm)')
    subplot(2,1,2);plot(timeLength,yData(2,:));xgrid;xtitle('','Time','h2 (cm)')
    
    h1u1 = [tempH(1,:)',u1];
    h1u2 = [tempH(1,:)',u2];
    h2u1 = [tempH(2,:)',u1];
    h2u2 = [tempH(2,:)',u2];
    
    arx11 = arx(h1u1,[2,2,1]);
    arx12 = arx(h1u2,[2,2,1]);
    arx21 = arx(h2u1,[2,2,1]);
    arx22 = arx(h2u2,[2,2,1]);
    
    figure;clf();resid(h1u1,arx11)
    figure;clf();resid(h1u2,arx12)
    figure;clf();resid(h2u1,arx21)
    figure;clf();resid(h2u2,arx22)
    
//    S=15;
//    [R,N1,SVAL] = findR(S,tempH(1,:)',u1);
//    N=1;
//    sys1 = findABCD(S,N,1,R,1) ;sys1.dt=5;
//    
//    s = poly(0,'s');
//    sys1 = ss2tf(minss(sys1));
//    sys1c = horner(sys1,-(s*Ts/2+1)/(1-s*Ts/2))



    
