function varargout = step2(varargin)
    [lhs,rhs] = argn(0)
//------------------------------------------------------------------------------
// checking the input and out data 
    if rhs == 0 | (rhs == 1 & typeof(varargin($)) <> ['state-space', 'rational'] | (rhs == 1 & size(varargin($),'*') == 0)) then
        error(msprintf(gettext("%s: Wrong type for input argument \n#%d: State-space or transfer function of linear system expected.\n"),"step",1))
    end    
//------------------------------------------------------------------------------
// storing the indexs of discrete and continuous type system as well as the plot
// properties and time data
    CTindex = []
    DTindex = []
    colorIndex = []
    timeData = []
    timeCount = 0
    tempData = []
    isUnstable = %F
    plotFlag = %T
    for ii = 1:rhs//length(varargin)
         if typeof(varargin(ii)) == 'state-space' | typeof(varargin(ii)) == 'rational' then
             if varargin(ii).dt == 'c' then
                 CTindex = [CTindex ii]
             else
                 DTindex = [DTindex ii]
             end
         elseif typeof(varargin(ii)) == 'constant' then
             timeData = varargin(ii)
             timeCount = timeCount + 1
             if timeCount > 1 then
                 error(msprintf(gettext("%s: Wrong type for input argument \n#%d: Invalid syntax \n#%d: Too many time data  \n"),"step",1,2))
             end
         elseif typeof(varargin(ii)) == 'string' then
             if strcmp(varargin(ii),'off')== 0 then
                 plotFlag = %F
             elseif strcmp(varargin(ii),'on') == 0 then
                 plotFlag = %T
             else
                colorIndex = [colorIndex ii]
                if tempData == ii then
                    error(msprintf(gettext("%s: Wrong type for input argument \n#%d: Invalid syntax \n#%d: Too many color data  \n"),"step",1,2))
                end
                tempData = ii+1
            end
         else
             error(msprintf(gettext("%s: Wrong type for input argument \n#%d: State-space or transfer function of linear system expected.\n"),"step",1))
         end
    end
//------------------------------------------------------------------------------
//// selection of the flag response
    if ~plotFlag & size(CTindex,'*') + size(DTindex,'*') > 1 then
        error(msprintf(gettext("%s: When output argument is consider then %s takes only one system input.\n"),"step","step"))
    end
//------------------------------------------------------------------------------
//If sampling time is not given then make it by default 1 sample/sec
    if size(DTindex,'*') ~= 0 then
        for ii = 1:size(DTindex,'*')
            if varargin(DTindex(ii)).dt == 'd' then
                varargin(DTindex(ii)).dt = 1
            end 
        end
//------------------------------------------------------------------------------
//compare the time step data with discrete sampling time
        if size(timeData,'*') > 1 then// & size(timeData,'*') ~= 1 then
            tempData = 0
            for ii = 1:size(DTindex,'*')
                if varargin(DTindex(ii)).dt ~= timeData(2) & tempData == 0 then
                    error(msprintf(gettext("%s: Invalid time_step (start:time_step:end).\nIt must be equal to the sampling time of the discrete systems\n"),"step"))
                elseif varargin(DTindex(ii)).dt ~= timeData(2) & tempData ~= 0 then
                    error(msprintf(gettext("%s: Sampling time of all the discrete time systems must be equal.\n"),"step"))
                else
                    tempData = tempData +1
                end
            end
        end
    end
    
//------------------------------------------------------------------------------
// sorting out the unstable poles 
//rational(1x1,nxm)
//state-space(nxm)->change it to tf and find out the unstable poles
//apply above conditions on discrete and continuous time systems

//------------------------------------------------------------------------------
// if time vector or end time is given then find out that it is in range 

//------------------------------------------------------------------------------
// if time vector is not given then find out the optimal time 

//------------------------------------------------------------------------------
// If the above condition is not true then find the optimal time
//continuous time system
    optCTtime = []
    usCTtime = []
    if size(timeData,'*') == 0 & size(CTindex,'*') > 0 then
        for ii = 1:size(CTindex,'*')
            [usFlag tempData] = optimalCT(varargin(CTindex(ii)))
            if usFlag then
                usCTtime = [usCTtime tempData]
                isUnstable = usFlag
            else
                optCTtime = [optCTtime tempData]
            end
        end
        if size(usCTtime,'*') == 0 then
            optCTtime = max(optCTtime)
        else
            usCTtime = min(usCTtime)
        end
    end
//discrete time system
    optDTtime = []
    usDTtime = []
    if size(timeData,'*') == 0 & size(DTindex,'*') > 0 then
        for ii = 1:size(DTindex,'*')
            [usFlag tempData] = optimalDT(varargin(DTindex(ii)))
            if usFlag then
                usDTtime = [usDTtime tempData]
                isUnstable = usFlag
            else
                optDTtime = [optDTtime tempData]
            end
        end
        if size(usDTtime,'*') == 0 then
            optDTtime = max(optDTtime)
        else
            usDTtime = min(usDTtime)
        end
    end
// optimal time is max of discrete and continuous time
    if isUnstable then
        finalTime = min([usCTtime usDTtime])
    else
        finalTime = max([optCTtime optDTtime])
    end
//finalTime = [optCTtime optDTtime]
//finalTime = max(finalTime)
//disp('rum')
//disp(finalTime)

//------------------------------------------------------------------------------
// plot 
//------------------------------------------------------------------------------
//storing the subplot data 
    outPut = []
    inPut = []
    stateSpaceFlage = %F
    if size(CTindex,'*') ~= 0 then
        for ii = 1 : size(CTindex,'*')
            if typeof(varargin(CTindex(ii))) == 'state-space' | typeof(varargin(CTindex(ii))) == 'rational' & length(size(varargin(CTindex(ii)))) == 2 then
                stateSpaceFlage = %T
                tempData = size(varargin(CTindex(ii)))
                outPut = [outPut tempData(1)]
                inPut = [inPut tempData(2)]
            end
        end
    end
    if size(DTindex,'*') ~= 0 then
        for ii = 1:size(DTindex,'*') 
            if typeof(varargin(DTindex(ii))) == 'state-space' then
                stateSpaceFlage = %T 
                tempData = size(varargin(DTindex(ii)))
                outPut = [outPut tempData(1)]
                inPut = [inPut tempData(2)]
            end
        end
    end
//------------------------------------------------------------------------------
// arrange the subplot data
    if stateSpaceFlage then
        outPut = max(outPut)
        inPut = max(inPut)
    else
        outPut = 1
        inPut = 1
    end
//------------------------------------------------------------------------------
// ploting the continuous domain
//Collecting the step Data for continuous domain
    currentColor = 2
    if size(CTindex,'*') then
        // arranging the time
        if size(timeData,'*') > 1 then
            timeCT = timeData
        elseif size(timeData,'*') == 1 then
            timeCT = 0:timeData/1000:timeData
        elseif size(timeData,'*') == 0 then
            timeCT = 0:finalTime/1000:finalTime
        end
        //**********************************************************************
        CTyData = []
        CTsizeArray = []
        tempIndexData = 1
        txedIndex = []
        //storing the step respons data
        for ii = 1:size(CTindex,'*')
            [CTytemp CTsizeArrayTemp] = stepCT(varargin(CTindex(ii)),timeCT)
            if size(colorIndex,'*') then
                givenColorIndex = find(colorIndex == CTindex(ii)+1)
                if size(givenColorIndex,'*') then
                    colorData = varargin(colorIndex(givenColorIndex))
                else
                    colorData = []
                end
            else
                colorData = []
            end
            if size(colorData,"*") == 0 then
                colorData = currentColor
            end
            if plotFlag then
                tempColorIndex = CTplot(outPut,inPut,typeof(varargin(CTindex(ii))),...
                size(varargin(CTindex(ii))),CTytemp,timeCT,colorData)            
                currentColor = tempColorIndex + 1
            end
        end

    end
//------------------------------------------------------------------------------
// ploting the discrete domain
//Collecting the step Data for discrete domain
    currentColor = currentColor + 1
    if size(DTindex,'*') ~= 0 then
        for ii = 1:size(DTindex,'*')
            //(finalTime)
            //disp(varargin(DTindex(ii)).dt)
            if size(timeData,'*') > 1 then
                timeDT = timeData
            elseif size(timeData,'*') == 1 then
                timeDT = 0:varargin(DTindex(ii)).dt:timeData
            else
                timeDT = 0:varargin(DTindex(ii)).dt:finalTime
            end
            DTinput = ones(1,size(timeDT,'*'))
            DTyOutput = []
            tempDT = varargin(DTindex(ii))
            if typeof(tempDT) == 'state-space' then
                tempDT = ss2tf(tempDT)
            end
            pause
            tempDT = (matrix(tempDT',size(tempDT,'*'),1))'
            for jj = 1:size(varargin(DTindex(ii)),'*')
                if tempDT.num == 0 then
                    DTyOutput = [DTyOutput;zeros(1,size(timeDT,'*'))]
                else
                    disp('chhumma')
                    disp(DTinput)
                    disp(tempDT)
                    
                    tempYdata = flts(DTinput,tempDT(1,jj))
                    DTyOutput = [DTyOutput;tempYdata]
                end
            end
            DTsizeData = size(varargin(DTindex(ii)))
            DTcounter = 1
            if plotFlag then 
                if typeof(varargin(DTindex(ii))) == 'state-space' | typeof(varargin(DTindex(ii))) == 'rational' & length(size(varargin(DTindex(ii)))) == 2 then
                        for jj = 1: DTsizeData(1)
                            for kk = 1:DTsizeData(2)
                                subplot(outPut,inPut,DTcounter);plot2d2(timeDT,DTyOutput(DTcounter,:),currentColor)
                                DTcounter = DTcounter + 1
                                //currentColor = currentColor + 1
                            end
                        end
                else
                    for jj = 1:size(varargin(DTindex(ii)),'*')
                        subplot(outPut,inPut,1);plot2d2(timeDT,DTyOutput(jj,:),currentColor)
                        currentColor = currentColor + 1
                    end
                end
                currentColor = currentColor + 1
            end
        end
    end
//------------------------------------------------------------------------------
//configuration of the plot     
    if plotFlag then
        tempCount = 1
        for ii = 1:inPut:outPut*inPut
            outPutStr = "To: Out("+string(tempCount)+")"
            subplot(outPut,inPut,ii);xtitle('','',outPutStr)
            tempCount = tempCount + 1
        end
        for ii = 1:inPut
            inPutStr = "From: In("+string(ii)+")"
            subplot(outPut,inPut,ii);xtitle(inPutStr)
        end
        f = gcf()
        
        f.figure_name = "Step"
        f.info_message = "time(second)"
        //f.children = "time"
        disp(f)
        //xtitle('','time')
    end
    if lhs ==1 & ~plotFlag then
        if size(CTindex,'*') == 1 & size(DTindex,'*') == 0 then
            varargout(1) = timeCT
        else
            varargout(1) = timeDT
        end
    elseif lhs == 2 & ~plotFlag then
        if size(CTindex,'*') == 1 & size(DTindex,'*') == 0 then
            varargout(2) = timeCT
            varargout(1) = CTytemp
        elseif size(CTindex,'*') == 0 & size(DTindex,'*') == 1 then
            varargout(2) = timeDT
            varargout(1) = DTyOutput
        end
    elseif lhs == 1 then
        varargout(1) = []
    end
    
endfunction






//------------------------------------------------------------------------------
//optimal continuous time
function [usFlag, outCT] = optimalCT(CTin)
    if typeof(CTin) == 'state-space' then
        CTin = ss2tf(CTin)
    end
    CTin = matrix(CTin,1,size(CTin,'*'))
    t = []
    rhsPole = []
    rhsFlag = %f
    for ii = 1:size(CTin,'*')
        //roots of the transfer function
        tempRoot = clean(roots(CTin.den(1,ii)))
        [sorted index] = gsort((real(tempRoot)))
        tempRoot = tempRoot(index)
        if CTin.num == 0 then
        else
        // RHS
            if real(tempRoot(1)) > 0 then
               //unstable
               rhsFlag = %T
               tempTime = 26*log(10)/real(tempRoot(1))
               rhsPole = [rhsPole tempTime]
            elseif real(tempRoot(1)) == 0 & imag(tempRoot(1)) == 0 then
               //origin
               tempTime = find(tempRoot == 0)
               t = [t length(tempTime)*100]
            elseif real(tempRoot(1)) == 0 & (imag(tempRoot(1))) ~= 0 then
               //imaginary axis
               t = [t abs(tempRoot(1))*100]
            elseif real(tempRoot(1)) <= 0 then //& imag(tempRoot(1)) ~= 0 |
               //underdamped
                //critical damped
                //over damped
               t = [t abs(10/real(tempRoot(1)))]
            end
        end
    end
    if rhsFlag then
        outCT = round(min(rhsPole))
    else
        outCT = max(t)
    end
    usFlag = rhsFlag
endfunction

//------------------------------------------------------------------------------
// optimal discrete time systems
function [usFlag, outDT] = optimalDT(DTin)
    if typeof(DTin) == 'state-space' then
        DTin = ss2tf(DTin)
    end
    DTin = matrix(DTin,1,size(DTin,'*'))
    n = []
    OverUnitFlag = %F
    usData = [] 
    for ii =1:size(DTin,'*')
        tempRoot = clean(roots(DTin.den(1,ii)))
        [sorted index] = gsort(abs(real(tempRoot)))
        tempRoot = tempRoot(index)
        if round(abs(real(tempRoot(1))))-1 > 0 then
            temp = 26/log10(abs(real(tempRoot(1))))
            usData = [usData temp*DTin.dt]
            OverUnitFlag = %T
        elseif (abs(real(tempRoot(1))))-1 < 0 then
            n = [n abs(real(tempRoot(1)))*100]
        elseif round(abs(real(tempRoot(1))))-1 == 0 then
            n = [n abs(real(tempRoot(1)))*1000] 
        end
    end
    if OverUnitFlag then
        outDT = round(min(usData))
    else
        outDT = round(n)
    end
    usFlag = OverUnitFlag
endfunction

//------------------------------------------------------------------------------
//Collection of the step response for the continuous domain
function [CTyTemp ,CTsizeArray]=stepCT(CTdata,timeData)
    if typeof(CTdata) == 'state-space' then
        CTdata = ss2tf(CTdata)
    end
    CTsizeArray = size(CTdata,'*')
    tempCTy = []
    CTdata = (matrix(CTdata',1,CTsizeArray))
    for ii = 1:CTsizeArray
        if CTdata(1,ii).num ~= 0 then
            tempCTy = [tempCTy;csim('step',timeData,CTdata(1,ii))]
        else
            tempCTy = [tempCTy;zeros(1,length(timeData))]
        end
    end
    CTyTemp = tempCTy
endfunction
//------------------------------------------------------------------------------
//continuous plot
function tempIndex = CTplot(varargin)
    tempData = 1
    tempYdata = varargin(5)
    //(typeof(varargin($)))
    if varargin(3) == 'state-space' | varargin(3) == 'rational' & length(varargin(4)) == 2 then
        if typeof(varargin($)) == 'string' then
            for ii = 1:varargin(4)(1)
                for jj = 1:varargin(4)(2)
                    subplot(varargin(1),varargin(2),tempData);plot(varargin(6),tempYdata(tempData,:),varargin($))
                    tempData = tempData + 1
                    xgrid()
                end
            end
            tempIndex = 0
        elseif typeof(varargin($)) == 'constant' then
            colorData = varargin($)
            for ii = 1:varargin(4)(1)
                for jj = 1:varargin(4)(2)
                    subplot(varargin(1),varargin(2),tempData);plot(varargin(6),tempYdata(tempData,:))
                    tempData = tempData + 1
                    last_line = gce()
                    last_line.children.foreground = colorData
                    xgrid()
                end
            end
            tempIndex = colorData+1
        end
    else
        if typeof(varargin($)) == 'string' then
            xgrid()
            for ii = 1:size(varargin(5),"r")
                subplot(varargin(1),varargin(2),1);plot(varargin(6),tempYdata(tempData,:),varargin($))
                tempData = tempData + 1
            end
            tempIndex = 0
        elseif typeof(varargin($)) == 'constant' then
            xgrid()
            for ii = 1:size(varargin(5),"r")
                    subplot(varargin(1),varargin(2),1);plot(varargin(6),tempYdata(tempData,:))
                    tempData = tempData + 1
                    last_line = gce()
                    last_line.children.foreground = colorData+1
                    colorData = colorData + 1
            end
            tempIndex = colorData + 1
        end
    end
    
endfunction
//-------------------------------------------------------------------------------
        
////        //**********************************************************************
////        //ploting the step respons for continuous domain
////        for ii = 1:size(CTindex,'*')
////            //data tranfer for the continuous domain plot
////            //txed data are
////            //subplot number, time,ydata,size,type, color,current color index
////            //disp(size(colorIndex,'*'))
////            if size(colorIndex,'*') then
////                givenColorIndex = find(colorIndex == CTindex(ii)+1)
////                if size(givenColorIndex,'*') then
////                    colorData = varargin(colorIndex(givenColorIndex))
////                else
////                    colorData = []
////                end
////            else
////                colorData = []
////            end
////            //disp(CTsizeArray(ii))
////            if CTsizeArray(ii) == 1 then
////                txedIndex = tempIndexData
////                tempIndexData = tempIndexData+CTsizeArray(ii)
////            else
////                txedIndex = [tempIndexData:tempIndexData+CTsizeArray(ii)-1]
////                tempIndexData = tempIndexData+CTsizeArray(ii)
////            end
////            
////            //disp(txedIndex)
////            tempColorIndex = CTplot(outPut,inPut,typeof(varargin(CTindex(ii))),...
////            size(varargin(CTindex(ii))),CTsizeArray(ii),CTyData(txedIndex,:),timeCT,...//CTdataAccess:CTdataAccess+CTsizeArray(ii)
////            colorData,currentColor)
////            currentColor = currentColor+tempColorIndex
////            //subplot(1,1,1);plot(timeCT,CTyData(ii,:))
////
//        end

////            tempColorIndex = CTplot(outPut,inPut,typeof(varargin(CTindex(ii))),...
////            size(varargin(CTindex(ii))),CTytemp,timeCT,colorData)
////    disp(varargin(1))
////    disp(varargin(2))


//-----------------------------------------------------------------------------
//        temp = size(find(clean(roots(CTin(1,ii).den)) == 0),'*')
//        if temp == 0 & CTin(1,ii).num ~= 0 then
//            tempo = size(find(real(clean(roots(CTin(1,ii).den))) == 0),'*')
//            if tempo == 0 then
//                disp('underdamped')
//                //checking that the dominant root is underdamped
//                rootData = clean(roots(CTin(1,ii).den))
//                [sorted index] = gsort(real(rootData))
//                rootData = rootData(index)
//                //disp(real(rootData(1)))
//                finalValue = abs(horner(CTin(1,ii),%eps))
//                //disp(finalValue)
//                realRoots = abs(real(rootData(1))) 
//                tempT = realRoots//abs(realRoots/log(finalValue))
//                //disp(tempT)
//                //if imag(rootData(1)) == 0 & real(rootData(1)) ~= 0 then
//                    // dominant roots is critically damped,overdamped
//                    t = [t round(10/tempT)]
//                //else
//                    //dominant roots is underdamped
//                    //t = [t round(10/tempT)]
//                //end
//            else
//                //set the time according to repeated roots on imaginary axis
//                disp('imaginary')
//                t = [t max(imag(roots(CTin(1,ii).den)))*100]
//            end
//        else
//            // set the time according to number of poles at origin
//            disp('origin')
//            t = [t temp*50]
//        end
