    //Example
    //https://in.mathworks.com/help/ident/examples/estimating-simple-models-from-real-laboratory-process-data.html
    //run the following command in Matlab
    //load dryer2;
    //dryerData = [y2,u2];
    //save('dryerData','dryerData')
    //-------------------------------------------------------------------------------------------------------------
    
    //Setting up Data for Analysis
    loadmatfile('dryerData.mat')
    dry = iddata(dryerData(:,1),dryerData(:,2),0.08);
    Get(dry)
    ze = iddata(dry.OutputData(1:300),dry.InputData(1:300),0.08)
    
    //Preprocessing the Data
    figure();clf();
    t = (200:300)*0.08;
    subplot(2,1,1);plot(t,dry.OutputData(200:300));xgrid();xtitle('Thermocouple Voltage')
    subplot(2,1,2);plot2d2(t,dry.InputData(200:300),2);xgrid();xtitle('Heater Voltage','Time(seconds)')
    
    ze.OutputData = detrend(ze.OutputData);
    ze.InputData = detrend(ze.InputData);
    figure();clf();
    t = (200:300)*0.08;
    subplot(2,1,1);plot(t,dry.OutputData(200:300));xgrid();xtitle('Thermocouple Voltage')
    subplot(2,1,2);plot2d2(t,dry.InputData(200:300),2);xgrid();xtitle('Heater Voltage','Time(seconds)')
    
    //Estimating Models with a Prescribed Structure
    m2 = arx(ze,[2 2 3]);
    m2
    
    //Validating the Estimated Model to Experimental Output
    zv = iddata(dry.OutputData(800:900),dry.InputData(800:900),0.08);   // select an independent data set for validation
    zv.OutputData = detrend(zv.OutputData);    // preprocess the validation data
    zv.InputData = detrend(zv.InputData);
    // In matlab
    // opt = compareOptions('InitialCondition','z');
    //compare(zv,m1,opt);     <- use following command
    figure();clf()
    compare(zv,m2)
    gs = spa(ze);
    
    z = poly(0,'z');
    difData = z^(length(m2.b)-length(m2.a));
    numData = m2.b(length(m2.b):-1:1);numData = poly(numData,'z','coeff');
    denData = m2.a(length(m2.a):-1:1);denData = poly(denData,'z','coeff');
    m2D = syslin(0.08,numData/denData)/difData;
    //run following command in Matlab 
    //bodeplot(m2,'r',w,opt); 
    figure();clf()
    bode(m2D)
