//Examples
//https://in.mathworks.com/help/ident/examples/two-tank-system-single-input-single-output-nonlinear-arx-and-hammerstein-wiener-models.html#responsive_offcanvas
//load twotankdata
//twoTankData = [y,u];
//save('twoTankData','twoTankData')
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
    //The Input-Output Data Set
    loadmatfile('twoTankData.mat')
    z = iddata(twoTankData(:,1),twoTankData(:,2),0.2)
    
    //Plotting the Data
    figure();clf();
    t = (0:(size(twoTankData,'r')-1))*0.2;
    subplot(2,1,1);plot(t,z.OutputData);xgrid();xtitle('y1')
    subplot(2,1,2);plot2d2(t,z.InputData,2);xgrid();xtitle('u1','time (seconds)')
    
    //Splitting the Data
    z1 = iddata(z.OutputData(1:1000),z.InputData(1:1000),0.2); 
    z2 = iddata(z.OutputData(1001:2000),z.InputData(1001:2000),0.2); 
    z3 = iddata(z.OutputData(2001:3000),z.InputData(2001:3000),0.2);
    
    //Evaluating Estimated Models
    mlin = arx(z1,[5 1 3]);
    figure();clf();
    //in Matlab use the following command
    //opt = compareOptions('InitialCondition','z');
    //compare(z1,mlin,opt)
    compare(z1,mlin)
