// Copyright (C) 2017 - IIT Bombay - FOSSEE
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
// Organization: FOSSEE, IIT Bombay
// Email: toolbox@scilab.in

function AVRPWM1SetDuty(output_pin,duty,Top_Value)
//Function to Set Duty cycle of PWM Output generated by Timer1 at OC1A or OC1B pin.    
//Parameters
//      ouput_pin: integer, 0 (for OC1A) or 1 (for OC1B)
//
//      duty:        It holds an integer value from 0 to 100 which sets the percentage of time for which signal is active.
//
//      Top_Value:   It holds an integer value from 0 to 65535.This value sets the Top value of the counter TCNT1 i.e ICR.(for more info refer datasheet)
//
//Description
//      Each Micro controller has PWM output pins which can generate varying voltage
//      from 0V-5V.This function Sets the duty cycle of output PWM signal.Also this function 
//      decides the Top Vale of TCNT1 and the output pin to output PWM signal.
//
// This is curretly dummy function. It provides no functionality but is required 
// for providing support for generating C code for AVR.
//
//Example
//      AVRPWM1SetDuty(0,50,40000); //This function will produce PWM signal of 50% duty cycle on OC1A pin and TCNT1 will reset at 40000 instead at 65535.
//See also
//     AVRPWM1Setup
//
//Authors
//     Ashish Kamble
//

if(output_pin>=2) then
disp("Error : Invalid input argument ''output_pin'' in AVRPWM1SetDuty function.");
end
if(duty>100) then 
disp("Error : Invalid input argument ''duty'' in AVRPWM1SetDuty function.");
end
if(Top_Value>65535) then
disp("Error : Invalid input argument ''Top_Value'' in AVRPWM1Setduty function.");
end
endfunction
