// Copyright (C) 2017 - IIT Bombay - FOSSEE
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
// Organization: FOSSEE, IIT Bombay
// Email: toolbox@scilab.in

function AVRPWM2SetDuty(duty)
//Function to Set Duty cycle of PWM Output generated by Timer2 at OC2 pin.    
//
//Parameters
//	duty : It holds an integer value from 0 to 100 which sets the percentage of time for which signal is active.
//
//Description
//      Each Micro controller has PWM output pins which can generate varying voltage
//      from 0V-5V.In this function by varying the duty cycle, varying voltage can be 
//      produced.
//
// This is curretly dummy function. It provides no functionality but is required 
// for providing support for generating C code for AVR.
//
//Example
//      AVRPWM2SetDuty(50); //Produces 2.5V at OC2 pin
//      AVRPWM2SetDuty(0); //Produces 0V at OC2 pin
//
//See also
//      AVRPWM2Setup
//
//Authors
//      Ashish Kamble
//

if(duty>100) then 
disp("Error : Invalid input argument ''duty'' in AVRPWM2SetDuty function.");
end
endfunction
