// Copyright (C) 2017 - IIT Bombay - FOSSEE
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
// Author: Jorawar Singh
// Organization: FOSSEE, IIT Bombay
// Email: toolbox@scilab.in

RPI_Directories = [ "Digital", ...
                "gertBoard", ...
                "I2C", ...
                "Interrupt", ...
                "lcd", ...
                "lcd128x64", ...
                "mcp", ...
                "Misc", ...
                "pcf", ...
                "piGlow", ...
                "pinMap", ...
                "pwm", ...
                "Serial", ...
                "Setup", ...
                "Shift", ...
                "Soft", ...
                "SPI", ...
                "Timing"];
                
RPI_path_buildmacros = get_absolute_file_path("buildmacros.sce");

for H=1:size(RPI_Directories,"*")
  myfile = RPI_path_buildmacros + filesep() + RPI_Directories(H) + filesep() + "buildmacros.sce";
  if isfile(myfile) then
    exec(myfile);
  end
end

clear RPI_path_buildmacros;

function buildmacros()
    macros_path = get_absolute_file_path("buildmacros.sce");
    tbx_build_macros(TOOLBOX_NAME, macros_path);
    clear tbx_build_macros;
endfunction

buildmacros();
clear buildmacros;
