/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008-2008 - INRIA - Allan SIMON
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "conj.h"
#include <assert.h>
#include <stdio.h>
#include <math.h>
#define SIZE 100
#define FMATRIX  {0.0373321f,0.4293466f,0.3157233f,0.3682477f,0.1458774f,0.6768379f,0.5261979f,0.4003626f,\
0.0029108f,0.3068181f,0.7902694f,0.9577950f,0.6689271f,0.2929616f,0.8223899f,0.0179846f,\
0.8710701f,0.3181024f,0.5724473f,0.5738658f,0.3492018f,0.7067298f,0.3599201f,0.4052311f,\
0.6140811f,0.6524047f,0.0295171f,0.5668896f,0.7114017f,0.4588491f,0.4720517f,0.0623731f,\
0.0854401f,0.0134564f,0.3543002f,0.6719395f,0.1360619f,0.2119744f,0.4015942f,0.4036219f,\
0.5628382f,0.5531093f,0.0768984f,0.5360758f,0.0900212f,0.6218026f,0.0001215f,0.7219727f,\
0.6661293f,0.6799288f,0.9514125f,0.1206901f,0.7318910f,0.0831662f,0.8021909f,0.0290492f,\
0.6502991f,0.7427882f,0.2176611f,0.9788486f,0.8925237f,0.3511275f,0.4745619f,0.7699462f,\
0.0734342f,0.5894619f,0.2378993f,0.4076361f,0.4304818f,0.0370717f,0.6404148f,0.4130743f,\
0.8396902f,0.0002195f,0.5085374f,0.4754997f,0.9625065f,0.9798011f,0.0785698f,0.9150032f,\
0.6172610f,0.9964195f,0.0468599f,0.9245926f,0.9689865f,0.4916290f,0.2977053f,0.0603055f,\
0.6313472f,0.0241030f,0.1527438f,0.9481178f,0.2744266f,0.4794727f,0.4855768f,0.6764004f,\
0.8321250f,0.0125876f,0.5453780f,0.8426717f}
#define DMATRIX {0.70964269945397973061,0.6610225578770041465759,0.7252350724302232265472,\
0.510143497958779335022,0.2824866441078484058380,0.2214915128424763679504,\
0.5767575385980308055878,0.7048253491520881652832,0.5607945644296705722809,\
0.3628880484029650688171,0.3088326244615018367767,0.9813414867967367172241,\
0.7428482254035770893097,0.1616391474381089210510,0.3652521963231265544891,\
0.3835070468485355377197,0.1169181005097925662994,0.8911246126517653465271,\
0.0634272000752389431000,0.6263941843062639236450,0.6807702076621353626251,\
0.2588596837595105171204,0.4394804346375167369843,0.8598818778991699218750,\
0.5482823201455175876617,0.8135995296761393547058,0.4898237003944814205170,\
0.0240026097744703292847,0.7369195525534451007843,0.2411156157031655311584,\
0.1529693226329982280731,0.2648359201848506927490,0.4298193217255175113678,\
0.7673939457163214683533,0.8753260499797761440277,0.3796988371759653091431,\
0.3062356826849281787872,0.3880051793530583381653,0.1047293278388679027557,\
0.7603831812739372253418,0.0340930395759642124176,0.1423966242000460624695,\
0.5554559468291699886322,0.8031897451728582382202,0.5183992316015064716339,\
0.1518561029806733131409,0.5884730662219226360321,0.2545093484222888946533,\
0.9992679939605295658112,0.6398976957425475120544,0.5506716123782098293304,\
0.4607007671147584915161,0.5933007937856018543243,0.6538193570449948310852,\
0.4168340521864593029022,0.9910155385732650756836,0.3720780410803854465485,\
0.7061824081465601921082,0.5780865414999425411224,0.602319641038775444031,\
0.5715096746571362018585,0.0549629041925072669983,0.1205854485742747784,\
0.0143620483577251434326,0.0257951230742037296295,0.8411248764023184776306,\
0.4381882525049149990082,0.4643401596695184707642,0.4197426405735313892365,\
0.8023654492571949958801,0.5228588166646659374237,0.5095121040940284729004,\
0.4531980180181562900543,0.7817818326875567436218,0.776557037141174077988,\
0.0466059204190969467163,0.5113326688297092914581,0.7502101892605423927307,\
0.6883628661744296550751,0.0167756117880344390869,0.9345410899259150028229,\
0.5609863763675093650818,0.2205847105942666530609,0.7648540753871202468872,\
0.4816976976580917835236,0.1558785634115338325500,0.2476022052578628063202,\
0.5216529071331024169922,0.0805230387486517429352,0.4409417239949107170105,\
0.8911933614872395992279,0.9780590813606977462769,0.4588093762286007404327,\
0.5510440031066536903381,0.0960960905067622661591,0.4196785055100917816162,\
0.7502556503750383853912,0.7218149593099951744080,0.2895541018806397914886,\
0.3907764498144388198853}


static void cconjsTest ( void )
{
    float realin = 0.126244857f;
    float imagin = -0.47864959f;
    floatComplex in = FloatComplex ( realin , imagin  );

    assert ( fabs ( creals ( in  ) - realin ) / fabs( creals (in)) < 1e-06 );
    assert ( fabs ( cimags ( in  ) - imagin ) / fabs( cimags (in)) < 1e-06 );
}


static void cconjaTest ( void )
{
    int i = 0 ;
    float tin [] = FMATRIX ;
    floatComplex* in = FloatComplexMatrix ( tin , tin , SIZE );
    floatComplex out[100] ;

    cconja ( in , SIZE , out ) ;

    for ( i = 0 ; i < SIZE ; i++ )
    {
    assert ( fabs ( creals ( in[i] ) - tin[i] ) / fabs( creals (in[i])) < 1e-06 );
    assert ( fabs ( cimags ( in[i] ) - tin[i] ) / fabs( cimags (in[i])) < 1e-06 );
    }

}

static void zconjsTest ( void )
{
    double realin = 0.126244857788445;
    double imagin = -0.47864959451267;
    doubleComplex in = DoubleComplex ( realin , imagin  );

    assert ( fabs ( zreals ( in  ) - realin ) / fabs( zreals (in)) < 1e-16 );
    assert ( fabs ( zimags ( in  ) - imagin ) / fabs( zimags (in)) < 1e-16 );
}

static void zconjaTest ( void )
{
    int i = 0 ;
    double tin [] = DMATRIX ;
    doubleComplex* in = DoubleComplexMatrix ( tin , tin , SIZE );
    doubleComplex out[100] ;

    zconja ( in , SIZE , out ) ;

    for ( i = 0 ; i < SIZE ; i++ )
    {
    assert ( fabs ( zreals ( in[i] ) - tin[i] ) / fabs( zreals (in[i])) < 1e-16 );
    assert ( fabs ( zimags ( in[i] ) - tin[i] ) / fabs( zimags (in[i])) < 1e-16 );
    }

}

static int testConj   (void) {

  printf("\n>>>> Float a Tests\n");
  cconjsTest();
  cconjaTest();
printf("\t>>>> Double a Tests\n");
  zconjsTest();
  zconjaTest();


  return 0;
}


int main(void) {
  assert(testConj() == 0);
  return 0;
}
