/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008-2008 - INRIA - Bruno JOFRET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testAsinh.h"



#define SOURCE {-1.3576117896733277401466f,-1.7637832035201410629810f,0.3855566139299755334946f,\
-0.2160798468986061537933f,0.5079016244365412990902f,-0.6713405437771273742698f,\
1.2405146112769958044453f,1.3996914808133518182132f,2.455810932856137718261f,\
-0.140780207215658148545f,-0.4702849878182233100965f,0.0273321471208497618344f,\
0.1272959744763040301763f,1.0077609385751984394375f,-0.5992823608151862657678f,\
-1.4909735993420030197854f,1.1850328323549159659223f,-0.7532372700108580509948f,\
0.1544844959811866313970f,-0.4395251247591652199453f,-0.1710077835697096926282f,\
-0.0020392103157046703732f,2.3911285878389949566269f,-1.8171171150936700211531f,\
-0.7159791420443786247318f,0.5100070355081758322058f,-0.9023845512384770506387f,\
0.1404573536528139765522f,1.101925188407546940539f,-0.0755748286838698046797f,\
0.0052019860396882644168f,-0.3525317421211751067744f,0.9599782396584397581307f,\
-0.3373393328184763340083f,-0.9424787821879185845120f,1.107342433121214275715f,\
0.5275760618563184456420f,2.2874014544326271014540f,0.8431549305721607323605f,\
-0.1180124731434434998123f,-0.4202553394312918411124f,-1.114616954771672663327f,\
0.7423526085481280123446f,-0.8110912540737037490501f,-0.2279425085104251347268f,\
0.6450672141930872127702f,0.7812946955887702937815f,1.4559939295961445981931f,\
1.4808632601102580395036f,-0.0561674797508281767322f,-0.6499637724416639228409f,\
0.9406577697059905762700f,0.4408659857477613686072f,1.0630757257539220628217f,\
-1.3783233641019425608221f,-0.3062086297728683903507f,0.3570701509900506276374f,\
0.2722352561686949279363f,-0.8234027247256571202527f,-0.5990920922251514735279f,\
0.8126089186562406307957f,-0.9202541957145593531919f,0.4637689483065319806521f,\
2.7285780311422769273122f,-0.5523000528063060077244f,0.5645499540468182919639f,\
-0.1966239792749471526623f,0.3232076144184721222530f,0.2044915219084416369011f,\
0.9122595139735795166658f,1.32862804461268768641f,-0.3933121244849541731092f,\
0.6800596076198115458311f,-0.0390966465388340317366f,0.4460664717379928534413f,\
0.0466968662605830517331f,-1.159097013642337747896f,-0.1516000867442619526315f,\
1.099835547132880231302f,-1.8591997482220850024248f,-1.5859733492347323213778f,\
-2.3518422239705527587716f,-0.0363309315202365243347f,-0.3671077430846361733252f,\
1.4974841041542252817464f,0.1166082461631383904166f,0.6150562435701190100446f,\
-1.1854669210396810985486f,0.3562903039222897749738f,0.3468046496992864269338f,\
-0.7767949783190361001672f,-0.0388605946733660209680f,0.4658948000641440767566f,\
2.5397452836287333077792f,-1.6499955625089919308834f,-1.730408375709416413102f,\
-0.5118965544481819396339f,0.6229106301535243250811f,1.2541834743916775440908f,\
-0.4242067654129669240781f,-2.4609745338396713520979f,-0.5875679117078018709464f,\
0.0525256277866840218249f,-0.0221901005868065138993f,0.0047340660621973179242f,\
0.5954335288237887491292f,1.240326181995874410546f,-0.4474314847009220885710f,\
0.309985603496633732590f,0.1897272751476858920761f,-0.5041309171227571495066f,\
-1.0407049076417729249755f,-0.8790182225827031237131f,-0.8241442015820352740008f,\
0.0114520840633361691702f,-0.8375012162452729613804f,1.5044689875616372720657f,\
-1.4872169103117691690841f,-0.9491620445763213620438f,-0.4714572242020408365804f,\
-0.9944436112957297790871f,-0.7897744853013518584461f,-1.9610605179993771951530f,\
-0.5551411828413486126976f,-0.1498033190111577317438f,1.049612455441040648196f,\
-1.873247408264758551155f,-1.7768646550852811305532f,2.055125969134249608317f,\
0.4181799324473139956027f,0.4756981765178688870144f,-0.0497090050304667893655f,\
-0.8254170186481527560218f,0.3315212467523889205978f,-0.1049083295446031904863f,\
0.9436361823785577307433f,-0.4297495677869329622212f,0.6041720693587251389545f,\
-0.5126921017648137235412f,0.8253623930867394209443f,-0.5636867633411185574133f,\
1.4780035136607696522049f,-0.1150898513104453707578f,-0.0895959753888824761425f,\
-0.1719733530741588689583f,0.2269131790250100699780f,2.0342102181126362481223f,\
-0.0976186373893909720145f,-1.0193857468205604899f,0.778026114056752038373f,\
0.3469309321844699645077f,-0.2119385547567329830532f,0.1122013143743656737872f,\
0.5130455426994967593757f,-0.9836962738165191399986f,-1.8662473753394661635241f,\
0.5046191490309642757595f,0.5397589965174257597980f,0.1495290449776452701425f,\
-1.0010126697848658050560f,-1.231087303316227510308f,0.493771591129457787517f,\
0.0084749296034232757258f,0.6528794554325030308206f,1.3165434517533367575481f,\
-0.7644706245855447113158f,1.60959294894722515501f,-0.3945002118117288958388f,\
-1.7397191133485980785167f,0.7283944071784652640744f,-0.8252534213629215686936f,\
0.1067480143242338502807f,1.4303021806407054672405f,-0.9653188502218088551388f,\
0.3473141482678416824825f,1.3246017895509272221943f,2.2493951812296155701176f,\
-0.6569708783346918101742f,-0.321524642114760117462f,0.6051546744959480639281f,\
0.3028414522677088660529f,-0.6449695892069078340114f,0.3426130327302095435194f,\
-0.9643932135296735541630f,1.3325612893853038265490f,-1.628074335418207230219f,\
0.7075076309451185929689f,1.0853008279162978944044f,-2.3506278976788554935240f,\
-0.1463993258475799474905f,-1.0813242242905494183702f,0.8848173893719444293993f,\
-0.8759582027327027509145f,-0.8344888331049786778237f,-1.0485734628076319729928f,\
1.9962933549994803517080f,1.2493174700563109968954f,1.1394362749053514871633f,\
-0.2197402489428784411185f,0.3152457615995896134109f}

#define RESULT {-1.1130949556588403126511f,-1.3327159168755193796585f,0.3765918165954149632313f,\
-0.2144327449409605401698f,0.4882680607211341006213f,-0.6290298228269889380115f,\
1.0416537998862092084806f,1.1378027100741174848508f,1.6306935238556961031975f,\
-0.1403192842222721059553f,-0.4544772654936784506141f,0.0273287452012760077869f,\
0.1269546678262620797994f,0.8868507654832032960357f,-0.568209430801213888351f,\
-1.1897458189645284676317f,1.0063560088725012064970f,-0.6957349846601869058915f,\
0.1538765289352577170234f,-0.4264787556420423508818f,-0.1701850823931514988807f,\
-0.0020392089024058542880f,1.6060204471410550741695f,-1.3587234662009097796442f,\
-0.6657080515933866404765f,0.4901444289074484705893f,-0.8106383081775411225678f,\
0.1399995760847499992607f,0.9516413314489057251322f,-0.0755030713336432846017f,\
0.0052019625784457792020f,-0.3456102163306026819889f,0.8527889195091039598040f,\
-0.3312482849825826303203f,-0.8401095674014050773692f,0.9552769725934540101520f,\
0.5057396137890651788283f,1.5652435713544583517631f,0.7660130911978242362892f,\
-0.1177402502570575049123f,-0.4087756154845550438104f,-0.9601436921836913329642f,\
0.6870180358136419584980f,-0.7413056602559416896625f,-0.2260133834402236752137f,\
0.607083791196235011967f,0.7179951440904949189203f,1.1701025225825925080159f,\
1.1841009702891132082669f,-0.0561379888707583402097f,-0.6111939387463327655325f,\
0.8387837653657870262691f,0.4277059773372764994726f,0.9252791007143230661569f,\
-1.1253178411086610655f,-0.3016147291750726489035f,0.3498873875038394642978f,\
0.2689800399453179946541f,-0.7508385861915640724362f,-0.568046218336308084140f,\
0.7424839156827229835756f,-0.8238461490952974086710f,0.4485733597383650406165f,\
1.7289314850929364819621f,-0.5274948117440469985695f,0.5381900831525847639369f,\
-0.1953785803896550821168f,0.3178295637778837390286f,0.2030924952508830483300f,\
0.8179516300830952379997f,1.0957859238613814056862f,-0.3838186466908449778757f,\
0.6362542602331872076959f,-0.0390866932016993157140f,0.4324599635687117471505f,\
0.0466799117153936446445f,-0.9895220015504287980335f,-0.1510253177999459628378f,\
0.9502363023238964423456f,-1.3788344661100282451116f,-1.2415257056941875202227f,\
-1.5907556842186492129798f,-0.0363229438428324669097f,-0.3593253093499745309813f,\
1.1933668386250828596928f,0.1163455870775610828671f,0.5816925710627691703536f,\
-1.0066359311257613295965f,0.3491528652755562234233f,0.3402040976525141924292f,\
-0.7144454627768908050456f,-0.0388508204533765666433f,0.4505011238681072560652f,\
1.6618918653106427019139f,-1.2751867809374948237178f,-1.3161363888578068159774f,\
-0.4918270306483571441269f,0.5883710719531183297448f,1.0502037442465796956981f,\
-0.4124158523209305871049f,-1.6326391191927918100646f,-0.5581352790789477769096f,\
0.0525015052004256660423f,-0.0221882799205271458165f,0.0047340483795489029725f,\
0.5649052397488373289391f,1.0415355372390291410767f,-0.4337062598861871065559f,\
0.3052242689715726209343f,0.1886070763157441099178f,-0.4849035737297955339642f,\
-0.9098654196250280934422f,-0.7931897365608786554247f,-0.7514108860522482613575f,\
0.0114518337541998777018f,-0.7616847132530191188948f,1.1972396117455856856537f,\
-1.1876514534079536389299f,-0.8449650527155313506356f,-0.4555378112663634460056f,\
-0.8774391641368382011024f,-0.7246635421278604383133f,-1.4260843463597587810199f,\
-0.5299803397861506670807f,-0.1492486124002971037417f,0.9160234338985321356219f,\
-1.3854693118499961101975f,-1.339149741178953689769f,1.4680202081995989971119f,\
0.4068615933419172381313f,0.4593706772145678129959f,-0.0496885560579486892929f,\
-0.7523928088748154108245f,0.3257305872841815830299f,-0.1047168437798993573251f,\
0.8409515953244546260237f,-0.4175134246305884921924f,0.5723991247141133609233f,\
-0.4925350737504667897326f,0.7523506802368506996004f,-0.5374382677208087155662f,\
1.1824994989469264083937f,-0.1148372801243118385139f,-0.0894765353119480744137f,\
-0.1711367593250398000393f,0.2250096841326320595833f,1.458830901005770064316f,\
-0.0974642573471812823094f,-0.8950151622701945086646f,0.7154174354590427942213f,\
0.3403234064876564657354f,-0.2103831526165375054305f,0.1119672185619183107930f,\
0.4928495654965970862449f,-0.8697979955142227659337f,-1.382167978700230337452f,\
0.4853394960873701480253f,0.5164877528407616491535f,0.1489773595696585739567f,\
-0.8820894714376154022162f,-1.0357236173571910953228f,0.4756340389263381540630f,\
0.0084748281555349427863f,0.6136369862616236625641f,1.0884976091419886756739f,\
-0.7046834979102297724651f,1.254056645766540967202f,-0.3849240656020492257205f,\
-1.3207856959376931271777f,0.6757730196964429891793f,-0.7522666350656633804661f,\
0.1065463121770779120201f,1.155469512029384748786f,-0.8566364746899163273852f,\
0.3406854318087456645614f,1.0933623617966952146219f,1.5499122891284196068540f,\
-0.6170596901911918896744f,-0.3162277642902040497574f,0.5732399668068761666717f,\
0.2983935984890606074593f,-0.6070017519078403367416f,0.3362413129909137543549f,\
-0.8559703502467290725519f,1.0981489764525824703867f,-1.2637694566754069658288f,\
0.6588062099967662010869f,0.9404229224232689698937f,-1.590280419973736147909f,\
-0.1458813492114517662568f,-0.9377256428290303702511f,0.7975391112088442424621f,\
-0.7908896752603351565369f,-0.7593735645090678998415f,-0.9153065625835585805703f,\
1.441976583204267914340f,1.0471665685842834747632f,0.9766162941953494547320f,\
-0.2180092160957680658129f,0.3102448153202543856821f}


#define CSOURCER {0.1344153599005591392945f,-1.5506135890216410366804f,-0.6851077106999041710367f,\
0.4218254137797516900577f,0.4563186792784946765877f,-0.0065657292828231895304f,\
-1.4909053660893785142605f,0.3020078702400747494572f,0.9932063361099687792688f,\
-0.4433136654301204071515f,-1.2230912696221460933543f,-0.4536074652511654647924f,\
-0.391728395210721336284f,-1.0754644749418362792426f,-0.3220075728643138068819f,\
-1.8561721663709394025688f,0.9166361449615868517427f,-0.4865676280317013935317f,\
-0.0798825634299456799337f,0.7227932226211960520246f,0.4367586477867241301354f,\
1.100708465607679542586f,0.7887304681164191144660f,-0.7638617615134800642451f,\
-1.1157778009204568636648f,-0.0715514394916681589764f,0.1759955522740979383389f,\
0.6521704771208436390850f,-1.2566799200234315403435f,0.7200913102328155845910f,\
-0.3420550667112094989086f,0.2477935566640704911912f,2.0205940701992970431888f,\
1.3930268695166325709778f,-1.2605487293586259411882f,-0.1650288634784027319569f,\
-0.0981081330322927658294f,0.4100655669623185506367f,0.7181621264742018562188f,\
-0.4072630840419457221024f,0.5156039430832634051782f,0.3795734781395984636099f,\
0.3638182194100580413298f,0.8461109103084072380341f,0.6093905395787995171730f,\
-0.2503150987783319125768f,0.6420253514641469649860f,-0.0446314315869399819148f,\
0.2916988037421140433914f,-0.3385179884731976951429f,0.4290547410494972568884f,\
-1.7617580904822116583119f,0.0242252644066083683283f,-1.6979773429025941666737f,\
-1.5685374082937220130418f,0.2235220732382334762889f,0.3158040584918663795655f,\
-0.3902896794740354780018f,-0.2554731784615550393980f,-1.2399505074947390070861f,\
-0.0969941013810174113008f,-0.7835998873676693898815f,-0.7420185738540517883521f,\
0.1215847078229450456410f,0.346331144382537814419f,-0.1289657459832099506425f,\
-0.2972509851392565738415f,0.5513684955823417999099f,-0.3924372370508544816126f,\
0.6550918706396454682661f,-0.0941496244175293039991f,-0.6298808116548983981886f,\
0.6046273337026021321705f,1.154776599111647650275f,-1.3475403271419439388268f,\
1.6941635868888738070126f,-0.9698161544930480326698f,0.321333626597992860763f,\
0.8077673631787291030903f,0.4495327099693594008478f,-0.2815944820401523052134f,\
0.5503911320698096076853f,0.4415940612643087237466f,-0.0426890352355768151749f,\
0.4574486820024267763607f,-1.8233880107049311725120f,-1.2644581540832258159668f,\
1.8182154451811951556550f,-0.4365692326313646565161f,-0.7834466000398015994577f,\
-0.2438122853723030947215f,-1.238179759598785789620f,1.0164635023339896324757f,\
1.1566875865587697980175f,0.7525323014625638906594f,-0.5302881550474964900133f,\
0.9946348209098996306921f,-0.2846244148716441380031f,-1.4971569165104527954213f,\
0.3858437386079422992680f,0.5857497893655945198077f,-0.5407108407032041874629f,\
-0.3913628275219260821416f,0.394150621449124050066f,-0.3677461583219513441279f,\
-0.3580090499105863521834f,1.2238011161239454871463f,-0.0394483595782139026542f,\
0.6819869387311006114771f,0.0482725904112477066654f,0.6909298247176761664790f,\
1.3224847954183336362632f,1.4037115762091163517766f,0.8467069128655627663349f,\
0.5210759995289813151231f,-0.2055830325344648878971f,-2.0192992995259366750815f,\
-0.5304191698016149647543f,1.09472080578548336405f,1.3620867421349684978082f,\
-0.1808242201566298279491f,-0.0194904828858388744217f,-0.4683180277648698042192f,\
0.7819869233308703870833f,0.1429480494914288357666f,0.2773646548392231792057f,\
0.6096476038786750040188f,-0.5960852983339143262853f,-1.963887290912852856550f,\
0.9721629223729456592551f,-1.6452050961761244263215f,-0.3723296190652639614527f,\
0.4738633834151028678683f,-1.057700746568926764013f,-0.4968910756708404541371f,\
0.2577873463311163293454f,-0.0737988795500269523231f,0.1977793752007929173331f,\
-0.6149210248305110315670f,0.9875664176674272543011f,-0.4642707502431423494116f,\
0.0643413048674845028385f,0.6498540575999842694443f,0.7121440663138152160627f,\
0.2359686505725840099945f,-0.2350484222736072826f,1.427908791905283747425f,\
-2.1717696603112686126735f,-0.7707405591334609562537f,0.8328839983146067993403f,\
-0.8442913355247498863321f,-0.9327775490791254675571f,-0.1481361786955139869804f,\
1.3160166106571784538914f,-1.641046498941054032628f,1.1071159236267200665083f,\
-0.1637297725664050573879f,0.0063889356258534446900f,-0.1876117315630027870821f,\
-0.0437156856017992812014f,-0.5047856242612756005883f,-0.4377080020532335691286f,\
0.8918622387976500309748f,-0.7125206673387354250337f,-1.8420141064608679393f,\
-0.6323236657671401639291f,0.4307970989642812553733f,0.0065706118931696342461f,\
-0.2380637309545470814420f,-0.9281665549650555124828f,1.2462413799568070604806f,\
0.1118120260462647785893f,0.5017427788303500113543f,0.1413380949238240147370f,\
0.5728474017890546887699f,-0.2522748296906130449635f,-0.4384774472140181011959f,\
0.0497517512937118988603f,0.5020924835745471659365f,0.6928164360637126817366f,\
0.9383192238380625438410f,0.9522811808490952989459f,0.6799302528285031677058f,\
0.5017679240717164423913f,-2.1626383553421018035579f,0.4579762384000223285341f,\
0.0586823729814069730559f,-1.0035555258293702429739f,-0.1166748359615927543853f,\
0.8530686378617126086610f,-0.5952441201854786756442f,-0.9104692400773028992944f,\
-0.1222081949574846115869f,0.8743861864198215760879f,-1.7814901158856750740256f,\
-0.1655434636829379024814f,1.2699075561256230049167f,3.1587625106365013749610f,\
0.8610776754247619901861f,-0.0100004380673695478232f}

#define CSOURCEI {0.9250286334648400998759f,0.1065362941212572023275f,-0.8122748012511081805442f,\
2.9016509109873367400212f,-0.879282905363888867001f,-0.3325238972742790566350f,\
1.2084799362120550725308f,0.2580513186266746861186f,-0.2529978784629969279507f,\
1.6363224419507169660193f,0.3632057263498695842685f,0.3611017132584669053763f,\
-1.2067543995469365292195f,-0.9261214746973902567362f,0.5500770410591231396324f,\
0.3509274981930612380410f,-2.0620828383452867171854f,0.1301261656898765051160f,\
-0.0829640021096160473757f,0.5497292800458170036748f,-1.586103376800369391120f,\
1.1212128658770057487715f,-0.0802149047940418080671f,0.3400568097779858578456f,\
0.5992917235464352287977f,1.2934484737369573714716f,-0.1770100915330515556345f,\
-1.6783588206143511545321f,0.3877335362207995905770f,-0.3290626192650726866695f,\
-0.7735806757117498211329f,1.4288193530454935675778f,-0.0608386450296815664562f,\
0.2853217242027552558170f,-0.3091484421032868468160f,0.2351673955360732704012f,\
0.8718242905301006873131f,0.9043814712183079196350f,0.4001603453209788274769f,\
0.2902565872125924539837f,-0.1051862594971314374126f,-0.2633497801636938695502f,\
0.5605928815183498503671f,-1.0135332223701010168071f,1.3762849538989350151041f,\
0.0221113855817069056287f,0.296045052860035018405f,0.1323984531412186749222f,\
-0.5439657044615130443432f,0.7105758550684416752219f,-1.988902172751357388947f,\
0.8370036445008282033342f,-1.361827445493777322127f,-0.2908726176761944892668f,\
0.7582058566306987268391f,2.2582687071318150451305f,-0.838995532132944754622f,\
-0.0049693115325542529942f,0.8948621233346091274896f,-0.1820415696112677728102f,\
0.0164009645281327567923f,0.4631157184786182656744f,1.2818863747394355634412f,\
1.37735582155233560187f,-0.7661687725125947423521f,-0.8188017890741936533061f,\
1.3941959606340814659120f,2.0721869090596265472470f,0.9329858014692479217800f,\
-1.0023470169799657547571f,0.1352029091047084741195f,0.5763346694547388793239f,\
-1.492034523395888490072f,-0.4804977288873880647557f,0.7911732889577677285686f,\
0.1745293679511154827377f,0.0354831535332537570393f,-0.8628629256538601355331f,\
0.1942834096659604437018f,1.3466596448020036191906f,0.3364543941938548110571f,\
-1.109797124842869298078f,0.1809508886112952685821f,0.5725159396053964844242f,\
0.6787472822917395287590f,1.4922528447187788369632f,-0.9855408452288743070824f,\
2.0147405762642014437347f,-0.1974169216352719968821f,-0.2472797570908096820297f,\
-0.3003777280233598800940f,-0.6957353172991608269982f,0.8954567399776292013769f,\
0.0025734217968703923703f,1.2028191624106452373155f,-0.3976568161030914483334f,\
-0.9486032699014914637559f,0.344203116731234826098f,-0.1282579491971870822020f,\
0.2354837848969928981724f,-1.0123893486718691381299f,-0.1455435264750559176683f,\
-0.0385439121492695893623f,0.2704776801120854501370f,0.9996348746916957628272f,\
1.1879952493572987215487f,-0.1421627190737907164841f,-0.9134168336317867176177f,\
-1.3273949616244651306118f,-0.2266260602581666450117f,0.0136941574262192684169f,\
0.8667822397875659667932f,-0.8918524882230300931951f,0.5818810906621436629393f,\
0.5786477410918646757665f,-1.2824019249961673416749f,-0.8858272202103619763491f,\
1.49931415247364041576f,-0.3191008638398869501351f,-0.6302800825827241659738f,\
-0.9307697616588104239099f,-0.2218962076254625825911f,0.5504657591791385362612f,\
0.7937732776747626894931f,0.4530121091137990219089f,-0.5561836772913717474864f,\
-0.0487810094749783207391f,1.0373690852013959240452f,-1.9605345216190741552964f,\
-0.6318190008183720562940f,-0.2595506312908315571519f,1.6655693943633802511783f,\
0.2643484753712377899326f,0.5166487752761181884154f,-1.7642021092407271787295f,\
0.9519817124353935344772f,1.5941109627321103925368f,-0.3268346133298423716873f,\
-0.8591341754919610274044f,-0.5067465121338621258928f,0.4012524027420211192307f,\
-1.3781772559142455580883f,-1.0900200484217259511155f,0.7071849131547247591101f,\
0.6311112492498477388736f,-1.5661486235109134401711f,-0.3037032596268335327139f,\
-2.3928711979350367755615f,0.9280630230889591603116f,1.234345031017325400313f,\
0.0245382276611107209841f,-1.7795591476102954331395f,-0.1457340296796875434016f,\
-1.4175919090731374794245f,-1.0931645829165108629866f,0.0976120560124896369247f,\
-0.4917932561715864236973f,0.3236361331498361360026f,-1.3493789441767958248164f,\
-0.4975410901203008995353f,-0.5175498508985710843788f,1.9028534065523732277114f,\
-1.0213015320689262654952f,0.7201673839470011939667f,-0.229479324750370056174f,\
0.0507808834449509222120f,-0.6036524407661360003274f,-0.3189899214184117592907f,\
0.8969390978377852485792f,0.0689550751790670851671f,-0.3842312216289716086948f,\
-0.5817559662860881664059f,-1.4228206622942274339749f,-0.8055937171612096436846f,\
-0.8761791574203163790457f,0.6999940081500163335804f,0.3592083211755666694032f,\
-2.2759824091756848396528f,1.1126243656877470300515f,-1.490042708505755930659f,\
-0.2517675074289520420479f,-0.4649616224894683735869f,-0.9304122891120238936224f,\
-0.2780945839682648634827f,-1.186365868114249266796f,-1.0805465619847403058174f,\
-0.2982113561322028982836f,-0.4608151973468663786804f,0.5142626215675811796046f,\
-0.8962085262358048254328f,-1.8912922138922239057024f,1.5339839202719194322100f,\
-1.0493592314888038341536f,1.5275565058768361126340f,-0.3000289995792813080300f,\
-1.2901253199534357118949f,0.4517205659557054775455f,0.1925085892467791881533f,\
0.4244705571771024699146f,1.1465794102472002258253f}

#define CRESULTR {0.2881823261718455264635f,-1.2239148834349047323400f,-0.7845879395690421587162f,\
1.7398908843418365854916f,0.6267968040978579846723f,-0.0069618200210163757799f,\
-1.3647060336777470102021f,0.3067781755755824568688f,0.8879601142484547793288f,\
-1.1408081118402808584733f,-1.0511217892257147532575f,-0.4630227853264242132703f,\
-0.8052300885146775888401f,-1.0799054881923455528892f,-0.3673239873834487356774f,\
-1.3895193771431015861140f,1.4748704381210364644517f,-0.4721815868535457205724f,\
-0.0800715444386163321955f,0.7328675926305248111703f,1.1062012776691256821238f,\
1.1578188890116758447135f,0.7250736097899580512305f,-0.7268209399811761395327f,\
-1.020749615675486277055f,-0.7543891378811746761812f,0.1777916795470285138414f,\
1.224903809672051702151f,-1.074529895353530717372f,0.6903548013878436639956f,\
-0.4611640141379182988857f,0.933556473565831823613f,1.4531339378119088046049f,\
1.1451427225776011908920f,-1.0686132863053487973559f,-0.1688483441440512822229f,\
-0.1889456477264452038956f,0.5985578048499338166266f,0.6993236665323845357989f,\
-0.4109810453160360754765f,0.4971360116983927213141f,0.3821580291233257486994f,\
0.4128919091647823558233f,0.9758538921704605906271f,1.0346135696067118026065f,\
-0.2478280180540722854587f,0.6216905071606976251886f,-0.0450118169844396301404f,\
0.3340415020637265142156f,-0.4315313860868430495543f,1.3446595868643815840926f,\
-1.4033414360880258620057f,0.8274220763035017300879f,-1.309144795084008494612f,\
-1.3004176310924011605863f,1.4613978516551788811029f,0.4652521895005036212112f,\
-0.3810083873666035292338f,-0.4305652750257212835194f,-1.0463819862831613693999f,\
-0.0968555231163464591670f,-0.7621978211341690068181f,-1.0442639351316740370379f,\
0.8551375533721097266238f,0.4624338658491132791895f,-0.2135461711123592121186f,\
-0.9192783709328955499274f,1.406572519212488048268f,-0.5996917427163407365853f,\
0.8472849136812159454024f,-0.0948718277212909494311f,-0.6635046470522460992925f,\
1.102552918644890800337f,1.0241591511876448894469f,-1.1946095915247210150767f,\
1.3012416677676885701231f,-0.860094399966521483414f,0.4848763007604853791932f,\
0.7459402751068522352540f,0.9429407450799555112653f,-0.2932662625241302944978f,\
0.8365772498525353428889f,0.4339900657778844039747f,-0.0520088659229247518567f,\
0.540163948037489571874f,-1.5617045052623743650599f,-1.1990755672824380262398f,\
1.6897714229424107834632f,-0.4304392780607278479188f,-0.7314935627224536940361f,\
-0.2521660858364912494167f,-1.1139709472810304102808f,1.03593284093582016503f,\
0.9879482215425008373444f,1.008898373366306833177f,-0.5387894626210441018088f,\
1.0404295395317768591070f,-0.2970761763070669525533f,-1.1952939328908356309000f,\
0.3857997224260597546319f,0.8038817262315489653446f,-0.5212531537640049394966f,\
-0.3822389517390957225373f,0.3966495909859810709008f,-0.6230521638604892276092f,\
-0.7692209701300163349202f,1.03425437487647720047f,-0.0946733232120821749378f,\
1.0396309891046779938506f,0.0495385539831420876333f,0.6452562376798283150237f,\
1.1985497422790862831476f,1.2458585900431864423865f,0.8349246161988523873276f,\
0.5689579490080320933743f,-0.7806209699664544698905f,-1.5187452500641256403213f,\
-1.0796802038517956390251f,0.9639374126836365297422f,1.1711728912763936794050f,\
-0.362488012679416937711f,-0.0199872602643281528645f,-0.5128264059242761963020f,\
0.8492028743473079011039f,0.1591587587129435210631f,0.3212111561314560104208f,\
0.5775318673000989777577f,-0.8249558967503766160334f,-1.7154192273737123297650f,\
0.9346304365709510175719f,-1.2804432024400131950870f,-1.1426657840798974952179f,\
0.4703017265736584850977f,-0.9677493848474170157203f,-1.2320829767979621927054f,\
0.4762683633703864716225f,-1.0444970147674126348392f,0.2072645201710894835578f,\
-0.7498010260478793487238f,0.9188781401771745072082f,-0.4789588845434366026765f,\
0.8476937452776511783270f,0.8895027647705600060135f,0.7682169660294876356588f,\
0.2922093151936491217668f,-1.0429114806489117039945f,1.166492728893671504409f,\
-1.8646253504096552688907f,-0.8923239533314403226782f,1.0666374040344190898821f,\
-0.7669950473749445052363f,-1.3585386555510787776058f,-0.1491456224121993634490f,\
1.354597929546794699007f,-1.4004360287243708960148f,0.9567139977921835791719f,\
-0.1859618971982733570680f,0.0067522660769214690180f,-0.842830481930881947328f,\
-0.0503539309377906904586f,-0.5389456072426579424928f,-1.2991753231583602623544f,\
1.0064698858838660999737f,-0.7727166159011478185903f,-1.375918311051623987851f,\
-0.5968365322787659854598f,0.4909328325978893903248f,0.0069327197759769939797f,\
-0.4109069224660110153380f,-0.8305261099098545374275f,1.067766372332880076002f,\
0.1364036525382384124061f,1.0185816452043403579353f,0.2263896344197315613211f,\
0.7241797053868859190828f,-0.3310339119084142467386f,-0.4485953806654829345568f,\
1.4637030484564286236804f,0.8062581119903107218505f,1.135230070733268981087f,\
0.8486739138084887779101f,0.8869200257723099944940f,0.8304138989692378958196f,\
0.4970805707137128659490f,-1.6189532479764259242927f,0.7536345887109229257916f,\
0.0614297741451279438740f,-0.9217679644120017057318f,-0.1351912284135200204016f,\
0.9344534227267771164804f,-1.3237759469951597690596f,-1.2409772949992454726953f,\
-0.4266400610039619012426f,1.2242961173386468498592f,-1.3507787481217943259537f,\
-0.7743193525686042910650f,1.0905655681187926830944f,1.869097852573508911078f,\
0.8141159942263986870614f,-0.5353611933969746328188f}

#define CRESULTI {1.0927665474832626291146f,0.0577041411945533808114f,-0.6605411939586326441898f,\
1.4173928005937053153929f,-0.8196938376873322829042f,-0.3389699587748392084485f,\
0.6182411929183926346809f,0.2489298772050817232238f,-0.1790179858054015138435f,\
1.2497543779018556175942f,0.2282445233800083350673f,0.3316185520857942714557f,\
-1.1178350760886399672955f,-0.5992404494636266454322f,0.5409431572062767257236f,\
0.165426376161976390611f,-1.1122536593055589726475f,0.1171231329897951256580f,\
-0.0827933061236485051682f,0.4436212447193593200190f,-1.2403328057018132568601f,\
0.6960798868922111193314f,-0.0629757037081154352753f,0.2697689038111338311055f,\
0.3922302209885859536342f,1.4842743869253867128322f,-0.1751428834182987837043f,\
-1.13801740936157136375f,0.2394213509890497915134f,-0.2668464988788373237760f,\
-0.7726426977316005473284f,1.3382415873096298319922f,-0.0269807302035863991185f,\
0.1656312162752983929703f,-0.1911246952977092017356f,0.2339836780169318453115f,\
1.0284310438096477824388f,0.8686878315011077322794f,0.3246111072217529036621f,\
0.2706500543034189298908f,-0.0935407508346946525712f,-0.2477506860556301926390f,\
0.5421539099371334158306f,-0.7327711559744070068945f,1.05214358953255682216f,\
0.0214509576394467729732f,0.2493724089381304798163f,0.1326531466862980457311f,\
-0.5409686898264083332322f,0.7065143938000820744705f,-1.3284854753780470648650f,\
0.3984512917058077308141f,-1.5446072484052193463100f,-0.1469509150678137976431f,\
0.3947301571210936610434f,1.461008167394748147316f,-0.8567501445560671280433f,\
-0.0046292376134026641879f,0.9577036871573997300899f,-0.1140752778705255016112f,\
0.0163250605343483005949f,0.3628386917181465332050f,0.9320951721399445277783f,\
1.44423353597128478754f,-0.7628206936973814800140f,-0.9280966118664348840639f,\
1.2849894108105837098321f,1.2792864989827095190122f,0.9061761299907579170210f,\
-0.8122605612540356734286f,0.1350064725981316715586f,0.4883936062374085174120f,\
-1.102637196793889051705f,-0.3106468603302708908487f,0.4543964386247798525886f,\
0.0885735454738456329249f,0.0254706011136682855533f,-0.8796254633651946486239f,\
0.151022627304807338655f,1.1452851102523748938466f,0.3283556388648877777392f,\
-0.9434455972747952667845f,0.1659123702555805879300f,0.6086281726098896616151f,\
0.631662047814702143356f,0.6431181331610840157254f,-0.5760553428914201301581f,\
0.8026360136122261401681f,-0.1814351276467410234439f,-0.1944579368330171531554f,\
-0.2953494745705410595704f,-0.4250058789202441067445f,0.599813865521373279499f,\
0.0016830438518425523946f,0.8854731871017331723550f,-0.3534985427172745442448f,\
-0.6383931728072353983805f,0.3358307199066276060861f,-0.0711733718807077142543f,\
0.2207727851446303901639f,-0.8556718335996058577564f,-0.1281371029552695606224f,\
-0.0358976629777693137524f,0.2532084228703710415687f,0.983986642358089413918f,\
1.1345925939829912820755f,-0.0898559156199065373061f,-1.1416915329673189560822f,\
-0.9870037974692073001748f,-0.2283270051627071806077f,0.0112664968061259064547f,\
0.4998464672322767698986f,-0.4937534754955061888637f,0.4389132738737425154518f,\
0.5191615917775272981416f,-1.330080589614465180759f,-0.3792401398168883108752f,\
1.1512099997314479971067f,-0.2141264512433771194377f,-0.3645359117298094808746f,\
-1.0609046855212507232125f,-0.2237132816089271170057f,0.5066458933231118288987f,\
0.6114387233853804115569f,0.4637825784576218857147f,-0.5570387380565021695489f,\
-0.0416532931678999865377f,0.8675730496349238762832f,-0.7521971544712148238787f,\
-0.4444425039044248570974f,-0.1343255157657375076230f,1.3031888522890535675458f,\
0.2398794824711508455461f,0.3501788639961876947737f,-1.2484148728039676790047f,\
1.0223862780907517766593f,1.5114877336366283611113f,-0.3256639805152193312132f,\
-0.7257147000802074421344f,-0.3563177118938634091450f,0.367466380314942664409f,\
-1.5032253124394940879682f,-0.8731092741090689113292f,0.5703012583169800864269f,\
0.6498833797759138164452f,-1.3804786941428137669874f,-0.1733188156619589748164f,\
-0.8098487944615534450676f,0.7091099644264757806411f,0.8627806630820323841036f,\
0.0187490818204580703132f,-1.0316116049359651540840f,-0.1446317495535741626256f,\
-0.7559013344655626243096f,-0.5329078157992787057040f,0.0653983668850169619358f,\
-0.5045465362161873912328f,0.3295621318182701542376f,-1.3711989596398608259875f,\
-0.5200355557922887728139f,-0.4673488331710942134123f,1.3098786184351398631520f,\
-0.7189565120188516900157f,0.580208200526596162838f,-0.1091990841314347954194f,\
0.0429221122996483323009f,-0.5675416667058814645941f,-0.3246554520854594838575f,\
0.9723329710924543123340f,0.0505316478341986258238f,-0.2385123070932486100126f,\
-0.6142986606043344677275f,-1.1409813222703388824186f,-0.9033119064286492250204f,\
-0.7584587763797572268487f,0.7252421018090512427889f,0.3319280479688784257775f,\
-1.5464687515566899467245f,0.9763347698321626078055f,-1.0511809923664583443781f,\
-0.1831638202759971745248f,-0.3336438319634690841120f,-0.7499286125479456277532f,\
-0.2495331996617490000201f,-0.4693439688376106477818f,-0.9839213631021112016484f,\
-0.3022296870844187743899f,-0.3220832096726037319101f,0.5347182539371353460211f,\
-0.6559994287878105900802f,-1.2228456605235495935347f,0.9588662882096035122714f,\
-1.2891530456629314294048f,0.9731441796186428572213f,-0.1461840118371629804184f,\
-1.3757278523698810435150f,0.2762809284691948308321f,0.0580458636704428015962f,\
0.3198225937522309325622f,1.5529789344620548163789f}

void sasinhsTest(void) {
	float in[]= SOURCE;
	float res[]= RESULT;
	float out;
	int i=0;

	for (i=0;i<200;i++){
		out=sasinhs(in[i]);
		assert ( ( (fabs(out-res[i])) / (fabs(out)) ) <1e-6);
	}
}

void casinhsTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in, out;
	int i=0;

	for (i=0;i<200;i++){
		in=FloatComplex(inR[i],inI[i]);
		out = casinhs(in);

		assert( ( ( fabs( creals(out)-resR[i] ) ) / (fabs(creals(out)) ) ) <1e-6);
		assert( ( ( fabs( cimags(out)-resI[i] ) ) / (fabs(cimags(out)) ) ) <1e-6);
	}
}

void sasinhaTest(void) {
	float in[]= SOURCE;
	float res[]= RESULT;
	float out[200];
	int i=0;

	sasinha(in,200,out);
	for (i=0;i<200;i++){
		assert ( ( (fabs(out[i]-res[i])) / (fabs(out[i])) ) <1e-6);
	}}

void casinhaTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in[200], out[200];
	int i=0;

	for (i=0;i<200;i++){
		in[i]=FloatComplex(inR[i],inI[i]);
	}
	casinha(in,200,out);
	for (i=0;i<200;i++){
		assert( ( ( fabs( creals(out[i])-resR[i] ) ) / (fabs(creals(out[i])) ) ) <1e-6);
		assert( ( ( fabs( cimags(out[i])-resI[i] ) ) / (fabs(cimags(out[i])) ) ) <1e-6);
	}
}

int testAsinh(void) {
  printf("\n>>>> Double Hyperbolic ArcSine Tests\n");
  sasinhsTest();
  casinhsTest();
  sasinhaTest();
  casinhaTest();

  return 0;
}

int main(void) {
  assert(testAsinh() == 0);
  return 0;
}
