/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008-2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testAtan.h"

#define SOURCE {0.2271646957046519754719,0.0509554588447201708967,1.85687282969809008826,\
-0.0600149264751901750925,0.1154209251583080408921,0.3931023811137128731730,\
-0.3192353063868129114944,-0.1509983292012369027191,-0.3971164405532471297633,\
-0.4879179365092389808467,0.8039704485327389127391,-1.6086183006520318183874,\
-1.4550051558571557297483,-2.0613539298303464875062,2.3614638061462338569640,\
-1.1480101088176024592968,-0.2658609898928261938700,1.5427739450302764279144,\
0.7423335722389889923534,0.3296187860375025535653,0.8154893385384427428875,\
-0.7055736212996815970300,0.2819847871866195676560,0.3955156539663013948172,\
-1.0216483261612141486552,-0.9217285194529017955389,0.1388701122197689430404,\
0.2561008611862776729318,0.9488840790776944533746,-0.6033504831579518112861,\
-1.255847241084065313288,-1.5093582375924872174267,-0.2071228671170260715595,\
-0.3992159361232490155658,1.1415777038585108726920,1.2096296402394912661293,\
1.2000346264198469281581,0.7648344037454491983752,0.5126417298496636076877,\
-0.6005237850264322219118,-2.2808601123468448257370,-1.0478316411512684780405,\
0.3987387706615069249416,-0.7901557685645255180162,0.9472076517346639246142,\
1.2552561019596721880731,0.4826393798173508331573,-1.9230607741483070061150,\
0.4005546162223627693066,0.1739168390171661471300,-0.0825727057882147952306,\
0.8203738818332056981220,0.9228038015421474726807,0.4570111559683089907935,\
0.9219829463190309937204,1.604104528474896707024,-0.7201236539398426783620,\
0.6869793119903724321063,-1.3399970213280150144186,0.6385085849830633986102,\
-2.1392676796592846599765,0.3031216472852934495918,1.4731483222685206602165,\
-0.6666106701273177836953,2.5253251451367195735,-0.3387226520606179125394,\
0.1099263677503663910739,0.2055796316301525261672,0.4180157426427644207223,\
-0.5676554981767482077615,0.1457986457557736703627,-1.887021345850510067876,\
-2.0255226332731517402408,-1.5021973207858168031237,-0.1565213082415607970255,\
1.792895025421787247311,0.9902819037203779428680,-1.3877868870664777922741,\
-1.9114516712610110094062,-0.1241624780676525430234,-0.1512289550370426727266,\
1.0440663453119916059819,0.8275748256509259936919,0.9453274386638104154201,\
0.8371330563424048687438,0.7021707191099652023425,-1.06501992349112173386,\
0.0584382761085656052269,0.3908208204693481846448,0.1507745763925768811564,\
1.0041017891872929812536,-1.2313120848428102949157,0.3394895696418271380246,\
-0.0827142520512850892844,0.6446222176264210235175,-1.4935026770981445487507,\
-0.8052775249062644746800,-0.5748653112322126279565,0.9754979932482783500092,\
-2.2884524191498907264020,2.022987266935787342703,0.1637454282369502356342,\
0.5475744092801727580522,-0.8932610448161549809853,-1.2797351399265011195894,\
0.1118201613432585478369,-0.9620980829388734445473,0.3643849907609559291011,\
-0.6874188098904436827752,-1.217541476664303568000,-0.5294220756831705676504,\
-0.5958966870065123266897,0.1130069370904074471662,1.3982224083465000230575,\
-1.0698899503771839292199,-0.4886124217435617311800,-1.3658513358172643670230,\
0.7879963184644042106797,-1.4375620975102927356915,-0.4139225629147579854639,\
0.4724629049642866118752,1.3786020791121860185058,-0.1818007311019581573319,\
-0.1220915022718044445904,-2.1432379005797042026416,-0.8715288727031362814301,\
1.7328275421264391908949,0.0746395063981880602100,0.9478227559099661192477,\
-0.6746643568348875685814,-1.12189978973121218253,0.7712825781700975991129,\
0.7878967433781322027286,-0.114954127571938721775,-0.8797100720757337066757,\
0.3945983137523260686486,-0.1335061206135170208675,-0.8812942795785859706470,\
0.9678256351883146590964,-1.2184863124466103201371,0.2811177412486541848935,\
0.9039980069833579712224,-0.8586130195545335075380,-0.9119525776637865677188,\
0.7834023749729661645347,-1.8588322045751330957586,0.9413946838303350883592,\
-0.6013167449649100548825,0.7116576086154465796696,0.1856739618227061516809,\
-2.4025809662081938355982,-1.1900189182655975805858,0.4811625406314723463197,\
0.2175387195999395339996,-0.0380853618830928608574,-0.6838145482543566133771,\
-1.5179336348870946515888,-1.718734246002084020688,-0.5464611700109887060250,\
0.7723526959000743818962,0.3006795138383335785903,1.4291868716265472283311,\
-0.0677166634975557846232,0.0573956162401944233742,0.1830487012206095109867,\
0.6989722492840018119864,0.1910038834963114218191,0.2306826823577726726100,\
-0.2565102919971545825106,-0.3420573662934773273570,-0.0978166804483409507709,\
0.1422536753322360680851,0.5435939242933658377410,-0.3468100829076145585894,\
0.4660640367220392210612,0.8993729143853705920719,0.7600191222869452367661,\
0.8968829064436780740266,0.5805771807617583490924,-0.2307843851109470378891,\
0.5165770205506754475522,0.8824788500189956197417,-0.7969387348104061130627,\
-1.8168722946703086407183,1.5190242407155258863583,-0.8149773729875190442229,\
2.4028228775031306163612,0.4982657796195523181026,0.2226740315197290043248,\
0.1768897379163425209736,0.3603060382424789764855,0.3218716686921767045071,\
-1.192570046506437719813,-0.1122386313819233177869,-2.0287975179488202392974,\
0.100288454133301133120,-0.9179783877737051067669,-1.1999331406575297620520,\
0.7483478159755958536437,2.2060613717090746810356}

#define RESULT {0.2233738732437201557346,0.0509114261721980362885,1.0767942567911201745545,\
-0.0599430280405672463728,0.1149124379797051148655,0.3745460477695387035979,\
-0.3090091280795300709983,-0.1498661654051850200542,-0.3780180809438991595961,\
-0.4539353243495501954996,0.6771572627749745665326,-1.0146085369409014731445,\
-0.9686564923933993487282,-1.1191250002845629651915,1.1702255762215818535310,\
-0.8541951038511210736459,-0.2598500531232013632810,0.9956994243583069392756,\
0.6385765127412353914238,0.3184037447477280347030,0.6841145592833487443230,\
-0.6144568631857774132499,0.2748482455938721091826,0.3766345938432117956829,\
-0.7961060093123013547967,-0.7446909349913972686608,0.1379876022907993438071,\
0.2507123565043022361820,0.759175872898178005777,-0.5428794496736766284073,\
-0.89833074078511021554,-0.9856607896834306270506,-0.2042349952101077392719,\
-0.3798302772852411579585,0.8514111742492602719068,0.8799860018302214648145,\
0.8760722415122048634117,0.6529277236314812160600,0.4737097703113398172725,\
-0.5408045473230975730417,-1.1576046419742331838876,-0.8087511308495316519895,\
0.3794186378049814734048,-0.6687094713589172290114,0.7582929808049961861727,\
0.8981012978260718426782,0.4496629050128420623800,-1.0912735975391061327144,\
0.3809844030879972476278,0.1721944986308187042212,-0.0823858026410947269502,\
0.6870411688329144395126,0.7452719880215435965809,0.4286690862084140407617,\
0.7448284765591709488675,1.0133478453990099055204,-0.6241044852011972121630,\
0.6019336895450897451099,-0.9296864924479115721567,0.5682544332615881987891,\
-1.1335263715873262757583,0.2943182248013878621329,0.9744281865108882501048,\
-0.5879638357107155322012,1.1937528186152712716961,-0.3265930739728566956082,\
0.1094867742408287547562,0.2027547884149371593132,0.3959400774109990694960,\
-0.5162971747333449101802,0.1447785328438968288634,-1.0834879385306221966090,\
-1.112201615701992940544,-0.98346913687842862917,-0.1552615733221418270471,\
1.062017052786182524926,0.7805154284284491206236,-0.9463968404701921244282,\
-1.088790816976063835497,-0.1235302727421704604982,-0.1500916423979053448967,\
0.8069530021779800499360,0.6913301738780865957068,0.7573010048408638228423,\
0.6969765492354944580455,0.6121813376326975530972,-0.8168741064761906311986,\
0.0583718892203711620104,0.3725683317450820819516,0.1496473933205103579169,\
0.7874448575733706823243,-0.8886955789071054878647,0.3272808967598674345645,\
-0.0825263887088810432768,0.5725854110105892402771,-0.980788536566781998793,\
-0.6779506710306395511623,-0.5217330517396027156352,0.772995847351621967469,\
-1.1588253401537096376472,1.1117042516684423337,0.1623050519698593929796,\
0.5009790459791051420169,-0.7290794216990050813365,-0.9074929345625200038938,\
0.111357569834535111153,-0.7660835307058299070704,0.349432040770661034301,\
-0.6022322122997969540137,-0.883185569845575946246,-0.4869072854862174781765,\
-0.5373968957759416298359,0.1125295355475867259409,0.9499457978350420717106,\
-0.8191503966966299232766,-0.4544961153792455021971,-0.9388212744104845741688,\
0.667378646873721059762,-0.9630145809992480820938,-0.3924506725722226585518,\
0.4413762601275756369823,0.9432440329190430183814,-0.1798366074472934617035,\
-0.1214902252731905191174,-1.134237248756892579848,-0.7168606663031997783264,\
1.0473916695445741886772,0.0745013609201800736104,0.7586170976909952790024,\
-0.5935190472805600414574,-0.8427835085661474767704,0.6569834032811123769591,\
0.6673172133738860534180,-0.1144517528481678869667,-0.7214914324609644769026,\
0.3758410950307565223660,-0.1327212976140068612096,-0.722383800988696922474,\
0.769049408891516961262,-0.8835660062516154100720,0.2740448831292710551999,\
0.7350195594735607906856,-0.7094731621063239401792,-0.7393796262522003281958,\
0.6645381846985234375325,-1.0772344059827341222757,0.7552201039546350136433,\
-0.5413871326815293816281,0.6185070897724082028546,0.1835833463904297524483,\
-1.176386657281365266670,-0.8719472877519027775861,0.4484643942741659561335,\
0.2142014421948802427309,-0.0380669636860080026763,-0.5997804502671881810016,\
-0.9882664118774061590145,-1.0438491153613729256477,-0.5001221995547742160682,\
0.6576540281533080900545,0.292080085019127744239,0.9602726979256205330771,\
-0.0676134413768641334697,0.0573327152217289193192,0.1810443840994339081973,\
0.6100358657130787731759,0.1887306738654894733287,0.2267166741276365193869,\
-0.2510965487437752940991,-0.3295815282597121531616,-0.0975064859373050984992,\
0.141305606529955662953,0.4979116182528884881897,-0.3338302007475900112787,\
0.4361321851910835434296,0.7324685375973356560309,0.6498825704253795576548,\
0.731090278993245523687,0.526015577583169635645,-0.2268132361170670519002,\
0.4768211073463659022131,0.7230501420836584758334,-0.6728715276854828619690,\
-1.0676488164290300897363,0.9885963208407696489743,-0.6838069995773392584226,\
1.1764223744131836468796,0.4622592705138702240397,0.2190994523411692873616,\
0.1750786606269341127984,0.345826480359459564884,0.3113998336672463840280,\
-0.8730018295092231150889,-0.1117708529226727198758,-1.1128425715998719880417,\
0.0999542424787834421496,-0.7426595867662098005013,-0.8760306483273037070347,\
0.6424428721795988339593,1.1452043748636047126865}

#define ZSOURCER {-1.1795163216180464260674,-0.6957584169324845246862,0.8259988996926452831104,\
0.2005040766836741483736,-1.2112828126521528737669,1.577061196992769698255,\
0.7637772368360737917925,1.8192271630516374525399,0.5455430088849253511540,\
1.146539236621446411490,1.6240394311350210276856,-1.4966797534977682726520,\
-1.59547014335820214193,-0.7395898851221245351439,-0.8068636961152658715335,\
-1.0311002075319768422901,1.2005970723482952688954,-0.2648910783446530303742,\
-0.2626223153489460337973,-0.7475187472806215094323,-0.5661153624892958369230,\
0.7434875747358512532159,0.7872535238570613769227,0.451715552409009846180,\
0.4606878032667490185936,0.0776842938192593146507,0.8641526902252117947612,\
1.207833841833020782630,0.8731959322473188400693,0.0203507380205638840898,\
-2.142561452892851825425,0.3422111419280877142590,1.2579314478540355448644,\
1.7477933051936518360492,0.5187339957481993391042,-0.132728581017459240643,\
-1.1602733035670516059668,0.4875989045190238790894,-0.5701105851822111381111,\
-1.1912139790942799510987,2.0124340046175204221868,-2.7045248893564091119401,\
-0.6431322992574242114472,-1.9153194443350760600708,-0.5655545944523592272191,\
-0.65321727466490830949,-0.704349532744792949934,0.1130503418105048285547,\
0.7790220841116946015603,-0.8369920883463126681789,-1.604067362874623814406,\
-0.2256746981594401069149,-0.1392938143448255172707,0.6830835101317246360608,\
-0.4155213883413004238854,0.0229733819760836940893,0.8246417042132325736503,\
-0.6376565658151804871778,-1.7068298799179615343746,1.4073819355206949044401,\
-0.8295221757203087298294,0.6373043870424420775933,-0.2922017410826197592044,\
2.1752387761511053909658,0.0600723389389604608968,0.7835812912685555797765,\
-1.3959357154825373648066,-2.0629358999978850697232,0.2656918800288301518719,\
-1.1613766205716309354301,0.8939124507954123721731,1.6784098435216081579568,\
1.2683311792448521693188,1.8385748076192800493089,-0.9497329202198889763764,\
-1.270378528387523964227,0.7963056587352231874277,-0.8480009473832804678395,\
-0.8640072224951356183453,-0.8715001223760306947597,-1.0437638424148545368553,\
-0.4238345049288854693437,1.1151445198271947578661,-2.2055374030068151114392,\
0.2874269036908579932899,-1.141542990475093111158,0.5076848390265716881586,\
0.3056363849775944885323,-0.3052849785217074396471,0.0155317052678219415240,\
0.2432114799458970910706,0.6784283234918451199746,1.872617399166290219625,\
-0.5480102320972454199577,-1.1310137592478748391756,-0.0865801063652356234224,\
-0.32288669591661972591,-0.3304845320488251636526,0.0611848701378388329375,\
1.826560717567842440090,0.7447867877814601245134,-1.1564474239432984692399,\
-1.1265940444751152416103,0.142628529129462972014,-0.8925873814067234457426,\
-0.3627863505191566417807,-0.5662183332585394301972,-0.2716795089578870614488,\
1.3639803640910439508360,1.237612166886607800720,0.3924305122780659127457,\
0.7582137693795522048745,-1.1492170633741971563779,0.4241382639443282975833,\
0.4098444400457034175744,-1.37669132334320454270,-1.4476326062045372644604,\
0.7114066611465256206870,-1.3924830606697651269599,0.0338524257403221839891,\
0.0146836062137128426502,1.2378730149006278438151,0.2801823548361609406143,\
-1.3742686169958964192972,0.1717540380186403925489,-0.5855903929173471578196,\
0.1907429151227005570401,0.7888793090772500127272,1.1338168541183824000740,\
0.7778678198128919918375,0.4430509890900592440133,-1.8169712227336964893709,\
-0.1603235606348805963872,1.0728726966089832117746,-0.6538383763382829005906,\
-1.2903854138672581353120,-1.2588653493715018516497,0.662482523108547827206,\
0.8653058064884894262647,0.8205627120768179683097,-0.6052538675768098785923,\
0.1489320223008726296055,-1.1002545757952191252116,0.5601748137285590400936,\
-0.7753064210754536667025,0.0825270383499445148168,-1.3301792471357218872186,\
0.3149537401293732719054,-0.4413283119409475707684,0.5584497354764290655282,\
0.2709448579613401020261,-0.4281368707331745238065,-0.2387957265896963054974,\
-0.4604827882307634956405,-0.5412644127984000963494,0.7328783982761175597176,\
-0.0713404400136534444510,-1.1936962614002064597685,-3.042807307214757006619,\
0.7597050488151386726798,0.1791274991920646930676,-0.2506292816675101398083,\
-0.6351531470374360832665,-0.121161180968055212648,-0.3652194549719223193307,\
-0.9437320920432173965153,-0.2710022932148818952669,-0.9443973941449046449748,\
1.3983220899832822237130,-0.4381256814836405610869,0.3765568950431126271639,\
-0.3219819650340491334894,-0.1074889504736799422657,-0.6785727331891553415488,\
2.4505579021475099033012,-1.3142551981836398944381,0.7354780365902759964314,\
0.3711279315629368302787,-0.8351813322615772028357,0.9766824658266765046832,\
1.461883720898450089720,1.5553635146325224258845,1.4271923988949506423296,\
0.0934141721491809351452,-0.6278372555306163116384,-0.7994063607890871114847,\
0.4560734872063767486594,1.2736575371127356604006,0.2044809074410245119946,\
0.2464253458581916467196,0.1480097817386342162749,-0.7352399556856978879438,\
0.9198120099159204920980,-0.6013531026590643868701,-0.6865004071225593307304,\
-0.104616070370811706236,-0.3041328910990643286105,-1.0780356133329238588203,\
-0.4779521279351744977859,0.5025105381497957379722}

#define ZSOURCEI {-0.9552428551144188650923,1.2961834852294731312838,1.1017640646828426032044,\
0.8711087850527934328682,-0.9420760043657475657497,-0.1497284505613425964476,\
-1.3185366552605053414027,-0.6344981208817582762904,-0.1939736947913383302566,\
0.5047024828595823020549,0.571239270735604098839,0.6329832938920191276466,\
-1.0836206204774869732432,-0.2988022043772741165313,0.0786451729619408040906,\
0.1005946170325885125063,0.1951019512685897017157,1.3036996759610997020928,\
-1.604446040591435362899,-1.665829130168900329423,0.3894119616051456289618,\
-0.6441312956332616579402,-0.3024073427875212938254,-0.4621890957188650173038,\
-0.6774568059775447625981,0.445231860114528421590,-0.5535293580988084327643,\
-0.0006762893110915249931,-1.089389506561633025328,0.5723493142465210237191,\
0.4420973206857362058919,-0.1612581930858848211496,-0.7163329171822375718293,\
-0.5277733874018479820478,-0.4768406780661605948168,-0.3993604887388358948286,\
-1.3804293506092022436604,-0.1591254367281162429570,-1.6980146860343119374903,\
-1.4761781930573465437817,0.2862303841437082718713,0.6052999005919722508295,\
-0.5483298295339265049364,0.0209604427664898014527,-0.6457183807429971444947,\
-0.0603329310380973649064,0.0091414413452102355473,1.0949883817318917245132,\
1.6400776092272673079009,-0.623485665086227380804,0.9132225220115295361012,\
0.0829708966832887195864,-0.1905412057335640341194,1.7237280439025588485435,\
-1.1486098807701770052603,0.7656322424078984001383,0.365608177776686305016,\
0.8275570484489896960767,-1.1195346368945833237518,2.009348617520048563279,\
-1.3914607990698013573194,2.0854477679794358735421,1.2877168046463016715109,\
-0.8111545211857794646093,-1.4392639991852771430558,0.5337937550547192655515,\
-0.4149967301072188807787,0.7753596072101661684783,-2.0802067762281923890555,\
0.0857878546561958027494,0.6902510695334604928775,-0.8020501997457173404271,\
-0.4448276219158631139550,-0.4542741017673427861290,0.7497806557441212271797,\
0.3761686067694443580400,-0.5437950704705085680501,0.1952712229487395811933,\
1.4963569359039357031804,0.1448961397504171522144,-1.6571742156046651572865,\
-2.266222156481924709936,-0.6895293883454371997033,0.2295209621736973848449,\
0.5362163385171105911553,0.9313103118348207143384,0.6330960821019180340130,\
-1.0858111091662558944648,0.0887541886374976635166,-0.34952319730873010473,\
1.2435770678983146808605,0.3496891344866185913354,0.8861210080034624958500,\
0.8494363200871917207735,-2.6007673657870293837391,0.1208397242502698559763,\
-2.7285983994246283401708,-0.9589084058643195795923,0.5028677894031623463178,\
0.1177935239520793014867,-0.8303109816686591315715,0.1392963806792855974148,\
-0.7007200653415375235511,0.3010279059055253614297,0.2808756871176958935798,\
-0.3407758216783158822238,-0.1629402754377415607490,-0.9384370915542669111531,\
-0.9062708617577245329144,-3.8216620591432644005181,-0.4342151148359789103459,\
-1.8035270857235303765265,0.5183732162291515566110,-0.6322771366436347184603,\
-1.565814486101537061913,-0.1275146747340561437234,1.64064977802353451075,\
0.3863617690782851776810,2.0004008659625807098337,-0.6217884089242305956091,\
0.5238947303594374549363,0.6235004214546735479274,0.2053444204279457063755,\
0.8703948860420792632553,-1.0392069272746413677311,1.003277086375655047235,\
-0.592126107443248783646,1.4081926997371712051432,0.3085101089696197229628,\
1.3401416840168169919423,-0.1266586333113026985320,-0.6461594510334438545840,\
-1.0118098370918304773625,0.6188273552553577028235,0.3590555220619524590120,\
-1.1731665361057745933238,-0.6396350210213861409159,-0.1754282371769660675564,\
-1.4007581459609705909486,0.9435849228454418202716,-0.8904968184314612233976,\
0.2054651558278166589844,0.4710457442017800810952,-0.9616306477690889087384,\
-0.121221389008828367428,-0.4940626370918775878138,-1.6256998584585298228689,\
0.2527933604007285839366,0.9910414428133418329736,-0.4204166976073123729307,\
-0.3726016912019385896038,0.9512465231833235890235,1.9770278000388763484096,\
0.7942630050207910574755,0.2042467951135929216111,-0.4515030272861193516576,\
0.6146475682591936440247,-0.6290585121948016888993,-0.1427330253584118413546,\
-0.0603831392611861861308,-0.0118358773438195733624,1.060362899843382056275,\
0.0968488469273018626193,0.1916075762821658201585,-0.4096449181703107345065,\
0.3696227488734469268650,0.2664498618423789544352,-1.1169828984464544863187,\
0.1529016818054778348301,0.5016653096177513537768,0.3713737327704177415555,\
1.519060224335068820523,-0.1807259441689535728326,1.8139275887503047979266,\
-0.3257752015232963649360,2.1486960576842424330835,-0.1051361455427324009815,\
-0.2626851203928968758738,1.0103646188196337973864,0.2148110767207350724206,\
0.4407052420763278299809,-0.5122126723342420584473,1.2412118916908576604641,\
0.9766933236701691445347,2.039099736880281454887,-0.2559919392094065493382,\
0.5420836083333696597819,0.0791245311903027159772,-0.0955893777744002970387,\
-1.3712286813648302263857,2.1069701518694308184365,-1.189922581642507859456,\
-1.1599757893702906663691,-0.5696357256121767909107,-1.3015572133370920671069,\
-0.5449309642239419382292,-0.5067789559895423678881,0.6346443332238025369918,\
-0.6108333161328157734360,1.8419857567724760016858}

#define ZRESULTR {-1.0378404956328399766363,-1.133735695651125086059,1.0339197498326544444325,\
0.5531122148702418694910,-1.040340001858497842591,1.0085860369894361632248,\
1.1420720538989748149561,1.1056797792052726059353,0.5117972485274214777817,\
0.9070677525728206846978,1.0572990288526666891045,-1.0360972400059726972188,\
-1.1383229838393340571656,-0.6648420928164470167232,-0.6807443500487321275116,\
-0.8031597943350016199915,0.883947625424225447155,-1.269412549612109586405,\
-1.4161063395011512788813,-1.2859233456553140761969,-0.5672668801729759957553,\
0.7745318044293433290548,0.6947007749642374330179,0.4991201053193883852011,\
0.6140034872209438887580,0.096413007169791717366,0.8007709883951089624432,\
0.8792563999787510464756,1.0343346624696823088385,0.0302467913897976371784,\
-1.1472175673143576446478,0.3369832737151475243742,0.9907410521400105141154,\
1.0796900049026223467052,0.5594674889946016360653,-0.1560251223940891662778,\
-1.1705823062338804874116,0.4618385738778090776613,-1.3324797047631469215645,\
-1.1997345609820562195580,1.1160254294044837930500,-1.230501878395329207194,\
-0.6761086369817806973614,-1.0896592333865446899921,-0.6710881467286168300390,\
-0.5798029666713722107829,-0.6136654494083557676021,1.1617507290156328103592,\
1.27276401512989068010,-0.8120428578165023170143,-1.1072391191957589029471,\
-0.2233715590492064695383,-0.1434422451344934956730,1.3153998337128238738103,\
-1.0526498309129606045786,0.0553606627561369843415,0.7291584643384485531215,\
-0.8211933984789114848724,-1.1593353121271579020402,1.3152057671476293787549,\
-1.172801856026281397405,1.4071868225661712248353,-1.237749706635684621148,\
1.1803373520872921798031,1.5151506180989924299496,0.7531983030718831795269,\
-0.9762856051169326310202,-1.1612557605568909480098,1.4932305416569968681273,\
-0.8614722664300586973951,0.8618528735715539346174,1.1016443473924788509777,\
0.9393199732131509716027,1.0919198431908447854966,-0.9052324038739091305317,\
-0.9298866314213817263479,0.7633780893052066751636,-0.7143116680469970836143,\
-1.2127221047629597183715,-0.7227638256662162197230,-1.253501631676815275540,\
-1.4738165927959636647415,0.9413278434132237304510,-1.1484735264203178584097,\
0.3698862224535668929981,-1.0222624393360630890015,0.6231994143282580944643,\
0.9950036636352803665062,-0.2983226702432650867536,0.0176907017367243651895,\
1.2324636476429444709169,0.6361627801840686879942,1.1459319881374090410731,\
-0.7953680408910630550423,-1.4154164061425698051266,-0.0876282946873059020998,\
-1.5216557556403844664317,-0.8071142269969606708457,0.0815747053150205070349,\
1.0712377179167194007903,0.8666202597884599123645,-0.8619222017137594393787,\
-0.9481006227828882026998,0.1552413858057176687666,-0.7506128146087278629750,\
-0.3836715577045819447477,-0.5239185633043924594787,-0.7436026090030812829568,\
1.0616275053374448766874,1.4897517325664235698923,0.4367517077925673341099,\
1.3246660695183969380651,-0.9109135023203799308433,0.5553722323129884896886,\
1.3365545316217091187383,-0.9452504202661284882225,-1.24445301968662169756,\
0.6665795438258386163000,-1.314150441284937187447,0.0550695906884250130364,\
0.0202332991673926272658,0.9634857364192206397036,0.2836842504797497110935,\
-1.0552170344242444155469,0.9396260470070250114816,-0.9303925570132891564867,\
0.2783356640126000702828,1.1824291811858682610392,0.8685688319389791578473,\
1.1519647668153425446036,0.4220715686665841848146,-1.1065714015957384130928,\
-0.861924596730684333679,0.9073537157079681891858,-0.6218839294281949259258,\
-1.120015581786375724604,-0.9733844585621500566930,0.595029230494463101664,\
1.175230190501943328130,0.9508205283471821145369,-0.8508278968495206484590,\
0.1541098930310453307690,-0.8824217885955716322854,0.8902851444120675195038,\
-0.6639557596979325237996,0.1084368331219868891724,-1.2396941127079998956617,\
0.3226031789257856052799,-0.8843151570857661347702,0.5707126023897258759732,\
0.3012759106579737111709,-0.8367027089033168829602,-1.4909615617958020816758,\
-0.7009193727197650103378,-0.5098573775891588333309,0.6979392344955810401075,\
-0.11360619748546052499,-0.9509385591695135309109,-1.253860295053432105661,\
0.650797750208578995590,0.1772712514866976729611,-0.9640945137047890467485,\
-0.5689005122453275609118,-0.1250511412013994849701,-0.4037636514907702589561,\
-0.7926166698304296653887,-0.2823466357029139617296,-1.056824688357730357424,\
0.9537129762345133432433,-0.5025361511250948653995,0.4038372312258701746224,\
-1.356748408455357823854,-0.1106205947085566049237,-1.3416335800212069173654,\
1.1885949854017261451133,-1.3422443000337007656952,0.6375731708639520434190,\
0.3760968575323995755078,-0.9884746207385446403748,0.7854115858087797885645,\
0.999043445647114114472,1.033179400413832382810,1.1526308570666976560659,\
0.6867562899067288784138,-1.4009010309735028254607,-0.6940419760103245794269,\
0.5354681750957488439724,0.9063410461496741454823,0.2034358249367814175379,\
1.3295608151948998809644,1.5281379412739910517161,-1.0737486644518823286631,\
1.0727905584835071284289,-0.6577524210666327864061,-1.1372820311372766610702,\
-0.1467884541731124814490,-0.3758609793464613990643,-0.9135278670013463608868,\
-0.5879353157795642603745,1.3892627420568484097885}

#define ZRESULTI {-0.3299360864553753103223,0.5773236414575498853807,0.4991095547887292593892,\
1.0331094146354482532502,-0.3176151990967214233663,-0.0427672547155572568833,\
-0.5408736725419536206516,-0.1380553162115908116814,-0.1495803862615101287314,\
0.2075977110248564960759,0.1483156441793008761820,0.1814264210630067153396,\
-0.2481388687151736549552,-0.1914494023025192226406,0.0475995307877313186817,\
0.0486725512662827888843,0.0793454719839349342791,0.8749639413571212998022,\
-0.6896294045728997845757,-0.5086525074514365307721,0.2944098793875352670923,\
-0.3917506744074427116331,-0.1846852570799382420308,-0.3894217746197643492678,\
-0.5646100518854718641748,0.4746040014516990646065,-0.3015127179783077537856,\
-0.0002750414994330601867,-0.4738712470203229054633,0.6504861039469930217294,\
0.0770111005352082517161,-0.1450021418767060144006,-0.2504460533174687753011,\
-0.1242925201299330817406,-0.3767991401181884358884,-0.4132076872602681860691,\
-0.3870747570445600693745,-0.1287551829606753961421,-0.5591653729797143590474,\
-0.3808547758746415601294,0.0560087196606005033317,0.0701856173788610038233,\
-0.3788485405347551959743,0.0044895072328474238538,-0.4792093730891275327188,\
-0.0422815385429984591514,0.0061101098120875880007,1.3269258764406561823535,\
0.50216582477378490790,-0.3441118926473294425961,0.2204807457606408893636,\
0.0790893257779779063066,-0.1890021515648551142519,0.518665277550073300361,\
-0.8006086655024508003109,1.0073379811293934338323,0.2137094925844510162616,\
0.5375421998418649094376,-0.2320202834395212743157,0.3256990051992574852768,\
-0.5075425697148114867474,0.4587488944259289214145,0.8635283954295314146066,\
-0.1297869621390935479521,-0.852694676585578515,0.3180243625197139989424,\
-0.1362504231180562963566,0.1356147426873018091431,-0.5110906304654022624945,\
0.0364746671485365880905,0.3518205609306652159596,-0.1882338930265980980749,\
-0.1641509348055795458610,-0.1003678389496054923491,0.3533058939584889368568,\
0.1400753442460135889114,-0.3190262039403771177071,0.1130098866744752156288,\
0.4874882612585151875351,0.0821093566409674818773,-0.4196102828902398829136,\
-0.451423643355465198379,-0.2794721520836026540380,0.0388676985912680683644,\
0.5261724556813406339373,0.3369140501375452179111,0.5021943268293638240607,\
-0.9466008502228719923011,0.0813161752282447886087,-0.3647911127697049948893,\
0.9402058236775613364600,0.2373145443406108057172,0.1741667096823807936445,\
0.6110175965051998225874,-0.3276211596627106037438,0.1205074840878167241609,\
-0.3776545253138779423274,-0.8929722827626465075923,0.549792722962075375293,\
0.0271042479895461374539,-0.47522513055127707515,0.0593823102898174345898,\
-0.2798313897020670570903,0.3034375004902351569136,0.1544875118519504486603,\
-0.3064946913611272250044,-0.1233973071314871799986,-0.9748519593919268144688,\
-0.2695469774323944189831,-0.2398595153162375315237,-0.3849351067537384318840,\
-0.4832629774775746844817,0.2120502817724358168849,-0.5500280838647416681297,\
-0.6567358702149050930785,-0.0439088406752093027285,0.3215272662057582220285,\
0.252983359599071477852,0.3285524490410307585364,-0.7260295113781071174586,\
0.5814783672028649430530,0.2280478984411803411447,0.1921683660815579341996,\
0.2598222279442688464890,-1.2261944929533434844870,0.6354501028006451779362,\
-0.6350507146232319266588,0.5241840999802419576170,0.1326112979841672367964,\
0.5331634907909190701503,-0.1060363792025432461141,-0.1405159325068739140097,\
-1.2650277702054697481771,0.2669908129991411804838,0.2495345813255305800205,\
-0.3316627619047222141901,-0.2282918540535401608071,-0.1217152595768435791035,\
-0.4921799931736892674827,0.4709770755615852455556,-0.5858164911014823728053,\
0.2035859669317575948444,0.2043112301670926833630,-0.6450693837623580062512,\
-0.0755935103401305513726,-0.5356174761081086144188,-0.3471562389208797116957,\
0.2328317315621121486036,0.7651997819792383248583,-0.3199579280419243554334,\
-0.3582454315092570285017,0.7669246314230472316709,0.5441811107763497856737,\
0.6504831149102675569296,0.1580962824886572026806,-0.2872668874651375658935,\
0.7084196447067554469612,-0.2398740644903666341392,-0.0138893916104706732079,\
-0.0382724601233607325534,-0.0114683647521359316501,1.042906817386681339599,\
0.0689854613036876146426,0.1910230634709511876590,-0.3704134917614289590482,\
0.1911216797569713354843,0.2522464542416475996589,-0.4451672855349098623101,\
0.0515134584128001532521,0.4287903998263715155126,0.3315338614185490695441,\
0.7124742713592439047332,-0.1805296499983318203597,0.5024343285394804459187,\
-0.0459393453273769861167,0.3351247751616924785978,-0.0681623033986126780626,\
-0.2332477835758634543417,0.4789761892657505848447,0.1091019217623192538724,\
0.1355147604481500289708,-0.1428984493591255733325,0.3037123307940571281804,\
1.5115293287912119346572,0.4692494475562393740908,-0.154956179496453544386,\
0.4557841446769143045614,0.0301394028826129541099,-0.0919789120268482279785,\
-0.8385856266070932374390,0.5121474514176801440257,-0.5562655937076338430458,\
-0.4610543161770726539039,-0.4105611124291430047428,-0.5820664911774818817136,\
-0.5994113052598605273502,-0.4878070905668511203501,0.2712394281598410339384,\
-0.5014387951037901913764,0.5397742494143892288960}



void datansTest() {
 	double in[]= SOURCE;
	double res[]= RESULT;
	double out;
	int i=0;

	for (i=0;i<200;i++){
		out=datans(in[i]);
		assert( ( (fabs(out-res[i])) / (fabs(out)) ) <3e-16);
	}
}

void zatansTest() {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex in, out;
	int i=0;

	for (i=0;i<200;i++){
		in=DoubleComplex(inR[i],inI[i]);
		out=zatans(in);
		assert( ( (fabs(zreals(out)-resR[i])) / (fabs(zreals(out))) ) <3e-15);
		assert( ( (fabs(zimags(out)-resI[i])) / (fabs(zimags(out))) ) <3e-15);	
	}
}

void datanaTest(void) {
 	double in[]= SOURCE;
	double res[]= RESULT;
	double out[200];
	int i=0;
	
	datana(in,200,out);
	for (i=0;i<200;i++){
		assert( ( (fabs(out[i]-res[i])) / (fabs(out[i])) ) <3e-16);
	}
}

void zatanaTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex in[200], out[200];
	int i=0;

	for (i=0;i<200;i++){
		in[i]=DoubleComplex(inR[i],inI[i]);
	}
	zatana(in,200,out);
	for (i=0;i<200;i++){
		assert( ( (fabs(zreals(out[i])-resR[i])) / (fabs(zreals(out[i]))) ) <3e-15);
		assert( ( (fabs(zimags(out[i])-resI[i])) / (fabs(zimags(out[i]))) ) <3e-15);	
	}	
}

int testAtan() {
  printf("\n>>>> Double Arc Tangeant Tests\n");
  datansTest();
  zatansTest();
  datanaTest();
  zatanaTest();

  return 0;
}

int main() {
  assert(testAtan() == 0);
  return 0;
}
