/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2006-2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testCos.h"

#define SOURCE {0.6087216374946681218816,-0.4914009399790010834685,0.2966492127240239473629,\
-1.0120131171793795843428,-2.1768580524449996360659,0.0399891371904198267284,\
0.3264664449949340463419,0.3928915710000103755917,-0.9023248339668938911018,\
-0.7061054028011619632110,0.6351420537982425118528,1.7243031942788638044561,\
-1.193843423508647916265,-0.6699486724870092890782,0.9455390047179551560319,\
-0.7269584830448905243827,0.0587220167793607444873,0.7465722023081590164040,\
-1.8115798920517958148224,-2.7758706356233147083401,1.6672616062636114175888,\
-0.0836705642425854267952,0.3278617890836109105557,-0.4784618803967296551960,\
-1.5167866307363953026766,0.3278666902123760218402,1.4583399615307341967707,\
0.1568728504489345088,0.8788327319516627822438,0.6503974594047504664829,\
-1.2192475208695570110251,1.1760897921697979207067,-1.8443279857673484656289,\
0.7800878370874437806037,-1.7143820612787801227483,-1.2442138561935551788196,\
-0.5030865876060848229656,-0.7500891916411158710787,0.0131204357988426462828,\
-1.3051873378120935065283,-0.4721103394959948462706,-1.08171405175402890464,\
0.1772346225663179453136,0.0709726766378662859980,0.5997183167182360552516,\
-0.7982542475055777186910,1.1146919091581586336304,-0.5226194052411643475864,\
-0.3280122727754089528851,0.0845844607820355476324,-0.4076056231156577891461,\
2.671024580732940023609,0.2751537532064078916960,0.6141628828811964702084,\
-0.7694928564341785293124,1.5452838740749164081478,1.2047554263319388834219,\
-0.4418728868867642933793,-2.3845314085200706166745,-0.4507303538478215632068,\
-1.2843948816610906149549,0.6258568994217935665958,0.5221599455292258440409,\
0.6881147826420792590341,-1.5350411433640571701176,-0.9627472135269001807245,\
-0.5218069771892938080171,0.1257945676013507985136,-1.6629602539620385037722,\
-0.1168122168368753571732,0.6319751771097191772597,0.0279680711838030011951,\
-1.0789454333610759562134,-2.2539675570413915117740,0.0159524501831603895963,\
0.7246005623822228125519,1.3584241656028799294376,0.1335331404272114830256,\
0.8003059664568770159576,-1.5933335032689068810896,-0.2766963701941145270524,\
-0.1259819476132254256751,-2.1871819624452908392698,-0.0027183437417650840526,\
0.0895441283705892265843,-0.0655528187812533247314,0.0082181667448872272597,\
-0.1292799439278431716804,0.8059814954561199673577,-1.0227158239595737221350,\
-1.1728578375397291644333,0.3095622814458759419765,0.4085150016548139140227,\
0.4376992889872045044974,3.0932123457325086945957,-0.2404500241757465406334,\
-0.2553482065690487190501,1.0058683512127921666490,1.8395637792194936555035,\
0.3411429898658094317376,-3.0536685582128435534344,-0.1095788307430261981912,\
1.6414918920137913094237,-1.0744672373614887472826,1.5353378953533194373193,\
-0.8528406784492137404641,-0.7422456212235352124296,0.1342811638770788351671,\
-1.6549750406888592557664,-0.7256367869747750720677,-0.0862485588565954086615,\
-0.0561038363580659213414,-0.0030846890449726638815,0.2539566584786872027735,\
-2.255576969911772700073,-1.7353562843564334094992,1.4790955315931679781016,\
-0.6277258320505759714436,-0.874734985447433444072,1.7535503835541961237254,\
-0.8019918985373268860428,0.2826253943812546687298,0.9297345065408313402600,\
-0.1628091770786383452041,-0.5361503318172788912221,-0.1559543394910963276523,\
0.4214606760227143644748,1.9422068405845787086861,1.126122745997659491124,\
-0.3806596390838080656849,0.2838150495409667017910,0.5356418000869134221631,\
-0.8698259506453359657385,-1.4811954887734988250969,-0.6640101248288414748089,\
-0.8768395331826340788339,0.1637943427647920169310,0.8023136616688257838348,\
1.9190648920981443481537,-1.1659867862660415749332,0.9175250832331292016875,\
-0.4629851548188154697350,1.1531379126231540155345,1.280357188491430875388,\
0.8752030571429955108087,-1.80360898378670553299,0.5261137866109517613467,\
0.0015036147858927245008,-0.9395126502065724860557,0.1254332133415215488892,\
0.7981010350443900058792,-0.7787639258289269506008,-2.211373434923878722458,\
0.4245313340753193442900,0.4777310697112210347015,-0.7091015173222630085803,\
2.5269774755909995000991,-0.5189834616032670266961,0.7465455379507028865760,\
1.6922232637382539355286,-0.7527036628439752741215,-0.1791091421294778995854,\
-1.143803039940205490410,-0.3557089242818732288676,-2.5859928945830414903639,\
-0.4620292997028574988327,2.1043646801028508264153,0.2700104378784371483846,\
-0.5683100411735593215923,0.0576234736047250076241,-0.3494123351876678440497,\
-0.6437179916333417573071,1.1183843932324186720706,-1.7070244497383502135790,\
-0.5423910203569126675660,1.478528409100926088726,1.4635937207455358421981,\
0.9926533118110351106012,-0.7069946768514858703725,-0.7247022468472048561949,\
0.0958136359005943571976,-0.3502577985930430126693,-0.7552136456030923428173,\
0.4974020403078212582137,-1.1482817888259779781635,-0.2861580091485689814057,\
-0.5017215979538576231533,-0.6146143460074020570261,-0.8743941016318307335453,\
0.6112858348465053381915,1.1276508199848169766710,-0.6796253617896085286176,\
1.0967206821241466396799,0.3644470031679390431556,0.2076189090924974445240,\
-0.5458105472995297136052,-0.0671640776881476525562,0.9301013215147568846675,\
1.4191187165731935504454,1.9739542618337482249302}

#define RESULT {0.8203796801888452172591,0.8816726743563225721090,0.9563213494741442666225,\
0.5301548730715204271746,-0.5696350270974277485436,0.9992005409985472708101,\
0.9471814588690369296486,0.9238058529293791121262,0.6197871850499613310959,\
0.7608947481851529026642,0.8049874252319156875402,-0.1529046956055711559141,\
0.3680890208730970281081,0.7838535385146575551474,0.5853059322813873865954,\
0.7471992477828661716188,0.9982763577574981228580,0.7340210854728602685171,\
-0.2384636600673788464633,-0.9338657938993391027793,-0.0963157386477964672089,\
0.9965016599751398418405,0.9467330527147245211594,0.8877041448701339376726,\
0.0539834417486552073373,0.9467314744445589624888,0.1122194864288899307514,\
0.9877206673462950448084,0.6380503687973807513956,0.7958431986465404062159,\
0.3443523016260275904088,0.3845373047091283913446,-0.2701334763293031793197,\
0.7108517612540402597077,-0.1430928615933441672148,0.32080801483743826008,\
0.8760985949432102959378,0.7316280694838999121288,0.9999139283169750092028,\
0.2624969502467918158750,0.8906105597759395031687,0.4698159512131697135295,\
0.9843350146218102780793,0.9974824965990314318276,0.8254946325091827574738,\
0.6979579732366844035951,0.4404541009116093031039,0.8665146735535679267670,\
0.9466845833195259851678,0.9964248667932769087940,0.9180726139212290748404,\
-0.8913108719456435125039,0.9623834350402660220425,0.8172561425171237514675,\
0.718263617781651042549,0.0255096851968806929978,0.3579214307842031317364,\
0.903952340447022550940,-0.7268574491788566405148,0.9001291834726419249790,\
0.2825020879048804056666,0.8104614523160890149356,0.8667439221341659560949,\
0.7724446547102603588542,0.0357475654825572253248,0.5712673305171682702763,\
0.8669199123046601451748,0.9920982915300309290529,-0.0920335062605047438122,\
0.9931852073290609039802,0.8068622676403011118040,0.9996089189905136285219,\
0.4722581851967700972139,-0.6312557202207959017315,0.9998727623649044105036,\
0.7487642434889083542515,0.2107793581335721255776,0.9910976901702407415584,\
0.6964871898378746095659,-0.0225352686591101247782,0.961963168947402524900,\
0.992074764843193790398,-0.5780897184534614652307,0.9999963053059259809885,\
0.9959936026023269439733,0.997852183268367110003,0.9999662310577351886920,\
0.9916549805054094557377,0.6924034092861499622984,0.5210498486203913870440,\
0.3875187390378670992952,0.9524670084743368514424,0.9177117455650365407394,\
0.9057292314266010002655,-0.9988299011655918935304,0.9712309045685737496356,\
0.9675754035185222257098,0.5353549836201899614352,-0.2655433409023978952312,\
0.9423728774251888262725,-0.9961371662051550224248,0.9940022450449995661259,\
-0.0706366921418750404182,0.4762007884740003804680,0.0354510015922323284965,\
0.65784633984897000758,0.7369525027778347503471,0.9909978235616448971612,\
-0.0840793332663393455650,0.7480769942249303472437,0.9962828981406220973938,\
0.9984265925479938186271,0.9999952423505205079124,0.9679259470687455735316,\
-0.632503122148043273043,-0.1638182491633654591645,0.0915723300147998908738,\
0.8093652317898135661878,0.6412002458492904732879,-0.1817384524188947747536,\
0.6952764275967198148720,0.9603265844478726664946,0.5980467860661466961147,\
0.9867758355724630670025,0.8596815738538068352170,0.9878637498486452228619,\
0.9124923605358673528443,-0.3629301323805959045288,0.4301632279198022157374,\
0.9284197599136463363578,0.959994136496382766133,0.8599412360983218484023,\
0.6449595684306472787028,0.0894809955848772375919,0.7875272110120042912129,\
0.6395838526894777054110,0.9866156703762346547038,0.6950451267922697073942,\
-0.3412708317791682266495,0.3938437014688686566011,0.6077873470346980555590,\
0.8947232532371431901197,0.405621261011146261311,0.2863729991092465732017,\
0.6408409897588510650834,-0.2307152077489570130009,0.8647651606784810818240,\
0.9999988695715007480658,0.5901815182487093469632,0.9921435633684139165922,\
0.6980676864202854936536,0.7117823002210422744795,-0.5976582378696937425389,\
0.9112318735935986957486,0.8880403834946687391394,0.7589472311619362976387,\
-0.8169954127513406882954,0.8683238289487801297994,0.7340391936884439472166,\
-0.1211287602524158124595,0.7298432754851863490941,0.9840027922687679673430,\
0.414135922956764768177,0.9373998379717353168772,-0.8495842484392269744475,\
0.8951497493851807707443,-0.5086089166239101677647,0.9637681122030780089815,\
0.8428117284541520870533,0.9983402269892645009008,0.9395740596053013815592,\
0.7998698514817192961601,0.4371360854041511645462,-0.1358071578606558360569,\
0.8564769211630707257399,0.0921370549444396474970,0.1069973881579713986811,\
0.5464696941763740323239,0.7603174194154225240538,0.7486968394521967828936,\
0.9954133840567818136691,0.9392842830606296100626,0.7281251176521188472890,\
0.8788251271401545938744,0.4100551583355765972172,0.9593354263834207307227,\
0.8767558837388640391453,0.8169958925140410332943,0.6414617938312918710153,\
0.8189107275146941811172,0.4287832557249183773607,0.7778082340710044118026,\
0.4565162294470550552461,0.9343210101535780465198,0.9785245037094734144034,\
0.8547068075395470865274,0.9977453410917197507146,0.5977527578720709389160,\
0.1510966938752993093953,-0.3923250465140346587845}

#define ZSOURCER {0.8652785065984375245662,-1.3368838685782120645484,1.6264408224927449087005,\
-1.8690897079220740728545,0.9951518628175756164822,-1.688893672224414332916,\
-0.7497508971113807652031,0.8268999681758193442960,2.2753757356206412154620,\
-0.3872960166494098244172,-0.0799160908491712979052,-0.1884631346495315440404,\
0.2094439405660133701748,0.3401928613448036986533,-1.2494684410199645707706,\
-0.2979401746978811993394,-0.5157853813810977516852,0.7932915899466403963913,\
1.5620570356415210966361,-0.844359823617092053460,-1.0437648196696975855247,\
1.932990034770735388037,0.1853438341489616059121,-0.9962801836788344189699,\
-0.5388351087532706751304,0.6070505636662814064053,1.5888625026588754085566,\
0.2617832537783132407228,1.1970490473872079650874,0.12578128394682370,\
1.39770280807620150831,0.2099988595145213798876,0.3421775699723230701466,\
-1.8782261453279518459425,-0.6664189835307311460255,0.8127373993936040097452,\
0.3767873922208855863580,-0.6374952135371538819442,-0.974468710244571822976,\
-0.6722228555627711710230,0.8585099013504803311392,0.2446046980188737729467,\
-0.9043973313471151964649,0.1358880163960933251666,-0.7695067786636404782996,\
-0.8938327489087023458580,-1.9114553148531847615033,1.0171770494404650531095,\
0.1835886481619793952902,-0.3163377812153213564095,-0.9195862784206330076131,\
-0.1072018571251609070361,-1.7348283435296543153470,-1.0280015900042309695550,\
-0.1045837022850216735392,-1.5256722999247080974072,1.1084725864612092749439,\
0.6805135215035358342561,1.6689686098271181435848,0.2989927467898484958475,\
-0.5006434061857586437227,0.7116857998261418849495,0.2485278541920327155523,\
-0.6900291112600369647367,-0.6267355965803992345897,-0.4282667464892624953343,\
-0.7336468298863978443336,-0.3574021092257179676999,0.2860336762162377644003,\
1.1425687805503488281289,0.6919758815746888114262,0.8010668577124011591195,\
1.7767980155474207837329,0.197833004692656910795,-1.8362538605563030191803,\
0.3869279168511000066566,0.5325960336459322208569,0.0883113910959548165103,\
-2.6418732644466236259007,-0.6564988101863107328171,-0.5566003466732061255584,\
-1.479779603028395396080,0.1430519638431400619716,0.4320971393139262928251,\
-0.3181852113191626640898,0.5371570151959671468589,1.4535234978041589037900,\
0.3101271616559506116850,-1.340732344843439172166,2.060471964067395411746,\
-0.0787601433757613156317,-1.0771984898755455617447,0.5648344207720079612756,\
-0.3508614616179664413842,-0.9690830277765453137917,0.5156195652795886319453,\
-0.5293387239139798472465,-0.9571359764302782568990,-0.2269082544310593585468,\
0.4895059752188103407988,-0.2522128725839323237778,-1.4975804078553673903684,\
-0.1603766798935232218426,0.1464267186008629817451,2.1615853347433549025425,\
0.0399126120226646896594,-0.5544284809990485118902,0.5328414558183197646812,\
0.3907850242802237139550,-0.3787774013072854883966,0.8417359908290755754479,\
0.3176700186731257757877,1.592244506660871694592,-0.9951932381029318097632,\
0.0410951006109449151760,-0.5188832355843150390129,-0.4767385649438746209050,\
-0.3777777846485093071749,0.7910209775449256186519,-0.7086741723196363640369,\
-2.3537808974280172158444,0.3583714955858253170540,-2.508952017613233387294,\
2.087806522953977506063,0.2382312089001768218299,1.9833918106929020463980,\
-2.167582574594525635092,-1.401225926702102553278,0.4640426253451597760069,\
-0.3076759844353880168910,-0.7615259380675128975113,-1.1385700743993105721330,\
-0.4270402705994392755784,-0.0367498239842839885538,-0.9128849844856976591956,\
-1.9549432857416617626001,-0.8811112725878604834406,2.9821802878266292502474,\
-1.7022507648063245344616,1.2487885639051212738337,0.0676735499770482057391,\
-0.2367248998667950132813,-0.5285347231086527930444,0.7141648125067473484862,\
-0.5878970571029352720771,-1.1459325979718588683909,0.4680548872241794833293,\
-0.6843012596069305564228,0.5355357649056337043803,0.1540760632792411710668,\
-0.6157450195036280327088,-1.41787024661118454816,-0.4570344170862304378211,\
-0.1411796126420029884319,-0.6614438004746325816541,1.5436797442842080663183,\
-0.0655012358215935341921,-1.0114218055676069685234,0.1895887411932805077797,\
-1.2984646974992717360919,-0.5015613008687210827574,-1.162209366222186623929,\
-2.509167640329787563047,-0.4405707024000362626026,-0.3943332184880063984167,\
1.2805404560028668115024,-0.3061569333239507750832,-1.1420665340809226240282,\
1.0167026164121319986577,1.958453071130288769552,-0.8471715882458593638304,\
2.5258191429986913689731,-0.2048087265120654143491,-0.4182027716366760183853,\
-0.3527210857802417498519,-0.5595241893671244470809,-0.6478265699785845654901,\
-1.0507861982209916185127,0.7848448646063929112771,-0.1328983392812562724927,\
-0.8579290931640745077047,-1.0403775604411991118070,-0.0520608986196072903718,\
1.276568442453563045902,1.4203725991168176800983,-0.1287251249804796937592,\
-1.959471210760952208929,0.3404865901494299462726,0.3700863012564228338164,\
0.9399888255640819201275,0.4874471402488251836616,-0.9277526481559981164082,\
1.4687996535197915815019,0.6577767757776173951356,-0.2596038157216366548674,\
1.1286217610308955094922,0.0284581900701165874112,-1.2794761544488175708523,\
-1.1137434890242723373177,-2.2955389951107569856958}

#define ZSOURCEI {0.1918412521642277324130,0.4822328106056159024995,2.4722523083922975928317,\
-0.1999085627658134245443,0.2290361675784305939274,0.1385769022152809337722,\
-0.1308449665803144978948,1.8188246235702238973175,-1.360744719214450615397,\
-0.8851525561710794631765,1.8831231089443882797951,-0.7390687967111120304509,\
1.1162950684058663419762,0.5417636328738030249141,0.9074880499974204983715,\
0.1136822955664789497332,0.5661113725007503871822,0.7795296942845783005893,\
0.5870328147250098993482,0.0887163653774847987821,1.3588131422838234385608,\
-0.7770801239208607880116,-2.1816983571681287656929,-0.6867928574771322569603,\
3.132774112529277399375,-0.5876856927977032185595,-0.5468023513790022383,\
0.3644381766801820243806,0.9444714440193706650462,-1.0355805625638589972937,\
1.6339838311734231623973,2.3222150378340997711746,0.7603859366849585743608,\
-1.7528561088374936538514,-0.2830657824851525727894,-0.5082187590533610022092,\
1.2854936372804377509027,-0.1071924175739472628877,0.0680608377011317072780,\
1.2478214718780462622050,0.2022362844423137018257,-1.1601145695370460586560,\
-1.3732471859884713971667,-0.0871747108156779304533,0.3318121744832343011922,\
0.813877556086732623086,0.6766249185129517007553,0.2594423975862346631871,\
-1.2199874507987620297911,-0.9897424388234272729648,-1.5501341727479884813334,\
1.3236241898041882780745,-0.6342132090900320928739,-0.4029346079915554490469,\
1.3618162247590774871497,-1.2268551088323862430229,-0.0165544865341302541162,\
0.4697449293077746168557,0.5129232238932224241523,-1.2864890116754716942182,\
-0.5815154649104360418121,0.0042198993973377365435,0.4217149352171605802830,\
-0.3269590438815029309616,-0.2713027722538356445448,0.9981558319993941719162,\
-2.0584511427735407984585,0.6360071281896889638929,0.7792532924825519291545,\
0.8152290078526440719742,0.302690835462471330430,0.7846292874622610158397,\
1.3471935456922272678071,0.0235796939592457371893,0.8341783427284864549378,\
-0.8042305059271110945218,1.2811212643144183065402,1.109535684815037281936,\
1.5542750631114032877633,0.2918299696375577512164,1.0694551283559152743408,\
1.2577061015533308463432,-2.904044346742185922494,-0.2870782813229341146055,\
-1.2760057024544790849063,0.283985753428556031430,-1.3175328345022150333676,\
0.8988284250430720323521,-1.8112538507045783386928,-1.0995994665801063217003,\
-0.4449820788080595668212,0.5855247264136794749234,-0.7093745947817804431423,\
0.1905828492221817993535,-0.5445080014401588730522,-1.365437721272832805042,\
-0.6751146881456216997108,-1.1868018509166287088874,-0.8652762231421259331299,\
1.3117247998219794258290,-0.2796512899932403484193,-0.2218002038379895402009,\
-1.9751109128000410297687,0.1122673197507930292760,1.2555755229270146866583,\
-1.9515162530964744735940,0.1977614186013104402573,0.2974354172914404070838,\
-0.4957061458086293725955,-1.5054836292812976417110,-0.6943524973783626874635,\
-0.4602840002479897663079,1.3936515683502606055555,-0.0740340331806867979481,\
-0.6177784175603027172485,-0.2145874798022777973916,0.8980342752260660477148,\
0.0337374057866826476682,-1.1446268541982025368497,-1.2555511561156762478930,\
0.8386583904487018292784,-2.446562477109361033456,1.5119860122449106931697,\
0.1869337784232076582480,-0.3349553867803892748256,0.131542782393392315710,\
0.0174597275898690194873,1.778529610135566318974,0.618702552545296935449,\
-1.6771343167918386640736,0.7435693095206714620105,-0.5379787827929278787309,\
-1.5913674625260130213178,0.1780898508541619018608,-0.25671563034338790166,\
-0.2862788634729842573989,-0.4906498481756356722094,0.3900012521547605026662,\
-1.84205336065016078706,-1.5234366963806009742655,0.2365255965998115661453,\
-1.7320610820689275044515,-0.2834038205636343343841,-1.5009852265404577398300,\
1.7422292049682128745047,-0.2436614706579122158203,1.0689605525655874185276,\
2.3690635117400145048805,-0.1930577380634317663510,0.2735573868128330365934,\
1.5569516288681788385162,0.7150292123422491430418,0.5468099984878278529976,\
-1.5473048247641658647922,-0.4396944448158471852039,0.3112403247843043563314,\
-1.26537605009678144619,-2.3950841704590355440985,-0.2592078718414222993083,\
-0.4387845364322502383914,0.7187054098642295940635,-1.2095433748027486497989,\
0.1746582197927172008800,-1.1207357315790709151315,-1.2331864421831437717003,\
1.040361177077658849655,-0.7973568364198504454521,0.4368277956791839500283,\
1.3732228487397339922182,-1.520585040532598242180,1.0844121210894082096843,\
-0.6034908039898051468342,1.691270204422151035573,-1.0147637811434373489305,\
-1.543831005555790003569,-0.1908715944289217369967,-0.9777526617402377828725,\
-0.5011593951678696701180,-0.6581745867398813842897,-1.222568274664002307972,\
0.5739764929054486097826,-0.8178919175936580909791,-0.0839772392176704185474,\
-2.2467727407263837768880,0.5311634003342166066020,0.0127028917577170375602,\
1.4336465735979566638036,1.140130846486164140074,0.7078292602873598182711,\
0.6419172762011019495176,-0.7752020495699509794463,-0.2227250211522007472542,\
0.1418062472773869153730,0.3461143754334283229035,0.9346610138588777871860,\
-1.1766714696487656777180,-1.155321545637316260624,-1.0348373990480448370022,\
-0.4377198927182634480282,0.5342901632756290597470}

#define ZRESULTR {0.6603968316049805276080,0.2592621892570787789367,-0.3318454617138371642859,\
-0.2997813790812504652905,0.5587163403231363290047,-0.1189561420345783687713,\
0.7381324458324397541631,2.142136719995466176414,-1.3458078751828295160919,\
1.3129764303388649082649,3.3523257180963095258619,1.2630048090441925445759,\
1.6535623505413692413413,1.0844508507590295831591,0.4550473771130031930277,\
0.9621269818830543441024,1.013062998048058771516,0.9256575460351638140466,\
0.0102887155976816024872,0.6668255580964917994535,1.0432946799591633624260,\
-0.4668000327046901709593,4.4102457143090099123128,0.6767097030615227826189,\
9.8624279257033951040512,0.9672974379596046556884,-0.0208338391589294388839,\
1.0307881917288705952984,0.5404196044618572170037,1.5733521090107187578866,\
0.4580812522816201659559,5.0350486020971887413111,1.2277369531593618212639,\
-0.8994082908263842934815,0.8177424613018864363312,0.7782283917530580241717,\
1.8099404305650070856615,0.8082102149385829159556,0.5629089875114635654896,\
1.4748501127652635656062,0.6669768846821123586821,1.699726699407153374111,\
1.298577834389474938703,0.9945484939786765066216,0.7581576733086236030701,\
0.8456096567246286221931,-0.4135520032774342991111,0.5435636589621466452371,\
1.810248147243165517395,1.4551350063240526822028,1.4924370356604863552263,\
2.0000431078502241000194,-0.1972543510483453221838,0.5590324784918681011447,\
2.068372118994307395923,0.0835345805491203158288,0.4460902185747692705320,\
0.8645923158579836842463,-0.1111931823350623821378,1.8617144830169030100819,\
1.02983082411914805832,0.7572686801513547338871,1.0567502136654132183224,\
0.8128189945963255613748,0.8399378223031567225476,1.4017511305320988768131,\
2.956644273924759147576,1.132754400798835492381,1.265693867178816711672,\
0.5610629520868651853860,0.8055306977755860575741,0.9213852223586275203004,\
-0.4199962882323669544071,0.9807673830270958736932,-0.3590470367287647013299,\
1.2420524197984359471292,1.6706050779946230999684,1.6747789118158156185245,\
-2.16927668845889520810,0.8261050353521025568782,1.3826822282594428692448,\
0.1727680624199215975167,9.057823043102500193413,0.9457668311290795548629,\
1.833812877114292083647,0.8940453644463330906689,0.2341249670166324903242,\
1.363576337757532064288,0.7162232362688260023376,-0.7845189065148089335722,\
1.097237008647440115183,0.5573625517969845732935,1.0662662205819704031029,\
0.9561831479074293094200,0.6520642360884429944434,1.8151009640860991112277,\
1.0674278234021243871865,1.0313090898160910402481,1.3624555698791520619295,\
1.757155073751679230654,1.0064753136983999315390,0.0749572440340378898238,\
3.6259465360107721032534,0.9955398364095786600814,-1.0568745874589622336,\
3.5878460752889553830869,0.8668812254131966765769,0.8997505054992860351604,\
1.040555384796898463762,2.1965462296781987916461,0.8333142225488954224488,\
1.0523855335407785727142,-0.0458709738274477793474,0.5458332569596060501738,\
1.195961273756254605871,0.8884437146730177481402,1.2715015087988947861675,\
0.9300156339115848158627,1.2162605499523735375078,1.4405129668915395146911,\
-0.9683533444224800001976,5.4479898316980985839564,-1.9178644985834492064924,\
-0.5029446665597729904107,1.0267816742413071740003,-0.4044626121435637711166,\
-0.5620727987859718277619,0.5138734552212488315703,1.0709367349326839313761,\
2.6385439370616894372290,0.9332628709668898681073,0.4809878535892211925962,\
2.3274184357315248483644,1.0152140200890447108151,0.6317250697033859330176,\
-0.390230756302790915413,0.7144330074150475606842,-1.0633635201019895344388,\
-0.4238985166974506557658,0.7604701169947127858961,1.0257495217324759106958,\
2.8333209029821588842424,0.8984586856426056700187,1.7791621377373312284931,\
2.4485583447413197255571,0.4244935342539479794510,1.4527777983860266086680,\
4.1768674382240673637057,0.8760717584983536143639,1.025358467451832122919,\
2.0225373659775809365158,0.1929591577071132768584,1.0348979760988403775457,\
2.4313713775277490114490,0.8666224950927583492444,0.0284371329577691699109,\
1.9091763626738669223926,2.934604495210217045553,1.0152593733387236252241,\
0.2952893892910067874524,1.1132087589342971600814,0.7251532821639393722180,\
-0.8189305685602711326609,1.5345662883929571673747,1.7188713168135731912400,\
0.4555641729620423796554,1.273008943337736509349,0.4560137683691281029752,\
1.1053164018215166919390,-0.9060167575034622222674,1.0910838839542402745053,\
-0.9695473009615381831949,2.7466955042474223702698,1.4261078323829836644876,\
2.297318046615583586600,0.8629928731306283351543,1.2099030156571450866920,\
0.5606054313387058840590,0.8663522170995916482639,1.8289146898108739058841,\
0.7647265415048952741373,0.6847484857113015355168,1.0021685183539132957264,\
1.3866261204365910586489,0.1714987437851132057176,0.9918063704778133926609,\
-0.8398571556569223162114,1.624536447087556512159,1.17576217917109437927,\
0.7155426268638502840247,1.1625689563760244205071,0.6145684296686997338810,\
0.1028453801776162412907,0.8392286126386587774562,1.4202930257299617444744,\
0.7599315975784372012569,1.74429364867563263530,0.4552293130713663815712,\
0.4842614797058485409664,-0.759839135565466450295}

#define ZRESULTI {-0.146941580724984616202,0.4874941601771347610139,-5.8732506000776529830887,\
-0.1923557391894928081388,-0.1938092227520436805488,0.1380525220047903456333,\
-0.0894197912409416678647,-2.2083871916990625017263,1.38762940282270652581,\
-0.379707247416236348680,0.2563331150684992620903,-0.1514182976925468326890,\
-0.2833925825567581990860,-0.1897432487381172094842,0.9841855659814751078329,\
0.0334435644614089755411,0.2943712296517632109882,-0.6135431940236653058918,\
-0.6213108038265401367184,0.0664065988188502348555,1.5707022449109617756591,\
0.8020378110570226537490,0.8061058304221635495423,-0.6229364595259883063960,\
5.873854580840536243613,0.3548772564844954735541,0.5743671991358663131422,\
-0.0964195772855189620065,-1.015948375800173053563,0.1544112964905340057431,\
-2.427720301875694985938,-1.0527358981959802353146,-0.2804463002040958885530,\
-2.667664304679369102757,-0.1773304122311009645152,0.3851475525760940099573,\
-0.6144403782537597447089,-0.0639215126270850642065,0.0563572709924226103451,\
0.9949983775946195097006,-0.1541120072724549983079,0.3483472405495082191429,\
-1.4521802331617248427165,0.0118245383836800051908,0.2351284238449595775933,\
0.7067939417094389886742,0.6875306193270583898780,-0.2231728770983253673510,\
0.2822282491943420845715,-0.3606863345205877369182,-1.789492973412827536706,\
0.1867542931864467348202,-0.6684973125435003105110,-0.3544323112754915183764,\
0.1903651481757896168912,-1.5570503331148395353978,0.0148172477875626266292,\
-0.3065501441038122609761,-0.5331323204569118345830,0.4924734236714592428008,\
-0.2951210995789439461845,-0.0027560721209946860942,-0.1068344484336290478588,\
-0.2118570413928013151939,-0.1610793407630224660654,0.4868738628243398092188,\
-2.579960937463402714798,0.2378086541486917060428,-0.2428029308169650513083,\
-0.8265359232776167131007,-0.1960976284506159017518,-0.6230605514253650945022,\
-1.755406116186124965139,-0.0046349019875992188491,0.9016172621635419881514,\
0.3372605888766848636351,-0.8436494304870341132130,-0.1192082555849750258314,\
1.0830200228715931576318,0.1806566116072005345750,0.6790264707808069122308,\
1.609828137915977341876,1.2968382390971706641380,0.1218796661012466753249,\
-0.5166846594494688416077,-0.1472753279361777856149,1.7212963380251158351797,\
-0.3127599294310591804269,-2.89888504993117113173,1.1780998114195078141364,\
-0.0361775267207019371463,0.5456053298268405127303,0.4123679880285295307196,\
0.0659019050150095875296,-0.4713866341281334748636,0.9028599597514885832794,\
-0.3674007976866919822356,-1.2146233237644410429823,-0.2198736582857065691154,\
-0.8094828887322721433506,-0.0706994284778254822310,-0.2230241649514515533959,\
-0.5643984283124198197967,-0.0164146852495472492239,-1.3391611472776376867699,\
0.1376079760459386902571,0.1047929421413649753170,-0.1533297870650806860038,\
0.1966501815957944765412,-0.7921571860524847519258,0.5604745942609183906313,\
0.1489022072975806909589,-1.8902500881495403195487,-0.0621612461401919516590,\
0.0270260228763795351536,-0.1072348104191992446133,0.4697601544599027123539,\
0.0124466007411300864927,1.0036512376933612866736,-1.049412060795365198018,\
0.6666269392002136529030,2.010144371510963257066,1.2757551800142050701936,\
-0.1634497680436179101182,0.0805305413426501415231,-0.1208519512813724661182,\
0.0144424770778995917309,2.8348773781599185817015,-0.2949185744370810824400,\
-0.7818376664535492404084,0.5616872313168002062156,-0.5124110438039969350754,\
-0.9747306641614861266731,0.0065779403553887496811,-0.205370183808804979142,\
-0.269054670595636091779,-0.3938808526857590086578,-0.0634893958645683514908,\
-3.0489600352607997280074,2.072697136598120604134,-0.0161438616695122189038,\
-0.6420425137334005993850,-0.144832386550082847787,1.3961681016866522853093,\
1.534869934827646220654,-0.2242019675630647912445,-0.5795004710241905554469,\
3.3483419852888491874410,0.0991308462877908275201,-0.0425076535895645771235,\
1.309216767461068409162,0.7684601350295457988793,0.2535070961278987344834,\
-0.3156127379694732559834,-0.278872470151356244283,-0.3161734445550384298151,\
-0.106765701893629952335,-4.6100082079818358593570,0.0493978828262259944681,\
-0.4363059774746961272385,0.3760761368145200678192,-1.4011279329067940491171,\
0.1037666142610354780285,-0.5844725415055048722834,-0.6033334328120393275086,\
-1.1866522252940947534938,-0.2666075239397875384917,0.4100487177769164826024,\
-1.570972740050773142073,2.0165334475753500242945,0.9815781508770222707483,\
0.3701172711568467832421,0.5330671903876023076663,-0.4865756887562372456912,\
-0.7719024118076073248673,-0.101927682205751976574,-0.6886382760934363078675,\
-0.4533487312581489514507,0.4994598581237761347751,-0.2054810163364952091403,\
0.4584447177031794051771,-0.7868410449880314239124,-0.0043750939988532102504,\
4.4747804523350742655907,-0.5502105833706960602569,0.0016307130557308498371,\
1.83024619927524345719,-0.4687597592810309743427,-0.2779394557997144632466,\
-0.5547224826362566751925,0.400556327585974369931,-0.1797184375596841132694,\
-0.1415425280521077078255,-0.2158502978608074218680,0.2764160437046866980459,\
1.326476685000083532984,0.0406909700160508550071,-1.1778701919064038516893,\
-0.4054547584096580559176,0.419311934137157338309}


void dcossTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out;
	int i;

	for (i=0;i<200;i++){
		out=dcoss(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<3e-16);
	}
}

void zcossTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=DoubleComplex(inR[i],inI[i]);
		out=zcoss(in);
		assert( fabs(zreals(out)-resR[i]) < 3e-15);	
		assert( fabs(zimags(out)-resI[i]) < 3e-15);			
	}
}

void dcosaTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out[200];
	int i;
	
	dcosa(in,200,out);
	for (i=0;i<200;i++){
		assert( fabs(out[i]-res[i]) < 1e-15);
	}
}

void zcosaTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex in[200],out[200];
	int i;

	for (i=0;i<200;i++){
		in[i]=DoubleComplex(inR[i],inI[i]);
	}
	zcosa(in,200,out);
	for (i=0;i<200;i++){
		assert( fabs(zreals(out[i])-resR[i]) < 3e-14);	
		assert( fabs(zimags(out[i])-resI[i]) < 3e-14);			
	}
}



int testCos(void) {
  printf("\n>>>> Double Cosine Tests\n");
  dcossTest();
  zcossTest();
  dcosaTest();
  zcosaTest();
  return 0;
}

int main(void) {
  assert(testCos() == 0);
  return 0;
}
