/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2006-2008 - INRIA - Bruno JOFRET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testCosh.h"

#define SOURCE {-1.205685175775274453613,-0.8333271236779051793775,1.2335774322243386880160,\
0.3311018349037936903123,-0.8052653369328224286505,0.1998487851928297531767,\
-0.8705427356398579563646,0.1975294304937466050021,0.9239335793216870706956,\
0.2378506537628061745515,0.0049366873129022617595,-0.669236585027300545647,\
1.0653101376824569701540,-0.3369456198746673680766,0.6204667311042414423738,\
1.6283002068610463730636,0.7206914942876857521625,1.7221990362694574727698,\
-1.0902216302137626158242,0.2874486754733126536721,-1.2122889745482419154854,\
1.8215917027079053802652,2.8016558959521908889201,0.4050930510541474460773,\
0.0617355341334478585624,-0.4301267567705842620462,-0.8284509700102783424924,\
1.0256901078279201389165,1.525021231170059277105,-1.3197460532844016434240,\
-0.4460647093896898951471,0.5045503141647188494190,-0.8098965560197782798113,\
0.4268132043604428993433,-1.1336964590865461488534,1.127146072313511160345,\
-0.9122705295277132586662,-0.3089065753248803058995,-2.3178211651402826909418,\
1.1439933378277502562526,0.7005552213939509886842,0.4233298618301614135717,\
-2.5208275627904130899992,-0.2816183187535069021301,0.7467093404219694585677,\
0.7637510409783198062073,0.3396503036180347767647,-0.9747149605661590276995,\
0.1472242280982364037722,0.9901921384491637612157,-1.2197737051905059857404,\
-0.4607952353595122785279,-0.9492383290419380559300,1.4160381392623584417834,\
-0.2758297498115374613015,1.7324484611160422264931,1.1368999048747294722261,\
0.8568173351546003457813,0.3519313905007281362280,-0.8897875910518927566883,\
0.2244273879422930551009,0.2394303391704008243668,-1.0382487030291693841377,\
-1.0129167707607047432816,-0.3443356316152397234021,0.9904626758703307665144,\
-0.5700286524862564485616,-1.2143893416629112369520,-0.7653327397314562130504,\
0.5932733856160632424093,1.0109636831448121085941,-0.2591906321322083317504,\
-0.6337213759172125593366,-1.3891534527523830000462,-0.7588209965122667544080,\
-0.7751521002127067516696,-0.2569588781664822740858,-1.1144881209346948480743,\
1.3683403773429958505403,-1.3171565382517111952865,-2.0066059395312958457680,\
1.1665757372971858885080,0.1803963656727911035738,-1.4583403177666438566007,\
-2.0738880513575592701159,-0.7736713589363241050378,-0.4690505767289738225934,\
0.5290181646318501407222,-0.6366436437236088208280,-0.1514973533385992610079,\
-0.4939237897364461837846,1.2009977647347911400288,-0.4479171393972471992839,\
0.7962022364285237241432,1.0553131168098721648363,0.6399283922940391944323,\
0.6404945676646236485396,0.4718907579921589601213,-1.1669004068172705856909,\
0.8239670665751658296116,-0.5209824870944876895607,-0.5564774733886624913382,\
0.677433403214317775287,-0.9826152250790042286255,-0.2301482766849789196595,\
1.5256623976111793883348,-0.0141042499939363699668,-0.2206563911375283293381,\
-1.2404617973010751974527,0.4956722425079039262563,-0.9198528977539149886766,\
-0.9204208417497926619788,0.8313756689801026222852,0.3180154749624292120913,\
0.2494121392443543194783,1.9786862305439512077498,-0.7539887840478504132946,\
-0.2522144002260635065049,1.4817018679370650424687,-1.1886013018444978595056,\
0.3497827881131843619222,0.0164051036269147361424,-0.3356971818656850903295,\
1.5387250556465030815190,-2.2939395533776552049687,0.5463520678571377464650,\
-0.6249598247747292223409,-0.3795057983233444121041,-0.6817850926970092650947,\
0.1137639445438838742275,-0.3667643438770555319728,0.7811095630972452186214,\
-0.6491897518190495874890,-0.4116889792407164572197,2.2135576248798094489700,\
-0.8117887004060938549443,0.543890637094475826174,-0.4300056333049381840361,\
-1.1073264735386671997475,1.9600404811338050237168,-1.1810889471038799047875,\
-1.5998650464994574882382,0.2370987431342703177783,-1.1837915340560738464148,\
-1.3250738110530209112881,0.9867165393345800339375,-0.4254735979103318466166,\
-0.1977286302171261667127,-1.3843612904745590252986,0.0058770971600078198913,\
1.6513137110120594819307,-1.9479686718307542836470,-1.1853539723928359084226,\
-0.1952876876932538308118,-0.3910952467587283098993,2.6051477231429984726674,\
-1.1685665444554920178177,0.4303553159707447783866,0.4980619697002917622974,\
-0.5945099409025637049453,0.6251723753612481448982,0.5667367529854526742028,\
0.2583522627447231712061,-1.117334797621551301106,-0.1572947959550771157566,\
-0.1675843890566963978461,-0.4415529643720014774111,0.0296777742804143623845,\
0.950535269366517221457,-0.2023353295590510914082,1.2240649283812428116391,\
0.8408743467009373029342,0.7289489292828028599303,-0.3650480390020546805907,\
0.7141089622210116116818,-1.6330473677930090747878,-1.2120035333729530790947,\
2.5522160888662996924836,0.4631064145940361198583,-0.0364246441804653570129,\
0.7308349560709582748430,-1.059234312724760096458,-1.5608743035213317185,\
0.7865883787823105821602,-0.1899223202317779357617,-0.4035214553331447628892,\
1.4993140466900047869103,1.2050329976249689600820,-0.2109320691913422751718,\
0.0478227589320652582416,1.1080187662760754285785,0.3698710666565526716809,\
-1.8629885917707584841452,0.1117850228517819205498,0.9930250182564113181627,\
1.2533428090752711803191,0.5303160507909902010582,0.2252859052932770778099,\
-0.7558035543285445134742,1.1653980888802857318609}

#define RESULT {1.819266428064204577097,1.3677812549451693335811,1.8623697303215194231996,\
1.0553168123818659207558,1.3421296845542964870646,1.0200363222965405096687,\
1.403465448863383979727,1.0195724536239654245406,1.4580674176636316818900,\
1.0284200725097112361084,1.0000121854655601438822,1.2324226844271635172845,\
1.6231798706546742838697,1.0573052784271492754442,1.1987446423322825062030,\
2.64573472675944731947,1.2711350583337506225945,2.8877476825709762486838,\
1.6555376604226368364436,1.0415986209192817923963,1.829342489722003417540,\
3.171729047671292711641,8.2663047019615358834699,1.0831783845382449982253,\
1.0019062434070211686787,1.0939395186073928023518,1.3632471669518277934685,\
1.5737842316817938215223,2.4064287835907673951397,2.0048370085520934580359,\
1.1011474483510161892497,1.1300087947090773354830,1.3462897763229764169779,\
1.0924759182927643585970,1.7144810122297002852321,1.7053954010120264683792,\
1.4457904936509571314218,1.048092245021622570533,5.126007634597746331906,\
1.7289119973762236970316,1.2555903810189259495189,1.0909502538663513604433,\
6.2596397068650517780952,1.03991721163594563748,1.2919843250699158954120,\
1.3061137606130501787050,1.0582378205813938176760,1.5138557575271749389145,\
1.0108570760043096292691,1.5316284576789631621807,1.8408591504389772985917,\
1.1080580118223748442574,1.4853883271417620548505,2.1817178624460376035188,\
1.0382828245407387246502,2.9156663093555850174710,1.7189510624849844155904,\
1.390081256029065626123,1.0625696729809925855648,1.4226777259325882329932,\
1.0252897080419871578272,1.0288006377558764903313,1.5891703898572226982822,\
1.558389589207426872974,1.0598715893830090717,1.5319423704594259394440,\
1.1669134763143933497531,1.8325639262468249590654,1.3074443355436990987783,\
1.1812094824791219416227,1.5560581683472911596056,1.0337783603024415235438,\
1.20761220067196339834,2.1303694894256701708457,1.3019874017358665785338,\
1.3157780065006974279385,1.0331959861022277369358,1.6880453716815839726451,\
2.0916769731603670479103,2.000344096331303500591,3.7862367743494589333864,\
1.7612050492619382158210,1.016315598810441089839,2.2657204820986769355784,\
4.0406956659153259181494,1.3145132010698166169504,1.1120358920747182018829,\
1.1432241110320022769997,1.2095957312624510127108,1.0114976895400229484068,\
1.1244804773055134816673,1.8121625561683152305648,1.1020033178144590380043,\
1.3340717665795371882353,1.6104789889363373411868,1.2118376325588768871455,\
1.2122253780682052948237,1.1134219567585550425548,1.7616758393639733171199,\
1.3591064226145659343814,1.1388088791439558988827,1.1588706347019575026991,\
1.2383685118981913042546,1.5228821862471519921201,1.0266012226158198750170,\
2.4078326713444666573594,1.00009946658283555010,1.0244435586923690273409,\
1.8732301190987417083278,1.1253813439974511556585,1.4537494816372256156711,\
1.4543489946263667977888,1.3659627989922018542757,1.0509945293445170921842,\
1.0312647772215886021741,3.68574234301369418887,1.2979736367142225006432,\
1.0319750139115386744493,2.3138394341351444793986,1.7935669311616093679618,\
1.061800258350523940010,1.0001345667304306630285,1.0568774415753066087120,\
2.4366507835843460583192,5.0073927789679837374592,1.1530000373394655444059,\
1.2017269174685778487799,1.0728807813362080114672,1.2415589372685298386045,\
1.0064780997777151849704,1.0680153713756039834948,1.3208958764713327749263,\
1.2182291644802725194552,1.0859476120918869490595,4.6287577582643999463130,\
1.3479977392146349490787,1.1515908109414143556393,1.0938858068153072267137,\
1.6783490081276506433738,3.6202335893551729206763,1.782432142455154355787,\
2.5771439034538188295187,1.0282398297270358700217,1.786426290897340729558,\
2.014123198363930722365,1.5276055774381211982,1.0918876182447221356853,\
1.019612078038364622046,2.1213794605936713288941,1.0000172701852236833986,\
2.7028112826383159372767,3.5784939357816578642257,1.7887413660887121480414,\
1.0191293197498234590626,1.0774575372953134611009,6.8035582731627464170288,\
1.764094760751516499653,1.0940409161295887585652,1.1266181837435944590453,\
1.1819878003429369339727,1.2018685976750431709803,1.1649400331120620677439,\
1.03355898490236453036,1.6919235891909962798962,1.0123963536864837298168,\
1.0140751587041334502715,1.0990787112389970303639,1.0004404174672476557362,\
1.4868140745992959317334,1.02053972356750688455,1.847508472372893173485,\
1.3748631970003435398553,1.2776582369190518928548,1.0673732569157268201820,\
1.2659971203245654614022,2.6573926189895762384197,1.8289053177424414720065,\
6.4567128779259412851843,1.1091640429888753871523,1.0006634506999989575604,\
1.2791603587689326371191,1.61544148317066760256,2.4864680737312045977205,\
1.3256439332679719189656,1.0180895207546800662612,1.0825255238019519943293,\
2.3509495822805339670936,1.8182756477804529193776,1.0223287733363202178793,\
1.001143726087694751925,1.679282557162007583074,1.0691856802487731403772,\
3.2990857486037623580444,1.0062544545151006492034,1.5349210973541418390198,\
1.8937893477592186997072,1.1439441561926790846826,1.0254843822262098562703,\
1.2994774746280413069144,1.7594989466591723914490}

#define ZSOURCER {-0.8912345066950769778558,-0.0058415661764856371616,0.8327394520710053038570,\
-1.3031116495573464852953,1.3063996947557070527068,-0.3291212350984021872691,\
-0.4314780628860441225036,0.3257069146291299843732,0.2704533752036020199938,\
0.3948286552396417792288,1.7413456505609685720515,-0.0929389968439678221257,\
-1.7740482961163070996236,-0.9310406640182858906130,1.0558482448966843847415,\
0.5302093445317125341987,0.9099214704748677107204,-1.3248358105760951186625,\
-0.5468817390748145212953,-0.8462613338460863721124,-0.8447436284186202737345,\
-1.201032047282137193989,0.0724835993626015417934,0.0038054949984360143984,\
-0.1410382163048108095094,-1.7842189597096504982687,0.0501420738427398662851,\
-0.2334922077300364828822,1.5945984531602754863400,-0.3238241601909672695569,\
1.513308285995593083229,1.5778451444411625281816,1.3691912706993336623640,\
1.748251159750787042668,0.6019009531079806407661,0.0153371667399079970179,\
-2.11368074169300124154,0.0736235546297408505190,1.16364818469077779817,\
-1.7239586420846975123311,-0.1812698216235553161368,1.3506264987504341679170,\
0.1572244306209917286132,0.0637660966151842728555,-0.1712993899334549763314,\
1.9516485698976029361518,2.845403039274271073111,0.2554082947132658709677,\
0.3587738434809014664850,1.6800084635178351710749,-0.7143150645295742728891,\
0.3176042681985608573392,0.1918613409687800752668,-0.8669525494355047046113,\
-2.486482303849266717322,-0.3399076190046602663486,-0.0275599140270330646152,\
0.0760891140551305106277,0.0175525149136643889014,-1.0447511992604696651199,\
0.5928194662003063442057,0.5337685538183976063920,-0.1083277352156265110894,\
1.3163705916013288543809,1.6481947619041572572485,-0.0366427588652487520871,\
-2.24532677610144792979,1.1646157862674424432470,0.1931514629705824159789,\
-2.0280558458213828743055,-1.588195044157987734224,1.217389599860282611843,\
-0.7923310676779923289459,0.4657912238712272334773,0.6341322794098591675294,\
-0.2308714073795904986319,0.0959191686134504700734,-0.4119590516116395373380,\
0.9909317687163362586844,-1.1184985773424866994930,0.3764360122586650203580,\
1.0283807947333536425560,0.4399875767202614529339,-0.4587329057670580523265,\
-0.8383371473991714228902,1.8010370613667443517869,0.3638310348854316700340,\
0.5630372956104594539539,0.5158868637708874382852,0.6872616626544041373847,\
-0.0355020269914341005113,0.8259138693919667595367,0.6872047295901000385498,\
0.0739287007414783509107,-0.7662836697323893719869,0.4114094358620231095536,\
0.9046891131020067255974,0.7464765051550138474923,-1.2447871833324788415354,\
0.6121845724663061982795,1.2932746927561220573466,-1.3794546951962081138277,\
-1.0054979370864329801805,0.304912140043878954199,2.2462341404304981828943,\
0.8089620929537136850840,0.9035087652875184449641,1.3506573247795918835124,\
0.7844818177699410810533,-0.0679273669198190016560,0.4928294105013013015615,\
-1.096446680245239946316,1.737658266453646849214,1.2019686032899719041467,\
0.1928095667884118236124,-1.5186389453508686298022,-1.2473448039026917566,\
-1.489337044442988755577,1.4654430117361589847036,-0.3194353686893170451988,\
0.9845148496238763646815,0.6602210723100759848236,0.8588563891948870487880,\
-1.9910804060218119104775,-0.6479512615308331557884,0.3691293678246713727553,\
-0.71770775009329423888,0.0044545145586906377197,-1.7569208392800599316530,\
2.0338706868044176268029,-2.1630248696548646236693,-0.8178753147165283010622,\
-1.3281476236021181325242,0.6822623476118111485178,0.7066790730643729423477,\
-0.423530195967014910785,-0.8514600115056394358248,0.1911450421094866014560,\
-0.0937215291541069195347,0.5968058072572121064425,0.1973784591490661544100,\
-1.6526328643143648466918,2.1042236280016610727728,-2.19182144090441122231,\
-1.2142537279036162978230,-0.1183253697043944729916,-0.8801137301237593746350,\
-0.9900854927608483402324,-0.4110378213905900302017,-1.0605052107018932971982,\
2.0298978504498510488929,0.9198308522281034571577,1.4593911606425682414567,\
1.313234307458837291094,1.5294344184237567141338,0.6175875795682116420338,\
0.2031917147194874651017,1.5255721310550354186120,0.9034041242193133758320,\
-0.7761278947312221232480,-0.4993921694234899066878,-0.4357874013090125009384,\
0.3873324791493603647119,-0.4467287463644364353677,-0.2545033653001004259053,\
-1.3746540854818518617719,-0.1477740272607140914474,-1.5074443625622220288562,\
-1.6715013742258788553841,0.9592226709426125985658,1.3640187263976746301353,\
0.7890452102613630946948,1.2129240708363580036888,-0.9486821752491236825477,\
-0.4274439849602727492517,1.6129284060703097392,0.9379949480470993750103,\
-0.5596964661999650481050,-0.7987634619537844482551,0.0324112900849305857198,\
1.314201571181351946294,1.0612990922031533269632,0.9227327442687582870207,\
1.0844570327567082390630,-0.7983322787922396690519,0.4385271461747112797802,\
0.0024102971394308028881,-1.0118154904234695212750,0.0705293335731081022510,\
0.0697245903762851448882,-0.1632285547093744459968,-0.3480161062719534514898,\
0.7985173205564675136259,0.1109596610185162313122,2.1081890906632976268043,\
0.4892671398131347992866,1.0240089881181213549155,1.4852757378982723857064,\
1.0644644981998814259327,-0.3570451345877300175502}

#define ZSOURCEI {-0.9898306808620782604180,0.3667210055378663513537,-0.0115516846422681774414,\
0.8852998822794806432768,-1.1751393894807391493629,-0.0206719580996688329089,\
0.7962831267090092479677,-0.3570515343460327617464,1.1412480529936015472003,\
0.9660799200593181979002,-1.500080296017527903274,1.5242908911731756216312,\
1.105363493233324723164,-1.4826475597643153925276,-0.0160696607830907479963,\
-1.1650712441016521925263,-1.5029224597675916452744,-0.1699343140216190151115,\
0.7034171630892511739575,0.78048631235475940393,0.3572706186066606504070,\
-0.6408324378966977485916,-0.0937081428320361148332,-0.5995006453733843221343,\
1.998069767982257660677,-1.4952437710179469210203,-0.0218783914582419587724,\
0.6948934249723224265693,0.1340798946938218938474,0.89984980932311908752,\
-0.2284707639451582783519,-1.9920610974541457238729,0.3296873301478878692805,\
0.8334316663655645385234,0.6017800660861944983537,0.3195021884236714515559,\
0.8984984730147690390467,-1.9683562813815465020184,-0.2621383110944355832039,\
-0.6316753727255608463764,-0.0591493996271135885623,0.4809775893765277920977,\
0.6120565292662866196949,0.6937256492244192607188,-1.4222204429149998272663,\
0.8456412639793806640398,0.5364524335270092203487,-0.5058105404615705902316,\
-1.5311811141279494385969,0.0523506509744253098471,-0.5845520117472021714988,\
1.1469635617104527725019,-0.1258479133308397501789,0.5773840158286764889795,\
-1.1474331349335626928365,-0.3322391415499996170091,0.9929767773460509427963,\
-1.660441950926221155171,-1.0585630798226148829855,-0.5685726288282663132279,\
2.5350425363467468109491,1.1303214701472124037451,0.5096756039133761850835,\
0.5467199129804439783342,1.4455896704702442256973,0.2077882393389256510119,\
1.3512301851415178255422,0.2700167751147149464153,-0.6941424124437390874576,\
0.5635246670082925124490,0.5834755445761464764942,0.9008533966882129595533,\
-1.170120921094221611014,-0.0177589837851252312084,-0.2475436907499060923410,\
0.4245903735389653377297,1.3061684980078611673093,-0.5518911372967175710258,\
-0.1216398923828668349190,-0.1029994384259720480168,-0.1089806892178883240829,\
1.0016946254399594629092,0.2334205918306470894930,0.9399822370279485861388,\
-0.5987819428189028458931,1.4171477596181012437171,-0.0511681877729818074263,\
-1.239060328697855206670,0.1921278548938223085241,0.5833400770787767752878,\
0.1323798905411992243852,0.0725274151024776908558,1.517150104931189957824,\
-0.2298162704468252326429,-0.4156880360427151477332,-1.2865870850947289660837,\
0.2915127708019566443731,-0.4334207057720374511867,0.6674221275639458106355,\
-0.1336045597099253245954,0.2151665632136103845085,-0.3174957202806932832218,\
0.9961380035737125160367,1.5546597091479958940852,-1.3388468039798184783251,\
-0.5065257499177515665423,-1.0639142786788362560202,-0.2959444267422965957337,\
-1.960038123367497275851,-2.1398034807947201585421,1.3019428580756020608078,\
-0.3083046332207799999914,0.2621552778202266842378,0.5195575373923391193642,\
1.56243573209724884165,0.2068570860697496183178,-1.0570132216452536866313,\
-0.5904609039323533981047,-1.8482550680523897046470,-1.291460161650367144404,\
-0.7557326141240545691602,-1.0579108981634606223565,1.2726680818341371548286,\
0.8679294400149879518125,0.1923087263308917160831,-0.7207099055968289036400,\
-0.9810187619058614583167,-1.1007025532949878954270,1.0502610988542768755138,\
2.1328376492581355705624,0.2517811686949605887165,0.0286045569084023044992,\
0.5426452678085846859091,1.0007501149236575077595,-0.1483667758019126259317,\
0.6740034918705165578601,-0.7882925718203834808406,-0.7561945904807015894633,\
0.5978999579905148742398,-1.0006972818202708452873,-0.8844110367528469351939,\
0.0563203493770412927377,0.0010532695687821122445,-2.2465253729529170989565,\
1.141716522775603870343,-0.4500026076505115879556,0.9053568457125464874480,\
1.1182847109018192455210,0.8014435340539697305573,0.7353172667964483766312,\
-1.0684850588765142376246,-0.8549786389844856726583,3.744686089807424789200,\
0.2152832470021692201634,-0.8813298598480671097732,1.096456876472062580419,\
0.3072305150928033579127,-0.0799524082246828721177,-0.0588190904677381790067,\
-1.1720572424194137806097,1.4720320544391665151807,0.0931276494198173265815,\
0.555984015411468357470,0.8773397145008163811042,0.3438026639727968514215,\
0.2511717975861258445036,-0.4806220734748062883845,0.1665649861790623464941,\
-0.9011922058627225284866,-1.3882654124150977104080,-1.0995275754970570414315,\
-0.2796226936636541648973,1.8675624576106222285432,-0.6479880884779005700835,\
-1.2193765127792735025736,-0.4210708606718742141872,1.074252254135527273604,\
0.5620287257728261431922,-0.5121392183328929981201,0.0495074962957085112913,\
-1.483551847645206089865,-0.1477396930496895632867,0.4331368024681788719832,\
-0.1336623009706502385185,-0.5252621832336971108290,0.6576305030526226058640,\
-2.5329417269156695446952,-0.3644974785307753539776,-3.0957701776748671740336,\
-1.5563868957442139606684,-1.3037172144407160878643,0.1173565633554439491260,\
-1.4546337195274263720535,0.8077473947731041992171,0.5608831835142086275070,\
-0.2032753128403547993042,2.1656548569001641268983,-1.0352617083883073334505,\
0.0703447174899709398721,0.9001420266818445092838}

#define ZRESULTR {0.7816146272263719829709,0.9335239938948984850242,1.3671418657595642009994,\
1.251053426889690234347,0.7638235407866506010421,1.05442571981112132029,\
0.7654863707154079266459,0.9870695051633786576417,0.4317842171461107048103,\
0.6134213525393761301530,0.2077424772758102444747,0.0466895952950193357522,\
1.360861123120397309094,0.1290276167481773372803,1.6109467398934755877349,\
0.4514742994866134950804,0.0978899773240222564885,1.9847014656066033211346,\
0.8795516810834358434334,0.9805643961019996357464,1.2914771272713012617572,\
1.45266805020831779593,0.9982291599155850292391,0.8256234470461548680120,\
-0.4185192299594263642959,0.2310786951961565083291,1.0010177538173574696145,\
0.7891557184270517888436,2.5416517088949488467620,0.6546112908226877635798,\
2.3190840475863043756988,-1.0326993872554559583676,1.9805065587758790002226,\
1.9896627954528611770257,0.9782130127113016770934,0.9495035596250852583111,\
2.6155274562386430226013,-0.3882195415344683042669,1.6969468407328636150311,\
2.3343766660435352200409,1.0146967843242544748961,1.8258003683547168183310,\
0.8286050933424484732370,0.7704328385697075676219,0.1502070282359266317762,\
2.3818436251417942628450,7.4205579165122914631070,0.9034699872486960936513,\
0.0421812525739015259374,2.772183837530781680414,1.05592364033954333458,\
0.4321743126982589000562,1.0104075090452335761171,1.172999728469012792331,\
2.4859521407117588509550,1.0004516930864140178414,0.546406215495572333829,\
-0.0897848836255507876114,0.4902005853747226638006,1.3459428245240352417511,\
-0.9702703286402243332276,0.4885630407318873325018,0.8780295479347596243613,\
1.70760011581548409865,0.3365500801559331289781,0.9791465640129676240022,\
1.0399586044108937166186,1.694655018871175533590,0.782984551558400743154,\
3.2677601373666536055396,2.1277760759506403332,1.14078060084558496889,\
0.5190124031043247265771,1.1102812125309757806946,1.1710705982540408065518,\
0.9356000257245263851402,0.2627541871520008842644,0.9248192933983879759907,\
1.521163371222483906564,1.6845378275230893372338,1.06533482774366716761,\
0.8498389444062255382306,1.0685794539652364587567,0.652956087446700861321,\
1.1336945232455741816580,0.4760496137462009169639,1.0655234579631518432308,\
0.3786859524519583519719,1.1151440885209693565372,1.0396183182135259048806,\
0.9918753196058325283246,1.3573231183580980463432,0.0667878216615050979144,\
0.9763703551872023878033,1.1968339368077574036420,0.3044649077728942554444,\
1.3772502379038416009394,1.17234744424829684384,1.4766671247289078205966,\
1.1826761905568310417891,1.9143513147617730041361,2.0066566439861803772260,\
0.8422630906406018969079,0.0168918363185286551920,1.0985590427740710151028,\
1.1765072536632881217145,0.6974498887881349640239,1.9699828668985011059789,\
-0.5023701162984575141479,-0.5400394193341752080428,0.2985422403364683119342,\
1.5853347023892305767134,2.8298681106779470795232,1.57430200098008077347,\
0.0085163822819922137264,2.34150280392945697727,0.9260267598505396158259,\
1.935359947414732717519,-0.624580203843195791436,0.2899045962478056792655,\
1.1098967555784207128511,0.6015796718407534493522,0.4088898624506622225816,\
2.4110975561220100438220,1.194926943855234124925,0.8031086031385790136028,\
0.7056759527365589201864,0.4529743829467441917913,1.4838629998186587677367,\
-2.0715572287647061600069,4.2672653505633393322682,1.3529709414016093393940,\
1.7293958649615748246475,0.6702228972280770413761,1.246418198725941284266,\
0.8524596514683829839854,0.9764536278838282790105,0.7407821510692440547530,\
0.8301521851442831279044,0.6387195724636756111181,0.6461301327556139284525,\
2.7018352901688040823558,4.1613347047505291342873,-2.8343681862783589586741,\
0.7623226303646806201186,0.9067568500030595002315,0.8723652455116047699235,\
0.6696132906174546706168,0.7552700261493744404717,1.1992371819877765126705,\
1.8643427000471699539474,0.9539854852947572405597,-1.8677739580920826867327,\
1.9475448138625472971341,1.5369506397672023645384,0.5466606741068265051808,\
0.9729193674298542982015,2.3999437957484786032580,1.4341047292357653741846,\
0.5111837868275163065945,0.1111569790233604693164,1.091716362873146328738,\
0.9138969247921984173644,0.7040484777727061826980,0.9721353920795816616618,\
2.0373197284299586762302,0.8964067096914249965778,2.3355486655682877739082,\
1.7093760866374785312161,0.2716303051904848664400,0.9460612941094431738165,\
1.2762143042912967860758,-0.5352378220939374431353,1.1838129188764214827501,\
0.3761598820395333775402,2.3805545048605618596582,0.7017854493503786761366,\
0.9822084988099225588698,1.1648832392783827760496,0.9992994024245958062380,\
0.1738523619678353504536,1.6004378914991708171556,1.3222645989799672872067,\
1.6332603440938282535200,1.1558588483310223704592,0.8687697917589873863875,\
-0.8204224950713523423218,1.4547791700377004087130,-1.0014359468702989097721,\
0.0144439712508898226995,0.2674388703277625345400,1.0538721408636444465401,\
0.1548583219344299433118,0.6953871836582313781250,3.5373520681952288491345,\
1.0989946596859092586840,-0.8807918395297148483891,1.18456726702104053750,\
1.6180875245455190736266,0.6615360547308598571092}

#define ZRESULTI {0.8476313539717991174527,-0.0020945428347154504238,-0.0107702820990110675198,\
-1.3194799051731675998411,-1.5788424410279275900137,0.0069265821924918190636,\
-0.3180628434269115456523,-0.1158623505001605547005,0.2488922702434745726219,\
0.3333162069042073238911,-2.7579550935532486377610,-0.0929722217314629395535,\
-2.558018975124945360022,1.0673421965913736375597,-0.0202992468302341001751,\
-0.5103135313335316336492,-1.0383893485568700398858,0.2955939972849115360276,\
-0.3716363644745803163083,-0.669112301980219426056,-0.3318327753869652063656,\
0.9035686841735829366584,-0.0067883075736271340089,-0.0021471806447879195068,\
-0.1287847092516060110157,2.8852450693166233897102,-0.0010974001216119489213,\
-0.1508680801994282949519,0.315705921414520418455,-0.2580859369524737267909,\
-0.4893903475844605388545,-2.116294802120160856163,0.5953479459460185863051,\
2.0617504351927595784844,0.3616928144472888462246,0.0048175006267416721831,\
-3.1913265982599425818478,-0.0679428805767179483377,-0.3743690366783002931861,\
1.6027053949682106281927,0.0107745309683946743906,0.8329399053511026274066,\
0.0907062192789129806414,0.0408000708558418981320,0.1702419063491371065133,\
2.5813113904964448686030,4.3826942657913274814518,-0.1250993995488117738191,\
-0.366232782627764485994,0.1355060901825991537262,0.4285644238647245418683,\
0.2943941929388677047896,-0.0242296816969479640591,-0.5347582943284873158163,\
5.440972259812645539512,0.1130116459854922927875,-0.0230886388762507679950,\
-0.0758567265188389433517,-0.0153004723200108137121,0.6705905748883707051533,\
0.3580727041769314333841,0.5060754117432990639713,-0.0529558939424066774104,\
0.8998620364333704824134,2.4830051583371242074350,-0.0075609544367582562363,\
-4.5567155472995342080367,0.3858035723583744802667,-0.1243338609096430735779,\
-1.9945093918095539997637,-1.2920941940088974675405,1.2080631306058675633608,\
0.8083456169264077173509,-0.0085739065252298622688,-0.1660020282935961710713,\
-0.0959540597572042242014,0.0927222427996397119410,0.2221508503381195154258,\
-0.1409070089536773040528,0.1405249830722395676386,-0.0419169397939630830607,\
1.0272672902510724401992,0.1050876648914500499643,-0.3835786757949954384195,\
0.5298437409836795897178,2.9106995454114534815915,-0.0190217208337024913656,\
-0.5609150372475696366692,0.1029355491400509997613,0.4090658874763115071538,\
-0.0046870241505978906330,0.0668889266782490693464,0.7415168418856862286859,\
-0.0168562013052173872985,0.3406253082923152986083,-0.4061399877851155082453,\
0.2969570085375197732169,-0.3434409399238548266098,-0.9854495385788534234095,\
-0.0867374346127948586682,0.3597999966335438393195,0.5808295174480837541608,\
-0.9935741356819206560047,0.3096185219585154135835,-4.5479921396771585406782,\
-0.4366900670417938612466,-0.9018465944214471008422,-0.5250881076401040514767,\
-0.8025691478992442728924,0.0572684987995472974398,0.4945930961405698988997,\
0.4034972398433521179051,0.7137454043276676429741,0.7512128888062908904644,\
0.1939996418115135512483,-0.4464039676558783642513,1.3907357608014461192170,\
1.17156541392215607367,-1.9708685366549760775712,0.3123022444724680712902,\
-0.7896872395843760328304,-0.6179850212857144198253,0.9256883067644073870284,\
-2.7417718288371224488742,-0.1326893078962607386284,-0.2491649089658723725815,\
0.6490031468453125729212,-0.0039713278584005608923,-2.4386883505629461943442,\
3.178543851545130305425,-1.0690676099739919724385,-0.0260882664072711288605,\
-0.9060493921002102934992,0.6199896062130800800105,-0.1133779208230118323852,\
-0.2723070216270195298414,0.6794632710962359434248,-0.1319558520667497847345,\
-0.0528338647750857190455,-0.53278022650161005469,-0.1536737960232173183517,\
-0.1415472283443244549961,0.0042545728383564943367,3.4486281529351474617329,\
-1.3962363760387317412892,0.0515879186128369374154,-0.7852445756480942451461,\
-1.0432119477148995567717,-0.3036586016327645909385,-0.8524640219222514581077,\
-3.278864600929186412515,-0.7961629883628608128632,-1.1545100621855832745410,\
0.3684195377039459207147,-1.6970666375940057779559,0.5849997270051815467795,\
0.0618729525386339657134,-0.1749203390283090575608,-0.0606310989665877000943,\
0.7892429044220883316285,-0.5178739198482895655928,-0.0418201497112469372519,\
0.2095761220035197158751,-0.3550942958596610687927,-0.0867144455279654918778,\
-0.4598945931287213850780,0.0685694193597463919065,-0.3559389766660929765862,\
2.0119894555407911163059,-1.0947444956011096461879,-1.6288470340375438283331,\
-0.2410820142960599099524,1.4659778142858674865323,0.6624490343288035321123,\
0.4136536130989748594189,-0.9846866209581750517543,0.9510859925791920188587,\
-0.3140825904492373088495,0.4344001304574144906034,0.0016042272632115935332,\
-1.7199780122539785054414,-0.1872506113405222882839,0.4446357342161921244461,\
-0.1745599221993578142875,0.4442139130537332003534,0.2767209124711134116126,\
-0.0013781156561338940309,0.4254643497866397727769,-0.0032333769526939463469,\
-0.0697738544158777868054,0.1581414947349125965648,-0.0415758240738434495243,\
-0.8801521218406083146846,0.0803587769045229632914,2.1574882446469239027920,\
-0.1027605757720615048401,1.0043017952229080780313,-1.8015810020856124484823,\
0.0897692625606805599814,-0.2856956371820633111547}




void dcoshsTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out;
	int i;

	for (i=0;i<200;i++){
		out=dcoshs(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<3e-16);
	}
}

void zcoshsTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=DoubleComplex(inR[i],inI[i]);
		out=zcoshs(in);
		assert( fabs(zreals(out) - resR[i]) < 1e-14);	
		assert( fabs(zimags(out) - resI[i]) < 1e-14);			
	}
}

void dcoshaTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out[200];
	int i;
	double mon_test[9]={1,8,3,2,8,4,3,4,5};
	double mon_res[9]={1.5430806348152437124099,1490.4791612521778461087,10.06766199577776710328,
	3.7621956910836313880964,1490.4791612521778461087,27.308232836016486544395,
	10.06766199577776710328,27.308232836016486544395,74.209948524787861856566}; 
	double mon_out[9];
	dcosha(in,200,out);
	
	dcosha(mon_test,9,mon_out);
	
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<3e-16);
	}
	
	for (i=0;i<9;i++){
		assert(( (fabs(mon_out[i]-mon_res[i]))/(fabs(mon_out[i])) )<3e-16);
	}
}

void zcoshaTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex in[200],out[200];
	int i;

	for (i=0;i<200;i++){
		in[i]=DoubleComplex(inR[i],inI[i]);
	}
	zcosha(in,200,out);
	for (i=0;i<200;i++){
		assert( fabs(zreals(out[i]) - resR[i]) < 3e-15);	
		assert( fabs(zimags(out[i]) - resI[i]) < 3e-15);			
	}
}

int testCosh(void) {
  printf("\n>>>> Double Hyperbolic Cosine Tests\n");
  dcoshsTest();
  zcoshsTest();
  dcoshaTest();
  zcoshaTest();
  return 0;
}

int main(void) {
  assert(testCosh() == 0);
  return 0;
}
