/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2006-2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testCosh.h"

#define SOURCE {-1.205685175775274453613f,-0.8333271236779051793775f,1.2335774322243386880160f,\
0.3311018349037936903123f,-0.8052653369328224286505f,0.1998487851928297531767f,\
-0.8705427356398579563646f,0.1975294304937466050021f,0.9239335793216870706956f,\
0.2378506537628061745515f,0.0049366873129022617595f,-0.669236585027300545647f,\
1.0653101376824569701540f,-0.3369456198746673680766f,0.6204667311042414423738f,\
1.6283002068610463730636f,0.7206914942876857521625f,1.7221990362694574727698f,\
-1.0902216302137626158242f,0.2874486754733126536721f,-1.2122889745482419154854f,\
1.8215917027079053802652f,2.8016558959521908889201f,0.4050930510541474460773f,\
0.0617355341334478585624f,-0.4301267567705842620462f,-0.8284509700102783424924f,\
1.0256901078279201389165f,1.525021231170059277105f,-1.3197460532844016434240f,\
-0.4460647093896898951471f,0.5045503141647188494190f,-0.8098965560197782798113f,\
0.4268132043604428993433f,-1.1336964590865461488534f,1.127146072313511160345f,\
-0.9122705295277132586662f,-0.3089065753248803058995f,-2.3178211651402826909418f,\
1.1439933378277502562526f,0.7005552213939509886842f,0.4233298618301614135717f,\
-2.5208275627904130899992f,-0.2816183187535069021301f,0.7467093404219694585677f,\
0.7637510409783198062073f,0.3396503036180347767647f,-0.9747149605661590276995f,\
0.1472242280982364037722f,0.9901921384491637612157f,-1.2197737051905059857404f,\
-0.4607952353595122785279f,-0.9492383290419380559300f,1.4160381392623584417834f,\
-0.2758297498115374613015f,1.7324484611160422264931f,1.1368999048747294722261f,\
0.8568173351546003457813f,0.3519313905007281362280f,-0.8897875910518927566883f,\
0.2244273879422930551009f,0.2394303391704008243668f,-1.0382487030291693841377f,\
-1.0129167707607047432816f,-0.3443356316152397234021f,0.9904626758703307665144f,\
-0.5700286524862564485616f,-1.2143893416629112369520f,-0.7653327397314562130504f,\
0.5932733856160632424093f,1.0109636831448121085941f,-0.2591906321322083317504f,\
-0.6337213759172125593366f,-1.3891534527523830000462f,-0.7588209965122667544080f,\
-0.7751521002127067516696f,-0.2569588781664822740858f,-1.1144881209346948480743f,\
1.3683403773429958505403f,-1.3171565382517111952865f,-2.0066059395312958457680f,\
1.1665757372971858885080f,0.1803963656727911035738f,-1.4583403177666438566007f,\
-2.0738880513575592701159f,-0.7736713589363241050378f,-0.4690505767289738225934f,\
0.5290181646318501407222f,-0.6366436437236088208280f,-0.1514973533385992610079f,\
-0.4939237897364461837846f,1.2009977647347911400288f,-0.4479171393972471992839f,\
0.7962022364285237241432f,1.0553131168098721648363f,0.6399283922940391944323f,\
0.6404945676646236485396f,0.4718907579921589601213f,-1.1669004068172705856909f,\
0.8239670665751658296116f,-0.5209824870944876895607f,-0.5564774733886624913382f,\
0.677433403214317775287f,-0.9826152250790042286255f,-0.2301482766849789196595f,\
1.5256623976111793883348f,-0.0141042499939363699668f,-0.2206563911375283293381f,\
-1.2404617973010751974527f,0.4956722425079039262563f,-0.9198528977539149886766f,\
-0.9204208417497926619788f,0.8313756689801026222852f,0.3180154749624292120913f,\
0.2494121392443543194783f,1.9786862305439512077498f,-0.7539887840478504132946f,\
-0.2522144002260635065049f,1.4817018679370650424687f,-1.1886013018444978595056f,\
0.3497827881131843619222f,0.0164051036269147361424f,-0.3356971818656850903295f,\
1.5387250556465030815190f,-2.2939395533776552049687f,0.5463520678571377464650f,\
-0.6249598247747292223409f,-0.3795057983233444121041f,-0.6817850926970092650947f,\
0.1137639445438838742275f,-0.3667643438770555319728f,0.7811095630972452186214f,\
-0.6491897518190495874890f,-0.4116889792407164572197f,2.2135576248798094489700f,\
-0.8117887004060938549443f,0.543890637094475826174f,-0.4300056333049381840361f,\
-1.1073264735386671997475f,1.9600404811338050237168f,-1.1810889471038799047875f,\
-1.5998650464994574882382f,0.2370987431342703177783f,-1.1837915340560738464148f,\
-1.3250738110530209112881f,0.9867165393345800339375f,-0.4254735979103318466166f,\
-0.1977286302171261667127f,-1.3843612904745590252986f,0.0058770971600078198913f,\
1.6513137110120594819307f,-1.9479686718307542836470f,-1.1853539723928359084226f,\
-0.1952876876932538308118f,-0.3910952467587283098993f,2.6051477231429984726674f,\
-1.1685665444554920178177f,0.4303553159707447783866f,0.4980619697002917622974f,\
-0.5945099409025637049453f,0.6251723753612481448982f,0.5667367529854526742028f,\
0.2583522627447231712061f,-1.117334797621551301106f,-0.1572947959550771157566f,\
-0.1675843890566963978461f,-0.4415529643720014774111f,0.0296777742804143623845f,\
0.950535269366517221457f,-0.2023353295590510914082f,1.2240649283812428116391f,\
0.8408743467009373029342f,0.7289489292828028599303f,-0.3650480390020546805907f,\
0.7141089622210116116818f,-1.6330473677930090747878f,-1.2120035333729530790947f,\
2.5522160888662996924836f,0.4631064145940361198583f,-0.0364246441804653570129f,\
0.7308349560709582748430f,-1.059234312724760096458f,-1.5608743035213317185f,\
0.7865883787823105821602f,-0.1899223202317779357617f,-0.4035214553331447628892f,\
1.4993140466900047869103f,1.2050329976249689600820f,-0.2109320691913422751718f,\
0.0478227589320652582416f,1.1080187662760754285785f,0.3698710666565526716809f,\
-1.8629885917707584841452f,0.1117850228517819205498f,0.9930250182564113181627f,\
1.2533428090752711803191f,0.5303160507909902010582f,0.2252859052932770778099f,\
-0.7558035543285445134742f,1.1653980888802857318609f}

#define RESULT {1.819266428064204577097f,1.3677812549451693335811f,1.8623697303215194231996f,\
1.0553168123818659207558f,1.3421296845542964870646f,1.0200363222965405096687f,\
1.403465448863383979727f,1.0195724536239654245406f,1.4580674176636316818900f,\
1.0284200725097112361084f,1.0000121854655601438822f,1.2324226844271635172845f,\
1.6231798706546742838697f,1.0573052784271492754442f,1.1987446423322825062030f,\
2.64573472675944731947f,1.2711350583337506225945f,2.8877476825709762486838f,\
1.6555376604226368364436f,1.0415986209192817923963f,1.829342489722003417540f,\
3.171729047671292711641f,8.2663047019615358834699f,1.0831783845382449982253f,\
1.0019062434070211686787f,1.0939395186073928023518f,1.3632471669518277934685f,\
1.5737842316817938215223f,2.4064287835907673951397f,2.0048370085520934580359f,\
1.1011474483510161892497f,1.1300087947090773354830f,1.3462897763229764169779f,\
1.0924759182927643585970f,1.7144810122297002852321f,1.7053954010120264683792f,\
1.4457904936509571314218f,1.048092245021622570533f,5.126007634597746331906f,\
1.7289119973762236970316f,1.2555903810189259495189f,1.0909502538663513604433f,\
6.2596397068650517780952f,1.03991721163594563748f,1.2919843250699158954120f,\
1.3061137606130501787050f,1.0582378205813938176760f,1.5138557575271749389145f,\
1.0108570760043096292691f,1.5316284576789631621807f,1.8408591504389772985917f,\
1.1080580118223748442574f,1.4853883271417620548505f,2.1817178624460376035188f,\
1.0382828245407387246502f,2.9156663093555850174710f,1.7189510624849844155904f,\
1.390081256029065626123f,1.0625696729809925855648f,1.4226777259325882329932f,\
1.0252897080419871578272f,1.0288006377558764903313f,1.5891703898572226982822f,\
1.558389589207426872974f,1.0598715893830090717f,1.5319423704594259394440f,\
1.1669134763143933497531f,1.8325639262468249590654f,1.3074443355436990987783f,\
1.1812094824791219416227f,1.5560581683472911596056f,1.0337783603024415235438f,\
1.20761220067196339834f,2.1303694894256701708457f,1.3019874017358665785338f,\
1.3157780065006974279385f,1.0331959861022277369358f,1.6880453716815839726451f,\
2.0916769731603670479103f,2.000344096331303500591f,3.7862367743494589333864f,\
1.7612050492619382158210f,1.016315598810441089839f,2.2657204820986769355784f,\
4.0406956659153259181494f,1.3145132010698166169504f,1.1120358920747182018829f,\
1.1432241110320022769997f,1.2095957312624510127108f,1.0114976895400229484068f,\
1.1244804773055134816673f,1.8121625561683152305648f,1.1020033178144590380043f,\
1.3340717665795371882353f,1.6104789889363373411868f,1.2118376325588768871455f,\
1.2122253780682052948237f,1.1134219567585550425548f,1.7616758393639733171199f,\
1.3591064226145659343814f,1.1388088791439558988827f,1.1588706347019575026991f,\
1.2383685118981913042546f,1.5228821862471519921201f,1.0266012226158198750170f,\
2.4078326713444666573594f,1.00009946658283555010f,1.0244435586923690273409f,\
1.8732301190987417083278f,1.1253813439974511556585f,1.4537494816372256156711f,\
1.4543489946263667977888f,1.3659627989922018542757f,1.0509945293445170921842f,\
1.0312647772215886021741f,3.68574234301369418887f,1.2979736367142225006432f,\
1.0319750139115386744493f,2.3138394341351444793986f,1.7935669311616093679618f,\
1.061800258350523940010f,1.0001345667304306630285f,1.0568774415753066087120f,\
2.4366507835843460583192f,5.0073927789679837374592f,1.1530000373394655444059f,\
1.2017269174685778487799f,1.0728807813362080114672f,1.2415589372685298386045f,\
1.0064780997777151849704f,1.0680153713756039834948f,1.3208958764713327749263f,\
1.2182291644802725194552f,1.0859476120918869490595f,4.6287577582643999463130f,\
1.3479977392146349490787f,1.1515908109414143556393f,1.0938858068153072267137f,\
1.6783490081276506433738f,3.6202335893551729206763f,1.782432142455154355787f,\
2.5771439034538188295187f,1.0282398297270358700217f,1.786426290897340729558f,\
2.014123198363930722365f,1.5276055774381211982f,1.0918876182447221356853f,\
1.019612078038364622046f,2.1213794605936713288941f,1.0000172701852236833986f,\
2.7028112826383159372767f,3.5784939357816578642257f,1.7887413660887121480414f,\
1.0191293197498234590626f,1.0774575372953134611009f,6.8035582731627464170288f,\
1.764094760751516499653f,1.0940409161295887585652f,1.1266181837435944590453f,\
1.1819878003429369339727f,1.2018685976750431709803f,1.1649400331120620677439f,\
1.03355898490236453036f,1.6919235891909962798962f,1.0123963536864837298168f,\
1.0140751587041334502715f,1.0990787112389970303639f,1.0004404174672476557362f,\
1.4868140745992959317334f,1.02053972356750688455f,1.847508472372893173485f,\
1.3748631970003435398553f,1.2776582369190518928548f,1.0673732569157268201820f,\
1.2659971203245654614022f,2.6573926189895762384197f,1.8289053177424414720065f,\
6.4567128779259412851843f,1.1091640429888753871523f,1.0006634506999989575604f,\
1.2791603587689326371191f,1.61544148317066760256f,2.4864680737312045977205f,\
1.3256439332679719189656f,1.0180895207546800662612f,1.0825255238019519943293f,\
2.3509495822805339670936f,1.8182756477804529193776f,1.0223287733363202178793f,\
1.001143726087694751925f,1.679282557162007583074f,1.0691856802487731403772f,\
3.2990857486037623580444f,1.0062544545151006492034f,1.5349210973541418390198f,\
1.8937893477592186997072f,1.1439441561926790846826f,1.0254843822262098562703f,\
1.2994774746280413069144f,1.7594989466591723914490f}

#define CSOURCER {-0.8912345066950769778558f,-0.0058415661764856371616f,0.8327394520710053038570f,\
-1.3031116495573464852953f,1.3063996947557070527068f,-0.3291212350984021872691f,\
-0.4314780628860441225036f,0.3257069146291299843732f,0.2704533752036020199938f,\
0.3948286552396417792288f,1.7413456505609685720515f,-0.0929389968439678221257f,\
-1.7740482961163070996236f,-0.9310406640182858906130f,1.0558482448966843847415f,\
0.5302093445317125341987f,0.9099214704748677107204f,-1.3248358105760951186625f,\
-0.5468817390748145212953f,-0.8462613338460863721124f,-0.8447436284186202737345f,\
-1.201032047282137193989f,0.0724835993626015417934f,0.0038054949984360143984f,\
-0.1410382163048108095094f,-1.7842189597096504982687f,0.0501420738427398662851f,\
-0.2334922077300364828822f,1.5945984531602754863400f,-0.3238241601909672695569f,\
1.513308285995593083229f,1.5778451444411625281816f,1.3691912706993336623640f,\
1.748251159750787042668f,0.6019009531079806407661f,0.0153371667399079970179f,\
-2.11368074169300124154f,0.0736235546297408505190f,1.16364818469077779817f,\
-1.7239586420846975123311f,-0.1812698216235553161368f,1.3506264987504341679170f,\
0.1572244306209917286132f,0.0637660966151842728555f,-0.1712993899334549763314f,\
1.9516485698976029361518f,2.845403039274271073111f,0.2554082947132658709677f,\
0.3587738434809014664850f,1.6800084635178351710749f,-0.7143150645295742728891f,\
0.3176042681985608573392f,0.1918613409687800752668f,-0.8669525494355047046113f,\
-2.486482303849266717322f,-0.3399076190046602663486f,-0.0275599140270330646152f,\
0.0760891140551305106277f,0.0175525149136643889014f,-1.0447511992604696651199f,\
0.5928194662003063442057f,0.5337685538183976063920f,-0.1083277352156265110894f,\
1.3163705916013288543809f,1.6481947619041572572485f,-0.0366427588652487520871f,\
-2.24532677610144792979f,1.1646157862674424432470f,0.1931514629705824159789f,\
-2.0280558458213828743055f,-1.588195044157987734224f,1.217389599860282611843f,\
-0.7923310676779923289459f,0.4657912238712272334773f,0.6341322794098591675294f,\
-0.2308714073795904986319f,0.0959191686134504700734f,-0.4119590516116395373380f,\
0.9909317687163362586844f,-1.1184985773424866994930f,0.3764360122586650203580f,\
1.0283807947333536425560f,0.4399875767202614529339f,-0.4587329057670580523265f,\
-0.8383371473991714228902f,1.8010370613667443517869f,0.3638310348854316700340f,\
0.5630372956104594539539f,0.5158868637708874382852f,0.6872616626544041373847f,\
-0.0355020269914341005113f,0.8259138693919667595367f,0.6872047295901000385498f,\
0.0739287007414783509107f,-0.7662836697323893719869f,0.4114094358620231095536f,\
0.9046891131020067255974f,0.7464765051550138474923f,-1.2447871833324788415354f,\
0.6121845724663061982795f,1.2932746927561220573466f,-1.3794546951962081138277f,\
-1.0054979370864329801805f,0.304912140043878954199f,2.2462341404304981828943f,\
0.8089620929537136850840f,0.9035087652875184449641f,1.3506573247795918835124f,\
0.7844818177699410810533f,-0.0679273669198190016560f,0.4928294105013013015615f,\
-1.096446680245239946316f,1.737658266453646849214f,1.2019686032899719041467f,\
0.1928095667884118236124f,-1.5186389453508686298022f,-1.2473448039026917566f,\
-1.489337044442988755577f,1.4654430117361589847036f,-0.3194353686893170451988f,\
0.9845148496238763646815f,0.6602210723100759848236f,0.8588563891948870487880f,\
-1.9910804060218119104775f,-0.6479512615308331557884f,0.3691293678246713727553f,\
-0.71770775009329423888f,0.0044545145586906377197f,-1.7569208392800599316530f,\
2.0338706868044176268029f,-2.1630248696548646236693f,-0.8178753147165283010622f,\
-1.3281476236021181325242f,0.6822623476118111485178f,0.7066790730643729423477f,\
-0.423530195967014910785f,-0.8514600115056394358248f,0.1911450421094866014560f,\
-0.0937215291541069195347f,0.5968058072572121064425f,0.1973784591490661544100f,\
-1.6526328643143648466918f,2.1042236280016610727728f,-2.19182144090441122231f,\
-1.2142537279036162978230f,-0.1183253697043944729916f,-0.8801137301237593746350f,\
-0.9900854927608483402324f,-0.4110378213905900302017f,-1.0605052107018932971982f,\
2.0298978504498510488929f,0.9198308522281034571577f,1.4593911606425682414567f,\
1.313234307458837291094f,1.5294344184237567141338f,0.6175875795682116420338f,\
0.2031917147194874651017f,1.5255721310550354186120f,0.9034041242193133758320f,\
-0.7761278947312221232480f,-0.4993921694234899066878f,-0.4357874013090125009384f,\
0.3873324791493603647119f,-0.4467287463644364353677f,-0.2545033653001004259053f,\
-1.3746540854818518617719f,-0.1477740272607140914474f,-1.5074443625622220288562f,\
-1.6715013742258788553841f,0.9592226709426125985658f,1.3640187263976746301353f,\
0.7890452102613630946948f,1.2129240708363580036888f,-0.9486821752491236825477f,\
-0.4274439849602727492517f,1.6129284060703097392f,0.9379949480470993750103f,\
-0.5596964661999650481050f,-0.7987634619537844482551f,0.0324112900849305857198f,\
1.314201571181351946294f,1.0612990922031533269632f,0.9227327442687582870207f,\
1.0844570327567082390630f,-0.7983322787922396690519f,0.4385271461747112797802f,\
0.0024102971394308028881f,-1.0118154904234695212750f,0.0705293335731081022510f,\
0.0697245903762851448882f,-0.1632285547093744459968f,-0.3480161062719534514898f,\
0.7985173205564675136259f,0.1109596610185162313122f,2.1081890906632976268043f,\
0.4892671398131347992866f,1.0240089881181213549155f,1.4852757378982723857064f,\
1.0644644981998814259327f,-0.3570451345877300175502f}

#define CSOURCEI {-0.9898306808620782604180f,0.3667210055378663513537f,-0.0115516846422681774414f,\
0.8852998822794806432768f,-1.1751393894807391493629f,-0.0206719580996688329089f,\
0.7962831267090092479677f,-0.3570515343460327617464f,1.1412480529936015472003f,\
0.9660799200593181979002f,-1.500080296017527903274f,1.5242908911731756216312f,\
1.105363493233324723164f,-1.4826475597643153925276f,-0.0160696607830907479963f,\
-1.1650712441016521925263f,-1.5029224597675916452744f,-0.1699343140216190151115f,\
0.7034171630892511739575f,0.78048631235475940393f,0.3572706186066606504070f,\
-0.6408324378966977485916f,-0.0937081428320361148332f,-0.5995006453733843221343f,\
1.998069767982257660677f,-1.4952437710179469210203f,-0.0218783914582419587724f,\
0.6948934249723224265693f,0.1340798946938218938474f,0.89984980932311908752f,\
-0.2284707639451582783519f,-1.9920610974541457238729f,0.3296873301478878692805f,\
0.8334316663655645385234f,0.6017800660861944983537f,0.3195021884236714515559f,\
0.8984984730147690390467f,-1.9683562813815465020184f,-0.2621383110944355832039f,\
-0.6316753727255608463764f,-0.0591493996271135885623f,0.4809775893765277920977f,\
0.6120565292662866196949f,0.6937256492244192607188f,-1.4222204429149998272663f,\
0.8456412639793806640398f,0.5364524335270092203487f,-0.5058105404615705902316f,\
-1.5311811141279494385969f,0.0523506509744253098471f,-0.5845520117472021714988f,\
1.1469635617104527725019f,-0.1258479133308397501789f,0.5773840158286764889795f,\
-1.1474331349335626928365f,-0.3322391415499996170091f,0.9929767773460509427963f,\
-1.660441950926221155171f,-1.0585630798226148829855f,-0.5685726288282663132279f,\
2.5350425363467468109491f,1.1303214701472124037451f,0.5096756039133761850835f,\
0.5467199129804439783342f,1.4455896704702442256973f,0.2077882393389256510119f,\
1.3512301851415178255422f,0.2700167751147149464153f,-0.6941424124437390874576f,\
0.5635246670082925124490f,0.5834755445761464764942f,0.9008533966882129595533f,\
-1.170120921094221611014f,-0.0177589837851252312084f,-0.2475436907499060923410f,\
0.4245903735389653377297f,1.3061684980078611673093f,-0.5518911372967175710258f,\
-0.1216398923828668349190f,-0.1029994384259720480168f,-0.1089806892178883240829f,\
1.0016946254399594629092f,0.2334205918306470894930f,0.9399822370279485861388f,\
-0.5987819428189028458931f,1.4171477596181012437171f,-0.0511681877729818074263f,\
-1.239060328697855206670f,0.1921278548938223085241f,0.5833400770787767752878f,\
0.1323798905411992243852f,0.0725274151024776908558f,1.517150104931189957824f,\
-0.2298162704468252326429f,-0.4156880360427151477332f,-1.2865870850947289660837f,\
0.2915127708019566443731f,-0.4334207057720374511867f,0.6674221275639458106355f,\
-0.1336045597099253245954f,0.2151665632136103845085f,-0.3174957202806932832218f,\
0.9961380035737125160367f,1.5546597091479958940852f,-1.3388468039798184783251f,\
-0.5065257499177515665423f,-1.0639142786788362560202f,-0.2959444267422965957337f,\
-1.960038123367497275851f,-2.1398034807947201585421f,1.3019428580756020608078f,\
-0.3083046332207799999914f,0.2621552778202266842378f,0.5195575373923391193642f,\
1.56243573209724884165f,0.2068570860697496183178f,-1.0570132216452536866313f,\
-0.5904609039323533981047f,-1.8482550680523897046470f,-1.291460161650367144404f,\
-0.7557326141240545691602f,-1.0579108981634606223565f,1.2726680818341371548286f,\
0.8679294400149879518125f,0.1923087263308917160831f,-0.7207099055968289036400f,\
-0.9810187619058614583167f,-1.1007025532949878954270f,1.0502610988542768755138f,\
2.1328376492581355705624f,0.2517811686949605887165f,0.0286045569084023044992f,\
0.5426452678085846859091f,1.0007501149236575077595f,-0.1483667758019126259317f,\
0.6740034918705165578601f,-0.7882925718203834808406f,-0.7561945904807015894633f,\
0.5978999579905148742398f,-1.0006972818202708452873f,-0.8844110367528469351939f,\
0.0563203493770412927377f,0.0010532695687821122445f,-2.2465253729529170989565f,\
1.141716522775603870343f,-0.4500026076505115879556f,0.9053568457125464874480f,\
1.1182847109018192455210f,0.8014435340539697305573f,0.7353172667964483766312f,\
-1.0684850588765142376246f,-0.8549786389844856726583f,3.744686089807424789200f,\
0.2152832470021692201634f,-0.8813298598480671097732f,1.096456876472062580419f,\
0.3072305150928033579127f,-0.0799524082246828721177f,-0.0588190904677381790067f,\
-1.1720572424194137806097f,1.4720320544391665151807f,0.0931276494198173265815f,\
0.555984015411468357470f,0.8773397145008163811042f,0.3438026639727968514215f,\
0.2511717975861258445036f,-0.4806220734748062883845f,0.1665649861790623464941f,\
-0.9011922058627225284866f,-1.3882654124150977104080f,-1.0995275754970570414315f,\
-0.2796226936636541648973f,1.8675624576106222285432f,-0.6479880884779005700835f,\
-1.2193765127792735025736f,-0.4210708606718742141872f,1.074252254135527273604f,\
0.5620287257728261431922f,-0.5121392183328929981201f,0.0495074962957085112913f,\
-1.483551847645206089865f,-0.1477396930496895632867f,0.4331368024681788719832f,\
-0.1336623009706502385185f,-0.5252621832336971108290f,0.6576305030526226058640f,\
-2.5329417269156695446952f,-0.3644974785307753539776f,-3.0957701776748671740336f,\
-1.5563868957442139606684f,-1.3037172144407160878643f,0.1173565633554439491260f,\
-1.4546337195274263720535f,0.8077473947731041992171f,0.5608831835142086275070f,\
-0.2032753128403547993042f,2.1656548569001641268983f,-1.0352617083883073334505f,\
0.0703447174899709398721f,0.9001420266818445092838f}

#define CRESULTR {0.7816146272263719829709f,0.9335239938948984850242f,1.3671418657595642009994f,\
1.251053426889690234347f,0.7638235407866506010421f,1.05442571981112132029f,\
0.7654863707154079266459f,0.9870695051633786576417f,0.4317842171461107048103f,\
0.6134213525393761301530f,0.2077424772758102444747f,0.0466895952950193357522f,\
1.360861123120397309094f,0.1290276167481773372803f,1.6109467398934755877349f,\
0.4514742994866134950804f,0.0978899773240222564885f,1.9847014656066033211346f,\
0.8795516810834358434334f,0.9805643961019996357464f,1.2914771272713012617572f,\
1.45266805020831779593f,0.9982291599155850292391f,0.8256234470461548680120f,\
-0.4185192299594263642959f,0.2310786951961565083291f,1.0010177538173574696145f,\
0.7891557184270517888436f,2.5416517088949488467620f,0.6546112908226877635798f,\
2.3190840475863043756988f,-1.0326993872554559583676f,1.9805065587758790002226f,\
1.9896627954528611770257f,0.9782130127113016770934f,0.9495035596250852583111f,\
2.6155274562386430226013f,-0.3882195415344683042669f,1.6969468407328636150311f,\
2.3343766660435352200409f,1.0146967843242544748961f,1.8258003683547168183310f,\
0.8286050933424484732370f,0.7704328385697075676219f,0.1502070282359266317762f,\
2.3818436251417942628450f,7.4205579165122914631070f,0.9034699872486960936513f,\
0.0421812525739015259374f,2.772183837530781680414f,1.05592364033954333458f,\
0.4321743126982589000562f,1.0104075090452335761171f,1.172999728469012792331f,\
2.4859521407117588509550f,1.0004516930864140178414f,0.546406215495572333829f,\
-0.0897848836255507876114f,0.4902005853747226638006f,1.3459428245240352417511f,\
-0.9702703286402243332276f,0.4885630407318873325018f,0.8780295479347596243613f,\
1.70760011581548409865f,0.3365500801559331289781f,0.9791465640129676240022f,\
1.0399586044108937166186f,1.694655018871175533590f,0.782984551558400743154f,\
3.2677601373666536055396f,2.1277760759506403332f,1.14078060084558496889f,\
0.5190124031043247265771f,1.1102812125309757806946f,1.1710705982540408065518f,\
0.9356000257245263851402f,0.2627541871520008842644f,0.9248192933983879759907f,\
1.521163371222483906564f,1.6845378275230893372338f,1.06533482774366716761f,\
0.8498389444062255382306f,1.0685794539652364587567f,0.652956087446700861321f,\
1.1336945232455741816580f,0.4760496137462009169639f,1.0655234579631518432308f,\
0.3786859524519583519719f,1.1151440885209693565372f,1.0396183182135259048806f,\
0.9918753196058325283246f,1.3573231183580980463432f,0.0667878216615050979144f,\
0.9763703551872023878033f,1.1968339368077574036420f,0.3044649077728942554444f,\
1.3772502379038416009394f,1.17234744424829684384f,1.4766671247289078205966f,\
1.1826761905568310417891f,1.9143513147617730041361f,2.0066566439861803772260f,\
0.8422630906406018969079f,0.0168918363185286551920f,1.0985590427740710151028f,\
1.1765072536632881217145f,0.6974498887881349640239f,1.9699828668985011059789f,\
-0.5023701162984575141479f,-0.5400394193341752080428f,0.2985422403364683119342f,\
1.5853347023892305767134f,2.8298681106779470795232f,1.57430200098008077347f,\
0.0085163822819922137264f,2.34150280392945697727f,0.9260267598505396158259f,\
1.935359947414732717519f,-0.624580203843195791436f,0.2899045962478056792655f,\
1.1098967555784207128511f,0.6015796718407534493522f,0.4088898624506622225816f,\
2.4110975561220100438220f,1.194926943855234124925f,0.8031086031385790136028f,\
0.7056759527365589201864f,0.4529743829467441917913f,1.4838629998186587677367f,\
-2.0715572287647061600069f,4.2672653505633393322682f,1.3529709414016093393940f,\
1.7293958649615748246475f,0.6702228972280770413761f,1.246418198725941284266f,\
0.8524596514683829839854f,0.9764536278838282790105f,0.7407821510692440547530f,\
0.8301521851442831279044f,0.6387195724636756111181f,0.6461301327556139284525f,\
2.7018352901688040823558f,4.1613347047505291342873f,-2.8343681862783589586741f,\
0.7623226303646806201186f,0.9067568500030595002315f,0.8723652455116047699235f,\
0.6696132906174546706168f,0.7552700261493744404717f,1.1992371819877765126705f,\
1.8643427000471699539474f,0.9539854852947572405597f,-1.8677739580920826867327f,\
1.9475448138625472971341f,1.5369506397672023645384f,0.5466606741068265051808f,\
0.9729193674298542982015f,2.3999437957484786032580f,1.4341047292357653741846f,\
0.5111837868275163065945f,0.1111569790233604693164f,1.091716362873146328738f,\
0.9138969247921984173644f,0.7040484777727061826980f,0.9721353920795816616618f,\
2.0373197284299586762302f,0.8964067096914249965778f,2.3355486655682877739082f,\
1.7093760866374785312161f,0.2716303051904848664400f,0.9460612941094431738165f,\
1.2762143042912967860758f,-0.5352378220939374431353f,1.1838129188764214827501f,\
0.3761598820395333775402f,2.3805545048605618596582f,0.7017854493503786761366f,\
0.9822084988099225588698f,1.1648832392783827760496f,0.9992994024245958062380f,\
0.1738523619678353504536f,1.6004378914991708171556f,1.3222645989799672872067f,\
1.6332603440938282535200f,1.1558588483310223704592f,0.8687697917589873863875f,\
-0.8204224950713523423218f,1.4547791700377004087130f,-1.0014359468702989097721f,\
0.0144439712508898226995f,0.2674388703277625345400f,1.0538721408636444465401f,\
0.1548583219344299433118f,0.6953871836582313781250f,3.5373520681952288491345f,\
1.0989946596859092586840f,-0.8807918395297148483891f,1.18456726702104053750f,\
1.6180875245455190736266f,0.6615360547308598571092f}

#define CRESULTI {0.8476313539717991174527f,-0.0020945428347154504238f,-0.0107702820990110675198f,\
-1.3194799051731675998411f,-1.5788424410279275900137f,0.0069265821924918190636f,\
-0.3180628434269115456523f,-0.1158623505001605547005f,0.2488922702434745726219f,\
0.3333162069042073238911f,-2.7579550935532486377610f,-0.0929722217314629395535f,\
-2.558018975124945360022f,1.0673421965913736375597f,-0.0202992468302341001751f,\
-0.5103135313335316336492f,-1.0383893485568700398858f,0.2955939972849115360276f,\
-0.3716363644745803163083f,-0.669112301980219426056f,-0.3318327753869652063656f,\
0.9035686841735829366584f,-0.0067883075736271340089f,-0.0021471806447879195068f,\
-0.1287847092516060110157f,2.8852450693166233897102f,-0.0010974001216119489213f,\
-0.1508680801994282949519f,0.315705921414520418455f,-0.2580859369524737267909f,\
-0.4893903475844605388545f,-2.116294802120160856163f,0.5953479459460185863051f,\
2.0617504351927595784844f,0.3616928144472888462246f,0.0048175006267416721831f,\
-3.1913265982599425818478f,-0.0679428805767179483377f,-0.3743690366783002931861f,\
1.6027053949682106281927f,0.0107745309683946743906f,0.8329399053511026274066f,\
0.0907062192789129806414f,0.0408000708558418981320f,0.1702419063491371065133f,\
2.5813113904964448686030f,4.3826942657913274814518f,-0.1250993995488117738191f,\
-0.366232782627764485994f,0.1355060901825991537262f,0.4285644238647245418683f,\
0.2943941929388677047896f,-0.0242296816969479640591f,-0.5347582943284873158163f,\
5.440972259812645539512f,0.1130116459854922927875f,-0.0230886388762507679950f,\
-0.0758567265188389433517f,-0.0153004723200108137121f,0.6705905748883707051533f,\
0.3580727041769314333841f,0.5060754117432990639713f,-0.0529558939424066774104f,\
0.8998620364333704824134f,2.4830051583371242074350f,-0.0075609544367582562363f,\
-4.5567155472995342080367f,0.3858035723583744802667f,-0.1243338609096430735779f,\
-1.9945093918095539997637f,-1.2920941940088974675405f,1.2080631306058675633608f,\
0.8083456169264077173509f,-0.0085739065252298622688f,-0.1660020282935961710713f,\
-0.0959540597572042242014f,0.0927222427996397119410f,0.2221508503381195154258f,\
-0.1409070089536773040528f,0.1405249830722395676386f,-0.0419169397939630830607f,\
1.0272672902510724401992f,0.1050876648914500499643f,-0.3835786757949954384195f,\
0.5298437409836795897178f,2.9106995454114534815915f,-0.0190217208337024913656f,\
-0.5609150372475696366692f,0.1029355491400509997613f,0.4090658874763115071538f,\
-0.0046870241505978906330f,0.0668889266782490693464f,0.7415168418856862286859f,\
-0.0168562013052173872985f,0.3406253082923152986083f,-0.4061399877851155082453f,\
0.2969570085375197732169f,-0.3434409399238548266098f,-0.9854495385788534234095f,\
-0.0867374346127948586682f,0.3597999966335438393195f,0.5808295174480837541608f,\
-0.9935741356819206560047f,0.3096185219585154135835f,-4.5479921396771585406782f,\
-0.4366900670417938612466f,-0.9018465944214471008422f,-0.5250881076401040514767f,\
-0.8025691478992442728924f,0.0572684987995472974398f,0.4945930961405698988997f,\
0.4034972398433521179051f,0.7137454043276676429741f,0.7512128888062908904644f,\
0.1939996418115135512483f,-0.4464039676558783642513f,1.3907357608014461192170f,\
1.17156541392215607367f,-1.9708685366549760775712f,0.3123022444724680712902f,\
-0.7896872395843760328304f,-0.6179850212857144198253f,0.9256883067644073870284f,\
-2.7417718288371224488742f,-0.1326893078962607386284f,-0.2491649089658723725815f,\
0.6490031468453125729212f,-0.0039713278584005608923f,-2.4386883505629461943442f,\
3.178543851545130305425f,-1.0690676099739919724385f,-0.0260882664072711288605f,\
-0.9060493921002102934992f,0.6199896062130800800105f,-0.1133779208230118323852f,\
-0.2723070216270195298414f,0.6794632710962359434248f,-0.1319558520667497847345f,\
-0.0528338647750857190455f,-0.53278022650161005469f,-0.1536737960232173183517f,\
-0.1415472283443244549961f,0.0042545728383564943367f,3.4486281529351474617329f,\
-1.3962363760387317412892f,0.0515879186128369374154f,-0.7852445756480942451461f,\
-1.0432119477148995567717f,-0.3036586016327645909385f,-0.8524640219222514581077f,\
-3.278864600929186412515f,-0.7961629883628608128632f,-1.1545100621855832745410f,\
0.3684195377039459207147f,-1.6970666375940057779559f,0.5849997270051815467795f,\
0.0618729525386339657134f,-0.1749203390283090575608f,-0.0606310989665877000943f,\
0.7892429044220883316285f,-0.5178739198482895655928f,-0.0418201497112469372519f,\
0.2095761220035197158751f,-0.3550942958596610687927f,-0.0867144455279654918778f,\
-0.4598945931287213850780f,0.0685694193597463919065f,-0.3559389766660929765862f,\
2.0119894555407911163059f,-1.0947444956011096461879f,-1.6288470340375438283331f,\
-0.2410820142960599099524f,1.4659778142858674865323f,0.6624490343288035321123f,\
0.4136536130989748594189f,-0.9846866209581750517543f,0.9510859925791920188587f,\
-0.3140825904492373088495f,0.4344001304574144906034f,0.0016042272632115935332f,\
-1.7199780122539785054414f,-0.1872506113405222882839f,0.4446357342161921244461f,\
-0.1745599221993578142875f,0.4442139130537332003534f,0.2767209124711134116126f,\
-0.0013781156561338940309f,0.4254643497866397727769f,-0.0032333769526939463469f,\
-0.0697738544158777868054f,0.1581414947349125965648f,-0.0415758240738434495243f,\
-0.8801521218406083146846f,0.0803587769045229632914f,2.1574882446469239027920f,\
-0.1027605757720615048401f,1.0043017952229080780313f,-1.8015810020856124484823f,\
0.0897692625606805599814f,-0.2856956371820633111547f}




void scoshsTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out;
	int i;

	for (i=0;i<200;i++){
		out=scoshs(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<1e-6);
	}
}

void ccoshsTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=FloatComplex(inR[i],inI[i]);
		out=ccoshs(in);
		assert( fabs(creals(out) - resR[i]) < 3e-6);	
		assert( fabs(cimags(out) - resI[i]) < 3e-6);			
	}
}

void scoshaTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out[200];
	int i,j;
	j=1;
	scosha(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<1e-6);
	}
}

void ccoshaTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in[200],out[200];
	int i;

	for (i=0;i<200;i++){
		in[i]=FloatComplex(inR[i],inI[i]);
	}
	ccosha(in,200,out);
	for (i=0;i<200;i++){
		assert( fabs(creals(out[i]) - resR[i]) < 3e-6);	
		assert( fabs(cimags(out[i]) - resI[i]) < 3e-6);			
	}
}


int testCosh(void) {
  printf("\n>>>> Hyperbolic Cosine Tests\n");
  scoshsTest();
  ccoshsTest();
  scoshaTest();
  ccoshaTest();
  return 0;
}

int main(void) {
  assert(testCosh() == 0);
  return 0;
}
