/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2006-2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testExp.h"

#define SOURCE {0.2179693998688542744269f,-0.0965447246339290049422f,0.7336822469173450711466f,\
0.1536179219946321450330f,2.4661907147341337598334f,0.6332832861607330388054f,\
0.4890665386763063948727f,-1.2667347141842044688786f,0.1055086446255857485221f,\
-0.5936826571652784600985f,-0.7816336465253074239357f,-1.2815191120322371176599f,\
-0.9972908908531801230879f,-0.5763370349806613557320f,0.3762718127153176217448f,\
-0.8343599392689131644119f,-1.0647534449045219506758f,0.8534997909421322415113f,\
0.4306578956143343739349f,0.5321132560429659985601f,1.5974906319789743402993f,\
0.7312358120089610391545f,0.4431279991113933891533f,0.0087064913021668820237f,\
-0.8280501749431711244753f,-1.0000194068543815095751f,-0.8231062295149559338014f,\
-1.014391306624823796412f,0.9121054970139131912177f,-0.3855306050210344781526f,\
-0.2598191828862038144088f,-0.0831341089570867414205f,1.6949336044621277075350f,\
0.2429392861367114797577f,1.8753502720069497033961f,0.1984146246369250243813f,\
-0.7119008641532499348514f,0.2504295152565002013922f,1.8412596530958635909769f,\
-0.8228059182439799723596f,0.6769888144769687920999f,-0.4970822573553836942750f,\
0.0527831065241245664388f,0.9397902577952749192391f,-0.1148979773734264131502f,\
0.0647134776331551031525f,0.3730550115687696344224f,1.8451193005461747898011f,\
-0.5388550697275177325807f,0.9483924031089353556823f,0.0149553330989996690475f,\
0.3492458987360779198994f,0.6782119558587149654727f,-1.0638111247721440122405f,\
-0.0013200516387791912543f,0.5311672327771198576229f,-0.6446734157979014945283f,\
0.7518088875179287366990f,-0.6321033286458267452801f,-1.7783294717850963717609f,\
-0.9695340176537615706209f,0.0585248375044749719054f,-0.4174672618194515405499f,\
1.067002270541741681953f,-0.1107931733964626630495f,0.9733263412399585368107f,\
-1.5676178926909869471018f,1.5082394419009976793689f,1.4975531724590585014312f,\
0.0773364211376570409584f,0.8296923447513622207339f,-0.9966607229071756668404f,\
-0.5179876589725144198084f,0.4414952679928694223577f,-0.8736872755871413209761f,\
-0.0349791375435402618344f,0.9274876201813765375093f,0.4517463561226834900530f,\
-0.9961910310034214344199f,-0.4760507657625145383484f,0.2735565496341169633432f,\
-0.8683706445498747816814f,-0.5819104976015757602070f,1.0334934603683001430596f,\
1.3664069352627037368109f,0.7304950466471921144418f,-2.2795501799654798169570f,\
-0.3686784792993444970222f,-1.2288389604009317679356f,-1.372993238103811464157f,\
0.4327366693143714915237f,-2.5372469745505505933636f,-0.6466940204055214858059f,\
0.3727678446055545102844f,-1.2012067538727111415398f,-0.4120248811585083825726f,\
-0.1824358873620524901238f,-0.7071004997444696460462f,-0.0734584462405756949410f,\
0.4857107830752938615326f,-1.5839443933479926407415f,-2.6376393427060378371607f,\
-0.1810786671588598961691f,0.8157163062709066325695f,-0.3867087459826359374659f,\
0.4198660262170845203222f,-0.6048459538042058047935f,0.7659922557941690746119f,\
0.7134643264223192726803f,0.1349874125377001632398f,0.9411487010623025284417f,\
-2.1973029826905001726800f,-1.9520696706230427075468f,-1.2525761477383645647876f,\
0.3859074186443228193788f,2.7807429866034785170825f,-0.4523923998873963236989f,\
1.585571863180605944876f,-0.8857651118640259557679f,1.3802479208151854361830f,\
-0.3327040930736118173883f,-0.2328335442849216174732f,-0.7859150581069940244561f,\
-0.7298755566585160003967f,-0.2812060079915064125800f,-0.5573134267677620767856f,\
-0.5509002031358800621774f,1.5296906305375963519566f,-0.5702710404977533453774f,\
-1.3692402567978680938410f,0.1826473558262797503016f,0.1798346311903204763905f,\
0.4425890891364235302241f,-0.9017692018513575602512f,-1.4772671313778520385540f,\
0.4118240527515873439235f,-0.3831680771908100302525f,-1.7286187555088927680913f,\
0.9581454530897092203290f,-0.4289057042708049327651f,-1.2735233142733974887051f,\
0.7534058867095866363073f,0.4695440194018555835065f,-1.4064759963786124252749f,\
0.4697098567590811124539f,-0.4910731440349740406504f,0.9955428392828012951199f,\
1.1510113490256201895789f,-0.1082632054930593029640f,0.4856574660939540488691f,\
2.8432492089162182402617f,-0.2526776656626389394589f,-2.1526240294434693112180f,\
-0.1700067035996372932782f,-1.2942848891673066624719f,0.3501843381023743151381f,\
0.1214335524018897854992f,-0.0093577680302103644072f,-0.8404790744305570271422f,\
-0.2709432496692772418534f,2.129923383430207373124f,0.1924976275921922719281f,\
-0.9958949135265199315015f,0.5029057807067898178133f,2.1223686722196575260568f,\
0.0454634212534271303641f,0.9495546668659169409210f,0.9477155819428292327089f,\
2.5219360071943213164047f,0.6965268573783115479969f,1.0778432726775772909633f,\
-2.5098595900849196560500f,0.4486528645511871360441f,-0.4241938936353907840804f,\
-0.1335517966712884141423f,-0.1078744374453666915459f,0.2327494623534509532448f,\
0.9351842746020352370451f,0.5235744811910800766697f,-0.0660252647673259390748f,\
-0.5945113005344258017004f,0.8805986363667026584068f,1.4189560003612493588321f,\
1.409077916250558226707f,0.696455894185944335284f,0.90951587071067696577f,\
-0.3637587731642325517001f,-0.6227550415243503501017f,-0.8451138025419450139353f,\
-0.9376931811420606832641f,-0.5548689487135263220807f,-0.5854929781645817898905f,\
1.2660172290794624583299f,0.5877121654077364087954f,-1.2764933780334013491142f,\
0.7392453034050661120347f,0.3032161878585472591929f,-0.4000095029594706308451f,\
0.6502681159628262985706f,1.845716594779029051665f}

#define RESULT {1.2435490142739233920821f,0.9079692880976051316821f,2.0827356520772775105854f,\
1.1660452814005672905751f,11.777497445956059962668f,1.8837854434705150197260f,\
1.6307932268341887027674f,0.2817501160466636123125f,1.1112757110437740948328f,\
0.5522896416607726566284f,0.4576577492819154380221f,0.2776152512958051654657f,\
0.3688774179340663095239f,0.5619530154526948262372f,1.456843068428832488337f,\
0.4341522763440999188589f,0.3448128596551297553319f,2.347849472141609439291f,\
1.5382692112870990364115f,1.7025263838493789325668f,4.9406190246302923441135f,\
2.0776466024256405873416f,1.5575716893750450875444f,1.0087445030337489626504f,\
0.43690033557496926742f,0.3678723018579735937195f,0.4390656952911728971856f,\
0.3626230889407328072949f,2.489558777574301107194f,0.6800896814511222521205f,\
0.7711910177313587855252f,0.9202277281636028760659f,5.4462843442294808227189f,\
1.2749912121263455855313f,6.5231035807982653551562f,1.219467910454189230052f,\
0.4907105362925133218432f,1.2845770436515608903250f,6.3044747124787887671005f,\
0.4391975714691279120139f,1.9679429600133448996502f,0.6083029443616727593991f,\
1.054200971008417697661f,2.5594445384876851612432f,0.8914570880611734082777f,\
1.0668533032547884431551f,1.4521642234675371518904f,6.3288547811978252966014f,\
0.5834158405874197983465f,2.5815562199289581180039f,1.0150677236735847763782f,\
1.4179978313495280595191f,1.9703515051800046808950f,0.3451379368940441505487f,\
0.9986808192461388289374f,1.7009165158858785549256f,0.5248339165868535216575f,\
2.120832897097891578397f,0.5314727626805419991030f,0.1689200974890469886258f,\
0.3792597252702665788782f,1.0602713198612101486162f,0.6587130565620143984873f,\
2.9066530672450663352890f,0.8951238652136722651065f,2.6467337728218058856555f,\
0.2085413590449486931355f,4.5187682330848559786318f,4.4707365550132545095607f,\
1.0804054865026515575011f,2.2926132972391299880144f,0.3691099459169989716045f,\
0.5957181306287809841038f,1.5550306685748274126979f,0.4174096039635283306168f,\
0.9656255613686579586386f,2.5281495201925832105871f,1.5710534099579722688844f,\
0.3692833545913285497875f,0.6212319441335979464114f,1.314631699051673319190f,\
0.4196347266560193634000f,0.5588297032433613420466f,2.810868359578304609414f,\
3.921236098173682904644f,2.076108123684798468f,0.1023302265504790059536f,\
0.6916477537748028092679f,0.2926321380214171319345f,0.2533474941164985949626f,\
1.5414702508327886576467f,0.0790838201409621577298f,0.5237745054427331847791f,\
1.4517472697479263388232f,0.3008309638501235339092f,0.6623077968618373834175f,\
0.8332380633061603480982f,0.4930717885873925898643f,0.9291747556935816554358f,\
1.6253298553258777037200f,0.2051642515979318348585f,0.0715299280520010488660f,\
0.8343697186187617464981f,2.2607945137747993413768f,0.6792889117422631350962f,\
1.521757666329790259496f,0.5461585538073224777023f,2.1511277850444776582606f,\
2.0410498879452951825897f,1.1445223776283628414063f,2.5629237613167004106174f,\
0.1111023997465931806294f,0.141979915628105440861f,0.2857676680597394103245f,\
1.470948482105968180278f,16.13100161483945527152f,0.6361045134063019190762f,\
4.882082463582880116348f,0.4123985215384664559934f,3.9758872105147431419425f,\
0.7169823228043985530f,0.7922854429887553617817f,0.4557025166581872288596f,\
0.4819689641868314944340f,0.7548728096296193346149f,0.5727457220779371693808f,\
0.5764306720519700721894f,4.61674832039780813631f,0.5653721791738470781041f,\
0.2543000889430159783267f,1.2003910225327127925254f,1.1970193970806983774224f,\
1.5567325245923557819339f,0.4058509918676029837314f,0.2282606431186239848152f,\
1.5095688084830436448414f,0.681698311719268423836f,0.1775294522772180583203f,\
2.606857448284196188126f,0.6512213336764225424247f,0.279843904757457517807f,\
2.1242225714533806701922f,1.5992647932168715385615f,0.2450051627087996841681f,\
1.5995300330564117263776f,0.6119693104596294341846f,2.706192970479794457361f,\
3.1613885606985867582353f,0.8973913670061375302822f,1.6252431999544321161721f,\
17.171468681707562353722f,0.7767182044255251938125f,0.1161789005908738792172f,\
0.8436591610241814809257f,0.2740938017114021296727f,1.4193291609241254214169f,\
1.129114336496770620855f,0.9906858796267230538035f,0.4315037514894317638436f,\
0.7626597763715156075293f,8.4142221179071938763627f,1.2122736276966128432520f,\
0.3693927220385589405005f,1.6535190604459728547226f,8.350894611450568660871f,\
1.0465127237901119539032f,2.5845584134924157737601f,2.579809559192972390207f,\
12.452681823131790395109f,2.0067707887308077197019f,2.9383355238494659467108f,\
0.0812796509085991214505f,1.5662008789775083705820f,0.6542970055839620879823f,\
0.8749821466412209813868f,0.8977403119208263726492f,1.2620652448583575822028f,\
2.547682887735915890914f,1.6880507842731462542218f,0.9361072134619135010070f,\
0.5518321800737933102710f,2.4123433907357978434050f,4.132803541818598880297f,\
4.0921803308889375117019f,2.0066283869219931901284f,2.4831200911745119341845f,\
0.6950588413666404230540f,0.5364644180251368910106f,0.4295084762729607374965f,\
0.3915299831612857883734f,0.5741474990346947526731f,0.5568312884718313870991f,\
3.546698706809571000065f,1.7998659059051445030519f,0.2790139835869558937453f,\
2.094354315836046254162f,1.3542071959523713786666f,0.6703136760416763539894f,\
1.916054484944200275720f,6.3326360988263932227937f}

#define CSOURCER {0.4962097263673624913949f,0.8910778018246798826141f,0.0947801220713381104011f,\
-0.4603936178711778848260f,-1.0252845699539288037982f,-0.98492140788616533431f,\
0.6666841978684399094846f,-0.8284280082188715255143f,-0.8087801325930177309687f,\
0.4980076621960153326896f,0.7628920854029445086653f,2.8126683658021311984498f,\
1.691339266824742670892f,-0.658296432197564951316f,-0.8165943259043131341457f,\
-0.153838313722479663737f,1.0488069232465311308999f,0.8083896014295570697783f,\
-2.5696290069516263265825f,-0.1755006665720788838758f,-0.4111892069294727503070f,\
0.4347439848326261624401f,0.2238731702156319669506f,0.1031628567688149950010f,\
-0.8488244709313933489270f,-1.4082269940133023133910f,-0.5694039300480933096793f,\
0.6847821865673663355167f,-0.2355866905280663559097f,0.126244929305970754463f,\
-0.7524531768104696372035f,1.547744870456928323321f,1.9472508676223883039569f,\
0.4418443111187473348878f,-1.2649638329504953038196f,-1.8396310805312170444381f,\
-1.8200055182230749917238f,-0.2830037881038854896687f,1.0167783703917296911357f,\
-1.3736934824588333814432f,-1.6523791477656657455952f,2.0750211192468381860010f,\
-2.2299199681252757088146f,0.0617102387651526432255f,-0.1883752530215108134115f,\
0.2017498149536396945258f,-0.3785108864619266544338f,1.4258759859183376406122f,\
-0.2179348061181922979745f,0.1732283900046150681984f,0.1667406411484310679860f,\
-0.6517590587731293405582f,0.2359187276296556834421f,0.2867271206877638478616f,\
0.0606400241806124770672f,-0.0258227029380159664451f,0.0208448589487377940188f,\
-0.1006137675958410082622f,0.6887664099542869511339f,0.1558887949250353788244f,\
0.8324928725743804269754f,-0.3151516259195137337201f,-0.3438938576674008262835f,\
0.0533533125037666533519f,1.410105419112359426137f,-0.72771444778030081046f,\
-0.0273112350183467821052f,-0.1234715201495915903873f,1.6876811670344133986532f,\
1.7843408966113634139816f,0.4553194681918236175200f,-2.482440448619641859551f,\
-0.5647234157267987386675f,0.4002741476630126693514f,2.0575413657607160011764f,\
0.9910894257133318063779f,-0.8534666223545112062610f,1.0313921190741603961527f,\
-0.5817813998765138938651f,0.6420267245927361310365f,-0.9597162563373448085358f,\
0.1578963713606084673380f,-0.3170234887209238405781f,1.1563426252866808585651f,\
-1.9325017123145520336891f,0.6854693920869295853393f,-0.5604369008834102494632f,\
-2.2658178544445064517276f,-0.3315993869783789849137f,-0.3992162906900829644208f,\
-1.538475385459755262474f,0.7929279218821023711428f,0.4799096678735629839530f,\
0.3842559929950347674676f,-0.2870732232583454446306f,-0.5902902430980193626553f,\
-0.7496420812260378152558f,-0.5047035567506975572982f,0.2586980379965187482050f,\
1.5714132313006403673938f,-1.0578766388700049372318f,0.7485548459128271714391f,\
-1.3801279040397811392893f,0.4597603556312274686313f,1.6137862227144141868962f,\
-1.2277987398411676078780f,0.2068847811693011184975f,-0.2479337336106740286024f,\
-0.3541997324021416981843f,0.1707344260894599619061f,-1.1381496515511626554940f,\
-0.8140025532586576684224f,0.0735093571009233642810f,0.3035280587071761959628f,\
-0.2782846453257922791913f,1.6871692459980407452491f,-1.323166422518824214549f,\
-0.0753800807237546693917f,-0.4003058770927516718530f,0.4033101968714281615469f,\
0.1113491527432870636938f,-0.8349617120636146916368f,-0.6907116891918870793532f,\
-0.0170584241359153961082f,0.8194033291997417922659f,0.1556399708519044799981f,\
0.1516310573630105518195f,0.7495489249293494360415f,0.1716685606331417590642f,\
0.4519531238973814590842f,0.9288803038597209793537f,-2.3544674327002401703623f,\
-0.4112942143200571387673f,-1.3097240599804396143924f,-0.6114852145918039383332f,\
-0.8710601639646612381895f,0.3633484479767548624984f,-0.3041452834723618048329f,\
-1.3937055405477738467823f,-0.5975281694506322516247f,-0.6997444046104884796122f,\
-0.3196851144737095085091f,1.09857442199734944843f,-1.77236020622582612916f,\
-0.0885003512087364219152f,1.3820373060805490883496f,-0.3478356988431264840145f,\
-1.5917082966936921817336f,-1.2805101534361520432270f,0.2630673092127150392017f,\
0.3354398592128065015316f,0.3056832398609472534190f,-0.3465598133034439864986f,\
-0.0149898968435104897046f,-0.8499089854435717406034f,1.1188306614388350279654f,\
-0.6366826455916885230124f,0.7478712286232889194793f,-1.1407898077101095157815f,\
1.7416298413146675816421f,-0.6492757257758221545174f,0.9050061520410521698210f,\
-0.7214302149042788325772f,0.1880549880800692907901f,-0.6074290437972867939820f,\
-0.3926402375420063872724f,-2.1738375226761288416810f,-0.3077758151743882342188f,\
-1.4339354091797107404460f,0.5131602976051053977002f,0.0609103217068958785463f,\
-0.0915059705228822850565f,0.2851713506321221225370f,0.3850345796175008161732f,\
0.5344891195679912776484f,-0.3352957511414503266600f,0.5011675332336322785665f,\
0.9817842562968046582483f,0.3201410638941641906285f,2.908782756663177426759f,\
-0.8167435983319983883177f,-0.6395703111646185989869f,0.4768832439562080693918f,\
-2.3940570181394389415175f,1.181268742272832517060f,0.7860988797801938821053f,\
0.2080213710796271764369f,-0.0657191135894376471382f,2.2596861347367309669210f,\
0.7576187360739459197845f,0.0816850726713814895286f,0.713209526903904489359f,\
1.0221713946590338384368f,-1.3357158672812421418286f,-1.3632163488573514342761f,\
-0.1933486222136764076662f,0.1054205318382937656141f,0.8628332102807707570946f,\
0.6890069943729065782279f,-0.1425645528482178403529f}

#define CSOURCEI {0.4187679309893236334617f,0.9571040727588696617190f,1.172760842677368797737f,\
0.8367787345559263290085f,0.0537934646406551114639f,-0.3937773223205939254754f,\
1.7876375988580777143255f,-0.5864530819794440130721f,-0.9799596671663597380331f,\
-1.435491321041636902933f,-0.7958478780018579668010f,0.5425829186077295585022f,\
-0.6690160051984340716658f,0.4469912205186009623858f,-0.2043520888417388603475f,\
-0.4718547031305261874046f,1.2345904036110504353729f,0.2305518055397126619965f,\
1.0780366202665678798667f,0.4904320988250001067676f,-0.2652022209879114633679f,\
-0.9976659763947106629445f,-1.349099117857334384496f,-0.4904839979026296425957f,\
0.5445911400019642911730f,1.5676016792969027502380f,0.9705535858979048580153f,\
1.562322752104617240576f,0.9312705713450669664510f,-1.491064034017491879425f,\
0.5387480326121706353248f,0.2780267771815282396020f,-0.6792511192992195523388f,\
-1.7001946270260519522566f,1.1064967394734230854425f,0.6449691334115315033415f,\
1.010191395265231717460f,0.7617257042808376343856f,0.7130320908537892687917f,\
1.3873980946032253847022f,1.0464400502880701893105f,0.7743318486747019502303f,\
-1.0385544825558827852774f,0.2570923151837984921286f,-0.8100639413180467096609f,\
0.9637587964856539901604f,1.5615765140914361630564f,0.5804915960065005764434f,\
-0.2022297555607953933876f,0.6091855774356720321094f,-0.5513582447276994535912f,\
-0.4240953703415643594177f,-0.8690915476323599619946f,-1.0352497689734347918744f,\
0.3275700398280019243202f,-0.7970043301223290743707f,0.2341992112983941609627f,\
-0.2288430429610794625273f,1.213479264737873375424f,0.9031823906644896871043f,\
1.4754958638303785622981f,1.6520423035243945175665f,0.8178319166692843422695f,\
-0.4286042039456253727181f,0.4413804125451418203241f,-0.8566414495458910538517f,\
-1.3669367412247732662678f,2.0376720143917643746079f,-1.8253356531263227324757f,\
1.5266365006585700392350f,0.1161871811298216261576f,-0.6659495480394291844206f,\
-0.5450277852280467349999f,1.2558648076421243811041f,-0.7854748651398538727975f,\
-2.1498185127975446562232f,-1.4516576281976432127863f,0.4432114256783392658434f,\
-0.0042605582120147401926f,-0.0805101613497762047533f,-1.1324416682104487819061f,\
0.1150256099470636506066f,1.3050405907321147580546f,-1.0622634828383090699333f,\
-1.35922814179336781670f,-1.703726701643710983447f,-0.282327674589286536921f,\
1.4699227361546476355869f,1.2714945342939698580409f,0.8438338325656443705824f,\
1.6086130230417976516577f,-0.8654237444216958952126f,-2.1306341506077157710308f,\
0.4262366479533865049056f,1.2202306126621282889033f,-0.4781944951046422920271f,\
2.2327961471769124379705f,0.6988675202840052280706f,-1.1016041402782228431079f,\
-0.0366155088206388534822f,0.9663901570211483882389f,-0.3288372819689815984567f,\
1.8550047995758884855633f,-0.9247532047817873523954f,-1.1547662665953339899971f,\
1.4270134659704167834349f,-0.2267973730507581442417f,1.4593991828148868972193f,\
-0.8205572609516469384516f,-0.3297213070039397009303f,-0.5787995844520394950194f,\
1.8452573890170231862840f,-0.5998455574460443973095f,0.5461062118050383773493f,\
0.3989213456307151295377f,0.6223400150931739371885f,-0.661605777551548035476f,\
-0.806522789665139905324f,-0.2812497112451433634028f,-0.4100128914055168882768f,\
-1.50945722493549672194f,0.4603669785905236677692f,-0.4126050173509914209546f,\
1.6611257451475334168123f,-0.8697907951355576816610f,0.6696537851786207307114f,\
-0.5134482200325719558620f,0.1007092240430608326429f,1.2778361566544564897896f,\
1.2322028231309287704676f,0.2307590408528507608388f,1.5263506644977615778203f,\
-0.8569947230359247214437f,1.1048772379802629384216f,-0.2109985124170330184068f,\
-0.0551453334787995949617f,0.1230778288705814127457f,-1.423405390861443020611f,\
-0.394586285353004440069f,-0.2879823286948200999902f,0.1062021177580684955233f,\
-0.6907035832345697068391f,0.3653158847737960068791f,0.9338855454474609407711f,\
-0.4120224826154939568035f,-0.1450379965292624417916f,-0.9040960399672915981384f,\
-0.3390386771829260181832f,1.625054083669380089461f,0.4716305826679590418316f,\
0.6165901874856758446697f,0.4270688825812783973035f,-0.8343519087812022450024f,\
-0.5142102680242138790234f,-0.3269678763130224319333f,-0.4453255190855087697344f,\
-1.2280852212014194968503f,0.0988020658802584578195f,0.7533305302295955074854f,\
0.1183515262592216288340f,0.4361801271894044096378f,-1.203233821600386388440f,\
0.6270203182178656353685f,-0.2147899120281239748742f,-1.6199408065241285293f,\
-0.3813310069938283253244f,-0.952339709740829487572f,-1.3753328967678597472002f,\
0.1397812751994848834425f,1.043902134788026403456f,1.1627380196617531638026f,\
-1.0121704799221244996943f,1.0517816399459063436694f,0.0479426304050067017548f,\
-1.9256009187313227748461f,0.0702119825151238802219f,-1.5960860779727858993482f,\
0.3892567541356096727512f,-0.3405739777798729162051f,-2.3927967690864724303879f,\
1.4571677327957668346414f,1.7033833498531005812282f,1.4103109856750082329313f,\
0.8887233594164675176685f,1.085007779468186495109f,-0.1517851031708108977547f,\
-1.4279908879739833249545f,0.8317119599758505676945f,-0.100625285489182120235f,\
-0.0641469431098572184791f,0.9441650291895723468016f,1.7557389523285045207501f,\
-1.4553402741895795635685f,0.8280178925672729839391f,0.3768033744738639723160f,\
0.769460862052703697955f,1.7363387952951863102413f,0.2883880023549790228010f,\
0.1937130526956079012990f,0.7931867418127547253448f}

#define CRESULTR {1.5005579968888511643854f,1.4038788522636540534450f,0.4261430281005708642361f,\
0.4227040163485943913280f,0.3581755188101993225835f,0.3448856718113299524298f,\
-0.4190544272790215352131f,0.3637606739341552875011f,0.2481133547640819725366f,\
0.221957537083997319405f,1.5004406253943489701896f,14.262372555443052490887f,\
4.2569132214783609313713f,0.4668662514373775884735f,0.4327387090783468837074f,\
0.7637186245018753316671f,0.9416373255706453893055f,2.1849079400266222528160f,\
0.0362192687509753849517f,0.7401390786280732658753f,0.6396875438787329448687f,\
0.8375646978007738052696f,0.2750576263630330475785f,0.9779650400990845815485f,\
0.3660147454727735727431f,0.0007813344853740371429f,0.3196234331185683896770f,\
0.0168057767355581332003f,0.4715477957119850183076f,0.0903652551480593341227f,\
0.4044631913155857239062f,4.5203389894684722349893f,5.4536105990647092411905f,\
-0.2007273149144214174910f,0.1263903817022170861240f,0.1269607449461356840636f,\
0.0861483947375209779818f,0.5452795580354135029921f,2.0908477302753070148356f,\
0.0461711120003356623176f,0.0959224290498517928594f,5.6938820505915233027849f,\
0.0545714270555244795879f,1.0286954018234739649529f,0.5710758281447196882397f,\
0.6979532622664902374865f,0.0063143806135506170760f,3.4798191533417077714319f,\
0.7877896535828416979541f,0.9752288031986856564615f,1.0063735441532775105600f,\
0.4749622284565679919410f,0.8172752232835529540012f,0.6797654131732457916115f,\
1.0060191413953609718135f,0.6810372893714221609329f,0.9931890911476703998062f,\
0.8807071418681532426476f,0.6964662788868779541573f,0.7235561661943166189559f,\
0.2187683453764143193254f,-0.0592182210929489902251f,0.4848204523909904195555f,\
0.9593919417277750882889f,3.7038010572869821679376f,0.3163625232453476932015f,\
0.1969961410854516870028f,-0.3978181614570159285726f,-1.361462433143773242961f,\
0.2629151417766518727959f,1.5660468223975476664833f,0.0656893454691978989635f,\
0.4861465273206775350445f,0.4622214272783724542393f,5.5338903531227128240744f,\
-1.474264258662732141048f,0.0506254763419271280878f,2.5339495141019958701634f,\
0.5588967788586440832432f,1.8941728912398605455536f,0.1625651067402884841773f,\
1.1633063892460699940f,0.191283239298288054719f,1.547496475194143350507f,\
0.0304040029736053936393f,-0.2630510364909662279764f,0.5483550218772245132826f,\
0.0104474069781232917903f,0.2116381376777875800155f,0.4458460510519014485808f,\
-0.0081176195921236100894f,1.4326892345597483924280f,-0.8581368290819433308769f,\
1.3371299915531948965253f,0.2577287469128092811665f,0.4920040313161565537214f,\
-0.2904655234170689381834f,0.462163508824150970344f,0.5856645720520745612703f,\
4.81021957957627943614f,0.1973001680885165531887f,2.0006745533290084537725f,\
-0.0705330419570823624609f,0.9534341938168940933096f,2.0294673010324730810794f,\
0.0419743009154483204259f,1.198346516707147646486f,0.0867559391436964755240f,\
0.4784523700257174994022f,1.1222795076752876131110f,0.2682227152927741387067f,\
-0.1200874658138830208820f,0.8883849124062789259781f,1.1576031776174615650632f,\
0.6976356512079191496412f,4.3909706615004120422441f,0.2101052025810229428870f,\
0.6417663596495127853458f,0.6437857682896207522916f,1.3727122635941697570416f,\
0.0685209480693795836004f,0.3887184828749501441791f,0.4591565751761637059758f,\
-0.0886808967743262233085f,1.4635680657432861284661f,0.9160726657458563293446f,\
1.0136746786541579457008f,2.1053235388732902677589f,0.3428728910762353088160f,\
0.5219502401364545240980f,2.4645660104152655733856f,0.0042184623117796499203f,\
0.4339378404381282194890f,0.1212485246955130047120f,0.5305120745426482598006f,\
0.4178714460322863755160f,1.42725807301201368382f,0.1083449257198766668697f,\
0.2290848259097614525448f,0.5275132726780440428627f,0.4939136954488312358791f,\
0.5598904753492991437369f,2.8019267774958218630843f,0.1010607343958155046604f,\
0.838703631682240602f,3.9411880425167020725041f,0.4367206268973685134860f,\
0.1919888550719570374792f,-0.0150705892655913463452f,1.1588916915452081024540f,\
1.1410183495054209146247f,1.2356219575708369262657f,0.4749404480211336654349f,\
0.8577273295080861670314f,0.4048075578221899673004f,2.7627080603314042583918f,\
0.1777810656017677348739f,2.1021956426305754561668f,0.2330964886175431460824f,\
5.66671671967639412060f,0.4735105506685184928450f,0.8882739731815125772130f,\
0.3935986079583607688548f,1.1791667609118299253623f,-0.0267606605538480354922f,\
0.6267669571981022702545f,0.0659441611256419563114f,0.1427681092204574897497f,\
0.2360440610261224370081f,0.8400442654362825223302f,0.4217500256271256020568f,\
0.4836741737176751265714f,0.659708006511050548681f,1.4679764549267637629981f,\
-0.5928767353529774686294f,0.7133645918582519618312f,-0.0417400106828591799246f,\
2.46953429512858368966f,1.2982129272812710230056f,-13.430164449559464756589f,\
0.0501008887550637785346f,-0.0697374371031275891442f,0.2574407425697148865673f,\
0.0575298048786480678563f,1.5214153238495213837922f,2.1695830700438989424583f,\
0.1752306830704533635590f,0.6307656294349494041640f,9.5316214402790411241995f,\
2.1288031244453153867369f,0.6363319322612546180551f,-0.3752333236632875990146f,\
0.3201657030914684676226f,0.1778562682310512732542f,0.2378885254191149545289f,\
0.5920073359495072740089f,-0.1831081087669608753465f,2.2719985676152019138385f,\
1.9544837479586136819165f,0.6083604660209539494176f}

#define CRESULTI {0.66789173388469347259f,1.9929317082415038964172f,1.0134693185160317252524f,\
0.4685368189063157107199f,0.0192861086704356442245f,-0.1432921900711904839021f,\
1.9021551721948490865088f,-0.2416937871379007396477f,-0.3698944066530311935992f,\
-1.630400797414071512037f,-1.53213128993891678498f,8.5994415909131678432686f,\
-3.3657446415150640284253f,0.2237921440211748103088f,-0.0896829281433757230513f,\
-0.3897266612271670926937f,2.6944436446476398572258f,0.5128535974480390446928f,\
0.0674551867661900700357f,0.3951923071518532726287f,-0.1737389326052603821804f,\
-1.2977574398167355251843f,-1.220297105474789312041f,-0.5222431149169146635813f,\
0.2216906290760837783260f,0.2445752865761168237668f,0.4669490113374816231406f,\
1.983268587510182312528f,0.6339653057626817300729f,-1.1309555970451541373478f,\
0.2417594109687444814405f,1.2901913158229225686568f,-4.40337349863430294050f,\
-1.5425684980543696855904f,0.2523692809573465090089f,0.0955121010048793767089f,\
0.1372242993017437351355f,0.5200557398879992465623f,1.8081956965026793060503f,\
0.2489243937541025242233f,0.1658522561714183829462f,5.5692357559437404290748f,\
-0.0926616074754614826858f,0.2704548071084568183764f,-0.5999663537818090697229f,\
1.0049457307841926922976f,0.6848514061793418150614f,2.2823134654584236180597f,\
-0.1615224571979621548401f,0.6804242491001384340876f,-0.6188951521875099004433f,\
-0.2144424405243884335093f,-0.9669529580119747835809f,-1.1455586484969144667190f,\
0.3418574459217512129250f,-0.6970321107785095726683f,0.2369522455719338394076f,\
-0.2051372202341115724700f,1.8654869710971573315561f,0.9177784888023613474317f,\
2.2886105642667078363672f,0.7272712824943110554443f,0.5173355346085974915127f,\
-0.4383775740596613790245f,1.7499274197824987719940f,-0.3649863488832993385635f,\
-0.9529087376623858185454f,0.7892565481221736067852f,-5.2327138940157267299469f,\
5.9498471753939741191175f,0.1827777741034706804335f,-0.0516109653428112533091f,\
-0.2947431961312417803001f,1.4188420873857061632606f,-5.534739336307598733811f,\
-2.255013513539458447354f,-0.4229165121855131270756f,1.2028903349471207206989f,\
-0.0023812266691438442427f,-0.1528305178806574626815f,-0.3467892290786088183019f,\
0.1344033089941876202289f,0.7027456808048029301972f,-2.7761066302583010667604f,\
-0.1415572225289876973076f,-1.9671936933888867216069f,-0.1590647203810587884121f,\
0.1032177704018006486608f,0.6858644064375456483873f,0.5012535303694961585919f,\
0.2145546901849673948615f,-1.6825191334017586264338f,-1.3692428047734856999540f,\
0.6071558835309880386433f,0.7048129294793062937785f,-0.2550146122571063656004f,\
0.3727193608915256306524f,0.388381095349859650767f,-1.1552707405821953656755f,\
-0.1762073913025017923850f,0.2856835610783352019659f,-0.6826826797070948416035f,\
0.2414553165222597663764f,-1.2645359787455874300832f,-4.5934329346040874142432f,\
0.2899138963758796094794f,-0.2765396421605960108892f,0.7755744714874250878012f,\
-0.5133371708548779555059f,-0.3840592062347947810430f,-0.1752712350242682792789f,\
0.4264971552447213154480f,-0.6075754177972138014852f,0.7035454748522144141631f,\
0.2940690048846716919684f,3.1502912129208726632612f,-0.1636049555981854697340f,\
-0.66946985566275640789f,-0.1859947683471395718513f,-0.5966446238894932418972f,\
-1.1156829506070020663344f,0.1927677941084386115111f,-0.2009874518146967659060f,\
0.9790782744873792742268f,-1.7340674208694739633074f,0.7252463079270474732851f,\
-0.5716056662861231929540f,0.2127452321317529204681f,1.1366978856910239237266f,\
1.4821597980401888250412f,0.5790353877850622499324f,0.0948502955617512716335f,\
-0.5009900731541635510169f,0.2411262068342296116530f,-0.1136285464587050847429f,\
-0.0230670473414846290139f,0.1765562266540864622133f,-0.7297546590556842627251f,\
-0.0953969444497970303631f,-0.1562582727501122537017f,0.0526527844386815990774f,\
-0.4627604755682861448207f,1.0716924742142539539458f,0.1366141387590569244992f,\
-0.3665452417574971422098f,-0.5756642515297435425126f,-0.5549906098825418965248f,\
-0.0677059511108183409434f,0.2774865464288255867409f,0.5910566892682205253351f,\
0.8087239218207783464365f,0.5623045509398011398972f,-0.5238753172271245484026f,\
-0.4845296390188432167356f,-0.1372866414817625335676f,-1.3186482320231969200819f,\
-0.4982790611331439079024f,0.2083797712931309276119f,0.2186064764396851156647f,\
0.6738135687471651369407f,0.2207138713569412324933f,-2.3068359206298949537484f,\
0.2851861631055106482968f,-0.2572412622481385358064f,-0.5440918958783450554151f,\
-0.2513065277256731899769f,-0.0926726651078676189055f,-0.7210825269104839119194f,\
0.0332111240217310629830f,1.4439889712068714189286f,0.9755400591442719981927f,\
-0.7738329957764321642699f,1.1548413262354173536295f,0.0704326239228644929158f,\
-1.6002810307194081929083f,0.0501692094503282184914f,-1.6501195063537017482247f,\
1.012969261434880197115f,-0.4600643435261628222399f,-12.481321255158581706723f,\
0.4390187012381037146014f,0.5228891202405995253244f,1.5903431490098800527022f,\
0.0708411654197008272549f,2.8815196278940593543894f,-0.3318628781486120393751f,\
-1.218706228014425851924f,0.6920752550579561956923f,-0.9623724741584287478702f,\
-0.1367438235977035676516f,0.8789505770880949864221f,2.005732337058288017317f,\
-2.760719914038102906773f,0.1937015573007111746140f,0.0941350707005644549152f,\
0.5734318083679456057311f,1.095987006643926342520f,0.6740067391703287169591f,\
0.3834169282796987543449f,0.6179115751021659885822f}




void sexpsTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out;
	int i;

	for (i=0;i<200;i++){
		out=sexps(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<1e-6);
	}
	
	assert(( (fabs(sexps(0)-1))/(fabs(sexps(0))) )<1e-6);
	assert(( (fabs(sexps(1)-2.7182818284590450907956))/(fabs(sexps(1))) )<1e-6);
	assert(( (fabs(sexps(2)-7.3890560989306504069418))/(fabs(sexps(2))) )<1e-6);
	assert(( (fabs(sexps(3)-20.085536923187671476398))/(fabs(sexps(3))) )<1e-6);
	assert(( (fabs(sexps(4)-54.598150033144236203952))/(fabs(sexps(4))) )<1e-6);
	assert(( (fabs(sexps(5)-148.41315910257662835647))/(fabs(sexps(5))) )<1e-6);
	assert(( (fabs(sexps(6)-403.42879349273533762243))/(fabs(sexps(6))) )<1e-6);
	assert(( (fabs(sexps(7)-1096.6331584284580458188))/(fabs(sexps(7))) )<1e-6);
}

void cexpsTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=FloatComplex(inR[i],inI[i]);
		out=cexps(in);
		assert(( (fabs(creals(out)-resR[i]))/(fabs(creals(out))) )<8e-6);	
		assert(( (fabs(cimags(out)-resI[i]))/(fabs(cimags(out))) )<1e-6);			
	}
}

void sexpaTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out[200];
	int i,j;
	float mon_test[6]={1.0f,4.0f,2.0f,5.0f,3.0f,6.0f};
	float result_mon_test[6]={2.7182818284590450907956f,54.598150033144236203952f,7.3890560989306504069418f,
	148.41315910257662835647f,20.085536923187671476398f,403.42879349273533762243f};
	float out_mon_test[6];
	j=1;
	sexpa(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<1e-6);
	}
	sexpa(mon_test,6,out_mon_test);
	for (i=0;i<6;i++){
		assert(( (fabs(out_mon_test[i]-result_mon_test[i]))/(fabs(out_mon_test[i])) )<1e-6);
	}
}

void cexpaTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in[200],out[200];
	int i;

	for (i=0;i<200;i++){
		in[i]=FloatComplex(inR[i],inI[i]);
	}
	cexpa(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(creals(out[i])-resR[i]))/(fabs(creals(out[i]))) )<8e-6);	
		assert(( (fabs(cimags(out[i])-resI[i]))/(fabs(cimags(out[i]))) )<1e-6);			
	}
}


int testExp(void) {
  printf("\n>>>> Float Exp Tests\n");
  sexpsTest();
  cexpsTest();
  sexpaTest();
  cexpaTest();
  return 0;
}

int main(void) {
  assert(testExp() == 0);
  return 0;
}
