/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testLog10.h"

#define SOURCE {0.3628176329657435417175,0.924179898109287023544,0.5243524145334959030151,\
0.7886543427594006061554,0.6525151440873742103577,0.2477638195268809795380,\
0.2364655844867229461670,0.7240293831564486026764,0.8278210600838065147400,\
0.4287728047929704189301,0.4858888480812311172485,0.5923984018154442310333,\
0.0949383648112416267395,0.1356843891553580760956,0.9917455688118934631348,\
0.7212927364744246006012,0.0115638775750994682312,0.0211908905766904354095,\
0.1524727698415517807007,0.9165380974300205707550,0.4467271203175187110901,\
0.5868234331719577312469,0.1882771886885166168213,0.4196520284749567508698,\
0.2730510598048567771912,0.7565603456459939479828,0.9378882069140672683716,\
0.0586007428355515003204,0.5101847248151898384094,0.5031699347309768199921,\
0.7783576548099517822266,0.6856653341092169284821,0.1381576983258128166199,\
0.371037633623927831650,0.6366564910858869552612,0.4961673622019588947296,\
0.2994064847007393836975,0.2392275254242122173309,0.5618183575570583343506,\
0.3218038142658770084381,0.1082227518782019615173,0.1685282415710389614105,\
0.8263800088316202163696,0.4923414406366646289825,0.7863734485581517219543,\
0.6762332352809607982635,0.0258686169981956481934,0.3594204657711088657379,\
0.3436427963897585868835,0.2824054299853742122650,0.1450859513133764266968,\
0.0762176741845905780792,0.5220461571589112281799,0.6713762427680194377899,\
0.0599394328892230987549,0.7267188713885843753815,0.2224657749757170677185,\
0.3122289828024804592133,0.4435700643807649612427,0.3983507198281586170197,\
0.1324583934620022773743,0.8820166247896850109100,0.5455272346735000610352,\
0.2917219498194754123688,0.7739847479388117790222,0.3354639573954045772552,\
0.8127403985708951950073,0.4612239454872906208038,0.6898109326139092445374,\
0.9649041066877543926239,0.8210376314818859100342,0.2802407057024538516998,\
0.9873316427692770957947,0.294199434574693441391,0.4859610591083765029907,\
0.2247181800194084644318,0.9585652919486165046692,0.1503968122415244579315,\
0.0216291621327400207520,0.0688429796136915683746,0.9950710041448473930359,\
0.7568672685883939266205,0.6163959559053182601929,0.0865804632194340229034,\
0.5165374809876084327698,0.1916800136677920818329,0.2940570451319217681885,\
0.3528221980668604373932,0.1317937439307570457458,0.0549608371220529079437,\
0.929352553561329841614,0.737892795819789171219,0.7509917514398694038391,\
0.6889848816208541393280,0.8865169286727905273438,0.6891661235131323337555,\
0.8677108911797404289246,0.7947537912987172603607,0.2496256213635206222534,\
0.3935408894903957843781,0.7297343472018837928772,0.7888072351925075054169,\
0.113488640636205673218,0.4145256043411791324615,0.6172473421320319175720,\
0.7440188056789338588715,0.9038409832864999771118,0.3976829168386757373810,\
0.9472072543576359748840,0.2581262919120490550995,0.1955799385905265808105,\
0.9381833248771727085114,0.4226356102153658866882,0.0937463282607495784760,\
0.9977992679923772811890,0.2042182614095509052277,0.9455819511786103248596,\
0.9336234177462756633759,0.9743702597916126251221,0.4100225553847849369049,\
0.5125095760449767112732,0.0948633304797112941742,0.5688196588307619094849,\
0.7322562676854431629181,0.8108531581237912178040,0.5459008770994842052460,\
0.5022544711828231811523,0.7634959020651876926422,0.7354982374235987663269,\
0.0699520572088658809662,0.6130836438387632369995,0.0965849910862743854523,\
0.5439325878396630287170,0.9187005828134715557098,0.5072866193950176239014,\
0.1335940570570528507233,0.8688194593414664268494,0.7999687767587602138519,\
0.9879787657409906387329,0.7131399479694664478302,0.3067426951602101325989,\
0.5431228461675345897675,0.7330236807465553283691,0.6498145484365522861481,\
0.8018737239763140678406,0.2859625308774411678314,0.1894423719495534896851,\
0.7794728656299412250519,0.5433104271069169044495,0.5268451268784701824188,\
0.1533693112432956695557,0.6041304902173578739166,0.5948378806933760643005,\
0.8857938847504556179047,0.0043053645640611648560,0.1302204323001205921173,\
0.9758609728887677192688,0.9183407831005752086639,0.0624175965785980224609,\
0.9939593323506414890289,0.4122588960453867912292,0.8258536770008504390717,\
0.0376359503716230392456,0.4675730471499264240265,0.4759115139022469520569,\
0.4060978214256465435028,0.0392968021333217620850,0.4401316107250750064850,\
0.3316476037725806236267,0.0877817696891725063324,0.1150833908468484878540,\
0.9667435702867805957794,0.8103649737313389778137,0.3928376468829810619354,\
0.7880131229758262634277,0.4798596971668303012848,0.0270724548026919364929,\
0.6701857983134686946869,0.5602217521518468856812,0.2564360727556049823761,\
0.2626037681475281715393,0.4447338129393756389618,0.8522944338619709014893,\
0.2347065494395792484283,0.3277532672509551048279,0.2253599218092858791351,\
0.3468936551362276077271,0.7743145865388214588165,0.1285835551097989082336,\
0.1156307714991271495819,0.2054340392351150512695,0.4535544612444937229156,\
0.6516549764201045036316,0.0710035725496709346771,0.1265540253371000289917,\
0.4974718545563519001007,0.0879269847646355628967,0.1462626229040324687958,\
0.715134423226118087769,0.9305738122202455997467}

#define RESULT {-0.4403116143527589509965,-0.0342434820791150257291,-0.2803767278195338774616,\
-0.1031133008775467624352,-0.1854094044230032989340,-0.6059621125162122368124,\
-0.6262320581190643498104,-0.1402438085490333719019,-0.0820635291772953134881,\
-0.36777276786493884320,-0.3134630685689411833117,-0.2273861217978072890578,\
-1.0225582527058232340522,-0.8674701161846418706602,-0.0035997313073961446743,\
-0.1418884411982046234169,-1.9368965147824408479238,-1.67385079107519252339,\
-0.8168077101761380687250,-0.0378494781542935143648,-0.3499576811822522337536,\
-0.2314925521326422763746,-0.7252022951018919361132,-0.3771106732935153860176,\
-0.563756133479260124197,-0.1211564255577455423429,-0.0278489249618575039624,\
-1.232096878737263700998,-0.2922725485247071319783,-0.2982853166297994018663,\
-0.1088207991305185085018,-0.1638878070544614040660,-0.8596249106224531644216,\
-0.4305820385081238765856,-0.1960948286770107240606,-0.3043718069355866306935,\
-0.5237387977162476504489,-0.6211888520577832917269,-0.2504040742204550751282,\
-0.4924088126148459254594,-0.9656814270628060192792,-0.7733273106340565750116,\
-0.0828201974893169740044,-0.3077336078949636233304,-0.1043711586288077197704,\
-0.169903488488286208424,-1.5872267891461315780788,-0.444397197348344763501,\
-0.4638927555552059822652,-0.5491269570890252582629,-0.8383746383028719550978,\
-1.1179443080462672099884,-0.2822910967808678894819,-0.1730340307038858715938,\
-1.222287370403489781268,-0.1386335619293298515586,-0.6527367931436293124747,\
-0.5055267858124582458501,-0.3530377711634032356081,-0.3997343937184095197246,\
-0.8779205166514928437849,-0.0545232289425809854566,-0.2631835629983380608898,\
-0.535030892349513287343,-0.1112675973936914503026,-0.4743541340498391156721,\
-0.0900481524037324287946,-0.3360881534089125155518,-0.1612699269064814533436,\
-0.0155158452113394202537,-0.0856369369482974790442,-0.5524687820481442024345,\
-0.0055369441569604379433,-0.5313581662832899121796,-0.3133985301037985338191,\
-0.6483617911201521311071,-0.0183783001388101094320,-0.8227613688014733250853,\
-1.664960303869991609105,-1.1621403411076904887977,-0.0021459286933866758389,\
-0.1209802758154948920666,-0.2101402192945755753595,-1.0625800949711647902518,\
-0.2868981597290535812128,-0.7174231683233029954749,-0.5315684111428640168384,\
-0.4524440987253919854716,-0.8801052046193623690229,-1.259946661051862371039,\
-0.0318195034221232311844,-0.1320067297295647867905,-0.1243648330674980567734,\
-0.1617903077014812007750,-0.05231296682112057672,-0.1616760787761070405910,\
-0.0616249514134949369359,-0.0997673916469928034889,-0.6027108410820325445911,\
-0.4050101371105858660826,-0.1368352118545152207307,-0.1030291145605434360855,\
-0.9450476059237150616710,-0.3824486388636323952461,-0.2095407714646851937701,\
-0.1284160871700188444322,-0.0439079701395359081606,-0.4004630644881080336894,\
-0.0235549844857810899978,-0.5881677573670978098619,-0.7086756945701918608549,\
-0.0277122904020632616906,-0.3740339131793987692554,-1.0280457331716890134743,\
-0.0009568190047624330983,-0.6899054254479447534365,-0.0243008259915241074667,\
-0.0298282635710438621957,-0.0112759802587220972492,-0.38719225203706036931,\
-0.2902980155704742437628,-1.0229016321238477704725,-0.2450254024783888040506,\
-0.1353369023236559165468,-0.0910577874542803367142,-0.2628862079121005446147,\
-0.2990761883748661031923,-0.1171932896033063276064,-0.1334183636952847862300,\
-1.1551995088873641126526,-0.2124802700500995344957,-1.0150903559327661973555,\
-0.2644549211536121879895,-0.0368260081130531435889,-0.2947465928364439435860,\
-0.8742128610575919944736,-0.0610704605568186745246,-0.0969269634405601765437,\
-0.0052523894413354609012,-0.1468252349912699539214,-0.5132257708646462690538,\
-0.2651019284616369375840,-0.1348819950022109859233,-0.1872105696377188988055,\
-0.0958940173743543372575,-0.5436908679171403857566,-0.7225228772557727996428,\
-0.1081989985152894545584,-0.2649519599919711310143,-0.2783170326568494279407,\
-0.8142615327667455105143,-0.2188692450535288658298,-0.2256013823621523806118,\
-0.0526673222769318341574,-2.3659900680299497111037,-0.8853208672348196195401,\
-0.0106120501693722224523,-0.0369961284323869002422,-1.2046929580793401814987,\
-0.0026313843119589821508,-0.3848299640358096573856,-0.0830968932369530594029,\
-1.424397112818484689711,-0.3301505313242010797303,-0.3224737880280506563402,\
-0.3913693403433980977368,-1.4056427898881791449526,-0.3564174388206851062932,\
-0.4793231362281260010683,-1.0565956679830132980413,-0.9389873504280431548707,\
-0.0146887076937459951781,-0.0913193386792951061759,-0.4057868990671495423861,\
-0.1034665500376885233225,-0.3188857244019617231956,-1.5674723626658799702227,\
-0.1738047793945742269806,-0.2516400325061770026913,-0.5910208828319416518582,\
-0.5806990464341352797817,-0.3518998500546973717817,-0.0694103478250598926458,\
-0.6294747913311795617375,-0.4844529702954271654924,-0.6471233167047535372873,\
-0.4598036435552441125729,-0.1110825594195994081570,-0.8908145709277390800196,\
-0.9369265766947033613476,-0.6873275946862682506122,-0.3433705568996603396670,\
-0.1859822838651877530136,-1.1487197991742361669054,-0.8977240365674604705148,\
-0.3032314852833657981002,-1.055877819626311886481,-0.8348666427090224440022,\
-0.1456123165510203598672,-0.0312491733461308825170}

#define ZSOURCER {0.3140813848003745079041,0.5769402063451707363129,0.1306138429790735244751,\
0.0478980806656181812286,0.4500174494460225105286,0.0384718659333884716034,\
0.483350999653339385986,0.2981918179430067539215,0.7112689120694994926453,\
0.9268360524438321590424,0.9477838929742574691772,0.1729496796615421772003,\
0.2750928336754441261292,0.0044281478039920330048,0.0611358620226383209229,\
0.1950612799264490604401,0.3789803450927138328552,0.2549188635312020778656,\
0.1764185149222612380981,0.6008180272765457630157,0.3703392641618847846985,\
0.2908470141701400279999,0.5384815335273742675781,0.8090293356217443943024,\
0.9260985879227519035339,0.1576966657303273677826,0.9518593531101942062378,\
0.2709982101805508136749,0.1609848598018288612366,0.8782086591236293315887,\
0.5091647170484066009521,0.7951062084175646305084,0.8432204117998480796814,\
0.5806765086017549037933,0.3487791065126657485962,0.9397577759809792041779,\
0.4363934816792607307434,0.5549766751937568187714,0.9105900451540946960449,\
0.5684339576400816440582,0.1862502051517367362976,0.0800832151435315608978,\
0.6585252787917852401733,0.1606054832227528095245,0.9711584830656647682190,\
0.3668168033473193645477,0.7386338301002979278564,0.9722552285529673099518,\
0.1349937235936522483826,0.4595781317912042140961,0.5414639282971620559692,\
0.6397600513882935047150,0.0211964594200253486633,0.4408156829886138439178,\
0.6374878138303756713867,0.3208820023573935031891,0.4267518399283289909363,\
0.7819778784178197383881,0.0543234180659055709839,0.9666189108975231647491,\
0.6948409983888268470764,0.1846996019594371318817,0.3645029179751873016357,\
0.8176643461920320987701,0.664914294146001338959,0.7559730983339250087738,\
0.5525381658226251602173,0.7192269531078636646271,0.1989364298060536384583,\
0.8610532465390861034393,0.1300329938530921936035,0.347959163133054971695,\
0.5025534434244036674500,0.4978472082875669002533,0.4675923939794301986694,\
0.9447452803142368793488,0.9599315756931900978088,0.5365384514443576335907,\
0.8122785724699497222900,0.6470989421941339969635,0.7010180121287703514099,\
0.6681951484642922878265,0.9593638796359300613403,0.0149199557490646839142,\
0.6199735002592206001282,0.4061129498295485973358,0.0471306145191192626953,\
0.8433605083264410495758,0.0635268418118357658386,0.9836421324871480464935,\
0.4434677045792341232300,0.8565507535822689533234,0.9080012599006295204163,\
0.4922491232864558696747,0.1930142603814601898193,0.3759337724186480045319,\
0.2437626412138342857361,0.1035623974166810512543,0.9936000052839517593384,\
0.5569599089212715625763,0.3858396532014012336731,0.7191527518443763256073,\
0.1707325801253318786621,0.2878904812969267368317,0.4294657362625002861023,\
0.8917979537509381771088,0.6188817229121923446655,0.3444608678109943866730,\
0.0692929709330201148987,0.3619817639701068401337,0.1783103235065937042236,\
0.8941529677249491214752,0.9010278200730681419373,0.0533773354254662990570,\
0.4162023533135652542114,0.9438270372338593006134,0.9242387460544705390930,\
0.8710649865679442882538,0.2808376699686050415039,0.8244629004038870334625,\
0.4650857029482722282410,0.1462343498133122920990,0.5975636970251798629761,\
0.3067605351097881793976,0.2377215037122368812561,0.0711208949796855449677,\
0.8753139786422252655029,0.4413500339724123477936,0.7631150623783469200134,\
0.9679268277250230312347,0.3924236092716455459595,0.717360940296202898026,\
0.8640465112403035163879,0.7354763629846274852753,0.0304915383458137512207,\
0.6331009590066969394684,0.4550241930410265922546,0.3173553734086453914642,\
0.8250397499650716781616,0.2725940425880253314972,0.3458735281601548194885,\
0.5352854127995669841766,0.7017193175852298736572,0.9817278520204126834869,\
0.2777477568015456199646,0.1314821145497262477875,0.366813333705067634583,\
0.7377605927176773548126,0.9103105561807751655579,0.3637479650788009166718,\
0.8207867145538330078125,0.3059372254647314548492,0.9788405327126383781433,\
0.9970494522713124752045,0.4636328797787427902222,0.7769650523550808429718,\
0.3400075891986489295959,0.0353285889141261577606,0.2607673071324825286865,\
0.5790986777283251285553,0.1250711670145392417908,0.0372988111339509487152,\
0.9382179621607065200806,0.5585843441076576709747,0.7192503632977604866028,\
0.3599752518348395824432,0.6758626028895378112793,0.2222136431373655796051,\
0.7860159231349825859070,0.1736893891356885433197,0.2674629595130681991577,\
0.7357366015203297138214,0.0550541067495942115784,0.5923380698077380657196,\
0.2162457890808582305908,0.7718841419555246829987,0.0926524316892027854919,\
0.7626169077120721340179,0.7347808051854372024536,0.8017499190755188465118,\
0.7732572900131344795227,0.2559880572371184825897,0.1179054826498031616,\
0.9232815303839743137360,0.6709534404799342155457,0.6071323617361485958099,\
0.4574467372149229049683,0.8206311021931469440460,0.0896153757348656654358,\
0.3426358769647777080536,0.1674894802272319793701,0.9481152505613863468170,\
0.9504805644974112510681,0.3436607695184648036957,0.2889420483261346817017,\
0.5325344172306358814240,0.2558945687487721443176,0.8863505902700126171112,\
0.0421485081315040588379,0.4876015805639326572418}

#define ZSOURCEI {0.347978035919368267059,0.2037199228070676326752,0.5962978359311819076538,\
0.8342303414829075336456,0.6809655660763382911682,0.9127784068696200847626,\
0.5243799723684787750244,0.7204323844052851200104,0.3259664541110396385193,\
0.1506391367875039577484,0.9124387521296739578247,0.6345743131823837757111,\
0.9268973069265484809875,0.7633614349178969860077,0.5918717086315155029297,\
0.9057438620366156101227,0.3263365356251597404480,0.3912780000828206539154,\
0.4635267537087202072144,0.0849754814989864826202,0.5800507226958870887756,\
0.7945564310066401958466,0.3823457323014736175537,0.3010852993465960025787,\
0.5789428642019629478455,0.2627451247535645961761,0.5713048521429300308228,\
0.1848654565401375293732,0.9971724869683384895325,0.4520535501651465892792,\
0.0334019884467124938965,0.4553878181613981723785,0.7851976407691836357117,\
0.4941168962977826595306,0.9304408635944128036499,0.7621670593507587909698,\
0.9264887655153870582581,0.7199950958602130413055,0.3973621018230915069580,\
0.8769331262446939945221,0.6766644334420561790466,0.8431562236510217189789,\
0.7608711589127779006958,0.8287630719132721424103,0.0037989662960171699524,\
0.9451942699961364269257,0.6311131268739700317383,0.0763222672976553440094,\
0.4486519275233149528503,0.1080312891863286495209,0.8351444136351346969604,\
0.3109649871475994586945,0.1235694894567131996155,0.0363539229147136211395,\
0.6609512977302074432373,0.9844443709589540958405,0.0688076755031943321228,\
0.5140342987142503261566,0.3807653579860925674438,0.1549817589111626148224,\
0.6850274773314595222473,0.0382853033952414989471,0.5224257782101631164551,\
0.7454454028047621250153,0.4607118470594286918640,0.4753002314828336238861,\
0.8575385268777608871460,0.8073885519988834857941,0.7132545644417405128479,\
0.0811268086545169353485,0.5751824118196964263916,0.884696914348751306534,\
0.5624709790572524070740,0.7315255901776254177094,0.6099120099097490310669,\
0.0705954921431839466095,0.8552806274965405464172,0.7045627343468368053436,\
0.5928074717521667480469,0.8517647930420935153961,0.2603117255493998527527,\
0.8596871509216725826263,0.3943212013691663742065,0.3333164160139858722687,\
0.2511775353923439979553,0.5570420245639979839325,0.7276714108884334564209,\
0.9383780122734606266022,0.1971746077761054039001,0.1607607132755219936371,\
0.7815325502306222915649,0.1760376212187111377716,0.2801528992131352424622,\
0.4699970218352973461151,0.3507726117968559265137,0.5713973813690245151520,\
0.4563077641651034355164,0.9214398502372205257416,0.4339873101562261581421,\
0.3514866163022816181183,0.1816438222303986549377,0.9070622171275317668915,\
0.7665811367332935333252,0.9807842955924570560455,0.1198607003316283226013,\
0.0508546582423150539398,0.2581452894955873489380,0.1401008707471191883087,\
0.5514106499031186103821,0.7882929998449981212616,0.8028824776411056518555,\
0.2425694861449301242828,0.7024780390784144401550,0.0922905071638524532318,\
0.4318286012858152389526,0.0804965649731457233429,0.7126307198777794837952,\
0.6893844078294932842255,0.2756213061511516571045,0.6968217701651155948639,\
0.4598932703956961631775,0.6099067903123795986176,0.3065654132515192031860,\
0.0749373403377830982208,0.9619921119883656501770,0.4158898773603141307831,\
0.3287452235817909240723,0.7406168007291853427887,0.5725225014612078666687,\
0.9504556744359433650970,0.1849336978048086166382,0.8698030491359531879425,\
0.6907873982563614845276,0.9524399931542575359344,0.6490485109388828277588,\
0.9960058168508112430573,0.2040582066401839256287,0.3800008497200906276703,\
0.9729049820452928543091,0.9110585046000778675079,0.3810073928907513618469,\
0.7869612383656203746796,0.5560158789157867431641,0.8529843934811651706696,\
0.4350629774853587150574,0.5956362797878682613373,0.7071880977600812911987,\
0.5747222309000790119171,0.4764349022880196571350,0.6098947445861995220184,\
0.9666662178933620452881,0.3874611915089190006256,0.0715632727369666099548,\
0.6122049516998231410980,0.9575729314237833023071,0.7723352131433784961700,\
0.1287384750321507453918,0.3884150418452918529510,0.2353963479399681091309,\
0.6542267077602446079254,0.3286431683227419853210,0.024017625954002141953,\
0.1042741741985082626343,0.9314296473748981952667,0.8185661518946290016174,\
0.8156488086096942424774,0.8688247688114643096924,0.3549220249988138675690,\
0.3890381073579192161560,0.6415715864859521389008,0.4902750719338655471802,\
0.3509976905770599842072,0.8516392158344388008118,0.1348936217837035655975,\
0.1156354099512100219727,0.8810075619257986545563,0.8367286501452326774597,\
0.5032693906687200069427,0.4486711751669645309448,0.9319602106697857379913,\
0.7298459419980645179749,0.3388367067091166973114,0.4314213804900646209717,\
0.7317318231798708438873,0.9655342241749167442322,0.2621376193128526210785,\
0.2050140891224145889282,0.2826355365104973316193,0.3973353477194905281067,\
0.7437736871652305126190,0.8185287192463874816895,0.3071001493372023105621,\
0.9627068741247057914734,0.9475456266663968563080,0.6546552237123250961304,\
0.1992082078941166400909,0.3616109425202012062073,0.9388273353688418865204,\
0.0409001447260379791260,0.0758434669114649295807}
#define ZRESULTR {-0.3290495609832542744932,-0.2133542315965856750459,-0.2143604594080804615075,\
-0.0779993516667897290873,-0.0881879704812010417614,-0.0392492308819259588804,\
-0.1468107357971605020364,-0.1080692186653561120968,-0.1065683791205834785032,\
-0.0273353392421778126908,0.1191283090947614642374,-0.1819586746730034731989,\
-0.0146372370113581271034,-0.1172624775653131612430,-0.2254678765990359434745,\
-0.0331498720885635145272,-0.3009243692795003366491,-0.3306899894153413344000,\
-0.3045496213459356615871,-0.2169562594261553178931,-0.1622895628928226752219,\
-0.0725702069682954281626,-0.1801817524356017496956,-0.0638691649231626773497,\
0.0382899018433042123699,-0.5136597137709293381391,0.0453803311793120195405,\
-0.4840630563482673509590,0.0043573655682720771609,-0.0053634673446913633602,\
-0.2922091972771523882280,-0.0379710404096835762999,0.0615264246077369611476,\
-0.1177861239572535467790,-0.0027606815124210713590,0.0827769612970807588948,\
0.0103506258196890514600,-0.0414069352257771042258,-0.0028258322392286264017,\
0.0191369442490108253307,-0.1537687128497234601010,-0.0721417928417731474378,\
0.0027147719270748577915,-0.0735641860746090447964,-0.0127065691399337477724,\
0.0059853142299196512854,-0.0125407536616094668347,-0.0108856950196654141821,\
-0.3292710076447024625246,-0.3259617043131136093770,-0.0020400145634434829929,\
-0.1479281118584361010004,-0.9017915683260822046208,-0.3542710907015680921184,\
-0.0370225124342607042616,0.0151168335656557354524,-0.3642515556722971115100,\
-0.0288172015063716119299,-0.4149670396818516682202,-0.0092330629379009203361,\
-0.0106663219864977006773,-0.7243988137694490347940,-0.1958487567186202316094,\
0.0439375096643265586338,-0.0920894961670395001407,-0.0491603497010221490715,\
0.0086566739889077232162,0.0339376585197796801219,-0.1304877971769988764805,\
-0.0630508696074615210270,-0.2293705604967442579500,-0.0219724307162800849835,\
-0.1224692215475379208911,-0.0531242407432285373980,-0.1143402977644937118518,\
-0.0234761498308886963626,0.1091329563146860859302,-0.0527638328353893792944,\
0.0024222192478416683901,0.0292586204417139908451,-0.1262209046057715389200,\
0.0369593428671423362974,0.0158795483132631205792,-0.4767086450021467136651,\
-0.1746242034102962470410,-0.1615510250958859250758,-0.1371556526467043735096,\
0.100945647205856317563,-0.6837031045647332661019,-0.0014388289408900174424,\
-0.0464403701173962263349,-0.0582634176897608505041,-0.0221676835116708763340,\
-0.1671127243957707675381,-0.3975387523773417086659,-0.1649600652341057516193,\
-0.2862269227110153524407,-0.0328071976308584797866,0.0351271945689521844503,\
-0.1813816670814733522654,-0.3701233874684188296378,0.0635430885883380841550,\
-0.1049291365916461549190,0.0095204817066643597501,-0.3507837205033069172266,\
-0.0490285470477662618793,-0.1735609734951024107907,-0.4296178908501777637952,\
-0.2551225266448440276434,-0.0617650291008570578866,-0.0848934350447099472792,\
-0.0331679244708535381214,0.0578595820981543801365,-0.9721832280456300656724,\
-0.2220295759617292030708,-0.0235337862370093645059,0.0670980880683051256197,\
0.0456584724702859962031,-0.4050627643604459149351,0.0332188086620539904659,\
-0.1843762947107071559216,-0.2025989526775586746510,-0.1728805677287464093173,\
-0.5006140240740283298138,-0.0039574496715991209703,-0.3747624646211847876387,\
-0.0291826804365620078030,-0.0644170285495881678184,-0.020449093098134307755,\
0.1324382164856784949158,-0.3626939268757052303727,0.0521008032215845851010,\
0.0438487661958249438920,0.0803943913989621228300,-0.1872441239933456957889,\
0.0719513030064179159861,-0.3021736609622284186472,-0.30531498564977166410,\
0.1057250974802272092123,-0.0218353036625967035500,-0.2885450025056992551242,\
-0.0214746210927109354438,-0.0480309906528200089570,0.1141195620733326948626,\
-0.2872136450436454380153,-0.2146876003507041108520,-0.0987270319138862650910,\
-0.0290961734854755134372,0.0117611124704010052561,-0.1486623273058947924952,\
0.1031611720947231414236,-0.3065510644941032425415,-0.0081304707590571338727,\
0.0681862604059072646701,0.0269042920576901857521,0.0396225366257938194092,\
-0.4394191704520844510284,-0.4089149013992912085058,-0.4543230131010723149565,\
-0.0586330634787295829069,-0.4539044694277152292017,-1.3529821933222951901854,\
-0.0250304307835438853702,0.0358632689692895620381,0.0372933340583203806751,\
-0.0498532689013882687745,0.0416880085188151769393,-0.3780489142107763544942,\
-0.0569883570641069869822,-0.1773959401592627993516,-0.2529880791121558170076,\
-0.0887499827789579032178,-0.0688387899649425538673,-0.2164511122923038211052,\
-0.6104407141161303229637,0.0686738036393797490753,-0.0747689959340766124862,\
-0.0391919696178445325918,-0.0650297590330818214843,0.0896829227334642459235,\
0.0266548623220910323173,-0.3719537274000056514822,-0.3494566550303903618158,\
0.0711759971067136287814,0.0703223378863101489245,-0.1795974324279027423135,\
-0.2999138709331988783546,-0.0615107548910408530318,-0.3900685687486248887090,\
-0.0867686652200203717422,-0.0780592259581650849132,-0.0014744231840779402701,\
0.1312513908465361422984,0.0034351924950619906404,-0.1453391630458231997824,\
-0.2452127202368474256922,-0.3536012485332969967899,0.1109696410995756055140,\
-1.2311333463434968038541,-0.3067437997278838479609}

#define ZRESULTI {0.3633100487665162359185,0.1474158063550214115001,0.5885387980009104680335,\
0.6572801175741773693773,0.4285748579481841735728,0.6638943219025983388804,\
0.3587662857455625187164,0.5117548829580961244901,0.1866273414364414962030,\
0.0699742348195561969515,0.3328432735187898949825,0.5666303041879406920955,\
0.5568906423318142895340,0.6796689265398294654830,0.6374873742133734255688,\
0.5900654029247031084893,0.3087389836998947201252,0.4314129861802953325167,\
0.5242475923033280693630,0.0610188495832547500575,0.4354133593463934692736,\
0.5297939421633884871099,0.2681487567918271475165,0.1547283383009969981448,\
0.2426408568390991671304,0.4474267034848418145287,0.2347646885151994655683,\
0.2599927875089523832131,0.6126748695156737367640,0.2064522777477181547656,\
0.0284496210471740680614,0.2258908609011123780341,0.3256261235849059465508,\
0.3061930542060117277359,0.5264317995551247575392,0.2959401807089209746060,\
0.4910139616058311062829,0.3969936639609323303368,0.1786986723204381510843,\
0.4324195385396965018998,0.5655382812237433887148,0.6410621383118232374798,\
0.3723548821340513237388,0.5990569422252302045351,0.0016988593650344200551,\
0.5214150467894975715666,0.3070731387905711318176,0.0340224494974534080738,\
0.5552566039785586937683,0.1002676097220635414997,0.4323764448196805720848,\
0.1964911590800132445978,0.6084096209152420886568,0.0357352532897105071297,\
0.3489411661881484660874,0.5453449961026168857359,0.0694263094757205379004,\
0.2525534710601468613156,0.6206431406119353733075,0.0690444796836073154678,\
0.3380054707664132407352,0.0887652999217624361084,0.4176207649503542729263,\
0.3210430331362784106553,0.2631553422310267675854,0.2437584071473132274477,\
0.4336070270779164292918,0.3661466421575780838538,0.5640596254022186561983,\
0.0407979674024822880352,0.5856292520126130662916,0.5194472182924043668351,\
0.3655014659417109568196,0.4226713256320973055580,0.3981267146771410581074,\
0.0323921796076454895918,0.3160837480759546291864,0.3995349584181833169083,\
0.273802063686018282151,0.4000313483957886884212,0.1544145556607701974539,\
0.3952425864610250583198,0.1693632158699578948990,0.6627611949754427245196,\
0.167173661907591114550,0.4086002639927426849376,0.6540985540228395622719,\
0.3642324586236761474467,0.5468253741606181606016,0.0703565244510996889993,\
0.4580361055958868110594,0.0880301024358387529389,0.1299718766609879727625,\
0.3310527463405003034680,0.4637212462953029801227,0.4294623340021747059936,\
0.4691072369162453403746,0.6335809675670333040998,0.1788460444456893838616,\
0.2444904068796305007805,0.1910877540250672246280,0.3910553307022346936073,\
0.5870156732892560791370,0.5581921905883382439839,0.1182006499862187365313,\
0.0247387920792678586701,0.1716217468036307647328,0.1677637778431290971337,\
0.6278971871585069530752,0.4952349292223454657602,0.5872771345770251283369,\
0.1150482129328096875254,0.2875910738555041423758,0.4544626742179224132556,\
0.3490957130610289338435,0.0369504335660946620079,0.2852598765351710419225,\
0.2907565249995825995555,0.3370230396263981242910,0.3047404031476670938083,\
0.33865617237418182972,0.5799887649794799315828,0.2058615017488183152050,\
0.1040542236456874769512,0.5769758315245528956794,0.6086314545246159779524,\
0.1560306547104348962041,0.4487914762887483810516,0.2795367938070804081363,\
0.3371389774796904048593,0.1912601282140735381443,0.3826791464254168939618,\
0.2928983745329591936724,0.396613573038569422469,0.6618005209348483131038,\
0.4362846209517689533008,0.1830850765515834310815,0.3800035453193333911948,\
0.376730811842592550054,0.5559265822426159298075,0.3620694326893729719785,\
0.4227803813529266152571,0.2910061310239929199817,0.3106691139011089619615,\
0.435429394944240932830,0.5878341337089509899272,0.4743827280867594087255,\
0.2874204018606083543830,0.2094051712928121644630,0.4486348592544623370415,\
0.3764598089790200385885,0.3919214486831592569871,0.0316949858971651426964,\
0.2391495340218968146395,0.486361470580685850695,0.3397962718388538583270,\
0.1571941632596165761004,0.6427949822892967679522,0.3189060883322832884446,\
0.3675164927613087662017,0.5242598134907254792125,0.2484566158604845087510,\
0.0480705017921116625756,0.4475807306655288364539,0.3691029449284471408710,\
0.5016842301167260265160,0.3950665170276177473596,0.4392508841037601752255,\
0.1996012963954646446396,0.5673662159944875549300,0.4652972123009525562409,\
0.1933199899606511118488,0.6541522766180654091528,0.0972438028822732308809,\
0.2132613189014408716648,0.3697245333311866000159,0.6342931063454819717862,\
0.2533327612355570357394,0.2380763598053285134970,0.3736506508141989035821,\
0.3285546506249918952136,0.4011970200297387822985,0.5663267577447791412126,\
0.2910519034072798771895,0.4184422115344140213899,0.1770121129168618634431,\
0.1829818983774834095790,0.1440504268816359956240,0.5858489671891115024849,\
0.4947061064648006212252,0.5945317434266266243270,0.1360392849738219778200,\
0.3438694289300276984989,0.5310838098864226752838,0.5016736389654107286518,\
0.1554601034674029658156,0.4147310296690985831347,0.3535773010333992383281,\
0.3345663906426585842979,0.0670148638928397127890}


/* FIXME : assert à 1e-14 */

void dlog10sTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out;
	int i;

	for (i=0;i<200;i++){
		out=dlog10s(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<3e-16);
	}
}

void zlog10sTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=DoubleComplex(inR[i],inI[i]);
		out=zlog10s(in);
		assert(( (fabs(zreals(out)-resR[i]))/(fabs(zreals(out))) )<3e-15);	
		assert(( (fabs(zimags(out)-resI[i]))/(fabs(zimags(out))) )<3e-15);			
	}
}

void dlog10aTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out[200];
	int i;

	dlog10a(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<3e-16);
	}
}

void zlog10aTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex *in,out[200];
	int i;


	in=DoubleComplexMatrix(inR,inI,200);
	zlog10a(in,200,out);

	for (i=0;i<200;i++){
		assert(( (fabs(zreals(out[i])-resR[i]))/(fabs(zreals(out[i]))) )<3e-15);	
		assert(( (fabs(zimags(out[i])-resI[i]))/(fabs(zimags(out[i]))) )<3e-15);			
	}
}

int testLog10(void) {
  printf("\n>>>> Double 10-Based Logarithm Tests\n");
  dlog10sTest();
  zlog10sTest();
  dlog10aTest();
  zlog10aTest();
  return 0;
}

int main(void) {
  assert(testLog10() == 0);
  return 0;
}
