/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2006-2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testLog10.h"

#define SOURCE {0.3628176329657435417175f,0.924179898109287023544f,0.5243524145334959030151f,\
0.7886543427594006061554f,0.6525151440873742103577f,0.2477638195268809795380f,\
0.2364655844867229461670f,0.7240293831564486026764f,0.8278210600838065147400f,\
0.4287728047929704189301f,0.4858888480812311172485f,0.5923984018154442310333f,\
0.0949383648112416267395f,0.1356843891553580760956f,0.9917455688118934631348f,\
0.7212927364744246006012f,0.0115638775750994682312f,0.0211908905766904354095f,\
0.1524727698415517807007f,0.9165380974300205707550f,0.4467271203175187110901f,\
0.5868234331719577312469f,0.1882771886885166168213f,0.4196520284749567508698f,\
0.2730510598048567771912f,0.7565603456459939479828f,0.9378882069140672683716f,\
0.0586007428355515003204f,0.5101847248151898384094f,0.5031699347309768199921f,\
0.7783576548099517822266f,0.6856653341092169284821f,0.1381576983258128166199f,\
0.371037633623927831650f,0.6366564910858869552612f,0.4961673622019588947296f,\
0.2994064847007393836975f,0.2392275254242122173309f,0.5618183575570583343506f,\
0.3218038142658770084381f,0.1082227518782019615173f,0.1685282415710389614105f,\
0.8263800088316202163696f,0.4923414406366646289825f,0.7863734485581517219543f,\
0.6762332352809607982635f,0.0258686169981956481934f,0.3594204657711088657379f,\
0.3436427963897585868835f,0.2824054299853742122650f,0.1450859513133764266968f,\
0.0762176741845905780792f,0.5220461571589112281799f,0.6713762427680194377899f,\
0.0599394328892230987549f,0.7267188713885843753815f,0.2224657749757170677185f,\
0.3122289828024804592133f,0.4435700643807649612427f,0.3983507198281586170197f,\
0.1324583934620022773743f,0.8820166247896850109100f,0.5455272346735000610352f,\
0.2917219498194754123688f,0.7739847479388117790222f,0.3354639573954045772552f,\
0.8127403985708951950073f,0.4612239454872906208038f,0.6898109326139092445374f,\
0.9649041066877543926239f,0.8210376314818859100342f,0.2802407057024538516998f,\
0.9873316427692770957947f,0.294199434574693441391f,0.4859610591083765029907f,\
0.2247181800194084644318f,0.9585652919486165046692f,0.1503968122415244579315f,\
0.0216291621327400207520f,0.0688429796136915683746f,0.9950710041448473930359f,\
0.7568672685883939266205f,0.6163959559053182601929f,0.0865804632194340229034f,\
0.5165374809876084327698f,0.1916800136677920818329f,0.2940570451319217681885f,\
0.3528221980668604373932f,0.1317937439307570457458f,0.0549608371220529079437f,\
0.929352553561329841614f,0.737892795819789171219f,0.7509917514398694038391f,\
0.6889848816208541393280f,0.8865169286727905273438f,0.6891661235131323337555f,\
0.8677108911797404289246f,0.7947537912987172603607f,0.2496256213635206222534f,\
0.3935408894903957843781f,0.7297343472018837928772f,0.7888072351925075054169f,\
0.113488640636205673218f,0.4145256043411791324615f,0.6172473421320319175720f,\
0.7440188056789338588715f,0.9038409832864999771118f,0.3976829168386757373810f,\
0.9472072543576359748840f,0.2581262919120490550995f,0.1955799385905265808105f,\
0.9381833248771727085114f,0.4226356102153658866882f,0.0937463282607495784760f,\
0.9977992679923772811890f,0.2042182614095509052277f,0.9455819511786103248596f,\
0.9336234177462756633759f,0.9743702597916126251221f,0.4100225553847849369049f,\
0.5125095760449767112732f,0.0948633304797112941742f,0.5688196588307619094849f,\
0.7322562676854431629181f,0.8108531581237912178040f,0.5459008770994842052460f,\
0.5022544711828231811523f,0.7634959020651876926422f,0.7354982374235987663269f,\
0.0699520572088658809662f,0.6130836438387632369995f,0.0965849910862743854523f,\
0.5439325878396630287170f,0.9187005828134715557098f,0.5072866193950176239014f,\
0.1335940570570528507233f,0.8688194593414664268494f,0.7999687767587602138519f,\
0.9879787657409906387329f,0.7131399479694664478302f,0.3067426951602101325989f,\
0.5431228461675345897675f,0.7330236807465553283691f,0.6498145484365522861481f,\
0.8018737239763140678406f,0.2859625308774411678314f,0.1894423719495534896851f,\
0.7794728656299412250519f,0.5433104271069169044495f,0.5268451268784701824188f,\
0.1533693112432956695557f,0.6041304902173578739166f,0.5948378806933760643005f,\
0.8857938847504556179047f,0.0043053645640611648560f,0.1302204323001205921173f,\
0.9758609728887677192688f,0.9183407831005752086639f,0.0624175965785980224609f,\
0.9939593323506414890289f,0.4122588960453867912292f,0.8258536770008504390717f,\
0.0376359503716230392456f,0.4675730471499264240265f,0.4759115139022469520569f,\
0.4060978214256465435028f,0.0392968021333217620850f,0.4401316107250750064850f,\
0.3316476037725806236267f,0.0877817696891725063324f,0.1150833908468484878540f,\
0.9667435702867805957794f,0.8103649737313389778137f,0.3928376468829810619354f,\
0.7880131229758262634277f,0.4798596971668303012848f,0.0270724548026919364929f,\
0.6701857983134686946869f,0.5602217521518468856812f,0.2564360727556049823761f,\
0.2626037681475281715393f,0.4447338129393756389618f,0.8522944338619709014893f,\
0.2347065494395792484283f,0.3277532672509551048279f,0.2253599218092858791351f,\
0.3468936551362276077271f,0.7743145865388214588165f,0.1285835551097989082336f,\
0.1156307714991271495819f,0.2054340392351150512695f,0.4535544612444937229156f,\
0.6516549764201045036316f,0.0710035725496709346771f,0.1265540253371000289917f,\
0.4974718545563519001007f,0.0879269847646355628967f,0.1462626229040324687958f,\
0.715134423226118087769f,0.9305738122202455997467f}

#define RESULT {-0.4403116143527589509965f,-0.0342434820791150257291f,-0.2803767278195338774616f,\
-0.1031133008775467624352f,-0.1854094044230032989340f,-0.6059621125162122368124f,\
-0.6262320581190643498104f,-0.1402438085490333719019f,-0.0820635291772953134881f,\
-0.36777276786493884320f,-0.3134630685689411833117f,-0.2273861217978072890578f,\
-1.0225582527058232340522f,-0.8674701161846418706602f,-0.0035997313073961446743f,\
-0.1418884411982046234169f,-1.9368965147824408479238f,-1.67385079107519252339f,\
-0.8168077101761380687250f,-0.0378494781542935143648f,-0.3499576811822522337536f,\
-0.2314925521326422763746f,-0.7252022951018919361132f,-0.3771106732935153860176f,\
-0.563756133479260124197f,-0.1211564255577455423429f,-0.0278489249618575039624f,\
-1.232096878737263700998f,-0.2922725485247071319783f,-0.2982853166297994018663f,\
-0.1088207991305185085018f,-0.1638878070544614040660f,-0.8596249106224531644216f,\
-0.4305820385081238765856f,-0.1960948286770107240606f,-0.3043718069355866306935f,\
-0.5237387977162476504489f,-0.6211888520577832917269f,-0.2504040742204550751282f,\
-0.4924088126148459254594f,-0.9656814270628060192792f,-0.7733273106340565750116f,\
-0.0828201974893169740044f,-0.3077336078949636233304f,-0.1043711586288077197704f,\
-0.169903488488286208424f,-1.5872267891461315780788f,-0.444397197348344763501f,\
-0.4638927555552059822652f,-0.5491269570890252582629f,-0.8383746383028719550978f,\
-1.1179443080462672099884f,-0.2822910967808678894819f,-0.1730340307038858715938f,\
-1.222287370403489781268f,-0.1386335619293298515586f,-0.6527367931436293124747f,\
-0.5055267858124582458501f,-0.3530377711634032356081f,-0.3997343937184095197246f,\
-0.8779205166514928437849f,-0.0545232289425809854566f,-0.2631835629983380608898f,\
-0.535030892349513287343f,-0.1112675973936914503026f,-0.4743541340498391156721f,\
-0.0900481524037324287946f,-0.3360881534089125155518f,-0.1612699269064814533436f,\
-0.0155158452113394202537f,-0.0856369369482974790442f,-0.5524687820481442024345f,\
-0.0055369441569604379433f,-0.5313581662832899121796f,-0.3133985301037985338191f,\
-0.6483617911201521311071f,-0.0183783001388101094320f,-0.8227613688014733250853f,\
-1.664960303869991609105f,-1.1621403411076904887977f,-0.0021459286933866758389f,\
-0.1209802758154948920666f,-0.2101402192945755753595f,-1.0625800949711647902518f,\
-0.2868981597290535812128f,-0.7174231683233029954749f,-0.5315684111428640168384f,\
-0.4524440987253919854716f,-0.8801052046193623690229f,-1.259946661051862371039f,\
-0.0318195034221232311844f,-0.1320067297295647867905f,-0.1243648330674980567734f,\
-0.1617903077014812007750f,-0.05231296682112057672f,-0.1616760787761070405910f,\
-0.0616249514134949369359f,-0.0997673916469928034889f,-0.6027108410820325445911f,\
-0.4050101371105858660826f,-0.1368352118545152207307f,-0.1030291145605434360855f,\
-0.9450476059237150616710f,-0.3824486388636323952461f,-0.2095407714646851937701f,\
-0.1284160871700188444322f,-0.0439079701395359081606f,-0.4004630644881080336894f,\
-0.0235549844857810899978f,-0.5881677573670978098619f,-0.7086756945701918608549f,\
-0.0277122904020632616906f,-0.3740339131793987692554f,-1.0280457331716890134743f,\
-0.0009568190047624330983f,-0.6899054254479447534365f,-0.0243008259915241074667f,\
-0.0298282635710438621957f,-0.0112759802587220972492f,-0.38719225203706036931f,\
-0.2902980155704742437628f,-1.0229016321238477704725f,-0.2450254024783888040506f,\
-0.1353369023236559165468f,-0.0910577874542803367142f,-0.2628862079121005446147f,\
-0.2990761883748661031923f,-0.1171932896033063276064f,-0.1334183636952847862300f,\
-1.1551995088873641126526f,-0.2124802700500995344957f,-1.0150903559327661973555f,\
-0.2644549211536121879895f,-0.0368260081130531435889f,-0.2947465928364439435860f,\
-0.8742128610575919944736f,-0.0610704605568186745246f,-0.0969269634405601765437f,\
-0.0052523894413354609012f,-0.1468252349912699539214f,-0.5132257708646462690538f,\
-0.2651019284616369375840f,-0.1348819950022109859233f,-0.1872105696377188988055f,\
-0.0958940173743543372575f,-0.5436908679171403857566f,-0.7225228772557727996428f,\
-0.1081989985152894545584f,-0.2649519599919711310143f,-0.2783170326568494279407f,\
-0.8142615327667455105143f,-0.2188692450535288658298f,-0.2256013823621523806118f,\
-0.0526673222769318341574f,-2.3659900680299497111037f,-0.8853208672348196195401f,\
-0.0106120501693722224523f,-0.0369961284323869002422f,-1.2046929580793401814987f,\
-0.0026313843119589821508f,-0.3848299640358096573856f,-0.0830968932369530594029f,\
-1.424397112818484689711f,-0.3301505313242010797303f,-0.3224737880280506563402f,\
-0.3913693403433980977368f,-1.4056427898881791449526f,-0.3564174388206851062932f,\
-0.4793231362281260010683f,-1.0565956679830132980413f,-0.9389873504280431548707f,\
-0.0146887076937459951781f,-0.0913193386792951061759f,-0.4057868990671495423861f,\
-0.1034665500376885233225f,-0.3188857244019617231956f,-1.5674723626658799702227f,\
-0.1738047793945742269806f,-0.2516400325061770026913f,-0.5910208828319416518582f,\
-0.5806990464341352797817f,-0.3518998500546973717817f,-0.0694103478250598926458f,\
-0.6294747913311795617375f,-0.4844529702954271654924f,-0.6471233167047535372873f,\
-0.4598036435552441125729f,-0.1110825594195994081570f,-0.8908145709277390800196f,\
-0.9369265766947033613476f,-0.6873275946862682506122f,-0.3433705568996603396670f,\
-0.1859822838651877530136f,-1.1487197991742361669054f,-0.8977240365674604705148f,\
-0.3032314852833657981002f,-1.055877819626311886481f,-0.8348666427090224440022f,\
-0.1456123165510203598672f,-0.0312491733461308825170f}

#define CSOURCER {0.3140813848003745079041f,0.5769402063451707363129f,0.1306138429790735244751f,\
0.0478980806656181812286f,0.4500174494460225105286f,0.0384718659333884716034f,\
0.483350999653339385986f,0.2981918179430067539215f,0.7112689120694994926453f,\
0.9268360524438321590424f,0.9477838929742574691772f,0.1729496796615421772003f,\
0.2750928336754441261292f,0.0044281478039920330048f,0.0611358620226383209229f,\
0.1950612799264490604401f,0.3789803450927138328552f,0.2549188635312020778656f,\
0.1764185149222612380981f,0.6008180272765457630157f,0.3703392641618847846985f,\
0.2908470141701400279999f,0.5384815335273742675781f,0.8090293356217443943024f,\
0.9260985879227519035339f,0.1576966657303273677826f,0.9518593531101942062378f,\
0.2709982101805508136749f,0.1609848598018288612366f,0.8782086591236293315887f,\
0.5091647170484066009521f,0.7951062084175646305084f,0.8432204117998480796814f,\
0.5806765086017549037933f,0.3487791065126657485962f,0.9397577759809792041779f,\
0.4363934816792607307434f,0.5549766751937568187714f,0.9105900451540946960449f,\
0.5684339576400816440582f,0.1862502051517367362976f,0.0800832151435315608978f,\
0.6585252787917852401733f,0.1606054832227528095245f,0.9711584830656647682190f,\
0.3668168033473193645477f,0.7386338301002979278564f,0.9722552285529673099518f,\
0.1349937235936522483826f,0.4595781317912042140961f,0.5414639282971620559692f,\
0.6397600513882935047150f,0.0211964594200253486633f,0.4408156829886138439178f,\
0.6374878138303756713867f,0.3208820023573935031891f,0.4267518399283289909363f,\
0.7819778784178197383881f,0.0543234180659055709839f,0.9666189108975231647491f,\
0.6948409983888268470764f,0.1846996019594371318817f,0.3645029179751873016357f,\
0.8176643461920320987701f,0.664914294146001338959f,0.7559730983339250087738f,\
0.5525381658226251602173f,0.7192269531078636646271f,0.1989364298060536384583f,\
0.8610532465390861034393f,0.1300329938530921936035f,0.347959163133054971695f,\
0.5025534434244036674500f,0.4978472082875669002533f,0.4675923939794301986694f,\
0.9447452803142368793488f,0.9599315756931900978088f,0.5365384514443576335907f,\
0.8122785724699497222900f,0.6470989421941339969635f,0.7010180121287703514099f,\
0.6681951484642922878265f,0.9593638796359300613403f,0.0149199557490646839142f,\
0.6199735002592206001282f,0.4061129498295485973358f,0.0471306145191192626953f,\
0.8433605083264410495758f,0.0635268418118357658386f,0.9836421324871480464935f,\
0.4434677045792341232300f,0.8565507535822689533234f,0.9080012599006295204163f,\
0.4922491232864558696747f,0.1930142603814601898193f,0.3759337724186480045319f,\
0.2437626412138342857361f,0.1035623974166810512543f,0.9936000052839517593384f,\
0.5569599089212715625763f,0.3858396532014012336731f,0.7191527518443763256073f,\
0.1707325801253318786621f,0.2878904812969267368317f,0.4294657362625002861023f,\
0.8917979537509381771088f,0.6188817229121923446655f,0.3444608678109943866730f,\
0.0692929709330201148987f,0.3619817639701068401337f,0.1783103235065937042236f,\
0.8941529677249491214752f,0.9010278200730681419373f,0.0533773354254662990570f,\
0.4162023533135652542114f,0.9438270372338593006134f,0.9242387460544705390930f,\
0.8710649865679442882538f,0.2808376699686050415039f,0.8244629004038870334625f,\
0.4650857029482722282410f,0.1462343498133122920990f,0.5975636970251798629761f,\
0.3067605351097881793976f,0.2377215037122368812561f,0.0711208949796855449677f,\
0.8753139786422252655029f,0.4413500339724123477936f,0.7631150623783469200134f,\
0.9679268277250230312347f,0.3924236092716455459595f,0.717360940296202898026f,\
0.8640465112403035163879f,0.7354763629846274852753f,0.0304915383458137512207f,\
0.6331009590066969394684f,0.4550241930410265922546f,0.3173553734086453914642f,\
0.8250397499650716781616f,0.2725940425880253314972f,0.3458735281601548194885f,\
0.5352854127995669841766f,0.7017193175852298736572f,0.9817278520204126834869f,\
0.2777477568015456199646f,0.1314821145497262477875f,0.366813333705067634583f,\
0.7377605927176773548126f,0.9103105561807751655579f,0.3637479650788009166718f,\
0.8207867145538330078125f,0.3059372254647314548492f,0.9788405327126383781433f,\
0.9970494522713124752045f,0.4636328797787427902222f,0.7769650523550808429718f,\
0.3400075891986489295959f,0.0353285889141261577606f,0.2607673071324825286865f,\
0.5790986777283251285553f,0.1250711670145392417908f,0.0372988111339509487152f,\
0.9382179621607065200806f,0.5585843441076576709747f,0.7192503632977604866028f,\
0.3599752518348395824432f,0.6758626028895378112793f,0.2222136431373655796051f,\
0.7860159231349825859070f,0.1736893891356885433197f,0.2674629595130681991577f,\
0.7357366015203297138214f,0.0550541067495942115784f,0.5923380698077380657196f,\
0.2162457890808582305908f,0.7718841419555246829987f,0.0926524316892027854919f,\
0.7626169077120721340179f,0.7347808051854372024536f,0.8017499190755188465118f,\
0.7732572900131344795227f,0.2559880572371184825897f,0.1179054826498031616f,\
0.9232815303839743137360f,0.6709534404799342155457f,0.6071323617361485958099f,\
0.4574467372149229049683f,0.8206311021931469440460f,0.0896153757348656654358f,\
0.3426358769647777080536f,0.1674894802272319793701f,0.9481152505613863468170f,\
0.9504805644974112510681f,0.3436607695184648036957f,0.2889420483261346817017f,\
0.5325344172306358814240f,0.2558945687487721443176f,0.8863505902700126171112f,\
0.0421485081315040588379f,0.4876015805639326572418f}

#define CSOURCEI {0.347978035919368267059f,0.2037199228070676326752f,0.5962978359311819076538f,\
0.8342303414829075336456f,0.6809655660763382911682f,0.9127784068696200847626f,\
0.5243799723684787750244f,0.7204323844052851200104f,0.3259664541110396385193f,\
0.1506391367875039577484f,0.9124387521296739578247f,0.6345743131823837757111f,\
0.9268973069265484809875f,0.7633614349178969860077f,0.5918717086315155029297f,\
0.9057438620366156101227f,0.3263365356251597404480f,0.3912780000828206539154f,\
0.4635267537087202072144f,0.0849754814989864826202f,0.5800507226958870887756f,\
0.7945564310066401958466f,0.3823457323014736175537f,0.3010852993465960025787f,\
0.5789428642019629478455f,0.2627451247535645961761f,0.5713048521429300308228f,\
0.1848654565401375293732f,0.9971724869683384895325f,0.4520535501651465892792f,\
0.0334019884467124938965f,0.4553878181613981723785f,0.7851976407691836357117f,\
0.4941168962977826595306f,0.9304408635944128036499f,0.7621670593507587909698f,\
0.9264887655153870582581f,0.7199950958602130413055f,0.3973621018230915069580f,\
0.8769331262446939945221f,0.6766644334420561790466f,0.8431562236510217189789f,\
0.7608711589127779006958f,0.8287630719132721424103f,0.0037989662960171699524f,\
0.9451942699961364269257f,0.6311131268739700317383f,0.0763222672976553440094f,\
0.4486519275233149528503f,0.1080312891863286495209f,0.8351444136351346969604f,\
0.3109649871475994586945f,0.1235694894567131996155f,0.0363539229147136211395f,\
0.6609512977302074432373f,0.9844443709589540958405f,0.0688076755031943321228f,\
0.5140342987142503261566f,0.3807653579860925674438f,0.1549817589111626148224f,\
0.6850274773314595222473f,0.0382853033952414989471f,0.5224257782101631164551f,\
0.7454454028047621250153f,0.4607118470594286918640f,0.4753002314828336238861f,\
0.8575385268777608871460f,0.8073885519988834857941f,0.7132545644417405128479f,\
0.0811268086545169353485f,0.5751824118196964263916f,0.884696914348751306534f,\
0.5624709790572524070740f,0.7315255901776254177094f,0.6099120099097490310669f,\
0.0705954921431839466095f,0.8552806274965405464172f,0.7045627343468368053436f,\
0.5928074717521667480469f,0.8517647930420935153961f,0.2603117255493998527527f,\
0.8596871509216725826263f,0.3943212013691663742065f,0.3333164160139858722687f,\
0.2511775353923439979553f,0.5570420245639979839325f,0.7276714108884334564209f,\
0.9383780122734606266022f,0.1971746077761054039001f,0.1607607132755219936371f,\
0.7815325502306222915649f,0.1760376212187111377716f,0.2801528992131352424622f,\
0.4699970218352973461151f,0.3507726117968559265137f,0.5713973813690245151520f,\
0.4563077641651034355164f,0.9214398502372205257416f,0.4339873101562261581421f,\
0.3514866163022816181183f,0.1816438222303986549377f,0.9070622171275317668915f,\
0.7665811367332935333252f,0.9807842955924570560455f,0.1198607003316283226013f,\
0.0508546582423150539398f,0.2581452894955873489380f,0.1401008707471191883087f,\
0.5514106499031186103821f,0.7882929998449981212616f,0.8028824776411056518555f,\
0.2425694861449301242828f,0.7024780390784144401550f,0.0922905071638524532318f,\
0.4318286012858152389526f,0.0804965649731457233429f,0.7126307198777794837952f,\
0.6893844078294932842255f,0.2756213061511516571045f,0.6968217701651155948639f,\
0.4598932703956961631775f,0.6099067903123795986176f,0.3065654132515192031860f,\
0.0749373403377830982208f,0.9619921119883656501770f,0.4158898773603141307831f,\
0.3287452235817909240723f,0.7406168007291853427887f,0.5725225014612078666687f,\
0.9504556744359433650970f,0.1849336978048086166382f,0.8698030491359531879425f,\
0.6907873982563614845276f,0.9524399931542575359344f,0.6490485109388828277588f,\
0.9960058168508112430573f,0.2040582066401839256287f,0.3800008497200906276703f,\
0.9729049820452928543091f,0.9110585046000778675079f,0.3810073928907513618469f,\
0.7869612383656203746796f,0.5560158789157867431641f,0.8529843934811651706696f,\
0.4350629774853587150574f,0.5956362797878682613373f,0.7071880977600812911987f,\
0.5747222309000790119171f,0.4764349022880196571350f,0.6098947445861995220184f,\
0.9666662178933620452881f,0.3874611915089190006256f,0.0715632727369666099548f,\
0.6122049516998231410980f,0.9575729314237833023071f,0.7723352131433784961700f,\
0.1287384750321507453918f,0.3884150418452918529510f,0.2353963479399681091309f,\
0.6542267077602446079254f,0.3286431683227419853210f,0.024017625954002141953f,\
0.1042741741985082626343f,0.9314296473748981952667f,0.8185661518946290016174f,\
0.8156488086096942424774f,0.8688247688114643096924f,0.3549220249988138675690f,\
0.3890381073579192161560f,0.6415715864859521389008f,0.4902750719338655471802f,\
0.3509976905770599842072f,0.8516392158344388008118f,0.1348936217837035655975f,\
0.1156354099512100219727f,0.8810075619257986545563f,0.8367286501452326774597f,\
0.5032693906687200069427f,0.4486711751669645309448f,0.9319602106697857379913f,\
0.7298459419980645179749f,0.3388367067091166973114f,0.4314213804900646209717f,\
0.7317318231798708438873f,0.9655342241749167442322f,0.2621376193128526210785f,\
0.2050140891224145889282f,0.2826355365104973316193f,0.3973353477194905281067f,\
0.7437736871652305126190f,0.8185287192463874816895f,0.3071001493372023105621f,\
0.9627068741247057914734f,0.9475456266663968563080f,0.6546552237123250961304f,\
0.1992082078941166400909f,0.3616109425202012062073f,0.9388273353688418865204f,\
0.0409001447260379791260f,0.0758434669114649295807f}

#define CRESULTR {-0.3290495609832542744932f,-0.2133542315965856750459f,-0.2143604594080804615075f,\
-0.0779993516667897290873f,-0.0881879704812010417614f,-0.0392492308819259588804f,\
-0.1468107357971605020364f,-0.1080692186653561120968f,-0.1065683791205834785032f,\
-0.0273353392421778126908f,0.1191283090947614642374f,-0.1819586746730034731989f,\
-0.0146372370113581271034f,-0.1172624775653131612430f,-0.2254678765990359434745f,\
-0.0331498720885635145272f,-0.3009243692795003366491f,-0.3306899894153413344000f,\
-0.3045496213459356615871f,-0.2169562594261553178931f,-0.1622895628928226752219f,\
-0.0725702069682954281626f,-0.1801817524356017496956f,-0.0638691649231626773497f,\
0.0382899018433042123699f,-0.5136597137709293381391f,0.0453803311793120195405f,\
-0.4840630563482673509590f,0.0043573655682720771609f,-0.0053634673446913633602f,\
-0.2922091972771523882280f,-0.0379710404096835762999f,0.0615264246077369611476f,\
-0.1177861239572535467790f,-0.0027606815124210713590f,0.0827769612970807588948f,\
0.0103506258196890514600f,-0.0414069352257771042258f,-0.0028258322392286264017f,\
0.0191369442490108253307f,-0.1537687128497234601010f,-0.0721417928417731474378f,\
0.0027147719270748577915f,-0.0735641860746090447964f,-0.0127065691399337477724f,\
0.0059853142299196512854f,-0.0125407536616094668347f,-0.0108856950196654141821f,\
-0.3292710076447024625246f,-0.3259617043131136093770f,-0.0020400145634434829929f,\
-0.1479281118584361010004f,-0.9017915683260822046208f,-0.3542710907015680921184f,\
-0.0370225124342607042616f,0.0151168335656557354524f,-0.3642515556722971115100f,\
-0.0288172015063716119299f,-0.4149670396818516682202f,-0.0092330629379009203361f,\
-0.0106663219864977006773f,-0.7243988137694490347940f,-0.1958487567186202316094f,\
0.0439375096643265586338f,-0.0920894961670395001407f,-0.0491603497010221490715f,\
0.0086566739889077232162f,0.0339376585197796801219f,-0.1304877971769988764805f,\
-0.0630508696074615210270f,-0.2293705604967442579500f,-0.0219724307162800849835f,\
-0.1224692215475379208911f,-0.0531242407432285373980f,-0.1143402977644937118518f,\
-0.0234761498308886963626f,0.1091329563146860859302f,-0.0527638328353893792944f,\
0.0024222192478416683901f,0.0292586204417139908451f,-0.1262209046057715389200f,\
0.0369593428671423362974f,0.0158795483132631205792f,-0.4767086450021467136651f,\
-0.1746242034102962470410f,-0.1615510250958859250758f,-0.1371556526467043735096f,\
0.100945647205856317563f,-0.6837031045647332661019f,-0.0014388289408900174424f,\
-0.0464403701173962263349f,-0.0582634176897608505041f,-0.0221676835116708763340f,\
-0.1671127243957707675381f,-0.3975387523773417086659f,-0.1649600652341057516193f,\
-0.2862269227110153524407f,-0.0328071976308584797866f,0.0351271945689521844503f,\
-0.1813816670814733522654f,-0.3701233874684188296378f,0.0635430885883380841550f,\
-0.1049291365916461549190f,0.0095204817066643597501f,-0.3507837205033069172266f,\
-0.0490285470477662618793f,-0.1735609734951024107907f,-0.4296178908501777637952f,\
-0.2551225266448440276434f,-0.0617650291008570578866f,-0.0848934350447099472792f,\
-0.0331679244708535381214f,0.0578595820981543801365f,-0.9721832280456300656724f,\
-0.2220295759617292030708f,-0.0235337862370093645059f,0.0670980880683051256197f,\
0.0456584724702859962031f,-0.4050627643604459149351f,0.0332188086620539904659f,\
-0.1843762947107071559216f,-0.2025989526775586746510f,-0.1728805677287464093173f,\
-0.5006140240740283298138f,-0.0039574496715991209703f,-0.3747624646211847876387f,\
-0.0291826804365620078030f,-0.0644170285495881678184f,-0.020449093098134307755f,\
0.1324382164856784949158f,-0.3626939268757052303727f,0.0521008032215845851010f,\
0.0438487661958249438920f,0.0803943913989621228300f,-0.1872441239933456957889f,\
0.0719513030064179159861f,-0.3021736609622284186472f,-0.30531498564977166410f,\
0.1057250974802272092123f,-0.0218353036625967035500f,-0.2885450025056992551242f,\
-0.0214746210927109354438f,-0.0480309906528200089570f,0.1141195620733326948626f,\
-0.2872136450436454380153f,-0.2146876003507041108520f,-0.0987270319138862650910f,\
-0.0290961734854755134372f,0.0117611124704010052561f,-0.1486623273058947924952f,\
0.1031611720947231414236f,-0.3065510644941032425415f,-0.0081304707590571338727f,\
0.0681862604059072646701f,0.0269042920576901857521f,0.0396225366257938194092f,\
-0.4394191704520844510284f,-0.4089149013992912085058f,-0.4543230131010723149565f,\
-0.0586330634787295829069f,-0.4539044694277152292017f,-1.3529821933222951901854f,\
-0.0250304307835438853702f,0.0358632689692895620381f,0.0372933340583203806751f,\
-0.0498532689013882687745f,0.0416880085188151769393f,-0.3780489142107763544942f,\
-0.0569883570641069869822f,-0.1773959401592627993516f,-0.2529880791121558170076f,\
-0.0887499827789579032178f,-0.0688387899649425538673f,-0.2164511122923038211052f,\
-0.6104407141161303229637f,0.0686738036393797490753f,-0.0747689959340766124862f,\
-0.0391919696178445325918f,-0.0650297590330818214843f,0.0896829227334642459235f,\
0.0266548623220910323173f,-0.3719537274000056514822f,-0.3494566550303903618158f,\
0.0711759971067136287814f,0.0703223378863101489245f,-0.1795974324279027423135f,\
-0.2999138709331988783546f,-0.0615107548910408530318f,-0.3900685687486248887090f,\
-0.0867686652200203717422f,-0.0780592259581650849132f,-0.0014744231840779402701f,\
0.1312513908465361422984f,0.0034351924950619906404f,-0.1453391630458231997824f,\
-0.2452127202368474256922f,-0.3536012485332969967899f,0.1109696410995756055140f,\
-1.2311333463434968038541f,-0.3067437997278838479609f}

#define CRESULTI {0.3633100487665162359185f,0.1474158063550214115001f,0.5885387980009104680335f,\
0.6572801175741773693773f,0.4285748579481841735728f,0.6638943219025983388804f,\
0.3587662857455625187164f,0.5117548829580961244901f,0.1866273414364414962030f,\
0.0699742348195561969515f,0.3328432735187898949825f,0.5666303041879406920955f,\
0.5568906423318142895340f,0.6796689265398294654830f,0.6374873742133734255688f,\
0.5900654029247031084893f,0.3087389836998947201252f,0.4314129861802953325167f,\
0.5242475923033280693630f,0.0610188495832547500575f,0.4354133593463934692736f,\
0.5297939421633884871099f,0.2681487567918271475165f,0.1547283383009969981448f,\
0.2426408568390991671304f,0.4474267034848418145287f,0.2347646885151994655683f,\
0.2599927875089523832131f,0.6126748695156737367640f,0.2064522777477181547656f,\
0.0284496210471740680614f,0.2258908609011123780341f,0.3256261235849059465508f,\
0.3061930542060117277359f,0.5264317995551247575392f,0.2959401807089209746060f,\
0.4910139616058311062829f,0.3969936639609323303368f,0.1786986723204381510843f,\
0.4324195385396965018998f,0.5655382812237433887148f,0.6410621383118232374798f,\
0.3723548821340513237388f,0.5990569422252302045351f,0.0016988593650344200551f,\
0.5214150467894975715666f,0.3070731387905711318176f,0.0340224494974534080738f,\
0.5552566039785586937683f,0.1002676097220635414997f,0.4323764448196805720848f,\
0.1964911590800132445978f,0.6084096209152420886568f,0.0357352532897105071297f,\
0.3489411661881484660874f,0.5453449961026168857359f,0.0694263094757205379004f,\
0.2525534710601468613156f,0.6206431406119353733075f,0.0690444796836073154678f,\
0.3380054707664132407352f,0.0887652999217624361084f,0.4176207649503542729263f,\
0.3210430331362784106553f,0.2631553422310267675854f,0.2437584071473132274477f,\
0.4336070270779164292918f,0.3661466421575780838538f,0.5640596254022186561983f,\
0.0407979674024822880352f,0.5856292520126130662916f,0.5194472182924043668351f,\
0.3655014659417109568196f,0.4226713256320973055580f,0.3981267146771410581074f,\
0.0323921796076454895918f,0.3160837480759546291864f,0.3995349584181833169083f,\
0.273802063686018282151f,0.4000313483957886884212f,0.1544145556607701974539f,\
0.3952425864610250583198f,0.1693632158699578948990f,0.6627611949754427245196f,\
0.167173661907591114550f,0.4086002639927426849376f,0.6540985540228395622719f,\
0.3642324586236761474467f,0.5468253741606181606016f,0.0703565244510996889993f,\
0.4580361055958868110594f,0.0880301024358387529389f,0.1299718766609879727625f,\
0.3310527463405003034680f,0.4637212462953029801227f,0.4294623340021747059936f,\
0.4691072369162453403746f,0.6335809675670333040998f,0.1788460444456893838616f,\
0.2444904068796305007805f,0.1910877540250672246280f,0.3910553307022346936073f,\
0.5870156732892560791370f,0.5581921905883382439839f,0.1182006499862187365313f,\
0.0247387920792678586701f,0.1716217468036307647328f,0.1677637778431290971337f,\
0.6278971871585069530752f,0.4952349292223454657602f,0.5872771345770251283369f,\
0.1150482129328096875254f,0.2875910738555041423758f,0.4544626742179224132556f,\
0.3490957130610289338435f,0.0369504335660946620079f,0.2852598765351710419225f,\
0.2907565249995825995555f,0.3370230396263981242910f,0.3047404031476670938083f,\
0.33865617237418182972f,0.5799887649794799315828f,0.2058615017488183152050f,\
0.1040542236456874769512f,0.5769758315245528956794f,0.6086314545246159779524f,\
0.1560306547104348962041f,0.4487914762887483810516f,0.2795367938070804081363f,\
0.3371389774796904048593f,0.1912601282140735381443f,0.3826791464254168939618f,\
0.2928983745329591936724f,0.396613573038569422469f,0.6618005209348483131038f,\
0.4362846209517689533008f,0.1830850765515834310815f,0.3800035453193333911948f,\
0.376730811842592550054f,0.5559265822426159298075f,0.3620694326893729719785f,\
0.4227803813529266152571f,0.2910061310239929199817f,0.3106691139011089619615f,\
0.435429394944240932830f,0.5878341337089509899272f,0.4743827280867594087255f,\
0.2874204018606083543830f,0.2094051712928121644630f,0.4486348592544623370415f,\
0.3764598089790200385885f,0.3919214486831592569871f,0.0316949858971651426964f,\
0.2391495340218968146395f,0.486361470580685850695f,0.3397962718388538583270f,\
0.1571941632596165761004f,0.6427949822892967679522f,0.3189060883322832884446f,\
0.3675164927613087662017f,0.5242598134907254792125f,0.2484566158604845087510f,\
0.0480705017921116625756f,0.4475807306655288364539f,0.3691029449284471408710f,\
0.5016842301167260265160f,0.3950665170276177473596f,0.4392508841037601752255f,\
0.1996012963954646446396f,0.5673662159944875549300f,0.4652972123009525562409f,\
0.1933199899606511118488f,0.6541522766180654091528f,0.0972438028822732308809f,\
0.2132613189014408716648f,0.3697245333311866000159f,0.6342931063454819717862f,\
0.2533327612355570357394f,0.2380763598053285134970f,0.3736506508141989035821f,\
0.3285546506249918952136f,0.4011970200297387822985f,0.5663267577447791412126f,\
0.2910519034072798771895f,0.4184422115344140213899f,0.1770121129168618634431f,\
0.1829818983774834095790f,0.1440504268816359956240f,0.5858489671891115024849f,\
0.4947061064648006212252f,0.5945317434266266243270f,0.1360392849738219778200f,\
0.3438694289300276984989f,0.5310838098864226752838f,0.5016736389654107286518f,\
0.1554601034674029658156f,0.4147310296690985831347f,0.3535773010333992383281f,\
0.3345663906426585842979f,0.0670148638928397127890f}




void slog10sTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out;
	int i;

	for (i=0;i<200;i++){
		out=slog10s(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<3e-5);
	}
}

void clog10sTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=FloatComplex(inR[i],inI[i]);
		out=clog10s(in);
		assert(( (fabs(creals(out)-resR[i]))/(fabs(creals(out))) )<3e-5);	
		assert(( (fabs(cimags(out)-resI[i]))/(fabs(cimags(out))) )<1e-6);			
	}
}

void slog10aTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out[200];
	int i,j;
	j=1;
	slog10a(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<3e-5);
	}
}

void clog10aTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex *in,out[200];
	int i;

	in=FloatComplexMatrix(inR,inI,200);
	clog10a(in,200,out);

	for (i=0;i<200;i++){
		assert(( (fabs(creals(out[i])-resR[i]))/(fabs(creals(out[i]))) )<3e-5);	
		assert(( (fabs(cimags(out[i])-resI[i]))/(fabs(cimags(out[i]))) )<1e-6);			
	}
}

int testLog10(void) {
  printf("\n>>>> 10-Based Logarithm Tests\n");
  slog10sTest();
  clog10sTest();
  slog10aTest();
  clog10aTest();
  return 0;
}

int main(void) {
  assert(testLog10() == 0);
  return 0;
}
