/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2006-2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testPow.h"

#define SOURCE {0.4672355107031762599945f,0.9742379654198884963989f,0.6003209394402801990509f,\
0.8107941793277859687805f,0.8507457631640136241913f,0.2203239351511001586914f,\
0.9582479097880423069000f,0.0577683029696345329285f,0.6003680988214910030365f,\
0.0178048145025968551636f,0.878713116515427827835f,0.9244096884503960609436f,\
0.1339239249937236309052f,0.4019813351333141326904f,0.9738700897432863712311f,\
0.5752419373020529747009f,0.6085763848386704921722f,0.5994307789951562881470f,\
0.2787468102760612964630f,0.7734748693183064460754f,0.1174856307916343212128f,\
0.6118692830204963684082f,0.5719244205392897129059f,0.4209215147420763969421f,\
0.9079484730027616024017f,0.5168110188096761703491f,0.7020753105171024799347f,\
0.1115869814530014991760f,0.9647724027745425701141f,0.9537742473185062408447f,\
0.0141105786897242069244f,0.9176791971549391746521f,0.8026339909993112087250f,\
0.7647842485457658767700f,0.4686868679709732532501f,0.1267915265634655952454f,\
0.8111716615967452526093f,0.2579231262207031250000f,0.5488225766457617282867f,\
0.1490072635933756828308f,0.9965628399513661861420f,0.0626764874905347824097f,\
0.5473734443075954914093f,0.3126759985461831092835f,0.4633354763500392436981f,\
0.0458269976079463958740f,0.3291175127960741519928f,0.7676118602976202964783f,\
0.4801639444194734096527f,0.2566448096185922622681f,0.1611994621343910694122f,\
0.2144636334851384162903f,0.4733993145637214183807f,0.370124869048595428467f,\
0.7056843214668333530426f,0.6790067506954073905945f,0.7920840024016797542572f,\
0.5970210935920476913452f,0.7679705549962818622589f,0.0501071596518158912659f,\
0.5882007922045886516571f,0.5294274277985095977783f,0.8948125229217112064362f,\
0.6001070654019713401794f,0.6559062353335320949554f,0.89065577276051044464f,\
0.4157023173756897449493f,0.2063825475051999092102f,0.5734984236769378185272f,\
0.6581607908010482788086f,0.0213609733618795871735f,0.4928230522200465202332f,\
0.9918691380880773067474f,0.5282615851610898971558f,0.4730890546925365924835f,\
0.6099827596917748451233f,0.4131903718225657939911f,0.1914102546870708465576f,\
0.5367266149260103702545f,0.8726538261398673057556f,0.3035852289758622646332f,\
0.3867573235183954238892f,0.7349725333042442798615f,0.9736115010455250740051f,\
0.8835331979207694530487f,0.2047640457749366760254f,0.0118132256902754306793f,\
0.9922811193391680717468f,0.4397597997449338436127f,0.6066115852445363998413f,\
0.9028107305057346820831f,0.9170769685879349708557f,0.5023606116883456707001f,\
0.6291570700705051422119f,0.3050001696683466434479f,0.9001630311831831932f,\
0.7309096655808389186859f,0.2441865224391222000122f,0.4401465845294296741486f,\
0.9633856015279889106751f,0.8533022212795913219452f,0.3407146632671356201172f,\
0.1051111468113958835602f,0.3741277782246470451355f,0.5010819151066243648529f,\
0.7990815918892621994019f,0.8030767445452511310577f,0.4098358312621712684631f,\
0.2850022832863032817841f,0.1255963407456874847412f,0.8493829430080950260162f,\
0.7299674442037940025330f,0.9545726603828370571137f,0.6164773050695657730103f,\
0.0457203206606209278107f,0.0741118313744664192200f,0.9853384527377784252167f,\
0.5198395475745201110840f,0.0164341800846159458160f,0.505031730048358440399f,\
0.4376457869075238704681f,0.1644789781421422958374f,0.8006876339204609394074f,\
0.9153772676363587379456f,0.4306405331008136272430f,0.5242034085094928741455f,\
0.7942340658046305179596f,0.0168217038735747337341f,0.0752517036162316799164f,\
0.186460481956601142883f,0.6345489663071930408478f,0.5303690480068325996399f,\
0.2099092262797057628632f,0.1940124779939651489258f,0.1230711438693106174469f,\
0.7965835509821772575378f,0.7827460928820073604584f,0.7284079920500516891480f,\
0.7783033107407391071320f,0.5244910726323723793030f,0.2240348826162517070770f,\
0.10400049015879631042f,0.1135220439173281192780f,0.8979023238644003868103f,\
0.6526086605153977870941f,0.0412637386471033096313f,0.2328471210785210132599f,\
0.7579079838469624519348f,0.2600162508897483348846f,0.6881541088223457336426f,\
0.8394202315248548984528f,0.0802956921979784965515f,0.7161618857644498348236f,\
0.3582697566598653793335f,0.2494430621154606342316f,0.4666389161720871925354f,\
0.9401792283169925212860f,0.4545566774904727935791f,0.5058247582055628299713f,\
0.8678076928481459617615f,0.0802897713147103786469f,0.5473116356879472732544f,\
0.1851887595839798450470f,0.258651246316730976105f,0.0463956105522811412811f,\
0.0752319693565368652344f,0.9919890114106237888336f,0.4826024798676371574402f,\
0.4391565932892262935638f,0.6382622700184583663940f,0.7334855501540005207062f,\
0.9849543431773781776428f,0.2193018416874110698700f,0.3509879373013973236084f,\
0.7693294645287096500397f,0.6535580744966864585877f,0.9609256512485444545746f,\
0.2253256086260080337524f,0.5295072314329445362091f,0.4856933178380131721497f,\
0.0325177642516791820526f,0.0512604638934135437012f,0.1943944268859922885895f,\
0.2998601151630282402039f,0.549478018190711736679f,0.7443804051727056503296f,\
0.1306688119657337665558f,0.2112427735701203346252f,0.4418653692118823528290f,\
0.6289571113884449005127f,0.1768327937461435794830f,0.0895956074818968772888f,\
0.481131290551275014877f,0.6253239680081605911255f,0.3720952612347900867462f,\
0.7183005558326840400696f,0.6095875459723174571991f,0.8103008717298507690430f,\
0.2223627963103353977203f,0.8733466742560267448425f}

#define EXPAND 0.4163583382032811641693f

#define RESULT {0.7284646681346131913415f,0.989192008106873243989f,0.8085895400964338008976f,\
0.9163769951101256028281f,0.9349137762043832067249f,0.5326945489743132311489f,\
0.9823995642201152067585f,0.305083797583213633953f,0.8086159867079506513576f,\
0.1868945690068203879797f,0.9475895783496315338823f,0.9678039608420992978566f,\
0.4329723055503270634503f,0.68423899539773069822f,0.9890364718108022312748f,\
0.7943497624629932696294f,0.8132007898688196068093f,0.808090117466149226999f,\
0.5875008761072864071906f,0.8985735866087510848033f,0.4099967340694569695181f,\
0.8150299171646913087841f,0.7924391432248698574625f,0.6974820008616173794280f,\
0.9605908201300753512797f,0.7597020352483303540225f,0.8630591732121281056678f,\
0.4012970358491440014959f,0.9851790447321197019548f,0.9804873634101264334717f,\
0.1696475368521674076394f,0.9648638597435894581622f,0.9125256586220036325585f,\
0.8943560812692227246501f,0.7294059529194845126199f,0.4232180082272890553341f,\
0.916554605507083564042f,0.5688124226892673496181f,0.7789513375488348323472f,\
0.4526453084551937400271f,0.9985674717102872577357f,0.3156199821647662773216f,\
0.7780943221002011300769f,0.6162804684283178513482f,0.7259267967438961521864f,\
0.2770427140579521108066f,0.6295715021115366738513f,0.8957313597799472226768f,\
0.7367902678841352637207f,0.5676369465830355398595f,0.4677127626898579526582f,\
0.5267487587241619362288f,0.7324505569224598611200f,0.6611168125785117366533f,\
0.8649036030014317644188f,0.8511368159883252459963f,0.9075123889490784856449f,\
0.8067359928657767964566f,0.8959056083070979781269f,0.2875361378747636753595f,\
0.8017520221011086301033f,0.7673694529244873274720f,0.9547798347087154136048f,\
0.8084695859896496861197f,0.8389586175592145256275f,0.9529306420557314138975f,\
0.6938680535086353406982f,0.5183921020261006429308f,0.793346444899387437388f,\
0.8401580945174779158080f,0.2016154416018380302056f,0.7448165896518380568736f,\
0.9966065805762621687691f,0.7666654335848160917166f,0.732250650546897197124f,\
0.8139827028709292200404f,0.6921192559761130125295f,0.5023891186631103122906f,\
0.7717567966494431885849f,0.9448634993544591242909f,0.6087559602629232236026f,\
0.6733278820109139806149f,0.8796721878469864197569f,0.9889271210673219458798f,\
0.9497503111327298963573f,0.5166955674002130516342f,0.157548601510365510192f,\
0.9967789108028516364968f,0.7103130756882061191959f,0.812106637266760356120f,\
0.9583239035572395092544f,0.9646001738095134614426f,0.7507845794857243015841f,\
0.8245398795703052785555f,0.6099356789350187657561f,0.9571527235790283638650f,\
0.8776442633914852686772f,0.5559974763067492276036f,0.7105731272697249911730f,\
0.9845891777882239681574f,0.9360824607784468120997f,0.6387148606873016554175f,\
0.3914310831295715331635f,0.6640844299927105565118f,0.7499883148290458212415f,\
0.9108419054310594731305f,0.9127352082795270327154f,0.6897741461687679764836f,\
0.5929547610295462511942f,0.4215523895030350853830f,0.934289925422809419686f,\
0.8771730273596389793056f,0.9808290164206334704744f,0.8175799454103661600968f,\
0.2767740197567316595695f,0.3384295343168625125330f,0.9938692202734674685516f,\
0.7615524516687232070566f,0.1807639486854548671602f,0.7524441192146538170960f,\
0.7088893722374375316875f,0.4716512920271773157133f,0.9116036713239157318611f,\
0.9638554137274480959619f,0.7041427136462521385596f,0.7642077184686376645217f,\
0.9085372292434992225196f,0.1825266043999770881889f,0.3405871110552653457937f,\
0.4969386012149143438954f,0.8274746814049287468862f,0.7679374104413381196821f,\
0.5220621091101612654128f,0.5052216371459599120186f,0.4180025804993992566416f,\
0.9096552753365539922825f,0.9030424754444578150370f,0.8763923131750169792653f,\
0.9009048556663895590546f,0.7643822986790410611846f,0.5364120201901159123992f,\
0.3897036620350837199389f,0.4041799474476096554199f,0.956151132910635803697f,\
0.8371998878550279687971f,0.2652042210750701900501f,0.5450981151899623178281f,\
0.8909992090057128333314f,0.5707298363723116718660f,0.8558922439179788010932f,\
0.9297114995403523707296f,0.3499125215193959470561f,0.8702273048082653783553f,\
0.6522163450193463329896f,0.560949837269416606844f,0.7280772489811332404130f,\
0.9746440403672457231110f,0.7201681760891580630357f,0.7529358332138126330690f,\
0.9426752591053616514571f,0.3499017784013320198078f,0.7780577391146925592125f,\
0.4955246248432562672370f,0.5694804460964003611778f,0.2784687951398606142739f,\
0.3405499204525159195889f,0.9966567274503397300123f,0.7383459049553654507392f,\
0.7099072481980015503211f,0.8294873733988427089159f,0.8789307415943956591775f,\
0.9937078900984196438984f,0.5316642496139925011534f,0.6466638927283177018524f,\
0.8965653157624376978774f,0.8377067792805890089625f,0.9835416334061796161947f,\
0.5376965838311716927578f,0.7674176109757441244241f,0.7403110930323951732746f,\
0.2401646248105218373059f,0.2902733727718892486891f,0.5056355181408417331923f,\
0.6056346866145997376307f,0.7793385312672220788244f,0.8843430174683920563794f,\
0.4285591961287324447305f,0.5234404705944887270519f,0.7117271278107557552772f,\
0.8244307605644806136169f,0.4860897924292185146022f,0.3662484869284197697148f,\
0.7374079263129095229701f,0.8224445894290783876102f,0.6625799211503411445534f,\
0.8713083765590698970271f,0.8137630792596124429394f,0.9161448146036499373679f,\
0.5347414781155725993500f,0.9451757704519925251674f}

#define CSOURCER {0.6045256052166223526001f,0.9455216196365654468536f,0.4476299257948994636536f,\
0.8624908211641013622284f,0.1751048639416694641113f,0.2067177616991102695465f,\
0.6848411662504076957703f,0.1348653226159512996674f,0.0069159921258687973022f,\
0.1496290047653019428253f,0.5665438110008835792542f,0.4359452719800174236298f,\
0.6547604538500308990479f,0.3381605879403650760651f,0.4259321158751845359802f,\
0.3060420057736337184906f,0.7704779822379350662231f,0.7058695447631180286408f,\
0.2373670237138867378235f,0.8205849635414779186249f,0.6789963841438293457031f,\
0.5250809141434729099274f,0.3359806565567851066589f,0.8941988362930715084076f,\
0.5461782198399305343628f,0.7568633262999355792999f,0.0259526828303933143616f,\
0.3250150899402797222138f,0.6072143577039241791f,0.8756139636971056461334f,\
0.2962085595354437828064f,0.4229678637348115444183f,0.4243144039064645767212f,\
0.7620028969831764698029f,0.3622896494343876838684f,0.5658242437057197093964f,\
0.6424440070986747741699f,0.7580267959274351596832f,0.2531452132388949394226f,\
0.5266989110969007015228f,0.2118590380996465682983f,0.4779220153577625751495f,\
0.1615962767973542213440f,0.9168031658045947551727f,0.5461866445839405059815f,\
0.4686870560981333255768f,0.7772213732823729515076f,0.5871783248148858547211f,\
0.5848031807690858840942f,0.3139644009061157703400f,0.3204141603782773017883f,\
0.3331634956412017345429f,0.2282590121030807495117f,0.2750317254103720188141f,\
0.4963629124686121940613f,0.7453477247618138790131f,0.1155001949518918991089f,\
0.0626524840481579303741f,0.0877018878236413002014f,0.5507565210573375225067f,\
0.2116370312869548797607f,0.8335358710028231143951f,0.4045845707878470420837f,\
0.2880227542482316493988f,0.1750094983726739883423f,0.0051561561413109302521f,\
0.3109287889674305915833f,0.6602919283322989940643f,0.9722995534539222717285f,\
0.9826813959516584873200f,0.0455837054178118705750f,0.4096118300221860408783f,\
0.7104403134435415267944f,0.3917615194804966449738f,0.5571686858311295509338f,\
0.0565565521828830242157f,0.1540721096098423004150f,0.9109257892705500125885f,\
0.5713340407237410545349f,0.3488348922692239284515f,0.8972954172641038894653f,\
0.2973396372981369495392f,0.1091936426237225532532f,0.7626331257633864879608f,\
0.6584706604480743408203f,0.6996708759106695652008f,0.6756794182583689689636f,\
0.9004421546123921871185f,0.6668148916214704513550f,0.8518152837641537189484f,\
0.8365677157416939735413f,0.1291190306656062602997f,0.6095453463494777679443f,\
0.2412315667606890201569f,0.4029275467619299888611f,0.3019328541122376918793f,\
0.1083198729902505874634f,0.8456356939859688282013f,0.9417407037690281867981f,\
0.9083450469188392162323f,0.1937242373824119567871f,0.5318046086467802524567f,\
0.8314437521621584892273f,0.4952740012668073177338f,0.7465563025325536727905f,\
0.7102393140085041522980f,0.5811418974772095680237f,0.7035941029898822307587f,\
0.3746570833027362823486f,0.3394373343326151371002f,0.6322447275742888450623f,\
0.7636191300116479396820f,0.6940386760979890823364f,0.8735245508141815662384f,\
0.3612738298252224922180f,0.7933200257830321788788f,0.4830590635538101196289f,\
0.2469964125193655490875f,0.5025922833010554313660f,0.7430270477198064327240f,\
0.6783937942236661911011f,0.4903185223229229450226f,0.709806025959551334381f,\
0.3303662906400859355927f,0.6815545372664928436279f,0.0701365978457033634186f,\
0.4745870968326926231384f,0.8091805852018296718597f,0.9447045121341943740845f,\
0.5478458073921501636505f,0.1216687532141804695129f,0.9161847713403403759003f,\
0.3045207932591438293457f,0.6502694808878004550934f,0.0987624628469347953796f,\
0.8391053467057645320892f,0.0328534897416830062866f,0.3461971958167850971222f,\
0.2801467711105942726135f,0.5500544901005923748016f,0.0729318000376224517822f,\
0.0225322381593286991119f,0.50267804320901632309f,0.3478884599171578884125f,\
0.4298669416457414627075f,0.3537984383292496204376f,0.0529730813577771186829f,\
0.9533003675751388072968f,0.1842019557952880859375f,0.958756382111459970474f,\
0.3245136169716715812683f,0.0003973259590566158295f,0.0972583871334791183472f,\
0.4378789965994656086f,0.3634226778522133827210f,0.2685119728557765483856f,\
0.2770298384130001068115f,0.8854365111328661441803f,0.5216628303751349449158f,\
0.4979983693920075893f,0.8733724001795053482056f,0.4699407932348549365997f,\
0.9364062966778874397278f,0.1337622734718024730682f,0.2712419554591178894043f,\
0.1766990595497190952301f,0.0543269468471407890320f,0.8402757882140576839447f,\
0.7507283594459295272827f,0.3062269617803394794464f,0.9195641661062836647034f,\
0.1318263853900134563446f,0.0826364941895008087158f,0.8222710476256906986237f,\
0.4441085970029234886169f,0.9617503038607537746429f,0.0283641982823610305786f,\
0.1431905967183411121368f,0.3793597565963864326477f,0.6144003230147063732147f,\
0.2128270715475082397461f,0.4704488315619528293610f,0.2076055286452174186707f,\
0.7435979112051427364349f,0.3391801547259092330933f,0.2479635034687817096710f,\
0.6721735307946801185608f,0.9013197491876780986786f,0.2140864841639995574951f,\
0.8460668534971773624420f,0.1650043567642569541931f,0.4003686285577714443207f,\
0.5522825215011835098267f,0.0638249483890831470490f,0.6903966935351490974426f,\
0.8547787251882255077362f,0.0291904583573341369629f,0.5434663915075361728668f,\
0.6236743135377764701843f,0.2417052476666867733002f}

#define CSOURCEI {0.5503273960202932357788f,0.6906704087741672992706f,0.9835249418392777442932f,\
0.8285484607331454753876f,0.2062614001333713531494f,0.1944643096067011356354f,\
0.4367609983310103416443f,0.8090620837174355983734f,0.8818644303828477859497f,\
0.7404803228564560413361f,0.7542522149160504341126f,0.9921960639767348766327f,\
0.9886121451854705810547f,0.0113218077458441257477f,0.9367801276966929435730f,\
0.3874237253330647945404f,0.2886805813759565353394f,0.567788839805871248245f,\
0.7295644441619515419006f,0.0303032915107905864716f,0.2795897088944911956787f,\
0.7047131718136370182037f,0.7442112853750586509705f,0.8920237845741212368012f,\
0.1081438604742288589478f,0.8751525697298347949982f,0.9068333031609654426575f,\
0.2166852983646094799042f,0.4824190363287925720215f,0.7766945236362516880035f,\
0.4510916722938418388367f,0.1300636469386518001556f,0.5505470838397741317749f,\
0.6936193336732685565949f,0.1749099576845765113831f,0.8636093880049884319305f,\
0.2150467522442340850830f,0.1886725709773600101471f,0.1796098565682768821716f,\
0.4374312213622033596039f,0.8514516223222017288208f,0.7381969136185944080353f,\
0.8102188156917691230774f,0.1460137623362243175507f,0.8999849110841751098633f,\
0.4043733575381338596344f,0.0156995235010981559753f,0.6904196902178227901459f,\
0.2990311514586210250855f,0.1383218024857342243195f,0.8478512773290276527405f,\
0.3007262717001140117645f,0.229154746979475021362f,0.8078110129572451114655f,\
0.3176332255825400352478f,0.6924462593160569667816f,0.1364154014736413955689f,\
0.5433279541321098804474f,0.3276594849303364753723f,0.2006831648759543895721f,\
0.5037304237484931945801f,0.4962565028108656406403f,0.8996161324903368949890f,\
0.9357709079049527645111f,0.3390339072793722152710f,0.6029155333526432514191f,\
0.4153500730171799659729f,0.3041478390805423259735f,0.8489827848970890045166f,\
0.4482063786126673221588f,0.0903797810897231101990f,0.7382151386700570583344f,\
0.2669597584754228591919f,0.8226196658797562122345f,0.3985779182985424995422f,\
0.9789295899681746959686f,0.3041231036186218261719f,0.0663515278138220310211f,\
0.6667758254334330558777f,0.7548807277344167232513f,0.1922533493489027023315f,\
0.7942791883833706378937f,0.5580398896709084510803f,0.2016023616306483745575f,\
0.787146832793951034546f,0.0955459238030016422272f,0.6623697867617011070252f,\
0.864868474658578634262f,0.7013061288744211196899f,0.8015053984709084033966f,\
0.9135685982182621955872f,0.6317234965972602367401f,0.9346773549914360046387f,\
0.9157753759063780307770f,0.0510348035022616386414f,0.4329969524405896663666f,\
0.9721843507140874862671f,0.8001508046872913837433f,0.8452261472120881080627f,\
0.0610524858348071575165f,0.8168097324669361114502f,0.2101262793876230716705f,\
0.3055453812703490257263f,0.9465212575159966945648f,0.9269728232175111770630f,\
0.7737778765149414539337f,0.5893978821113705635071f,0.2377697187475860118866f,\
0.5269544571638107299805f,0.0077543654479086399078f,0.8311711428686976432800f,\
0.0268517597578465938568f,0.2591186594218015670776f,0.4641277943737804889679f,\
0.6098861405625939369202f,0.0656952331773936748505f,0.6466812007129192352295f,\
0.1018534512259066104889f,0.2742705782875418663025f,0.8162728524766862392426f,\
0.3357750270515680313110f,0.4765891996212303638458f,0.8440040023997426033020f,\
0.1785074654035270214081f,0.5855625644326210021973f,0.8426241897977888584137f,\
0.7058847947046160697937f,0.7396617024205625057221f,0.9751448985189199447632f,\
0.7606669445522129535675f,0.8236690396443009376526f,0.8889620001427829265595f,\
0.7960178293287754058838f,0.3052428201772272586823f,0.6803312664851546287537f,\
0.6412069997750222682953f,0.0988248009234666824341f,0.4654508423991501331329f,\
0.6714970665052533149719f,0.5131103205494582653046f,0.8631567060947418212891f,\
0.8328299173153936862946f,0.1687975851818919181824f,0.2961277081631124019623f,\
0.2591485660523176193237f,0.1700844173319637775421f,0.9718958893790841102600f,\
0.0695185582153499126434f,0.4696230851113796234131f,0.9544191421009600162506f,\
0.3679352095350623130798f,0.2973918146453797817230f,0.0415310803800821304321f,\
0.4892336544580757617950f,0.5171590568497776985169f,0.3534862431697547435761f,\
0.2354387864470481872559f,0.6779259913600981235504f,0.3834532154724001884460f,\
0.3174350797198712825775f,0.3418120350688695907593f,0.0535557498224079608917f,\
0.9285596096888184547424f,0.3862650538794696331024f,0.4328473098576068878174f,\
0.1581165478564798831940f,0.7887120461091399192810f,0.7448797873221337795258f,\
0.5185996759682893753052f,0.8651678604073822498322f,0.1524438308551907539368f,\
0.2392775672487914562225f,0.5761575847864151000977f,0.7395762302912771701813f,\
0.0583172617480158805847f,0.6962534948252141475678f,0.4206145536154508590698f,\
0.0281158541329205036163f,0.8313249954953789710999f,0.2333360086195170879364f,\
0.8865877203643321990967f,0.3746785433031618595123f,0.87671328987926244736f,\
0.4027077830396592617035f,0.2890332732349634170532f,0.8538430598564445972443f,\
0.5499771209433674812317f,0.5128610017709434032440f,0.6321087554097175598145f,\
0.4165538274683058261871f,0.3217771751806139945984f,0.9717370062135159969330f,\
0.5348322447389364242554f,0.3416590173728764057159f,0.9565287167206406593323f,\
0.9951003189198672771454f,0.3422884084284305572510f,0.7870580093003809452057f,\
0.9234123295173048973084f,0.5238970420323312282562f}

#define CEXPAND  FloatComplex(0.3911314327269792556763f,0.0342082274146378040314f)

#define CRESULTR {0.8655722944852924927162f,1.0080311239181567461998f,0.8925609142479407065451f,\
0.9964280419988468251447f,0.5571485762795388430035f,0.5766215951761861635561f,\
0.8833535690601446166426f,0.7551084203039666320478f,0.7412402656397241162978f,\
0.7391120775302850720578f,0.8861033666941620090540f,0.8909045287065679996630f,\
0.9553114711351453625099f,0.6535792477810216105638f,0.8762967780815824614393f,\
0.6963121473209069600685f,0.9071008437483685238334f,0.9080649209860272019768f,\
0.7651103758972559454321f,0.9246247726026085578255f,0.8656267259726894147676f,\
0.8620727374643903928586f,0.8030427255614291937036f,1.014256580496504245303f,\
0.7887395917701954806134f,0.9690769811804932354349f,0.75373087988847220497f,\
0.665324036040102595457f,0.8564304632009258622105f,0.9943426065332526819773f,\
0.7091702303650339045404f,0.7167445282856460542220f,0.7911175844993063588362f,\
0.9453949687634901621891f,0.6824619663334378083519f,0.9058411269303636714767f,\
0.8438785717448686884978f,0.8969692115256107101118f,0.6070703034893107918890f,\
0.8141804062940767305889f,0.7904108638330922254056f,0.8517415416153172325053f,\
0.7635694344691914547951f,0.9644146393547212703368f,0.9063017724357406157409f,\
0.7813949726703418585672f,0.9055722155740445478145f,0.8821341574516833317077f,\
0.8226826712356364312839f,0.6436863850966426658928f,0.8232923424855791427746f,\
0.6889381687909778007040f,0.6034207402867282077352f,0.7986983615906712019594f,\
0.7808389246254876514541f,0.9393662483390998740873f,0.4756496767288962979059f,\
0.6410331785900358347874f,0.5570736776954752222935f,0.7962089930094966572227f,\
0.6867653317367202747690f,0.9490886605505213236000f,0.8617186127290810127022f,\
0.8347121855317853889034f,0.6099049384775118154423f,0.6446553539303585544928f,\
0.7064095183446724712795f,0.8589826028412402836310f,1.0333280419860488841266f,\
1.0009679370157384958873f,0.3688473932823669865222f,0.8275000335386157868101f,\
0.8791435711677849651480f,0.8404774761127835613905f,0.8221259638143403325472f,\
0.7823902259896605704270f,0.5836984889260519171472f,0.9624591212353429403592f,\
0.87214445216994962440f,0.8101176247061679935868f,0.9569519742645639093226f,\
0.8025144823533889582023f,0.6640375158107885145142f,0.8994725858878525048823f,\
0.9233788797234009360082f,0.8679958766637961842250f,0.9100186689417938401547f,\
1.0128641777475222429672f,0.9127218133217330775509f,0.9896138009394465084867f,\
0.9993082101967839525614f,0.6972926524978265705457f,0.9323806069591931144913f,\
0.8160101391916357860268f,0.6998385921148442267992f,0.7068441167224135401881f,\
0.7938968406481717865475f,0.9874359653522727375830f,1.0234238356749769671694f,\
0.9614819054159017275296f,0.7753407410455703807628f,0.7868519463954313231113f,\
0.9338642936617034262525f,0.8994361995251628494330f,0.9734883682358368428567f,\
0.9388466429512447586347f,0.8625681777851778031518f,0.8742421714653901831937f,\
0.7644849876693550205786f,0.6546359139100853541393f,0.9218660826188850299090f,\
0.8990166027048773766950f,0.8711301239674282825831f,0.9615090167391108222361f,\
0.7791813215771166145629f,0.9117874338036765502480f,0.8349616312306362697626f,\
0.5854098493033248473694f,0.7781598635219196813395f,0.9560498319869397132464f,\
0.8700533052058453398203f,0.8046824930853576640644f,0.9493290716357183356422f,\
0.6616981690563410456463f,0.9011123668510968576229f,0.7463274688937293621649f,\
0.8438944808683609410949f,0.967670917420046960977f,1.0395767162530316074509f,\
0.8807547325114291059123f,0.7554892774648256370540f,1.0206386037631571817030f,\
0.8053238451013553511615f,0.8544388176999402340073f,0.7032843861931318274472f,\
0.9661800692102989751575f,0.3625289807733498292919f,0.7365208997706992333221f,\
0.7641887204486981222118f,0.8370383509177440339855f,0.7532858906222718031742f,\
0.7301419617080030510792f,0.7674102539899976260784f,0.6963774291087447831927f,\
0.7363495079699874379386f,0.6761329476101115565356f,0.7795085331527642491523f,\
0.9796876475370105419316f,0.6630224685689680708123f,1.0412428453447015730404f,\
0.7007987051265935907196f,0.4957725828833144943175f,0.4082730584143764995808f,\
0.7838070894699612489731f,0.7572068286455557739600f,0.6666425764079034754772f,\
0.6381705607729424301056f,0.9863693130746217230254f,0.8032162659781901803413f,\
0.7816455003905713461165f,0.9529341373635599188319f,0.7431207805833531798712f,\
1.0315213570726253777821f,0.6072910725514631957722f,0.6918695596662881586170f,\
0.5400639166795813128630f,0.7250562108574124531302f,0.9788012629543616505146f,\
0.9194404507581022123475f,0.8230461548879194344508f,0.9655761323394732587033f,\
0.5404820390080352643381f,0.6609198489663343778489f,0.9720869068178448202389f,\
0.7269646989456197694324f,1.0139914787794561679135f,0.5745919175986482496654f,\
0.4679101548416189637614f,0.8383907049310611592219f,0.8313089288905458618117f,\
0.8000776949896156731157f,0.7769598400111837888105f,0.7959059962591698011991f,\
0.9044673697739834539178f,0.6897306414144260822141f,0.8021024469389655964235f,\
0.8925260669951027292512f,0.9759461964985622905999f,0.7283675470231352200301f,\
0.9471290701945646040016f,0.5973840169182614845411f,0.8760985519463477810831f,\
0.8416576754202981236475f,0.5517569581734146355601f,0.9608393360039786390558f,\
1.0156994041747668955367f,0.5352727784981988756741f,0.8841861277509572847322f,\
0.9348154737561720217798f,0.7061621510971951565239f}

#define CRESULTI {0.2507352759957017229731f,0.2597077035238002373774f,0.4311375801547998043439f,\
0.3142096700904059569659f,0.1689085837110216592460f,0.1485678383570865346286f,\
0.1928467320522971317764f,0.4557228688087557322284f,0.5147867499839029470365f,\
0.4298954588594036674287f,0.3339518115646432083743f,0.4361032888669963969441f,\
0.3942661152625340226230f,-0.0156759414692011767034f,0.4216342190154458435814f,\
0.2375262387333460234462f,0.1218623208365654658758f,0.2430961140393538000293f,\
0.4005557344949497444731f,0.0071165503832518592006f,0.1239424146890654998554f,\
0.3239999103802678193098f,0.3796166421020668590991f,0.3301654490061948776791f,\
0.0445509799759439481526f,0.3433255246943433536266f,0.5155063670908992534692f,\
0.1333705576653928526199f,0.2222401853006255867395f,0.2958473844131312979755f,\
0.2718238835045109769162f,0.0638111633635406738652f,0.2844115395647432431581f,\
0.2819711640048214729148f,0.0995008638276371482068f,0.3708897696809553279351f,\
0.0957826319358946326465f,0.0782020197404261763197f,0.1239058544887542273605f,\
0.2149541532842871305320f,0.4468354605467026452459f,0.3454060748345405551518f,\
0.4482667635221281310365f,0.0571905015324990773085f,0.3861704363530624739553f,\
0.2095642888443723650394f,-0.0006474107340685887483f,0.3074538897511936430540f,\
0.1416418035595575219965f,0.0813510707235199914678f,0.4178944079756690133110f,\
0.18311799903417008695f,0.1665779146084863104882f,0.4164312720201777673346f,\
0.1619976176982119708825f,0.2837987818207240997559f,0.1371322947622884147467f,\
0.3919995308417341117746f,0.286564517326931111896f,0.0947138076393856248592f,\
0.3217566148347950072406f,0.2012986727837245137796f,0.4147875243243727139131f,\
0.4526264616938408535951f,0.2543075867710146709122f,0.4351291297892320164564f,\
0.25036019692983552121f,0.1367950667990639190830f,0.3077766302819374688582f,\
0.1718309573016958136105f,0.1360328259424684049783f,0.3601092291418593882568f,\
0.115968588156260335453f,0.3929767663484189932355f,0.1924420270514885511481f,\
0.5251513760714544565289f,0.2427797113296941700078f,0.0243927289528858663725f,\
0.3014989005539743804896f,0.3801688209308042853962f,0.0763497789484379602021f,\
0.4062860677618788662890f,0.3797590074517701586032f,0.0838649495994110844022f,\
0.3295489656272450607055f,0.0357665894585867810695f,0.2829096131593998308951f,\
0.3209960925989643332201f,0.2983490076404094470952f,0.3068339844593696019715f,\
0.3442039183940806545969f,0.3997229201738806136923f,0.3855619142782349961784f,\
0.4583545007457388020811f,0.0129171956556070680056f,0.2615205358423942638702f,\
0.5091243033451308130921f,0.3071680827115451650755f,0.3100250105838900926969f,\
0.0221547458511593270414f,0.4411750253003750010805f,0.1013179671536272169474f,\
0.1255083141058383477962f,0.4104233196300889341401f,0.3610487505240286831842f,\
0.3169796206475462563290f,0.2701202532733757433192f,0.1030111453872422366818f,\
0.2857724100202110317781f,-0.0183464877937233594718f,0.3485944785418330638116f,\
0.0040848531118679188429f,0.1134446524724902760628f,0.1855694326698145713017f,\
0.3234291264874709082022f,0.0223549106164038433042f,0.3105918323857878027283f,\
0.0633707862092978274626f,0.1386383792252010582757f,0.3263302138383256667531f,\
0.1495653713305781229437f,0.238933687038423103743f,0.3403467519630717363910f,\
0.1069587420575875136297f,0.2532367083846476796261f,0.4848918076968742330024f,\
0.3344586340162984394731f,0.2917134330674172049136f,0.3489590836696481734869f,\
0.3396338202076644718908f,0.4639844509888130796860f,0.3265435199559258427904f,\
0.4050419249651691089298f,0.1381892282967451812681f,0.4265392723554026210842f,\
0.2540046810921274267336f,0.1582030803668608431867f,0.2652048658869911035296f,\
0.3681251025496489193145f,0.2442033766470435018903f,0.4897753247400377096810f,\
0.4969094538937048333160f,0.0808848883024730763713f,0.177092893746416069067f,\
0.1405588477423546367451f,0.0975493235811483866415f,0.5243731122097079477840f,\
0.0263866256125966647250f,0.3160166163140329387282f,0.3411837870670260119965f,\
0.2224220694199508796540f,0.319442449785955595587f,0.0331421867036013270691f,\
0.2549221660285751478448f,0.2842420144041926111100f,0.2302184532629851232422f,\
0.1567850704050047783156f,0.2616647545633992155700f,0.1906579007076603937687f,\
0.1616590279518919370805f,0.1379022630075907862590f,0.0139510212573068798775f,\
0.3361354155389051356906f,0.2959004712785165969180f,0.2703106383010808189127f,\
0.1300325021070959929936f,0.4744646613374619570358f,0.2895824249534337813117f,\
0.2184961358962822230989f,0.426807187423937750559f,0.0597990003127331498645f,\
0.2115261803479235591663f,0.3963149188292993674310f,0.2900288348173129526764f,\
0.0171555875146988598412f,0.259954574571872487621f,0.3590435173524976764092f,\
0.0046771943868099191341f,0.3986564841709960838045f,0.1066577525426010836229f,\
0.4571171140442078506538f,0.1948069655442623004937f,0.4555736953569811120701f,\
0.172447721502373058078f,0.1749336453691343052f,0.4380034702144764424681f,\
0.2406770716320568714863f,0.2014785207952041745649f,0.3725791699557115532748f,\
0.169353818078211759701f,0.2485400584530522705151f,0.4375888098622027211349f,\
0.2529242309847982150828f,0.3057408437536958678571f,0.3787762920334192262573f,\
0.3662661014371520473709f,0.3241866507622078730222f,0.3495665845168827723377f,\
0.3796220139680390737169f,0.3208771087739308858211f}



void spowsTest(void) {
	float in1[]=SOURCE;
	float in2=EXPAND;
	float res[]=RESULT;
	float out1,out2,out3;
	int i;

	for (i=0;i<200;i++){
		out1=spows(in1[i],in2);
		out2=spows(in1[i],0);
		out3=spows(in1[i],1);

		assert(( (fabs(out1-res[i]))/(fabs(out1)) )<1e-6);
		assert(( (fabs(out2-1))/(fabs(out2)) )<1e-16);
		assert(( (fabs(out3-in1[i]))/(fabs(out3)) )<1e-16);
	}
}


void cpowsTest(void) {
	float in1R[]=CSOURCER;
	float in1I[]=CSOURCEI;
	floatComplex in2=CEXPAND;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in1,out;
	int i;

	for (i=0;i<200;i++){
		in1=FloatComplex(in1R[i],in1I[i]);
		out=cpows(in1,in2);
		assert(( (fabs(creals(out)-resR[i]))/(fabs(creals(out))) )<1e-5);	
		assert(( (fabs(cimags(out)-resI[i]))/(fabs(cimags(out))) )<1e-5);			
	}
}

void spowaTest(void) {
	float in1[]=SOURCE;
	float in2[200];
	float ZERO[200]={0};
	float ONE[200];
	float res[]=RESULT;
	float out1[200],out2[200],out3[200];
	int i;

	for (i=0;i<200;i++) {
		in2[i]=EXPAND;
		ONE[i]=1;
	}
	spowa(in1,200,in2,out1);
	spowa(in1,200,ZERO,out2);
	spowa(in1,200,ONE,out3);
	for (i=0;i<200;i++){
		assert(( (fabs(out1[i]-res[i]))/(fabs(out1[i])) )<1e-6);
		assert(( (fabs(out2[i]-1))/(fabs(out2[i])) )<1e-16);
		assert(( (fabs(out3[i]-in1[i]))/(fabs(out3[i])) )<1e-16);
	}
}

void cpowaTest(void) {
	float in1R[]=CSOURCER;
	float in1I[]=CSOURCEI;
	floatComplex in2[200];
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex *in1, out[200];
	int i;
	
	for (i=0;i<200;i++) in2[i]=CEXPAND;
	in1=FloatComplexMatrix(in1R,in1I,200);
	cpowa(in1,200,in2,out);

	for (i=0;i<200;i++){
		assert(( (fabs(creals(out[i])-resR[i]))/(fabs(creals(out[i]))) )<1e-6);	
		assert(( (fabs(cimags(out[i])-resI[i]))/(fabs(cimags(out[i]))) )<1e-6);			
	}
}

int testPow(void) {
  printf("\n>>>> Powonential Tests\n");
  spowsTest();

    cpowsTest();
    spowaTest();
    cpowaTest();

  return 0;
}

int main(void) {
  assert(testPow() == 0);
  return 0;
}
