/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testSin.h"


#define SOURCE {0.7062616096809506416321,0.4090520101599395275116,0.3011248558759689331055,\
0.1880126395262777805328,0.1796709178015589714050,0.2828889950178563594818,\
0.7232380937784910202026,0.7360379849560558795929,0.1852612206712365150452,\
0.7703790138475596904755,0.1914967410266399383545,0.7521587223745882511139,\
0.6205883463844656944275,0.2807604051195085048676,0.2289868686348199844360,\
0.5049233403988182544708,0.8354099662974476814270,0.8174716415815055370331,\
0.0030740275979042053223,0.3677616142667829990387,0.8278525872156023979187,\
0.72754097869619727135,0.5323124285787343978882,0.9267726917751133441925,\
0.9542504185810685157776,0.3162104780785739421845,0.5789009965956211090088,\
0.6881225542165338993073,0.3714061146602034568787,0.1705444059334695339203,\
0.1954363007098436355591,0.978800852317363023758,0.9300233917310833930969,\
0.5357720064930617809296,0.3947123587131500244141,0.1344871171750128269196,\
0.7380615202710032463074,0.588114650454372167587,0.9113173168152570724487,\
0.5682763461954891681671,0.1127616921439766883850,0.9478473584167659282684,\
0.5237770043313503265381,0.8140139640308916568756,0.1400952627882361412048,\
0.2763446993194520473480,0.9059953633695840835571,0.1379901585169136524200,\
0.5603838684037327766419,0.3008610638789832592011,0.4767417535185813904,\
0.8127435916103422641754,0.1988414181396365165710,0.1107953130267560482025,\
0.2159351315349340438843,0.6467244853265583515167,0.6597879612818360328674,\
0.0691898013465106487274,0.9164751060307025909424,0.8635670826770365238190,\
0.5032854294404387474060,0.1832137755118310451508,0.8403698671609163284302,\
0.9247214836068451404572,0.6229452537372708320618,0.2773811477236449718475,\
0.2479109913110733032227,0.3891948559321463108063,0.0436578569933772087097,\
0.8132526441477239131928,0.7686451207846403121948,0.4041520212776958942413,\
0.8579940209165215492249,0.6993723283521831035614,0.0828925184905529022217,\
0.9201254160143435001373,0.5200281282886862754822,0.9351884997449815273285,\
0.8825624976307153701782,0.2245844271965324878693,0.2153332801535725593567,\
0.4327089670114219188690,0.5800157263875007629395,0.8876141034997999668121,\
0.5258982880041003227234,0.859640696551650762558,0.7337234076112508773804,\
0.7134532411582767963409,0.1087165409699082374573,0.8477638359181582927704,\
0.6594733335077762603760,0.7916418449021875858307,0.6067967480048537254334,\
0.4102901122532784938812,0.1958728153258562088013,0.241527963895350694656,\
0.5113455550745129585266,0.9119556057266891002655,0.0928984880447387695313,\
0.7438839026726782321930,0.1938720373436808586121,0.4355978979729115962982,\
0.9922429900616407394409,0.4533818070776760578156,0.8269640663638710975647,\
0.8889675955288112163544,0.4682085178792476654053,0.3856786251999437808991,\
0.4124865522608160972595,0.6955242282710969448090,0.0978972557932138442993,\
0.8728604433126747608185,0.6359515609219670295715,0.4129665228538215160370,\
0.0294486805796623229980,0.1809961968101561069489,0.7658103061839938163757,\
0.1232470511458814144135,0.0170737411826848983765,0.8835507561452686786652,\
0.3164170170202851295471,0.9378212536685168743134,0.3916359134018421173096,\
0.0844073877669870853424,0.6934146797284483909607,0.4618808380328118801117,\
0.9355291295796632766724,0.0842495900578796863556,0.5402926551178097724915,\
0.5613215523771941661835,0.1306025832891464233398,0.5840523042716085910797,\
0.0048661706969141960144,0.2761953338049352169037,0.7478824090212583541870,\
0.0194325004704296588898,0.6444276878610253334045,0.2243968318216502666473,\
0.2478402368724346160889,0.1196091384626924991608,0.1883201440796256065369,\
0.3393343067727982997894,0.959958622232079505920,0.2847225037403404712677,\
0.8766820700839161872864,0.2853349032811820507050,0.5103433504700660705566,\
0.8752629184164106845856,0.5941145820543169975281,0.3945342986844480037689,\
0.4661326166242361068726,0.0073588271625339984894,0.5170202488079667091370,\
0.4690007264725863933563,0.6654530800879001617432,0.9476742581464350223541,\
0.4933638339862227439880,0.2918433747254312038422,0.2016727942973375320435,\
0.7016656589694321155548,0.8736049132421612739563,0.191055159550160169601,\
0.5307010114192962646484,0.8889481076039373874664,0.0115523664280772209167,\
0.4998398735187947750092,0.6700848620384931564331,0.4995208983309566974640,\
0.1538907447829842567444,0.2571737091057002544403,0.9586529098451137542725,\
0.6246025026775896549225,0.9371285131201148033142,0.9923511571250855922699,\
0.3454555813223123550415,0.7558249053545296192169,0.2107181670144200325012,\
0.9372652801685035228729,0.6767524704337120056152,0.7465373151935636997223,\
0.4050982249900698661804,0.5101723610423505306244,0.9497965183109045028687,\
0.0289692510850727558136,0.1634070957079529762268,0.4146909262053668498993,\
0.0021650679409503936768,0.1810030029155313968658,0.4556188201531767845154,\
0.1977851442061364650726,0.6053877938538789749146,0.4363054675050079822540,\
0.8938506888225674629211,0.6104825991205871105194,0.4316215068101882934570,\
0.2315693595446646213532,0.4675927339121699333191,0.6150764389894902706146,\
0.8621218334883451461792,0.3846137975342571735382}

#define RESULT {0.6489941700631755017170,0.3977397277804613495711,0.2965946353370927379700,\
0.1869069269006927436205,0.1787057982923107302131,0.2791309758033572174796,\
0.6618156282674139134770,0.6713568034120557248556,0.1842032905163836498108,\
0.6964072867055017823645,0.1903284889107588750967,0.6832166836832923584311,\
0.5815139023939676077291,0.2770863600724933761832,0.2269909547378782532778,\
0.4837403483762576783533,0.7415716096535567292136,0.7294185948731235491493,\
0.0030740227564945614772,0.3595276195652636896938,0.7364804339477919459256,\
0.6650352209120763413708,0.5075271675293236972593,0.7996863750649069180199,\
0.8158805463618925557512,0.3109671621400240670852,0.5471043307230858410151,\
0.6350880886600825947497,0.3629260331962892438540,0.1697188821645874701183,\
0.1941945483009222261916,0.8298288212470000813070,0.8016339250362096713332,\
0.5105050203992042012757,0.3845426809733389905688,0.1340820770536885198077,\
0.6728551393063956220786,0.5547934214048261258867,0.7903115520300768581663,\
0.5381801020151927295032,0.1125228794588504499519,0.8121614659213718390163,\
0.5001543426683193738214,0.7270489540313778142888,0.1396374447476722568950,\
0.2728408635666067505454,0.787039586876701835472,0.1375526569581922986529,\
0.5315113932434574195440,0.2963427027488344522865,0.4588866814078613742822,\
0.7261761481530248918404,0.1975337103519642922844,0.1105687722679299794804,\
0.2142609363196769090010,0.6025755797169196625873,0.6129493292515678648513,\
0.0691346099927565571619,0.7934612300206389523538,0.7601650349312217835873,\
0.4823061815340158875465,0.1821904962108664982612,0.7448899416114136418088,\
0.7984531114259775241848,0.5834297155392762501691,0.2738378415422391687351,\
0.2453793544289556705085,0.3794436069308826930957,0.0436439896074229186085,\
0.7265260320935078564020,0.6951619177333813182074,0.3932392395246541161313,\
0.756532263098035340221,0.6437374906114369244037,0.0827976230060826490220,\
0.7956775933285428203945,0.4969045479155810296490,0.8047109984386738856799,\
0.7723690449233312493860,0.2227012449582090047873,0.2136730232885993008285,\
0.4193316280451939714880,0.5480370912598671040428,0.7755678252599553790248,\
0.5019901124659599256361,0.7576080909498315030248,0.6696395939777050054786,\
0.6544486857456611739181,0.1085025088408962251618,0.7498026974031274383137,\
0.6127007045227848003322,0.7115079193085073194780,0.5702389863986391249640,\
0.3988753791946258453471,0.1946227344887739574286,0.2391865177264060060569,\
0.4893511304026755825980,0.7907024739412412683848,0.0927649247006697985629,\
0.6771509587172231947605,0.1926598267972080835708,0.4219525417710163206486,\
0.8372545804484667897327,0.4380081794254953031498,0.7358790955224862040396,\
0.7764215257273850978592,0.4512883308374140978181,0.3761879989923791467454,\
0.4008885622012666738456,0.6407879869830552799215,0.0977409582360771744813,\
0.7661702973755802892342,0.5939433204542849953356,0.4013282299434615674194,\
0.0294444243265947341870,0.1800095863769710646807,0.6931213117261505463063,\
0.1229352709600845944271,0.0170729116595537758205,0.7729963838033769851776,\
0.3111634543825066989697,0.8062711862134785967271,0.3817009768423728632847,\
0.0843071952194427848282,0.6391670242169816829048,0.4456326503441452313581,\
0.8049131723565879914517,0.0841499582510354254827,0.5143869824676139401731,\
0.5323054257425473556609,0.1302316176753355037032,0.5514090290933710836185,\
0.0048661514920936704831,0.2726971620593832135171,0.6800878151345280953066,\
0.0194312774699979817772,0.6007410055835120665790,0.2225183567972019438308,\
0.2453107625419813642154,0.1193241474447570282802,0.1872090036522589262535,\
0.3328594328994332052218,0.8191678366228465346666,0.2808911379544120623386,\
0.7686206175384947547613,0.2814788293582466960352,0.4884768753384709505383,\
0.7677120055843160706388,0.5597752773423979588685,0.3843783063813486222671,\
0.4494348707705640433296,0.0073587607464321675918,0.4942920505581040457876,\
0.4519951388248303891793,0.6174156057066327862870,0.8120604613904897073340,\
0.4735912411780784370130,0.2877181408083371860762,0.2003085018506444991981,\
0.6454907592331077248460,0.7666485093752634094599,0.1898949607970919217781,\
0.5061380545505530514916,0.7764092440179690690627,0.0115521094721033057429,\
0.4792850082508480769050,0.6210525015048259378503,0.4790050323268763010631,\
0.1532840475926474099744,0.2543482295640571710926,0.8184182421341416047156,\
0.5847748710564846241766,0.8058612048242990155700,0.8373137227375435642784,\
0.3386253785349607747790,0.6858891905260645627251,0.2091622355697206059322,\
0.8059421776695899763965,0.6262645222993747928797,0.6791010706734159629860,\
0.3941090372936942864968,0.4883276667837411211259,0.8132971260929759971248,\
0.0289651993379718974975,0.1626808532406751051092,0.4029070726587401507501,\
0.0021650662494845369747,0.1800162812994652028475,0.4400180916539356279493,\
0.1964981391369581276152,0.5690809947427917236951,0.4225939313085426696226,\
0.7794896502659051096273,0.5732629547867681418794,0.4183441479008401797657,\
0.2295052748166268863361,0.4507387331252663553727,0.5770209539366986106757,\
0.7592252195553320648358,0.3752011769086914250160}

#define ZSOURCER {0.6045256052166223526001,0.9455216196365654468536,0.4476299257948994636536,\
0.8624908211641013622284,0.1751048639416694641113,0.2067177616991102695465,\
0.6848411662504076957703,0.1348653226159512996674,0.0069159921258687973022,\
0.1496290047653019428253,0.5665438110008835792542,0.4359452719800174236298,\
0.6547604538500308990479,0.3381605879403650760651,0.4259321158751845359802,\
0.3060420057736337184906,0.7704779822379350662231,0.7058695447631180286408,\
0.2373670237138867378235,0.8205849635414779186249,0.6789963841438293457031,\
0.5250809141434729099274,0.3359806565567851066589,0.8941988362930715084076,\
0.5461782198399305343628,0.7568633262999355792999,0.0259526828303933143616,\
0.3250150899402797222138,0.6072143577039241791,0.8756139636971056461334,\
0.2962085595354437828064,0.4229678637348115444183,0.4243144039064645767212,\
0.7620028969831764698029,0.3622896494343876838684,0.5658242437057197093964,\
0.6424440070986747741699,0.7580267959274351596832,0.2531452132388949394226,\
0.5266989110969007015228,0.2118590380996465682983,0.4779220153577625751495,\
0.1615962767973542213440,0.9168031658045947551727,0.5461866445839405059815,\
0.4686870560981333255768,0.7772213732823729515076,0.5871783248148858547211,\
0.5848031807690858840942,0.3139644009061157703400,0.3204141603782773017883,\
0.3331634956412017345429,0.2282590121030807495117,0.2750317254103720188141,\
0.4963629124686121940613,0.7453477247618138790131,0.1155001949518918991089,\
0.0626524840481579303741,0.0877018878236413002014,0.5507565210573375225067,\
0.2116370312869548797607,0.8335358710028231143951,0.4045845707878470420837,\
0.2880227542482316493988,0.1750094983726739883423,0.0051561561413109302521,\
0.3109287889674305915833,0.6602919283322989940643,0.9722995534539222717285,\
0.9826813959516584873200,0.0455837054178118705750,0.4096118300221860408783,\
0.7104403134435415267944,0.3917615194804966449738,0.5571686858311295509338,\
0.0565565521828830242157,0.1540721096098423004150,0.9109257892705500125885,\
0.5713340407237410545349,0.3488348922692239284515,0.8972954172641038894653,\
0.2973396372981369495392,0.1091936426237225532532,0.7626331257633864879608,\
0.6584706604480743408203,0.6996708759106695652008,0.6756794182583689689636,\
0.9004421546123921871185,0.6668148916214704513550,0.8518152837641537189484,\
0.8365677157416939735413,0.1291190306656062602997,0.6095453463494777679443,\
0.2412315667606890201569,0.4029275467619299888611,0.3019328541122376918793,\
0.1083198729902505874634,0.8456356939859688282013,0.9417407037690281867981,\
0.9083450469188392162323,0.1937242373824119567871,0.5318046086467802524567,\
0.8314437521621584892273,0.4952740012668073177338,0.7465563025325536727905,\
0.7102393140085041522980,0.5811418974772095680237,0.7035941029898822307587,\
0.3746570833027362823486,0.3394373343326151371002,0.6322447275742888450623,\
0.7636191300116479396820,0.6940386760979890823364,0.8735245508141815662384,\
0.3612738298252224922180,0.7933200257830321788788,0.4830590635538101196289,\
0.2469964125193655490875,0.5025922833010554313660,0.7430270477198064327240,\
0.6783937942236661911011,0.4903185223229229450226,0.709806025959551334381,\
0.3303662906400859355927,0.6815545372664928436279,0.0701365978457033634186,\
0.4745870968326926231384,0.8091805852018296718597,0.9447045121341943740845,\
0.5478458073921501636505,0.1216687532141804695129,0.9161847713403403759003,\
0.3045207932591438293457,0.6502694808878004550934,0.0987624628469347953796,\
0.8391053467057645320892,0.0328534897416830062866,0.3461971958167850971222,\
0.2801467711105942726135,0.5500544901005923748016,0.0729318000376224517822,\
0.0225322381593286991119,0.50267804320901632309,0.3478884599171578884125,\
0.4298669416457414627075,0.3537984383292496204376,0.0529730813577771186829,\
0.9533003675751388072968,0.1842019557952880859375,0.958756382111459970474,\
0.3245136169716715812683,0.0003973259590566158295,0.0972583871334791183472,\
0.4378789965994656086,0.3634226778522133827210,0.2685119728557765483856,\
0.2770298384130001068115,0.8854365111328661441803,0.5216628303751349449158,\
0.4979983693920075893,0.8733724001795053482056,0.4699407932348549365997,\
0.9364062966778874397278,0.1337622734718024730682,0.2712419554591178894043,\
0.1766990595497190952301,0.0543269468471407890320,0.8402757882140576839447,\
0.7507283594459295272827,0.3062269617803394794464,0.9195641661062836647034,\
0.1318263853900134563446,0.0826364941895008087158,0.8222710476256906986237,\
0.4441085970029234886169,0.9617503038607537746429,0.0283641982823610305786,\
0.1431905967183411121368,0.3793597565963864326477,0.6144003230147063732147,\
0.2128270715475082397461,0.4704488315619528293610,0.2076055286452174186707,\
0.7435979112051427364349,0.3391801547259092330933,0.2479635034687817096710,\
0.6721735307946801185608,0.9013197491876780986786,0.2140864841639995574951,\
0.8460668534971773624420,0.1650043567642569541931,0.4003686285577714443207,\
0.5522825215011835098267,0.0638249483890831470490,0.6903966935351490974426,\
0.8547787251882255077362,0.0291904583573341369629,0.5434663915075361728668,\
0.6236743135377764701843,0.2417052476666867733002}

#define ZSOURCEI {0.5503273960202932357788,0.6906704087741672992706,0.9835249418392777442932,\
0.8285484607331454753876,0.2062614001333713531494,0.1944643096067011356354,\
0.4367609983310103416443,0.8090620837174355983734,0.8818644303828477859497,\
0.7404803228564560413361,0.7542522149160504341126,0.9921960639767348766327,\
0.9886121451854705810547,0.0113218077458441257477,0.9367801276966929435730,\
0.3874237253330647945404,0.2886805813759565353394,0.567788839805871248245,\
0.7295644441619515419006,0.0303032915107905864716,0.2795897088944911956787,\
0.7047131718136370182037,0.7442112853750586509705,0.8920237845741212368012,\
0.1081438604742288589478,0.8751525697298347949982,0.9068333031609654426575,\
0.2166852983646094799042,0.4824190363287925720215,0.7766945236362516880035,\
0.4510916722938418388367,0.1300636469386518001556,0.5505470838397741317749,\
0.6936193336732685565949,0.1749099576845765113831,0.8636093880049884319305,\
0.2150467522442340850830,0.1886725709773600101471,0.1796098565682768821716,\
0.4374312213622033596039,0.8514516223222017288208,0.7381969136185944080353,\
0.8102188156917691230774,0.1460137623362243175507,0.8999849110841751098633,\
0.4043733575381338596344,0.0156995235010981559753,0.6904196902178227901459,\
0.2990311514586210250855,0.1383218024857342243195,0.8478512773290276527405,\
0.3007262717001140117645,0.229154746979475021362,0.8078110129572451114655,\
0.3176332255825400352478,0.6924462593160569667816,0.1364154014736413955689,\
0.5433279541321098804474,0.3276594849303364753723,0.2006831648759543895721,\
0.5037304237484931945801,0.4962565028108656406403,0.8996161324903368949890,\
0.9357709079049527645111,0.3390339072793722152710,0.6029155333526432514191,\
0.4153500730171799659729,0.3041478390805423259735,0.8489827848970890045166,\
0.4482063786126673221588,0.0903797810897231101990,0.7382151386700570583344,\
0.2669597584754228591919,0.8226196658797562122345,0.3985779182985424995422,\
0.9789295899681746959686,0.3041231036186218261719,0.0663515278138220310211,\
0.6667758254334330558777,0.7548807277344167232513,0.1922533493489027023315,\
0.7942791883833706378937,0.5580398896709084510803,0.2016023616306483745575,\
0.787146832793951034546,0.0955459238030016422272,0.6623697867617011070252,\
0.864868474658578634262,0.7013061288744211196899,0.8015053984709084033966,\
0.9135685982182621955872,0.6317234965972602367401,0.9346773549914360046387,\
0.9157753759063780307770,0.0510348035022616386414,0.4329969524405896663666,\
0.9721843507140874862671,0.8001508046872913837433,0.8452261472120881080627,\
0.0610524858348071575165,0.8168097324669361114502,0.2101262793876230716705,\
0.3055453812703490257263,0.9465212575159966945648,0.9269728232175111770630,\
0.7737778765149414539337,0.5893978821113705635071,0.2377697187475860118866,\
0.5269544571638107299805,0.0077543654479086399078,0.8311711428686976432800,\
0.0268517597578465938568,0.2591186594218015670776,0.4641277943737804889679,\
0.6098861405625939369202,0.0656952331773936748505,0.6466812007129192352295,\
0.1018534512259066104889,0.2742705782875418663025,0.8162728524766862392426,\
0.3357750270515680313110,0.4765891996212303638458,0.8440040023997426033020,\
0.1785074654035270214081,0.5855625644326210021973,0.8426241897977888584137,\
0.7058847947046160697937,0.7396617024205625057221,0.9751448985189199447632,\
0.7606669445522129535675,0.8236690396443009376526,0.8889620001427829265595,\
0.7960178293287754058838,0.3052428201772272586823,0.6803312664851546287537,\
0.6412069997750222682953,0.0988248009234666824341,0.4654508423991501331329,\
0.6714970665052533149719,0.5131103205494582653046,0.8631567060947418212891,\
0.8328299173153936862946,0.1687975851818919181824,0.2961277081631124019623,\
0.2591485660523176193237,0.1700844173319637775421,0.9718958893790841102600,\
0.0695185582153499126434,0.4696230851113796234131,0.9544191421009600162506,\
0.3679352095350623130798,0.2973918146453797817230,0.0415310803800821304321,\
0.4892336544580757617950,0.5171590568497776985169,0.3534862431697547435761,\
0.2354387864470481872559,0.6779259913600981235504,0.3834532154724001884460,\
0.3174350797198712825775,0.3418120350688695907593,0.0535557498224079608917,\
0.9285596096888184547424,0.3862650538794696331024,0.4328473098576068878174,\
0.1581165478564798831940,0.7887120461091399192810,0.7448797873221337795258,\
0.5185996759682893753052,0.8651678604073822498322,0.1524438308551907539368,\
0.2392775672487914562225,0.5761575847864151000977,0.7395762302912771701813,\
0.0583172617480158805847,0.6962534948252141475678,0.4206145536154508590698,\
0.0281158541329205036163,0.8313249954953789710999,0.2333360086195170879364,\
0.8865877203643321990967,0.3746785433031618595123,0.87671328987926244736,\
0.4027077830396592617035,0.2890332732349634170532,0.8538430598564445972443,\
0.5499771209433674812317,0.5128610017709434032440,0.6321087554097175598145,\
0.4165538274683058261871,0.3217771751806139945984,0.9717370062135159969330,\
0.5348322447389364242554,0.3416590173728764057159,0.9565287167206406593323,\
0.9951003189198672771454,0.3422884084284305572510,0.7870580093003809452057,\
0.9234123295173048973084,0.5238970420323312282562}

#define ZRESULTR {0.6566347140259699566300,1.0119999258966314581443,0.6596019011837132017817,\
1.035407544941025825835,0.1779303602523068794650,0.2091417769467268095163,\
0.6938478808740486947215,0.1809168200637071011183,0.0097840077120305499192,\
0.1918418803766589464388,0.6967642148886226127758,0.6477398327340490036264,\
0.9315995708552796683577,0.3317736774434180135884,0.6081114651603225507159,\
0.3241823207263323514127,0.7257014354377283593678,0.7561000009288112444494,\
0.3005492023050818084506,0.7318806897852137005600,0.6527186268049437467553,\
0.6309941597264083767982,0.4252885469799541073854,1.1110399216338266992210,\
0.5224655834751933403126,0.9668090801088078389824,0.0373711557740689717666,\
0.3268489749847858782950,0.6382749343202905878414,1.0114485987268988509413,\
0.3221010444660392657568,0.4139453304596071303578,0.4756810141068628650096,\
0.8632093598097250186640,0.3598514339778784987267,0.7487720850314417697646,\
0.6130614254242318095223,0.6997626019564747723578,0.2545007621033356648432,\
0.5515473173800672368472,0.2912178978332317091926,0.5910474830807833646063,\
0.2166565482354273763921,0.8021363255207357711996,0.7443835374940948046429,\
0.4891530673136452178618,0.7013877718782099979222,0.6913869813942569164667,\
0.5769011420640627330059,0.3117908008696873567445,0.4351103756992900639666,\
0.3419338661078391572445,0.2322493315296763338740,0.3651122336184794425762,\
0.5004568464347787237756,0.8474278924029616799629,0.1163175220516309976704,\
0.0720827231471598273149,0.0923335564898466049089,0.5339057146859005342776,\
0.2372798723378120866467,0.8333578948329619651148,0.5639606188473457182298,\
0.4177713004682119257716,0.1842205910422827219719,0.0061220134095790416234,\
0.3327145852908883205679,0.6419359463626251871560,1.1422474153376851457864,\
0.9169649828841031080629,0.0457541584695274616834,0.5117881770849980194171,\
0.6755451518212014505593,0.5184569836246168961225,0.5713468012823553765500,\
0.0858443570774837100279,0.1606151108412635364342,0.7918113937347260877786,\
0.6654818631286439911676,0.4439038705567253662032,0.796132686757749730155,\
0.3903563868552101800979,0.1263898622508018709798,0.7049140832202889228597,\
0.8114695967676066601371,0.6469075512356741164410,0.7677157469479103379939,\
1.0953970513593642710504,0.7769182781192301989748,1.0073965025007358686793,\
1.074286510426218699266,0.1553189729796884688273,0.8413108822720302137910,\
0.3462739066818524835689,0.3926238690106399475965,0.3256804935966552405624,\
0.1633497671324356526057,1.0010270500405602511762,1.115022351982163151263,\
0.7899569005544465616353,0.2603865455411881191239,0.5183255731419573741903,\
0.7736654652779521024186,0.7045488355155032911270,0.99239017570392618062,\
0.8571418992433421646382,0.6471261632164159172120,0.6653365916658987577748,\
0.4179492416945764787783,0.332966594116362202271,0.8071129279142643664358,\
0.6917895244691119049918,0.6612409505512693019824,0.8506578773411223037826,\
0.4212670370210502279740,0.7142246190696375229834,0.5650468142706680518828,\
0.2457619298195089230230,0.4999304697490009052885,0.9146990697266257352993,\
0.6632530384013611834959,0.5254071357713419043733,0.8979087718767884140902,\
0.3295715941858761155459,0.7411311982358101957402,0.0964650394595463894776,\
0.5756260203046842383046,0.9308880528862794045963,1.2271094550000687384284,\
0.6789423000457328605251,0.1649198200195263752654,1.1279258179884905644030,\
0.3999539922775662836862,0.6338241429246500580064,0.1223148225900566599123,\
0.9023144865193905017620,0.0330081109061416202999,0.3767477211449618557104,\
0.3412118905344592723061,0.5930700069420078435201,0.1017393430189639513817,\
0.0308061153410014963716,0.4886538358989525598908,0.3559707023880692156048,\
0.4308223854061962176942,0.3514869377238818426434,0.0799867738322445898103,\
0.8173018105145738454453,0.2037338143062503714731,1.220430983869785990237,\
0.3406746275228044185113,0.0004150259547877954485,0.0971888856349881896657,\
0.4757842207231965381276,0.4040809859598182285367,0.2820450997896822298294,\
0.2811152693325764118093,0.9590128703774639662427,0.5354093557700149164091,\
0.5019368627578308927895,0.8117140104249528365088,0.4534830656186849551226,\
1.1783423931120406980000,0.1434370411700725822524,0.2934216038065708409555,\
0.1779829127631718521663,0.0720832823745556211525,0.9611918663155849529289,\
0.7759794971968927423944,0.4215038017355943744668,0.8045968908805133379403,\
0.1352257439826550500239,0.0966259862726158991197,0.9423768067086430999524,\
0.4303839309127981405112,1.027158469056514755735,0.0309063123957022088673,\
0.1427581856076631239283,0.5058338353137836751472,0.5922330662524728506213,\
0.2998212988294082781415,0.4854774490519005447631,0.2905366689284186176856,\
0.732577252768074504985,0.3467085924376158700966,0.3404646689762517719480,\
0.7192597601031739396049,0.8895525359433824608146,0.2563314638119464916599,\
0.8145777458167494655683,0.1728338655335915907685,0.5887205934900180404057,\
0.6014718010439381590260,0.0675406202372636349507,0.9510839296787396701660,\
1.1598095667324348490013,0.0309128254938883482994,0.6857099135308569737290,\
0.8512200678266018671891,0.2729650321569278004219}

#define ZRESULTI {0.4759980266175199981049,0.4371792356294723624899,1.0366401767050017479477,\
0.6028332456001923578270,0.2045505325550055208961,0.1915259687562470281019,\
0.3491380267554807237396,0.8920876814407183719169,1.0006703458507313353465,\
0.8009779429459989996687,0.6984902194099197325627,1.0544026495724472258786,\
0.9182841727572422785286,0.0106808422200693302340,0.9834445059055472171394,\
0.3787326350421501008903,0.2100400056445083096790,0.4557093767576786413898,\
0.7737087506882367460293,0.0206637462688268880306,0.2204234493680024276063,\
0.6615160486898620240126,0.7692763584553293787494,0.6356101396181920160089,\
0.0925908774129100275996,0.7206114133477932170990,1.0359844944992535609174,\
0.2069515918997265613299,0.4117290503525293243747,0.5490423106381259188424,\
0.4462283131040214456675,0.1189364264093275003198,0.5274577925657699672968,\
0.5430180765717186330832,0.1643914008870697718301,0.8230721066766158999783,\
0.1735038050714417801057,0.1378272158996049767676,0.1748220246567987745667,\
0.3903220669843952550515,0.936703269190418574830,0.7166597754518847507299,\
0.8900704241537943373075,0.0891449760436722887791,0.8771518805722777756273,\
0.3706792570421439947381,0.0111920996603491820776,0.6215444290094976897976,\
0.2530709869257740662896,0.1319801016143227201383,0.9046350616526124266414,\
0.2884930138703660218447,0.2251695646636414915864,0.8648081988694793498240,\
0.2840216379380148814526,0.5504953762822683005496,0.1359271700042656016993,\
0.5693382736493431961478,0.3322720353016644923017,0.1721580834994098363477,\
0.5135850315563981194345,0.3474773880755230304196,0.9431362964718456032287,\
1.0340232262721140710227,0.3402877573217258366789,0.6401040473330621427550,\
0.4069022009136239459437,0.2439407776749255851723,0.5378842266979906305835,\
0.2570716586141951753852,0.0904088654517940515376,0.7403475521247256940782,\
0.2047878426979200527924,0.8489939536581485590716,0.3473238625280567482001,\
1.1411188764290771668897,0.3051746072580045487932,0.0407043050782743276450,\
0.6033725923116708411698,0.778737542643346047910,0.1206535237380119696127,\
0.8418336511001852651148,0.5839585555917582437857,0.1467518266954731531726,\
0.6888901126606848945855,0.0732090771366951525989,0.5554652901202962178573,\
0.6068461403975041745795,0.5973804827482247503667,0.5862495346519734917834,\
0.7008734442762630800772,0.6689719175986947874435,0.8829098191147302099324,\
1.0188712228965588479923,0.0469681660587412258545,0.4264494425604897775983,\
1.1260897634779567511032,0.5891751058811135477455,0.5586811292942333029288,\
0.0375737549548666310839,0.8936786828452066844264,0.1824421274677656690244,\
0.2090978327687162685589,0.9628255596340984379111,0.7821471108810679195855,\
0.6470050596557553879151,0.5216627363302938080736,0.1830177712067865836154,\
0.5134143514131775942744,0.0073119913675850425894,0.7504222430574429836270,\
0.0193983766100578602920,0.2014128332431188439511,0.3088455785813677967333,\
0.6065483134448432789299,0.0461172484518394959485,0.6134456837548584173803,\
0.0989331667688019139595,0.2433781622039619951803,0.6701373782390742661619,\
0.2663685035487164953771,0.4365368071405912875349,0.7189236163164304249662,\
0.1697526069685433847134,0.4811811372286406429666,0.9436115675726329810047,\
0.6813279536427474525340,0.5582673535726633273768,0.6663831331574520122629,\
0.7137987696438253815146,0.9132123041060544732517,0.6154027043735471602659,\
0.8421707385350217789366,0.2467394118703030714279,0.730464243452961903280,\
0.4583747264016979627854,0.0989323235351602520149,0.4538168380708768601117,\
0.6949204434222109316721,0.4568731305870791792323,0.9718116503334458533558,\
0.9322636874728698064274,0.1486199865445305412504,0.2824746711136658094965,\
0.238217162606873950059,0.1603203534786354911290,1.130704398714823533112,\
0.0402833511895827542371,0.4788366747059483730098,0.6354755115001236021044,\
0.3566529249056448747091,0.3017948657011057522759,0.0413466935121344983384,\
0.46096369056612357,0.5052181131344314346521,0.3479618653266752237308,\
0.2285599720872606155364,0.462725396526868226754,0.3406579403750831791520,\
0.2835867580422753442271,0.2238269615848648141920,0.0477728736811990767341,\
0.6329115684248395323763,0.3924052442709091148565,0.4301664447715317640686,\
0.1563039559206648165812,0.8717772653208039068673,0.544280842419675670030,\
0.3964232571280063566199,0.9317498908981691752018,0.0927647199866874355711,\
0.239471404370552171104,0.6064908073717841796579,0.5504808053886728336224,\
0.0526899922619719976447,0.4312873750429307428966,0.4329527886793243518504,\
0.0278317754230633894463,0.8642909834572990446233,0.1923982024967207382638,\
0.9846585214795218199413,0.3418444780294159768275,0.9720887284222768931485,\
0.3044849414953779143112,0.2763773261322472474255,0.9320336608375792142311,\
0.4523656548286881795562,0.3324058771805019629753,0.6596413052835798929152,\
0.2842028663251400799616,0.3229125187951548126009,1.0425270197833373941876,\
0.4773378821453879150560,0.3476356752155591589570,0.8551943809979846156111,\
0.7664315470559724952082,0.3488628182805697530711,0.7453969031814248191736,\
0.8607289142164601392082,0.5322582746397167552388}





void dsinsTest() {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out;
	int i;

	for (i=0;i<200;i++){
		out=dsins(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<3e-16);
	}
}

void zsinsTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=DoubleComplex(inR[i],inI[i]);
		out=zsins(in);
		assert(( (fabs(zreals(out)-resR[i]))/(fabs(zreals(out))) )<3e-15);	
		assert(( (fabs(zimags(out)-resI[i]))/(fabs(zimags(out))) )<3e-15);			
	}
}

void dsinaTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out[200];
	int i;

	dsina(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<1e-16);
	}
}

void zsinaTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex *in,out[200];
	int i;


	in=DoubleComplexMatrix(inR,inI,200);
	zsina(in,200,out);

	for (i=0;i<200;i++){
		assert(( (fabs(zreals(out[i])-resR[i]))/(fabs(zreals(out[i]))) )<3e-15);	
		assert(( (fabs(zimags(out[i])-resI[i]))/(fabs(zimags(out[i]))) )<3e-15);			
	}
}

int testSin() {
  printf("\n>>>> Double Sine Tests\n");
  dsinsTest();
  zsinsTest();
  dsinaTest();
  zsinaTest();
  return 0;
}

int main(void) {
  assert(testSin() == 0);
  return 0;
}
