/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */


#include "testSin.h"

#define SOURCE {0.7062616096809506416321f,0.4090520101599395275116f,0.3011248558759689331055f,\
0.1880126395262777805328f,0.1796709178015589714050f,0.2828889950178563594818f,\
0.7232380937784910202026f,0.7360379849560558795929f,0.1852612206712365150452f,\
0.7703790138475596904755f,0.1914967410266399383545f,0.7521587223745882511139f,\
0.6205883463844656944275f,0.2807604051195085048676f,0.2289868686348199844360f,\
0.5049233403988182544708f,0.8354099662974476814270f,0.8174716415815055370331f,\
0.0030740275979042053223f,0.3677616142667829990387f,0.8278525872156023979187f,\
0.72754097869619727135f,0.5323124285787343978882f,0.9267726917751133441925f,\
0.9542504185810685157776f,0.3162104780785739421845f,0.5789009965956211090088f,\
0.6881225542165338993073f,0.3714061146602034568787f,0.1705444059334695339203f,\
0.1954363007098436355591f,0.978800852317363023758f,0.9300233917310833930969f,\
0.5357720064930617809296f,0.3947123587131500244141f,0.1344871171750128269196f,\
0.7380615202710032463074f,0.588114650454372167587f,0.9113173168152570724487f,\
0.5682763461954891681671f,0.1127616921439766883850f,0.9478473584167659282684f,\
0.5237770043313503265381f,0.8140139640308916568756f,0.1400952627882361412048f,\
0.2763446993194520473480f,0.9059953633695840835571f,0.1379901585169136524200f,\
0.5603838684037327766419f,0.3008610638789832592011f,0.4767417535185813904f,\
0.8127435916103422641754f,0.1988414181396365165710f,0.1107953130267560482025f,\
0.2159351315349340438843f,0.6467244853265583515167f,0.6597879612818360328674f,\
0.0691898013465106487274f,0.9164751060307025909424f,0.8635670826770365238190f,\
0.5032854294404387474060f,0.1832137755118310451508f,0.8403698671609163284302f,\
0.9247214836068451404572f,0.6229452537372708320618f,0.2773811477236449718475f,\
0.2479109913110733032227f,0.3891948559321463108063f,0.0436578569933772087097f,\
0.8132526441477239131928f,0.7686451207846403121948f,0.4041520212776958942413f,\
0.8579940209165215492249f,0.6993723283521831035614f,0.0828925184905529022217f,\
0.9201254160143435001373f,0.5200281282886862754822f,0.9351884997449815273285f,\
0.8825624976307153701782f,0.2245844271965324878693f,0.2153332801535725593567f,\
0.4327089670114219188690f,0.5800157263875007629395f,0.8876141034997999668121f,\
0.5258982880041003227234f,0.859640696551650762558f,0.7337234076112508773804f,\
0.7134532411582767963409f,0.1087165409699082374573f,0.8477638359181582927704f,\
0.6594733335077762603760f,0.7916418449021875858307f,0.6067967480048537254334f,\
0.4102901122532784938812f,0.1958728153258562088013f,0.241527963895350694656f,\
0.5113455550745129585266f,0.9119556057266891002655f,0.0928984880447387695313f,\
0.7438839026726782321930f,0.1938720373436808586121f,0.4355978979729115962982f,\
0.9922429900616407394409f,0.4533818070776760578156f,0.8269640663638710975647f,\
0.8889675955288112163544f,0.4682085178792476654053f,0.3856786251999437808991f,\
0.4124865522608160972595f,0.6955242282710969448090f,0.0978972557932138442993f,\
0.8728604433126747608185f,0.6359515609219670295715f,0.4129665228538215160370f,\
0.0294486805796623229980f,0.1809961968101561069489f,0.7658103061839938163757f,\
0.1232470511458814144135f,0.0170737411826848983765f,0.8835507561452686786652f,\
0.3164170170202851295471f,0.9378212536685168743134f,0.3916359134018421173096f,\
0.0844073877669870853424f,0.6934146797284483909607f,0.4618808380328118801117f,\
0.9355291295796632766724f,0.0842495900578796863556f,0.5402926551178097724915f,\
0.5613215523771941661835f,0.1306025832891464233398f,0.5840523042716085910797f,\
0.0048661706969141960144f,0.2761953338049352169037f,0.7478824090212583541870f,\
0.0194325004704296588898f,0.6444276878610253334045f,0.2243968318216502666473f,\
0.2478402368724346160889f,0.1196091384626924991608f,0.1883201440796256065369f,\
0.3393343067727982997894f,0.959958622232079505920f,0.2847225037403404712677f,\
0.8766820700839161872864f,0.2853349032811820507050f,0.5103433504700660705566f,\
0.8752629184164106845856f,0.5941145820543169975281f,0.3945342986844480037689f,\
0.4661326166242361068726f,0.0073588271625339984894f,0.5170202488079667091370f,\
0.4690007264725863933563f,0.6654530800879001617432f,0.9476742581464350223541f,\
0.4933638339862227439880f,0.2918433747254312038422f,0.2016727942973375320435f,\
0.7016656589694321155548f,0.8736049132421612739563f,0.191055159550160169601f,\
0.5307010114192962646484f,0.8889481076039373874664f,0.0115523664280772209167f,\
0.4998398735187947750092f,0.6700848620384931564331f,0.4995208983309566974640f,\
0.1538907447829842567444f,0.2571737091057002544403f,0.9586529098451137542725f,\
0.6246025026775896549225f,0.9371285131201148033142f,0.9923511571250855922699f,\
0.3454555813223123550415f,0.7558249053545296192169f,0.2107181670144200325012f,\
0.9372652801685035228729f,0.6767524704337120056152f,0.7465373151935636997223f,\
0.4050982249900698661804f,0.5101723610423505306244f,0.9497965183109045028687f,\
0.0289692510850727558136f,0.1634070957079529762268f,0.4146909262053668498993f,\
0.0021650679409503936768f,0.1810030029155313968658f,0.4556188201531767845154f,\
0.1977851442061364650726f,0.6053877938538789749146f,0.4363054675050079822540f,\
0.8938506888225674629211f,0.6104825991205871105194f,0.4316215068101882934570f,\
0.2315693595446646213532f,0.4675927339121699333191f,0.6150764389894902706146f,\
0.8621218334883451461792f,0.3846137975342571735382f}

#define RESULT {0.6489941700631755017170f,0.3977397277804613495711f,0.2965946353370927379700f,\
0.1869069269006927436205f,0.1787057982923107302131f,0.2791309758033572174796f,\
0.6618156282674139134770f,0.6713568034120557248556f,0.1842032905163836498108f,\
0.6964072867055017823645f,0.1903284889107588750967f,0.6832166836832923584311f,\
0.5815139023939676077291f,0.2770863600724933761832f,0.2269909547378782532778f,\
0.4837403483762576783533f,0.7415716096535567292136f,0.7294185948731235491493f,\
0.0030740227564945614772f,0.3595276195652636896938f,0.7364804339477919459256f,\
0.6650352209120763413708f,0.5075271675293236972593f,0.7996863750649069180199f,\
0.8158805463618925557512f,0.3109671621400240670852f,0.5471043307230858410151f,\
0.6350880886600825947497f,0.3629260331962892438540f,0.1697188821645874701183f,\
0.1941945483009222261916f,0.8298288212470000813070f,0.8016339250362096713332f,\
0.5105050203992042012757f,0.3845426809733389905688f,0.1340820770536885198077f,\
0.6728551393063956220786f,0.5547934214048261258867f,0.7903115520300768581663f,\
0.5381801020151927295032f,0.1125228794588504499519f,0.8121614659213718390163f,\
0.5001543426683193738214f,0.7270489540313778142888f,0.1396374447476722568950f,\
0.2728408635666067505454f,0.787039586876701835472f,0.1375526569581922986529f,\
0.5315113932434574195440f,0.2963427027488344522865f,0.4588866814078613742822f,\
0.7261761481530248918404f,0.1975337103519642922844f,0.1105687722679299794804f,\
0.2142609363196769090010f,0.6025755797169196625873f,0.6129493292515678648513f,\
0.0691346099927565571619f,0.7934612300206389523538f,0.7601650349312217835873f,\
0.4823061815340158875465f,0.1821904962108664982612f,0.7448899416114136418088f,\
0.7984531114259775241848f,0.5834297155392762501691f,0.2738378415422391687351f,\
0.2453793544289556705085f,0.3794436069308826930957f,0.0436439896074229186085f,\
0.7265260320935078564020f,0.6951619177333813182074f,0.3932392395246541161313f,\
0.756532263098035340221f,0.6437374906114369244037f,0.0827976230060826490220f,\
0.7956775933285428203945f,0.4969045479155810296490f,0.8047109984386738856799f,\
0.7723690449233312493860f,0.2227012449582090047873f,0.2136730232885993008285f,\
0.4193316280451939714880f,0.5480370912598671040428f,0.7755678252599553790248f,\
0.5019901124659599256361f,0.7576080909498315030248f,0.6696395939777050054786f,\
0.6544486857456611739181f,0.1085025088408962251618f,0.7498026974031274383137f,\
0.6127007045227848003322f,0.7115079193085073194780f,0.5702389863986391249640f,\
0.3988753791946258453471f,0.1946227344887739574286f,0.2391865177264060060569f,\
0.4893511304026755825980f,0.7907024739412412683848f,0.0927649247006697985629f,\
0.6771509587172231947605f,0.1926598267972080835708f,0.4219525417710163206486f,\
0.8372545804484667897327f,0.4380081794254953031498f,0.7358790955224862040396f,\
0.7764215257273850978592f,0.4512883308374140978181f,0.3761879989923791467454f,\
0.4008885622012666738456f,0.6407879869830552799215f,0.0977409582360771744813f,\
0.7661702973755802892342f,0.5939433204542849953356f,0.4013282299434615674194f,\
0.0294444243265947341870f,0.1800095863769710646807f,0.6931213117261505463063f,\
0.1229352709600845944271f,0.0170729116595537758205f,0.7729963838033769851776f,\
0.3111634543825066989697f,0.8062711862134785967271f,0.3817009768423728632847f,\
0.0843071952194427848282f,0.6391670242169816829048f,0.4456326503441452313581f,\
0.8049131723565879914517f,0.0841499582510354254827f,0.5143869824676139401731f,\
0.5323054257425473556609f,0.1302316176753355037032f,0.5514090290933710836185f,\
0.0048661514920936704831f,0.2726971620593832135171f,0.6800878151345280953066f,\
0.0194312774699979817772f,0.6007410055835120665790f,0.2225183567972019438308f,\
0.2453107625419813642154f,0.1193241474447570282802f,0.1872090036522589262535f,\
0.3328594328994332052218f,0.8191678366228465346666f,0.2808911379544120623386f,\
0.7686206175384947547613f,0.2814788293582466960352f,0.4884768753384709505383f,\
0.7677120055843160706388f,0.5597752773423979588685f,0.3843783063813486222671f,\
0.4494348707705640433296f,0.0073587607464321675918f,0.4942920505581040457876f,\
0.4519951388248303891793f,0.6174156057066327862870f,0.8120604613904897073340f,\
0.4735912411780784370130f,0.2877181408083371860762f,0.2003085018506444991981f,\
0.6454907592331077248460f,0.7666485093752634094599f,0.1898949607970919217781f,\
0.5061380545505530514916f,0.7764092440179690690627f,0.0115521094721033057429f,\
0.4792850082508480769050f,0.6210525015048259378503f,0.4790050323268763010631f,\
0.1532840475926474099744f,0.2543482295640571710926f,0.8184182421341416047156f,\
0.5847748710564846241766f,0.8058612048242990155700f,0.8373137227375435642784f,\
0.3386253785349607747790f,0.6858891905260645627251f,0.2091622355697206059322f,\
0.8059421776695899763965f,0.6262645222993747928797f,0.6791010706734159629860f,\
0.3941090372936942864968f,0.4883276667837411211259f,0.8132971260929759971248f,\
0.0289651993379718974975f,0.1626808532406751051092f,0.4029070726587401507501f,\
0.0021650662494845369747f,0.1800162812994652028475f,0.4400180916539356279493f,\
0.1964981391369581276152f,0.5690809947427917236951f,0.4225939313085426696226f,\
0.7794896502659051096273f,0.5732629547867681418794f,0.4183441479008401797657f,\
0.2295052748166268863361f,0.4507387331252663553727f,0.5770209539366986106757f,\
0.7592252195553320648358f,0.3752011769086914250160f}

#define CSOURCER {0.6045256052166223526001f,0.9455216196365654468536f,0.4476299257948994636536f,\
0.8624908211641013622284f,0.1751048639416694641113f,0.2067177616991102695465f,\
0.6848411662504076957703f,0.1348653226159512996674f,0.0069159921258687973022f,\
0.1496290047653019428253f,0.5665438110008835792542f,0.4359452719800174236298f,\
0.6547604538500308990479f,0.3381605879403650760651f,0.4259321158751845359802f,\
0.3060420057736337184906f,0.7704779822379350662231f,0.7058695447631180286408f,\
0.2373670237138867378235f,0.8205849635414779186249f,0.6789963841438293457031f,\
0.5250809141434729099274f,0.3359806565567851066589f,0.8941988362930715084076f,\
0.5461782198399305343628f,0.7568633262999355792999f,0.0259526828303933143616f,\
0.3250150899402797222138f,0.6072143577039241791f,0.8756139636971056461334f,\
0.2962085595354437828064f,0.4229678637348115444183f,0.4243144039064645767212f,\
0.7620028969831764698029f,0.3622896494343876838684f,0.5658242437057197093964f,\
0.6424440070986747741699f,0.7580267959274351596832f,0.2531452132388949394226f,\
0.5266989110969007015228f,0.2118590380996465682983f,0.4779220153577625751495f,\
0.1615962767973542213440f,0.9168031658045947551727f,0.5461866445839405059815f,\
0.4686870560981333255768f,0.7772213732823729515076f,0.5871783248148858547211f,\
0.5848031807690858840942f,0.3139644009061157703400f,0.3204141603782773017883f,\
0.3331634956412017345429f,0.2282590121030807495117f,0.2750317254103720188141f,\
0.4963629124686121940613f,0.7453477247618138790131f,0.1155001949518918991089f,\
0.0626524840481579303741f,0.0877018878236413002014f,0.5507565210573375225067f,\
0.2116370312869548797607f,0.8335358710028231143951f,0.4045845707878470420837f,\
0.2880227542482316493988f,0.1750094983726739883423f,0.0051561561413109302521f,\
0.3109287889674305915833f,0.6602919283322989940643f,0.9722995534539222717285f,\
0.9826813959516584873200f,0.0455837054178118705750f,0.4096118300221860408783f,\
0.7104403134435415267944f,0.3917615194804966449738f,0.5571686858311295509338f,\
0.0565565521828830242157f,0.1540721096098423004150f,0.9109257892705500125885f,\
0.5713340407237410545349f,0.3488348922692239284515f,0.8972954172641038894653f,\
0.2973396372981369495392f,0.1091936426237225532532f,0.7626331257633864879608f,\
0.6584706604480743408203f,0.6996708759106695652008f,0.6756794182583689689636f,\
0.9004421546123921871185f,0.6668148916214704513550f,0.8518152837641537189484f,\
0.8365677157416939735413f,0.1291190306656062602997f,0.6095453463494777679443f,\
0.2412315667606890201569f,0.4029275467619299888611f,0.3019328541122376918793f,\
0.1083198729902505874634f,0.8456356939859688282013f,0.9417407037690281867981f,\
0.9083450469188392162323f,0.1937242373824119567871f,0.5318046086467802524567f,\
0.8314437521621584892273f,0.4952740012668073177338f,0.7465563025325536727905f,\
0.7102393140085041522980f,0.5811418974772095680237f,0.7035941029898822307587f,\
0.3746570833027362823486f,0.3394373343326151371002f,0.6322447275742888450623f,\
0.7636191300116479396820f,0.6940386760979890823364f,0.8735245508141815662384f,\
0.3612738298252224922180f,0.7933200257830321788788f,0.4830590635538101196289f,\
0.2469964125193655490875f,0.5025922833010554313660f,0.7430270477198064327240f,\
0.6783937942236661911011f,0.4903185223229229450226f,0.709806025959551334381f,\
0.3303662906400859355927f,0.6815545372664928436279f,0.0701365978457033634186f,\
0.4745870968326926231384f,0.8091805852018296718597f,0.9447045121341943740845f,\
0.5478458073921501636505f,0.1216687532141804695129f,0.9161847713403403759003f,\
0.3045207932591438293457f,0.6502694808878004550934f,0.0987624628469347953796f,\
0.8391053467057645320892f,0.0328534897416830062866f,0.3461971958167850971222f,\
0.2801467711105942726135f,0.5500544901005923748016f,0.0729318000376224517822f,\
0.0225322381593286991119f,0.50267804320901632309f,0.3478884599171578884125f,\
0.4298669416457414627075f,0.3537984383292496204376f,0.0529730813577771186829f,\
0.9533003675751388072968f,0.1842019557952880859375f,0.958756382111459970474f,\
0.3245136169716715812683f,0.0003973259590566158295f,0.0972583871334791183472f,\
0.4378789965994656086f,0.3634226778522133827210f,0.2685119728557765483856f,\
0.2770298384130001068115f,0.8854365111328661441803f,0.5216628303751349449158f,\
0.4979983693920075893f,0.8733724001795053482056f,0.4699407932348549365997f,\
0.9364062966778874397278f,0.1337622734718024730682f,0.2712419554591178894043f,\
0.1766990595497190952301f,0.0543269468471407890320f,0.8402757882140576839447f,\
0.7507283594459295272827f,0.3062269617803394794464f,0.9195641661062836647034f,\
0.1318263853900134563446f,0.0826364941895008087158f,0.8222710476256906986237f,\
0.4441085970029234886169f,0.9617503038607537746429f,0.0283641982823610305786f,\
0.1431905967183411121368f,0.3793597565963864326477f,0.6144003230147063732147f,\
0.2128270715475082397461f,0.4704488315619528293610f,0.2076055286452174186707f,\
0.7435979112051427364349f,0.3391801547259092330933f,0.2479635034687817096710f,\
0.6721735307946801185608f,0.9013197491876780986786f,0.2140864841639995574951f,\
0.8460668534971773624420f,0.1650043567642569541931f,0.4003686285577714443207f,\
0.5522825215011835098267f,0.0638249483890831470490f,0.6903966935351490974426f,\
0.8547787251882255077362f,0.0291904583573341369629f,0.5434663915075361728668f,\
0.6236743135377764701843f,0.2417052476666867733002f}

#define CSOURCEI {0.5503273960202932357788f,0.6906704087741672992706f,0.9835249418392777442932f,\
0.8285484607331454753876f,0.2062614001333713531494f,0.1944643096067011356354f,\
0.4367609983310103416443f,0.8090620837174355983734f,0.8818644303828477859497f,\
0.7404803228564560413361f,0.7542522149160504341126f,0.9921960639767348766327f,\
0.9886121451854705810547f,0.0113218077458441257477f,0.9367801276966929435730f,\
0.3874237253330647945404f,0.2886805813759565353394f,0.567788839805871248245f,\
0.7295644441619515419006f,0.0303032915107905864716f,0.2795897088944911956787f,\
0.7047131718136370182037f,0.7442112853750586509705f,0.8920237845741212368012f,\
0.1081438604742288589478f,0.8751525697298347949982f,0.9068333031609654426575f,\
0.2166852983646094799042f,0.4824190363287925720215f,0.7766945236362516880035f,\
0.4510916722938418388367f,0.1300636469386518001556f,0.5505470838397741317749f,\
0.6936193336732685565949f,0.1749099576845765113831f,0.8636093880049884319305f,\
0.2150467522442340850830f,0.1886725709773600101471f,0.1796098565682768821716f,\
0.4374312213622033596039f,0.8514516223222017288208f,0.7381969136185944080353f,\
0.8102188156917691230774f,0.1460137623362243175507f,0.8999849110841751098633f,\
0.4043733575381338596344f,0.0156995235010981559753f,0.6904196902178227901459f,\
0.2990311514586210250855f,0.1383218024857342243195f,0.8478512773290276527405f,\
0.3007262717001140117645f,0.229154746979475021362f,0.8078110129572451114655f,\
0.3176332255825400352478f,0.6924462593160569667816f,0.1364154014736413955689f,\
0.5433279541321098804474f,0.3276594849303364753723f,0.2006831648759543895721f,\
0.5037304237484931945801f,0.4962565028108656406403f,0.8996161324903368949890f,\
0.9357709079049527645111f,0.3390339072793722152710f,0.6029155333526432514191f,\
0.4153500730171799659729f,0.3041478390805423259735f,0.8489827848970890045166f,\
0.4482063786126673221588f,0.0903797810897231101990f,0.7382151386700570583344f,\
0.2669597584754228591919f,0.8226196658797562122345f,0.3985779182985424995422f,\
0.9789295899681746959686f,0.3041231036186218261719f,0.0663515278138220310211f,\
0.6667758254334330558777f,0.7548807277344167232513f,0.1922533493489027023315f,\
0.7942791883833706378937f,0.5580398896709084510803f,0.2016023616306483745575f,\
0.787146832793951034546f,0.0955459238030016422272f,0.6623697867617011070252f,\
0.864868474658578634262f,0.7013061288744211196899f,0.8015053984709084033966f,\
0.9135685982182621955872f,0.6317234965972602367401f,0.9346773549914360046387f,\
0.9157753759063780307770f,0.0510348035022616386414f,0.4329969524405896663666f,\
0.9721843507140874862671f,0.8001508046872913837433f,0.8452261472120881080627f,\
0.0610524858348071575165f,0.8168097324669361114502f,0.2101262793876230716705f,\
0.3055453812703490257263f,0.9465212575159966945648f,0.9269728232175111770630f,\
0.7737778765149414539337f,0.5893978821113705635071f,0.2377697187475860118866f,\
0.5269544571638107299805f,0.0077543654479086399078f,0.8311711428686976432800f,\
0.0268517597578465938568f,0.2591186594218015670776f,0.4641277943737804889679f,\
0.6098861405625939369202f,0.0656952331773936748505f,0.6466812007129192352295f,\
0.1018534512259066104889f,0.2742705782875418663025f,0.8162728524766862392426f,\
0.3357750270515680313110f,0.4765891996212303638458f,0.8440040023997426033020f,\
0.1785074654035270214081f,0.5855625644326210021973f,0.8426241897977888584137f,\
0.7058847947046160697937f,0.7396617024205625057221f,0.9751448985189199447632f,\
0.7606669445522129535675f,0.8236690396443009376526f,0.8889620001427829265595f,\
0.7960178293287754058838f,0.3052428201772272586823f,0.6803312664851546287537f,\
0.6412069997750222682953f,0.0988248009234666824341f,0.4654508423991501331329f,\
0.6714970665052533149719f,0.5131103205494582653046f,0.8631567060947418212891f,\
0.8328299173153936862946f,0.1687975851818919181824f,0.2961277081631124019623f,\
0.2591485660523176193237f,0.1700844173319637775421f,0.9718958893790841102600f,\
0.0695185582153499126434f,0.4696230851113796234131f,0.9544191421009600162506f,\
0.3679352095350623130798f,0.2973918146453797817230f,0.0415310803800821304321f,\
0.4892336544580757617950f,0.5171590568497776985169f,0.3534862431697547435761f,\
0.2354387864470481872559f,0.6779259913600981235504f,0.3834532154724001884460f,\
0.3174350797198712825775f,0.3418120350688695907593f,0.0535557498224079608917f,\
0.9285596096888184547424f,0.3862650538794696331024f,0.4328473098576068878174f,\
0.1581165478564798831940f,0.7887120461091399192810f,0.7448797873221337795258f,\
0.5185996759682893753052f,0.8651678604073822498322f,0.1524438308551907539368f,\
0.2392775672487914562225f,0.5761575847864151000977f,0.7395762302912771701813f,\
0.0583172617480158805847f,0.6962534948252141475678f,0.4206145536154508590698f,\
0.0281158541329205036163f,0.8313249954953789710999f,0.2333360086195170879364f,\
0.8865877203643321990967f,0.3746785433031618595123f,0.87671328987926244736f,\
0.4027077830396592617035f,0.2890332732349634170532f,0.8538430598564445972443f,\
0.5499771209433674812317f,0.5128610017709434032440f,0.6321087554097175598145f,\
0.4165538274683058261871f,0.3217771751806139945984f,0.9717370062135159969330f,\
0.5348322447389364242554f,0.3416590173728764057159f,0.9565287167206406593323f,\
0.9951003189198672771454f,0.3422884084284305572510f,0.7870580093003809452057f,\
0.9234123295173048973084f,0.5238970420323312282562f}

#define CRESULTR {0.6566347140259699566300f,1.0119999258966314581443f,0.6596019011837132017817f,\
1.035407544941025825835f,0.1779303602523068794650f,0.2091417769467268095163f,\
0.6938478808740486947215f,0.1809168200637071011183f,0.0097840077120305499192f,\
0.1918418803766589464388f,0.6967642148886226127758f,0.6477398327340490036264f,\
0.9315995708552796683577f,0.3317736774434180135884f,0.6081114651603225507159f,\
0.3241823207263323514127f,0.7257014354377283593678f,0.7561000009288112444494f,\
0.3005492023050818084506f,0.7318806897852137005600f,0.6527186268049437467553f,\
0.6309941597264083767982f,0.4252885469799541073854f,1.1110399216338266992210f,\
0.5224655834751933403126f,0.9668090801088078389824f,0.0373711557740689717666f,\
0.3268489749847858782950f,0.6382749343202905878414f,1.0114485987268988509413f,\
0.3221010444660392657568f,0.4139453304596071303578f,0.4756810141068628650096f,\
0.8632093598097250186640f,0.3598514339778784987267f,0.7487720850314417697646f,\
0.6130614254242318095223f,0.6997626019564747723578f,0.2545007621033356648432f,\
0.5515473173800672368472f,0.2912178978332317091926f,0.5910474830807833646063f,\
0.2166565482354273763921f,0.8021363255207357711996f,0.7443835374940948046429f,\
0.4891530673136452178618f,0.7013877718782099979222f,0.6913869813942569164667f,\
0.5769011420640627330059f,0.3117908008696873567445f,0.4351103756992900639666f,\
0.3419338661078391572445f,0.2322493315296763338740f,0.3651122336184794425762f,\
0.5004568464347787237756f,0.8474278924029616799629f,0.1163175220516309976704f,\
0.0720827231471598273149f,0.0923335564898466049089f,0.5339057146859005342776f,\
0.2372798723378120866467f,0.8333578948329619651148f,0.5639606188473457182298f,\
0.4177713004682119257716f,0.1842205910422827219719f,0.0061220134095790416234f,\
0.3327145852908883205679f,0.6419359463626251871560f,1.1422474153376851457864f,\
0.9169649828841031080629f,0.0457541584695274616834f,0.5117881770849980194171f,\
0.6755451518212014505593f,0.5184569836246168961225f,0.5713468012823553765500f,\
0.0858443570774837100279f,0.1606151108412635364342f,0.7918113937347260877786f,\
0.6654818631286439911676f,0.4439038705567253662032f,0.796132686757749730155f,\
0.3903563868552101800979f,0.1263898622508018709798f,0.7049140832202889228597f,\
0.8114695967676066601371f,0.6469075512356741164410f,0.7677157469479103379939f,\
1.0953970513593642710504f,0.7769182781192301989748f,1.0073965025007358686793f,\
1.074286510426218699266f,0.1553189729796884688273f,0.8413108822720302137910f,\
0.3462739066818524835689f,0.3926238690106399475965f,0.3256804935966552405624f,\
0.1633497671324356526057f,1.0010270500405602511762f,1.115022351982163151263f,\
0.7899569005544465616353f,0.2603865455411881191239f,0.5183255731419573741903f,\
0.7736654652779521024186f,0.7045488355155032911270f,0.99239017570392618062f,\
0.8571418992433421646382f,0.6471261632164159172120f,0.6653365916658987577748f,\
0.4179492416945764787783f,0.332966594116362202271f,0.8071129279142643664358f,\
0.6917895244691119049918f,0.6612409505512693019824f,0.8506578773411223037826f,\
0.4212670370210502279740f,0.7142246190696375229834f,0.5650468142706680518828f,\
0.2457619298195089230230f,0.4999304697490009052885f,0.9146990697266257352993f,\
0.6632530384013611834959f,0.5254071357713419043733f,0.8979087718767884140902f,\
0.3295715941858761155459f,0.7411311982358101957402f,0.0964650394595463894776f,\
0.5756260203046842383046f,0.9308880528862794045963f,1.2271094550000687384284f,\
0.6789423000457328605251f,0.1649198200195263752654f,1.1279258179884905644030f,\
0.3999539922775662836862f,0.6338241429246500580064f,0.1223148225900566599123f,\
0.9023144865193905017620f,0.0330081109061416202999f,0.3767477211449618557104f,\
0.3412118905344592723061f,0.5930700069420078435201f,0.1017393430189639513817f,\
0.0308061153410014963716f,0.4886538358989525598908f,0.3559707023880692156048f,\
0.4308223854061962176942f,0.3514869377238818426434f,0.0799867738322445898103f,\
0.8173018105145738454453f,0.2037338143062503714731f,1.220430983869785990237f,\
0.3406746275228044185113f,0.0004150259547877954485f,0.0971888856349881896657f,\
0.4757842207231965381276f,0.4040809859598182285367f,0.2820450997896822298294f,\
0.2811152693325764118093f,0.9590128703774639662427f,0.5354093557700149164091f,\
0.5019368627578308927895f,0.8117140104249528365088f,0.4534830656186849551226f,\
1.1783423931120406980000f,0.1434370411700725822524f,0.2934216038065708409555f,\
0.1779829127631718521663f,0.0720832823745556211525f,0.9611918663155849529289f,\
0.7759794971968927423944f,0.4215038017355943744668f,0.8045968908805133379403f,\
0.1352257439826550500239f,0.0966259862726158991197f,0.9423768067086430999524f,\
0.4303839309127981405112f,1.027158469056514755735f,0.0309063123957022088673f,\
0.1427581856076631239283f,0.5058338353137836751472f,0.5922330662524728506213f,\
0.2998212988294082781415f,0.4854774490519005447631f,0.2905366689284186176856f,\
0.732577252768074504985f,0.3467085924376158700966f,0.3404646689762517719480f,\
0.7192597601031739396049f,0.8895525359433824608146f,0.2563314638119464916599f,\
0.8145777458167494655683f,0.1728338655335915907685f,0.5887205934900180404057f,\
0.6014718010439381590260f,0.0675406202372636349507f,0.9510839296787396701660f,\
1.1598095667324348490013f,0.0309128254938883482994f,0.6857099135308569737290f,\
0.8512200678266018671891f,0.2729650321569278004219f}

#define CRESULTI {0.4759980266175199981049f,0.4371792356294723624899f,1.0366401767050017479477f,\
0.6028332456001923578270f,0.2045505325550055208961f,0.1915259687562470281019f,\
0.3491380267554807237396f,0.8920876814407183719169f,1.0006703458507313353465f,\
0.8009779429459989996687f,0.6984902194099197325627f,1.0544026495724472258786f,\
0.9182841727572422785286f,0.0106808422200693302340f,0.9834445059055472171394f,\
0.3787326350421501008903f,0.2100400056445083096790f,0.4557093767576786413898f,\
0.7737087506882367460293f,0.0206637462688268880306f,0.2204234493680024276063f,\
0.6615160486898620240126f,0.7692763584553293787494f,0.6356101396181920160089f,\
0.0925908774129100275996f,0.7206114133477932170990f,1.0359844944992535609174f,\
0.2069515918997265613299f,0.4117290503525293243747f,0.5490423106381259188424f,\
0.4462283131040214456675f,0.1189364264093275003198f,0.5274577925657699672968f,\
0.5430180765717186330832f,0.1643914008870697718301f,0.8230721066766158999783f,\
0.1735038050714417801057f,0.1378272158996049767676f,0.1748220246567987745667f,\
0.3903220669843952550515f,0.936703269190418574830f,0.7166597754518847507299f,\
0.8900704241537943373075f,0.0891449760436722887791f,0.8771518805722777756273f,\
0.3706792570421439947381f,0.0111920996603491820776f,0.6215444290094976897976f,\
0.2530709869257740662896f,0.1319801016143227201383f,0.9046350616526124266414f,\
0.2884930138703660218447f,0.2251695646636414915864f,0.8648081988694793498240f,\
0.2840216379380148814526f,0.5504953762822683005496f,0.1359271700042656016993f,\
0.5693382736493431961478f,0.3322720353016644923017f,0.1721580834994098363477f,\
0.5135850315563981194345f,0.3474773880755230304196f,0.9431362964718456032287f,\
1.0340232262721140710227f,0.3402877573217258366789f,0.6401040473330621427550f,\
0.4069022009136239459437f,0.2439407776749255851723f,0.5378842266979906305835f,\
0.2570716586141951753852f,0.0904088654517940515376f,0.7403475521247256940782f,\
0.2047878426979200527924f,0.8489939536581485590716f,0.3473238625280567482001f,\
1.1411188764290771668897f,0.3051746072580045487932f,0.0407043050782743276450f,\
0.6033725923116708411698f,0.778737542643346047910f,0.1206535237380119696127f,\
0.8418336511001852651148f,0.5839585555917582437857f,0.1467518266954731531726f,\
0.6888901126606848945855f,0.0732090771366951525989f,0.5554652901202962178573f,\
0.6068461403975041745795f,0.5973804827482247503667f,0.5862495346519734917834f,\
0.7008734442762630800772f,0.6689719175986947874435f,0.8829098191147302099324f,\
1.0188712228965588479923f,0.0469681660587412258545f,0.4264494425604897775983f,\
1.1260897634779567511032f,0.5891751058811135477455f,0.5586811292942333029288f,\
0.0375737549548666310839f,0.8936786828452066844264f,0.1824421274677656690244f,\
0.2090978327687162685589f,0.9628255596340984379111f,0.7821471108810679195855f,\
0.6470050596557553879151f,0.5216627363302938080736f,0.1830177712067865836154f,\
0.5134143514131775942744f,0.0073119913675850425894f,0.7504222430574429836270f,\
0.0193983766100578602920f,0.2014128332431188439511f,0.3088455785813677967333f,\
0.6065483134448432789299f,0.0461172484518394959485f,0.6134456837548584173803f,\
0.0989331667688019139595f,0.2433781622039619951803f,0.6701373782390742661619f,\
0.2663685035487164953771f,0.4365368071405912875349f,0.7189236163164304249662f,\
0.1697526069685433847134f,0.4811811372286406429666f,0.9436115675726329810047f,\
0.6813279536427474525340f,0.5582673535726633273768f,0.6663831331574520122629f,\
0.7137987696438253815146f,0.9132123041060544732517f,0.6154027043735471602659f,\
0.8421707385350217789366f,0.2467394118703030714279f,0.730464243452961903280f,\
0.4583747264016979627854f,0.0989323235351602520149f,0.4538168380708768601117f,\
0.6949204434222109316721f,0.4568731305870791792323f,0.9718116503334458533558f,\
0.9322636874728698064274f,0.1486199865445305412504f,0.2824746711136658094965f,\
0.238217162606873950059f,0.1603203534786354911290f,1.130704398714823533112f,\
0.0402833511895827542371f,0.4788366747059483730098f,0.6354755115001236021044f,\
0.3566529249056448747091f,0.3017948657011057522759f,0.0413466935121344983384f,\
0.46096369056612357f,0.5052181131344314346521f,0.3479618653266752237308f,\
0.2285599720872606155364f,0.462725396526868226754f,0.3406579403750831791520f,\
0.2835867580422753442271f,0.2238269615848648141920f,0.0477728736811990767341f,\
0.6329115684248395323763f,0.3924052442709091148565f,0.4301664447715317640686f,\
0.1563039559206648165812f,0.8717772653208039068673f,0.544280842419675670030f,\
0.3964232571280063566199f,0.9317498908981691752018f,0.0927647199866874355711f,\
0.239471404370552171104f,0.6064908073717841796579f,0.5504808053886728336224f,\
0.0526899922619719976447f,0.4312873750429307428966f,0.4329527886793243518504f,\
0.0278317754230633894463f,0.8642909834572990446233f,0.1923982024967207382638f,\
0.9846585214795218199413f,0.3418444780294159768275f,0.9720887284222768931485f,\
0.3044849414953779143112f,0.2763773261322472474255f,0.9320336608375792142311f,\
0.4523656548286881795562f,0.3324058771805019629753f,0.6596413052835798929152f,\
0.2842028663251400799616f,0.3229125187951548126009f,1.0425270197833373941876f,\
0.4773378821453879150560f,0.3476356752155591589570f,0.8551943809979846156111f,\
0.7664315470559724952082f,0.3488628182805697530711f,0.7453969031814248191736f,\
0.8607289142164601392082f,0.5322582746397167552388f}


void ssinsTest() {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out;
	int i;

	for (i=0;i<200;i++){
		out=ssins(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<1e-6);
	}
}

void csinsTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=FloatComplex(inR[i],inI[i]);
		out=csins(in);
		assert(( (fabs(creals(out)-resR[i]))/(fabs(creals(out))) )<1e-6);	
		assert(( (fabs(cimags(out)-resI[i]))/(fabs(cimags(out))) )<1e-6);			
	}
}

void ssinaTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out[200];
	int i,j;
	j=1;
	ssina(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<1e-6);
	}
}

void csinaTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex *in,out[200];
	int i;

	in=FloatComplexMatrix(inR,inI,200);
	csina(in,200,out);

	for (i=0;i<200;i++){
		assert(( (fabs(creals(out[i])-resR[i]))/(fabs(creals(out[i]))) )<1e-6);	
		assert(( (fabs(cimags(out[i])-resI[i]))/(fabs(cimags(out[i]))) )<1e-6);			
	}
}

int testSin() {
  printf("\n>>>> Float Sine Tests\n");
  ssinsTest();
  csinsTest();
  ssinaTest();
  csinaTest();
  return 0;
}

int main(void) {
  assert(testSin() == 0);
  return 0;
}
