/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2006-2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testSinh.h"

#define SOURCE {0.7062616096809506416321f,0.4090520101599395275116f,0.3011248558759689331055f,\
0.1880126395262777805328f,0.1796709178015589714050f,0.2828889950178563594818f,\
0.7232380937784910202026f,0.7360379849560558795929f,0.1852612206712365150452f,\
0.7703790138475596904755f,0.1914967410266399383545f,0.7521587223745882511139f,\
0.6205883463844656944275f,0.2807604051195085048676f,0.2289868686348199844360f,\
0.5049233403988182544708f,0.8354099662974476814270f,0.8174716415815055370331f,\
0.0030740275979042053223f,0.3677616142667829990387f,0.8278525872156023979187f,\
0.72754097869619727135f,0.5323124285787343978882f,0.9267726917751133441925f,\
0.9542504185810685157776f,0.3162104780785739421845f,0.5789009965956211090088f,\
0.6881225542165338993073f,0.3714061146602034568787f,0.1705444059334695339203f,\
0.1954363007098436355591f,0.978800852317363023758f,0.9300233917310833930969f,\
0.5357720064930617809296f,0.3947123587131500244141f,0.1344871171750128269196f,\
0.7380615202710032463074f,0.588114650454372167587f,0.9113173168152570724487f,\
0.5682763461954891681671f,0.1127616921439766883850f,0.9478473584167659282684f,\
0.5237770043313503265381f,0.8140139640308916568756f,0.1400952627882361412048f,\
0.2763446993194520473480f,0.9059953633695840835571f,0.1379901585169136524200f,\
0.5603838684037327766419f,0.3008610638789832592011f,0.4767417535185813904f,\
0.8127435916103422641754f,0.1988414181396365165710f,0.1107953130267560482025f,\
0.2159351315349340438843f,0.6467244853265583515167f,0.6597879612818360328674f,\
0.0691898013465106487274f,0.9164751060307025909424f,0.8635670826770365238190f,\
0.5032854294404387474060f,0.1832137755118310451508f,0.8403698671609163284302f,\
0.9247214836068451404572f,0.6229452537372708320618f,0.2773811477236449718475f,\
0.2479109913110733032227f,0.3891948559321463108063f,0.0436578569933772087097f,\
0.8132526441477239131928f,0.7686451207846403121948f,0.4041520212776958942413f,\
0.8579940209165215492249f,0.6993723283521831035614f,0.0828925184905529022217f,\
0.9201254160143435001373f,0.5200281282886862754822f,0.9351884997449815273285f,\
0.8825624976307153701782f,0.2245844271965324878693f,0.2153332801535725593567f,\
0.4327089670114219188690f,0.5800157263875007629395f,0.8876141034997999668121f,\
0.5258982880041003227234f,0.859640696551650762558f,0.7337234076112508773804f,\
0.7134532411582767963409f,0.1087165409699082374573f,0.8477638359181582927704f,\
0.6594733335077762603760f,0.7916418449021875858307f,0.6067967480048537254334f,\
0.4102901122532784938812f,0.1958728153258562088013f,0.241527963895350694656f,\
0.5113455550745129585266f,0.9119556057266891002655f,0.0928984880447387695313f,\
0.7438839026726782321930f,0.1938720373436808586121f,0.4355978979729115962982f,\
0.9922429900616407394409f,0.4533818070776760578156f,0.8269640663638710975647f,\
0.8889675955288112163544f,0.4682085178792476654053f,0.3856786251999437808991f,\
0.4124865522608160972595f,0.6955242282710969448090f,0.0978972557932138442993f,\
0.8728604433126747608185f,0.6359515609219670295715f,0.4129665228538215160370f,\
0.0294486805796623229980f,0.1809961968101561069489f,0.7658103061839938163757f,\
0.1232470511458814144135f,0.0170737411826848983765f,0.8835507561452686786652f,\
0.3164170170202851295471f,0.9378212536685168743134f,0.3916359134018421173096f,\
0.0844073877669870853424f,0.6934146797284483909607f,0.4618808380328118801117f,\
0.9355291295796632766724f,0.0842495900578796863556f,0.5402926551178097724915f,\
0.5613215523771941661835f,0.1306025832891464233398f,0.5840523042716085910797f,\
0.0048661706969141960144f,0.2761953338049352169037f,0.7478824090212583541870f,\
0.0194325004704296588898f,0.6444276878610253334045f,0.2243968318216502666473f,\
0.2478402368724346160889f,0.1196091384626924991608f,0.1883201440796256065369f,\
0.3393343067727982997894f,0.959958622232079505920f,0.2847225037403404712677f,\
0.8766820700839161872864f,0.2853349032811820507050f,0.5103433504700660705566f,\
0.8752629184164106845856f,0.5941145820543169975281f,0.3945342986844480037689f,\
0.4661326166242361068726f,0.0073588271625339984894f,0.5170202488079667091370f,\
0.4690007264725863933563f,0.6654530800879001617432f,0.9476742581464350223541f,\
0.4933638339862227439880f,0.2918433747254312038422f,0.2016727942973375320435f,\
0.7016656589694321155548f,0.8736049132421612739563f,0.191055159550160169601f,\
0.5307010114192962646484f,0.8889481076039373874664f,0.0115523664280772209167f,\
0.4998398735187947750092f,0.6700848620384931564331f,0.4995208983309566974640f,\
0.1538907447829842567444f,0.2571737091057002544403f,0.9586529098451137542725f,\
0.6246025026775896549225f,0.9371285131201148033142f,0.9923511571250855922699f,\
0.3454555813223123550415f,0.7558249053545296192169f,0.2107181670144200325012f,\
0.9372652801685035228729f,0.6767524704337120056152f,0.7465373151935636997223f,\
0.4050982249900698661804f,0.5101723610423505306244f,0.9497965183109045028687f,\
0.0289692510850727558136f,0.1634070957079529762268f,0.4146909262053668498993f,\
0.0021650679409503936768f,0.1810030029155313968658f,0.4556188201531767845154f,\
0.1977851442061364650726f,0.6053877938538789749146f,0.4363054675050079822540f,\
0.8938506888225674629211f,0.6104825991205871105194f,0.4316215068101882934570f,\
0.2315693595446646213532f,0.4675927339121699333191f,0.6150764389894902706146f,\
0.8621218334883451461792f,0.3846137975342571735382f}

#define RESULT {0.7664580028254754928696f,0.4205551659468407255105f,0.3056963415200024125618f,\
0.1891222676242167166638f,0.1806391579088424403921f,0.2866772088777344573707f,\
0.7879588923423612722985f,0.8043199087726096152551f,0.1863227880624591659142f,\
0.8488736885251115804607f,0.1926692851046332977116f,0.8251135119137460449679f,\
0.6611970121102711539507f,0.2844635257838270536723f,0.2309932755888478017603f,\
0.5266533298916223904129f,0.9360312470542428986420f,0.9116099093552539889274f,\
0.0030740324393184245005f,0.3761077290387422333851f,0.9257063259676088229355f,\
0.7934443680694276412879f,0.5578100394371053871723f,1.0652568032347091708800f,\
1.1058113484469005438626f,0.3215064844139553512648f,0.6117813058051149166516f,\
0.7437286582384788902189f,0.3800039829530417190284f,0.1713723342659267123711f,\
0.1966828051044853253870f,1.1427508290431065418602f,1.0700119918415624820085f,\
0.5617747940982125154363f,0.4050417184145185811595f,0.1348928905465842098543f,\
0.8069184166073162245425f,0.6226085497916535871354f,1.0428015042623968167135f,\
0.599360373550158476164f,0.1130008086773218733967f,1.0962875524202524424311f,\
0.5480567058218726028684f,0.9069365704321199483928f,0.1405539802560804574227f,\
0.2798753950272672152977f,1.0351270996105206290139f,0.1384284939283927651221f,\
0.5901774101693750829156f,0.3054205096845967748465f,0.4950072868345940513279f,\
0.9052222830609093495724f,0.2001543065651501807079f,0.1110221320487437962621f,\
0.2176171514122479666575f,0.6927590813444466366633f,0.7087105942005499370495f,\
0.0692450191279527643706f,1.0502673603752690212332f,0.9749750092666438217037f,\
0.5248028600685283873162f,0.1842404954551666029783f,0.9428365029551442066946f,\
1.0622620507764020114649f,0.6640243707694319930113f,0.2809518213531947417039f,\
0.2504582355084098987952f,0.3990949339123049943723f,0.0436717270227189244269f,\
0.9059090417535855532805f,0.8466005962798425210636f,0.4152445147326426222456f,\
0.9672066028315211561051f,0.7577960172200091104600f,0.0829874792017267076671f,\
1.0555680256611981171488f,0.5437855687819154182350f,1.0775908909563920446f,\
1.0016820806611792527008f,0.2264771318543304656767f,0.2170012532427569029725f,\
0.4463391386879682620759f,0.6130884787237118604963f,1.0088449524118139333240f,\
0.5504769168224112885213f,0.9694988006053883999869f,0.8013516989017863689782f,\
0.7755389514921953164617f,0.1089308262191755055648f,0.9530245458199384511744f,\
0.7083249989659490264415f,0.8769583844905950442694f,0.6447256579530228348673f,\
0.4218986249201953087074f,0.1971277014550009420990f,0.2438831089846125732557f,\
0.533922660930493120368f,1.0437239139050094038907f,0.0930321667054502116079f,\
0.8144136536953445748566f,0.1950888127224135459858f,0.4495046404602288658836f,\
1.1632667385972190743360f,0.4690747173387543877965f,0.9244959100750387293033f,\
1.0107684876711933164017f,0.4855037229984789926007f,0.3953114776639800043157f,\
0.4242835646837694318911f,0.7529734313215303842526f,0.0980537032157421939438f,\
0.9879966883143458389327f,0.6796935751591178798137f,0.4248049987494686430267f,\
0.0294529372018587365378f,0.1819860446417611021808f,0.8428897015241260115559f,\
0.1235593052805215308343f,0.0170745707299980210847f,1.00308135457124825152f,\
0.3217234423590110692359f,1.0814650488452381971172f,0.4017244052147506683248f,\
0.0845076517232198759499f,0.7503344007980436991545f,0.4784793780524976836155f,\
1.0780917143422910076112f,0.0843492926084187938374f,0.5669657003997248256866f,\
0.5912664777040658181662f,0.1309741822002446487439f,0.6178283036240778125503f,\
0.0048661899017801981890f,0.2797202929941594029550f,0.8195769639564471908955f,\
0.0194337235170454029898f,0.6899668115272159507612f,0.2262847895615458237995f,\
0.2503852962589531161441f,0.1198945374904236832458f,0.1894352321040725928292f,\
0.3458841682539985917799f,1.114339839966214773526f,0.2885850554536735224076f,\
0.9933761739682215319292f,0.2892224999614779745727f,0.5327868189334407089675f,\
0.9913768259985344943885f,0.6296876098817790756712f,0.4048496130982584539915f,\
0.4831971402378967828106f,0.0073588935789954878705f,0.5403641862154227037962f,\
0.4863845156450118945024f,0.7156655787491872366957f,1.0960307119322381108617f,\
0.5136236116845008803367f,0.2960038943626104313012f,0.2030426468819693797130f,\
0.7606754386337204465463f,0.9890435019692191964680f,0.1922196010078167094370f,\
0.5559656008212838784743f,1.0107407789878923853877f,0.0115526233874804207247f,\
0.5209147493956211016908f,0.72136900661981750993f,0.5205551177967873144326f,\
0.1544988804781949887079f,0.2600179378248433925691f,1.112385813317804839073f,\
0.6660146232231449747729f,1.080444939603935505801f,1.163432674859314452931f,\
0.3523677837341518959136f,0.8298721326257240127333f,0.212281022488974985274f,\
1.0806462976206427928361f,0.729606491474904528260f,0.8178385727082368994445f,\
0.4162692379888194293969f,0.5325930826611361412759f,1.099181921047706733674f,\
0.0289733031722175932154f,0.1641352799703627574068f,0.4266791772900341284114f,\
0.0021650696324170431474f,0.1819929625387523564051f,0.4715467862637556795136f,\
0.1990771937658423751394f,0.6430498957811131566231f,0.4502805198476966808130f,\
1.0177235844677285925286f,0.6491155460121008635710f,0.4451485373036410675418f,\
0.2336445425260662012157f,0.4848192931203018085640f,0.6545992099992568036271f,\
0.9729575479551634265008f,0.394166691840286298465f}

#define CSOURCER {0.6045256052166223526001f,0.9455216196365654468536f,0.4476299257948994636536f,\
0.8624908211641013622284f,0.1751048639416694641113f,0.2067177616991102695465f,\
0.6848411662504076957703f,0.1348653226159512996674f,0.0069159921258687973022f,\
0.1496290047653019428253f,0.5665438110008835792542f,0.4359452719800174236298f,\
0.6547604538500308990479f,0.3381605879403650760651f,0.4259321158751845359802f,\
0.3060420057736337184906f,0.7704779822379350662231f,0.7058695447631180286408f,\
0.2373670237138867378235f,0.8205849635414779186249f,0.6789963841438293457031f,\
0.5250809141434729099274f,0.3359806565567851066589f,0.8941988362930715084076f,\
0.5461782198399305343628f,0.7568633262999355792999f,0.0259526828303933143616f,\
0.3250150899402797222138f,0.6072143577039241791f,0.8756139636971056461334f,\
0.2962085595354437828064f,0.4229678637348115444183f,0.4243144039064645767212f,\
0.7620028969831764698029f,0.3622896494343876838684f,0.5658242437057197093964f,\
0.6424440070986747741699f,0.7580267959274351596832f,0.2531452132388949394226f,\
0.5266989110969007015228f,0.2118590380996465682983f,0.4779220153577625751495f,\
0.1615962767973542213440f,0.9168031658045947551727f,0.5461866445839405059815f,\
0.4686870560981333255768f,0.7772213732823729515076f,0.5871783248148858547211f,\
0.5848031807690858840942f,0.3139644009061157703400f,0.3204141603782773017883f,\
0.3331634956412017345429f,0.2282590121030807495117f,0.2750317254103720188141f,\
0.4963629124686121940613f,0.7453477247618138790131f,0.1155001949518918991089f,\
0.0626524840481579303741f,0.0877018878236413002014f,0.5507565210573375225067f,\
0.2116370312869548797607f,0.8335358710028231143951f,0.4045845707878470420837f,\
0.2880227542482316493988f,0.1750094983726739883423f,0.0051561561413109302521f,\
0.3109287889674305915833f,0.6602919283322989940643f,0.9722995534539222717285f,\
0.9826813959516584873200f,0.0455837054178118705750f,0.4096118300221860408783f,\
0.7104403134435415267944f,0.3917615194804966449738f,0.5571686858311295509338f,\
0.0565565521828830242157f,0.1540721096098423004150f,0.9109257892705500125885f,\
0.5713340407237410545349f,0.3488348922692239284515f,0.8972954172641038894653f,\
0.2973396372981369495392f,0.1091936426237225532532f,0.7626331257633864879608f,\
0.6584706604480743408203f,0.6996708759106695652008f,0.6756794182583689689636f,\
0.9004421546123921871185f,0.6668148916214704513550f,0.8518152837641537189484f,\
0.8365677157416939735413f,0.1291190306656062602997f,0.6095453463494777679443f,\
0.2412315667606890201569f,0.4029275467619299888611f,0.3019328541122376918793f,\
0.1083198729902505874634f,0.8456356939859688282013f,0.9417407037690281867981f,\
0.9083450469188392162323f,0.1937242373824119567871f,0.5318046086467802524567f,\
0.8314437521621584892273f,0.4952740012668073177338f,0.7465563025325536727905f,\
0.7102393140085041522980f,0.5811418974772095680237f,0.7035941029898822307587f,\
0.3746570833027362823486f,0.3394373343326151371002f,0.6322447275742888450623f,\
0.7636191300116479396820f,0.6940386760979890823364f,0.8735245508141815662384f,\
0.3612738298252224922180f,0.7933200257830321788788f,0.4830590635538101196289f,\
0.2469964125193655490875f,0.5025922833010554313660f,0.7430270477198064327240f,\
0.6783937942236661911011f,0.4903185223229229450226f,0.709806025959551334381f,\
0.3303662906400859355927f,0.6815545372664928436279f,0.0701365978457033634186f,\
0.4745870968326926231384f,0.8091805852018296718597f,0.9447045121341943740845f,\
0.5478458073921501636505f,0.1216687532141804695129f,0.9161847713403403759003f,\
0.3045207932591438293457f,0.6502694808878004550934f,0.0987624628469347953796f,\
0.8391053467057645320892f,0.0328534897416830062866f,0.3461971958167850971222f,\
0.2801467711105942726135f,0.5500544901005923748016f,0.0729318000376224517822f,\
0.0225322381593286991119f,0.50267804320901632309f,0.3478884599171578884125f,\
0.4298669416457414627075f,0.3537984383292496204376f,0.0529730813577771186829f,\
0.9533003675751388072968f,0.1842019557952880859375f,0.958756382111459970474f,\
0.3245136169716715812683f,0.0003973259590566158295f,0.0972583871334791183472f,\
0.4378789965994656086f,0.3634226778522133827210f,0.2685119728557765483856f,\
0.2770298384130001068115f,0.8854365111328661441803f,0.5216628303751349449158f,\
0.4979983693920075893f,0.8733724001795053482056f,0.4699407932348549365997f,\
0.9364062966778874397278f,0.1337622734718024730682f,0.2712419554591178894043f,\
0.1766990595497190952301f,0.0543269468471407890320f,0.8402757882140576839447f,\
0.7507283594459295272827f,0.3062269617803394794464f,0.9195641661062836647034f,\
0.1318263853900134563446f,0.0826364941895008087158f,0.8222710476256906986237f,\
0.4441085970029234886169f,0.9617503038607537746429f,0.0283641982823610305786f,\
0.1431905967183411121368f,0.3793597565963864326477f,0.6144003230147063732147f,\
0.2128270715475082397461f,0.4704488315619528293610f,0.2076055286452174186707f,\
0.7435979112051427364349f,0.3391801547259092330933f,0.2479635034687817096710f,\
0.6721735307946801185608f,0.9013197491876780986786f,0.2140864841639995574951f,\
0.8460668534971773624420f,0.1650043567642569541931f,0.4003686285577714443207f,\
0.5522825215011835098267f,0.0638249483890831470490f,0.6903966935351490974426f,\
0.8547787251882255077362f,0.0291904583573341369629f,0.5434663915075361728668f,\
0.6236743135377764701843f,0.2417052476666867733002f}

#define CSOURCEI {0.5503273960202932357788f,0.6906704087741672992706f,0.9835249418392777442932f,\
0.8285484607331454753876f,0.2062614001333713531494f,0.1944643096067011356354f,\
0.4367609983310103416443f,0.8090620837174355983734f,0.8818644303828477859497f,\
0.7404803228564560413361f,0.7542522149160504341126f,0.9921960639767348766327f,\
0.9886121451854705810547f,0.0113218077458441257477f,0.9367801276966929435730f,\
0.3874237253330647945404f,0.2886805813759565353394f,0.567788839805871248245f,\
0.7295644441619515419006f,0.0303032915107905864716f,0.2795897088944911956787f,\
0.7047131718136370182037f,0.7442112853750586509705f,0.8920237845741212368012f,\
0.1081438604742288589478f,0.8751525697298347949982f,0.9068333031609654426575f,\
0.2166852983646094799042f,0.4824190363287925720215f,0.7766945236362516880035f,\
0.4510916722938418388367f,0.1300636469386518001556f,0.5505470838397741317749f,\
0.6936193336732685565949f,0.1749099576845765113831f,0.8636093880049884319305f,\
0.2150467522442340850830f,0.1886725709773600101471f,0.1796098565682768821716f,\
0.4374312213622033596039f,0.8514516223222017288208f,0.7381969136185944080353f,\
0.8102188156917691230774f,0.1460137623362243175507f,0.8999849110841751098633f,\
0.4043733575381338596344f,0.0156995235010981559753f,0.6904196902178227901459f,\
0.2990311514586210250855f,0.1383218024857342243195f,0.8478512773290276527405f,\
0.3007262717001140117645f,0.229154746979475021362f,0.8078110129572451114655f,\
0.3176332255825400352478f,0.6924462593160569667816f,0.1364154014736413955689f,\
0.5433279541321098804474f,0.3276594849303364753723f,0.2006831648759543895721f,\
0.5037304237484931945801f,0.4962565028108656406403f,0.8996161324903368949890f,\
0.9357709079049527645111f,0.3390339072793722152710f,0.6029155333526432514191f,\
0.4153500730171799659729f,0.3041478390805423259735f,0.8489827848970890045166f,\
0.4482063786126673221588f,0.0903797810897231101990f,0.7382151386700570583344f,\
0.2669597584754228591919f,0.8226196658797562122345f,0.3985779182985424995422f,\
0.9789295899681746959686f,0.3041231036186218261719f,0.0663515278138220310211f,\
0.6667758254334330558777f,0.7548807277344167232513f,0.1922533493489027023315f,\
0.7942791883833706378937f,0.5580398896709084510803f,0.2016023616306483745575f,\
0.787146832793951034546f,0.0955459238030016422272f,0.6623697867617011070252f,\
0.864868474658578634262f,0.7013061288744211196899f,0.8015053984709084033966f,\
0.9135685982182621955872f,0.6317234965972602367401f,0.9346773549914360046387f,\
0.9157753759063780307770f,0.0510348035022616386414f,0.4329969524405896663666f,\
0.9721843507140874862671f,0.8001508046872913837433f,0.8452261472120881080627f,\
0.0610524858348071575165f,0.8168097324669361114502f,0.2101262793876230716705f,\
0.3055453812703490257263f,0.9465212575159966945648f,0.9269728232175111770630f,\
0.7737778765149414539337f,0.5893978821113705635071f,0.2377697187475860118866f,\
0.5269544571638107299805f,0.0077543654479086399078f,0.8311711428686976432800f,\
0.0268517597578465938568f,0.2591186594218015670776f,0.4641277943737804889679f,\
0.6098861405625939369202f,0.0656952331773936748505f,0.6466812007129192352295f,\
0.1018534512259066104889f,0.2742705782875418663025f,0.8162728524766862392426f,\
0.3357750270515680313110f,0.4765891996212303638458f,0.8440040023997426033020f,\
0.1785074654035270214081f,0.5855625644326210021973f,0.8426241897977888584137f,\
0.7058847947046160697937f,0.7396617024205625057221f,0.9751448985189199447632f,\
0.7606669445522129535675f,0.8236690396443009376526f,0.8889620001427829265595f,\
0.7960178293287754058838f,0.3052428201772272586823f,0.6803312664851546287537f,\
0.6412069997750222682953f,0.0988248009234666824341f,0.4654508423991501331329f,\
0.6714970665052533149719f,0.5131103205494582653046f,0.8631567060947418212891f,\
0.8328299173153936862946f,0.1687975851818919181824f,0.2961277081631124019623f,\
0.2591485660523176193237f,0.1700844173319637775421f,0.9718958893790841102600f,\
0.0695185582153499126434f,0.4696230851113796234131f,0.9544191421009600162506f,\
0.3679352095350623130798f,0.2973918146453797817230f,0.0415310803800821304321f,\
0.4892336544580757617950f,0.5171590568497776985169f,0.3534862431697547435761f,\
0.2354387864470481872559f,0.6779259913600981235504f,0.3834532154724001884460f,\
0.3174350797198712825775f,0.3418120350688695907593f,0.0535557498224079608917f,\
0.9285596096888184547424f,0.3862650538794696331024f,0.4328473098576068878174f,\
0.1581165478564798831940f,0.7887120461091399192810f,0.7448797873221337795258f,\
0.5185996759682893753052f,0.8651678604073822498322f,0.1524438308551907539368f,\
0.2392775672487914562225f,0.5761575847864151000977f,0.7395762302912771701813f,\
0.0583172617480158805847f,0.6962534948252141475678f,0.4206145536154508590698f,\
0.0281158541329205036163f,0.8313249954953789710999f,0.2333360086195170879364f,\
0.8865877203643321990967f,0.3746785433031618595123f,0.87671328987926244736f,\
0.4027077830396592617035f,0.2890332732349634170532f,0.8538430598564445972443f,\
0.5499771209433674812317f,0.5128610017709434032440f,0.6321087554097175598145f,\
0.4165538274683058261871f,0.3217771751806139945984f,0.9717370062135159969330f,\
0.5348322447389364242554f,0.3416590173728764057159f,0.9565287167206406593323f,\
0.9951003189198672771454f,0.3422884084284305572510f,0.7870580093003809452057f,\
0.9234123295173048973084f,0.5238970420323312282562f}

#define CRESULTR {0.5472322176851935893183f,0.8423815144738766580446f,0.2563943802472780086887f,\
0.6580149781735437075625f,0.172270452907771959294f,0.2042689977544929758047f,\
0.6702103597375301813344f,0.0933634309412847973597f,0.0043966214876582573878f,\
0.1108604362841248136551f,0.4353327109259368388194f,0.2460210551978029014375f,\
0.3863009441992301673530f,0.3446203724316067584788f,0.2600144972151141042893f,\
0.2878039319893796466054f,0.8138720272443707992593f,0.6457782886418844681131f,\
0.1786150863987957249091f,0.9154066811177691276313f,0.7039465385045338141623f,\
0.4186412388856993738173f,0.251831143580886374078f,0.6392775639808577770040f,\
0.5703895608242733894f,0.5327133470263697434532f,0.0159949490007091424393f,\
0.3230326909984754801819f,0.5715867388279289862396f,0.70743658734176706471f,\
0.2704947225723857706647f,0.4320127595486245031253f,0.3725662344034775808055f,\
0.6443049465819230547936f,0.3646176810862393202761f,0.3875469668337525042112f,\
0.6717212085417494371598f,0.8179578243363959666468f,0.2517417237838881494128f,\
0.4994735839970788071618f,0.1406387935502509678454f,0.3671229322416942886243f,\
0.1118802149170177451243f,1.0395621212598731286647f,0.3566561127022580546253f,\
0.4468365274738785863917f,0.8577631106167230568005f,0.4791678319520160100886f,\
0.5912541631998992075481f,0.3160997340804129196457f,0.2156306076938400706489f,\
0.3241312167359722828941f,0.2242273866635746126796f,0.1924748395730505323709f,\
0.4911358423279918450355f,0.6282969869096745041404f,0.1146817647308075033275f,\
0.0536651752624737465869f,0.0831424755428421952130f,0.5674049454933377534260f,\
0.1867359129769284864508f,0.8208629596874984502009f,0.2585362736705908437429f,\
0.1732265992600796333800f,0.16589114027651630234f,0.0042470718039759334031f,\
0.2890982749320905043078f,0.6767719859275036498048f,0.7485620199211779901560f,\
1.0351949282063730439774f,0.0454133801589929955722f,0.3115216746749414067352f,\
0.7443929466921332949170f,0.2733866129562390612229f,0.5404777583133708596108f,\
0.0315703580162773125850f,0.147584010699447737425f,1.039942513447497107748f,\
0.4737927564457495854811f,0.2592593650600479859847f,1.0038035523317359043460f,\
0.2114594061381599998661f,0.0928125663229541070232f,0.8217516921908377680595f,\
0.4991177362348290791339f,0.7547125896791468946390f,0.5742746733474036746614f,\
0.6663538162766660111203f,0.5480484998281744957183f,0.6668472960736752108701f,\
0.5728135406334763368719f,0.1044902427136027156518f,0.3849616107773408679726f,\
0.1483818586286529961349f,0.4133800608325002845511f,0.2782513626438464227064f,\
0.0611572839884242727693f,0.6618291251618653170397f,0.7214555888399967198410f,\
1.0365769046431902999927f,0.1334450193993464428566f,0.5449721531302730292978f,\
0.8875031186053717879858f,0.3014734616304127201580f,0.4909287752495701262490f,\
0.5518178196952380210050f,0.5107438627596426750088f,0.7416305403413676611280f,\
0.3314614008027890745822f,0.3459827842193233804480f,0.4551032028697677422890f,\
0.8397231818014913029558f,0.7260395894674003258729f,0.8843138378471343541420f,\
0.3026251045027910646645f,0.8772951459166481447127f,0.4006929045316259263565f,\
0.2482223780387364797662f,0.5044338903508289728705f,0.5570690492655497871866f,\
0.6907809922454775097833f,0.4533479549350135084929f,0.5122634930781091444629f,\
0.3310630379415674395816f,0.613016054683563793581f,0.0467146352521808638780f,\
0.3748904897125588941975f,0.6651387060224456249102f,0.6124566220104487035414f,\
0.4169978608497757477380f,0.0828821922879106609550f,0.6616323773282192233225f,\
0.2163376802382008246006f,0.6648529631046872223621f,0.0768992913125638027916f,\
0.7541728606139842527867f,0.0326990726296657319150f,0.3155854015657582611887f,\
0.2222045454294520605565f,0.5037531760449395212831f,0.0474507678257595696958f,\
0.0151606295675061168715f,0.5166679862331013950438f,0.3394987264597518761278f,\
0.4284286045731299230610f,0.3560134790628905476773f,0.0298767286161388812005f,\
1.1017278018047820253855f,0.1651905315864863887931f,0.6431406060888099629480f,\
0.3081371323272805162752f,0.0003798849528566614498f,0.0973277933130341499357f,\
0.3989833287694000141244f,0.3228967085282569149385f,0.2549483000782091224323f,\
0.2728461176861247117209f,0.7833569024666595659312f,0.5060212064439562063001f,\
0.4929175980688511038430f,0.9315180933744126035023f,0.4867312349946628091679f,\
0.6465368595829137365882f,0.1242768439875277936002f,0.2492570609243859591775f,\
0.1754042926970652005458f,0.0383062756502238338507f,0.6930494891633879328552f,\
0.7150128880873719561251f,0.2017103771899077802043f,1.0425200734321566908847f,\
0.1284418402888304333587f,0.0693747355415850891491f,0.6782611829725390117929f,\
0.4580719788105512280119f,0.8570372579890597197760f,0.0258953949937216834631f,\
0.1436236317560128927795f,0.2618257507714434328960f,0.6360738131964667196883f,\
0.1355372871482912744412f,0.4541408129960864403785f,0.1337573051159255954623f,\
0.7489238330244115671164f,0.3313805035932426146239f,0.1646094396781437041444f,\
0.6171903594464053233182f,0.8960982240646825358610f,0.1740438285898232018134f,\
0.8693877096502734547201f,0.1572467731529608725438f,0.2318339325462937250411f,\
0.4996847882291703402125f,0.0601767100407825661357f,0.4302901718551004339730f,\
0.5241328386970756092467f,0.0275009970661485095289f,0.4028168044525495261610f,\
0.4010021931852675303176f,0.2113305958381946625391f}

#define CRESULTI {0.6214715223992962611632f,0.9436786189504819954976f,0.9172582471851381535899f,\
1.0284753878837631368981f,0.2079498059841204116172f,0.1973845021659479948006f,\
0.5261415139330058998723f,0.7302311658604533350925f,0.7719439236164448159272f,\
0.6822088697503370102737f,0.7976066327178688020183f,0.9180538587851772014403f,\
1.0207957462450507613028f,0.0119750831911820069392f,0.879846633700931413102f,\
0.3956357637150365591516f,0.3734519291784937355949f,0.6773972534299040892947f,\
0.6854109454702602688414f,0.0410850121880191737622f,0.3420572770093958103743f,\
0.7391907226260076013702f,0.7159858470768458715838f,1.1108178290074384175767f,\
0.1244362063872984924817f,0.9982082241998391225479f,0.7878214785460178060106f,\
0.2264493394334471387808f,0.552110320407191546010f,0.9872379452017052692270f,\
0.4552134557945506365684f,0.1414727851379618539518f,0.5709593924198277381521f,\
0.8340926447704026802654f,0.1855652888756788854163f,0.8851645482631337324975f,\
0.2589660662395600887464f,0.2440703736645542243355f,0.1844003846229365917164f,\
0.4837426621723381336970f,0.7691827103731639914130f,0.7512840132775820967126f,\
0.7339173856842455823113f,0.2110467570718085883463f,0.9030907830676864200825f,\
0.4374528982447763447716f,0.0206840630038046084660f,0.7498395827082200426617f,\
0.3464215069230207055817f,0.1447328712349580659424f,0.7886833031982384278891f,\
0.312806155477839797907f,0.2330978063822336521227f,0.7502851663968435058649f,\
0.3515894758711366474557f,0.8241207799426445435032f,0.1369007991441129890031f,\
0.5180025607419450617286f,0.3230663992238576032179f,0.2303438195780269093227f,\
0.4935463909681327976387f,0.6513439726551492059414f,0.8480586102235279089001f,\
0.8386806876018545464646f,0.3376822861028858646648f,0.5670539014238122899059f,\
0.4231729333084569000256f,0.3671714099084233406956f,1.13425596729819333497f,\
0.6599735877547936446774f,0.0903505740838268234238f,0.7302185329365624699705f,\
0.3332210660971928195551f,0.7898975683733762132022f,0.4499243250096228718959f,\
0.8312282843326663783756f,0.303017954499597730322f,0.0957670218140728168876f,\
0.7221703011467139887714f,0.7273159314358644822463f,0.2732920828342843555525f,\
0.7451259889709352934872f,0.5326844296662366362583f,0.2613476456913891299294f,\
0.8675343198300645708443f,0.1197200851202140647889f,0.7607940863441885470664f,\
1.090938503691738947765f,0.7940557967113777149137f,0.9951827798045931317006f,\
1.0852570666616287997641f,0.595465988685999203511f,0.9585290107353723332295f,\
0.8162216959679288175167f,0.0552099482904373911607f,0.4388645680780451363567f,\
0.8309698024824113682385f,0.9896452984090404747519f,1.1051208602025746063902f,\
0.0879648640386297558935f,0.7426871822259456523696f,0.2387805138959819828415f,\
0.4109188911191957171987f,0.9129531289726338094681f,1.033237369823349904863f,\
0.8826396237315312642835f,0.6523964780046094258381f,0.2962811673651402077923f,\
0.538613833971326338990f,0.0082053089862361757584f,0.8913512641166435601647f,\
0.0350642631947976693f,0.3204573641970900332865f,0.6295687491907059341045f,\
0.6105613490275437760246f,0.0874124111159134270510f,0.6742190253215021300548f,\
0.104794765122307897975f,0.3057785774947048840211f,0.9391488111872891009213f,\
0.4082750199603700225204f,0.5150095094925122296559f,0.9436041246896892387142f,\
0.1873390728066921528949f,0.686076538028982052531f,0.7482286603321709472780f,\
0.7231441171996566552593f,0.9070157682190420622703f,1.2254699773201918056031f,\
0.7954755918374329937137f,0.7390808722803764441167f,1.1257197223371009364712f,\
0.7479651939595457488252f,0.3663340286526505784615f,0.6321209550080593153609f,\
0.8213953702909778664676f,0.0987172713829019138343f,0.4759918803039691614920f,\
0.6467330123916542605755f,0.5670425014955073894640f,0.7619202005568085356302f,\
0.7400260728625026596106f,0.1896730654043395358777f,0.3096563558430623364082f,\
0.2803008416090244647734f,0.1799702823909465065899f,0.8271151236999281231022f,\
0.1034896632231103036359f,0.4602495369086131438152f,1.2206297477145873209281f,\
0.3787956849306995388282f,0.2930275328196350614896f,0.0417156660446471733161f,\
0.5157276686593796899416f,0.5274236913745330435077f,0.3587249786695337894216f,\
0.2422782860407424743165f,0.8895205282611465813503f,0.4261958074481287384039f,\
0.3516419517981719256028f,0.4713702889404160489839f,0.0595506543369787033626f,\
1.1782482373185512170011f,0.3801066173107530143938f,0.4349822461068365009318f,\
0.1599230612164924403285f,0.7104933564880103746830f,0.9316143186085994454260f,\
0.6420254878605806680980f,0.7971748574811535759110f,0.2207115251543733114303f,\
0.2390631455930626592110f,0.5466671036053578625058f,0.9149528397614811181526f,\
0.0641270748267019075062f,0.9615389273937551273264f,0.4084857821404656030850f,\
0.0284008421665001876966f,0.7926291386522584803132f,0.2762568577554586624068f,\
0.792535972676840283491f,0.407224868689896601914f,0.785264393436451157982f,\
0.5053477011274932761964f,0.3015786475260285870448f,0.7771045707144023095836f,\
0.6452560689270674387785f,0.7038409533210520097057f,0.6044393344259090250503f,\
0.5582751049083489736091f,0.3205680190439157417615f,0.8929464541247862374718f,\
0.5894255515487558660936f,0.3357333458035489104354f,1.0198128299863529200309f,\
1.1643703264707510047771f,0.3357866330198117088557f,0.8154766229713432679205f,\
0.9578920067258681614320f,0.5149424663113579825335f}




void ssinhsTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out;
	int i;

	for (i=0;i<200;i++){
		out=ssinhs(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<1e-6);
	}
}

void csinhsTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=FloatComplex(inR[i],inI[i]);
		out=csinhs(in);
		assert(( (fabs(creals(out)-resR[i]))/(fabs(creals(out))) )<1e-6);	
		assert(( (fabs(cimags(out)-resI[i]))/(fabs(cimags(out))) )<1e-6);			
	}
}

void ssinhaTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out[200];
	int i,j;
	j=1;
	ssinha(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<1e-6);
	}
}

void csinhaTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex *in,out[200];
	int i;

	in=FloatComplexMatrix(inR,inI,200);
	csinha(in,200,out);

	for (i=0;i<200;i++){
		assert(( (fabs(creals(out[i])-resR[i]))/(fabs(creals(out[i]))) )<1e-6);	
		assert(( (fabs(cimags(out[i])-resI[i]))/(fabs(cimags(out[i]))) )<1e-6);			
	}
}

int testSinh() {
  printf("\n>>>> Hyperbolic Sine Tests\n");
  ssinhsTest();
  csinhsTest();
  ssinhaTest();
  csinhaTest();
  return 0;
}

int main() {
  assert(testSinh() == 0);
  return 0;
}
