/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testSqrt.h"

#define SOURCE {0.7062616096809506416321,0.4090520101599395275116,0.3011248558759689331055,\
0.1880126395262777805328,0.1796709178015589714050,0.2828889950178563594818,\
0.7232380937784910202026,0.7360379849560558795929,0.1852612206712365150452,\
0.7703790138475596904755,0.1914967410266399383545,0.7521587223745882511139,\
0.6205883463844656944275,0.2807604051195085048676,0.2289868686348199844360,\
0.5049233403988182544708,0.8354099662974476814270,0.8174716415815055370331,\
0.0030740275979042053223,0.3677616142667829990387,0.8278525872156023979187,\
0.72754097869619727135,0.5323124285787343978882,0.9267726917751133441925,\
0.9542504185810685157776,0.3162104780785739421845,0.5789009965956211090088,\
0.6881225542165338993073,0.3714061146602034568787,0.1705444059334695339203,\
0.1954363007098436355591,0.978800852317363023758,0.9300233917310833930969,\
0.5357720064930617809296,0.3947123587131500244141,0.1344871171750128269196,\
0.7380615202710032463074,0.588114650454372167587,0.9113173168152570724487,\
0.5682763461954891681671,0.1127616921439766883850,0.9478473584167659282684,\
0.5237770043313503265381,0.8140139640308916568756,0.1400952627882361412048,\
0.2763446993194520473480,0.9059953633695840835571,0.1379901585169136524200,\
0.5603838684037327766419,0.3008610638789832592011,0.4767417535185813904,\
0.8127435916103422641754,0.1988414181396365165710,0.1107953130267560482025,\
0.2159351315349340438843,0.6467244853265583515167,0.6597879612818360328674,\
0.0691898013465106487274,0.9164751060307025909424,0.8635670826770365238190,\
0.5032854294404387474060,0.1832137755118310451508,0.8403698671609163284302,\
0.9247214836068451404572,0.6229452537372708320618,0.2773811477236449718475,\
0.2479109913110733032227,0.3891948559321463108063,0.0436578569933772087097,\
0.8132526441477239131928,0.7686451207846403121948,0.4041520212776958942413,\
0.8579940209165215492249,0.6993723283521831035614,0.0828925184905529022217,\
0.9201254160143435001373,0.5200281282886862754822,0.9351884997449815273285,\
0.8825624976307153701782,0.2245844271965324878693,0.2153332801535725593567,\
0.4327089670114219188690,0.5800157263875007629395,0.8876141034997999668121,\
0.5258982880041003227234,0.859640696551650762558,0.7337234076112508773804,\
0.7134532411582767963409,0.1087165409699082374573,0.8477638359181582927704,\
0.6594733335077762603760,0.7916418449021875858307,0.6067967480048537254334,\
0.4102901122532784938812,0.1958728153258562088013,0.241527963895350694656,\
0.5113455550745129585266,0.9119556057266891002655,0.0928984880447387695313,\
0.7438839026726782321930,0.1938720373436808586121,0.4355978979729115962982,\
0.9922429900616407394409,0.4533818070776760578156,0.8269640663638710975647,\
0.8889675955288112163544,0.4682085178792476654053,0.3856786251999437808991,\
0.4124865522608160972595,0.6955242282710969448090,0.0978972557932138442993,\
0.8728604433126747608185,0.6359515609219670295715,0.4129665228538215160370,\
0.0294486805796623229980,0.1809961968101561069489,0.7658103061839938163757,\
0.1232470511458814144135,0.0170737411826848983765,0.8835507561452686786652,\
0.3164170170202851295471,0.9378212536685168743134,0.3916359134018421173096,\
0.0844073877669870853424,0.6934146797284483909607,0.4618808380328118801117,\
0.9355291295796632766724,0.0842495900578796863556,0.5402926551178097724915,\
0.5613215523771941661835,0.1306025832891464233398,0.5840523042716085910797,\
0.0048661706969141960144,0.2761953338049352169037,0.7478824090212583541870,\
0.0194325004704296588898,0.6444276878610253334045,0.2243968318216502666473,\
0.2478402368724346160889,0.1196091384626924991608,0.1883201440796256065369,\
0.3393343067727982997894,0.959958622232079505920,0.2847225037403404712677,\
0.8766820700839161872864,0.2853349032811820507050,0.5103433504700660705566,\
0.8752629184164106845856,0.5941145820543169975281,0.3945342986844480037689,\
0.4661326166242361068726,0.0073588271625339984894,0.5170202488079667091370,\
0.4690007264725863933563,0.6654530800879001617432,0.9476742581464350223541,\
0.4933638339862227439880,0.2918433747254312038422,0.2016727942973375320435,\
0.7016656589694321155548,0.8736049132421612739563,0.191055159550160169601,\
0.5307010114192962646484,0.8889481076039373874664,0.0115523664280772209167,\
0.4998398735187947750092,0.6700848620384931564331,0.4995208983309566974640,\
0.1538907447829842567444,0.2571737091057002544403,0.9586529098451137542725,\
0.6246025026775896549225,0.9371285131201148033142,0.9923511571250855922699,\
0.3454555813223123550415,0.7558249053545296192169,0.2107181670144200325012,\
0.9372652801685035228729,0.6767524704337120056152,0.7465373151935636997223,\
0.4050982249900698661804,0.5101723610423505306244,0.9497965183109045028687,\
0.0289692510850727558136,0.1634070957079529762268,0.4146909262053668498993,\
0.0021650679409503936768,0.1810030029155313968658,0.4556188201531767845154,\
0.1977851442061364650726,0.6053877938538789749146,0.4363054675050079822540,\
0.8938506888225674629211,0.6104825991205871105194,0.4316215068101882934570,\
0.2315693595446646213532,0.4675927339121699333191,0.6150764389894902706146,\
0.8621218334883451461792,0.3846137975342571735382}

#define RESULT {0.8403937230137732417035,0.6395717396507912821946,0.5487484449872901404177,\
0.4336042429754092819572,0.4238760641998542411102,0.5318731004834296172135,\
0.8504340619815806689985,0.8579265615168094605281,0.4304198190967006287799,\
0.8777123753528599525708,0.4376034060957934568314,0.8672708471836166888025,\
0.7877742991393319460514,0.5298682903510159025728,0.4785257241098120895018,\
0.7105795806233234923610,0.9140076401745489409478,0.9041413836239913237591,\
0.0554439139843518405404,0.6064335200718896645711,0.9098640487543193655640,\
0.8529601272604701023283,0.7295974428263399813588,0.9626903405431641580492,\
0.9768574197809363202083,0.5623259535879292503324,0.7608554373832265849131,\
0.8295315269575556094139,0.6094309761246169410143,0.4129702240276767466476,\
0.4420817805676271472493,0.9893436472315183527471,0.9643772040706288795064,\
0.7319644844478875311822,0.6282613777029032453569,0.3667248521371476721598,\
0.8591050694012946076228,0.7668863347683098075081,0.9546294133407251525370,\
0.7538410616273759634609,0.3358000776414095667199,0.9735745263803721183393,\
0.7237243980489743711004,0.9022272241685526106281,0.3742930172849022740778,\
0.5256849810670379818944,0.9518378871265757990017,0.3714702659930047001780,\
0.7485879162822044463610,0.5485080344707662369785,0.6904648821761910637562,\
0.9015229290541324491670,0.4459163802100529760963,0.3328592991441819970433,\
0.4646882089476060961886,0.8041918212258555298533,0.8122733291705668268179,\
0.2630395433133783655855,0.9573270632499127907877,0.9292831014696417701870,\
0.709426126838051174239,0.4280347830630485406189,0.9167168958631211062027,\
0.9616243984045148573969,0.7892688095555726590646,0.5266698659726460896025,\
0.4979066090253003729060,0.6238548356245596782088,0.2089446266200143398351,\
0.9018052140832431007311,0.8767240847522328461849,0.6357295189604584839671,\
0.9262796666863207795117,0.8362848368541564436640,0.2879106085064475628599,\
0.9592316800514584240744,0.7211297582881227574703,0.9670514462762472840396,\
0.9394479749463060525017,0.4739033943711866703197,0.4640401708403837921502,\
0.6578061773892229791017,0.7615876353956259059430,0.9421327419741869491077,\
0.7251884499935863370723,0.9271681058749005055475,0.8565765626091171869305,\
0.8446616134040167978014,0.3297219146036675652134,0.9207409168263124277232,\
0.8120796349544644465723,0.8897425722658142133170,0.7789715964044220397611,\
0.6405389232929397103078,0.4425752086661161044390,0.4914549459465747394127,\
0.7150842992784227636349,0.9549636672285962690765,0.3047925327903207581848,\
0.8624870449303445596456,0.4403090248265198458633,0.6599984075533149585624,\
0.9961139443164325202318,0.6733363253810654702747,0.9093756464541323802919,\
0.9428507811572365282515,0.6842576399860272884368,0.6210302933029465677350,\
0.6422511597971747310254,0.8339809519833752959883,0.3128853716510470728274,\
0.9342700055726260721656,0.7974657114396624946195,0.6426247138523553115164,\
0.1716061787339323019275,0.4254364779966053888849,0.8751058828416100610070,\
0.351065593793925379007,0.1306665266343484677059,0.939973806095291464224,\
0.5625095706032787745698,0.9684117170235585492222,0.6258082081611283653544,\
0.2905294955197958439719,0.8327152452840337337747,0.6796181560500071938691,\
0.967227547984270019654,0.2902577993058579330921,0.7350460224488054583603,\
0.7492139563417076209,0.3613897941131520297198,0.7642331478492728757956,\
0.0697579436115643852778,0.5255428943530063845557,0.8648019478593109710118,\
0.1394005038385071892915,0.8027625351628122629677,0.4737054272664081300270,\
0.4978355520374520559734,0.3458455413370143394225,0.4339586893698818559351,\
0.5825240825689512735863,0.9797747813819661644175,0.5335939502471336304268,\
0.9363130192857067601864,0.5341674861700046461621,0.7143831958200487219912,\
0.9355548719430681892106,0.7707882861423861475814,0.628119653158892954359,\
0.6827390545620164452600,0.0857836066071717417980,0.7190412010503756112811,\
0.6848362771294949080669,0.8157530754388242488773,0.9734856229788064752029,\
0.7023986289751872336140,0.5402252999679219014340,0.4490799419895499244859,\
0.8376548567097501507561,0.9346683439820572258938,0.4370985696043401258493,\
0.7284922864514739027086,0.9428404465252524513375,0.1074819353569576446672,\
0.7069935455991057660086,0.8185871132863582477768,0.7067679239545019420632,\
0.3922891086723976905581,0.5071229723703120084721,0.9791082217227642381374,\
0.7903179756766194330453,0.9680539825444213208883,0.9961682373600784234924,\
0.5877546948534841941836,0.8693819099535771144360,0.4590404851583572698459,\
0.9681246201644205795489,0.8226496644585178374953,0.8640239089247262471716,\
0.6364732712298842853826,0.7142635095273666134830,0.9745750449867390807768,\
0.1702035577920530950991,0.4042364354037782381290,0.643965003866954543987,\
0.0465302905745321321307,0.4254444768892075012801,0.6749954223201641845265,\
0.444730417450995230144,0.7780667027022033499506,0.6605342288670648098758,\
0.9454367714567524227931,0.7813338589364902109224,0.6569790763869031158251,\
0.4812165412209607473493,0.6838075269490457852584,0.7842680912733159814820,\
0.9285051607225159875370,0.6201723933990106463199}

#define ZSOURCER {0.6045256052166223526001,0.9455216196365654468536,0.4476299257948994636536,\
0.8624908211641013622284,0.1751048639416694641113,0.2067177616991102695465,\
0.6848411662504076957703,0.1348653226159512996674,0.0069159921258687973022,\
0.1496290047653019428253,0.5665438110008835792542,0.4359452719800174236298,\
0.6547604538500308990479,0.3381605879403650760651,0.4259321158751845359802,\
0.3060420057736337184906,0.7704779822379350662231,0.7058695447631180286408,\
0.2373670237138867378235,0.8205849635414779186249,0.6789963841438293457031,\
0.5250809141434729099274,0.3359806565567851066589,0.8941988362930715084076,\
0.5461782198399305343628,0.7568633262999355792999,0.0259526828303933143616,\
0.3250150899402797222138,0.6072143577039241791,0.8756139636971056461334,\
0.2962085595354437828064,0.4229678637348115444183,0.4243144039064645767212,\
0.7620028969831764698029,0.3622896494343876838684,0.5658242437057197093964,\
0.6424440070986747741699,0.7580267959274351596832,0.2531452132388949394226,\
0.5266989110969007015228,0.2118590380996465682983,0.4779220153577625751495,\
0.1615962767973542213440,0.9168031658045947551727,0.5461866445839405059815,\
0.4686870560981333255768,0.7772213732823729515076,0.5871783248148858547211,\
0.5848031807690858840942,0.3139644009061157703400,0.3204141603782773017883,\
0.3331634956412017345429,0.2282590121030807495117,0.2750317254103720188141,\
0.4963629124686121940613,0.7453477247618138790131,0.1155001949518918991089,\
0.0626524840481579303741,0.0877018878236413002014,0.5507565210573375225067,\
0.2116370312869548797607,0.8335358710028231143951,0.4045845707878470420837,\
0.2880227542482316493988,0.1750094983726739883423,0.0051561561413109302521,\
0.3109287889674305915833,0.6602919283322989940643,0.9722995534539222717285,\
0.9826813959516584873200,0.0455837054178118705750,0.4096118300221860408783,\
0.7104403134435415267944,0.3917615194804966449738,0.5571686858311295509338,\
0.0565565521828830242157,0.1540721096098423004150,0.9109257892705500125885,\
0.5713340407237410545349,0.3488348922692239284515,0.8972954172641038894653,\
0.2973396372981369495392,0.1091936426237225532532,0.7626331257633864879608,\
0.6584706604480743408203,0.6996708759106695652008,0.6756794182583689689636,\
0.9004421546123921871185,0.6668148916214704513550,0.8518152837641537189484,\
0.8365677157416939735413,0.1291190306656062602997,0.6095453463494777679443,\
0.2412315667606890201569,0.4029275467619299888611,0.3019328541122376918793,\
0.1083198729902505874634,0.8456356939859688282013,0.9417407037690281867981,\
0.9083450469188392162323,0.1937242373824119567871,0.5318046086467802524567,\
0.8314437521621584892273,0.4952740012668073177338,0.7465563025325536727905,\
0.7102393140085041522980,0.5811418974772095680237,0.7035941029898822307587,\
0.3746570833027362823486,0.3394373343326151371002,0.6322447275742888450623,\
0.7636191300116479396820,0.6940386760979890823364,0.8735245508141815662384,\
0.3612738298252224922180,0.7933200257830321788788,0.4830590635538101196289,\
0.2469964125193655490875,0.5025922833010554313660,0.7430270477198064327240,\
0.6783937942236661911011,0.4903185223229229450226,0.709806025959551334381,\
0.3303662906400859355927,0.6815545372664928436279,0.0701365978457033634186,\
0.4745870968326926231384,0.8091805852018296718597,0.9447045121341943740845,\
0.5478458073921501636505,0.1216687532141804695129,0.9161847713403403759003,\
0.3045207932591438293457,0.6502694808878004550934,0.0987624628469347953796,\
0.8391053467057645320892,0.0328534897416830062866,0.3461971958167850971222,\
0.2801467711105942726135,0.5500544901005923748016,0.0729318000376224517822,\
0.0225322381593286991119,0.50267804320901632309,0.3478884599171578884125,\
0.4298669416457414627075,0.3537984383292496204376,0.0529730813577771186829,\
0.9533003675751388072968,0.1842019557952880859375,0.958756382111459970474,\
0.3245136169716715812683,0.0003973259590566158295,0.0972583871334791183472,\
0.4378789965994656086,0.3634226778522133827210,0.2685119728557765483856,\
0.2770298384130001068115,0.8854365111328661441803,0.5216628303751349449158,\
0.4979983693920075893,0.8733724001795053482056,0.4699407932348549365997,\
0.9364062966778874397278,0.1337622734718024730682,0.2712419554591178894043,\
0.1766990595497190952301,0.0543269468471407890320,0.8402757882140576839447,\
0.7507283594459295272827,0.3062269617803394794464,0.9195641661062836647034,\
0.1318263853900134563446,0.0826364941895008087158,0.8222710476256906986237,\
0.4441085970029234886169,0.9617503038607537746429,0.0283641982823610305786,\
0.1431905967183411121368,0.3793597565963864326477,0.6144003230147063732147,\
0.2128270715475082397461,0.4704488315619528293610,0.2076055286452174186707,\
0.7435979112051427364349,0.3391801547259092330933,0.2479635034687817096710,\
0.6721735307946801185608,0.9013197491876780986786,0.2140864841639995574951,\
0.8460668534971773624420,0.1650043567642569541931,0.4003686285577714443207,\
0.5522825215011835098267,0.0638249483890831470490,0.6903966935351490974426,\
0.8547787251882255077362,0.0291904583573341369629,0.5434663915075361728668,\
0.6236743135377764701843,0.2417052476666867733002}
#define ZSOURCEI {0.5503273960202932357788,0.6906704087741672992706,0.9835249418392777442932,\
0.8285484607331454753876,0.2062614001333713531494,0.1944643096067011356354,\
0.4367609983310103416443,0.8090620837174355983734,0.8818644303828477859497,\
0.7404803228564560413361,0.7542522149160504341126,0.9921960639767348766327,\
0.9886121451854705810547,0.0113218077458441257477,0.9367801276966929435730,\
0.3874237253330647945404,0.2886805813759565353394,0.567788839805871248245,\
0.7295644441619515419006,0.0303032915107905864716,0.2795897088944911956787,\
0.7047131718136370182037,0.7442112853750586509705,0.8920237845741212368012,\
0.1081438604742288589478,0.8751525697298347949982,0.9068333031609654426575,\
0.2166852983646094799042,0.4824190363287925720215,0.7766945236362516880035,\
0.4510916722938418388367,0.1300636469386518001556,0.5505470838397741317749,\
0.6936193336732685565949,0.1749099576845765113831,0.8636093880049884319305,\
0.2150467522442340850830,0.1886725709773600101471,0.1796098565682768821716,\
0.4374312213622033596039,0.8514516223222017288208,0.7381969136185944080353,\
0.8102188156917691230774,0.1460137623362243175507,0.8999849110841751098633,\
0.4043733575381338596344,0.0156995235010981559753,0.6904196902178227901459,\
0.2990311514586210250855,0.1383218024857342243195,0.8478512773290276527405,\
0.3007262717001140117645,0.229154746979475021362,0.8078110129572451114655,\
0.3176332255825400352478,0.6924462593160569667816,0.1364154014736413955689,\
0.5433279541321098804474,0.3276594849303364753723,0.2006831648759543895721,\
0.5037304237484931945801,0.4962565028108656406403,0.8996161324903368949890,\
0.9357709079049527645111,0.3390339072793722152710,0.6029155333526432514191,\
0.4153500730171799659729,0.3041478390805423259735,0.8489827848970890045166,\
0.4482063786126673221588,0.0903797810897231101990,0.7382151386700570583344,\
0.2669597584754228591919,0.8226196658797562122345,0.3985779182985424995422,\
0.9789295899681746959686,0.3041231036186218261719,0.0663515278138220310211,\
0.6667758254334330558777,0.7548807277344167232513,0.1922533493489027023315,\
0.7942791883833706378937,0.5580398896709084510803,0.2016023616306483745575,\
0.787146832793951034546,0.0955459238030016422272,0.6623697867617011070252,\
0.864868474658578634262,0.7013061288744211196899,0.8015053984709084033966,\
0.9135685982182621955872,0.6317234965972602367401,0.9346773549914360046387,\
0.9157753759063780307770,0.0510348035022616386414,0.4329969524405896663666,\
0.9721843507140874862671,0.8001508046872913837433,0.8452261472120881080627,\
0.0610524858348071575165,0.8168097324669361114502,0.2101262793876230716705,\
0.3055453812703490257263,0.9465212575159966945648,0.9269728232175111770630,\
0.7737778765149414539337,0.5893978821113705635071,0.2377697187475860118866,\
0.5269544571638107299805,0.0077543654479086399078,0.8311711428686976432800,\
0.0268517597578465938568,0.2591186594218015670776,0.4641277943737804889679,\
0.6098861405625939369202,0.0656952331773936748505,0.6466812007129192352295,\
0.1018534512259066104889,0.2742705782875418663025,0.8162728524766862392426,\
0.3357750270515680313110,0.4765891996212303638458,0.8440040023997426033020,\
0.1785074654035270214081,0.5855625644326210021973,0.8426241897977888584137,\
0.7058847947046160697937,0.7396617024205625057221,0.9751448985189199447632,\
0.7606669445522129535675,0.8236690396443009376526,0.8889620001427829265595,\
0.7960178293287754058838,0.3052428201772272586823,0.6803312664851546287537,\
0.6412069997750222682953,0.0988248009234666824341,0.4654508423991501331329,\
0.6714970665052533149719,0.5131103205494582653046,0.8631567060947418212891,\
0.8328299173153936862946,0.1687975851818919181824,0.2961277081631124019623,\
0.2591485660523176193237,0.1700844173319637775421,0.9718958893790841102600,\
0.0695185582153499126434,0.4696230851113796234131,0.9544191421009600162506,\
0.3679352095350623130798,0.2973918146453797817230,0.0415310803800821304321,\
0.4892336544580757617950,0.5171590568497776985169,0.3534862431697547435761,\
0.2354387864470481872559,0.6779259913600981235504,0.3834532154724001884460,\
0.3174350797198712825775,0.3418120350688695907593,0.0535557498224079608917,\
0.9285596096888184547424,0.3862650538794696331024,0.4328473098576068878174,\
0.1581165478564798831940,0.7887120461091399192810,0.7448797873221337795258,\
0.5185996759682893753052,0.8651678604073822498322,0.1524438308551907539368,\
0.2392775672487914562225,0.5761575847864151000977,0.7395762302912771701813,\
0.0583172617480158805847,0.6962534948252141475678,0.4206145536154508590698,\
0.0281158541329205036163,0.8313249954953789710999,0.2333360086195170879364,\
0.8865877203643321990967,0.3746785433031618595123,0.87671328987926244736,\
0.4027077830396592617035,0.2890332732349634170532,0.8538430598564445972443,\
0.5499771209433674812317,0.5128610017709434032440,0.6321087554097175598145,\
0.4165538274683058261871,0.3217771751806139945984,0.9717370062135159969330,\
0.5348322447389364242554,0.3416590173728764057159,0.9565287167206406593323,\
0.9951003189198672771454,0.3422884084284305572510,0.7870580093003809452057,\
0.9234123295173048973084,0.5238970420323312282562}

#define ZRESULTR {0.8432166939003225003546,1.028696846310626300536,0.8741363651656853805960,\
1.0145139259460289604675,0.4720540083473970804917,0.4952416659876168192334,\
0.8651884064428800868996,0.6910466586042781633736,0.6666361606264414874090,\
0.6727093940540614935841,0.8688705649614124615354,0.8716907101266159196840,\
0.959306172735902795701,0.5815972201878681913101,0.8529353171823288448650,\
0.6323612148789939935156,0.8925417496893577329331,0.8977079570170535260942,\
0.7087222819700315090685,0.9060158028150111508836,0.8406257183559593393341,\
0.8378258601984284181796,0.7591172919619637582400,1.0385687027372507706957,\
0.7426169311676505957465,0.9782382399865202637912,0.6830656191716251157686,\
0.5981803109332550771882,0.8314861127635455595453,1.011450539647472002258,\
0.6464748892519300849102,0.6578303557631125508820,0.7481312014375646191056,\
0.9466832738110327882808,0.6183009489366241284714,0.8939481166511646925699,\
0.8123805134131761862548,0.8772630865325246052322,0.5308180535125875953995,\
0.7782537556049359261934,0.7379946979653042582470,0.8238088030668070382845,\
0.7027705686531833251252,0.9605105126328297160399,0.8941312697312054913468,\
0.7374641482216017784879,0.8816465539160547315589,0.8641531635219484863697,\
0.7879164327234249309839,0.5731702653710250006114,0.7831953532687397911971,\
0.6252910190572938953224,0.5252142434850843866201,0.7511253936013374543634,\
0.7367688115224660938551,0.9388049677540464266201,0.3835650562588603929015,\
0.5520782622396902539208,0.4620041004215187374626,0.753968196415999991622,\
0.6156379639362553612969,0.9496353272389349564620,0.8339637612267859489990,\
0.7959636817154828181131,0.5275172507857687209665,0.5514044508846071002139,\
0.6441142487726253529345,0.8328463321559912424519,1.0637408773050947008443,\
1.0155667426713801404503,0.2709318224164963262446,0.7917869572241151843173,\
0.8571412685012261833961,0.8071256937996567071281,0.7881067116954072471202,\
0.7201105910271731191941,0.4974916923152819525633,0.9550562531126176590846,\
0.8512952675658871370956,0.7682506551752034118508,0.9526163214553304836585,\
0.756785792150606484441,0.5821581994240766499971,0.8807562498788572558084,\
0.9178011959841433364815,0.8384018774833429388238,0.9005192643641398708709,\
1.0365709563884744071061,0.9040270806600297914812,1.0053433947417824700921,\
1.0186506185399304413863,0.6220542372412505294221,0.9288207542994831866778,\
0.7707938959111726440199,0.63603233719709606486,0.6441295538205468185211,\
0.7370617546735380720691,1.0024537010421461502574,1.0505138587196660715506,\
0.953608813532313304151,0.7187463572209089601728,0.7428380749761755996730,\
0.9266208094400342210051,0.8841784551932333480195,0.9840672842877067338918,\
0.9382321956452510658409,0.8393030146072417707615,0.8503757458476615127552,\
0.7145712412765103938028,0.5826505086380492359766,0.9155742917376128442442,\
0.8739880489156448550858,0.8470155698847267045082,0.9650636753683585755681,\
0.7314820521682621201620,0.8914470068047345430173,0.8031939281911506522960,\
0.5070351579739499348065,0.7331953647718203459505,0.9609459795569127438242,\
0.847153172323739211969,0.7661900708888577105071,0.9519994233321562582262,\
0.5940854373891888418058,0.8888500969738630796968,0.6766367900740852814323,\
0.8139959478095014633325,0.9760840415848224260742,1.0729430743093604228022,\
0.8617604247210989276695,0.6907515785500089045002,1.0470820008330794514961,\
0.7605256422767727730872,0.8272295000550387022997,0.6269868176753693456149,\
0.9734363297756469801669,0.2617213661737881613689,0.6805441931353264362059,\
0.709837674958288866733,0.8069322418000910435154,0.6852606023040614946496,\
0.6540897892889659948068,0.7186585042731442607433,0.6343284289266235553839,\
0.6825711485307393022737,0.610883282746898181870,0.7163489185444231743816,\
0.9770189769897136278232,0.5867956626396594321804,1.0750765659376522176416,\
0.6384005820717564283484,0.3858687639762184984349,0.3186007968636310749844,\
0.7397471191545493818254,0.7055161810773808994668,0.5968318319385850223569,\
0.5659466952073320955563,1.0001490762521170196919,0.7645570771657418385203,\
0.7377545989844320750706,0.9516433749813681952645,0.6866306949128065939547,\
1.0618728756326238915619,0.5208322311777507929165,0.6253215357738258761700,\
0.4548702015131091402900,0.6499645432009629741899,0.9907517258725765385563,\
0.9119111641770327736367,0.7823013339720715775272,0.9622054437069111898495,\
0.4500082630180006204590,0.5764937377448445809947,0.9818886833563331695274,\
0.6678434466414240322507,1.0365982590716655842300,0.4743068831608843738401,\
0.3802074434441635730764,0.8040992937118037753308,0.7973759350671048018455,\
0.7498672536100723373664,0.7320754444197923316295,0.7445011903920762952325,\
0.8914147503382092718738,0.6264212402370327170686,0.7540169824914779717062,\
0.8776882812655947274649,0.9844634271419567816963,0.6638769890354155878143,\
0.9458113966252766902088,0.5131381594621587938221,0.8518664381177757372043,\
0.812738510298055549796,0.4535385196962208320670,0.9669683162928227604382,\
1.040816644093084830658,0.4316950876741513232204,0.8660041994184899394327,\
0.9321942634710010944232,0.6397933456564963705660}

#define ZRESULTI {0.3263261982366231217512,0.3357016264078308553920,0.5625695149136477057894,\
0.4083475049199193351868,0.2184722473340149073717,0.1963327431456096394680,\
0.2524080275917597870894,0.5853888978723345015709,0.6614285891378552939557,\
0.5503716236174250875379,0.4340417579628489397337,0.5691216233293430182272,\
0.5152745668080026542057,0.0097333750513688352402,0.5491507438051371758903,\
0.3063310306018693363050,0.1617182509817773616856,0.3162436265422815528936,\
0.5147040404416135528365,0.0167233791158154128376,0.1662985694996903240917,\
0.4205606470816827258119,0.4901820135407665146587,0.4294486162653968763792,\
0.0728126817040040535955,0.4473105496989639440209,0.6637966234200971538115,\
0.1811203866159907804878,0.2900944639504645650163,0.3839508177567231839156,\
0.3488856874362309956617,0.0988580458466166156484,0.36794821735938526563,\
0.3663418129703439607425,0.1414440314101028384197,0.4830310461641617592044,\
0.1323559272370566086696,0.1075347714236491863948,0.1691821287725076283781,\
0.2810338004872128814249,0.5768683871779194394236,0.4480389811753019424501,\
0.5764461773381487352808,0.0760084144919923321293,0.5032733679892044120763,\
0.2741647566958217985267,0.0089035245651246392590,0.3994776154055512673580,\
0.1897607024294587774183,0.1206637982137782894032,0.5412770094909528095784,\
0.2404690476392074838241,0.2181535914362372208242,0.5377337924125580315149,\
0.2155582732432577419690,0.3687913267931641758679,0.1778256377212544814270,\
0.4920751198642726587096,0.3546066849097115891709,0.1330846352869425042176,\
0.4091125411822805202355,0.2612879326286920989020,0.5393616451432939884469,\
0.5878226164089255245671,0.3213486447830481429477,0.5467089832022555828672,\
0.3224195659455129092663,0.1825954124653428600755,0.3990552600779624370375,\
0.2206681056892876025000,0.1667943253834255346035,0.4661703075143642238665,\
0.1557268144037805002178,0.5095982399018667008406,0.2528705265313027639174,\
0.6797078130539779827757,0.3056564645363825660773,0.0347369736586594715644,\
0.3916242993690946527785,0.4912984601114738780758,0.1009080702371304705256,\
0.5247714720741629701450,0.4792854332576366727,0.1144484422667324668987,\
0.4288220783749939757357,0.0569809815370433195292,0.36777102554791152311,\
0.4171776516254488420543,0.3878789385171945158781,0.3986227007920866149959,\
0.4484209706404114204048,0.5077720388168175391641,0.5031527077021280547342,\
0.5940468527088033079409,0.0401196609964555792049,0.3361101426509159328937,\
0.6594999296529031607150,0.3990961397296745039043,0.4022917642620268408038,\
0.0320112843801534235899,0.5682183459163515637513,0.1414347799783703119037,\
0.1648707746240843652341,0.5352546490793753664050,0.470990570471244762718,\
0.4123594778064457178068,0.3511234154134331153507,0.1398027400878979753518,\
0.3687207284066310042370,0.0066543882936226537647,0.4539069906010949617681,\
0.0153616286808277956177,0.1529597971009351853322,0.2404648554390081682808,\
0.4168838721023755411466,0.0368475258068726510552,0.4025685317176705413367,\
0.1004402255189763004672,0.1870378561196294198155,0.4247235900050622126045,\
0.1981784628926891167478,0.3110123830424602608957,0.4432796815388754252396,\
0.1502372000465193591090,0.3293933175156303350128,0.6226562035634579661547,\
0.4335923272125510874453,0.3788924267318253269465,0.4544252728163645227433,\
0.4413447883722416142938,0.5962122022024949341557,0.4244949294494160807467,\
0.5233339844701030418861,0.1844970592543655196760,0.5425403272492764772395,\
0.3293523059298621991076,0.1887977324286261304742,0.3419695936679567616068,\
0.4729933970782203567218,0.3179389135603382654516,0.6298017886863316316948,\
0.6366327153805051430879,0.1174393569255921254690,0.2334182851178558948391,\
0.1898326398721546515169,0.1392118774041107009953,0.6783676670817878617825,\
0.0355768720222523482377,0.4001589607861217867679,0.4438842647772449079291,\
0.2881695442233370707541,0.3853535740764292283345,0.0651773014834273051177,\
0.330676282333628224208,0.3665111238554681349910,0.2961355479495680342872,\
0.2080043831343482141350,0.3389124718789456314205,0.2507682074527933790975,\
0.2151359545279972751430,0.1795904033249649811577,0.0389989482113152971521,\
0.4372272948094740319114,0.3708152364207700224519,0.3460997943417740696503,\
0.1738040295127169787559,0.6067346706520863053314,0.3759164722454063634061,\
0.2843476954448227456140,0.5529633038042787163136,0.0792158430677229186134,\
0.2658590818355930918138,0.4997084504683915184842,0.3766089999954101985580,\
0.0436608774416314404654,0.3358357438535300443228,0.4433991668140928599229,\
0.0369743604678396259322,0.5169293158173903224295,0.1463149302341813229322,\
0.5911631132684145306655,0.2559015919459735610708,0.5887924030165481159571,\
0.2258812650827625445604,0.2307020058304501131108,0.5661961730855942231955,\
0.3133100513489369687292,0.2604774274143707435414,0.4760737048049700770314,\
0.2202097738273190163927,0.3135385365979036498274,0.5703576069745146526202,\
0.3290309478154280209417,0.3766593161719967164380,0.4946018916047810187742,\
0.4780382426469301782035,0.3964469578199069088598,0.4544192798538850830425,\
0.4952896438554572622337,0.4094267669310915347403}




void dsqrtsTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out;
	int i;

	for (i=0;i<200;i++){
		out=dsqrts(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<3e-16);
	}
}

void zsqrtsTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=DoubleComplex(inR[i],inI[i]);
		out=zsqrts(in);
		assert(( (fabs(zreals(out)-resR[i]))/(fabs(zreals(out))) )<3e-16);	
		assert(( (fabs(zimags(out)-resI[i]))/(fabs(zimags(out))) )<3e-16);			
	}
}

void dsqrtaTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out[200];
	int i;

	dsqrta(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<1e-16);
	}
}

void zsqrtaTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex *in,out[200];
	int i;


	in=DoubleComplexMatrix(inR,inI,200);
	zsqrta(in,200,out);

	for (i=0;i<200;i++){
		assert(( (fabs(zreals(out[i])-resR[i]))/(fabs(zreals(out[i]))) )<3e-16);	
		assert(( (fabs(zimags(out[i])-resI[i]))/(fabs(zimags(out[i]))) )<3e-16);			
	}
}


int testSqrt() {
  printf("\n>>>> Double Square Root Tests\n");
  dsqrtsTest();
  zsqrtsTest();
  dsqrtaTest();
  zsqrtaTest();

  return 0;
}

int main() {
  assert(testSqrt() == 0);
  return 0;
}
