/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testSqrt.h"

#define SOURCE {0.7062616096809506416321f,0.4090520101599395275116f,0.3011248558759689331055f,\
0.1880126395262777805328f,0.1796709178015589714050f,0.2828889950178563594818f,\
0.7232380937784910202026f,0.7360379849560558795929f,0.1852612206712365150452f,\
0.7703790138475596904755f,0.1914967410266399383545f,0.7521587223745882511139f,\
0.6205883463844656944275f,0.2807604051195085048676f,0.2289868686348199844360f,\
0.5049233403988182544708f,0.8354099662974476814270f,0.8174716415815055370331f,\
0.0030740275979042053223f,0.3677616142667829990387f,0.8278525872156023979187f,\
0.72754097869619727135f,0.5323124285787343978882f,0.9267726917751133441925f,\
0.9542504185810685157776f,0.3162104780785739421845f,0.5789009965956211090088f,\
0.6881225542165338993073f,0.3714061146602034568787f,0.1705444059334695339203f,\
0.1954363007098436355591f,0.978800852317363023758f,0.9300233917310833930969f,\
0.5357720064930617809296f,0.3947123587131500244141f,0.1344871171750128269196f,\
0.7380615202710032463074f,0.588114650454372167587f,0.9113173168152570724487f,\
0.5682763461954891681671f,0.1127616921439766883850f,0.9478473584167659282684f,\
0.5237770043313503265381f,0.8140139640308916568756f,0.1400952627882361412048f,\
0.2763446993194520473480f,0.9059953633695840835571f,0.1379901585169136524200f,\
0.5603838684037327766419f,0.3008610638789832592011f,0.4767417535185813904f,\
0.8127435916103422641754f,0.1988414181396365165710f,0.1107953130267560482025f,\
0.2159351315349340438843f,0.6467244853265583515167f,0.6597879612818360328674f,\
0.0691898013465106487274f,0.9164751060307025909424f,0.8635670826770365238190f,\
0.5032854294404387474060f,0.1832137755118310451508f,0.8403698671609163284302f,\
0.9247214836068451404572f,0.6229452537372708320618f,0.2773811477236449718475f,\
0.2479109913110733032227f,0.3891948559321463108063f,0.0436578569933772087097f,\
0.8132526441477239131928f,0.7686451207846403121948f,0.4041520212776958942413f,\
0.8579940209165215492249f,0.6993723283521831035614f,0.0828925184905529022217f,\
0.9201254160143435001373f,0.5200281282886862754822f,0.9351884997449815273285f,\
0.8825624976307153701782f,0.2245844271965324878693f,0.2153332801535725593567f,\
0.4327089670114219188690f,0.5800157263875007629395f,0.8876141034997999668121f,\
0.5258982880041003227234f,0.859640696551650762558f,0.7337234076112508773804f,\
0.7134532411582767963409f,0.1087165409699082374573f,0.8477638359181582927704f,\
0.6594733335077762603760f,0.7916418449021875858307f,0.6067967480048537254334f,\
0.4102901122532784938812f,0.1958728153258562088013f,0.241527963895350694656f,\
0.5113455550745129585266f,0.9119556057266891002655f,0.0928984880447387695313f,\
0.7438839026726782321930f,0.1938720373436808586121f,0.4355978979729115962982f,\
0.9922429900616407394409f,0.4533818070776760578156f,0.8269640663638710975647f,\
0.8889675955288112163544f,0.4682085178792476654053f,0.3856786251999437808991f,\
0.4124865522608160972595f,0.6955242282710969448090f,0.0978972557932138442993f,\
0.8728604433126747608185f,0.6359515609219670295715f,0.4129665228538215160370f,\
0.0294486805796623229980f,0.1809961968101561069489f,0.7658103061839938163757f,\
0.1232470511458814144135f,0.0170737411826848983765f,0.8835507561452686786652f,\
0.3164170170202851295471f,0.9378212536685168743134f,0.3916359134018421173096f,\
0.0844073877669870853424f,0.6934146797284483909607f,0.4618808380328118801117f,\
0.9355291295796632766724f,0.0842495900578796863556f,0.5402926551178097724915f,\
0.5613215523771941661835f,0.1306025832891464233398f,0.5840523042716085910797f,\
0.0048661706969141960144f,0.2761953338049352169037f,0.7478824090212583541870f,\
0.0194325004704296588898f,0.6444276878610253334045f,0.2243968318216502666473f,\
0.2478402368724346160889f,0.1196091384626924991608f,0.1883201440796256065369f,\
0.3393343067727982997894f,0.959958622232079505920f,0.2847225037403404712677f,\
0.8766820700839161872864f,0.2853349032811820507050f,0.5103433504700660705566f,\
0.8752629184164106845856f,0.5941145820543169975281f,0.3945342986844480037689f,\
0.4661326166242361068726f,0.0073588271625339984894f,0.5170202488079667091370f,\
0.4690007264725863933563f,0.6654530800879001617432f,0.9476742581464350223541f,\
0.4933638339862227439880f,0.2918433747254312038422f,0.2016727942973375320435f,\
0.7016656589694321155548f,0.8736049132421612739563f,0.191055159550160169601f,\
0.5307010114192962646484f,0.8889481076039373874664f,0.0115523664280772209167f,\
0.4998398735187947750092f,0.6700848620384931564331f,0.4995208983309566974640f,\
0.1538907447829842567444f,0.2571737091057002544403f,0.9586529098451137542725f,\
0.6246025026775896549225f,0.9371285131201148033142f,0.9923511571250855922699f,\
0.3454555813223123550415f,0.7558249053545296192169f,0.2107181670144200325012f,\
0.9372652801685035228729f,0.6767524704337120056152f,0.7465373151935636997223f,\
0.4050982249900698661804f,0.5101723610423505306244f,0.9497965183109045028687f,\
0.0289692510850727558136f,0.1634070957079529762268f,0.4146909262053668498993f,\
0.0021650679409503936768f,0.1810030029155313968658f,0.4556188201531767845154f,\
0.1977851442061364650726f,0.6053877938538789749146f,0.4363054675050079822540f,\
0.8938506888225674629211f,0.6104825991205871105194f,0.4316215068101882934570f,\
0.2315693595446646213532f,0.4675927339121699333191f,0.6150764389894902706146f,\
0.8621218334883451461792f,0.3846137975342571735382f}

#define RESULT {0.8403937230137732417035f,0.6395717396507912821946f,0.5487484449872901404177f,\
0.4336042429754092819572f,0.4238760641998542411102f,0.5318731004834296172135f,\
0.8504340619815806689985f,0.8579265615168094605281f,0.4304198190967006287799f,\
0.8777123753528599525708f,0.4376034060957934568314f,0.8672708471836166888025f,\
0.7877742991393319460514f,0.5298682903510159025728f,0.4785257241098120895018f,\
0.7105795806233234923610f,0.9140076401745489409478f,0.9041413836239913237591f,\
0.0554439139843518405404f,0.6064335200718896645711f,0.9098640487543193655640f,\
0.8529601272604701023283f,0.7295974428263399813588f,0.9626903405431641580492f,\
0.9768574197809363202083f,0.5623259535879292503324f,0.7608554373832265849131f,\
0.8295315269575556094139f,0.6094309761246169410143f,0.4129702240276767466476f,\
0.4420817805676271472493f,0.9893436472315183527471f,0.9643772040706288795064f,\
0.7319644844478875311822f,0.6282613777029032453569f,0.3667248521371476721598f,\
0.8591050694012946076228f,0.7668863347683098075081f,0.9546294133407251525370f,\
0.7538410616273759634609f,0.3358000776414095667199f,0.9735745263803721183393f,\
0.7237243980489743711004f,0.9022272241685526106281f,0.3742930172849022740778f,\
0.5256849810670379818944f,0.9518378871265757990017f,0.3714702659930047001780f,\
0.7485879162822044463610f,0.5485080344707662369785f,0.6904648821761910637562f,\
0.9015229290541324491670f,0.4459163802100529760963f,0.3328592991441819970433f,\
0.4646882089476060961886f,0.8041918212258555298533f,0.8122733291705668268179f,\
0.2630395433133783655855f,0.9573270632499127907877f,0.9292831014696417701870f,\
0.709426126838051174239f,0.4280347830630485406189f,0.9167168958631211062027f,\
0.9616243984045148573969f,0.7892688095555726590646f,0.5266698659726460896025f,\
0.4979066090253003729060f,0.6238548356245596782088f,0.2089446266200143398351f,\
0.9018052140832431007311f,0.8767240847522328461849f,0.6357295189604584839671f,\
0.9262796666863207795117f,0.8362848368541564436640f,0.2879106085064475628599f,\
0.9592316800514584240744f,0.7211297582881227574703f,0.9670514462762472840396f,\
0.9394479749463060525017f,0.4739033943711866703197f,0.4640401708403837921502f,\
0.6578061773892229791017f,0.7615876353956259059430f,0.9421327419741869491077f,\
0.7251884499935863370723f,0.9271681058749005055475f,0.8565765626091171869305f,\
0.8446616134040167978014f,0.3297219146036675652134f,0.9207409168263124277232f,\
0.8120796349544644465723f,0.8897425722658142133170f,0.7789715964044220397611f,\
0.6405389232929397103078f,0.4425752086661161044390f,0.4914549459465747394127f,\
0.7150842992784227636349f,0.9549636672285962690765f,0.3047925327903207581848f,\
0.8624870449303445596456f,0.4403090248265198458633f,0.6599984075533149585624f,\
0.9961139443164325202318f,0.6733363253810654702747f,0.9093756464541323802919f,\
0.9428507811572365282515f,0.6842576399860272884368f,0.6210302933029465677350f,\
0.6422511597971747310254f,0.8339809519833752959883f,0.3128853716510470728274f,\
0.9342700055726260721656f,0.7974657114396624946195f,0.6426247138523553115164f,\
0.1716061787339323019275f,0.4254364779966053888849f,0.8751058828416100610070f,\
0.351065593793925379007f,0.1306665266343484677059f,0.939973806095291464224f,\
0.5625095706032787745698f,0.9684117170235585492222f,0.6258082081611283653544f,\
0.2905294955197958439719f,0.8327152452840337337747f,0.6796181560500071938691f,\
0.967227547984270019654f,0.2902577993058579330921f,0.7350460224488054583603f,\
0.7492139563417076209f,0.3613897941131520297198f,0.7642331478492728757956f,\
0.0697579436115643852778f,0.5255428943530063845557f,0.8648019478593109710118f,\
0.1394005038385071892915f,0.8027625351628122629677f,0.4737054272664081300270f,\
0.4978355520374520559734f,0.3458455413370143394225f,0.4339586893698818559351f,\
0.5825240825689512735863f,0.9797747813819661644175f,0.5335939502471336304268f,\
0.9363130192857067601864f,0.5341674861700046461621f,0.7143831958200487219912f,\
0.9355548719430681892106f,0.7707882861423861475814f,0.628119653158892954359f,\
0.6827390545620164452600f,0.0857836066071717417980f,0.7190412010503756112811f,\
0.6848362771294949080669f,0.8157530754388242488773f,0.9734856229788064752029f,\
0.7023986289751872336140f,0.5402252999679219014340f,0.4490799419895499244859f,\
0.8376548567097501507561f,0.9346683439820572258938f,0.4370985696043401258493f,\
0.7284922864514739027086f,0.9428404465252524513375f,0.1074819353569576446672f,\
0.7069935455991057660086f,0.8185871132863582477768f,0.7067679239545019420632f,\
0.3922891086723976905581f,0.5071229723703120084721f,0.9791082217227642381374f,\
0.7903179756766194330453f,0.9680539825444213208883f,0.9961682373600784234924f,\
0.5877546948534841941836f,0.8693819099535771144360f,0.4590404851583572698459f,\
0.9681246201644205795489f,0.8226496644585178374953f,0.8640239089247262471716f,\
0.6364732712298842853826f,0.7142635095273666134830f,0.9745750449867390807768f,\
0.1702035577920530950991f,0.4042364354037782381290f,0.643965003866954543987f,\
0.0465302905745321321307f,0.4254444768892075012801f,0.6749954223201641845265f,\
0.444730417450995230144f,0.7780667027022033499506f,0.6605342288670648098758f,\
0.9454367714567524227931f,0.7813338589364902109224f,0.6569790763869031158251f,\
0.4812165412209607473493f,0.6838075269490457852584f,0.7842680912733159814820f,\
0.9285051607225159875370f,0.6201723933990106463199f}

#define CSOURCER {0.6045256052166223526001f,0.9455216196365654468536f,0.4476299257948994636536f,\
0.8624908211641013622284f,0.1751048639416694641113f,0.2067177616991102695465f,\
0.6848411662504076957703f,0.1348653226159512996674f,0.0069159921258687973022f,\
0.1496290047653019428253f,0.5665438110008835792542f,0.4359452719800174236298f,\
0.6547604538500308990479f,0.3381605879403650760651f,0.4259321158751845359802f,\
0.3060420057736337184906f,0.7704779822379350662231f,0.7058695447631180286408f,\
0.2373670237138867378235f,0.8205849635414779186249f,0.6789963841438293457031f,\
0.5250809141434729099274f,0.3359806565567851066589f,0.8941988362930715084076f,\
0.5461782198399305343628f,0.7568633262999355792999f,0.0259526828303933143616f,\
0.3250150899402797222138f,0.6072143577039241791f,0.8756139636971056461334f,\
0.2962085595354437828064f,0.4229678637348115444183f,0.4243144039064645767212f,\
0.7620028969831764698029f,0.3622896494343876838684f,0.5658242437057197093964f,\
0.6424440070986747741699f,0.7580267959274351596832f,0.2531452132388949394226f,\
0.5266989110969007015228f,0.2118590380996465682983f,0.4779220153577625751495f,\
0.1615962767973542213440f,0.9168031658045947551727f,0.5461866445839405059815f,\
0.4686870560981333255768f,0.7772213732823729515076f,0.5871783248148858547211f,\
0.5848031807690858840942f,0.3139644009061157703400f,0.3204141603782773017883f,\
0.3331634956412017345429f,0.2282590121030807495117f,0.2750317254103720188141f,\
0.4963629124686121940613f,0.7453477247618138790131f,0.1155001949518918991089f,\
0.0626524840481579303741f,0.0877018878236413002014f,0.5507565210573375225067f,\
0.2116370312869548797607f,0.8335358710028231143951f,0.4045845707878470420837f,\
0.2880227542482316493988f,0.1750094983726739883423f,0.0051561561413109302521f,\
0.3109287889674305915833f,0.6602919283322989940643f,0.9722995534539222717285f,\
0.9826813959516584873200f,0.0455837054178118705750f,0.4096118300221860408783f,\
0.7104403134435415267944f,0.3917615194804966449738f,0.5571686858311295509338f,\
0.0565565521828830242157f,0.1540721096098423004150f,0.9109257892705500125885f,\
0.5713340407237410545349f,0.3488348922692239284515f,0.8972954172641038894653f,\
0.2973396372981369495392f,0.1091936426237225532532f,0.7626331257633864879608f,\
0.6584706604480743408203f,0.6996708759106695652008f,0.6756794182583689689636f,\
0.9004421546123921871185f,0.6668148916214704513550f,0.8518152837641537189484f,\
0.8365677157416939735413f,0.1291190306656062602997f,0.6095453463494777679443f,\
0.2412315667606890201569f,0.4029275467619299888611f,0.3019328541122376918793f,\
0.1083198729902505874634f,0.8456356939859688282013f,0.9417407037690281867981f,\
0.9083450469188392162323f,0.1937242373824119567871f,0.5318046086467802524567f,\
0.8314437521621584892273f,0.4952740012668073177338f,0.7465563025325536727905f,\
0.7102393140085041522980f,0.5811418974772095680237f,0.7035941029898822307587f,\
0.3746570833027362823486f,0.3394373343326151371002f,0.6322447275742888450623f,\
0.7636191300116479396820f,0.6940386760979890823364f,0.8735245508141815662384f,\
0.3612738298252224922180f,0.7933200257830321788788f,0.4830590635538101196289f,\
0.2469964125193655490875f,0.5025922833010554313660f,0.7430270477198064327240f,\
0.6783937942236661911011f,0.4903185223229229450226f,0.709806025959551334381f,\
0.3303662906400859355927f,0.6815545372664928436279f,0.0701365978457033634186f,\
0.4745870968326926231384f,0.8091805852018296718597f,0.9447045121341943740845f,\
0.5478458073921501636505f,0.1216687532141804695129f,0.9161847713403403759003f,\
0.3045207932591438293457f,0.6502694808878004550934f,0.0987624628469347953796f,\
0.8391053467057645320892f,0.0328534897416830062866f,0.3461971958167850971222f,\
0.2801467711105942726135f,0.5500544901005923748016f,0.0729318000376224517822f,\
0.0225322381593286991119f,0.50267804320901632309f,0.3478884599171578884125f,\
0.4298669416457414627075f,0.3537984383292496204376f,0.0529730813577771186829f,\
0.9533003675751388072968f,0.1842019557952880859375f,0.958756382111459970474f,\
0.3245136169716715812683f,0.0003973259590566158295f,0.0972583871334791183472f,\
0.4378789965994656086f,0.3634226778522133827210f,0.2685119728557765483856f,\
0.2770298384130001068115f,0.8854365111328661441803f,0.5216628303751349449158f,\
0.4979983693920075893f,0.8733724001795053482056f,0.4699407932348549365997f,\
0.9364062966778874397278f,0.1337622734718024730682f,0.2712419554591178894043f,\
0.1766990595497190952301f,0.0543269468471407890320f,0.8402757882140576839447f,\
0.7507283594459295272827f,0.3062269617803394794464f,0.9195641661062836647034f,\
0.1318263853900134563446f,0.0826364941895008087158f,0.8222710476256906986237f,\
0.4441085970029234886169f,0.9617503038607537746429f,0.0283641982823610305786f,\
0.1431905967183411121368f,0.3793597565963864326477f,0.6144003230147063732147f,\
0.2128270715475082397461f,0.4704488315619528293610f,0.2076055286452174186707f,\
0.7435979112051427364349f,0.3391801547259092330933f,0.2479635034687817096710f,\
0.6721735307946801185608f,0.9013197491876780986786f,0.2140864841639995574951f,\
0.8460668534971773624420f,0.1650043567642569541931f,0.4003686285577714443207f,\
0.5522825215011835098267f,0.0638249483890831470490f,0.6903966935351490974426f,\
0.8547787251882255077362f,0.0291904583573341369629f,0.5434663915075361728668f,\
0.6236743135377764701843f,0.2417052476666867733002f}

#define CSOURCEI {0.5503273960202932357788f,0.6906704087741672992706f,0.9835249418392777442932f,\
0.8285484607331454753876f,0.2062614001333713531494f,0.1944643096067011356354f,\
0.4367609983310103416443f,0.8090620837174355983734f,0.8818644303828477859497f,\
0.7404803228564560413361f,0.7542522149160504341126f,0.9921960639767348766327f,\
0.9886121451854705810547f,0.0113218077458441257477f,0.9367801276966929435730f,\
0.3874237253330647945404f,0.2886805813759565353394f,0.567788839805871248245f,\
0.7295644441619515419006f,0.0303032915107905864716f,0.2795897088944911956787f,\
0.7047131718136370182037f,0.7442112853750586509705f,0.8920237845741212368012f,\
0.1081438604742288589478f,0.8751525697298347949982f,0.9068333031609654426575f,\
0.2166852983646094799042f,0.4824190363287925720215f,0.7766945236362516880035f,\
0.4510916722938418388367f,0.1300636469386518001556f,0.5505470838397741317749f,\
0.6936193336732685565949f,0.1749099576845765113831f,0.8636093880049884319305f,\
0.2150467522442340850830f,0.1886725709773600101471f,0.1796098565682768821716f,\
0.4374312213622033596039f,0.8514516223222017288208f,0.7381969136185944080353f,\
0.8102188156917691230774f,0.1460137623362243175507f,0.8999849110841751098633f,\
0.4043733575381338596344f,0.0156995235010981559753f,0.6904196902178227901459f,\
0.2990311514586210250855f,0.1383218024857342243195f,0.8478512773290276527405f,\
0.3007262717001140117645f,0.229154746979475021362f,0.8078110129572451114655f,\
0.3176332255825400352478f,0.6924462593160569667816f,0.1364154014736413955689f,\
0.5433279541321098804474f,0.3276594849303364753723f,0.2006831648759543895721f,\
0.5037304237484931945801f,0.4962565028108656406403f,0.8996161324903368949890f,\
0.9357709079049527645111f,0.3390339072793722152710f,0.6029155333526432514191f,\
0.4153500730171799659729f,0.3041478390805423259735f,0.8489827848970890045166f,\
0.4482063786126673221588f,0.0903797810897231101990f,0.7382151386700570583344f,\
0.2669597584754228591919f,0.8226196658797562122345f,0.3985779182985424995422f,\
0.9789295899681746959686f,0.3041231036186218261719f,0.0663515278138220310211f,\
0.6667758254334330558777f,0.7548807277344167232513f,0.1922533493489027023315f,\
0.7942791883833706378937f,0.5580398896709084510803f,0.2016023616306483745575f,\
0.787146832793951034546f,0.0955459238030016422272f,0.6623697867617011070252f,\
0.864868474658578634262f,0.7013061288744211196899f,0.8015053984709084033966f,\
0.9135685982182621955872f,0.6317234965972602367401f,0.9346773549914360046387f,\
0.9157753759063780307770f,0.0510348035022616386414f,0.4329969524405896663666f,\
0.9721843507140874862671f,0.8001508046872913837433f,0.8452261472120881080627f,\
0.0610524858348071575165f,0.8168097324669361114502f,0.2101262793876230716705f,\
0.3055453812703490257263f,0.9465212575159966945648f,0.9269728232175111770630f,\
0.7737778765149414539337f,0.5893978821113705635071f,0.2377697187475860118866f,\
0.5269544571638107299805f,0.0077543654479086399078f,0.8311711428686976432800f,\
0.0268517597578465938568f,0.2591186594218015670776f,0.4641277943737804889679f,\
0.6098861405625939369202f,0.0656952331773936748505f,0.6466812007129192352295f,\
0.1018534512259066104889f,0.2742705782875418663025f,0.8162728524766862392426f,\
0.3357750270515680313110f,0.4765891996212303638458f,0.8440040023997426033020f,\
0.1785074654035270214081f,0.5855625644326210021973f,0.8426241897977888584137f,\
0.7058847947046160697937f,0.7396617024205625057221f,0.9751448985189199447632f,\
0.7606669445522129535675f,0.8236690396443009376526f,0.8889620001427829265595f,\
0.7960178293287754058838f,0.3052428201772272586823f,0.6803312664851546287537f,\
0.6412069997750222682953f,0.0988248009234666824341f,0.4654508423991501331329f,\
0.6714970665052533149719f,0.5131103205494582653046f,0.8631567060947418212891f,\
0.8328299173153936862946f,0.1687975851818919181824f,0.2961277081631124019623f,\
0.2591485660523176193237f,0.1700844173319637775421f,0.9718958893790841102600f,\
0.0695185582153499126434f,0.4696230851113796234131f,0.9544191421009600162506f,\
0.3679352095350623130798f,0.2973918146453797817230f,0.0415310803800821304321f,\
0.4892336544580757617950f,0.5171590568497776985169f,0.3534862431697547435761f,\
0.2354387864470481872559f,0.6779259913600981235504f,0.3834532154724001884460f,\
0.3174350797198712825775f,0.3418120350688695907593f,0.0535557498224079608917f,\
0.9285596096888184547424f,0.3862650538794696331024f,0.4328473098576068878174f,\
0.1581165478564798831940f,0.7887120461091399192810f,0.7448797873221337795258f,\
0.5185996759682893753052f,0.8651678604073822498322f,0.1524438308551907539368f,\
0.2392775672487914562225f,0.5761575847864151000977f,0.7395762302912771701813f,\
0.0583172617480158805847f,0.6962534948252141475678f,0.4206145536154508590698f,\
0.0281158541329205036163f,0.8313249954953789710999f,0.2333360086195170879364f,\
0.8865877203643321990967f,0.3746785433031618595123f,0.87671328987926244736f,\
0.4027077830396592617035f,0.2890332732349634170532f,0.8538430598564445972443f,\
0.5499771209433674812317f,0.5128610017709434032440f,0.6321087554097175598145f,\
0.4165538274683058261871f,0.3217771751806139945984f,0.9717370062135159969330f,\
0.5348322447389364242554f,0.3416590173728764057159f,0.9565287167206406593323f,\
0.9951003189198672771454f,0.3422884084284305572510f,0.7870580093003809452057f,\
0.9234123295173048973084f,0.5238970420323312282562f}

#define CRESULTR {0.8432166939003225003546f,1.028696846310626300536f,0.8741363651656853805960f,\
1.0145139259460289604675f,0.4720540083473970804917f,0.4952416659876168192334f,\
0.8651884064428800868996f,0.6910466586042781633736f,0.6666361606264414874090f,\
0.6727093940540614935841f,0.8688705649614124615354f,0.8716907101266159196840f,\
0.959306172735902795701f,0.5815972201878681913101f,0.8529353171823288448650f,\
0.6323612148789939935156f,0.8925417496893577329331f,0.8977079570170535260942f,\
0.7087222819700315090685f,0.9060158028150111508836f,0.8406257183559593393341f,\
0.8378258601984284181796f,0.7591172919619637582400f,1.0385687027372507706957f,\
0.7426169311676505957465f,0.9782382399865202637912f,0.6830656191716251157686f,\
0.5981803109332550771882f,0.8314861127635455595453f,1.011450539647472002258f,\
0.6464748892519300849102f,0.6578303557631125508820f,0.7481312014375646191056f,\
0.9466832738110327882808f,0.6183009489366241284714f,0.8939481166511646925699f,\
0.8123805134131761862548f,0.8772630865325246052322f,0.5308180535125875953995f,\
0.7782537556049359261934f,0.7379946979653042582470f,0.8238088030668070382845f,\
0.7027705686531833251252f,0.9605105126328297160399f,0.8941312697312054913468f,\
0.7374641482216017784879f,0.8816465539160547315589f,0.8641531635219484863697f,\
0.7879164327234249309839f,0.5731702653710250006114f,0.7831953532687397911971f,\
0.6252910190572938953224f,0.5252142434850843866201f,0.7511253936013374543634f,\
0.7367688115224660938551f,0.9388049677540464266201f,0.3835650562588603929015f,\
0.5520782622396902539208f,0.4620041004215187374626f,0.753968196415999991622f,\
0.6156379639362553612969f,0.9496353272389349564620f,0.8339637612267859489990f,\
0.7959636817154828181131f,0.5275172507857687209665f,0.5514044508846071002139f,\
0.6441142487726253529345f,0.8328463321559912424519f,1.0637408773050947008443f,\
1.0155667426713801404503f,0.2709318224164963262446f,0.7917869572241151843173f,\
0.8571412685012261833961f,0.8071256937996567071281f,0.7881067116954072471202f,\
0.7201105910271731191941f,0.4974916923152819525633f,0.9550562531126176590846f,\
0.8512952675658871370956f,0.7682506551752034118508f,0.9526163214553304836585f,\
0.756785792150606484441f,0.5821581994240766499971f,0.8807562498788572558084f,\
0.9178011959841433364815f,0.8384018774833429388238f,0.9005192643641398708709f,\
1.0365709563884744071061f,0.9040270806600297914812f,1.0053433947417824700921f,\
1.0186506185399304413863f,0.6220542372412505294221f,0.9288207542994831866778f,\
0.7707938959111726440199f,0.63603233719709606486f,0.6441295538205468185211f,\
0.7370617546735380720691f,1.0024537010421461502574f,1.0505138587196660715506f,\
0.953608813532313304151f,0.7187463572209089601728f,0.7428380749761755996730f,\
0.9266208094400342210051f,0.8841784551932333480195f,0.9840672842877067338918f,\
0.9382321956452510658409f,0.8393030146072417707615f,0.8503757458476615127552f,\
0.7145712412765103938028f,0.5826505086380492359766f,0.9155742917376128442442f,\
0.8739880489156448550858f,0.8470155698847267045082f,0.9650636753683585755681f,\
0.7314820521682621201620f,0.8914470068047345430173f,0.8031939281911506522960f,\
0.5070351579739499348065f,0.7331953647718203459505f,0.9609459795569127438242f,\
0.847153172323739211969f,0.7661900708888577105071f,0.9519994233321562582262f,\
0.5940854373891888418058f,0.8888500969738630796968f,0.6766367900740852814323f,\
0.8139959478095014633325f,0.9760840415848224260742f,1.0729430743093604228022f,\
0.8617604247210989276695f,0.6907515785500089045002f,1.0470820008330794514961f,\
0.7605256422767727730872f,0.8272295000550387022997f,0.6269868176753693456149f,\
0.9734363297756469801669f,0.2617213661737881613689f,0.6805441931353264362059f,\
0.709837674958288866733f,0.8069322418000910435154f,0.6852606023040614946496f,\
0.6540897892889659948068f,0.7186585042731442607433f,0.6343284289266235553839f,\
0.6825711485307393022737f,0.610883282746898181870f,0.7163489185444231743816f,\
0.9770189769897136278232f,0.5867956626396594321804f,1.0750765659376522176416f,\
0.6384005820717564283484f,0.3858687639762184984349f,0.3186007968636310749844f,\
0.7397471191545493818254f,0.7055161810773808994668f,0.5968318319385850223569f,\
0.5659466952073320955563f,1.0001490762521170196919f,0.7645570771657418385203f,\
0.7377545989844320750706f,0.9516433749813681952645f,0.6866306949128065939547f,\
1.0618728756326238915619f,0.5208322311777507929165f,0.6253215357738258761700f,\
0.4548702015131091402900f,0.6499645432009629741899f,0.9907517258725765385563f,\
0.9119111641770327736367f,0.7823013339720715775272f,0.9622054437069111898495f,\
0.4500082630180006204590f,0.5764937377448445809947f,0.9818886833563331695274f,\
0.6678434466414240322507f,1.0365982590716655842300f,0.4743068831608843738401f,\
0.3802074434441635730764f,0.8040992937118037753308f,0.7973759350671048018455f,\
0.7498672536100723373664f,0.7320754444197923316295f,0.7445011903920762952325f,\
0.8914147503382092718738f,0.6264212402370327170686f,0.7540169824914779717062f,\
0.8776882812655947274649f,0.9844634271419567816963f,0.6638769890354155878143f,\
0.9458113966252766902088f,0.5131381594621587938221f,0.8518664381177757372043f,\
0.812738510298055549796f,0.4535385196962208320670f,0.9669683162928227604382f,\
1.040816644093084830658f,0.4316950876741513232204f,0.8660041994184899394327f,\
0.9321942634710010944232f,0.6397933456564963705660f}

#define CRESULTI {0.3263261982366231217512f,0.3357016264078308553920f,0.5625695149136477057894f,\
0.4083475049199193351868f,0.2184722473340149073717f,0.1963327431456096394680f,\
0.2524080275917597870894f,0.5853888978723345015709f,0.6614285891378552939557f,\
0.5503716236174250875379f,0.4340417579628489397337f,0.5691216233293430182272f,\
0.5152745668080026542057f,0.0097333750513688352402f,0.5491507438051371758903f,\
0.3063310306018693363050f,0.1617182509817773616856f,0.3162436265422815528936f,\
0.5147040404416135528365f,0.0167233791158154128376f,0.1662985694996903240917f,\
0.4205606470816827258119f,0.4901820135407665146587f,0.4294486162653968763792f,\
0.0728126817040040535955f,0.4473105496989639440209f,0.6637966234200971538115f,\
0.1811203866159907804878f,0.2900944639504645650163f,0.3839508177567231839156f,\
0.3488856874362309956617f,0.0988580458466166156484f,0.36794821735938526563f,\
0.3663418129703439607425f,0.1414440314101028384197f,0.4830310461641617592044f,\
0.1323559272370566086696f,0.1075347714236491863948f,0.1691821287725076283781f,\
0.2810338004872128814249f,0.5768683871779194394236f,0.4480389811753019424501f,\
0.5764461773381487352808f,0.0760084144919923321293f,0.5032733679892044120763f,\
0.2741647566958217985267f,0.0089035245651246392590f,0.3994776154055512673580f,\
0.1897607024294587774183f,0.1206637982137782894032f,0.5412770094909528095784f,\
0.2404690476392074838241f,0.2181535914362372208242f,0.5377337924125580315149f,\
0.2155582732432577419690f,0.3687913267931641758679f,0.1778256377212544814270f,\
0.4920751198642726587096f,0.3546066849097115891709f,0.1330846352869425042176f,\
0.4091125411822805202355f,0.2612879326286920989020f,0.5393616451432939884469f,\
0.5878226164089255245671f,0.3213486447830481429477f,0.5467089832022555828672f,\
0.3224195659455129092663f,0.1825954124653428600755f,0.3990552600779624370375f,\
0.2206681056892876025000f,0.1667943253834255346035f,0.4661703075143642238665f,\
0.1557268144037805002178f,0.5095982399018667008406f,0.2528705265313027639174f,\
0.6797078130539779827757f,0.3056564645363825660773f,0.0347369736586594715644f,\
0.3916242993690946527785f,0.4912984601114738780758f,0.1009080702371304705256f,\
0.5247714720741629701450f,0.4792854332576366727f,0.1144484422667324668987f,\
0.4288220783749939757357f,0.0569809815370433195292f,0.36777102554791152311f,\
0.4171776516254488420543f,0.3878789385171945158781f,0.3986227007920866149959f,\
0.4484209706404114204048f,0.5077720388168175391641f,0.5031527077021280547342f,\
0.5940468527088033079409f,0.0401196609964555792049f,0.3361101426509159328937f,\
0.6594999296529031607150f,0.3990961397296745039043f,0.4022917642620268408038f,\
0.0320112843801534235899f,0.5682183459163515637513f,0.1414347799783703119037f,\
0.1648707746240843652341f,0.5352546490793753664050f,0.470990570471244762718f,\
0.4123594778064457178068f,0.3511234154134331153507f,0.1398027400878979753518f,\
0.3687207284066310042370f,0.0066543882936226537647f,0.4539069906010949617681f,\
0.0153616286808277956177f,0.1529597971009351853322f,0.2404648554390081682808f,\
0.4168838721023755411466f,0.0368475258068726510552f,0.4025685317176705413367f,\
0.1004402255189763004672f,0.1870378561196294198155f,0.4247235900050622126045f,\
0.1981784628926891167478f,0.3110123830424602608957f,0.4432796815388754252396f,\
0.1502372000465193591090f,0.3293933175156303350128f,0.6226562035634579661547f,\
0.4335923272125510874453f,0.3788924267318253269465f,0.4544252728163645227433f,\
0.4413447883722416142938f,0.5962122022024949341557f,0.4244949294494160807467f,\
0.5233339844701030418861f,0.1844970592543655196760f,0.5425403272492764772395f,\
0.3293523059298621991076f,0.1887977324286261304742f,0.3419695936679567616068f,\
0.4729933970782203567218f,0.3179389135603382654516f,0.6298017886863316316948f,\
0.6366327153805051430879f,0.1174393569255921254690f,0.2334182851178558948391f,\
0.1898326398721546515169f,0.1392118774041107009953f,0.6783676670817878617825f,\
0.0355768720222523482377f,0.4001589607861217867679f,0.4438842647772449079291f,\
0.2881695442233370707541f,0.3853535740764292283345f,0.0651773014834273051177f,\
0.330676282333628224208f,0.3665111238554681349910f,0.2961355479495680342872f,\
0.2080043831343482141350f,0.3389124718789456314205f,0.2507682074527933790975f,\
0.2151359545279972751430f,0.1795904033249649811577f,0.0389989482113152971521f,\
0.4372272948094740319114f,0.3708152364207700224519f,0.3460997943417740696503f,\
0.1738040295127169787559f,0.6067346706520863053314f,0.3759164722454063634061f,\
0.2843476954448227456140f,0.5529633038042787163136f,0.0792158430677229186134f,\
0.2658590818355930918138f,0.4997084504683915184842f,0.3766089999954101985580f,\
0.0436608774416314404654f,0.3358357438535300443228f,0.4433991668140928599229f,\
0.0369743604678396259322f,0.5169293158173903224295f,0.1463149302341813229322f,\
0.5911631132684145306655f,0.2559015919459735610708f,0.5887924030165481159571f,\
0.2258812650827625445604f,0.2307020058304501131108f,0.5661961730855942231955f,\
0.3133100513489369687292f,0.2604774274143707435414f,0.4760737048049700770314f,\
0.2202097738273190163927f,0.3135385365979036498274f,0.5703576069745146526202f,\
0.3290309478154280209417f,0.3766593161719967164380f,0.4946018916047810187742f,\
0.4780382426469301782035f,0.3964469578199069088598f,0.4544192798538850830425f,\
0.4952896438554572622337f,0.4094267669310915347403f}




void ssqrtsTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out;
	int i;

	for (i=0;i<200;i++){
		out=ssqrts(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<1e-7);
	}
}

void csqrtsTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=FloatComplex(inR[i],inI[i]);
		out=csqrts(in);
		assert(( (fabs(creals(out)-resR[i]))/(fabs(creals(out))) )<1e-6);	
		assert(( (fabs(cimags(out)-resI[i]))/(fabs(cimags(out))) )<1e-6);			
	}
}

void ssqrtaTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out[200];
	int i,j;
	j=1;
	ssqrta(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<1e-6);
	}
}

void csqrtaTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex *in,out[200];
	int i;

	in=FloatComplexMatrix(inR,inI,200);
	csqrta(in,200,out);

	for (i=0;i<200;i++){
		assert(( (fabs(creals(out[i])-resR[i]))/(fabs(creals(out[i]))) )<1e-6);	
		assert(( (fabs(cimags(out[i])-resI[i]))/(fabs(cimags(out[i]))) )<1e-6);			
	}
}

int testSqrt() {
  printf("\n>>>> Float Square Root Tests\n");
  ssqrtsTest();
  csqrtsTest();
    ssqrtaTest();
    csqrtaTest();

  return 0;
}

int main() {
  assert(testSqrt() == 0);
  return 0;
}
