/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testTan.h"

#define SOURCE {0.7062616096809506416321f,0.4090520101599395275116f,0.3011248558759689331055f,\
0.1880126395262777805328f,0.1796709178015589714050f,0.2828889950178563594818f,\
0.7232380937784910202026f,0.7360379849560558795929f,0.1852612206712365150452f,\
0.7703790138475596904755f,0.1914967410266399383545f,0.7521587223745882511139f,\
0.6205883463844656944275f,0.2807604051195085048676f,0.2289868686348199844360f,\
0.5049233403988182544708f,0.8354099662974476814270f,0.8174716415815055370331f,\
0.0030740275979042053223f,0.3677616142667829990387f,0.8278525872156023979187f,\
0.72754097869619727135f,0.5323124285787343978882f,0.9267726917751133441925f,\
0.9542504185810685157776f,0.3162104780785739421845f,0.5789009965956211090088f,\
0.6881225542165338993073f,0.3714061146602034568787f,0.1705444059334695339203f,\
0.1954363007098436355591f,0.978800852317363023758f,0.9300233917310833930969f,\
0.5357720064930617809296f,0.3947123587131500244141f,0.1344871171750128269196f,\
0.7380615202710032463074f,0.588114650454372167587f,0.9113173168152570724487f,\
0.5682763461954891681671f,0.1127616921439766883850f,0.9478473584167659282684f,\
0.5237770043313503265381f,0.8140139640308916568756f,0.1400952627882361412048f,\
0.2763446993194520473480f,0.9059953633695840835571f,0.1379901585169136524200f,\
0.5603838684037327766419f,0.3008610638789832592011f,0.4767417535185813904f,\
0.8127435916103422641754f,0.1988414181396365165710f,0.1107953130267560482025f,\
0.2159351315349340438843f,0.6467244853265583515167f,0.6597879612818360328674f,\
0.0691898013465106487274f,0.9164751060307025909424f,0.8635670826770365238190f,\
0.5032854294404387474060f,0.1832137755118310451508f,0.8403698671609163284302f,\
0.9247214836068451404572f,0.6229452537372708320618f,0.2773811477236449718475f,\
0.2479109913110733032227f,0.3891948559321463108063f,0.0436578569933772087097f,\
0.8132526441477239131928f,0.7686451207846403121948f,0.4041520212776958942413f,\
0.8579940209165215492249f,0.6993723283521831035614f,0.0828925184905529022217f,\
0.9201254160143435001373f,0.5200281282886862754822f,0.9351884997449815273285f,\
0.8825624976307153701782f,0.2245844271965324878693f,0.2153332801535725593567f,\
0.4327089670114219188690f,0.5800157263875007629395f,0.8876141034997999668121f,\
0.5258982880041003227234f,0.859640696551650762558f,0.7337234076112508773804f,\
0.7134532411582767963409f,0.1087165409699082374573f,0.8477638359181582927704f,\
0.6594733335077762603760f,0.7916418449021875858307f,0.6067967480048537254334f,\
0.4102901122532784938812f,0.1958728153258562088013f,0.241527963895350694656f,\
0.5113455550745129585266f,0.9119556057266891002655f,0.0928984880447387695313f,\
0.7438839026726782321930f,0.1938720373436808586121f,0.4355978979729115962982f,\
0.9922429900616407394409f,0.4533818070776760578156f,0.8269640663638710975647f,\
0.8889675955288112163544f,0.4682085178792476654053f,0.3856786251999437808991f,\
0.4124865522608160972595f,0.6955242282710969448090f,0.0978972557932138442993f,\
0.8728604433126747608185f,0.6359515609219670295715f,0.4129665228538215160370f,\
0.0294486805796623229980f,0.1809961968101561069489f,0.7658103061839938163757f,\
0.1232470511458814144135f,0.0170737411826848983765f,0.8835507561452686786652f,\
0.3164170170202851295471f,0.9378212536685168743134f,0.3916359134018421173096f,\
0.0844073877669870853424f,0.6934146797284483909607f,0.4618808380328118801117f,\
0.9355291295796632766724f,0.0842495900578796863556f,0.5402926551178097724915f,\
0.5613215523771941661835f,0.1306025832891464233398f,0.5840523042716085910797f,\
0.0048661706969141960144f,0.2761953338049352169037f,0.7478824090212583541870f,\
0.0194325004704296588898f,0.6444276878610253334045f,0.2243968318216502666473f,\
0.2478402368724346160889f,0.1196091384626924991608f,0.1883201440796256065369f,\
0.3393343067727982997894f,0.959958622232079505920f,0.2847225037403404712677f,\
0.8766820700839161872864f,0.2853349032811820507050f,0.5103433504700660705566f,\
0.8752629184164106845856f,0.5941145820543169975281f,0.3945342986844480037689f,\
0.4661326166242361068726f,0.0073588271625339984894f,0.5170202488079667091370f,\
0.4690007264725863933563f,0.6654530800879001617432f,0.9476742581464350223541f,\
0.4933638339862227439880f,0.2918433747254312038422f,0.2016727942973375320435f,\
0.7016656589694321155548f,0.8736049132421612739563f,0.191055159550160169601f,\
0.5307010114192962646484f,0.8889481076039373874664f,0.0115523664280772209167f,\
0.4998398735187947750092f,0.6700848620384931564331f,0.4995208983309566974640f,\
0.1538907447829842567444f,0.2571737091057002544403f,0.9586529098451137542725f,\
0.6246025026775896549225f,0.9371285131201148033142f,0.9923511571250855922699f,\
0.3454555813223123550415f,0.7558249053545296192169f,0.2107181670144200325012f,\
0.9372652801685035228729f,0.6767524704337120056152f,0.7465373151935636997223f,\
0.4050982249900698661804f,0.5101723610423505306244f,0.9497965183109045028687f,\
0.0289692510850727558136f,0.1634070957079529762268f,0.4146909262053668498993f,\
0.0021650679409503936768f,0.1810030029155313968658f,0.4556188201531767845154f,\
0.1977851442061364650726f,0.6053877938538789749146f,0.4363054675050079822540f,\
0.8938506888225674629211f,0.6104825991205871105194f,0.4316215068101882934570f,\
0.2315693595446646213532f,0.4675927339121699333191f,0.6150764389894902706146f,\
0.8621218334883451461792f,0.3846137975342571735382f}

#define RESULT {0.8530491813252144561730f,0.4335045992710032103368f,0.3105691712500722179158f,\
0.1902597554084684006170f,0.1816295703181560194928f,0.2906848138476661458363f,\
0.8828132281173867168533f,0.9058504084575731418738f,0.1874102230574337113467f,\
0.9704039825071290037428f,0.193872386487773856745f,0.9356368085981127125095f,\
0.7147975865621483126944f,0.2883777870673323029394f,0.233074941053011769343f,\
0.5527124758136455762170f,1.1053818146408691536209f,1.0662960354617996294735f,\
0.0030740372807646679752f,0.3852902674825339213172f,1.0887291048642380175693f,\
0.8904988483295813717078f,0.589027514944382324380f,1.3318828819928720808008f,\
1.4110197782284186196478f,0.3271889768526293207351f,0.6535988324182537834162f,\
0.8221846610900451768345f,0.3894816929387301396304f,0.1722173220386573888607f,\
0.1979631660252146874157f,1.4871003608159341080608f,1.3409392796872054987034f,\
0.5936969391438152721108f,0.4165742349308056979851f,0.1353038396146245825324f,\
0.9095411562053630216695f,0.666828524289825752547f,1.2898724607003566600127f,\
0.6385394321030002373618f,0.1132420646312260748001f,1.3920395973271377787484f,\
0.5775879319584731330650f,1.058934135979150648055f,0.141019050913288951365f,\
0.2836009152345423944830f,1.2757925164705434806223f,0.1388727177433937698403f,\
0.6274844177211460483079f,0.3102799593553379198241f,0.5164764951302321938087f,\
1.0562428612021228513385f,0.2015041286208432702587f,0.1112509099475587071026f,\
0.2193551393571971375174f,0.7550487488328985197228f,0.7757652108685924030596f,\
0.0693004223106622879724f,1.3037037706937266712259f,1.1699705921283873877314f,\
0.550576129776577216646f,0.1852916762694652719201f,1.1164629082914852009623f,\
1.3262085052804502005586f,0.7183647379901514362643f,0.2847210542962326229599f,\
0.2531178933037822043062f,0.4101140401836267934677f,0.0436856155719798008863f,\
1.0573204171612526902635f,0.9670429620877326604145f,0.4276960657258361830913f,\
1.156854335998896532445f,0.8412159741625684361566f,0.0830828979444599852178f,\
1.3136054718047147638060f,0.5725991803557812787062f,1.355492790615370424234f,\
1.2159959299593459114419f,0.2284380696339281535678f,0.2187244120791704826701f,\
0.4619038629088654257515f,0.6551909258647544698206f,1.228594570395200147317f,\
0.5804203670779729540286f,1.1607121297665823345113f,0.9016453790519162181383f,\
0.8655510240366158791758f,0.1091468929729377396187f,1.133211951033040509884f,\
0.7752613593928633362040f,1.0125659843026109108166f,0.6941614960626277808231f,\
0.4349761638068749824981f,0.1984168266250701806452f,0.2463367776963759914199f,\
0.5611266025781723732f,1.2915741173940875619053f,0.0931666557927946503703f,\
0.9202369550199469561136f,0.1963381019951347117303f,0.4654138557801037467954f,\
1.531152598161082067918f,0.4872328317068129743817f,1.0867892686527245160732f,\
1.231996743210198141938f,0.5057142067082607272965f,0.4060123002390389479466f,\
0.4375906817398340642455f,0.8346659585500807443381f,0.0982112043307575288686f,\
1.1922276352973026902760f,0.7382700256000707117465f,0.4381626799731911381386f,\
0.0294571964089862109448f,0.1829988997674065476229f,0.9615720911131384607273f,\
0.1238749003414561927761f,0.0170754004466078072866f,1.2184484210758381728112f,\
0.3274176417863428056876f,1.3629896342945482246023f,0.4129685310508503515159f,\
0.0846084171803287293789f,0.8310930423770829245100f,0.4977934831990530883950f,\
1.3564597268158093967827f,0.0844494919835185042789f,0.5998275037194918946071f,\
0.6287920720664262885791f,0.1313502491565903540494f,0.6609756367352789263592f,\
0.0048662091069645377339f,0.2834395431640467921675f,0.9276488528261589427970f,\
0.0194349468870056892034f,0.7514487870197579244547f,0.2282406932471093830017f,\
0.2530426070707028074480f,0.1201828114589197499251f,0.1905784099029704803385f,\
0.352988062986135442411f,1.428231701456014857143f,0.2926743123472941854324f,\
1.2015237487616485800856f,0.2933392882321691486069f,0.5598095809652490206787f,\
1.1980617264883439698764f,0.6755313107918682336006f,0.4163652909127465440164f,\
0.5031101302799753094419f,0.0073589599979746594949f,0.5686119631638693050491f,\
0.5067094190821778143530f,0.7848798186452353720100f,1.391531190313842980544f,\
0.5377167840923406938458f,0.3004214213647905529214f,0.2044521595617958820146f,\
0.8451397437154636316237f,1.1940319015577840477960f,0.1934142466999154985619f,\
0.5868590674474564172769f,1.2319476773796440571829f,0.0115528803708900857511f,\
0.5460945923736312268559f,0.792392311128046200608f,0.5456805647330320585553f,\
0.1551171962759635702955f,0.2629975069837691137309f,1.4242699230594764170377f,\
0.7208802037485926295091f,1.3610118285291581408103f,1.5315144150725372718114f,\
0.3598870449025589057790f,0.9425361247426047306419f,0.2138933525822492576207f,\
1.3614020090881830959972f,0.8033042279594378998198f,0.925149379458894971506f,\
0.4288158062140490778269f,0.5595850272060393093554f,1.397781375537582970736f,\
0.0289773576405878592610f,0.1648772252909011803990f,0.4402197018088547242343f,\
0.0021650713238892428658f,0.1830059338084651376910f,0.4900039273308094966986f,\
0.2004051993228692374327f,0.6920756616600035604492f,0.4662749757103929471036f,\
1.244365984627544330365f,0.6996374475054760733173f,0.4605850493651166277509f,\
0.2357993689411847226811f,0.5049411785573922895054f,0.7065020490746397596737f,\
1.16655281751026174142f,0.4047724755535024310227f}

#define CSOURCER {0.6045256052166223526001f,0.9455216196365654468536f,0.4476299257948994636536f,\
0.8624908211641013622284f,0.1751048639416694641113f,0.2067177616991102695465f,\
0.6848411662504076957703f,0.1348653226159512996674f,0.0069159921258687973022f,\
0.1496290047653019428253f,0.5665438110008835792542f,0.4359452719800174236298f,\
0.6547604538500308990479f,0.3381605879403650760651f,0.4259321158751845359802f,\
0.3060420057736337184906f,0.7704779822379350662231f,0.7058695447631180286408f,\
0.2373670237138867378235f,0.8205849635414779186249f,0.6789963841438293457031f,\
0.5250809141434729099274f,0.3359806565567851066589f,0.8941988362930715084076f,\
0.5461782198399305343628f,0.7568633262999355792999f,0.0259526828303933143616f,\
0.3250150899402797222138f,0.6072143577039241791f,0.8756139636971056461334f,\
0.2962085595354437828064f,0.4229678637348115444183f,0.4243144039064645767212f,\
0.7620028969831764698029f,0.3622896494343876838684f,0.5658242437057197093964f,\
0.6424440070986747741699f,0.7580267959274351596832f,0.2531452132388949394226f,\
0.5266989110969007015228f,0.2118590380996465682983f,0.4779220153577625751495f,\
0.1615962767973542213440f,0.9168031658045947551727f,0.5461866445839405059815f,\
0.4686870560981333255768f,0.7772213732823729515076f,0.5871783248148858547211f,\
0.5848031807690858840942f,0.3139644009061157703400f,0.3204141603782773017883f,\
0.3331634956412017345429f,0.2282590121030807495117f,0.2750317254103720188141f,\
0.4963629124686121940613f,0.7453477247618138790131f,0.1155001949518918991089f,\
0.0626524840481579303741f,0.0877018878236413002014f,0.5507565210573375225067f,\
0.2116370312869548797607f,0.8335358710028231143951f,0.4045845707878470420837f,\
0.2880227542482316493988f,0.1750094983726739883423f,0.0051561561413109302521f,\
0.3109287889674305915833f,0.6602919283322989940643f,0.9722995534539222717285f,\
0.9826813959516584873200f,0.0455837054178118705750f,0.4096118300221860408783f,\
0.7104403134435415267944f,0.3917615194804966449738f,0.5571686858311295509338f,\
0.0565565521828830242157f,0.1540721096098423004150f,0.9109257892705500125885f,\
0.5713340407237410545349f,0.3488348922692239284515f,0.8972954172641038894653f,\
0.2973396372981369495392f,0.1091936426237225532532f,0.7626331257633864879608f,\
0.6584706604480743408203f,0.6996708759106695652008f,0.6756794182583689689636f,\
0.9004421546123921871185f,0.6668148916214704513550f,0.8518152837641537189484f,\
0.8365677157416939735413f,0.1291190306656062602997f,0.6095453463494777679443f,\
0.2412315667606890201569f,0.4029275467619299888611f,0.3019328541122376918793f,\
0.1083198729902505874634f,0.8456356939859688282013f,0.9417407037690281867981f,\
0.9083450469188392162323f,0.1937242373824119567871f,0.5318046086467802524567f,\
0.8314437521621584892273f,0.4952740012668073177338f,0.7465563025325536727905f,\
0.7102393140085041522980f,0.5811418974772095680237f,0.7035941029898822307587f,\
0.3746570833027362823486f,0.3394373343326151371002f,0.6322447275742888450623f,\
0.7636191300116479396820f,0.6940386760979890823364f,0.8735245508141815662384f,\
0.3612738298252224922180f,0.7933200257830321788788f,0.4830590635538101196289f,\
0.2469964125193655490875f,0.5025922833010554313660f,0.7430270477198064327240f,\
0.6783937942236661911011f,0.4903185223229229450226f,0.709806025959551334381f,\
0.3303662906400859355927f,0.6815545372664928436279f,0.0701365978457033634186f,\
0.4745870968326926231384f,0.8091805852018296718597f,0.9447045121341943740845f,\
0.5478458073921501636505f,0.1216687532141804695129f,0.9161847713403403759003f,\
0.3045207932591438293457f,0.6502694808878004550934f,0.0987624628469347953796f,\
0.8391053467057645320892f,0.0328534897416830062866f,0.3461971958167850971222f,\
0.2801467711105942726135f,0.5500544901005923748016f,0.0729318000376224517822f,\
0.0225322381593286991119f,0.50267804320901632309f,0.3478884599171578884125f,\
0.4298669416457414627075f,0.3537984383292496204376f,0.0529730813577771186829f,\
0.9533003675751388072968f,0.1842019557952880859375f,0.958756382111459970474f,\
0.3245136169716715812683f,0.0003973259590566158295f,0.0972583871334791183472f,\
0.4378789965994656086f,0.3634226778522133827210f,0.2685119728557765483856f,\
0.2770298384130001068115f,0.8854365111328661441803f,0.5216628303751349449158f,\
0.4979983693920075893f,0.8733724001795053482056f,0.4699407932348549365997f,\
0.9364062966778874397278f,0.1337622734718024730682f,0.2712419554591178894043f,\
0.1766990595497190952301f,0.0543269468471407890320f,0.8402757882140576839447f,\
0.7507283594459295272827f,0.3062269617803394794464f,0.9195641661062836647034f,\
0.1318263853900134563446f,0.0826364941895008087158f,0.8222710476256906986237f,\
0.4441085970029234886169f,0.9617503038607537746429f,0.0283641982823610305786f,\
0.1431905967183411121368f,0.3793597565963864326477f,0.6144003230147063732147f,\
0.2128270715475082397461f,0.4704488315619528293610f,0.2076055286452174186707f,\
0.7435979112051427364349f,0.3391801547259092330933f,0.2479635034687817096710f,\
0.6721735307946801185608f,0.9013197491876780986786f,0.2140864841639995574951f,\
0.8460668534971773624420f,0.1650043567642569541931f,0.4003686285577714443207f,\
0.5522825215011835098267f,0.0638249483890831470490f,0.6903966935351490974426f,\
0.8547787251882255077362f,0.0291904583573341369629f,0.5434663915075361728668f,\
0.6236743135377764701843f,0.2417052476666867733002f}

#define CSOURCEI {0.5503273960202932357788f,0.6906704087741672992706f,0.9835249418392777442932f,\
0.8285484607331454753876f,0.2062614001333713531494f,0.1944643096067011356354f,\
0.4367609983310103416443f,0.8090620837174355983734f,0.8818644303828477859497f,\
0.7404803228564560413361f,0.7542522149160504341126f,0.9921960639767348766327f,\
0.9886121451854705810547f,0.0113218077458441257477f,0.9367801276966929435730f,\
0.3874237253330647945404f,0.2886805813759565353394f,0.567788839805871248245f,\
0.7295644441619515419006f,0.0303032915107905864716f,0.2795897088944911956787f,\
0.7047131718136370182037f,0.7442112853750586509705f,0.8920237845741212368012f,\
0.1081438604742288589478f,0.8751525697298347949982f,0.9068333031609654426575f,\
0.2166852983646094799042f,0.4824190363287925720215f,0.7766945236362516880035f,\
0.4510916722938418388367f,0.1300636469386518001556f,0.5505470838397741317749f,\
0.6936193336732685565949f,0.1749099576845765113831f,0.8636093880049884319305f,\
0.2150467522442340850830f,0.1886725709773600101471f,0.1796098565682768821716f,\
0.4374312213622033596039f,0.8514516223222017288208f,0.7381969136185944080353f,\
0.8102188156917691230774f,0.1460137623362243175507f,0.8999849110841751098633f,\
0.4043733575381338596344f,0.0156995235010981559753f,0.6904196902178227901459f,\
0.2990311514586210250855f,0.1383218024857342243195f,0.8478512773290276527405f,\
0.3007262717001140117645f,0.229154746979475021362f,0.8078110129572451114655f,\
0.3176332255825400352478f,0.6924462593160569667816f,0.1364154014736413955689f,\
0.5433279541321098804474f,0.3276594849303364753723f,0.2006831648759543895721f,\
0.5037304237484931945801f,0.4962565028108656406403f,0.8996161324903368949890f,\
0.9357709079049527645111f,0.3390339072793722152710f,0.6029155333526432514191f,\
0.4153500730171799659729f,0.3041478390805423259735f,0.8489827848970890045166f,\
0.4482063786126673221588f,0.0903797810897231101990f,0.7382151386700570583344f,\
0.2669597584754228591919f,0.8226196658797562122345f,0.3985779182985424995422f,\
0.9789295899681746959686f,0.3041231036186218261719f,0.0663515278138220310211f,\
0.6667758254334330558777f,0.7548807277344167232513f,0.1922533493489027023315f,\
0.7942791883833706378937f,0.5580398896709084510803f,0.2016023616306483745575f,\
0.787146832793951034546f,0.0955459238030016422272f,0.6623697867617011070252f,\
0.864868474658578634262f,0.7013061288744211196899f,0.8015053984709084033966f,\
0.9135685982182621955872f,0.6317234965972602367401f,0.9346773549914360046387f,\
0.9157753759063780307770f,0.0510348035022616386414f,0.4329969524405896663666f,\
0.9721843507140874862671f,0.8001508046872913837433f,0.8452261472120881080627f,\
0.0610524858348071575165f,0.8168097324669361114502f,0.2101262793876230716705f,\
0.3055453812703490257263f,0.9465212575159966945648f,0.9269728232175111770630f,\
0.7737778765149414539337f,0.5893978821113705635071f,0.2377697187475860118866f,\
0.5269544571638107299805f,0.0077543654479086399078f,0.8311711428686976432800f,\
0.0268517597578465938568f,0.2591186594218015670776f,0.4641277943737804889679f,\
0.6098861405625939369202f,0.0656952331773936748505f,0.6466812007129192352295f,\
0.1018534512259066104889f,0.2742705782875418663025f,0.8162728524766862392426f,\
0.3357750270515680313110f,0.4765891996212303638458f,0.8440040023997426033020f,\
0.1785074654035270214081f,0.5855625644326210021973f,0.8426241897977888584137f,\
0.7058847947046160697937f,0.7396617024205625057221f,0.9751448985189199447632f,\
0.7606669445522129535675f,0.8236690396443009376526f,0.8889620001427829265595f,\
0.7960178293287754058838f,0.3052428201772272586823f,0.6803312664851546287537f,\
0.6412069997750222682953f,0.0988248009234666824341f,0.4654508423991501331329f,\
0.6714970665052533149719f,0.5131103205494582653046f,0.8631567060947418212891f,\
0.8328299173153936862946f,0.1687975851818919181824f,0.2961277081631124019623f,\
0.2591485660523176193237f,0.1700844173319637775421f,0.9718958893790841102600f,\
0.0695185582153499126434f,0.4696230851113796234131f,0.9544191421009600162506f,\
0.3679352095350623130798f,0.2973918146453797817230f,0.0415310803800821304321f,\
0.4892336544580757617950f,0.5171590568497776985169f,0.3534862431697547435761f,\
0.2354387864470481872559f,0.6779259913600981235504f,0.3834532154724001884460f,\
0.3174350797198712825775f,0.3418120350688695907593f,0.0535557498224079608917f,\
0.9285596096888184547424f,0.3862650538794696331024f,0.4328473098576068878174f,\
0.1581165478564798831940f,0.7887120461091399192810f,0.7448797873221337795258f,\
0.5185996759682893753052f,0.8651678604073822498322f,0.1524438308551907539368f,\
0.2392775672487914562225f,0.5761575847864151000977f,0.7395762302912771701813f,\
0.0583172617480158805847f,0.6962534948252141475678f,0.4206145536154508590698f,\
0.0281158541329205036163f,0.8313249954953789710999f,0.2333360086195170879364f,\
0.8865877203643321990967f,0.3746785433031618595123f,0.87671328987926244736f,\
0.4027077830396592617035f,0.2890332732349634170532f,0.8538430598564445972443f,\
0.5499771209433674812317f,0.5128610017709434032440f,0.6321087554097175598145f,\
0.4165538274683058261871f,0.3217771751806139945984f,0.9717370062135159969330f,\
0.5348322447389364242554f,0.3416590173728764057159f,0.9565287167206406593323f,\
0.9951003189198672771454f,0.3422884084284305572510f,0.7870580093003809452057f,\
0.9234123295173048973084f,0.5238970420323312282562f}

#define CRESULTR {0.4622549506274005182149f,0.52703543104286754151f,0.1827556517526441881572f,\
0.3854184255425531224759f,0.1693791983359425601385f,0.2016515153621968869935f,\
0.6100517388487384229379f,0.0743340542544716487150f,0.0034555684806514769605f,\
0.0902156984479902251950f,0.3241135973562218053345f,0.1760110212342378688266f,\
0.2452633832131958513401f,0.3516179963878625636120f,0.1885474403955421374146f,\
0.2692513911062309750477f,0.8321367071581778906975f,0.5264631357733180472280f,\
0.1448019483693787634593f,1.0708552390146606203558f,0.7125992289896019293849f,\
0.3253494174977278885486f,0.2001345889867806593365f,0.343199696050296210181f,\
0.5982400693418048476246f,0.3303593637710269814711f,0.0125118697596118978038f,\
0.3199717638395740970658f,0.5061472843217617034739f,0.4295842023027047207329f,\
0.2465282516242081889413f,0.441112206343829249544f,0.3219119603275076846316f,\
0.4595743499683106469966f,0.3660794615870797685808f,0.2720878846188879984780f,\
0.6972660654407580871350f,0.8861718442431221198774f,0.2499974132956042649489f,\
0.4568598941148580561134f,0.1097116340955419794279f,0.2836394335106861008811f,\
0.0888432657814137161090f,1.2330526748467487418992f,0.2488174581727523593244f,\
0.4160762578947443945943f,0.9833017375902159962209f,0.3688379479484371614717f,\
0.5845995722843282393910f,0.3179368621558099627933f,0.1652197278936747004696f,\
0.3133619394599517771205f,0.2199213980004723900663f,0.150759611907827051347f,\
0.4771998617931776376366f,0.4525965638532219448287f,0.1138559184839921800680f,\
0.0472861014102091622990f,0.0790630167394415495075f,0.5814611436078345185763f,\
0.1667238962880819019841f,0.6920944670661310915705f,0.1906861485587098559158f,\
0.1307919466930784202496f,0.1574308648240616004266f,0.0036575163164140646332f,\
0.2674520780172894851567f,0.6735689731298903915047f,0.378774827327838792268f,\
0.8834054385824835486929f,0.0452439501756518244746f,0.2447083220521515389834f,\
0.7633578523125562620422f,0.2078243181020067997800f,0.5055052026142557997090f,\
0.0245040445592060660007f,0.1414831146311008314154f,1.2738839652002900137973f,\
0.3722074374977639710238f,0.2046196449929307825677f,1.143222534499549469800f,\
0.1658122283683383380026f,0.0812521009905448621247f,0.8856778536505196530726f,\
0.3496455120553698669994f,0.8287603905975037266174f,0.4374379182437952429119f,\
0.3632754548631693114480f,0.4065565887334736672187f,0.4042071334744706256892f,\
0.3223163664494689273354f,0.0887658719864259648791f,0.2562423384997916109285f,\
0.1135016065651749256338f,0.4249393631867034448746f,0.2555315607462380622650f,\
0.0473167224981555015195f,0.4038863981107233547263f,0.3812800945055046519805f,\
1.2694612396144742128001f,0.1054006198029389801407f,0.5548755616229488207836f,\
0.9047138472187979951755f,0.2120875774680325287491f,0.2977497737582537329359f,\
0.3793852632159244175902f,0.4216852391721442327999f,0.7719661269702553507699f,\
0.2909766448133100369411f,0.3530800537032807717708f,0.3144419867733496687379f,\
0.9560423318471079623393f,0.7455173297127551945707f,0.7647697575929581770282f,\
0.2552307563419532465687f,1.0071246904841177904899f,0.3254058309317561237251f,\
0.2493837937457981657197f,0.4995060266703120754883f,0.3635478722517977989703f,\
0.6755663854502449439110f,0.4060422219779377672744f,0.3354119513743121228089f,\
0.3310200365444659897918f,0.4956952069626366363941f,0.0369899619573449203735f,\
0.2949888674609426608697f,0.4417162785414836534415f,0.2901327037722924995222f,\
0.3113814080983853260776f,0.0657705595388366343057f,0.3468932593605689174154f,\
0.1693138876335541220808f,0.6604383641650866110240f,0.0641696842881706724926f,\
0.5420718455446384975716f,0.0325460783396350344931f,0.2856018727381676169941f,\
0.1837045440337584378820f,0.4394912998560263073244f,0.0373805900188774464787f,\
0.0120513737523088183129f,0.5299342664002043568061f,0.3290248923514364487453f,\
0.4232813397541956845771f,0.3574733895472496092438f,0.0231976592717455104564f,\
1.388138041383984555566f,0.1495922092250967505578f,0.3027074594945061147833f,\
0.2906013786665496145822f,0.0003641583735012103801f,0.0973965246964013098285f,\
0.3558085542679609303285f,0.2850038039654740895657f,0.2413433027684695197923f,\
0.2679865438260303767137f,0.5240490385593890021454f,0.4768351880953459742685f,\
0.479037567928660701355f,0.9219838892273597430460f,0.5060637477109658499686f,\
0.3200337217432840941633f,0.1160441175011530240413f,0.2289284118436291093346f,\
0.1740340532494602521219f,0.0308192365918868102503f,0.4474996159504823212139f,\
0.601992209828681956729f,0.1542000078067730650666f,1.2334589409579821417395f,\
0.1251630868814269104128f,0.0603288006292757861271f,0.4462414520672394746548f,\
0.4738309669088760500699f,0.5239025685810345667193f,0.0238870191275340100490f,\
0.1440610501660575526461f,0.1990046768508525187880f,0.6514000598731057856128f,\
0.1047897932784156715957f,0.429099188123020058860f,0.1037294840964696623908f,\
0.6989271583573236634734f,0.3217396834648525993927f,0.1276324483471362458698f,\
0.51478179757014652651f,0.7241126844123151329313f,0.1471790945486320945079f,\
0.7963244963417922539506f,0.1499982428024713432269f,0.1685430842340138735125f,\
0.4298103979039861188838f,0.0569704807929593617932f,0.2690745622378380996764f,\
0.2759880123858853839813f,0.0260258640811948625815f,0.2968457197721043328009f,\
0.2658449701658989750008f,0.1869340145100120420540f}

#define CRESULTI {0.6606731609576530495076f,1.0352924413907944600766f,0.8208009210718538728457f,\
0.9855228198847613141354f,0.2094799364238341676803f,0.2001711092576675676824f,\
0.6157063400955946619320f,0.6758210089185754387842f,0.7073690227519786599686f,\
0.6379959312114483749312f,0.7691489792855270568595f,0.8204717538076390370705f,\
0.8992691795054111869590f,0.0127212399656787735619f,0.7965072880961274748302f,\
0.4005414846539865347808f,0.5078102333041875082742f,0.7442675929748912011519f,\
0.6446164613619681515999f,0.0651017559751383007027f,0.4292463160345246220295f,\
0.7218268661973539224164f,0.675831849442214971369f,1.016847265460205207432f,\
0.1468976923106849463707f,0.923642083424730087060f,0.7198425877508842773977f,\
0.2363604106893440193193f,0.6057859843456331327971f,0.9859934125773722746189f,\
0.4546059235344489524167f,0.1550160776744255175519f,0.5737784438019621902072f,\
0.8635696530908816281880f,0.1971722712896061546761f,0.8187472766310414096225f,\
0.3223047939566238695441f,0.3428986541358745587793f,0.1891956718334251719149f,\
0.5208354545548833369750f,0.7081524694874962166935f,0.7203267007574796210179f,\
0.6794103936977667901331f,0.3782115660166653348107f,0.8246286245352181243362f,\
0.4645139855543011786487f,0.0308839406628786498910f,0.7450942218464524646748f,\
0.4028312748892641792509f,0.1516356705950959171680f,0.7277735925258916882541f,\
0.3236400086381776008970f,0.2367328033923032648556f,0.6968150511733807173087f,\
0.3868027398676305850245f,0.8499965389936866566600f,0.1373663005352325217068f,\
0.4969728656393965771088f,0.3186158192908606912042f,0.2687494032146487410451f,\
0.4817044586911616854685f,0.8091241454316642212064f,0.7745837276131475324092f,\
0.7616864033669616951272f,0.3357065002058312042088f,0.5391311137157557276112f,\
0.4267832806356777752832f,0.4494653959304828472199f,1.07409232431056356205f,\
0.9773946189840253540027f,0.0903205143448218145119f,0.6947943813727951445358f,\
0.4320600869989819070582f,0.7345738223824911372617f,0.4980076917918512258154f,\
0.753646277499480543582f,0.3015650137112788620186f,0.1750320030662110004638f,\
0.7223173121894863601966f,0.6855367528648522723600f,0.4620100861135144620917f,\
0.6944021533252422440086f,0.5110335784375538148439f,0.3672451576697671193905f,\
0.8344551064956932107108f,0.16170594539219715347f,0.7832786921268890534265f,\
1.0189285776822756268700f,0.7988551639208606447440f,0.9719247807905779801274f,\
0.9809763387972041392970f,0.5656833224514162816732f,0.8638733429144607178785f,\
0.7441066604777042403640f,0.0602264440127683667314f,0.4402801210484636462716f,\
0.7535199884397705272221f,0.9667811691361050119298f,1.0493588871220529412653f,\
0.1602121578348635611011f,0.6872528304663769738170f,0.2746926003887739664577f,\
0.5904217499472341756928f,0.8227770718789775283852f,0.9300490141104427177510f,\
0.8608967966610167055208f,0.6761042332942854837796f,0.3862514929365022942065f,\
0.5383206023328632738867f,0.0087209580621782408633f,0.8379947814437334052684f,\
0.0514162894427564812205f,0.4107196425718538934646f,0.8291800128662117908007f,\
0.5965153474380232578866f,0.1327243053149035900695f,0.6666204349503430659496f,\
0.1078852700862242136592f,0.3410661266092010479589f,0.8978136284012265821986f,\
0.4999590426790496699994f,0.5396356462900459005638f,0.8861720904164178680418f,\
0.1966865820582558155305f,0.7384948934734244518907f,0.6889822634082830576929f,\
0.7002461629632836803694f,0.9202927678328401972507f,1.0522470356995357043672f,\
0.7633410819201092989417f,0.6825068129840573538658f,1.032180426666563732852f,\
0.6970224139462883883311f,0.4448502829538992786596f,0.5954971038562514307202f,\
0.9072269118636318019355f,0.0986096977623509007849f,0.4792818549998886235031f,\
0.6169344532127701841162f,0.5996614784596430158814f,0.6997864810760641152143f,\
0.6821778350957495851148f,0.2159298191152681511973f,0.3221001280586711645881f,\
0.3026923795099815683862f,0.1907050596442291245936f,0.7504581695080775327611f,\
0.2050797642560421019109f,0.4500993401191650811200f,1.0616552076870116039231f,\
0.3866139253948813192530f,0.2889239979563678062391f,0.0419016457354280461023f,\
0.5291730503201013124937f,0.5270449613735276317428f,0.3620065401137618765759f,\
0.2487989439191494456249f,0.9684607851607960338214f,0.4659312790851565244665f,\
0.3871941948924775833696f,0.6912156199525602007228f,0.0672566496597855195683f,\
1.0473726182255131966770f,0.3738845568372618499708f,0.4336537904037139901092f,\
0.1616849585723995341713f,0.6587810404999043800700f,0.9478245114156004236250f,\
0.7443033774708265326581f,0.7329852502477968156924f,0.3960943016785423709258f,\
0.2387102372514374737378f,0.5224647164810142241365f,0.9310236182750510902650f,\
0.0713841738247450452448f,1.0541437904171060413461f,0.3977173917051313734028f,\
0.0286922698814963753056f,0.7352303476692350070465f,0.3345177682401353491670f,\
0.7257755336052617023412f,0.4362132495206523241649f,0.7201678840265979264501f,\
0.6279860575277228518232f,0.3131701555376726897606f,0.7154672057942548235587f,\
0.7055403294219286802758f,0.90419581128384973745f,0.5774063124958943582499f,\
0.748377680093745611956f,0.3188837788675313866804f,0.8029276503063254022408f,\
0.6186055293635583929301f,0.3301554535865592887589f,0.907799805701633655275f,\
1.0004593122932974313954f,0.3297692664500386783288f,0.774518614973831232007f,\
0.8666563831612021928663f,0.5028547740750087813311f}




void stansTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out;
	int i;

	for (i=0;i<200;i++){
		out=stans(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<1e-7);
	}
}

void ctansTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=FloatComplex(inR[i],inI[i]);
		out=ctans(in);
		assert(( (fabs(creals(out)-resR[i]))/(fabs(creals(out))) )<1e-6);	
		assert(( (fabs(cimags(out)-resI[i]))/(fabs(cimags(out))) )<1e-6);			
	}
}

void stanaTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out[200];
	int i;

	stana(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<1e-6);
	}
}

void ctanaTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex *in,out[200];
	int i;

	in=FloatComplexMatrix(inR,inI,200);
	ctana(in,200,out);

	for (i=0;i<200;i++){
		assert(( (fabs(creals(out[i])-resR[i]))/(fabs(creals(out[i]))) )<1e-6);	
		assert(( (fabs(cimags(out[i])-resI[i]))/(fabs(cimags(out[i]))) )<1e-6);			
	}
}
int testTan() {
  printf("\n>>>> Float Tangeant Tests\n");
  stansTest();
  ctansTest();
  stanaTest();
  ctanaTest();

  return 0;
}

int main() {
  assert(testTan() == 0);
  return 0;
}
