/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testTanh.h"

#define SOURCE {0.7062616096809506416321,0.4090520101599395275116,0.3011248558759689331055,\
0.1880126395262777805328,0.1796709178015589714050,0.2828889950178563594818,\
0.7232380937784910202026,0.7360379849560558795929,0.1852612206712365150452,\
0.7703790138475596904755,0.1914967410266399383545,0.7521587223745882511139,\
0.6205883463844656944275,0.2807604051195085048676,0.2289868686348199844360,\
0.5049233403988182544708,0.8354099662974476814270,0.8174716415815055370331,\
0.0030740275979042053223,0.3677616142667829990387,0.8278525872156023979187,\
0.72754097869619727135,0.5323124285787343978882,0.9267726917751133441925,\
0.9542504185810685157776,0.3162104780785739421845,0.5789009965956211090088,\
0.6881225542165338993073,0.3714061146602034568787,0.1705444059334695339203,\
0.1954363007098436355591,0.978800852317363023758,0.9300233917310833930969,\
0.5357720064930617809296,0.3947123587131500244141,0.1344871171750128269196,\
0.7380615202710032463074,0.588114650454372167587,0.9113173168152570724487,\
0.5682763461954891681671,0.1127616921439766883850,0.9478473584167659282684,\
0.5237770043313503265381,0.8140139640308916568756,0.1400952627882361412048,\
0.2763446993194520473480,0.9059953633695840835571,0.1379901585169136524200,\
0.5603838684037327766419,0.3008610638789832592011,0.4767417535185813904,\
0.8127435916103422641754,0.1988414181396365165710,0.1107953130267560482025,\
0.2159351315349340438843,0.6467244853265583515167,0.6597879612818360328674,\
0.0691898013465106487274,0.9164751060307025909424,0.8635670826770365238190,\
0.5032854294404387474060,0.1832137755118310451508,0.8403698671609163284302,\
0.9247214836068451404572,0.6229452537372708320618,0.2773811477236449718475,\
0.2479109913110733032227,0.3891948559321463108063,0.0436578569933772087097,\
0.8132526441477239131928,0.7686451207846403121948,0.4041520212776958942413,\
0.8579940209165215492249,0.6993723283521831035614,0.0828925184905529022217,\
0.9201254160143435001373,0.5200281282886862754822,0.9351884997449815273285,\
0.8825624976307153701782,0.2245844271965324878693,0.2153332801535725593567,\
0.4327089670114219188690,0.5800157263875007629395,0.8876141034997999668121,\
0.5258982880041003227234,0.859640696551650762558,0.7337234076112508773804,\
0.7134532411582767963409,0.1087165409699082374573,0.8477638359181582927704,\
0.6594733335077762603760,0.7916418449021875858307,0.6067967480048537254334,\
0.4102901122532784938812,0.1958728153258562088013,0.241527963895350694656,\
0.5113455550745129585266,0.9119556057266891002655,0.0928984880447387695313,\
0.7438839026726782321930,0.1938720373436808586121,0.4355978979729115962982,\
0.9922429900616407394409,0.4533818070776760578156,0.8269640663638710975647,\
0.8889675955288112163544,0.4682085178792476654053,0.3856786251999437808991,\
0.4124865522608160972595,0.6955242282710969448090,0.0978972557932138442993,\
0.8728604433126747608185,0.6359515609219670295715,0.4129665228538215160370,\
0.0294486805796623229980,0.1809961968101561069489,0.7658103061839938163757,\
0.1232470511458814144135,0.0170737411826848983765,0.8835507561452686786652,\
0.3164170170202851295471,0.9378212536685168743134,0.3916359134018421173096,\
0.0844073877669870853424,0.6934146797284483909607,0.4618808380328118801117,\
0.9355291295796632766724,0.0842495900578796863556,0.5402926551178097724915,\
0.5613215523771941661835,0.1306025832891464233398,0.5840523042716085910797,\
0.0048661706969141960144,0.2761953338049352169037,0.7478824090212583541870,\
0.0194325004704296588898,0.6444276878610253334045,0.2243968318216502666473,\
0.2478402368724346160889,0.1196091384626924991608,0.1883201440796256065369,\
0.3393343067727982997894,0.959958622232079505920,0.2847225037403404712677,\
0.8766820700839161872864,0.2853349032811820507050,0.5103433504700660705566,\
0.8752629184164106845856,0.5941145820543169975281,0.3945342986844480037689,\
0.4661326166242361068726,0.0073588271625339984894,0.5170202488079667091370,\
0.4690007264725863933563,0.6654530800879001617432,0.9476742581464350223541,\
0.4933638339862227439880,0.2918433747254312038422,0.2016727942973375320435,\
0.7016656589694321155548,0.8736049132421612739563,0.191055159550160169601,\
0.5307010114192962646484,0.8889481076039373874664,0.0115523664280772209167,\
0.4998398735187947750092,0.6700848620384931564331,0.4995208983309566974640,\
0.1538907447829842567444,0.2571737091057002544403,0.9586529098451137542725,\
0.6246025026775896549225,0.9371285131201148033142,0.9923511571250855922699,\
0.3454555813223123550415,0.7558249053545296192169,0.2107181670144200325012,\
0.9372652801685035228729,0.6767524704337120056152,0.7465373151935636997223,\
0.4050982249900698661804,0.5101723610423505306244,0.9497965183109045028687,\
0.0289692510850727558136,0.1634070957079529762268,0.4146909262053668498993,\
0.0021650679409503936768,0.1810030029155313968658,0.4556188201531767845154,\
0.1977851442061364650726,0.6053877938538789749146,0.4363054675050079822540,\
0.8938506888225674629211,0.6104825991205871105194,0.4316215068101882934570,\
0.2315693595446646213532,0.4675927339121699333191,0.6150764389894902706146,\
0.8621218334883451461792,0.3846137975342571735382}

#define RESULT {0.6083272331025194601395,0.3876674561956683362496,0.2923416719993215950879,\
0.1858281840181150723623,0.1777622033720960281755,0.2755767974985386392639,\
0.6189110466547474986854,0.6267454363670084127591,0.1831704252906815044710,\
0.6471497862444923754310,0.1891897820789192330437,0.6364350501403950310930,\
0.5515375365220808179245,0.2736087067004031037065,0.2250667607234114742099,\
0.4659802867043164043004,0.6833702176797041838441,0.6736913883505325495449,\
0.0030740179151169427958,0.3520322698255886617602,0.6793212620436761550735,\
0.6215586405472446340781,0.4871467381023854570366,0.7290856689840882198794,\
0.7417012620322497307157,0.3060764076080783047118,0.5218661923298004712279,\
0.5967745422524275422660,0.3552210140242362257368,0.1689099681737986358154,\
0.1929854853271556480721,0.752546334797111304837,0.7306048018962054690917,\
0.4897808669902837253041,0.3754155858264546230529,0.1336821273676178090106,\
0.6279725491443334250974,0.5285382896600216984240,0.7217639239261176564710,\
0.5140922941464451945137,0.1122861813568946515174,0.7388069522259688159949,\
0.4806098503179282999120,0.6717986111263679616101,0.1391858664071369267035,\
0.2695186533316221155765,0.7192045990350994788543,0.1371209417264223628941,\
0.5082621919460940107527,0.2921004060298734161805,0.4436303990482610704049,\
0.6711009797617260019820,0.1962616190799932602840,0.1103441684263640337749,\
0.2126403628770875964271,0.5694607822364758931144,0.5782222848708917783966,\
0.0690796032269536119941,0.7242256121481682740182,0.69809096281132376749,\
0.4646970495827091318652,0.1811909351875044538183,0.6860049185734097276779,\
0.7281233753912585981993,0.5531753555435303670862,0.2704795450464865247398,\
0.2429539608603658584762,0.3706659125047845337875,0.0436301407089985798793,\
0.6713806714122574348380,0.6461409215061649780054,0.3834959767038711997422,\
0.6952226974662015779316,0.6039692179338833621927,0.0827031826719682033877,\
0.7259567403708432342668,0.4777217213658969674484,0.7330037868445029580755,\
0.7077007368815937393691,0.2208832069439833623026,0.2120656512810102645172,\
0.4075827434794156989284,0.5226768598581769120770,0.7102132909685879846862,\
0.4822394836530664030683,0.6960725041612901842214,0.6253380086104668444946,\
0.6128377044260436834477,0.1082902389835735668111,0.6898994401629748862703,\
0.5780128119634093675217,0.6593381318630107124079,0.5418683181743142451836,\
0.3887189835668665716106,0.1934057072291916479223,0.2369384549831176911550,\
0.4709929270514126020686,0.7220695597477664318120,0.0926321653854568632935,\
0.6314859919362979523427,0.1914790269022769997331,0.4099889146528875039088,\
0.7583171167988222993728,0.4246748836724252296193,0.6788424846042582228023,\
0.7108834330723724503898,0.4367506950167392987261,0.3676288421910962611605,\
0.3905819425256221721909,0.6015191410314820741334,0.0975857051379892537213,\
0.7028245349377849615635,0.5621367138424371301397,0.3909886152936559167159,\
0.0294401706564003176614,0.1790453013287252037600,0.6444866108356477329977,\
0.1226267854182154504183,0.0170720823056739953727,0.7081936907445306461639,\
0.3062635855747415369876,0.7342196272687927516287,0.3727696775311670207564,\
0.0842075009021545223264,0.6001711719907401043628,0.4316159054333421063454,\
0.7331613587758020189611,0.0840508200406931138549,0.4932094637687579607999,\
0.5089573121007661127280,0.1298650506608897969851,0.5256044879043626494308,\
0.0048661322875914753833,0.2693801321981743046585,0.6338839281129466929343,\
0.0194300547927987350694,0.5679067732631524201281,0.2207047568409323534677,\
0.2428873816732023682707,0.1190419938419155360121,0.1861250528158440442628,\
0.3268829619862821389553,0.7442584101595816070685,0.2772702073231406161291,\
0.7047532323150516031518,0.2778354302962353084006,0.4702126778004429574764,\
0.7040382261737980762462,0.5328484040985558278791,0.3752626107952297673798,\
0.43506925228714365961,0.0073586943328478923027,0.4753969607482095849349,\
0.4373915670200547722857,0.5819809696038570345777,0.7387283262105414083365,\
0.4568821823646959101595,0.2838305708191527498840,0.1989824153354164404384,\
0.6054239725907547553518,0.7032010676851431218992,0.1887639704824971842445,\
0.4859167650222710466146,0.7108737933392066388194,0.0115518525401329084923,\
0.461991216833716300538,0.5850357022343135593445,0.4617402854275272083839,\
0.1526873114812071496882,0.2516501130208930181453,0.7436753924988391828421,\
0.5543244269171754279313,0.7339001657945646295289,0.7583630791792929093376,\
0.3323391775157006899910,0.6386111600303081559105,0.2076538016886759763224,\
0.7339632624841636587831,0.5894041048692751916249,0.6330786187202321890766,\
0.3843027300435838400361,0.4700794834210440531486,0.7396909169647786219670,\
0.0289611499702619457075,0.1619680384735620870540,0.3924484198089013831101,\
0.0021650645580242309542,0.1790518892412555074234,0.4265067109232646425099,\
0.1952458211607971949597,0.5408723031703753791888,0.4105773773696593798022,\
0.7132904548568874680825,0.5444667235672814298297,0.4066755344379027192758,\
0.2275170058253208615895,0.4362522385676954606026,0.5476906607425194861705,\
0.6973492805657204307579,0.3667075667170831554387}

#define ZSOURCER {0.6045256052166223526001,0.9455216196365654468536,0.4476299257948994636536,\
0.8624908211641013622284,0.1751048639416694641113,0.2067177616991102695465,\
0.6848411662504076957703,0.1348653226159512996674,0.0069159921258687973022,\
0.1496290047653019428253,0.5665438110008835792542,0.4359452719800174236298,\
0.6547604538500308990479,0.3381605879403650760651,0.4259321158751845359802,\
0.3060420057736337184906,0.7704779822379350662231,0.7058695447631180286408,\
0.2373670237138867378235,0.8205849635414779186249,0.6789963841438293457031,\
0.5250809141434729099274,0.3359806565567851066589,0.8941988362930715084076,\
0.5461782198399305343628,0.7568633262999355792999,0.0259526828303933143616,\
0.3250150899402797222138,0.6072143577039241791,0.8756139636971056461334,\
0.2962085595354437828064,0.4229678637348115444183,0.4243144039064645767212,\
0.7620028969831764698029,0.3622896494343876838684,0.5658242437057197093964,\
0.6424440070986747741699,0.7580267959274351596832,0.2531452132388949394226,\
0.5266989110969007015228,0.2118590380996465682983,0.4779220153577625751495,\
0.1615962767973542213440,0.9168031658045947551727,0.5461866445839405059815,\
0.4686870560981333255768,0.7772213732823729515076,0.5871783248148858547211,\
0.5848031807690858840942,0.3139644009061157703400,0.3204141603782773017883,\
0.3331634956412017345429,0.2282590121030807495117,0.2750317254103720188141,\
0.4963629124686121940613,0.7453477247618138790131,0.1155001949518918991089,\
0.0626524840481579303741,0.0877018878236413002014,0.5507565210573375225067,\
0.2116370312869548797607,0.8335358710028231143951,0.4045845707878470420837,\
0.2880227542482316493988,0.1750094983726739883423,0.0051561561413109302521,\
0.3109287889674305915833,0.6602919283322989940643,0.9722995534539222717285,\
0.9826813959516584873200,0.0455837054178118705750,0.4096118300221860408783,\
0.7104403134435415267944,0.3917615194804966449738,0.5571686858311295509338,\
0.0565565521828830242157,0.1540721096098423004150,0.9109257892705500125885,\
0.5713340407237410545349,0.3488348922692239284515,0.8972954172641038894653,\
0.2973396372981369495392,0.1091936426237225532532,0.7626331257633864879608,\
0.6584706604480743408203,0.6996708759106695652008,0.6756794182583689689636,\
0.9004421546123921871185,0.6668148916214704513550,0.8518152837641537189484,\
0.8365677157416939735413,0.1291190306656062602997,0.6095453463494777679443,\
0.2412315667606890201569,0.4029275467619299888611,0.3019328541122376918793,\
0.1083198729902505874634,0.8456356939859688282013,0.9417407037690281867981,\
0.9083450469188392162323,0.1937242373824119567871,0.5318046086467802524567,\
0.8314437521621584892273,0.4952740012668073177338,0.7465563025325536727905,\
0.7102393140085041522980,0.5811418974772095680237,0.7035941029898822307587,\
0.3746570833027362823486,0.3394373343326151371002,0.6322447275742888450623,\
0.7636191300116479396820,0.6940386760979890823364,0.8735245508141815662384,\
0.3612738298252224922180,0.7933200257830321788788,0.4830590635538101196289,\
0.2469964125193655490875,0.5025922833010554313660,0.7430270477198064327240,\
0.6783937942236661911011,0.4903185223229229450226,0.709806025959551334381,\
0.3303662906400859355927,0.6815545372664928436279,0.0701365978457033634186,\
0.4745870968326926231384,0.8091805852018296718597,0.9447045121341943740845,\
0.5478458073921501636505,0.1216687532141804695129,0.9161847713403403759003,\
0.3045207932591438293457,0.6502694808878004550934,0.0987624628469347953796,\
0.8391053467057645320892,0.0328534897416830062866,0.3461971958167850971222,\
0.2801467711105942726135,0.5500544901005923748016,0.0729318000376224517822,\
0.0225322381593286991119,0.50267804320901632309,0.3478884599171578884125,\
0.4298669416457414627075,0.3537984383292496204376,0.0529730813577771186829,\
0.9533003675751388072968,0.1842019557952880859375,0.958756382111459970474,\
0.3245136169716715812683,0.0003973259590566158295,0.0972583871334791183472,\
0.4378789965994656086,0.3634226778522133827210,0.2685119728557765483856,\
0.2770298384130001068115,0.8854365111328661441803,0.5216628303751349449158,\
0.4979983693920075893,0.8733724001795053482056,0.4699407932348549365997,\
0.9364062966778874397278,0.1337622734718024730682,0.2712419554591178894043,\
0.1766990595497190952301,0.0543269468471407890320,0.8402757882140576839447,\
0.7507283594459295272827,0.3062269617803394794464,0.9195641661062836647034,\
0.1318263853900134563446,0.0826364941895008087158,0.8222710476256906986237,\
0.4441085970029234886169,0.9617503038607537746429,0.0283641982823610305786,\
0.1431905967183411121368,0.3793597565963864326477,0.6144003230147063732147,\
0.2128270715475082397461,0.4704488315619528293610,0.2076055286452174186707,\
0.7435979112051427364349,0.3391801547259092330933,0.2479635034687817096710,\
0.6721735307946801185608,0.9013197491876780986786,0.2140864841639995574951,\
0.8460668534971773624420,0.1650043567642569541931,0.4003686285577714443207,\
0.5522825215011835098267,0.0638249483890831470490,0.6903966935351490974426,\
0.8547787251882255077362,0.0291904583573341369629,0.5434663915075361728668,\
0.6236743135377764701843,0.2417052476666867733002}

#define ZSOURCEI {0.5503273960202932357788,0.6906704087741672992706,0.9835249418392777442932,\
0.8285484607331454753876,0.2062614001333713531494,0.1944643096067011356354,\
0.4367609983310103416443,0.8090620837174355983734,0.8818644303828477859497,\
0.7404803228564560413361,0.7542522149160504341126,0.9921960639767348766327,\
0.9886121451854705810547,0.0113218077458441257477,0.9367801276966929435730,\
0.3874237253330647945404,0.2886805813759565353394,0.567788839805871248245,\
0.7295644441619515419006,0.0303032915107905864716,0.2795897088944911956787,\
0.7047131718136370182037,0.7442112853750586509705,0.8920237845741212368012,\
0.1081438604742288589478,0.8751525697298347949982,0.9068333031609654426575,\
0.2166852983646094799042,0.4824190363287925720215,0.7766945236362516880035,\
0.4510916722938418388367,0.1300636469386518001556,0.5505470838397741317749,\
0.6936193336732685565949,0.1749099576845765113831,0.8636093880049884319305,\
0.2150467522442340850830,0.1886725709773600101471,0.1796098565682768821716,\
0.4374312213622033596039,0.8514516223222017288208,0.7381969136185944080353,\
0.8102188156917691230774,0.1460137623362243175507,0.8999849110841751098633,\
0.4043733575381338596344,0.0156995235010981559753,0.6904196902178227901459,\
0.2990311514586210250855,0.1383218024857342243195,0.8478512773290276527405,\
0.3007262717001140117645,0.229154746979475021362,0.8078110129572451114655,\
0.3176332255825400352478,0.6924462593160569667816,0.1364154014736413955689,\
0.5433279541321098804474,0.3276594849303364753723,0.2006831648759543895721,\
0.5037304237484931945801,0.4962565028108656406403,0.8996161324903368949890,\
0.9357709079049527645111,0.3390339072793722152710,0.6029155333526432514191,\
0.4153500730171799659729,0.3041478390805423259735,0.8489827848970890045166,\
0.4482063786126673221588,0.0903797810897231101990,0.7382151386700570583344,\
0.2669597584754228591919,0.8226196658797562122345,0.3985779182985424995422,\
0.9789295899681746959686,0.3041231036186218261719,0.0663515278138220310211,\
0.6667758254334330558777,0.7548807277344167232513,0.1922533493489027023315,\
0.7942791883833706378937,0.5580398896709084510803,0.2016023616306483745575,\
0.787146832793951034546,0.0955459238030016422272,0.6623697867617011070252,\
0.864868474658578634262,0.7013061288744211196899,0.8015053984709084033966,\
0.9135685982182621955872,0.6317234965972602367401,0.9346773549914360046387,\
0.9157753759063780307770,0.0510348035022616386414,0.4329969524405896663666,\
0.9721843507140874862671,0.8001508046872913837433,0.8452261472120881080627,\
0.0610524858348071575165,0.8168097324669361114502,0.2101262793876230716705,\
0.3055453812703490257263,0.9465212575159966945648,0.9269728232175111770630,\
0.7737778765149414539337,0.5893978821113705635071,0.2377697187475860118866,\
0.5269544571638107299805,0.0077543654479086399078,0.8311711428686976432800,\
0.0268517597578465938568,0.2591186594218015670776,0.4641277943737804889679,\
0.6098861405625939369202,0.0656952331773936748505,0.6466812007129192352295,\
0.1018534512259066104889,0.2742705782875418663025,0.8162728524766862392426,\
0.3357750270515680313110,0.4765891996212303638458,0.8440040023997426033020,\
0.1785074654035270214081,0.5855625644326210021973,0.8426241897977888584137,\
0.7058847947046160697937,0.7396617024205625057221,0.9751448985189199447632,\
0.7606669445522129535675,0.8236690396443009376526,0.8889620001427829265595,\
0.7960178293287754058838,0.3052428201772272586823,0.6803312664851546287537,\
0.6412069997750222682953,0.0988248009234666824341,0.4654508423991501331329,\
0.6714970665052533149719,0.5131103205494582653046,0.8631567060947418212891,\
0.8328299173153936862946,0.1687975851818919181824,0.2961277081631124019623,\
0.2591485660523176193237,0.1700844173319637775421,0.9718958893790841102600,\
0.0695185582153499126434,0.4696230851113796234131,0.9544191421009600162506,\
0.3679352095350623130798,0.2973918146453797817230,0.0415310803800821304321,\
0.4892336544580757617950,0.5171590568497776985169,0.3534862431697547435761,\
0.2354387864470481872559,0.6779259913600981235504,0.3834532154724001884460,\
0.3174350797198712825775,0.3418120350688695907593,0.0535557498224079608917,\
0.9285596096888184547424,0.3862650538794696331024,0.4328473098576068878174,\
0.1581165478564798831940,0.7887120461091399192810,0.7448797873221337795258,\
0.5185996759682893753052,0.8651678604073822498322,0.1524438308551907539368,\
0.2392775672487914562225,0.5761575847864151000977,0.7395762302912771701813,\
0.0583172617480158805847,0.6962534948252141475678,0.4206145536154508590698,\
0.0281158541329205036163,0.8313249954953789710999,0.2333360086195170879364,\
0.8865877203643321990967,0.3746785433031618595123,0.87671328987926244736,\
0.4027077830396592617035,0.2890332732349634170532,0.8538430598564445972443,\
0.5499771209433674812317,0.5128610017709434032440,0.6321087554097175598145,\
0.4165538274683058261871,0.3217771751806139945984,0.9717370062135159969330,\
0.5348322447389364242554,0.3416590173728764057159,0.9565287167206406593323,\
0.9951003189198672771454,0.3422884084284305572510,0.7870580093003809452057,\
0.9234123295173048973084,0.5238970420323312282562}

#define ZRESULTR {0.6700223015238303547747,0.9051590648529930227539,0.9783774998303537140387,\
0.9672554578415690773596,0.1806879116022510611828,0.2113884833531175511112,\
0.6724311908168314477763,0.2759693779071136221504,0.0171117603025009445972,\
0.2676571377242007998554,0.7836070482910290069256,0.9837911114618788088748,\
1.0787649507707848250959,0.3258715909732741722316,0.8818391305817397940459,\
0.3412489698350346656319,0.6791962837910036077105,0.7436127103435716811930,\
0.40184826884232582866,0.6757254959645757619313,0.6216816234807176488886,\
0.7106811634553994450059,0.5496317899100798820555,1.015517869987778709628,\
0.5020506061187628432663,0.9811456923663512963429,0.0682501782366792819623,\
0.3276872649171290174941,0.6393144648282618192070,0.9360249253515308121010,\
0.3486021801541281939230,0.405155698729944113712,0.5200555835311830854550,\
0.8452234271752276928424,0.3567295147730688009702,0.8928456199942530480129,\
0.5846382117554749235922,0.6534877266970448017602,0.2555268336748864332897,\
0.5599022272385358878211,0.4549851524880720865518,0.6983186009546583639107,\
0.3278445848029415965463,0.7317436304730139395858,0.9243668151604532701171,\
0.4997101034619103598899,0.6512014053656888235011,0.7461784468374338397112,\
0.5613804235723615088105,0.309377290465780441231,0.6302193796318024121561,\
0.3488048678688123183100,0.2359369023748482674385,0.5207697215592063111345,\
0.4975483327992256676886,0.8371220343907752603485,0.1171268218028372609663,\
0.085272785233540815408,0.0974986984973703479929,0.5164560743022618138909,\
0.2683348894394235739647,0.7764310536494951620057,0.8045234481921298419493,\
0.6958959159533119054331,0.1940650650900959395262,0.0075996484393591736892,\
0.3536342521606328781481,0.6152689741862609196232,0.9952856734893198442649,\
0.8206704954595607226509,0.0459255053037718463660,0.6307753783837566352588,\
0.6388147154641353742122,0.6937233166977520015806,0.5697295509652193779004,\
0.1802327077236753061218,0.1675371469878289276689,0.7230999921866064772402,\
0.7176490691010239952874,0.5749086647774364067232,0.7279693322506849417763,\
0.5413870504782296588786,0.1504476557625347432623,0.6581157602540366191590,\
0.8675383161064098569426,0.6076707020048850438343,0.7819483789931592765399,\
0.9976690503006511168138,0.8038234125831255072470,0.9466047824946693944881,\
1.0263044057305568124150,0.1954383476167207978058,0.9991226583234396052546,\
0.5824462236684256888353,0.3833026614151368027805,0.3492943337672331227672,\
0.3315115099350262606315,0.9442386171423264862312,0.9899258002262354416700,\
0.7216294786971718666635,0.3920325460401206107974,0.5034740230892749135450,\
0.715969761025848305813,0.9550125571098367904810,1.0265780142294762544708,\
0.8803585794351714843842,0.6748726933268143213240,0.6286862272305427934427,\
0.4593360950510761986365,0.3269925373376404986736,0.8950979801820350134634,\
0.6434757060207739742808,0.6268824366882729259842,0.7824259493911607243888,\
0.4869178781705328362683,0.6618946105318512795890,0.6319261919275969141552,\
0.2444724751522657224534,0.4924981727592058766696,0.9272283746811394999909,\
0.6354081057135144705583,0.5455716136398853777223,0.9397290975289604997300,\
0.3281437517029104355970,0.7390025847943897385761,0.1571298352097142136952,\
0.6681717696917298665582,0.893260926700763513431,1.0727843133940448971941,\
0.7758756582495047737780,0.2577884404871108037227,1.0152118695965053341013,\
0.553316515865495128779,0.6088582613070312454795,0.1618775254222162562900,\
0.8458278989313633422498,0.0331641659985394132715,0.4056540942022494600217,\
0.4254458405105830398618,0.6108828412056167556088,0.1710530527126769284596,\
0.0497407205620656947542,0.4747317015892947855704,0.3618696796533303894350,\
0.4287418625744875422257,0.3485740919790226710617,0.1655375133873851212218,\
0.7428884062630719542497,0.2271172969578298117543,1.0587395337282918816868,\
0.3549940948693925402147,0.0004346469449674766222,0.0971187244038783509259,\
0.5043807505243238509252,0.4434874448032950500220,0.2951797103676901401492,\
0.2845053188094572860223,0.8815102337365799956004,0.5368898054807562658652,\
0.4988328370209159090543,0.745435623332440511213,0.4391683137636283595917,\
1.0422403039497714072326,0.1545117394214212958037,0.3165746040477503964183,\
0.1791895467797269270172,0.1089461488105609721089,0.9065124792766549033374,\
0.7446224625751999282031,0.6296662678760955866864,0.7337000953456223051319,\
0.1387263358911398902773,0.1169149268680415021393,0.8975235374861081361075,\
0.4182178630757872883628,0.9119369228139623251295,0.0340248805832462572485,\
0.1423301258754861298161,0.6888548451397347172076,0.5685106882588889520847,\
0.4923020191500164788323,0.4917581413760083730580,0.4716616017939372351719,\
0.6955693872489776552470,0.3523112018531558975454,0.5222250480132760719343,\
0.7144705774015845944902,0.8119440584245034564503,0.3164274689259520823015,\
0.7538323331802344595687,0.1811571114058267151226,0.9128449761317551924833,\
0.6233160136433549824986,0.0717615749734574065455,1.0473491540209625139113,\
1.0924869453095222837646,0.0328835678516360627177,0.7973589739562461087274,\
0.9908609316019793000763,0.3104246876762664641980}

#define ZRESULTI {0.3914561710408779870996,0.2745677431871340612446,0.8850988190375015385314,\
0.3546606100359354085683,0.2026838146454169320432,0.1884673919393772267839,\
0.2801601885873738484456,1.0096958835716720592757,1.21412343558816204769,\
0.8776375911322839007411,0.5620073675207013508270,0.9130433942963852578245,\
0.5770284711891953133289,0.0101200891695042028556,0.8779935002098492313749,\
0.3667139971005198284537,0.1664312994282131086266,0.3494312783943472333625,\
0.8104125516371111226377,0.0164786111567649697085,0.1816457336156695190343,\
0.5593166230651334114299,0.7569161316066348454967,0.3415023725885689698245,\
0.0814423238542508892701,0.4465689540632135634546,1.275733507144991119020,\
0.197487841611818731868,0.3421719548772197971864,0.3349549978483222778536,\
0.4357966181675047567801,0.1096343010109522564388,0.4859836370575167374675,\
0.3800931088000560897910,0.1548265257107722947527,0.6348894325615116462913,\
0.1460748031318926942745,0.1110957110750060844451,0.1700664034230296439709,\
0.3412176537402174525404,1.0332395638414424432483,0.6273383485614248966655,\
0.9957192459042429888427,0.0691093109901288471519,0.6804424693811944591104,\
0.3344738416260302771299,0.0090436204351948476510,0.5006804162977720462635,\
0.2172201211207329951680,0.1261162082552027552396,0.9120640605812813106468,\
0.2753688308103523496584,0.2209039383694014757609,0.8997305533684579748055,\
0.2536420004619579504634,0.3903699376999557602019,0.1354191697515705339328,\
0.6007399379388951299319,0.3370127497194151389159,0.1507780721992685313282,\
0.5203153088877445764382,0.254583375618394558426,0.8702994198605253917123,\
1.0924089238964773684870,0.3407939274374255367306,0.6883985279629690756664,\
0.3940203751449571356602,0.2021529986071308460094,0.2883410464579913012884,\
0.1832164764792163502705,0.0904370855097187398286,0.6870692259557662495695,\
0.1667494081756663859562,0.7986735402486416779411,0.2997470364729120650971,\
1.4723672873315984954701,0.3058215886262277694030,0.0317778181669746695448,\
0.4953897349233554736614,0.7593857543036769408573,0.0933417291983620195373,\
0.8587250458616788595379,0.6140082043678934953235,0.1179425317948916696054,\
0.5008800041022678506408,0.0606528647874819346053,0.4208891412439614287955,\
0.3345057926491249999934,0.4488362148523600825278,0.356228513965734405744,\
0.3862019012866550471408,0.7133939454258028112221,0.6183512140459618278143,\
1.122372846973830329276,0.0435912326295722213354,0.4149318455829275609226,\
1.4136182419356593253923,0.360095911709175209303,0.3059781012378688380693,\
0.0293528815458468754496,0.9850054988638156094893,0.1610071461548980287226,\
0.1615738175268226772818,0.7804595725744208900565,0.4664649257591839126569,\
0.4516332153201338406312,0.4324429865103157633044,0.1499229835931424337225,\
0.4861395789308433634801,0.0069254200843589181283,0.5470248281814621416075,\
0.0157419761082240212968,0.1652796264802975090280,0.2251845784941430561599,\
0.5809144105432306748327,0.0370371154221026954723,0.5409142410066014594605,\
0.0961579912696427369090,0.2170435871168209518434,0.4413938390627674124289,\
0.2180518991856933708196,0.3882731529916919055445,0.4793791546290147587150,\
0.1615500633583723533171,0.3727683427019338191499,1.1092002442556854191480,\
0.6007159335006776457178,0.3670729131136168943428,0.3082959548830728202518,\
0.5833221942824414751883,1.0459318594890267828390,0.3263494274187709875967,\
0.8544844347571096676575,0.2053831793406840910965,0.7963141410348304471967,\
0.3137393761405720127300,0.0990397931617461729781,0.4344101753145302446946,\
0.7023788886417181576150,0.3911554522022889779365,1.1544412437572197926983,\
1.0984333102013155158971,0.1328621940810992829718,0.268167531788618462851,\
0.2190523476868022068054,0.1514050595867235948777,1.452314392851102864412,\
0.0312862499326923282350,0.4864975811326933685663,0.3000795354832859751504,\
0.3425769720223186820540,0.3064807342294366687696,0.0411636957365836206324,\
0.4217989293277185081088,0.4809545441238126106676,0.3404220390913085259044,\
0.2214498702533347351817,0.3018772698523388142711,0.2996779751331964392058,\
0.2530674633040843612974,0.1693130128868851891344,0.0432918302807213800643,\
0.3147578695966239403781,0.3983398179395671312442,0.4233396532725078320603,\
0.1544509091417925472634,1.000697611141370568788,0.3487050795605025621526,\
0.3006071168291280515383,0.9542614300639570279472,0.0718340034799053589465,\
0.2395154786718341477503,0.6434277607558438472069,0.3585399891990152521082,\
0.0482004898594938432921,0.2679535503180693334357,0.4468782830994436072736,\
0.0275539888537934679613,0.8228411197528838760817,0.1637277172538824099313,\
1.0994704384405307173722,0.3084433992108448485681,1.0856016429316568405739,\
0.2389273879432435854220,0.2631293443272026966184,1.0016126450700377770175,\
0.3562135410626017795188,0.2353197404250201296705,0.6834823618792332799998,\
0.2126404560740041416178,0.3234875849405334791165,0.9562375286253093076283,\
0.4069690501749418376498,0.3539780611029934576095,0.5294802297322954709458,\
0.3733196120144765539628,0.3559718013547358839155,0.6068341504607892566980,\
0.5969952503542278465787,0.5352237566999263895795}



void dtanhsTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out;
	int i;

	for (i=0;i<200;i++){
		out=dtanhs(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<3e-16);
	}
}

void ztanhsTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=DoubleComplex(inR[i],inI[i]);
		out=ztanhs(in);
		assert(( (fabs(zreals(out)-resR[i]))/(fabs(zreals(out))) )<3e-15);	
		assert(( (fabs(zimags(out)-resI[i]))/(fabs(zimags(out))) )<3e-15);			
	}
}

void dtanhaTest(void) {
	double in[]=SOURCE;
	double res[]=RESULT;
	double out[200];
	int i;

	dtanha(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<3e-15);
	}
}

void ztanhaTest(void) {
	double inR[]=ZSOURCER;
	double inI[]=ZSOURCEI;
	double resR[]=ZRESULTR;
	double resI[]=ZRESULTI;
	doubleComplex *in,out[200];
	int i;


	in=DoubleComplexMatrix(inR,inI,200);
	ztanha(in,200,out);

	for (i=0;i<200;i++){
		assert(( (fabs(zreals(out[i])-resR[i]))/(fabs(zreals(out[i]))) )<3e-15);	
		assert(( (fabs(zimags(out[i])-resI[i]))/(fabs(zimags(out[i]))) )<3e-15);			
	}
}


int testTanh() {
  printf("\n>>>> Double Hyperbolic Tangeant Tests\n");
  dtanhsTest();
  ztanhsTest();
  dtanhaTest();
  ztanhaTest();
  return 0;
}

int main() {
  assert(testTanh() == 0);
  return 0;
}
