/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "testTanh.h"

#define SOURCE {0.7062616096809506416321f,0.4090520101599395275116f,0.3011248558759689331055f,\
0.1880126395262777805328f,0.1796709178015589714050f,0.2828889950178563594818f,\
0.7232380937784910202026f,0.7360379849560558795929f,0.1852612206712365150452f,\
0.7703790138475596904755f,0.1914967410266399383545f,0.7521587223745882511139f,\
0.6205883463844656944275f,0.2807604051195085048676f,0.2289868686348199844360f,\
0.5049233403988182544708f,0.8354099662974476814270f,0.8174716415815055370331f,\
0.0030740275979042053223f,0.3677616142667829990387f,0.8278525872156023979187f,\
0.72754097869619727135f,0.5323124285787343978882f,0.9267726917751133441925f,\
0.9542504185810685157776f,0.3162104780785739421845f,0.5789009965956211090088f,\
0.6881225542165338993073f,0.3714061146602034568787f,0.1705444059334695339203f,\
0.1954363007098436355591f,0.978800852317363023758f,0.9300233917310833930969f,\
0.5357720064930617809296f,0.3947123587131500244141f,0.1344871171750128269196f,\
0.7380615202710032463074f,0.588114650454372167587f,0.9113173168152570724487f,\
0.5682763461954891681671f,0.1127616921439766883850f,0.9478473584167659282684f,\
0.5237770043313503265381f,0.8140139640308916568756f,0.1400952627882361412048f,\
0.2763446993194520473480f,0.9059953633695840835571f,0.1379901585169136524200f,\
0.5603838684037327766419f,0.3008610638789832592011f,0.4767417535185813904f,\
0.8127435916103422641754f,0.1988414181396365165710f,0.1107953130267560482025f,\
0.2159351315349340438843f,0.6467244853265583515167f,0.6597879612818360328674f,\
0.0691898013465106487274f,0.9164751060307025909424f,0.8635670826770365238190f,\
0.5032854294404387474060f,0.1832137755118310451508f,0.8403698671609163284302f,\
0.9247214836068451404572f,0.6229452537372708320618f,0.2773811477236449718475f,\
0.2479109913110733032227f,0.3891948559321463108063f,0.0436578569933772087097f,\
0.8132526441477239131928f,0.7686451207846403121948f,0.4041520212776958942413f,\
0.8579940209165215492249f,0.6993723283521831035614f,0.0828925184905529022217f,\
0.9201254160143435001373f,0.5200281282886862754822f,0.9351884997449815273285f,\
0.8825624976307153701782f,0.2245844271965324878693f,0.2153332801535725593567f,\
0.4327089670114219188690f,0.5800157263875007629395f,0.8876141034997999668121f,\
0.5258982880041003227234f,0.859640696551650762558f,0.7337234076112508773804f,\
0.7134532411582767963409f,0.1087165409699082374573f,0.8477638359181582927704f,\
0.6594733335077762603760f,0.7916418449021875858307f,0.6067967480048537254334f,\
0.4102901122532784938812f,0.1958728153258562088013f,0.241527963895350694656f,\
0.5113455550745129585266f,0.9119556057266891002655f,0.0928984880447387695313f,\
0.7438839026726782321930f,0.1938720373436808586121f,0.4355978979729115962982f,\
0.9922429900616407394409f,0.4533818070776760578156f,0.8269640663638710975647f,\
0.8889675955288112163544f,0.4682085178792476654053f,0.3856786251999437808991f,\
0.4124865522608160972595f,0.6955242282710969448090f,0.0978972557932138442993f,\
0.8728604433126747608185f,0.6359515609219670295715f,0.4129665228538215160370f,\
0.0294486805796623229980f,0.1809961968101561069489f,0.7658103061839938163757f,\
0.1232470511458814144135f,0.0170737411826848983765f,0.8835507561452686786652f,\
0.3164170170202851295471f,0.9378212536685168743134f,0.3916359134018421173096f,\
0.0844073877669870853424f,0.6934146797284483909607f,0.4618808380328118801117f,\
0.9355291295796632766724f,0.0842495900578796863556f,0.5402926551178097724915f,\
0.5613215523771941661835f,0.1306025832891464233398f,0.5840523042716085910797f,\
0.0048661706969141960144f,0.2761953338049352169037f,0.7478824090212583541870f,\
0.0194325004704296588898f,0.6444276878610253334045f,0.2243968318216502666473f,\
0.2478402368724346160889f,0.1196091384626924991608f,0.1883201440796256065369f,\
0.3393343067727982997894f,0.959958622232079505920f,0.2847225037403404712677f,\
0.8766820700839161872864f,0.2853349032811820507050f,0.5103433504700660705566f,\
0.8752629184164106845856f,0.5941145820543169975281f,0.3945342986844480037689f,\
0.4661326166242361068726f,0.0073588271625339984894f,0.5170202488079667091370f,\
0.4690007264725863933563f,0.6654530800879001617432f,0.9476742581464350223541f,\
0.4933638339862227439880f,0.2918433747254312038422f,0.2016727942973375320435f,\
0.7016656589694321155548f,0.8736049132421612739563f,0.191055159550160169601f,\
0.5307010114192962646484f,0.8889481076039373874664f,0.0115523664280772209167f,\
0.4998398735187947750092f,0.6700848620384931564331f,0.4995208983309566974640f,\
0.1538907447829842567444f,0.2571737091057002544403f,0.9586529098451137542725f,\
0.6246025026775896549225f,0.9371285131201148033142f,0.9923511571250855922699f,\
0.3454555813223123550415f,0.7558249053545296192169f,0.2107181670144200325012f,\
0.9372652801685035228729f,0.6767524704337120056152f,0.7465373151935636997223f,\
0.4050982249900698661804f,0.5101723610423505306244f,0.9497965183109045028687f,\
0.0289692510850727558136f,0.1634070957079529762268f,0.4146909262053668498993f,\
0.0021650679409503936768f,0.1810030029155313968658f,0.4556188201531767845154f,\
0.1977851442061364650726f,0.6053877938538789749146f,0.4363054675050079822540f,\
0.8938506888225674629211f,0.6104825991205871105194f,0.4316215068101882934570f,\
0.2315693595446646213532f,0.4675927339121699333191f,0.6150764389894902706146f,\
0.8621218334883451461792f,0.3846137975342571735382f}

#define RESULT {0.6083272331025194601395f,0.3876674561956683362496f,0.2923416719993215950879f,\
0.1858281840181150723623f,0.1777622033720960281755f,0.2755767974985386392639f,\
0.6189110466547474986854f,0.6267454363670084127591f,0.1831704252906815044710f,\
0.6471497862444923754310f,0.1891897820789192330437f,0.6364350501403950310930f,\
0.5515375365220808179245f,0.2736087067004031037065f,0.2250667607234114742099f,\
0.4659802867043164043004f,0.6833702176797041838441f,0.6736913883505325495449f,\
0.0030740179151169427958f,0.3520322698255886617602f,0.6793212620436761550735f,\
0.6215586405472446340781f,0.4871467381023854570366f,0.7290856689840882198794f,\
0.7417012620322497307157f,0.3060764076080783047118f,0.5218661923298004712279f,\
0.5967745422524275422660f,0.3552210140242362257368f,0.1689099681737986358154f,\
0.1929854853271556480721f,0.752546334797111304837f,0.7306048018962054690917f,\
0.4897808669902837253041f,0.3754155858264546230529f,0.1336821273676178090106f,\
0.6279725491443334250974f,0.5285382896600216984240f,0.7217639239261176564710f,\
0.5140922941464451945137f,0.1122861813568946515174f,0.7388069522259688159949f,\
0.4806098503179282999120f,0.6717986111263679616101f,0.1391858664071369267035f,\
0.2695186533316221155765f,0.7192045990350994788543f,0.1371209417264223628941f,\
0.5082621919460940107527f,0.2921004060298734161805f,0.4436303990482610704049f,\
0.6711009797617260019820f,0.1962616190799932602840f,0.1103441684263640337749f,\
0.2126403628770875964271f,0.5694607822364758931144f,0.5782222848708917783966f,\
0.0690796032269536119941f,0.7242256121481682740182f,0.69809096281132376749f,\
0.4646970495827091318652f,0.1811909351875044538183f,0.6860049185734097276779f,\
0.7281233753912585981993f,0.5531753555435303670862f,0.2704795450464865247398f,\
0.2429539608603658584762f,0.3706659125047845337875f,0.0436301407089985798793f,\
0.6713806714122574348380f,0.6461409215061649780054f,0.3834959767038711997422f,\
0.6952226974662015779316f,0.6039692179338833621927f,0.0827031826719682033877f,\
0.7259567403708432342668f,0.4777217213658969674484f,0.7330037868445029580755f,\
0.7077007368815937393691f,0.2208832069439833623026f,0.2120656512810102645172f,\
0.4075827434794156989284f,0.5226768598581769120770f,0.7102132909685879846862f,\
0.4822394836530664030683f,0.6960725041612901842214f,0.6253380086104668444946f,\
0.6128377044260436834477f,0.1082902389835735668111f,0.6898994401629748862703f,\
0.5780128119634093675217f,0.6593381318630107124079f,0.5418683181743142451836f,\
0.3887189835668665716106f,0.1934057072291916479223f,0.2369384549831176911550f,\
0.4709929270514126020686f,0.7220695597477664318120f,0.0926321653854568632935f,\
0.6314859919362979523427f,0.1914790269022769997331f,0.4099889146528875039088f,\
0.7583171167988222993728f,0.4246748836724252296193f,0.6788424846042582228023f,\
0.7108834330723724503898f,0.4367506950167392987261f,0.3676288421910962611605f,\
0.3905819425256221721909f,0.6015191410314820741334f,0.0975857051379892537213f,\
0.7028245349377849615635f,0.5621367138424371301397f,0.3909886152936559167159f,\
0.0294401706564003176614f,0.1790453013287252037600f,0.6444866108356477329977f,\
0.1226267854182154504183f,0.0170720823056739953727f,0.7081936907445306461639f,\
0.3062635855747415369876f,0.7342196272687927516287f,0.3727696775311670207564f,\
0.0842075009021545223264f,0.6001711719907401043628f,0.4316159054333421063454f,\
0.7331613587758020189611f,0.0840508200406931138549f,0.4932094637687579607999f,\
0.5089573121007661127280f,0.1298650506608897969851f,0.5256044879043626494308f,\
0.0048661322875914753833f,0.2693801321981743046585f,0.6338839281129466929343f,\
0.0194300547927987350694f,0.5679067732631524201281f,0.2207047568409323534677f,\
0.2428873816732023682707f,0.1190419938419155360121f,0.1861250528158440442628f,\
0.3268829619862821389553f,0.7442584101595816070685f,0.2772702073231406161291f,\
0.7047532323150516031518f,0.2778354302962353084006f,0.4702126778004429574764f,\
0.7040382261737980762462f,0.5328484040985558278791f,0.3752626107952297673798f,\
0.43506925228714365961f,0.0073586943328478923027f,0.4753969607482095849349f,\
0.4373915670200547722857f,0.5819809696038570345777f,0.7387283262105414083365f,\
0.4568821823646959101595f,0.2838305708191527498840f,0.1989824153354164404384f,\
0.6054239725907547553518f,0.7032010676851431218992f,0.1887639704824971842445f,\
0.4859167650222710466146f,0.7108737933392066388194f,0.0115518525401329084923f,\
0.461991216833716300538f,0.5850357022343135593445f,0.4617402854275272083839f,\
0.1526873114812071496882f,0.2516501130208930181453f,0.7436753924988391828421f,\
0.5543244269171754279313f,0.7339001657945646295289f,0.7583630791792929093376f,\
0.3323391775157006899910f,0.6386111600303081559105f,0.2076538016886759763224f,\
0.7339632624841636587831f,0.5894041048692751916249f,0.6330786187202321890766f,\
0.3843027300435838400361f,0.4700794834210440531486f,0.7396909169647786219670f,\
0.0289611499702619457075f,0.1619680384735620870540f,0.3924484198089013831101f,\
0.0021650645580242309542f,0.1790518892412555074234f,0.4265067109232646425099f,\
0.1952458211607971949597f,0.5408723031703753791888f,0.4105773773696593798022f,\
0.7132904548568874680825f,0.5444667235672814298297f,0.4066755344379027192758f,\
0.2275170058253208615895f,0.4362522385676954606026f,0.5476906607425194861705f,\
0.6973492805657204307579f,0.3667075667170831554387f}

#define CSOURCER {0.6045256052166223526001f,0.9455216196365654468536f,0.4476299257948994636536f,\
0.8624908211641013622284f,0.1751048639416694641113f,0.2067177616991102695465f,\
0.6848411662504076957703f,0.1348653226159512996674f,0.0069159921258687973022f,\
0.1496290047653019428253f,0.5665438110008835792542f,0.4359452719800174236298f,\
0.6547604538500308990479f,0.3381605879403650760651f,0.4259321158751845359802f,\
0.3060420057736337184906f,0.7704779822379350662231f,0.7058695447631180286408f,\
0.2373670237138867378235f,0.8205849635414779186249f,0.6789963841438293457031f,\
0.5250809141434729099274f,0.3359806565567851066589f,0.8941988362930715084076f,\
0.5461782198399305343628f,0.7568633262999355792999f,0.0259526828303933143616f,\
0.3250150899402797222138f,0.6072143577039241791f,0.8756139636971056461334f,\
0.2962085595354437828064f,0.4229678637348115444183f,0.4243144039064645767212f,\
0.7620028969831764698029f,0.3622896494343876838684f,0.5658242437057197093964f,\
0.6424440070986747741699f,0.7580267959274351596832f,0.2531452132388949394226f,\
0.5266989110969007015228f,0.2118590380996465682983f,0.4779220153577625751495f,\
0.1615962767973542213440f,0.9168031658045947551727f,0.5461866445839405059815f,\
0.4686870560981333255768f,0.7772213732823729515076f,0.5871783248148858547211f,\
0.5848031807690858840942f,0.3139644009061157703400f,0.3204141603782773017883f,\
0.3331634956412017345429f,0.2282590121030807495117f,0.2750317254103720188141f,\
0.4963629124686121940613f,0.7453477247618138790131f,0.1155001949518918991089f,\
0.0626524840481579303741f,0.0877018878236413002014f,0.5507565210573375225067f,\
0.2116370312869548797607f,0.8335358710028231143951f,0.4045845707878470420837f,\
0.2880227542482316493988f,0.1750094983726739883423f,0.0051561561413109302521f,\
0.3109287889674305915833f,0.6602919283322989940643f,0.9722995534539222717285f,\
0.9826813959516584873200f,0.0455837054178118705750f,0.4096118300221860408783f,\
0.7104403134435415267944f,0.3917615194804966449738f,0.5571686858311295509338f,\
0.0565565521828830242157f,0.1540721096098423004150f,0.9109257892705500125885f,\
0.5713340407237410545349f,0.3488348922692239284515f,0.8972954172641038894653f,\
0.2973396372981369495392f,0.1091936426237225532532f,0.7626331257633864879608f,\
0.6584706604480743408203f,0.6996708759106695652008f,0.6756794182583689689636f,\
0.9004421546123921871185f,0.6668148916214704513550f,0.8518152837641537189484f,\
0.8365677157416939735413f,0.1291190306656062602997f,0.6095453463494777679443f,\
0.2412315667606890201569f,0.4029275467619299888611f,0.3019328541122376918793f,\
0.1083198729902505874634f,0.8456356939859688282013f,0.9417407037690281867981f,\
0.9083450469188392162323f,0.1937242373824119567871f,0.5318046086467802524567f,\
0.8314437521621584892273f,0.4952740012668073177338f,0.7465563025325536727905f,\
0.7102393140085041522980f,0.5811418974772095680237f,0.7035941029898822307587f,\
0.3746570833027362823486f,0.3394373343326151371002f,0.6322447275742888450623f,\
0.7636191300116479396820f,0.6940386760979890823364f,0.8735245508141815662384f,\
0.3612738298252224922180f,0.7933200257830321788788f,0.4830590635538101196289f,\
0.2469964125193655490875f,0.5025922833010554313660f,0.7430270477198064327240f,\
0.6783937942236661911011f,0.4903185223229229450226f,0.709806025959551334381f,\
0.3303662906400859355927f,0.6815545372664928436279f,0.0701365978457033634186f,\
0.4745870968326926231384f,0.8091805852018296718597f,0.9447045121341943740845f,\
0.5478458073921501636505f,0.1216687532141804695129f,0.9161847713403403759003f,\
0.3045207932591438293457f,0.6502694808878004550934f,0.0987624628469347953796f,\
0.8391053467057645320892f,0.0328534897416830062866f,0.3461971958167850971222f,\
0.2801467711105942726135f,0.5500544901005923748016f,0.0729318000376224517822f,\
0.0225322381593286991119f,0.50267804320901632309f,0.3478884599171578884125f,\
0.4298669416457414627075f,0.3537984383292496204376f,0.0529730813577771186829f,\
0.9533003675751388072968f,0.1842019557952880859375f,0.958756382111459970474f,\
0.3245136169716715812683f,0.0003973259590566158295f,0.0972583871334791183472f,\
0.4378789965994656086f,0.3634226778522133827210f,0.2685119728557765483856f,\
0.2770298384130001068115f,0.8854365111328661441803f,0.5216628303751349449158f,\
0.4979983693920075893f,0.8733724001795053482056f,0.4699407932348549365997f,\
0.9364062966778874397278f,0.1337622734718024730682f,0.2712419554591178894043f,\
0.1766990595497190952301f,0.0543269468471407890320f,0.8402757882140576839447f,\
0.7507283594459295272827f,0.3062269617803394794464f,0.9195641661062836647034f,\
0.1318263853900134563446f,0.0826364941895008087158f,0.8222710476256906986237f,\
0.4441085970029234886169f,0.9617503038607537746429f,0.0283641982823610305786f,\
0.1431905967183411121368f,0.3793597565963864326477f,0.6144003230147063732147f,\
0.2128270715475082397461f,0.4704488315619528293610f,0.2076055286452174186707f,\
0.7435979112051427364349f,0.3391801547259092330933f,0.2479635034687817096710f,\
0.6721735307946801185608f,0.9013197491876780986786f,0.2140864841639995574951f,\
0.8460668534971773624420f,0.1650043567642569541931f,0.4003686285577714443207f,\
0.5522825215011835098267f,0.0638249483890831470490f,0.6903966935351490974426f,\
0.8547787251882255077362f,0.0291904583573341369629f,0.5434663915075361728668f,\
0.6236743135377764701843f,0.2417052476666867733002f}

#define CSOURCEI {0.5503273960202932357788f,0.6906704087741672992706f,0.9835249418392777442932f,\
0.8285484607331454753876f,0.2062614001333713531494f,0.1944643096067011356354f,\
0.4367609983310103416443f,0.8090620837174355983734f,0.8818644303828477859497f,\
0.7404803228564560413361f,0.7542522149160504341126f,0.9921960639767348766327f,\
0.9886121451854705810547f,0.0113218077458441257477f,0.9367801276966929435730f,\
0.3874237253330647945404f,0.2886805813759565353394f,0.567788839805871248245f,\
0.7295644441619515419006f,0.0303032915107905864716f,0.2795897088944911956787f,\
0.7047131718136370182037f,0.7442112853750586509705f,0.8920237845741212368012f,\
0.1081438604742288589478f,0.8751525697298347949982f,0.9068333031609654426575f,\
0.2166852983646094799042f,0.4824190363287925720215f,0.7766945236362516880035f,\
0.4510916722938418388367f,0.1300636469386518001556f,0.5505470838397741317749f,\
0.6936193336732685565949f,0.1749099576845765113831f,0.8636093880049884319305f,\
0.2150467522442340850830f,0.1886725709773600101471f,0.1796098565682768821716f,\
0.4374312213622033596039f,0.8514516223222017288208f,0.7381969136185944080353f,\
0.8102188156917691230774f,0.1460137623362243175507f,0.8999849110841751098633f,\
0.4043733575381338596344f,0.0156995235010981559753f,0.6904196902178227901459f,\
0.2990311514586210250855f,0.1383218024857342243195f,0.8478512773290276527405f,\
0.3007262717001140117645f,0.229154746979475021362f,0.8078110129572451114655f,\
0.3176332255825400352478f,0.6924462593160569667816f,0.1364154014736413955689f,\
0.5433279541321098804474f,0.3276594849303364753723f,0.2006831648759543895721f,\
0.5037304237484931945801f,0.4962565028108656406403f,0.8996161324903368949890f,\
0.9357709079049527645111f,0.3390339072793722152710f,0.6029155333526432514191f,\
0.4153500730171799659729f,0.3041478390805423259735f,0.8489827848970890045166f,\
0.4482063786126673221588f,0.0903797810897231101990f,0.7382151386700570583344f,\
0.2669597584754228591919f,0.8226196658797562122345f,0.3985779182985424995422f,\
0.9789295899681746959686f,0.3041231036186218261719f,0.0663515278138220310211f,\
0.6667758254334330558777f,0.7548807277344167232513f,0.1922533493489027023315f,\
0.7942791883833706378937f,0.5580398896709084510803f,0.2016023616306483745575f,\
0.787146832793951034546f,0.0955459238030016422272f,0.6623697867617011070252f,\
0.864868474658578634262f,0.7013061288744211196899f,0.8015053984709084033966f,\
0.9135685982182621955872f,0.6317234965972602367401f,0.9346773549914360046387f,\
0.9157753759063780307770f,0.0510348035022616386414f,0.4329969524405896663666f,\
0.9721843507140874862671f,0.8001508046872913837433f,0.8452261472120881080627f,\
0.0610524858348071575165f,0.8168097324669361114502f,0.2101262793876230716705f,\
0.3055453812703490257263f,0.9465212575159966945648f,0.9269728232175111770630f,\
0.7737778765149414539337f,0.5893978821113705635071f,0.2377697187475860118866f,\
0.5269544571638107299805f,0.0077543654479086399078f,0.8311711428686976432800f,\
0.0268517597578465938568f,0.2591186594218015670776f,0.4641277943737804889679f,\
0.6098861405625939369202f,0.0656952331773936748505f,0.6466812007129192352295f,\
0.1018534512259066104889f,0.2742705782875418663025f,0.8162728524766862392426f,\
0.3357750270515680313110f,0.4765891996212303638458f,0.8440040023997426033020f,\
0.1785074654035270214081f,0.5855625644326210021973f,0.8426241897977888584137f,\
0.7058847947046160697937f,0.7396617024205625057221f,0.9751448985189199447632f,\
0.7606669445522129535675f,0.8236690396443009376526f,0.8889620001427829265595f,\
0.7960178293287754058838f,0.3052428201772272586823f,0.6803312664851546287537f,\
0.6412069997750222682953f,0.0988248009234666824341f,0.4654508423991501331329f,\
0.6714970665052533149719f,0.5131103205494582653046f,0.8631567060947418212891f,\
0.8328299173153936862946f,0.1687975851818919181824f,0.2961277081631124019623f,\
0.2591485660523176193237f,0.1700844173319637775421f,0.9718958893790841102600f,\
0.0695185582153499126434f,0.4696230851113796234131f,0.9544191421009600162506f,\
0.3679352095350623130798f,0.2973918146453797817230f,0.0415310803800821304321f,\
0.4892336544580757617950f,0.5171590568497776985169f,0.3534862431697547435761f,\
0.2354387864470481872559f,0.6779259913600981235504f,0.3834532154724001884460f,\
0.3174350797198712825775f,0.3418120350688695907593f,0.0535557498224079608917f,\
0.9285596096888184547424f,0.3862650538794696331024f,0.4328473098576068878174f,\
0.1581165478564798831940f,0.7887120461091399192810f,0.7448797873221337795258f,\
0.5185996759682893753052f,0.8651678604073822498322f,0.1524438308551907539368f,\
0.2392775672487914562225f,0.5761575847864151000977f,0.7395762302912771701813f,\
0.0583172617480158805847f,0.6962534948252141475678f,0.4206145536154508590698f,\
0.0281158541329205036163f,0.8313249954953789710999f,0.2333360086195170879364f,\
0.8865877203643321990967f,0.3746785433031618595123f,0.87671328987926244736f,\
0.4027077830396592617035f,0.2890332732349634170532f,0.8538430598564445972443f,\
0.5499771209433674812317f,0.5128610017709434032440f,0.6321087554097175598145f,\
0.4165538274683058261871f,0.3217771751806139945984f,0.9717370062135159969330f,\
0.5348322447389364242554f,0.3416590173728764057159f,0.9565287167206406593323f,\
0.9951003189198672771454f,0.3422884084284305572510f,0.7870580093003809452057f,\
0.9234123295173048973084f,0.5238970420323312282562f}
#define CRESULTR {0.6700223015238303547747f,0.9051590648529930227539f,0.9783774998303537140387f,\
0.9672554578415690773596f,0.1806879116022510611828f,0.2113884833531175511112f,\
0.6724311908168314477763f,0.2759693779071136221504f,0.0171117603025009445972f,\
0.2676571377242007998554f,0.7836070482910290069256f,0.9837911114618788088748f,\
1.0787649507707848250959f,0.3258715909732741722316f,0.8818391305817397940459f,\
0.3412489698350346656319f,0.6791962837910036077105f,0.7436127103435716811930f,\
0.40184826884232582866f,0.6757254959645757619313f,0.6216816234807176488886f,\
0.7106811634553994450059f,0.5496317899100798820555f,1.015517869987778709628f,\
0.5020506061187628432663f,0.9811456923663512963429f,0.0682501782366792819623f,\
0.3276872649171290174941f,0.6393144648282618192070f,0.9360249253515308121010f,\
0.3486021801541281939230f,0.405155698729944113712f,0.5200555835311830854550f,\
0.8452234271752276928424f,0.3567295147730688009702f,0.8928456199942530480129f,\
0.5846382117554749235922f,0.6534877266970448017602f,0.2555268336748864332897f,\
0.5599022272385358878211f,0.4549851524880720865518f,0.6983186009546583639107f,\
0.3278445848029415965463f,0.7317436304730139395858f,0.9243668151604532701171f,\
0.4997101034619103598899f,0.6512014053656888235011f,0.7461784468374338397112f,\
0.5613804235723615088105f,0.309377290465780441231f,0.6302193796318024121561f,\
0.3488048678688123183100f,0.2359369023748482674385f,0.5207697215592063111345f,\
0.4975483327992256676886f,0.8371220343907752603485f,0.1171268218028372609663f,\
0.085272785233540815408f,0.0974986984973703479929f,0.5164560743022618138909f,\
0.2683348894394235739647f,0.7764310536494951620057f,0.8045234481921298419493f,\
0.6958959159533119054331f,0.1940650650900959395262f,0.0075996484393591736892f,\
0.3536342521606328781481f,0.6152689741862609196232f,0.9952856734893198442649f,\
0.8206704954595607226509f,0.0459255053037718463660f,0.6307753783837566352588f,\
0.6388147154641353742122f,0.6937233166977520015806f,0.5697295509652193779004f,\
0.1802327077236753061218f,0.1675371469878289276689f,0.7230999921866064772402f,\
0.7176490691010239952874f,0.5749086647774364067232f,0.7279693322506849417763f,\
0.5413870504782296588786f,0.1504476557625347432623f,0.6581157602540366191590f,\
0.8675383161064098569426f,0.6076707020048850438343f,0.7819483789931592765399f,\
0.9976690503006511168138f,0.8038234125831255072470f,0.9466047824946693944881f,\
1.0263044057305568124150f,0.1954383476167207978058f,0.9991226583234396052546f,\
0.5824462236684256888353f,0.3833026614151368027805f,0.3492943337672331227672f,\
0.3315115099350262606315f,0.9442386171423264862312f,0.9899258002262354416700f,\
0.7216294786971718666635f,0.3920325460401206107974f,0.5034740230892749135450f,\
0.715969761025848305813f,0.9550125571098367904810f,1.0265780142294762544708f,\
0.8803585794351714843842f,0.6748726933268143213240f,0.6286862272305427934427f,\
0.4593360950510761986365f,0.3269925373376404986736f,0.8950979801820350134634f,\
0.6434757060207739742808f,0.6268824366882729259842f,0.7824259493911607243888f,\
0.4869178781705328362683f,0.6618946105318512795890f,0.6319261919275969141552f,\
0.2444724751522657224534f,0.4924981727592058766696f,0.9272283746811394999909f,\
0.6354081057135144705583f,0.5455716136398853777223f,0.9397290975289604997300f,\
0.3281437517029104355970f,0.7390025847943897385761f,0.1571298352097142136952f,\
0.6681717696917298665582f,0.893260926700763513431f,1.0727843133940448971941f,\
0.7758756582495047737780f,0.2577884404871108037227f,1.0152118695965053341013f,\
0.553316515865495128779f,0.6088582613070312454795f,0.1618775254222162562900f,\
0.8458278989313633422498f,0.0331641659985394132715f,0.4056540942022494600217f,\
0.4254458405105830398618f,0.6108828412056167556088f,0.1710530527126769284596f,\
0.0497407205620656947542f,0.4747317015892947855704f,0.3618696796533303894350f,\
0.4287418625744875422257f,0.3485740919790226710617f,0.1655375133873851212218f,\
0.7428884062630719542497f,0.2271172969578298117543f,1.0587395337282918816868f,\
0.3549940948693925402147f,0.0004346469449674766222f,0.0971187244038783509259f,\
0.5043807505243238509252f,0.4434874448032950500220f,0.2951797103676901401492f,\
0.2845053188094572860223f,0.8815102337365799956004f,0.5368898054807562658652f,\
0.4988328370209159090543f,0.745435623332440511213f,0.4391683137636283595917f,\
1.0422403039497714072326f,0.1545117394214212958037f,0.3165746040477503964183f,\
0.1791895467797269270172f,0.1089461488105609721089f,0.9065124792766549033374f,\
0.7446224625751999282031f,0.6296662678760955866864f,0.7337000953456223051319f,\
0.1387263358911398902773f,0.1169149268680415021393f,0.8975235374861081361075f,\
0.4182178630757872883628f,0.9119369228139623251295f,0.0340248805832462572485f,\
0.1423301258754861298161f,0.6888548451397347172076f,0.5685106882588889520847f,\
0.4923020191500164788323f,0.4917581413760083730580f,0.4716616017939372351719f,\
0.6955693872489776552470f,0.3523112018531558975454f,0.5222250480132760719343f,\
0.7144705774015845944902f,0.8119440584245034564503f,0.3164274689259520823015f,\
0.7538323331802344595687f,0.1811571114058267151226f,0.9128449761317551924833f,\
0.6233160136433549824986f,0.0717615749734574065455f,1.0473491540209625139113f,\
1.0924869453095222837646f,0.0328835678516360627177f,0.7973589739562461087274f,\
0.9908609316019793000763f,0.3104246876762664641980f}

#define CRESULTI {0.3914561710408779870996f,0.2745677431871340612446f,0.8850988190375015385314f,\
0.3546606100359354085683f,0.2026838146454169320432f,0.1884673919393772267839f,\
0.2801601885873738484456f,1.0096958835716720592757f,1.21412343558816204769f,\
0.8776375911322839007411f,0.5620073675207013508270f,0.9130433942963852578245f,\
0.5770284711891953133289f,0.0101200891695042028556f,0.8779935002098492313749f,\
0.3667139971005198284537f,0.1664312994282131086266f,0.3494312783943472333625f,\
0.8104125516371111226377f,0.0164786111567649697085f,0.1816457336156695190343f,\
0.5593166230651334114299f,0.7569161316066348454967f,0.3415023725885689698245f,\
0.0814423238542508892701f,0.4465689540632135634546f,1.275733507144991119020f,\
0.197487841611818731868f,0.3421719548772197971864f,0.3349549978483222778536f,\
0.4357966181675047567801f,0.1096343010109522564388f,0.4859836370575167374675f,\
0.3800931088000560897910f,0.1548265257107722947527f,0.6348894325615116462913f,\
0.1460748031318926942745f,0.1110957110750060844451f,0.1700664034230296439709f,\
0.3412176537402174525404f,1.0332395638414424432483f,0.6273383485614248966655f,\
0.9957192459042429888427f,0.0691093109901288471519f,0.6804424693811944591104f,\
0.3344738416260302771299f,0.0090436204351948476510f,0.5006804162977720462635f,\
0.2172201211207329951680f,0.1261162082552027552396f,0.9120640605812813106468f,\
0.2753688308103523496584f,0.2209039383694014757609f,0.8997305533684579748055f,\
0.2536420004619579504634f,0.3903699376999557602019f,0.1354191697515705339328f,\
0.6007399379388951299319f,0.3370127497194151389159f,0.1507780721992685313282f,\
0.5203153088877445764382f,0.254583375618394558426f,0.8702994198605253917123f,\
1.0924089238964773684870f,0.3407939274374255367306f,0.6883985279629690756664f,\
0.3940203751449571356602f,0.2021529986071308460094f,0.2883410464579913012884f,\
0.1832164764792163502705f,0.0904370855097187398286f,0.6870692259557662495695f,\
0.1667494081756663859562f,0.7986735402486416779411f,0.2997470364729120650971f,\
1.4723672873315984954701f,0.3058215886262277694030f,0.0317778181669746695448f,\
0.4953897349233554736614f,0.7593857543036769408573f,0.0933417291983620195373f,\
0.8587250458616788595379f,0.6140082043678934953235f,0.1179425317948916696054f,\
0.5008800041022678506408f,0.0606528647874819346053f,0.4208891412439614287955f,\
0.3345057926491249999934f,0.4488362148523600825278f,0.356228513965734405744f,\
0.3862019012866550471408f,0.7133939454258028112221f,0.6183512140459618278143f,\
1.122372846973830329276f,0.0435912326295722213354f,0.4149318455829275609226f,\
1.4136182419356593253923f,0.360095911709175209303f,0.3059781012378688380693f,\
0.0293528815458468754496f,0.9850054988638156094893f,0.1610071461548980287226f,\
0.1615738175268226772818f,0.7804595725744208900565f,0.4664649257591839126569f,\
0.4516332153201338406312f,0.4324429865103157633044f,0.1499229835931424337225f,\
0.4861395789308433634801f,0.0069254200843589181283f,0.5470248281814621416075f,\
0.0157419761082240212968f,0.1652796264802975090280f,0.2251845784941430561599f,\
0.5809144105432306748327f,0.0370371154221026954723f,0.5409142410066014594605f,\
0.0961579912696427369090f,0.2170435871168209518434f,0.4413938390627674124289f,\
0.2180518991856933708196f,0.3882731529916919055445f,0.4793791546290147587150f,\
0.1615500633583723533171f,0.3727683427019338191499f,1.1092002442556854191480f,\
0.6007159335006776457178f,0.3670729131136168943428f,0.3082959548830728202518f,\
0.5833221942824414751883f,1.0459318594890267828390f,0.3263494274187709875967f,\
0.8544844347571096676575f,0.2053831793406840910965f,0.7963141410348304471967f,\
0.3137393761405720127300f,0.0990397931617461729781f,0.4344101753145302446946f,\
0.7023788886417181576150f,0.3911554522022889779365f,1.1544412437572197926983f,\
1.0984333102013155158971f,0.1328621940810992829718f,0.268167531788618462851f,\
0.2190523476868022068054f,0.1514050595867235948777f,1.452314392851102864412f,\
0.0312862499326923282350f,0.4864975811326933685663f,0.3000795354832859751504f,\
0.3425769720223186820540f,0.3064807342294366687696f,0.0411636957365836206324f,\
0.4217989293277185081088f,0.4809545441238126106676f,0.3404220390913085259044f,\
0.2214498702533347351817f,0.3018772698523388142711f,0.2996779751331964392058f,\
0.2530674633040843612974f,0.1693130128868851891344f,0.0432918302807213800643f,\
0.3147578695966239403781f,0.3983398179395671312442f,0.4233396532725078320603f,\
0.1544509091417925472634f,1.000697611141370568788f,0.3487050795605025621526f,\
0.3006071168291280515383f,0.9542614300639570279472f,0.0718340034799053589465f,\
0.2395154786718341477503f,0.6434277607558438472069f,0.3585399891990152521082f,\
0.0482004898594938432921f,0.2679535503180693334357f,0.4468782830994436072736f,\
0.0275539888537934679613f,0.8228411197528838760817f,0.1637277172538824099313f,\
1.0994704384405307173722f,0.3084433992108448485681f,1.0856016429316568405739f,\
0.2389273879432435854220f,0.2631293443272026966184f,1.0016126450700377770175f,\
0.3562135410626017795188f,0.2353197404250201296705f,0.6834823618792332799998f,\
0.2126404560740041416178f,0.3234875849405334791165f,0.9562375286253093076283f,\
0.4069690501749418376498f,0.3539780611029934576095f,0.5294802297322954709458f,\
0.3733196120144765539628f,0.3559718013547358839155f,0.6068341504607892566980f,\
0.5969952503542278465787f,0.5352237566999263895795f}




void stanhsTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out;
	int i;

	for (i=0;i<200;i++){
		out=stanhs(in[i]);
		assert(( (fabs(out-res[i]))/(fabs(out)) )<1e-6);
	}
}

void ctanhsTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex in,out;
	int i;

	for (i=0;i<200;i++){
		in=FloatComplex(inR[i],inI[i]);
		out=ctanhs(in);
		assert(( (fabs(creals(out)-resR[i]))/(fabs(creals(out))) )<1e-6);	
		assert(( (fabs(cimags(out)-resI[i]))/(fabs(cimags(out))) )<1e-6);			
	}
}

void stanhaTest(void) {
	float in[]=SOURCE;
	float res[]=RESULT;
	float out[200];
	int i;

	stanha(in,200,out);
	for (i=0;i<200;i++){
		assert(( (fabs(out[i]-res[i]))/(fabs(out[i])) )<1e-6);
	}
}

void ctanhaTest(void) {
	float inR[]=CSOURCER;
	float inI[]=CSOURCEI;
	float resR[]=CRESULTR;
	float resI[]=CRESULTI;
	floatComplex *in,out[200];
	int i;

	in=FloatComplexMatrix(inR,inI,200);
	ctanha(in,200,out);

	for (i=0;i<200;i++){
		assert(( (fabs(creals(out[i])-resR[i]))/(fabs(creals(out[i]))) )<1e-6);	
		assert(( (fabs(cimags(out[i])-resI[i]))/(fabs(cimags(out[i]))) )<1e-6);			
	}
}

int testTanh() {
  printf("\n>>>> Float Hyperbolic Tangeant Tests\n");
  stanhsTest();
  ctanhsTest();
  stanhaTest();
  ctanhaTest();
  return 0;
}

int main() {
  assert(testTanh() == 0);
  return 0;
}
