/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
 
 
#include <assert.h>
#include <stdio.h>
#include <math.h>
#include "determ.h"

 
 
#define IN2 {0.1998337740078568458557f,0.5618660743348300457001f,\
0.5896177329123020172119f,0.6853979662992060184479f}

#define RES2 -0.1943205386467572182152f

#define IN3 {0.8906224733218550682068f,0.5042212805710732936859f,0.3493615407496690750122f,\
0.3873778772540390491486f,0.9222898678854107856751f,0.9488184261135756969452f,\
0.3435337245464324951172f,0.3760118731297552585602f,0.7340940563008189201355f}

#define RES3 0.2464108526639412488635f

#define IN4 {0.2615761472843587398529f,0.4993493836373090744019f,0.2638578419573605060577f,\
 0.5253563085570931434631f,\
0.5376229803077876567841f,0.1199925504624843597412f,0.2256303490139544010162f,\
 0.6274093082174658775330f,\
0.7608432597480714321137f,0.0485566202551126480103f,0.6723949727602303028107f,\
 0.2017172696068882942200f,\
0.3911573919467628002167f,0.8300316557288169860840f,0.5878720157779753208160f,\
 0.4829179299995303153992f}
 
#define RES4 0.0079215378363537460038f

#define IN5 {0.2232865034602582454681f,0.8400885667651891708374f,0.1205995907075703144074f,\
 0.2855364168062806129456f,0.8607514644972980022430f,\
0.8494101651012897491455f,0.5257060811854898929596f,0.9931209897622466087341f,\
 0.6488562873564660549164f,0.9923190940171480178833f,\
0.0500419777818024158478f,0.7485506581142544746399f,0.4104058998636901378632f,\
 0.6084526330232620239258f,0.8544210889376699924469f,\
0.0642646728083491325378f,0.8279082938097417354584f,0.9262343775480985641480f,\
 0.5667211269028484821320f,0.5711638936772942543030f,\
0.8160110483877360820770f,0.0568927936255931854248f,0.5595936686731874942780f,\
 0.1249340316280722618103f,0.7279222286306321620941f}
 
#define RES5 0.0501241717143536200108f

#define IN6 {0.2677766475826501846314f,0.5465334919281303882599f,0.9885407658293843269348f,\
 0.7395656588487327098846f,0.0037173107266426086426f,0.5900572859682142734528f,\
0.3096467358991503715515f,0.2552205710671842098236f,0.6251879390329122543335f,\
 0.1157417376525700092316f,0.6117004090920090675354f,0.6783956284634768962860f,\
0.3320095278322696685791f,0.0258709923364222049713f,0.5174468224868178367615f,\
 0.3916873238049447536469f,0.2413538414984941482544f,0.5064434898085892200470f,\
0.4236102001741528511047f,0.2893727528862655162811f,0.0887932181358337402344f,\
 0.6212881752289831638336f,0.3454984454438090324402f,0.7064867629669606685638f,\
0.5211472492665052413940f,0.2870400850661098957062f,0.6502795079723000526428f,\
 0.0881334762088954448700f,0.4498763345181941986084f,0.722725308034569025040f,\
0.8976796260103583335877f,0.2427821881137788295746f,0.4337721113115549087524f,\
 0.9677053210325539112091f,0.5068534435704350471497f,0.523297640960663557053f}
 
#define RES6 -0.0275938917848303037761f

#define IN8 {0.5596947595477104187012f,0.5617307000793516635895f,0.468176002614200115204f,\
 0.7794546722434461116791f,0.7901071812957525253296f,0.9808542062528431415558f,\
 0.8187066102400422096252f,0.4256872381083667278290f,\
0.2461560554802417755127f,0.922953246627002954483f,0.1000745808705687522888f,\
 0.4678218117915093898773f,0.3950497675687074661255f,0.0366117102093994617462f,\
 0.5175368534401059150696f,0.8325451570563018321991f,\
0.6104832142591476440430f,0.1871111788786947727203f,0.0189574835821986198425f,\
 0.8433564766310155391693f,0.0748594831675291061401f,0.8532815133221447467804f,\
 0.0124590108171105384827f,0.1867539356462657451630f,\
0.4920584075152873992920f,0.7489608139730989933014f,0.9414957007393240928650f,\
 0.212405560072511434555f,0.5795019958168268203735f,0.2628147569485008716583f,\
 0.4360986622050404548645f,0.9110545101575553417206f,\
0.8082667365670204162598f,0.8102653049863874912262f,0.2590428395196795463562f,\
 0.4139087288640439510346f,0.3599927779287099838257f,0.6912787933833897113800f,\
 0.7656858796253800392151f,0.3572649653069674968720f,\
0.7693399824202060699463f,0.5477633909322321414948f,0.0962288742884993553162f,\
 0.9561171731911599636078f,0.2207408566027879714966f,0.0143259358592331409454f,\
 0.8191489772871136665344f,0.1304992842487990856171f,\
0.9682003557682037353516f,0.6561381467618048191071f,0.2445538965985178947449f,\
 0.5283123566769063472748f,0.8468925636261701583862f,0.7876622085459530353546f,\
 0.1262082615867257118225f,0.7883860985748469829559f,\
0.3453042469918727874756f,0.2659857333637773990631f,0.9709818651899695396423f,\
 0.8875247663818299770355f,0.2066752854734659194946f,0.8525160965509712696075f,\
 0.6744697811082005500794f,0.9152874383144080638886f}
 
#define RES8 0.1359018266554544440705f

#define IN10 {0.0284859761595726013184f,0.2367841475643217563629f,0.7015343559905886650085f,\
 0.1202526628039777278900f,0.8287412133067846298218f,0.3161072959192097187042f,\
 0.5305190766230225563049f,0.5715174819342792034149f,0.0478015430271625518799f,\
 0.8248619721271097660065f,\
0.5798843121156096458435f,0.2791808298788964748383f,0.9545110929757356643677f,\
 0.9071154636330902576447f,0.3360149310901761054993f,0.1175613063387572765350f,\
 0.9253723770380020141602f,0.7263671257533133029938f,0.9009497938677668571472f,\
 0.3948993249796330928803f,\
0.5655179750174283981323f,0.7061489676125347614288f,0.6787831196561455726624f,\
 0.413293636869639158249f,0.1402290873229503631592f,0.4952356130816042423248f,\
 0.4194877287372946739197f,0.8626222289167344570160f,0.2857509646564722061157f,\
 0.2512136367149651050568f,\
0.3389101596549153327942f,0.3921975973062217235565f,0.4681552127003669738770f,\
 0.3361602746881544589996f,0.5336876614019274711609f,0.2039063959382474422455f,\
 0.1589989718049764633179f,0.0181815107353031635284f,0.4098370606079697608948f,\
 0.0105834598653018474579f,\
0.1965309716761112213135f,0.2725595370866358280182f,0.3437655037268996238709f,\
 0.2033702037297189235687f,0.3011944610625505447388f,0.2762595904059708118439f,\
 0.2944530742242932319641f,0.5718073952011764049530f,0.2141770124435424804688f,\
 0.6895461627282202243805f,\
0.5855572847649455070496f,0.4204123034141957759857f,0.4277572017163038253784f,\
 0.318458587396889925003f,0.5761894444003701210022f,0.4254902224056422710419f,\
 0.9761981628835201263428f,0.2518960000015795230866f,0.4391129007562994956970f,\
 0.075930369552224874496f,\
0.2559380177408456802368f,0.0670616743154823780060f,0.7651131572201848030090f,\
 0.0417361590079963207245f,0.3438271805644035339356f,0.1970167332328855991364f,\
 0.2122898651286959648132f,0.3140398501418530941010f,0.7821625377982854843140f,\
 0.0540932347066700458527f,\
0.9190206909552216529846f,0.4603515709750354290009f,0.2992685027420520782471f,\
 0.0029166326858103275299f,0.8993470584973692893982f,0.8387927166186273097992f,\
 0.4343749452382326126099f,0.7767876130528748035431f,0.1395317660644650459290f,\
 0.1150637227110564708710f,\
0.5355419963598251342773f,0.4311733045615255832672f,0.614538478665053844452f,\
 0.9258962138555943965912f,0.0993817280977964401245f,0.4280578647740185260773f,\
 0.9431830951943993568420f,0.0327395270578563213348f,0.9213267080485820770264f,\
 0.9449024409987032413483f,\
0.9007069906219840049744f,0.8094316101633012294769f,0.0251954291015863418579f,\
 0.0019645062275230884552f,0.5075221331790089607239f,0.4076042952947318553925f,\
 0.8408046141266822814941f,0.501726570073515176773f,0.9128780765458941459656f,\
 0.4435729472897946834564f}
 
#define RES10 -0.0105698586359502730292f
 
 
 
 
#define CINR2 {0.9625065480358898639679f,0.9798011491075158119202f,\
0.0785698364488780498505f,0.9150031916797161102295f}
#define CINI2 {0.6172610134817659854889f,0.9964194735512137413025f,\
0.0468598580919206142426f,0.9245926234871149063110f}
#define CRESR2 0.2796908427268796071274f
#define CRESI2 1.3305203939304277582778f

#define CINR3 {0.9689865079708397388458f,0.4916289718821644783020f,0.2977053108625113964081f,\
0.0603054538369178771973f,0.631347181741148233414f,0.0241030259057879447937f,\
0.1527438252232968807221f,0.9481177683919668197632f,0.2744265575893223285675f}
#define CINI3 {0.4794727200642228126526f,0.485576837789267301559f,0.676400367170572280884f,\
0.8321249918080866336823f,0.0125875836238265037537f,0.5453779897652566432953f,\
0.8426716942340135574341f,0.9029165101237595081329f,0.4409482078626751899719f}
#define CRESR3 0.3208274162176448784933f
#define CRESI3 -0.5045627162227295237074f

#define CINR4 {0.8332359003834426403046f,0.7233976423740386962891f,0.4377150186337530612946f,\
 0.3080607382580637931824f,\
0.8749813153408467769623f,0.5355882328003644943237f,0.3085998897440731525421f,\
 0.3354632416740059852600f,\
0.2342486302368342876434f,0.2589411698281764984131f,0.8521509231068193912506f,\
 0.4821739485487341880798f,\
0.6095217890106141567230f,0.9872822705656290054321f,0.9811426815576851367950f,\
 0.3303113700821995735169f}
#define CINI4 {0.3589145573787391185761f,0.2780527696013450622559f,0.9583482020534574985504f,\
 0.0156362904235720634460f,\
0.2964351712726056575775f,0.4685934986919164657593f,0.4262020816095173358917f,\
 0.4217656338587403297424f,\
0.1034853602759540081024f,0.4279759414494037628174f,0.7860729382373392581940f,\
 0.8568082069978117942810f,\
0.1993437460623681545258f,0.7131301630288362503052f,0.5208952468819916248322f,\
 0.9311723159626126289368f}
#define CRESR4 0.5916307061533252475982f
#define CRESI4 -0.104762389048400544889f

#define CINR5 {0.4143836158327758312225f,0.5980196148157119750977f,0.5549105503596365451813f,\
 0.8552952585741877555847f,0.3097750707529485225678f,\
0.9446128141134977340698f,0.2442680452950298786163f,0.8760446915403008460999f,\
 0.4874215493910014629364f,0.3844018988311290740967f,\
0.0922345430590212345123f,0.0705418726429343223572f,0.7338807261548936367035f,\
 0.7792180571705102920532f,0.7827638057060539722443f,\
0.2161567779257893562317f,0.3420197847299277782440f,0.430093832314014434814f,\
 0.6261752569116652011871f,0.9554250938817858695984f,\
0.45415506651625037193f,0.0029223021119832992554f,0.0106920679099857807159f,\
 0.9746370846405625343323f,0.7704260940663516521454f}
#define CINI5 {0.6396631337702274322510f,0.9535886184312403202057f,0.4148483341559767723084f,\
 0.4661539695225656032562f,0.2238455135375261306763f,\
0.3456973326392471790314f,0.2340623633936047554016f,0.6619341480545699596405f,\
 0.2691179513931274414063f,0.9830248900689184665680f,\
0.7393351225182414054871f,0.2902135862968862056732f,0.3995949607342481613159f,\
 0.9792278115637600421906f,0.0075513580814003944397f,\
0.7021022657863795757294f,0.8907506130635738372803f,0.6526974202133715152741f,\
 0.4136228552088141441345f,0.8581690913997590541840f,\
0.2396089676767587661743f,0.4820041772909462451935f,0.9848585547879338264465f,\
 0.4469721647910773754120f,0.2329813763499259948731f}
#define CRESR5 -0.2050520846829704535441f
#define CRESI5 1.3442626005968567604043f

#define CINR6 {0.2234513931907713413239f,0.8002565456554293632507f,0.7750734328292310237885f,\
 0.4825006630271673202515f,0.7844883133657276630402f,0.1534679317846894264221f,\
0.7722877110354602336884f,0.8952021785080432891846f,0.9467325792647898197174f,\
 0.6981825744733214378357f,0.9559160820208489894867f,0.0484017301350831985474f,\
0.5323520642705261707306f,0.2946867095306515693665f,0.6977136689238250255585f,\
 0.9376203864812850952148f,0.1075560846365988254547f,0.7763424394652247428894f,\
0.6373417838476598262787f,0.0663061570376157760620f,0.8169459854252636432648f,\
 0.354739100672304630280f,0.5860544512979686260223f,0.3461025469005107879639f,\
0.4424751014448702335358f,0.8822665056213736534119f,0.7643693066202104091644f,\
 0.7764139864593744277954f,0.2807680931873619556427f,0.6908600600436329841614f,\
0.7174728694371879100800f,0.372018136084079742432f,0.9325496577657759189606f,\
 0.2256677551195025444031f,0.7521101920865476131439f,0.3074750658124685287476f}
#define CINI6 {0.5979326148517429828644f,0.1923890346661210060120f,0.2387088830582797527313f,\
 0.7470833100378513336182f,0.9713153676129877567291f,0.4370355373248457908630f,\
0.6224875054322183132172f,0.3291327971965074539185f,0.3296387386508285999298f,\
 0.2768637137487530708313f,0.4872983503155410289764f,0.7732046544551849365234f,\
0.9077521809376776218414f,0.5012293187901377677918f,0.5159545852802693843842f,\
 0.5792678873986005783081f,0.154639363754540681839f,0.7611137786880135536194f,\
0.6907917778007686138153f,0.2873229347169399261475f,0.9642531336285173892975f,\
 0.5660724332556128501892f,0.5782137936912477016449f,0.266342097893357276917f,\
0.4747098502703011035919f,0.6073546530678868293762f,0.0409730705432593822479f,\
 0.501256845891475677490f,0.5295930975116789340973f,0.6259458316490054130554f,\
0.2219352661632001399994f,0.3467419948428869247437f,0.3951167692430317401886f,\
 0.5442812526598572731018f,0.1430782820098102092743f,0.7165467627346515655518f}
#define CRESR6 0.0374364367907719236550f
#define CRESI6 0.0027318151340892903034f

#define CINR8 {0.826897530350834131241f,0.0803818320855498313904f,0.7634756616316735744476f,\
 0.6771226990967988967896f,0.0800866526551544666290f,0.5631617354229092597961f,\
 0.8400143641047179698944f,0.9142984896898269653320f,\
0.9566112258471548557282f,0.1676578698679804801941f,0.4345969124697148799896f,\
 0.0417516361922025680542f,0.4832747434265911579132f,0.2889312515035271644592f,\
 0.4115779171697795391083f,0.2200270108878612518311f,\
0.3144670636393129825592f,0.2733902474865317344666f,0.7691849744878709316254f,\
 0.0548522863537073135376f,0.4532337454147636890411f,0.2262856932356953620911f,\
 0.1486739399842917919159f,0.2435002401471138000488f,\
0.384454759303480386734f,0.1141278846189379692078f,0.3649685769341886043549f,\
 0.9379479344934225082398f,0.2138825734145939350128f,0.8807754451408982276917f,\
 0.3025345797650516033173f,0.2935827709734439849854f,\
0.9067896143533289432526f,0.7959460681304335594177f,0.0202379724942147731781f,\
 0.1722054202109575271606f,0.2199751031585037708283f,0.7548991339281201362610f,\
 0.4089378821663558483124f,0.4680796265602111816406f,\
0.420881266240030527115f,0.7480402020737528800964f,0.2455636872909963130951f,\
 0.0257788877934217453003f,0.3875689213164150714874f,0.2191973784938454627991f,\
 0.9874265412800014019013f,0.6185800097882747650147f,\
0.1833024383522570133209f,0.5313195576891303062439f,0.1505152708850800991058f,\
 0.9561535362154245376587f,0.6994940754957497119904f,0.2583465399220585823059f,\
 0.6155266496352851390839f,0.1903010532259941101074f,\
0.4607576900161802768707f,0.5220010234043002128601f,0.7053800462745130062103f,\
 0.8874893691390752792358f,0.1858218242414295673370f,0.0922524714842438697815f,\
 0.3779664481990039348602f,0.9369315691292285919190f}
#define CINI8 {0.1980521664954721927643f,0.4702028548344969749451f,0.3778818598948419094086f,\
 0.3629649449139833450317f,0.2793333870358765125275f,0.6721442686393857002258f,\
 0.6908950763754546642304f,0.5104757994413375854492f,\
0.0610603489913046360016f,0.9335384247824549674988f,0.1448998316191136837006f,\
 0.5721211265772581100464f,0.5459886942990124225617f,0.0516680190339684486389f,\
 0.5011013220064342021942f,0.9260971657931804656982f,\
0.8546948046423494815826f,0.5857099732384085655212f,0.8791871047578752040863f,\
 0.2532048318535089492798f,0.790395137388259172440f,0.6329805525019764900208f,\
 0.8602323713712394237518f,0.9019620195031166076660f,\
0.3158749365247786045075f,0.4001023573800921440125f,0.1110895960591733455658f,\
 0.4705127831548452377319f,0.5362763185985386371613f,0.2878431910648941993713f,\
 0.8740125591866672039032f,0.0740833915770053863525f,\
0.2814957336522638797760f,0.7083768015727400779724f,0.1652647457085549831390f,\
 0.2667352575808763504028f,0.8819408011622726917267f,0.3537154989317059516907f,\
 0.0264621186070144176483f,0.0861647427082061767578f,\
0.2313965209759771823883f,0.1340646473690867424011f,0.6724002673290669918060f,\
 0.1902998369187116622925f,0.7307508592493832111359f,0.5048490324988961219788f,\
 0.8791159312240779399872f,0.5544437132775783538818f,\
0.2063297093845903873444f,0.401161103509366512299f,0.4559328979812562465668f,\
 0.6977151576429605484009f,0.3965912279672920703888f,0.498381090350449085236f,\
 0.1452422770671546459198f,0.9075358733534812927246f,\
0.1009295457042753696442f,0.0177189959213137626648f,0.7937671481631696224213f,\
 0.4309146609157323837280f,0.584337853360921144485f,0.7954284632578492164612f,\
 0.1390615846030414104462f,0.1012784726917743682861f}
#define CRESR8 -0.2866880544829432109211f
#define CRESI8 -0.5082321435837643397449f

#define CINR10 {0.3316808626987040042877f,0.8344425177201628684998f,0.0549940518103539943695f,\
 0.3696003425866365432739f,0.7453266424126923084259f,0.0571811841800808906555f,\
 0.5999651807360351085663f,0.2085741907358169555664f,0.8798878290690481662750f,\
 0.4782809792086482048035f,\
0.7116099162958562374115f,0.8585865031927824020386f,0.8078222130425274372101f,\
 0.5159962782636284828186f,0.8917340408079326152802f,0.8842348866164684295654f,\
 0.70964269945397973061f,0.6610225578770041465759f,0.7252350724302232265472f,\
 0.510143497958779335022f,\
0.2824866441078484058380f,0.2214915128424763679504f,0.5767575385980308055878f,\
 0.7048253491520881652832f,0.5607945644296705722809f,0.3628880484029650688171f,\
 0.3088326244615018367767f,0.9813414867967367172241f,0.7428482254035770893097f,\
 0.1616391474381089210510f,\
0.3652521963231265544891f,0.3835070468485355377197f,0.1169181005097925662994f,\
 0.8911246126517653465271f,0.0634272000752389431000f,0.6263941843062639236450f,\
 0.6807702076621353626251f,0.2588596837595105171204f,0.4394804346375167369843f,\
 0.8598818778991699218750f,\
0.5482823201455175876617f,0.8135995296761393547058f,0.4898237003944814205170f,\
 0.0240026097744703292847f,0.7369195525534451007843f,0.2411156157031655311585f,\
 0.1529693226329982280731f,0.2648359201848506927490f,0.4298193217255175113678f,\
 0.7673939457163214683533f,\
0.8753260499797761440277f,0.3796988371759653091431f,0.3062356826849281787872f,\
 0.3880051793530583381653f,0.1047293278388679027557f,0.7603831812739372253418f,\
 0.0340930395759642124176f,0.1423966242000460624695f,0.5554559468291699886322f,\
 0.8031897451728582382202f,\
0.5183992316015064716339f,0.1518561029806733131409f,0.5884730662219226360321f,\
 0.2545093484222888946533f,0.9992679939605295658112f,0.6398976957425475120544f,\
 0.5506716123782098293304f,0.4607007671147584915161f,0.5933007937856018543243f,\
 0.6538193570449948310852f,\
0.4168340521864593029022f,0.9910155385732650756836f,0.3720780410803854465485f,\
 0.7061824081465601921082f,0.5780865414999425411224f,0.602319641038775444031f,\
 0.5715096746571362018585f,0.0549629041925072669983f,0.1205854485742747784f,\
 0.0143620483577251434326f,\
0.0257951230742037296295f,0.8411248764023184776306f,0.4381882525049149990082f,\
 0.4643401596695184707642f,0.4197426405735313892365f,0.8023654492571949958801f,\
 0.5228588166646659374237f,0.5095121040940284729004f,0.4531980180181562900543f,\
 0.7817818326875567436218f,\
0.776557037141174077988f,0.0466059204190969467163f,0.5113326688297092914581f,\
 0.7502101892605423927307f,0.6883628661744296550751f,0.0167756117880344390869f,\
 0.9345410899259150028229f,0.5609863763675093650818f,0.2205847105942666530609f,\
 0.7648540753871202468872f}
#define CINI10 {0.4816976976580917835236f,0.1558785634115338325501f,0.2476022052578628063202f,\
 0.5216529071331024169922f,0.0805230387486517429352f,0.4409417239949107170105f,\
 0.8911933614872395992279f,0.9780590813606977462769f,0.4588093762286007404327f,\
 0.5510440031066536903381f,\
0.0960960905067622661591f,0.4196785055100917816162f,0.7502556503750383853912f,\
 0.7218149593099951744080f,0.2895541018806397914887f,0.3907764498144388198853f,\
 0.6686618146486580371857f,0.4877656819298863410950f,0.4685971769504249095917f,\
 0.3562648519873619079590f,\
0.3442325466312468051910f,0.4253307832404971122742f,0.5588058172725141048431f,\
 0.3304864969104528427124f,0.4157403339631855487824f,0.1595822656527161598206f,\
 0.3883102680556476116180f,0.9415460713207721710205f,0.4722979352809488773346f,\
 0.8533652639016509056091f,\
0.1207739165984094142914f,0.8999380934983491897583f,0.4384902161546051502228f,\
 0.8976056622341275215149f,0.4911110657267272472382f,0.3402217179536819458008f,\
 0.9966153600253164768219f,0.0215395865961909294128f,0.6876890822313725948334f,\
 0.0044924151152372360229f,\
0.6397854541428387165070f,0.5416147718206048011780f,0.2247649203054606914520f,\
 0.7364005260169506072998f,0.4496364505030214786530f,0.9678138038143515586853f,\
 0.6489060199819505214691f,0.2544666919857263565064f,0.1923975017853081226349f,\
 0.6861492367461323738098f,\
0.4231455805711448192596f,0.6734441593289375305176f,0.8270696722902357578278f,\
 0.9360805852338671684265f,0.8326222090981900691986f,0.7424779590219259262085f,\
 0.0194640238769352436066f,0.8016031915321946144104f,0.2554539437405765056610f,\
 0.2688109613955020904541f,\
0.7558490769006311893463f,0.4347589677199721336365f,0.6425966522656381130219f,\
 0.6957868058234453201294f,0.6499576461501419544220f,0.2303190128877758979797f,\
 0.5504368054680526256561f,0.3038997054100036621094f,0.0371030517853796482086f,\
 0.1703881053254008293152f,\
0.5698686256073415279388f,0.0036411266773939132690f,0.4491547052748501300812f,\
 0.0576810697093605995178f,0.4956056098453700542450f,0.1888933442533016204834f,\
 0.5641230703331530094147f,0.8562210192903876304627f,0.0794764286838471889496f,\
 0.6196198705583810806274f,\
0.2241039988584816455841f,0.8582094730809330940247f,0.7114551994018256664276f,\
 0.8026027604937553405762f,0.6153324418701231479645f,0.8958183480426669120789f,\
 0.8721761344932019710541f,0.8389767911285161972046f,0.2040955354459583759308f,\
 0.3166538262739777565002f,\
0.7006825651042163372040f,0.2073105163872241973877f,0.5222550616599619388580f,\
 0.9416420971974730491638f,0.52116033947095274925f,0.4509841967374086380005f,\
 0.3961292845197021961212f,0.7240869747474789619446f,0.6724055963568389415741f,\
 0.2386146038770675659180f}
#define CRESR10 -0.0701164785573487325809f
#define CRESI10 -0.3697118554850691296565f


static void sdetermaTest(void){
	float in2[]=IN2; float res2=RES2;
	float in3[]=IN3; float res3=RES3;
	float in4[]=IN4; float res4=RES4;
	float in5[]=IN5; float res5=RES5;
	float in6[]=IN6; float res6=RES6;
	float in8[]=IN8; float res8=RES8;
	float in10[]=IN10; float res10=RES10;
	float out2,out3,out4,out5,out6,out8,out10;
	
	out2=sdeterma(in2,2);
	out3=sdeterma(in3,3);
	out4=sdeterma(in4,4);
	out5=sdeterma(in5,5);
	out6=sdeterma(in6,6);
	out8=sdeterma(in8,8);
	out10=sdeterma(in10,10);
	
	assert((fabs(out2-res2)/fabs(out2))<1e-6);
	assert((fabs(out3-res3)/fabs(out3))<1e-7);
	assert((fabs(out4-res4)/fabs(out4))<3e-6);
	assert((fabs(out5-res5)/fabs(out5))<1e-6);
	assert((fabs(out6-res6)/fabs(out6))<1e-6);
	assert((fabs(out8-res8)/fabs(out8))<1e-6);
	assert((fabs(out10-res10)/fabs(out10))<3e-6);
			
}

static void cdetermaTest(void){
	float inR2[]=CINR2; float inI2[]=CINI2; float resR2=CRESR2;  float resI2=CRESI2;
	float inR3[]=CINR3; float inI3[]=CINI3; float resR3=CRESR3;  float resI3=CRESI3;
	float inR4[]=CINR4; float inI4[]=CINI4; float resR4=CRESR4;  float resI4=CRESI4;
	float inR5[]=CINR5; float inI5[]=CINI5; float resR5=CRESR5;  float resI5=CRESI5;
	float inR6[]=CINR6; float inI6[]=CINI6; float resR6=CRESR6;  float resI6=CRESI6;
	float inR8[]=CINR8; float inI8[]=CINI8; float resR8=CRESR8;  float resI8=CRESI8;
	float inR10[]=CINR10; float inI10[]=CINI10; float resR10=CRESR10;  float resI10=CRESI10;
	floatComplex out2,out3,out4,out5,out6,out8,out10;	
	floatComplex *in2, *in3, *in4, *in5, *in6, *in8, *in10;
	
	in2=FloatComplexMatrix(inR2,inI2,4);
	in3=FloatComplexMatrix(inR3,inI3,9);
	in4=FloatComplexMatrix(inR4,inI4,16);
	in5=FloatComplexMatrix(inR5,inI5,25);
	in6=FloatComplexMatrix(inR6,inI6,36);
	in8=FloatComplexMatrix(inR8,inI8,64);
	in10=FloatComplexMatrix(inR10,inI10,100);
	
	out2=cdeterma(in2,2);
	out3=cdeterma(in3,3);
	out4=cdeterma(in4,4);
	out5=cdeterma(in5,5);
	out6=cdeterma(in6,6);
	out8=cdeterma(in8,8);
	out10=cdeterma(in10,10);
	
	
	assert((fabs(creals(out2)-resR2)/fabs(creals(out2)))<1e-6);
	assert((fabs(cimags(out2)-resI2)/fabs(cimags(out2)))<1e-6);
	
	assert((fabs(creals(out3)-resR3)/fabs(creals(out3)))<1e-6);
	assert((fabs(cimags(out3)-resI3)/fabs(cimags(out3)))<1e-6);
	
	assert((fabs(creals(out4)-resR4)/fabs(creals(out4)))<1e-6);
	assert((fabs(cimags(out4)-resI4)/fabs(cimags(out4)))<1e-6);
	
	assert((fabs(creals(out5)-resR5)/fabs(creals(out5)))<3e-6);
	assert((fabs(cimags(out5)-resI5)/fabs(cimags(out5)))<1e-6);
	
	assert((fabs(creals(out6)-resR6)/fabs(creals(out6)))<1e-6);
	assert((fabs(cimags(out6)-resI6)/fabs(cimags(out6)))<3e-6);
	
	assert((fabs(creals(out8)-resR8)/fabs(creals(out8)))<1e-6);
	assert((fabs(cimags(out8)-resI8)/fabs(cimags(out8)))<1e-6);
	
	assert((fabs(creals(out10)-resR10)/fabs(creals(out10)))<3e-6);
	assert((fabs(cimags(out10)-resI10)/fabs(cimags(out10)))<1e-6);
}

static int determTest(void){
	printf("\n >>> Float Determ <<<\n");
	sdetermaTest();
	cdetermaTest();
	return 0;
}


int main (void){
	assert(determTest()==0);
	return 0;
}		
