/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008-2008 - INRIA - Allan SIMON
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include "matrixDivision.h"

#define LINES1  2
#define LINES2  1
#define COLUMNS 2

#define ZLINES1 2
#define ZLINES2 1
#define ZCOLUMNS 2




static void sdivmaTest ( void ) 
{
	int i = 0 ; 
/*	
	float in1[] =
	{0.51323400903493166f,0.6807207581587136f,0.54669387824833393f,0.24904179340228438f,
 0.95017496403306723f,0.91187966475263238f,0.78931419923901558f,0.30985609395429492f,
 0.71984737459570169f,0.9819172923453152f,0.76060794852674007f,0.504620002117008f,
 0.06844846438616514f,0.1693508871831f,0.76318027824163437f,0.30514528928324580f,
 0.92679917532950640f,0.04813073994591832f,0.93056132830679417f,0.31760499393567443f,
0.20109100220724940f,0.75775502342730761f,0.15586951794102788f,0.59756303764879704f,
 0.93055095290765166f,0.94091763999313116f,0.42790159443393350f,0.01439402624964714f,
 0.85971397114917636f,0.11901073250919580f,0.59864782588556409f,0.15444914810359478f,
 0.44080717256292701f,0.09636751096695662f,0.47461007768288255f,0.42803008854389191f,
 0.92924218205735087f,0.47864412236958742f,0.44434435339644551f,0.52509398944675922f,
0.78608208894729614f,0.46497652260586619f,0.06789979804307222f,0.24485790403559804f,
 0.71605867333710194f,0.99458031123504043f,0.84305586572736502f,0.45727639505639672f,
 0.29075053706765175f,0.55482550663873553f,0.28596154693514109f,0.07587631093338132f,
 0.66903266869485378f,0.32733985921368f,0.90166416298598051f,0.83553476119413972f,
 0.80835641175508499f,0.73590047238394618f,0.83198319096118212f,0.93355408729985356f,
0.78650354826822877f,0.74095427244901657f,0.95994638977572322f,0.51785656530410051f,
 0.78444739105179906f,0.13383972086012363f,0.43243235861882567f,0.74689115490764380f,
 0.96420694747939706f,0.22162469848990440f,0.41627834690734744f,0.81930211279541254f,
 0.21618453459814191f,0.08386900834739208f,0.48852836480364203f,0.20842899661511183f,
 0.22902313107624650f,0.78962677717208862f,0.25109061924740672f,0.57858273852616549f,
0.69515300076454878f,0.48902340466156602f,0.47249071300029755f,0.59868981270119548f,
 0.75798543263226748f,0.80475882859900594f,0.61186199076473713f,0.6943939602933824f,
 0.10014689620584249f,0.01250550756230950f,0.47080435231328011f,0.58039451343938708f,
 0.95630660001188517f,0.32801365898922086f,0.27026554010808468f,0.52016736706718802f,
 0.16067446302622557f,0.04408275568857789f,0.88035558909177780f,0.92851745663210750f,
0.42481321236118674f,0.73924016486853361f,0.16896168375387788f,0.39154956489801407f,
 0.97163037536665797f,0.88981838244944811f,0.90427244128659368f,0.31537816859781742f,
 0.06473635649308562f,0.58296835329383612f,0.14059370616450906f,0.63762421533465385f,
 0.67373040271922946f,0.44792105350643396f,0.60066422121599317f,0.06632651202380657f,
 0.66453591873869300f,0.19733488839119673f,0.45683057839050889f,0.08710412681102753f,
0.34466254524886608f,0.09304937114939094f,0.06055234652012587f,0.10790407890453935f,
 0.15703585743904114f,0.72192603675648570f,0.34105927217751741f,0.62482782872393727f,
 0.68893781490623951f,0.03671516245231032f,0.98292266484349966f,0.73650254914537072f,
 0.13196587935090065f,0.18807678623124957f,0.43376339320093393f,0.47929613338783383f,
 0.15195304714143276f,0.18539744755253196f,0.92726647388190031f,0.80549291754141450f,
0.64977857517078519f,0.70831089280545712f,0.90016864379867911f,0.51403949689120054f,
 0.49954565847292542f,0.55090149492025375f,0.92046913085505366f,0.74058383423835039f,
 0.82662396552041173f,0.3313873652368784f,0.68757036840543151f,0.06999884452670813f,
 0.41287241736426950f,0.04925781115889549f,0.85545881045982242f,0.31712341401726007f,
 0.03992868261411786f,0.92384314350783825f,0.74299975624307990f,0.00424729567021132f,
0.01225362811237574f,0.3223448325879872f,0.93296645395457745f,0.08063758304342628f,
 0.74957344215363264f,0.82469086581841111f,0.35314525663852692f,0.44088636664673686f,
 0.79343967605382204f,0.06321920128539205f,0.87087013013660908f,0.05352633958682418f,
 0.47160778101533651f,0.38195306668058038f,0.04547535255551338f,0.02313599688932300f,
 0.63996278587728739f,0.36444053100422025f,0.37049167416989803f,0.76907502254471183f,
0.89965870184823871f,0.89933154825121164f,0.64569224463775754f,0.34696785174310207f,
 0.39040711661800742f,0.08694788347929716f,0.22625351930037141f,0.21681279689073563f,
 0.33453882811591029f,0.15584628004580736f,0.95653126062825322f,0.83982629515230656f,
 0.50479181623086333f,0.54758223798125982f,0.83060362795367837f,0.21214072033762932f,
 0.02860224200412631f,0.95791505370289087f,0.91556971566751599f,0.94719038717448711f,
0.30791273340582848f,0.81771020544692874f,0.74679336044937372f,0.87552759842947125f,
 0.49545058421790600f,0.48191254725679755f,0.39087839704006910f,0.88425681227818131f,
 0.54299664497375488f,0.20552197424694896f,0.31019500363618135f,0.57183724315837026f,
 0.54999292083084583f,0.12055991357192397f,0.26517685409635305f,0.29529260704293847f,
 0.95132300630211830f,0.57458581728860736f,0.71528563741594553f,0.91191364871338010f,
0.18359116325154901f,0.45608301833271980f,0.17441136343404651f,0.18253823462873697f,
 0.77341705607250333f,0.01534702442586422f,0.27907355269417167f,0.94600243400782347f,
 0.39083331311121583f,0.35583620518445969f,0.58566563902422786f,0.44004907924681902f,
 0.79277362348511815f,0.96740394271910191f,0.06400812184438109f,0.07406814303249121f,
 0.03709788480773568f,0.85063817724585533f,0.10404936922714114f,0.12005183193832636f,
0.52963322307914495f,0.42104291776195168f,0.92252827808260918f,0.17444357229396701f,
 0.34813721571117640f,0.98178615467622876f,0.51038642041385174f,0.35229418566450477f,
 0.33187932055443525f,0.12522496515884995f,0.17751775681972504f,0.30953403143212199f,
 0.30514361429959536f,0.69633625121787190f,0.58739017136394978f,0.95729830628260970f,
 0.78135449346154928f,0.41670671710744500f,0.55824907496571541f,0.17518991930410266f,
0.11329598492011428f,0.87877958174794912f,0.81112976977601647f,0.1327551044523716f,
 0.88772260351106524f,0.77383322361856699f,0.39891980635002255f,0.42609489522874355f,
 0.29346287390217185f,0.29799025785177946f,0.62878308678045869f,0.90327445417642593f,
 0.88942573545500636f,0.11638559121638536f,0.92788035096600652f,0.30957929231226444f,
 0.2565767071209848f,0.42655616905540228f,0.26941573480144143f,0.65786541625857353f,
0.98608913458883762f,0.04273471748456359f,0.26294819917529821f,0.66961710015311837f,
 0.19781696423888206f,0.62439860356971622f,0.25354105327278376f,0.55396229820325971f,
 0.92479544691741467f,0.09095242014154792f,0.63873832207173109f,0.97996837133541703f,
 0.67638632655143738f,0.89037371007725596f,0.41085386741906404f,0.07612052233889699f,
 0.31289586611092091f,0.62697393959388137f,0.15661530848592520f,0.28013094374909997f};
	
float in2[]  =
	{0.56034345272928476f,0.89566554129123688f,0.53930272068828344f,0.3547350224107504f,
 0.80800013709813356f,0.62323769554495811f,0.58200186025351286f,0.56180121190845966f,
 0.23549679014831781f,0.28873602300882339f,0.43252215441316366f,0.7673156540840864f,
 0.06873596925288439f,0.18797885254025459f,0.86748637538403273f,0.73920361138880253f,
 0.97392784897238016f,0.86080306768417358f,0.39093428757041693f,0.57339327596127987f,
0.16198171628639102f,0.66783405328169465f,0.1454864419065416f,0.32747871475294232f,
 0.51621831534430385f,0.79978153714910150f,0.09275748720392585f,0.14153907122090459f,
 0.06119967205449939f,0.32070356840267777f,0.73968251561746001f,0.37837028549984097f,
 0.56752133695408702f,0.11224916437640786f,0.28770424565300345f,0.00037088664248586f,
 0.79149663401767612f,0.58377730334177613f,0.59390504425391555f,0.02694623963907361f,
0.76592414453625679f,0.02564378362149000f,0.74512455798685551f,0.02366107050329447f,
 0.06156063079833984f,0.04258572962135077f,0.63941287063062191f,0.38405111897736788f,
 0.14321060106158257f,0.42103306483477354f,0.05339348502457142f,0.93415357265621424f,
 0.59929492324590683f,0.66478141304105520f,0.14329732768237591f,0.42867958266288042f,
 0.10990926995873451f,0.63394964020699263f,0.05351450480520725f,0.54702291730791330f,
0.69746216991916299f,0.03159578284248710f,0.25769635709002614f,0.59392183972522616f,
 0.01609914982691407f,0.86753786867484450f,0.32879876391962171f,0.22861831961199641f,
 0.33929981896653771f,0.75886590173467994f,0.61312689306214452f,0.48855357570573688f,
 0.10645245248451829f,0.14542592084035277f,0.18745915638282895f,0.87820987729355693f,
 0.92918653646484017f,0.92348486324772239f,0.39261205168440938f,0.68466226710006595f,
0.08946218248456717f,0.42732305638492107f,0.77090662438422441f,0.924068246036768f,
 0.50982708018273115f,0.34508761204779148f,0.10317245963960886f,0.63696919381618500f,
 0.88041578140109777f,0.65034613572061062f,0.80938913393765688f,0.9986613355576992f,
 0.38141551148146391f,0.43060396797955036f,0.61948752496391535f,0.80996788293123245f,
 0.05324298795312643f,0.29668187908828259f,0.00448737759143114f,0.82276185229420662f,
0.19805425917729735f,0.10866974340751767f,0.99788628844544291f,0.6723356381990016f,
 0.46966064115986228f,0.79823006363585591f,0.67132972134277225f,0.35570297623053193f,
 0.52579802041873336f,0.25843874411657453f,0.19287035940214992f,0.59324032673612237f,
 0.25955950608476996f,0.61404782952740788f,0.21750316722318530f,0.81994143361225724f,
 0.19624035572633147f,0.8358787004835904f,0.42109713284298778f,0.31491625169292092f,
0.25988535769283772f,0.76794129703193903f,0.84549946337938309f,0.48446214850991964f,
 0.52822500281035900f,0.37241784948855639f,0.85067357495427132f,0.16846220474690199f,
 0.71482414938509464f,0.78300847951322794f,0.54156896471977234f,0.89239248540252447f,
 0.00643130205571651f,0.21658254135400057f,0.44520513340830803f,0.32618630956858397f,
 0.52326664514839649f,0.32250450644642115f,0.26230763643980026f,0.23438148852437735f,
0.50999558391049504f,0.37397424085065722f,0.64668390387669206f,0.64172910666093230f,
 0.03306737588718534f,0.18668571440503001f,0.83025926211848855f,0.99121205648407340f,
 0.38945918949320912f,0.27384403301402926f,0.41589357936754823f,0.99599931901320815f,
 0.81049045221880078f,0.96830060658976436f,0.40803860733285546f,0.52525822212919593f,
 0.33058117749169469f,0.23706211848184466f,0.17479355866089463f,0.62723324215039611f,
0.16741782892495394f,0.15187738463282585f,0.72003478836268187f,0.59474316425621510f,
 0.71126131806522608f,0.50548844784498215f,0.43874060269445181f,0.84671537391841412f,
 0.46396317798644304f,0.84823036566376686f,0.28646126668900251f,0.48104315437376499f,
 0.26604998949915171f,0.66378767788410187f,0.63686545100063086f,0.79531485401093960f,
 0.95694970060139894f,0.70720722898840904f,0.83713256847113371f,0.62996550090610981f,
0.34009417472407222f,0.72199993440881371f,0.67456434061750770f,0.10675506712868810f,
 0.79017778439447284f,0.34282173449173570f,0.58765271818265319f,0.07389529095962644f,
 0.16408033994957805f,0.12704358855262399f,0.51104495069012046f,0.07703803153708577f,
 0.12485344661399722f,0.51966900611296296f,0.49762418633326888f,0.77279568510130048f,
 0.95798523304983974f,0.22388020763173699f,0.83013197174295783f,0.04275623383000493f};


float result[] = 
{-0.13425098694507090f,0.24735018618193444f,-0.13997367470679392f,0.11987585715392905f,
 -0.07023550140255914f,-0.32818483956327921f,0.82293845909628660f,-0.04825208923032670f,
 0.41107043821212774f,0.28834120500378574f,
0.26097631689267364f,0.41112922481604613f,-0.48704150701173060f,0.16756167892414930f,
 0.18525816194433214f,0.24194769618197037f,0.04516579999951376f,0.08210988946198612f,
 -0.17724539433971653f,0.21570365259908197f,
0.46476238563747729f,0.12929328091152756f,0.03791742144738922f,0.33232469296313982f,
 -0.14531956716307623f,-0.04355937726216118f,-0.32871318476723438f,0.16208735115250936f,
 0.27759742819012267f,0.20883772519304408f,
0.60589399320385928f,0.06028369176400562f,0.33610957414517950f,-0.32741653379843827f,
 0.32006732568590329f,0.12357809346654614f,0.26645037101516444f,-0.15778041923768410f,
 -0.02281069075548223f,-0.21831876232917027f,
0.11316162639341981f,0.44869069077875356f,0.05087241573803265f,-0.07310286041500898f,
 0.24172631454502305f,0.20582249789901347f,-0.49030030296647070f,0.49725834464740676f,
 -0.15098926456955386f,0.29845287904710704f,
0.26126025652717821f,0.61602266860724408f,-0.04395376298763495f,-0.31468851985942192f,
 -0.42610430769336133f,0.07619666627024707f,0.42141080474076514f,0.34732212135875368f,
 0.21966932936729675f,-0.16465486570712187f,
0.01801836442044520f,0.13867951307716378f,-0.22823955222461578f,0.35528257041935002f,
 0.3416886047495104f,-0.05324845913867078f,-0.18334602929956423f,0.34486570917896908f,
 -0.09850219178062529f,0.15717539967151753f,
0.26027320955453370f,0.24744146889140337f,-0.164185466873868f,-0.18897859269730288f,
 -0.10286928200189474f,0.54800666111794050f,0.32097861553203794f,0.16617893447929227f,
 -0.03433269255504845f,-0.01421332288783149f,
-0.24887241840873561f,0.52303584234440914f,0.02976416459895397f,-0.12264750867737524f,
 0.30087087321455463f,0.28120264259279731f,-0.02981261204955734f,-0.05832040687613257f,
 0.09480786369785668f,0.26640553810556677f,
0.28112837735944118f,0.53844297257991636f,0.87478164836631844f,-0.1409682347398108f,
 0.66145942836153393f,-0.26119505204825816f,-0.34297154024663806f,-0.24798246038042729f,
 -0.30432340939641339f,0.37887301625026215f,
0.38327878821721156f,0.28922881585078497f,-0.34742629642806333f,-0.03677194909448467f,
 -0.04829379940842784f,0.06878313210496664f,0.04495930782786764f,0.47892284040726463f,
 0.32833980213443120f,-0.23534654463679133f,
-0.02763634740677747f,0.72078725530634646f,0.48763002329592203f,-0.57876872035917137f,
 0.23063708055466298f,0.04745273757978258f,-0.28751023415434818f,0.138229588096174f,
 0.36392895348902060f,-0.15741181362164816f,
0.13480297497174423f,-0.06082319210597478f,-0.03346206227374363f,0.157369564795072f,
 -0.09939329142432089f,0.50801256096451919f,-0.21552055455365590f,0.18726599728475304f,
 -0.09981549922929681f,0.56837678961938298f,
0.51101691288362061f,0.72117205689181529f,0.47311124338037619f,-0.59816447223287172f,
 0.56148184747810326f,0.06803537921378118f,-0.12236345370998958f,-0.2366952577209536f,
 -0.10560524465448745f,-0.03700000431544657f,
-0.07318875604760167f,0.49681103126620946f,0.16658812117729807f,0.19247716660649325f,
 0.17479922937365650f,0.20305642078183334f,-0.11893261285117168f,0.52167729786941019f,
 -0.26590601210923126f,-0.17052720242327102f};
		*/
	
	/*float in1[] =    { 4.0f , 3.0f , 8.0f , 9.0f } ;
	float in2[] =    { 1.0f , 3.0f , 2.0f , 4.0f } ;
	float result[] = { 4.0f , 7.5f , 0.0f ,-1.5f };
float out[(COLUMNS)*(LINES2)] ;*/
	
	float in1[] =    { 1.0f ,3.0f ,2.0f ,4.0f } ;
	float in2[] =    { 1.0f , 2.0f } ;
	float result[] = { 1.0f , 2.2f };
	float out [(COLUMNS)*(LINES2)] ;
    
 

	srdivma ( in1 , LINES1 , COLUMNS , in2 , LINES2 , COLUMNS , out) ;
	
	for ( i = 0 ; i < LINES2 *COLUMNS ; ++i )
	{
		printf ( "\t\t %d out : %e  result : %e   assert : %e \n" ,
                 i , out[i] , result[i] , fabs ( out[i] - result[i] ) / fabs( out[i]) ) ;
			assert ( fabs ( out[i] - result[i] ) / fabs( out[i]) < 1e-6 ) ;
	}
	
}







static void drdivmaTest ( void )
{
	int i = 0 ; 
	
/*	double in1[] =    { 4 , 3 , 8 , 9 } ;
	double in2[] =    { 1 , 3 , 2 , 4 } ;
	double result[] = { 4 , 7.5 , 0 ,-1.5 };*/
	
	
	double in1[] =    { 1 ,3 ,2 ,4 } ;
	double in2[] =    { 1 , 2 } ;
	double result[] = { 1 , 2.2 };
	double out [(COLUMNS)*(LINES2)] ;

	drdivma ( in1 , LINES1 , COLUMNS , in2 , LINES2 , COLUMNS , out) ;
	for ( i = 0 ; i < LINES2 *COLUMNS  ; i++ )
	{
		printf ( "\t\t %d out : %e  result : %e   assert : %e \n" ,
                 i , out[i] , result[i] , fabs ( out[i] - result[i] ) / fabs( out[i]) ) ;
		
			assert ( fabs ( out[i] - result[i] ) / fabs( out[i]) < 3e-16 ) ;
	}
	
}

static void crdivmaTest (void )
{
    int i = 0 ;
    
    float tin1[] = { 1.0f , 3.0f , 2.0f ,4.0f};
    float tin2[] = { 1.0f , 2.0f};
    
    
	floatComplex* in1 ;
	floatComplex* in2 ;
	floatComplex out[ZLINES2*ZCOLUMNS]  ;
	floatComplex Result[ZLINES1*ZLINES2] ;

	in1 = FloatComplexMatrix (  tin1 , tin1 , ZLINES1*ZCOLUMNS );
	in2 = FloatComplexMatrix (  tin2 , tin2 , ZLINES2*ZCOLUMNS );

	
    Result[0] = FloatComplex ( 1.0f ,  0 );
    Result[1] = FloatComplex ( 2.2f   , 0 );
    
	crdivma ( in1 , ZLINES1 , ZCOLUMNS , in2 ,ZLINES2 , ZCOLUMNS , out) ;
	
		for ( i = 0 ; i < (ZLINES2*ZCOLUMNS )  ; i++ )
	{
	  printf ( "\t\t %d out : %e + %e * i  result : %e + %e * i   assert : %e + %e \n" ,
              i ,creals(out[i]) , cimags(out[i]) , creals (Result[i])  , cimags (Result[i]),
              fabs(  creals(out[i]) -  creals (Result[i]) ) / fabs (creals (out[i])) ,
              fabs(  cimags(out[i]) -  cimags (Result[i]) ) / fabs (cimags (out[i])));
        
    if (  creals(out[i])  < 1e-06 && creals (Result[i]) < 1e-08 )
        assert ( 1 ) ;
    else         
        assert ( fabs(  creals(out[i]) -  creals (Result[i]) ) / fabs (creals (out[i]))  < 1e-16 );
    
        
    if (  cimags(out[i])  < 1e-06 && cimags (Result[i]) < 1e-08 )
        assert ( 1 ) ;
    else         
	    assert ( fabs(  cimags(out[i]) -  cimags (Result[i]) ) / fabs (cimags (out[i]))  < 1e-16  ) ;

    }
    
}





static void zrdivmaTest ( void ){
	int i = 0 ; 
	
/*	double tin1 [] = 
	{0.69949407549574971,0.25834653992205858,0.61552664963528514,0.19030105322599411,
 0.46075769001618028,0.52200102340430021,0.70538004627451301,0.88748936913907528,
 0.18582182424142957,0.09225247148424387,0.37796644819900393,0.93693156912922859,
 0.19805216649547219,
0.47020285483449697,0.37788185989484191,0.36296494491398335,0.27933338703587651,
 0.67214426863938570,0.69089507637545466,0.5104757994413376,0.06106034899130464,
 0.93353842478245497,0.14489983161911368,0.57212112657725811,0.54598869429901242,
 0.05166801903396845,
0.50110132200643420,0.92609716579318047,0.85469480464234948,0.58570997323840857,
 0.8791871047578752,0.25320483185350895,0.7903951373882592,0.63298055250197649,
 0.86023237137123942,0.90196201950311661,0.31587493652477860,0.40010235738009214,
 0.11108959605917335,
0.47051278315484524,0.53627631859853864,0.28784319106489420,0.87401255918666720,
 0.07408339157700539,0.28149573365226388,0.70837680157274008,0.16526474570855498,
 0.26673525758087635,0.88194080116227269,0.35371549893170595,0.02646211860701442,
 0.08616474270820618,
0.23139652097597718,0.13406464736908674,0.67240026732906699,0.19029983691871166,
 0.73075085924938321,0.50484903249889612,0.87911593122407794,0.55444371327757835,
 0.2063297093845904,0.40116110350936651,0.45593289798125625,0.69771515764296055,
 0.39659122796729207,
0.49838109035044909,0.14524227706715465,0.90753587335348129,0.10092954570427537,
 0.01771899592131376,0.79376714816316962,0.43091466091573238,0.58433785336092114,
 0.79542846325784922,0.13906158460304141,0.10127847269177437,0.331680862698704,
 0.83444251772016287,
0.05499405181035399,0.36960034258663654,0.74532664241269231,0.05718118418008089,
 0.59996518073603511,0.20857419073581696,0.87988782906904817,0.47828097920864820,
 0.71160991629585624,0.85858650319278240,0.80782221304252744,0.51599627826362848,
 0.89173404080793262,
0.88423488661646843,0.70964269945397973,0.66102255787700415,0.72523507243022323,
 0.51014349795877934,0.28248664410784841,0.22149151284247637,0.57675753859803081,
 0.70482534915208817,0.56079456442967057,0.36288804840296507,0.30883262446150184,
 0.98134148679673672,
0.74284822540357709,0.16163914743810892,0.36525219632312655,0.38350704684853554,
 0.11691810050979257,0.89112461265176535,0.06342720007523894,0.62639418430626392,
 0.68077020766213536,0.25885968375951052,0.43948043463751674,0.85988187789916992,
 0.54828232014551759,
0.81359952967613935,0.48982370039448142,0.02400260977447033,0.73691955255344510,
 0.24111561570316553,0.15296932263299823,0.26483592018485069,0.42981932172551751,
 0.76739394571632147,0.87532604997977614,0.37969883717596531,0.30623568268492818,
 0.38800517935305834}
;	
	double tin2[] =
		{0.10472932783886790,0.76038318127393723,0.03409303957596421,0.14239662420004606,
 0.55545594682916999,0.80318974517285824,0.51839923160150647,
0.15185610298067331,0.58847306622192264,0.25450934842228889,0.99926799396052957,
 0.63989769574254751,0.55067161237820983,0.46070076711475849,
0.59330079378560185,0.65381935704499483,0.41683405218645930,0.99101553857326508,
 0.37207804108038545,0.70618240814656019,0.57808654149994254,
0.60231964103877544,0.57150967465713620,0.05496290419250727,0.12058544857427478,
 0.01436204835772514,0.02579512307420373,0.84112487640231848,
0.43818825250491500,0.46434015966951847,0.41974264057353139,0.80236544925719500,
 0.52285881666466594,0.50951210409402847,0.45319801801815629,
0.78178183268755674,0.77655703714117408,0.04660592041909695,0.51133266882970929,
 0.75021018926054239,0.68836286617442966,0.01677561178803444,
0.93454108992591500,0.56098637636750937,0.22058471059426665,0.76485407538712025,
 0.48169769765809178,0.15587856341153383,0.24760220525786281,
0.5216529071331024,0.08052303874865174,0.44094172399491072,0.89119336148723960,
 0.97805908136069775,0.45880937622860074,0.55104400310665369,
0.09609609050676227,0.41967850551009178,0.75025565037503839,0.72181495930999517,
 0.28955410188063979,0.39077644981443882,0.66866181464865804,
0.48776568192988634,0.46859717695042491,0.35626485198736191,0.34423254663124681,
 0.42533078324049711,0.55880581727251410,0.33048649691045284};
	
	double tresult [] = 
{0.09451169317317064,0.75015055776907902,0.36496074775718695,0.68454978838459446,
 0.13580235186649750,-0.73350613524989861,0.36833823393043919,0.27427787570717332,
 0.17435767433670571,1.27922130237729870,-0.15718152608891298,-0.66812523122285583,
 0.43535989166783623,
-0.17216817930992268,-1.11920478787033972,0.09365729285784405,-0.91168598672719281,
 -0.5256902016286176,1.47418373212534837,0.32785551967187748,0.09665910045214705,
 0.38963814934750451,-0.74599090807052515,0.77435560834796702,1.17862196275483577,
 0.41913747422722752,
0.65168405083167491,-0.79778304970274549,-0.36689764540805470,-0.07037790812871010,
 -0.90964747913660449,0.87009086524746737,-0.86086796711204328,0.69420170666117553,
 0.39900228216491013,0.01839542030829135,0.34079166496122038,0.94979559344928910,
 1.29342689865858507,
-0.64010890644433138,0.43942520236508265,0.36871562427022309,-0.23543430717113373,
 0.9837594524525952,-0.15541789413277388,0.51832027142464965,-0.49730447418173146,
 0.37785363034287500,0.05031307256758123,0.14529056591993289,-0.19261761155662854,
 -0.65165849136819898,
0.56992829732488970,-0.67626872453203313,0.08987541550832115,-0.27809079516465274,
 -0.52685742082861620,0.87085948155471882,-0.36015598439076552,0.24628281709439132,
 0.16018284982540432,-0.78765458348414275,0.4868803314915888,0.67004786693098373,
 1.38638653773561149,
0.49065638508775172,1.15002211885645633,0.31098171282535453,0.772677804931936,
 0.77563266454559698,-0.93158860042668212,0.20092451587523308,0.56834988643083173,
 -0.03774794264631696,0.70322729924980754,-0.84660509947179974,-0.48910607201144141,
 -0.91999377725600595,
0.57044463605090034,0.85729374705550832,0.03549271915962299,1.08806327983132478,
 0.40323683962485551,-0.27978276073461661,0.45277262688908537,0.06218152458345420,
 -0.2153422115217984,0.68840508909853904,0.09945644614561956,-0.17861252621808085,
 -0.44037299008464365}
;*/
    
	double bR[6]={1,4,2,5,3,6};
	double bI[6]={1,0,4,0,1,2};
	double dR[9]={4,8,3,2,8,4,3,4,5};
	double dI[9]={0,0,4,0,-1,0,0,0,0};
	double rR[6]={0.9845119462120300868335,1.191739704646416209144,- 0.1118981870572697823185,
	0.2069876335694560698375,0.0988113819185977154680,0.3193660703565854852570};
	double rI[6]={- 1.3492616160403412273183,- 0.3196061952215153434409,0.5309160763597071674980,
	- 0.3168447592748228625048,0.5848241085364388469614,0.8452395245527674072505};
	doubleComplex* in1 ;
	doubleComplex* in2 ;
	doubleComplex* out  ;
	doubleComplex* Result ;

	in1 = DoubleComplexMatrix ( bR,bI,6 );
	in2 = DoubleComplexMatrix ( dR,dI,9 );
	out = (doubleComplex*)malloc((unsigned int)6*sizeof(doubleComplex));
	Result = (doubleComplex*)malloc((unsigned int)6*sizeof(doubleComplex));
	
    Result = DoubleComplexMatrix ( rR   , rI , 6 );
    
	zrdivma ( in1 , 2 , 3 , in2 ,3 , 3 , out) ;
	
    for ( i = 0 ; i < (6 )  ; i++ )
	{
	  printf ( "\t\t %d out : %1.20f + %1.20f * i  result : %1.20f + %1.20f * i  assert : %e + %e \n" ,
              i ,zreals(out[i]) , zimags(out[i]) , zreals (Result[i])  , zimags (Result[i]),
              fabs(  zreals(out[i]) -  zreals (Result[i]) ) / fabs (zreals (out[i])) ,
              fabs(  zimags(out[i]) -  zimags (Result[i]) ) / fabs (zimags (out[i])));
    
    /* if we don't add that test assert failed if result = 0  'cause then we have  |(out - 0)|/|out| = 1*/     
        
    if (  zreals(out[i])  < 1e-16 && zreals (Result[i]) < 1e-16 )
        assert ( 1 ) ;
    else         
        assert ( fabs(  zreals(out[i]) -  zreals (Result[i]) ) / fabs (zreals (out[i]))  < 3e-15 );
    
        
    if (  zimags(out[i])  < 1e-16 && zimags (Result[i]) < 1e-16 )
        assert ( 1 ) ;
    else         
	    assert ( fabs(  zimags(out[i]) -  zimags (Result[i]) ) / fabs (zimags (out[i]))  < 3e-15  ) ;

	}
	
	free(Result);
	free(out);
}



static void mytest (void ){
  double in1[16] = {  1 , 5 , 9  , 13  } ;
  double in2[16] = {  2 , 6 , 10   } ;

  double out[16] = { 0 } ;
 
  int i = 0 ;

 drdivma  ( in1 , 1 , 4  , in2 ,1, 3 , out  ); 

  for ( i = 0 ; i <1; i++)
     {
printf ( "\t\t %d out : %20.15e\t\n" , i , out[i]  ) ;

     }

}


static int testRDivma   (void) {

  printf("\n\n\n\n**********************\n");
  printf("***** Right Tests ****\n");
  printf("**********************\n");
   mytest ( );
  printf("\n\t>>>> Float real  Tests\n");
  sdivmaTest();
    
  printf("\n\n\n\n\t>>>> Double real  Tests\n");
  drdivmaTest();

  printf("\n\t>>>> Float complex  Tests\n");
  crdivmaTest();	
    
  printf("\n\t>>>> Double complex  Tests\n");
  zrdivmaTest();	
  return 0;
}


int main(void) {
  assert(testRDivma () == 0);
  return 0;
}
