/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2008-2008 - INRIA - Allan SIMON
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include <assert.h>
#include <stdio.h>
#include "infiniteNorm.h"


#define LEADDIM 10

#define DMATRIX_IN  {0.15869047446176410,0.80895681912079453,0.72621259605512023,0.18993748771026731,\
 0.43964602379128337,0.37921421090140939,0.95195201179012656,0.59145097108557820,\
 0.70597065938636661,0.62873698258772492,\
0.62407150492072105,0.68317985069006681,0.70999773032963276,0.25839814636856318,\
 0.65407369285821915,0.76687160786241293,0.71278580836951733,0.68067426700145006,\
 0.70181696489453316,0.28785153012722731,\
0.63760355720296502,0.03401931514963508,0.47457459988072515,0.09878737432882190,\
 0.58781063789501786,0.60066213225945830,0.11923700617626309,0.07392961112782359,\
 0.40879997471347451,0.3292048736475408,\
0.42704886104911566,0.23805456422269344,0.9438692079856992,0.06199027225375175,\
 0.60208318661898375,0.78567356057465076,0.50091631803661585,0.94336947053670883,\
 0.06362213846296072,0.47192330472171307,\
0.10716815060004592,0.94920115964487195,0.14596485672518611,0.04034968325868249,\
 0.04535020282492042,0.73871155502274632,0.32900535268709064,0.12863306934013963,\
 0.06573933875188231,0.33537696348503232,\
0.23822965659201145,0.21827886346727610,0.07141010463237762,0.74001471605151892,\
 0.20294443331658840,0.55442603398114443,0.48089468106627464,0.20190807711333036,\
 0.53310041315853596,0.55530697200447321,\
0.94629473658278584,0.61546878470107913,0.67337385797873139,0.61626600986346602,\
 0.78442738251760602,0.99291495559737086,0.33036959776654840,0.19693034281954169,\
 0.03315818728879094,0.11960808141157031,\
0.45766852516680956,0.83135433867573738,0.65369247179478407,0.6583583448082209,\
 0.26375361625105143,0.97574284672737122,0.63044753577560186,0.89286901615560055,\
 0.31578356493264437,0.76139996573328972,\
0.89644787041470408,0.77340125897899270,0.19968961318954825,0.25145971449092031,\
 0.43832763982936740,0.37096222722902894,0.21171907847747207,0.46179189579561353,\
 0.37858232436701655,0.47909884760156274,\
0.44384705275297165,0.4244190966710448,0.60141251794993877,0.38433500844985247,\
 0.86648589745163918,0.30322382133454084,0.44860231317579746,0.62512917164713144,\
 0.46195234358310699,0.28169692959636450}

#define DRESULT_OUT 6.46840295149013400

#define FMATRIX_IN  {0.15869047446176410f,0.80895681912079453f,0.72621259605512023f,0.18993748771026731f,\
 0.43964602379128337f,0.37921421090140939f,0.95195201179012656f,0.59145097108557820f,\
 0.70597065938636661f,0.62873698258772492f,\
0.62407150492072105f,0.68317985069006681f,0.70999773032963276f,0.25839814636856318f,\
 0.65407369285821915f,0.76687160786241293f,0.71278580836951733f,0.68067426700145006f,\
 0.70181696489453316f,0.28785153012722731f,\
0.63760355720296502f,0.03401931514963508f,0.47457459988072515f,0.09878737432882190f,\
 0.58781063789501786f,0.60066213225945830f,0.11923700617626309f,0.07392961112782359f,\
 0.40879997471347451f,0.3292048736475408f,\
0.42704886104911566f,0.23805456422269344f,0.9438692079856992f,0.06199027225375175f,\
 0.60208318661898375f,0.78567356057465076f,0.50091631803661585f,0.94336947053670883f,\
 0.06362213846296072f,0.47192330472171307f,\
0.10716815060004592f,0.94920115964487195f,0.14596485672518611f,0.04034968325868249f,\
 0.04535020282492042f,0.73871155502274632f,0.32900535268709064f,0.12863306934013963f,\
 0.06573933875188231f,0.33537696348503232f,\
0.23822965659201145f,0.21827886346727610f,0.07141010463237762f,0.74001471605151892f,\
 0.20294443331658840f,0.55442603398114443f,0.48089468106627464f,0.20190807711333036f,\
 0.53310041315853596f,0.55530697200447321f,\
0.94629473658278584f,0.61546878470107913f,0.67337385797873139f,0.61626600986346602f,\
 0.78442738251760602f,0.99291495559737086f,0.33036959776654840f,0.19693034281954169f,\
 0.03315818728879094f,0.11960808141157031f,\
0.45766852516680956f,0.83135433867573738f,0.65369247179478407f,0.6583583448082209f,\
 0.26375361625105143f,0.97574284672737122f,0.63044753577560186f,0.89286901615560055f,\
 0.31578356493264437f,0.76139996573328972f,\
0.89644787041470408f,0.77340125897899270f,0.19968961318954825f,0.25145971449092031f,\
 0.43832763982936740f,0.37096222722902894f,0.21171907847747207f,0.46179189579561353f,\
 0.37858232436701655f,0.47909884760156274f,\
0.44384705275297165f,0.4244190966710448f,0.60141251794993877f,0.38433500844985247f,\
 0.86648589745163918f,0.30322382133454084f,0.44860231317579746f,0.62512917164713144f,\
 0.46195234358310699f,0.28169692959636450f}

#define FRESULT_OUT 6.46840295149013400f


#define ZRMATRIX_IN {0.21132486546412110,0.56084860628470778,0.30760907428339124,0.50153415976092219, \
 0.28064980218186975,0.40948254754766822,0.38737787725403905,0.53762298030778766,\
 0.58787201577797532,0.64885628735646605,\
0.75604385416954756,0.66235693730413914,0.93296162132173777,0.43685875833034515,\
 0.12800584640353918,0.87841258011758327,0.92228986788541079,0.11999255046248436,\
 0.48291792999953032,0.99231909401714802,\
0.00022113462910056,0.72635067673400044,0.21460078610107303,0.26931248093023896,\
 0.77831285959109664,0.11383596854284406,0.94881842611357570,0.2256303490139544,\
 0.22328650346025825,0.05004197778180242,\
0.33032709173858166,0.19851438421756029,0.31264199689030647,0.63257448654621840,\
 0.21190304495394230,0.19983377400785685,0.34353372454643250,0.62740930821746588,\
 0.84008856676518917,0.74855065811425447,\
0.66538110421970487,0.54425731627270579,0.36163610080257058,0.40519540151581168,\
 0.11213546665385365,0.56186607433483005,0.37601187312975526,0.76084325974807143,\
 0.12059959070757031,0.41040589986369014,\
0.62839178834110498,0.23207478970289230,0.2922266637906432,0.91847078315913677,\
 0.68568959552794695,0.58961773291230202,0.73409405630081892,0.04855662025511265,\
 0.28553641680628061,0.60845263302326202,\
0.84974523587152362,0.23122371966019273,0.56642488157376647,0.04373343335464597,\
 0.15312166837975383,0.68539796629920602,0.26157614728435874,0.67239497276023030,\
 0.86075146449729800,0.85442108893766999,\
0.68573101982474327,0.21646326314657927,0.48264719732105732,0.48185089323669672,\
 0.69708506017923355,0.89062247332185507,0.49934938363730907,0.20171726960688829,\
 0.84941016510128975,0.06426467280834913,\
0.87821648130193353,0.88338878145441413,0.33217189135029912,0.26395560009405017,\
 0.84155184263363481,0.50422128057107329,0.26385784195736051,0.39115739194676280,\
 0.52570608118548989,0.82790829380974174,\
0.06837403681129217,0.65251349471509457,0.59350947011262178,0.41481037065386772,\
 0.40620247554033995,0.34936154074966908,0.52535630855709314,0.83003165572881699,\
 0.99312098976224661,0.92623437754809856}

#define ZIMATRIX_IN {0.56672112690284848,0.73956565884873271,0.02587099233642220,0.70648676296696067,\
 0.96770532103255391,0.42568723810836673,0.18711117887869477,0.21240556007251143,\
 0.69127879338338971,0.13049928424879909,\
0.57116389367729425,0.00371731072664261,0.51744682248681784,0.52114724926650524,\
 0.50685344357043505,0.24615605548024178,0.01895748358219862,0.57950199581682682,\
 0.76568587962538004,0.96820035576820374,\
0.81601104838773608,0.59005728596821427,0.39168732380494475,0.28704008506610990,\
 0.52329764096066356,0.92295324662700295,0.84335647663101554,0.26281475694850087,\
 0.35726496530696750,0.6561381467618048,\
0.05689279362559319,0.3096467358991504,0.24135384149849415,0.65027950797230005,\
 0.5596947595477104,0.10007458087056875,0.07485948316752911,0.43609866220504045,\
 0.76933998242020607,0.24455389659851789,\
0.55959366867318749,0.25522057106718421,0.50644348980858922,0.08813347620889544,\
 0.56173070007935166,0.46782181179150939,0.85328151332214475,0.91105451015755534,\
 0.54776339093223214,0.52831235667690635,\
0.12493403162807226,0.62518793903291225,0.42361020017415285,0.44987633451819420,\
 0.46817600261420012,0.39504976756870747,0.01245901081711054,0.80826673656702042,\
 0.09622887428849936,0.84689256362617016,\
0.72792222863063216,0.11574173765257001,0.28937275288626552,0.72272530803456903,\
 0.77945467224344611,0.03661171020939946,0.18675393564626575,0.81026530498638749,\
 0.95611717319115996,0.78766220854595304,\
0.26777664758265018,0.61170040909200907,0.08879321813583374,0.89767962601035833,\
 0.79010718129575253,0.51753685344010592,0.49205840751528740,0.25904283951967955,\
 0.22074085660278797,0.12620826158672571,\
0.54653349192813039,0.67839562846347690,0.62128817522898316,0.24278218811377883,\
 0.98085420625284314,0.83254515705630183,0.74896081397309899,0.41390872886404395,\
 0.01432593585923314,0.78838609857484698,\
0.98854076582938433,0.33200952783226967,0.34549844544380903,0.43377211131155491,\
 0.81870661024004221,0.61048321425914764,0.94149570073932409,0.35999277792870998,\
 0.81914897728711367,0.34530424699187279}

#define ZRESULT_OUT 8.6410312306124072989633 

#define CRMATRIX_IN {0.21132486546412110f,0.56084860628470778f,0.30760907428339124f,0.50153415976092219f, \
 0.28064980218186975f,0.40948254754766822f,0.38737787725403905f,0.53762298030778766f,\
 0.58787201577797532f,0.64885628735646605f,\
0.75604385416954756f,0.66235693730413914f,0.93296162132173777f,0.43685875833034515f,\
 0.12800584640353918f,0.87841258011758327f,0.92228986788541079f,0.11999255046248436f,\
 0.48291792999953032f,0.99231909401714802f,\
0.00022113462910056f,0.72635067673400044f,0.21460078610107303f,0.26931248093023896f,\
 0.77831285959109664f,0.11383596854284406f,0.94881842611357570f,0.2256303490139544f,\
 0.22328650346025825f,0.05004197778180242f,\
0.33032709173858166f,0.19851438421756029f,0.31264199689030647f,0.63257448654621840f,\
 0.21190304495394230f,0.19983377400785685f,0.34353372454643250f,0.62740930821746588f,\
 0.84008856676518917f,0.74855065811425447f,\
0.66538110421970487f,0.54425731627270579f,0.36163610080257058f,0.40519540151581168f,\
 0.11213546665385365f,0.56186607433483005f,0.37601187312975526f,0.76084325974807143f,\
 0.12059959070757031f,0.41040589986369014f,\
0.62839178834110498f,0.23207478970289230f,0.2922266637906432f,0.91847078315913677f,\
 0.68568959552794695f,0.58961773291230202f,0.73409405630081892f,0.04855662025511265f,\
 0.28553641680628061f,0.60845263302326202f,\
0.84974523587152362f,0.23122371966019273f,0.56642488157376647f,0.04373343335464597f,\
 0.15312166837975383f,0.68539796629920602f,0.26157614728435874f,0.67239497276023030f,\
 0.86075146449729800f,0.85442108893766999f,\
0.68573101982474327f,0.21646326314657927f,0.48264719732105732f,0.48185089323669672f,\
 0.69708506017923355f,0.89062247332185507f,0.49934938363730907f,0.20171726960688829f,\
 0.84941016510128975f,0.06426467280834913f,\
0.87821648130193353f,0.88338878145441413f,0.33217189135029912f,0.26395560009405017f,\
 0.84155184263363481f,0.50422128057107329f,0.26385784195736051f,0.39115739194676280f,\
 0.52570608118548989f,0.82790829380974174f,\
0.06837403681129217f,0.65251349471509457f,0.59350947011262178f,0.41481037065386772f,\
 0.40620247554033995f,0.34936154074966908f,0.52535630855709314f,0.83003165572881699f,\
 0.99312098976224661f,0.92623437754809856f}

#define CIMATRIX_IN {0.56672112690284848f,0.73956565884873271f,0.02587099233642220f,0.70648676296696067f,\
 0.96770532103255391f,0.42568723810836673f,0.18711117887869477f,0.21240556007251143f,\
 0.69127879338338971f,0.13049928424879909f,\
0.57116389367729425f,0.00371731072664261f,0.51744682248681784f,0.52114724926650524f,\
 0.50685344357043505f,0.24615605548024178f,0.01895748358219862f,0.57950199581682682f,\
 0.76568587962538004f,0.96820035576820374f,\
0.81601104838773608f,0.59005728596821427f,0.39168732380494475f,0.28704008506610990f,\
 0.52329764096066356f,0.92295324662700295f,0.84335647663101554f,0.26281475694850087f,\
 0.35726496530696750f,0.6561381467618048f,\
0.05689279362559319f,0.3096467358991504f,0.24135384149849415f,0.65027950797230005f,\
 0.5596947595477104f,0.10007458087056875f,0.07485948316752911f,0.43609866220504045f,\
 0.76933998242020607f,0.24455389659851789f,\
0.55959366867318749f,0.25522057106718421f,0.50644348980858922f,0.08813347620889544f,\
 0.56173070007935166f,0.46782181179150939f,0.85328151332214475f,0.91105451015755534f,\
 0.54776339093223214f,0.52831235667690635f,\
0.12493403162807226f,0.62518793903291225f,0.42361020017415285f,0.44987633451819420f,\
 0.46817600261420012f,0.39504976756870747f,0.01245901081711054f,0.80826673656702042f,\
 0.09622887428849936f,0.84689256362617016f,\
0.72792222863063216f,0.11574173765257001f,0.28937275288626552f,0.72272530803456903f,\
 0.77945467224344611f,0.03661171020939946f,0.18675393564626575f,0.81026530498638749f,\
 0.95611717319115996f,0.78766220854595304f,\
0.26777664758265018f,0.61170040909200907f,0.08879321813583374f,0.89767962601035833f,\
 0.79010718129575253f,0.51753685344010592f,0.49205840751528740f,0.25904283951967955f,\
 0.22074085660278797f,0.12620826158672571f,\
0.54653349192813039f,0.67839562846347690f,0.62128817522898316f,0.24278218811377883f,\
 0.98085420625284314f,0.83254515705630183f,0.74896081397309899f,0.41390872886404395f,\
 0.01432593585923314f,0.78838609857484698f,\
0.98854076582938433f,0.33200952783226967f,0.34549844544380903f,0.43377211131155491f,\
 0.81870661024004221f,0.61048321425914764f,0.94149570073932409f,0.35999277792870998f,\
 0.81914897728711367f,0.34530424699187279f}

#define CRESULT_OUT 8.6410312306124072989633f 

static void sinfnormaTest(void) {
    
    float in[] = FMATRIX_IN ;
    
    float out = 0;
    
    float result = FRESULT_OUT ;
    
    out = sinfnorma ( in , LEADDIM , LEADDIM );
    
    printf ( "\t\t  out : %e\tresult : %e\tassert : %e \n" , out , result , fabs ( out - result ) / fabs( out) ) ;
    assert ( fabs ( out - result ) / fabs( out) < 1e-6 ) ;
    
    
    
}

static void dinfnormaTest(void) {
    
    double in[] = DMATRIX_IN ;
    
    double out = 0;
    
    double result = DRESULT_OUT ;
    
    out = dinfnorma ( in , LEADDIM , LEADDIM );
    
    printf ( "\t\t  out : %.16f\tresult : %.16f\tassert : %e \n" , out , result , fabs ( out - result ) / fabs( out) ) ;
   assert ( fabs ( out - result ) / fabs( out) < 3e-16 ) ;
    
    
    
}

static void zinfnormaTest(void) {
    
    double Rin[] = ZRMATRIX_IN ;
    double Iin[] = ZIMATRIX_IN ;
    
    doubleComplex* in = DoubleComplexMatrix ( Rin , Iin , LEADDIM*LEADDIM ) ;
    
    double out = 0;
    
    double result = ZRESULT_OUT ;
    
    out = zinfnorma ( in , LEADDIM , LEADDIM );
    
    printf ( "\t\t  out : %.16f\tresult : %.16f\tassert : %e \n" , out , result , fabs ( out - result ) / fabs( out) ) ;
   assert ( fabs ( out - result ) / fabs( out) < 3e-16 ) ;
    
    
    
}

static void cinfnormaTest(void) {
    
    float Rin[] = CRMATRIX_IN ;
    float Iin[] = CIMATRIX_IN ;
    
    floatComplex* in = FloatComplexMatrix ( Rin , Iin , LEADDIM*LEADDIM ) ;
    
    float out = 0;
    
    float result = CRESULT_OUT ;
    
    out = cinfnorma ( in , LEADDIM , LEADDIM );
    
    printf ( "\t\t  out : %.16f\tresult : %.16f\tassert : %e \n" , out , result , fabs ( out - result ) / fabs( out) ) ;
   assert ( fabs ( out - result ) / fabs( out) < 3e-6 ) ;
    
    
    
}

static int testInfiniteNorm(void) {

  printf("\n>>>> Matrix Exponential Tests\n");
  printf("\t>>>> Matrix Double Realt Tests\n");  
  dinfnormaTest();

  printf("\n\n\t>>>> Matrix Float Realt Tests\n");     
  sinfnormaTest();
  
  printf("\n\n\n");
  printf("\t>>>> Matrix Float Complex Tests\n");      
  cinfnormaTest();; 
    
  printf("\n\n\n");
  printf("\t>>>> Matrix Double Complex Tests\n");  
  zinfnormaTest();

  return 0;
}



int main(void) {
  assert(testInfiniteNorm() == 0);
  return 0;
}


