
/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include <math.h>
#include <assert.h>
#include "matrixMagnitude.h"
#include <stdio.h>
static void dmagnsTest(void){
	double in[11]={-5,-4,-3,-2,-1,0,1,2,3,4,5};
	double res[11]={5,4,3,2,1,0,1,2,3,4,5};
	double out;
	int i;
	
	for (i=0;i<11;i++) {
		out=dmagns(in[i]);
		if (out==0) assert( fabs(out-res[i])==0);
		else assert( fabs(out-res[i])/fabs(out)==0);
	}
}


static void zmagnsTest(void){
	double inR[8] = {0.3493615407496690750122,0.9222898678854107856751,- 0.8906224733218550682068,- 0.3435337245464324951172, \
	0.5896177329123020172119,0.5896177329123020172119,- 0.5896177329123020172119,- 0.5896177329123020172119};
	double inI[8] = { 0.3873778772540390491486,0.9488184261135756969452,0.5042212805710732936859,- 0.3760118731297552585602, \
	0.6853979662992060184479,- 0.6853979662992060184479,0.6853979662992060184479,- 0.6853979662992060184479};
	double res[8] = {0.5216465335270885628205,1.3232063354355325657252,1.0234488212737711254618, 0.5093136053899318671512, \
	0.9041125168759308605715,0.9041125168759308605715,0.9041125168759308605715,0.9041125168759308605715};
	int i;
	double out;
	doubleComplex in;
	
	for (i=0;i<8;i++) {
		in = DoubleComplex(inR[i],inI[i]);
		out=zmagns(in);
		assert( fabs(out-res[i])/fabs(out)<3e-16);
	}
}


static void dmagnaTest(void){
	double in1[12] = {0.2017172696068882942200,0.3911573919467628002167,0.8300316557288169860840,\
	0.5878720157779753208160,0.4829179299995303153992,0.2232865034602582454681,\
	0.8400885667651891708374,0.1205995907075703144074,0.2855364168062806129456,\
	0.8607514644972980022430,0.8494101651012897491455,0.5257060811854898929596};
	double in2[12] = {0.2017172696068882942200,0.8400885667651891708374,0.3911573919467628002167,\
	0.1205995907075703144074,0.8300316557288169860840,0.2855364168062806129456,\
	0.5878720157779753208160,0.8607514644972980022430,0.4829179299995303153992,\
	0.8494101651012897491455,0.2232865034602582454681,0.5257060811854898929596};
	double in3[12] = {0.2017172696068882942200,0.4829179299995303153992,0.2855364168062806129456,\
	0.3911573919467628002167,0.2232865034602582454681,0.8607514644972980022430,\
	0.8300316557288169860840,0.8400885667651891708374,0.8494101651012897491455,\
	0.5878720157779753208160,0.1205995907075703144074,0.5257060811854898929596};
	double in4[12] = {0.2017172696068882942200,0.5878720157779753208160,0.8400885667651891708374,\
	0.8607514644972980022430,0.3911573919467628002167,0.4829179299995303153992,\
	0.1205995907075703144074,0.8494101651012897491455,0.8300316557288169860840,\
	0.2232865034602582454681,0.2855364168062806129456,0.5257060811854898929596};
	double in5[12] = {0.2017172696068882942200,0.8300316557288169860840,0.4829179299995303153992,\
	0.8400885667651891708374,0.2855364168062806129456,0.8494101651012897491455,\
	0.3911573919467628002167,0.5878720157779753208160,0.2232865034602582454681,\
	0.1205995907075703144074,0.8607514644972980022430,0.5257060811854898929596};
	double in6[12] = {0.2017172696068882942200,0.3911573919467628002167,0.8300316557288169860840,\
0.5878720157779753208160,0.4829179299995303153992,0.2232865034602582454681,\
0.8400885667651891708374,0.1205995907075703144074,0.2855364168062806129456,\
0.8607514644972980022430,0.8494101651012897491455,0.5257060811854898929596};
	double res[6] = {6.1990750515833497047424,1.448623480275273323059,2.5195303875952959060669,\
	2.4904293166473507881165,3.4897020040079951286316,6.1990750515833497047424};
	double out1,out2,out3,out4,out5,out6;
	
	out1=dmagna(in1,1,12);
	out2=dmagna(in2,2,6);
	out3=dmagna(in3,3,4);
	out4=dmagna(in4,4,3);
	out5=dmagna(in5,6,2);
	out6=dmagna(in6,12,1);

	
	assert( fabs(out1-res[0])/fabs(out1)<1e-16);
	assert( fabs(out2-res[1])/fabs(out2)<1e-16);
	assert( fabs(out3-res[2])/fabs(out3)<1e-16);
	assert( fabs(out4-res[3])/fabs(out4)<1e-16);
	assert( fabs(out5-res[4])/fabs(out5)<1e-16);
	assert( fabs(out6-res[5])/fabs(out6)<1e-16);
	
}


static void zmagnaTest(void){
	double inr1[12] = {0.2017172696068882942200,0.3911573919467628002167,0.8300316557288169860840,\
	0.5878720157779753208160,0.4829179299995303153992,0.2232865034602582454681,\
	0.8400885667651891708374,0.1205995907075703144074,0.2855364168062806129456,\
	0.8607514644972980022430,0.8494101651012897491455,0.5257060811854898929596};
	
	double inr2[12] = {0.2017172696068882942200,0.8400885667651891708374,0.3911573919467628002167,\
	0.1205995907075703144074,0.8300316557288169860840,0.2855364168062806129456,\
	0.5878720157779753208160,0.8607514644972980022430,0.4829179299995303153992,\
	0.8494101651012897491455,0.2232865034602582454681,0.5257060811854898929596};
	
	double inr3[12] = {0.2017172696068882942200,0.4829179299995303153992,0.2855364168062806129456,\
	0.3911573919467628002167,0.2232865034602582454681,0.8607514644972980022430,\
	0.8300316557288169860840,0.8400885667651891708374,0.8494101651012897491455,\
	0.5878720157779753208160,0.1205995907075703144074,0.5257060811854898929596};
	
	double inr4[12] = {0.2017172696068882942200,0.5878720157779753208160,0.8400885667651891708374,\
	0.8607514644972980022430,0.3911573919467628002167,0.4829179299995303153992,\
	0.1205995907075703144074,0.8494101651012897491455,0.8300316557288169860840,\
	0.2232865034602582454681,0.2855364168062806129456,0.5257060811854898929596};
	
	double inr5[12] = {0.2017172696068882942200,0.8300316557288169860840,0.4829179299995303153992,\
	0.8400885667651891708374,0.2855364168062806129456,0.8494101651012897491455,\
	0.3911573919467628002167,0.5878720157779753208160,0.2232865034602582454681,\
	0.1205995907075703144074,0.8607514644972980022430,0.5257060811854898929596};
	
	double inr6[12] = {0.2017172696068882942200,0.3911573919467628002167,0.8300316557288169860840,\
	0.5878720157779753208160,0.4829179299995303153992,0.2232865034602582454681,\
	0.8400885667651891708374,0.1205995907075703144074,0.2855364168062806129456,\
	0.8607514644972980022430,0.8494101651012897491455,0.5257060811854898929596};
	
	double in7[12]={0};
	
	double res[6] = {6.1990750515833497047424,1.448623480275273323059,2.5195303875952959060669,\
	2.4904293166473507881165,3.4897020040079951286316,6.1990750515833497047424};
	
	double inR[12] = {0.9931209897622466087341,0.6488562873564660549164,0.9923190940171480178833,\
	 0.0500419777818024158478,\
	0.7485506581142544746399,0.4104058998636901378632,0.6084526330232620239258,\
	 0.8544210889376699924469,\
	0.0642646728083491325378,0.8279082938097417354584,0.9262343775480985641480,\
	 0.5667211269028484821320};
	double inI[12] = {0.5711638936772942543030,0.8160110483877360820770,0.0568927936255931854248,\
	 0.5595936686731874942780,\
	0.1249340316280722618103,0.7279222286306321620941,0.2677766475826501846314,\
	 0.5465334919281303882599,\
	0.9885407658293843269348,0.7395656588487327098846,0.0037173107266426086426,\
	 0.5900572859682142734528};
	double result = 3.8451319979533651327586;
	
	double out1,out2,out3,out4,out5,out6;
	double out;
	doubleComplex* in,*in1,*in2,*in3,*in4,*in5,*in6;
	
	in=DoubleComplexMatrix(inR,inI,12);
	out = zmagna(in, 4,3);
	assert(fabs(out-result)/fabs(out) <1e-16);
	
		
	in1=DoubleComplexMatrix(inr1,in7,12);		
	in2=DoubleComplexMatrix(inr2,in7,12);		
	in3=DoubleComplexMatrix(inr3,in7,12);		
	in4=DoubleComplexMatrix(inr4,in7,12);		
	in5=DoubleComplexMatrix(inr5,in7,12);		
	in6=DoubleComplexMatrix(inr6,in7,12);
	
	out1=zmagna(in1,1,12);
	out2=zmagna(in2,2,6);
	out3=zmagna(in3,3,4);
	out4=zmagna(in4,4,3);
	out5=zmagna(in5,6,2);
	out6=zmagna(in6,12,1);	
	
	assert( fabs(out1-res[0])/fabs(out1)<1e-16);
	assert( fabs(out2-res[1])/fabs(out2)<1e-16);
	assert( fabs(out3-res[2])/fabs(out3)<1e-16);
	assert( fabs(out4-res[3])/fabs(out4)<1e-16);
	assert( fabs(out5-res[4])/fabs(out5)<1e-16);
	assert( fabs(out6-res[5])/fabs(out6)<1e-16);
}


static int magnTest(void){
	printf("\n >>> Double Magnitude Tests <<< \n");
	dmagnsTest();
	dmagnaTest();
	zmagnsTest();
	zmagnaTest();
	return 0;
}

int main (void){
	assert (magnTest()==0);
	return 0;
}
