
/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include <math.h>
#include <assert.h>
#include "matrixMagnitude.h"
#include <stdio.h>

static void smagnsTest(void){
	float in[11]={-5.0f,-4.0f,-3.0f,-2.0f,-1.0f,0.0f,1.0f,2.0f,3.0f,4.0f,5.0f};
	float res[11]={5.0f,4.0f,3.0f,2.0f,1.0f,0.0f,1.0f,2.0f,3.0f,4.0f,5.0f};
	float out;
	int i;
	
	for (i=0;i<11;i++) {
		out=smagns(in[i]);
		if (out==0) assert( fabs(out-res[i])==0);
		else assert( fabs(out-res[i])/fabs(out)==0);
	}
}


static void cmagnsTest(void){
	float inR[8] = {0.3493615407496690750122f,0.9222898678854107856751f,- 0.8906224733218550682068f,- 0.3435337245464324951172f, \
	0.5896177329123020172119f,0.5896177329123020172119f,- 0.5896177329123020172119f,- 0.5896177329123020172119f};
	float inI[8] = { 0.3873778772540390491486f,0.9488184261135756969452f,0.5042212805710732936859f,- 0.3760118731297552585602f, \
	0.6853979662992060184479f,- 0.6853979662992060184479f,0.6853979662992060184479f,- 0.6853979662992060184479f};
	float res[8] = {0.5216465335270885628205f,1.3232063354355325657252f,1.0234488212737711254618f, 0.5093136053899318671512f, \
	0.9041125168759308605715f,0.9041125168759308605715f,0.9041125168759308605715f,0.9041125168759308605715f};
	int i;
	float out;
	floatComplex in;
	
	for (i=0;i<8;i++) {
		in = FloatComplex(inR[i],inI[i]);
		out=cmagns(in);
		assert( fabs(out-res[i])/fabs(out)<1e-6);
	}
}


static void smagnaTest(void){
	float in1[12] = {0.2017172696068882942200f,0.3911573919467628002167f,0.8300316557288169860840f,\
	0.5878720157779753208160f,0.4829179299995303153992f,0.2232865034602582454681f,\
	0.8400885667651891708374f,0.1205995907075703144074f,0.2855364168062806129456f,\
	0.8607514644972980022430f,0.8494101651012897491455f,0.5257060811854898929596f};
	float in2[12] = {0.2017172696068882942200f,0.8400885667651891708374f,0.3911573919467628002167f,\
	0.1205995907075703144074f,0.8300316557288169860840f,0.2855364168062806129456f,\
	0.5878720157779753208160f,0.8607514644972980022430f,0.4829179299995303153992f,\
	0.8494101651012897491455f,0.2232865034602582454681f,0.5257060811854898929596f};
	float in3[12] = {0.2017172696068882942200f,0.4829179299995303153992f,0.2855364168062806129456f,\
	0.3911573919467628002167f,0.2232865034602582454681f,0.8607514644972980022430f,\
	0.8300316557288169860840f,0.8400885667651891708374f,0.8494101651012897491455f,\
	0.5878720157779753208160f,0.1205995907075703144074f,0.5257060811854898929596f};
	float in4[12] = {0.2017172696068882942200f,0.5878720157779753208160f,0.8400885667651891708374f,\
	0.8607514644972980022430f,0.3911573919467628002167f,0.4829179299995303153992f,\
	0.1205995907075703144074f,0.8494101651012897491455f,0.8300316557288169860840f,\
	0.2232865034602582454681f,0.2855364168062806129456f,0.5257060811854898929596f};
	float in5[12] = {0.2017172696068882942200f,0.8300316557288169860840f,0.4829179299995303153992f,\
	0.8400885667651891708374f,0.2855364168062806129456f,0.8494101651012897491455f,\
	0.3911573919467628002167f,0.5878720157779753208160f,0.2232865034602582454681f,\
	0.1205995907075703144074f,0.8607514644972980022430f,0.5257060811854898929596f};
	float in6[12] = {0.2017172696068882942200f,0.3911573919467628002167f,0.8300316557288169860840f,\
0.5878720157779753208160f,0.4829179299995303153992f,0.2232865034602582454681f,\
0.8400885667651891708374f,0.1205995907075703144074f,0.2855364168062806129456f,\
0.8607514644972980022430f,0.8494101651012897491455f,0.5257060811854898929596f};
	float res[6] = {6.1990750515833497047424f,1.448623480275273323059f,2.5195303875952959060669f,\
	2.4904293166473507881165f,3.4897020040079951286316f,6.1990750515833497047424f};
	float out1,out2,out3,out4,out5,out6;
	
	out1=smagna(in1,1,12);
	out2=smagna(in2,2,6);
	out3=smagna(in3,3,4);
	out4=smagna(in4,4,3);
	out5=smagna(in5,6,2);
	out6=smagna(in6,12,1);
	
	assert( fabs(out1-res[0])/fabs(out1)<1e-6);
	assert( fabs(out2-res[1])/fabs(out2)<1e-6);
	assert( fabs(out3-res[2])/fabs(out3)<1e-6);
	assert( fabs(out4-res[3])/fabs(out4)<1e-6);
	assert( fabs(out5-res[4])/fabs(out5)<1e-6);
	assert( fabs(out6-res[5])/fabs(out6)<1e-6);
}


static void cmagnaTest(void){
	float inR[12] = {0.9931209897622466087341f,0.6488562873564660549164f,0.9923190940171480178833f, \
 0.0500419777818024158478f,\
0.7485506581142544746399f,0.4104058998636901378632f,0.6084526330232620239258f,\
 0.8544210889376699924469f,\
0.0642646728083491325378f,0.8279082938097417354584f,0.9262343775480985641480f,\
 0.5667211269028484821320f};
	float inI[12] = {0.5711638936772942543030f,0.8160110483877360820770f,0.0568927936255931854248f, \
 0.5595936686731874942780f,\
0.1249340316280722618103f,0.7279222286306321620941f,0.2677766475826501846314f,\
 0.5465334919281303882599f,\
0.9885407658293843269348f,0.7395656588487327098846f,0.0037173107266426086426f,\
 0.5900572859682142734528f};
	float result = 3.8451319979533651327586f;
	
	float in1[12] = {0.2017172696068882942200f,0.3911573919467628002167f,0.8300316557288169860840f,\
	0.5878720157779753208160f,0.4829179299995303153992f,0.2232865034602582454681f,\
	0.8400885667651891708374f,0.1205995907075703144074f,0.2855364168062806129456f,\
	0.8607514644972980022430f,0.8494101651012897491455f,0.5257060811854898929596f};
	float in2[12] = {0.2017172696068882942200f,0.8400885667651891708374f,0.3911573919467628002167f,\
	0.1205995907075703144074f,0.8300316557288169860840f,0.2855364168062806129456f,\
	0.5878720157779753208160f,0.8607514644972980022430f,0.4829179299995303153992f,\
	0.8494101651012897491455f,0.2232865034602582454681f,0.5257060811854898929596f};
	float in3[12] = {0.2017172696068882942200f,0.4829179299995303153992f,0.2855364168062806129456f,\
	0.3911573919467628002167f,0.2232865034602582454681f,0.8607514644972980022430f,\
	0.8300316557288169860840f,0.8400885667651891708374f,0.8494101651012897491455f,\
	0.5878720157779753208160f,0.1205995907075703144074f,0.5257060811854898929596f};
	float in4[12] = {0.2017172696068882942200f,0.5878720157779753208160f,0.8400885667651891708374f,\
	0.8607514644972980022430f,0.3911573919467628002167f,0.4829179299995303153992f,\
	0.1205995907075703144074f,0.8494101651012897491455f,0.8300316557288169860840f,\
	0.2232865034602582454681f,0.2855364168062806129456f,0.5257060811854898929596f};
	float in5[12] = {0.2017172696068882942200f,0.8300316557288169860840f,0.4829179299995303153992f,\
	0.8400885667651891708374f,0.2855364168062806129456f,0.8494101651012897491455f,\
	0.3911573919467628002167f,0.5878720157779753208160f,0.2232865034602582454681f,\
	0.1205995907075703144074f,0.8607514644972980022430f,0.5257060811854898929596f};
	float in6[12] = {0.2017172696068882942200f,0.3911573919467628002167f,0.8300316557288169860840f,\
	0.5878720157779753208160f,0.4829179299995303153992f,0.2232865034602582454681f,\
	0.8400885667651891708374f,0.1205995907075703144074f,0.2855364168062806129456f,\
	0.8607514644972980022430f,0.8494101651012897491455f,0.5257060811854898929596f};
	float in7[12] = {0};
	float res[6] = {6.1990750515833497047424f,1.448623480275273323059f,2.5195303875952959060669f,\
	2.4904293166473507881165f,3.4897020040079951286316f,6.1990750515833497047424f};
	float out;
	floatComplex *in;
	floatComplex *In1,*In2,*In3,*In4,*In5,*In6;
	float out1,out2,out3,out4,out5,out6;

	in=FloatComplexMatrix(inR,inI,12);	
	out = cmagna(in, 4,3);
	assert(fabs(out-result)/fabs(out) <1e-6);
	
	
	In1=FloatComplexMatrix(in1,in7,12);	
	In2=FloatComplexMatrix(in2,in7,12);	
	In3=FloatComplexMatrix(in3,in7,12);	
	In4=FloatComplexMatrix(in4,in7,12);	
	In5=FloatComplexMatrix(in5,in7,12);	
	In6=FloatComplexMatrix(in6,in7,12);	
	out1=cmagna(In1,1,12);
	out2=cmagna(In2,2,6);
	out3=cmagna(In3,3,4);
	out4=cmagna(In4,4,3);
	out5=cmagna(In5,6,2);
	out6=cmagna(In6,12,1);		
	assert( fabs(out1-res[0])/fabs(out1)<1e-6);
	assert( fabs(out2-res[1])/fabs(out2)<1e-6);
	assert( fabs(out3-res[2])/fabs(out3)<1e-6);
	assert( fabs(out4-res[3])/fabs(out4)<1e-6);
	assert( fabs(out5-res[4])/fabs(out5)<1e-6);
	assert( fabs(out6-res[5])/fabs(out6)<1e-6);
}



static int magnTest(void){
	printf("\n >>> Float Magnitude Tests <<< \n");
	smagnsTest();
	smagnaTest();
	cmagnsTest();
	cmagnaTest();
	return 0;
}

int main (void){
	assert (magnTest()==0);
	return 0;
}
