/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008-2008 - INRIA - Allan SIMON
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include "matrixTranspose.h"
#include <assert.h>
#include <stdio.h>

#define LINE   15
#define COLUMN 10



static void stranspaTest (void ) {
	
	int i = 0 ;

	
	float in[] ={0.34382718056440353f,0.11506372271105647f,0.50752213317900896f,0.15747882844880223f,
 0.97023218311369419f,0.40251684701070189f,0.22695036139339209f,0.91680057207122445f,
 0.62407150492072105f,0.61546878470107913f,
0.1970167332328856f,0.53554199635982513f,0.40760429529473186f,0.53506936598569155f,
 0.85157642932608724f,0.09831319935619831f,0.68369307881221175f,0.21228999551385641f,
 0.63760355720296502f,0.83135433867573738f,
0.21228986512869596f,0.43117330456152558f,0.84080461412668228f,0.21290646074339747f,
 0.33933044690638781f,0.26086253346875310f,0.93650726415216923f,0.26978330826386809f,
 0.42704886104911566f,0.77340125897899270f,
0.31403985014185309f,0.61453847866505384f,0.5017265700735152f,0.55914506316184998f,
 0.87725317804142833f,0.36363423336297274f,0.50530174048617482f,0.31998893804848194f,
 0.10716815060004592f,0.4244190966710448f,
0.78216253779828548f,0.92589621385559440f,0.91287807654589415f,0.43049659812822938f,
 0.11314024776220322f,0.17466178117319942f,0.25248145777732134f,0.02321802498772740f,
 0.23822965659201145f,0.72621259605512023f,
0.05409323470667005f,0.09938172809779644f,0.44357294728979468f,0.02280548494309187f,
 0.5264128320850432f,0.92341394722461700f,0.68188397912308574f,0.72654472757130861f,
 0.94629473658278584f,0.70999773032963276f,
0.91902069095522165f,0.42805786477401853f,0.59837839566171169f,0.57614597817882895f,
 0.52973940502852201f,0.76051409030333161f,0.28363681584596634f,0.15340585587546229f,
 0.45766852516680956f,0.47457459988072515f,
0.46035157097503543f,0.94318309519439936f,0.7741842647083104f,0.71491303853690624f,
 0.92917560925707221f,0.56402041297405958f,0.14094856614246964f,0.23552638292312622f,
 0.89644787041470408f,0.9438692079856992f,
0.29926850274205208f,0.03273952705785632f,0.79220082703977823f,0.93216359661892056f,
 0.97654302977025509f,0.37970651825889945f,0.67591095995157957f,0.08797382796183228f,
 0.44384705275297165f,0.14596485672518611f,
0.00291663268581033f,0.92132670804858208f,0.55046048713847995f,0.12326993141323328f,
 0.62254639761522412f,0.87762261740863323f,0.45126775791868567f,0.71059537213295698f,
 0.80895681912079453f,0.07141010463237762f,
0.89934705849736929f,0.94490244099870324f,0.40850437059998512f,0.28655522270128131f,
 0.98225832823663950f,0.82174257980659604f,0.75430292449891567f,0.68887275597080588f,
 0.68317985069006681f,0.67337385797873139f,
0.83879271661862731f,0.900706990621984f,0.72174380579963326f,0.01247995719313622f,
 0.75429888023063540f,0.67870581243187189f,0.13702143030241132f,0.65953194908797741f,
 0.03401931514963508f,0.65369247179478407f,
0.43437494523823261f,0.80943161016330123f,0.47685358580201864f,0.57694048294797540f,
 0.54547880962491035f,0.08220098121091723f,0.66082405392080545f,0.18151161121204495f,
 0.23805456422269344f,0.19968961318954825f,
0.77678761305287480f,0.02519542910158634f,0.63930579042062163f,0.39386960770934820f,
 0.72860160330310464f,0.25527314469218254f,0.38900542212650180f,0.3904965976253152f,
 0.94920115964487195f,0.60141251794993877f,
0.13953176606446505f,0.00196450622752309f,0.99638652987778187f,0.68885837262496352f,
 0.02525969501584768f,0.74444567272439599f,0.70018205419182777f,0.15869047446176410f,
 0.21827886346727610f,0.18993748771026731f};
	
	
	float out[(COLUMN+1 )*(LINE+1)] ;
	
	float Result[(COLUMN+1)*(LINE+1)] = 
		{0.34382718056440353f,0.1970167332328856f,0.21228986512869596f,0.31403985014185309f,
 0.78216253779828548f,0.05409323470667005f,0.91902069095522165f,0.46035157097503543f,
 0.29926850274205208f,0.00291663268581033f,0.89934705849736929f,0.83879271661862731f,
 0.43437494523823261f,0.77678761305287480f,0.13953176606446505f,
0.11506372271105647f,0.53554199635982513f,0.43117330456152558f,0.61453847866505384f,
 0.92589621385559440f,0.09938172809779644f,0.42805786477401853f,0.94318309519439936f,
 0.03273952705785632f,0.92132670804858208f,0.94490244099870324f,0.900706990621984f,
 0.80943161016330123f,0.02519542910158634f,0.00196450622752309f,
0.50752213317900896f,0.40760429529473186f,0.84080461412668228f,0.5017265700735152f,
 0.91287807654589415f,0.44357294728979468f,0.59837839566171169f,0.7741842647083104f,
 0.79220082703977823f,0.55046048713847995f,0.40850437059998512f,0.72174380579963326f,
 0.47685358580201864f,0.63930579042062163f,0.99638652987778187f,
0.15747882844880223f,0.53506936598569155f,0.21290646074339747f,0.55914506316184998f,
 0.43049659812822938f,0.02280548494309187f,0.57614597817882895f,0.71491303853690624f,
 0.93216359661892056f,0.12326993141323328f,0.28655522270128131f,0.01247995719313622f,
 0.57694048294797540f,0.39386960770934820f,0.68885837262496352f,
0.97023218311369419f,0.85157642932608724f,0.33933044690638781f,0.87725317804142833f,
 0.11314024776220322f,0.5264128320850432f,0.52973940502852201f,0.92917560925707221f,
 0.97654302977025509f,0.62254639761522412f,0.98225832823663950f,0.75429888023063540f,
 0.54547880962491035f,0.72860160330310464f,0.02525969501584768f,
0.40251684701070189f,0.09831319935619831f,0.26086253346875310f,0.36363423336297274f,
 0.17466178117319942f,0.92341394722461700f,0.76051409030333161f,0.56402041297405958f,
 0.37970651825889945f,0.87762261740863323f,0.82174257980659604f,0.67870581243187189f,
 0.08220098121091723f,0.25527314469218254f,0.74444567272439599f,
0.22695036139339209f,0.68369307881221175f,0.93650726415216923f,0.50530174048617482f,
 0.25248145777732134f,0.68188397912308574f,0.28363681584596634f,0.14094856614246964f,
 0.67591095995157957f,0.45126775791868567f,0.75430292449891567f,0.13702143030241132f,
 0.66082405392080545f,0.38900542212650180f,0.70018205419182777f,
0.91680057207122445f,0.21228999551385641f,0.26978330826386809f,0.31998893804848194f,
 0.02321802498772740f,0.72654472757130861f,0.15340585587546229f,0.23552638292312622f,
 0.08797382796183228f,0.71059537213295698f,0.68887275597080588f,0.65953194908797741f,
 0.18151161121204495f,0.3904965976253152f,0.15869047446176410f,
0.62407150492072105f,0.63760355720296502f,0.42704886104911566f,0.10716815060004592f,
 0.23822965659201145f,0.94629473658278584f,0.45766852516680956f,0.89644787041470408f,
 0.44384705275297165f,0.80895681912079453f,0.68317985069006681f,0.03401931514963508f,
 0.23805456422269344f,0.94920115964487195f,0.21827886346727610f,
0.61546878470107913f,0.83135433867573738f,0.77340125897899270f,0.4244190966710448f,
 0.72621259605512023f,0.70999773032963276f,0.47457459988072515f,0.9438692079856992f,
 0.14596485672518611f,0.07141010463237762f,0.67337385797873139f,0.65369247179478407f,
 0.19968961318954825f,0.60141251794993877f,0.18993748771026731f};

	stransposea  ( in ,  COLUMN , LINE , out );
	
	

	for ( i = 0 ; i < LINE*COLUMN  ; i++ )
	{
			assert ( fabs ( out[i] - Result[i] ) / fabs( out[i]) < 1e-6 ) ;
	}
	
	
	
}


static void dtranspaTest (void ) {
	
	int i = 0 ;

	
	double in[] ={0.34382718056440353,0.11506372271105647,0.50752213317900896,0.15747882844880223,
 0.97023218311369419,0.40251684701070189,0.22695036139339209,0.91680057207122445,
 0.62407150492072105,0.61546878470107913,
0.1970167332328856,0.53554199635982513,0.40760429529473186,0.53506936598569155,
 0.85157642932608724,0.09831319935619831,0.68369307881221175,0.21228999551385641,
 0.63760355720296502,0.83135433867573738,
0.21228986512869596,0.43117330456152558,0.84080461412668228,0.21290646074339747,
 0.33933044690638781,0.26086253346875310,0.93650726415216923,0.26978330826386809,
 0.42704886104911566,0.77340125897899270,
0.31403985014185309,0.61453847866505384,0.5017265700735152,0.55914506316184998,
 0.87725317804142833,0.36363423336297274,0.50530174048617482,0.31998893804848194,
 0.10716815060004592,0.4244190966710448,
0.78216253779828548,0.92589621385559440,0.91287807654589415,0.43049659812822938,
 0.11314024776220322,0.17466178117319942,0.25248145777732134,0.02321802498772740,
 0.23822965659201145,0.72621259605512023,
0.05409323470667005,0.09938172809779644,0.44357294728979468,0.02280548494309187,
 0.5264128320850432,0.92341394722461700,0.68188397912308574,0.72654472757130861,
 0.94629473658278584,0.70999773032963276,
0.91902069095522165,0.42805786477401853,0.59837839566171169,0.57614597817882895,
 0.52973940502852201,0.76051409030333161,0.28363681584596634,0.15340585587546229,
 0.45766852516680956,0.47457459988072515,
0.46035157097503543,0.94318309519439936,0.7741842647083104,0.71491303853690624,
 0.92917560925707221,0.56402041297405958,0.14094856614246964,0.23552638292312622,
 0.89644787041470408,0.9438692079856992,
0.29926850274205208,0.03273952705785632,0.79220082703977823,0.93216359661892056,
 0.97654302977025509,0.37970651825889945,0.67591095995157957,0.08797382796183228,
 0.44384705275297165,0.14596485672518611,
0.00291663268581033,0.92132670804858208,0.55046048713847995,0.12326993141323328,
 0.62254639761522412,0.87762261740863323,0.45126775791868567,0.71059537213295698,
 0.80895681912079453,0.07141010463237762,
0.89934705849736929,0.94490244099870324,0.40850437059998512,0.28655522270128131,
 0.98225832823663950,0.82174257980659604,0.75430292449891567,0.68887275597080588,
 0.68317985069006681,0.67337385797873139,
0.83879271661862731,0.900706990621984,0.72174380579963326,0.01247995719313622,
 0.75429888023063540,0.67870581243187189,0.13702143030241132,0.65953194908797741,
 0.03401931514963508,0.65369247179478407,
0.43437494523823261,0.80943161016330123,0.47685358580201864,0.57694048294797540,
 0.54547880962491035,0.08220098121091723,0.66082405392080545,0.18151161121204495,
 0.23805456422269344,0.19968961318954825,
0.77678761305287480,0.02519542910158634,0.63930579042062163,0.39386960770934820,
 0.72860160330310464,0.25527314469218254,0.38900542212650180,0.3904965976253152,
 0.94920115964487195,0.60141251794993877,
0.13953176606446505,0.00196450622752309,0.99638652987778187,0.68885837262496352,
 0.02525969501584768,0.74444567272439599,0.70018205419182777,0.15869047446176410,
 0.21827886346727610,0.18993748771026731};
	
	
	double out[(COLUMN+1 )*(LINE+1)] ;
	
	double Result[(COLUMN+1)*(LINE+1)] = 
		{0.34382718056440353,0.1970167332328856,0.21228986512869596,0.31403985014185309,
 0.78216253779828548,0.05409323470667005,0.91902069095522165,0.46035157097503543,
 0.29926850274205208,0.00291663268581033,0.89934705849736929,0.83879271661862731,
 0.43437494523823261,0.77678761305287480,0.13953176606446505,
0.11506372271105647,0.53554199635982513,0.43117330456152558,0.61453847866505384,
 0.92589621385559440,0.09938172809779644,0.42805786477401853,0.94318309519439936,
 0.03273952705785632,0.92132670804858208,0.94490244099870324,0.900706990621984,
 0.80943161016330123,0.02519542910158634,0.00196450622752309,
0.50752213317900896,0.40760429529473186,0.84080461412668228,0.5017265700735152,
 0.91287807654589415,0.44357294728979468,0.59837839566171169,0.7741842647083104,
 0.79220082703977823,0.55046048713847995,0.40850437059998512,0.72174380579963326,
 0.47685358580201864,0.63930579042062163,0.99638652987778187,
0.15747882844880223,0.53506936598569155,0.21290646074339747,0.55914506316184998,
 0.43049659812822938,0.02280548494309187,0.57614597817882895,0.71491303853690624,
 0.93216359661892056,0.12326993141323328,0.28655522270128131,0.01247995719313622,
 0.57694048294797540,0.39386960770934820,0.68885837262496352,
0.97023218311369419,0.85157642932608724,0.33933044690638781,0.87725317804142833,
 0.11314024776220322,0.5264128320850432,0.52973940502852201,0.92917560925707221,
 0.97654302977025509,0.62254639761522412,0.98225832823663950,0.75429888023063540,
 0.54547880962491035,0.72860160330310464,0.02525969501584768,
0.40251684701070189,0.09831319935619831,0.26086253346875310,0.36363423336297274,
 0.17466178117319942,0.92341394722461700,0.76051409030333161,0.56402041297405958,
 0.37970651825889945,0.87762261740863323,0.82174257980659604,0.67870581243187189,
 0.08220098121091723,0.25527314469218254,0.74444567272439599,
0.22695036139339209,0.68369307881221175,0.93650726415216923,0.50530174048617482,
 0.25248145777732134,0.68188397912308574,0.28363681584596634,0.14094856614246964,
 0.67591095995157957,0.45126775791868567,0.75430292449891567,0.13702143030241132,
 0.66082405392080545,0.38900542212650180,0.70018205419182777,
0.91680057207122445,0.21228999551385641,0.26978330826386809,0.31998893804848194,
 0.02321802498772740,0.72654472757130861,0.15340585587546229,0.23552638292312622,
 0.08797382796183228,0.71059537213295698,0.68887275597080588,0.65953194908797741,
 0.18151161121204495,0.3904965976253152,0.15869047446176410,
0.62407150492072105,0.63760355720296502,0.42704886104911566,0.10716815060004592,
 0.23822965659201145,0.94629473658278584,0.45766852516680956,0.89644787041470408,
 0.44384705275297165,0.80895681912079453,0.68317985069006681,0.03401931514963508,
 0.23805456422269344,0.94920115964487195,0.21827886346727610,
0.61546878470107913,0.83135433867573738,0.77340125897899270,0.4244190966710448,
 0.72621259605512023,0.70999773032963276,0.47457459988072515,0.9438692079856992,
 0.14596485672518611,0.07141010463237762,0.67337385797873139,0.65369247179478407,
 0.19968961318954825,0.60141251794993877,0.18993748771026731};

	dtransposea  ( in ,  COLUMN , LINE , out );
	

	for ( i = 0 ; i < LINE*COLUMN  ; i++ )
	{
			assert ( fabs ( out[i] - Result[i] ) / fabs( out[i]) < 1e-16 ) ;
	}
	
	
	
}



static void ctranspaTest (void ) {
	
	int i = 0 ;

	
	float Pin[] ={0.34382718056440353f,0.11506372271105647f,0.50752213317900896f,0.15747882844880223f,
 0.97023218311369419f,0.40251684701070189f,0.22695036139339209f,0.91680057207122445f,
 0.62407150492072105f,0.61546878470107913f,
0.1970167332328856f,0.53554199635982513f,0.40760429529473186f,0.53506936598569155f,
 0.85157642932608724f,0.09831319935619831f,0.68369307881221175f,0.21228999551385641f,
 0.63760355720296502f,0.83135433867573738f,
0.21228986512869596f,0.43117330456152558f,0.84080461412668228f,0.21290646074339747f,
 0.33933044690638781f,0.26086253346875310f,0.93650726415216923f,0.26978330826386809f,
 0.42704886104911566f,0.77340125897899270f,
0.31403985014185309f,0.61453847866505384f,0.5017265700735152f,0.55914506316184998f,
 0.87725317804142833f,0.36363423336297274f,0.50530174048617482f,0.31998893804848194f,
 0.10716815060004592f,0.4244190966710448f,
0.78216253779828548f,0.92589621385559440f,0.91287807654589415f,0.43049659812822938f,
 0.11314024776220322f,0.17466178117319942f,0.25248145777732134f,0.02321802498772740f,
 0.23822965659201145f,0.72621259605512023f,
0.05409323470667005f,0.09938172809779644f,0.44357294728979468f,0.02280548494309187f,
 0.5264128320850432f,0.92341394722461700f,0.68188397912308574f,0.72654472757130861f,
 0.94629473658278584f,0.70999773032963276f,
0.91902069095522165f,0.42805786477401853f,0.59837839566171169f,0.57614597817882895f,
 0.52973940502852201f,0.76051409030333161f,0.28363681584596634f,0.15340585587546229f,
 0.45766852516680956f,0.47457459988072515f,
0.46035157097503543f,0.94318309519439936f,0.7741842647083104f,0.71491303853690624f,
 0.92917560925707221f,0.56402041297405958f,0.14094856614246964f,0.23552638292312622f,
 0.89644787041470408f,0.9438692079856992f,
0.29926850274205208f,0.03273952705785632f,0.79220082703977823f,0.93216359661892056f,
 0.97654302977025509f,0.37970651825889945f,0.67591095995157957f,0.08797382796183228f,
 0.44384705275297165f,0.14596485672518611f,
0.00291663268581033f,0.92132670804858208f,0.55046048713847995f,0.12326993141323328f,
 0.62254639761522412f,0.87762261740863323f,0.45126775791868567f,0.71059537213295698f,
 0.80895681912079453f,0.07141010463237762f,
0.89934705849736929f,0.94490244099870324f,0.40850437059998512f,0.28655522270128131f,
 0.98225832823663950f,0.82174257980659604f,0.75430292449891567f,0.68887275597080588f,
 0.68317985069006681f,0.67337385797873139f,
0.83879271661862731f,0.900706990621984f,0.72174380579963326f,0.01247995719313622f,
 0.75429888023063540f,0.67870581243187189f,0.13702143030241132f,0.65953194908797741f,
 0.03401931514963508f,0.65369247179478407f,
0.43437494523823261f,0.80943161016330123f,0.47685358580201864f,0.57694048294797540f,
 0.54547880962491035f,0.08220098121091723f,0.66082405392080545f,0.18151161121204495f,
 0.23805456422269344f,0.19968961318954825f,
0.77678761305287480f,0.02519542910158634f,0.63930579042062163f,0.39386960770934820f,
 0.72860160330310464f,0.25527314469218254f,0.38900542212650180f,0.3904965976253152f,
 0.94920115964487195f,0.60141251794993877f,
0.13953176606446505f,0.00196450622752309f,0.99638652987778187f,0.68885837262496352f,
 0.02525969501584768f,0.74444567272439599f,0.70018205419182777f,0.15869047446176410f,
 0.21827886346727610f,0.18993748771026731f};
	
	
	floatComplex out[(COLUMN+1 )*(LINE+1)] ;
        floatComplex in[(COLUMN+1 )*(LINE+1)] ;
        floatComplex Result[(COLUMN+1 )*(LINE+1)] ;
	
	float PResult[(COLUMN+1)*(LINE+1)] = 
		{0.34382718056440353f,0.1970167332328856f,0.21228986512869596f,0.31403985014185309f,
 0.78216253779828548f,0.05409323470667005f,0.91902069095522165f,0.46035157097503543f,
 0.29926850274205208f,0.00291663268581033f,0.89934705849736929f,0.83879271661862731f,
 0.43437494523823261f,0.77678761305287480f,0.13953176606446505f,
0.11506372271105647f,0.53554199635982513f,0.43117330456152558f,0.61453847866505384f,
 0.92589621385559440f,0.09938172809779644f,0.42805786477401853f,0.94318309519439936f,
 0.03273952705785632f,0.92132670804858208f,0.94490244099870324f,0.900706990621984f,
 0.80943161016330123f,0.02519542910158634f,0.00196450622752309f,
0.50752213317900896f,0.40760429529473186f,0.84080461412668228f,0.5017265700735152f,
 0.91287807654589415f,0.44357294728979468f,0.59837839566171169f,0.7741842647083104f,
 0.79220082703977823f,0.55046048713847995f,0.40850437059998512f,0.72174380579963326f,
 0.47685358580201864f,0.63930579042062163f,0.99638652987778187f,
0.15747882844880223f,0.53506936598569155f,0.21290646074339747f,0.55914506316184998f,
 0.43049659812822938f,0.02280548494309187f,0.57614597817882895f,0.71491303853690624f,
 0.93216359661892056f,0.12326993141323328f,0.28655522270128131f,0.01247995719313622f,
 0.57694048294797540f,0.39386960770934820f,0.68885837262496352f,
0.97023218311369419f,0.85157642932608724f,0.33933044690638781f,0.87725317804142833f,
 0.11314024776220322f,0.5264128320850432f,0.52973940502852201f,0.92917560925707221f,
 0.97654302977025509f,0.62254639761522412f,0.98225832823663950f,0.75429888023063540f,
 0.54547880962491035f,0.72860160330310464f,0.02525969501584768f,
0.40251684701070189f,0.09831319935619831f,0.26086253346875310f,0.36363423336297274f,
 0.17466178117319942f,0.92341394722461700f,0.76051409030333161f,0.56402041297405958f,
 0.37970651825889945f,0.87762261740863323f,0.82174257980659604f,0.67870581243187189f,
 0.08220098121091723f,0.25527314469218254f,0.74444567272439599f,
0.22695036139339209f,0.68369307881221175f,0.93650726415216923f,0.50530174048617482f,
 0.25248145777732134f,0.68188397912308574f,0.28363681584596634f,0.14094856614246964f,
 0.67591095995157957f,0.45126775791868567f,0.75430292449891567f,0.13702143030241132f,
 0.66082405392080545f,0.38900542212650180f,0.70018205419182777f,
0.91680057207122445f,0.21228999551385641f,0.26978330826386809f,0.31998893804848194f,
 0.02321802498772740f,0.72654472757130861f,0.15340585587546229f,0.23552638292312622f,
 0.08797382796183228f,0.71059537213295698f,0.68887275597080588f,0.65953194908797741f,
 0.18151161121204495f,0.3904965976253152f,0.15869047446176410f,
0.62407150492072105f,0.63760355720296502f,0.42704886104911566f,0.10716815060004592f,
 0.23822965659201145f,0.94629473658278584f,0.45766852516680956f,0.89644787041470408f,
 0.44384705275297165f,0.80895681912079453f,0.68317985069006681f,0.03401931514963508f,
 0.23805456422269344f,0.94920115964487195f,0.21827886346727610f,
0.61546878470107913f,0.83135433867573738f,0.77340125897899270f,0.4244190966710448f,
 0.72621259605512023f,0.70999773032963276f,0.47457459988072515f,0.9438692079856992f,
 0.14596485672518611f,0.07141010463237762f,0.67337385797873139f,0.65369247179478407f,
 0.19968961318954825f,0.60141251794993877f,0.18993748771026731f};


	
	

	for ( i = 0 ; i < LINE*COLUMN  ; i++ )
	{
	  in[i] = FloatComplex ( Pin[i] , Pin[i] ) ;
         Result[i] = 	 FloatComplex ( PResult[i] , PResult[i] ) ;	
	}
	

	ctransposea  ( in ,  COLUMN , LINE , out );
	
	

	for ( i = 0 ; i < LINE*COLUMN  ; i++ )
	{
         assert ( fabs(  creals(out[i]) -  creals (Result[i]) ) / fabs (creals (out[i]))  < 1e-07 );
	  assert ( fabs(  cimags(out[i]) -  cimags (Result[i]) ) / fabs (cimags (out[i]))  < 1e-07 ) ;

	}
	
	
	
}






static void ztranspaTest (void ) {
	
	int i = 0 ;

	
	double Pin[] ={0.34382718056440353f,0.11506372271105647f,0.50752213317900896f,0.15747882844880223f,
 0.97023218311369419f,0.40251684701070189f,0.22695036139339209f,0.91680057207122445f,
 0.62407150492072105f,0.61546878470107913f,
0.1970167332328856f,0.53554199635982513f,0.40760429529473186f,0.53506936598569155f,
 0.85157642932608724f,0.09831319935619831f,0.68369307881221175f,0.21228999551385641f,
 0.63760355720296502f,0.83135433867573738f,
0.21228986512869596f,0.43117330456152558f,0.84080461412668228f,0.21290646074339747f,
 0.33933044690638781f,0.26086253346875310f,0.93650726415216923f,0.26978330826386809f,
 0.42704886104911566f,0.77340125897899270f,
0.31403985014185309f,0.61453847866505384f,0.5017265700735152f,0.55914506316184998f,
 0.87725317804142833f,0.36363423336297274f,0.50530174048617482f,0.31998893804848194f,
 0.10716815060004592f,0.4244190966710448f,
0.78216253779828548f,0.92589621385559440f,0.91287807654589415f,0.43049659812822938f,
 0.11314024776220322f,0.17466178117319942f,0.25248145777732134f,0.02321802498772740f,
 0.23822965659201145f,0.72621259605512023f,
0.05409323470667005f,0.09938172809779644f,0.44357294728979468f,0.02280548494309187f,
 0.5264128320850432f,0.92341394722461700f,0.68188397912308574f,0.72654472757130861f,
 0.94629473658278584f,0.70999773032963276f,
0.91902069095522165f,0.42805786477401853f,0.59837839566171169f,0.57614597817882895f,
 0.52973940502852201f,0.76051409030333161f,0.28363681584596634f,0.15340585587546229f,
 0.45766852516680956f,0.47457459988072515f,
0.46035157097503543f,0.94318309519439936f,0.7741842647083104f,0.71491303853690624f,
 0.92917560925707221f,0.56402041297405958f,0.14094856614246964f,0.23552638292312622f,
 0.89644787041470408f,0.9438692079856992f,
0.29926850274205208f,0.03273952705785632f,0.79220082703977823f,0.93216359661892056f,
 0.97654302977025509f,0.37970651825889945f,0.67591095995157957f,0.08797382796183228f,
 0.44384705275297165f,0.14596485672518611f,
0.00291663268581033f,0.92132670804858208f,0.55046048713847995f,0.12326993141323328f,
 0.62254639761522412f,0.87762261740863323f,0.45126775791868567f,0.71059537213295698f,
 0.80895681912079453f,0.07141010463237762f,
0.89934705849736929f,0.94490244099870324f,0.40850437059998512f,0.28655522270128131f,
 0.98225832823663950f,0.82174257980659604f,0.75430292449891567f,0.68887275597080588f,
 0.68317985069006681f,0.67337385797873139f,
0.83879271661862731f,0.900706990621984f,0.72174380579963326f,0.01247995719313622f,
 0.75429888023063540f,0.67870581243187189f,0.13702143030241132f,0.65953194908797741f,
 0.03401931514963508f,0.65369247179478407f,
0.43437494523823261f,0.80943161016330123f,0.47685358580201864f,0.57694048294797540f,
 0.54547880962491035f,0.08220098121091723f,0.66082405392080545f,0.18151161121204495f,
 0.23805456422269344f,0.19968961318954825f,
0.77678761305287480f,0.02519542910158634f,0.63930579042062163f,0.39386960770934820f,
 0.72860160330310464f,0.25527314469218254f,0.38900542212650180f,0.3904965976253152f,
 0.94920115964487195f,0.60141251794993877f,
0.13953176606446505f,0.00196450622752309f,0.99638652987778187f,0.68885837262496352f,
 0.02525969501584768f,0.74444567272439599f,0.70018205419182777f,0.15869047446176410f,
 0.21827886346727610f,0.18993748771026731f};
	
	
	doubleComplex out[(COLUMN+1 )*(LINE+1)] ;
        doubleComplex in[(COLUMN+1 )*(LINE+1)] ;
        doubleComplex Result[(COLUMN+1 )*(LINE+1)] ;
	
	double PResult[(COLUMN+1)*(LINE+1)] = 
		{0.34382718056440353f,0.1970167332328856f,0.21228986512869596f,0.31403985014185309f,
 0.78216253779828548f,0.05409323470667005f,0.91902069095522165f,0.46035157097503543f,
 0.29926850274205208f,0.00291663268581033f,0.89934705849736929f,0.83879271661862731f,
 0.43437494523823261f,0.77678761305287480f,0.13953176606446505f,
0.11506372271105647f,0.53554199635982513f,0.43117330456152558f,0.61453847866505384f,
 0.92589621385559440f,0.09938172809779644f,0.42805786477401853f,0.94318309519439936f,
 0.03273952705785632f,0.92132670804858208f,0.94490244099870324f,0.900706990621984f,
 0.80943161016330123f,0.02519542910158634f,0.00196450622752309f,
0.50752213317900896f,0.40760429529473186f,0.84080461412668228f,0.5017265700735152f,
 0.91287807654589415f,0.44357294728979468f,0.59837839566171169f,0.7741842647083104f,
 0.79220082703977823f,0.55046048713847995f,0.40850437059998512f,0.72174380579963326f,
 0.47685358580201864f,0.63930579042062163f,0.99638652987778187f,
0.15747882844880223f,0.53506936598569155f,0.21290646074339747f,0.55914506316184998f,
 0.43049659812822938f,0.02280548494309187f,0.57614597817882895f,0.71491303853690624f,
 0.93216359661892056f,0.12326993141323328f,0.28655522270128131f,0.01247995719313622f,
 0.57694048294797540f,0.39386960770934820f,0.68885837262496352f,
0.97023218311369419f,0.85157642932608724f,0.33933044690638781f,0.87725317804142833f,
 0.11314024776220322f,0.5264128320850432f,0.52973940502852201f,0.92917560925707221f,
 0.97654302977025509f,0.62254639761522412f,0.98225832823663950f,0.75429888023063540f,
 0.54547880962491035f,0.72860160330310464f,0.02525969501584768f,
0.40251684701070189f,0.09831319935619831f,0.26086253346875310f,0.36363423336297274f,
 0.17466178117319942f,0.92341394722461700f,0.76051409030333161f,0.56402041297405958f,
 0.37970651825889945f,0.87762261740863323f,0.82174257980659604f,0.67870581243187189f,
 0.08220098121091723f,0.25527314469218254f,0.74444567272439599f,
0.22695036139339209f,0.68369307881221175f,0.93650726415216923f,0.50530174048617482f,
 0.25248145777732134f,0.68188397912308574f,0.28363681584596634f,0.14094856614246964f,
 0.67591095995157957f,0.45126775791868567f,0.75430292449891567f,0.13702143030241132f,
 0.66082405392080545f,0.38900542212650180f,0.70018205419182777f,
0.91680057207122445f,0.21228999551385641f,0.26978330826386809f,0.31998893804848194f,
 0.02321802498772740f,0.72654472757130861f,0.15340585587546229f,0.23552638292312622f,
 0.08797382796183228f,0.71059537213295698f,0.68887275597080588f,0.65953194908797741f,
 0.18151161121204495f,0.3904965976253152f,0.15869047446176410f,
0.62407150492072105f,0.63760355720296502f,0.42704886104911566f,0.10716815060004592f,
 0.23822965659201145f,0.94629473658278584f,0.45766852516680956f,0.89644787041470408f,
 0.44384705275297165f,0.80895681912079453f,0.68317985069006681f,0.03401931514963508f,
 0.23805456422269344f,0.94920115964487195f,0.21827886346727610f,
0.61546878470107913f,0.83135433867573738f,0.77340125897899270f,0.4244190966710448f,
 0.72621259605512023f,0.70999773032963276f,0.47457459988072515f,0.9438692079856992f,
 0.14596485672518611f,0.07141010463237762f,0.67337385797873139f,0.65369247179478407f,
 0.19968961318954825f,0.60141251794993877f,0.18993748771026731f};


	
	

	for ( i = 0 ; i < LINE*COLUMN  ; i++ )
	{
	  in[i] = DoubleComplex ( Pin[i] , Pin[i] ) ;
         Result[i] = DoubleComplex ( PResult[i] , PResult[i] ) ;	
	}
	
	
	

	ztransposea  ( in , COLUMN  ,  LINE, out );
	
	

	for ( i = 0 ; i < LINE*COLUMN  ; i++ )
	{
         assert ( fabs(  zreals(out[i]) -  zreals (Result[i]) ) / fabs (zreals (out[i]))  < 1e-17 );
	  assert ( fabs(  zimags(out[i]) -  zimags (Result[i]) ) / fabs (zimags (out[i]))  < 1e-17 ) ;

	}
	
	
	
}




static int testTranspa   (void) {

  printf("\n>>>> Float real  Tests\n");
  stranspaTest();
printf("\t>>>> Double real Tests\n");
  dtranspaTest();
printf("\t>>>> Double  complex Tests\n");
ctranspaTest();
printf("\t>>>> Float complex Tests\n");
ztranspaTest();
  return 0;
}


int main(void) {
  assert(testTranspa() == 0);
  return 0;
}


