/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2006-2008 - INRIA - Bruno JOFRET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <math.h>
#include "multiplication.h"


#define FP1 {0.3874644362367689609528f,0.3987790448591113090515f,0.9963990836404263973236f,\
0.9320784267038106918335f,0.0681476672179996967316f,0.7187465364113450050354f,\
0.6592897172085940837860f,0.437819693237543106079f,0.9570061699487268924713f,\
0.3977778619155287742615f,0.5414962074719369411469f,0.1475485283881425857544f,\
0.9197258842177689075470f,0.4185347454622387886047f,0.9044831502251327037811f,\
0.3202747702598571777344f,0.5748232551850378513336f,0.7572625903412699699402f,\
0.3254728927277028560638f,0.5012555103749036788940f,0.2686208193190395832062f,\
0.1170668462291359901428f,0.3667570571415126324f,0.8753886483609676361084f,\
0.5248321653343737125397f,0.7686112513765692710876f,0.8289924389682710170746f,\
0.6499033216387033462524f,0.5625062701292335987091f,0.216987949796020984650f,\
0.932231280487030744553f,0.9350972101092338562012f,0.9760812097229063510895f,\
0.9135094834491610527039f,0.2684359191916882991791f,0.0918707158416509628296f,\
0.1712972451932728290558f,0.7311726594343781471252f,0.8692278112284839153290f,\
0.0148080177605152130127f,0.6507192836143076419830f,0.4225442921742796897888f,\
0.2326209298335015773773f,0.3195550013333559036255f,0.7426187139935791492462f,\
0.7788188206031918525696f,0.6524895387701690196991f,0.9032440632581710815430f,\
0.8669646182097494602203f,0.7087978003546595573425f,0.6945203407667577266693f,\
0.8467157911509275436401f,0.9322743569500744342804f,0.9565412709489464759827f,\
0.1623990009538829326630f,0.1272875182330608367920f,0.9570735306479036808014f,\
0.6764409979805350303650f,0.3979810453020036220551f,0.1108187530189752578735f,\
0.5097153154201805591583f,0.5844655903056263923645f,0.2591971340589225292206f,\
0.2918234840035438537598f,0.0603091740049421787262f,0.9043274922296404838562f,\
0.6194427101872861385345f,0.2503793593496084213257f,0.8385089416988193988800f,\
0.8273218506947159767151f,0.7322020228020846843719f,0.2945837415754795074463f,\
0.2909102872945368289948f,0.7045872574672102928162f,0.3046565256081521511078f,\
0.7573066372424364089966f,0.7318075490184128284454f,0.6905383663251996040344f,\
0.6240276503376662731171f,0.415990501642227172852f,0.2810599454678595066071f,\
0.0562203852459788322449f,0.5804039551876485347748f,0.0042469184845685958862f,\
0.6828171615488827228546f,0.8913354435935616493225f,0.9298026482574641704559f,\
0.2840001545846462249756f,0.0988543094135820865631f,0.4136908343061804771423f,\
0.6412154859863221645355f,0.6469275895506143569946f,0.4702662643976509571075f,\
0.6048191310837864875793f,0.6713890465907752513885f,0.7139470204710960388184f,\
0.5412713759578764438629f,0.3905201805755496025085f,0.0110893785022199153900f,\
0.9015008416026830673218f,0.1388745536096394062042f,0.0850749695673584938049f,\
0.3466010238043963909149f,0.4233870990574359893799f,0.8021397278644144535065f,\
0.3178813671693205833435f,0.1802104166708886623383f,0.6968874204903841018677f,\
0.3548216861672699451447f,0.1612617420032620429993f,0.7534236568026244640350f,\
0.6219418197870254516602f,0.5151072838343679904938f,0.6781924543902277946472f,\
0.6166686578653752803802f,0.7021203767508268356323f,0.1362160299904644489288f,\
0.6087052235379815101624f,0.1892316709272563457489f,0.4761417917907238006592f,\
0.1716100485064089298248f,0.4137103697285056114197f,0.1531781828962266445160f,\
0.2286888156086206436157f,0.9585634139366447925568f,0.3949919315055012702942f,\
0.0250081899575889110565f,0.4492705538868904113770f,0.91384086245670915f,\
0.1101246578618884086609f,0.7487958460114896297455f,0.0078816469758749008179f,\
0.2352358778007328510284f,0.8010628754273056983948f,0.6545634861104190349579f,\
0.5162083245813846588135f,0.7027181521989405155182f,0.0551512306556105613708f,\
0.6256400248967111110687f,0.8431313354521989822388f,0.1729404223151504993439f,\
0.4173073070123791694641f,0.8187537300400435924530f,0.2532757520675659179688f,\
0.8608546801842749118805f,0.1721261171624064445496f,0.7806093706749379634857f,\
0.1373576503247022628784f,0.0021877591498196125031f,0.0146564701572060585022f,\
0.3046997408382594585419f,0.8030776642262935638428f,0.9905262948013842105865f,\
0.8285992136225104331970f,0.8721015579067170619965f,0.2953114155679941177368f,\
0.5827610609121620655060f,0.2906773509457707405090f,0.020005736034363508224f,\
0.7143468186259269714355f,0.2666406803764402866364f,0.5199280334636569023132f,\
0.4817320345900952816010f,0.0009182598441839218140f,0.3841847111470997333527f,\
0.4906664276495575904846f,0.4419780815951526165009f,0.6567876525223255157471f,\
0.10470610717311501503f,0.4278714573010802268982f,0.7510527721606194972992f,\
0.3696223665028810501099f,0.8411930543370544910431f,0.9037434207275509834290f,\
0.441844041924923658371f,0.0109200328588485717773f,0.2038001813925802707672f,\
0.854183482937514781952f,0.3932710154913365840912f,0.9757302235811948776245f,\
0.0841991459019482135773f,0.2339450428262352943420f,0.483970529865473508835f,\
0.3329230062663555145264f,0.9645385951735079288483f,0.5292069753631949424744f,\
0.0799680328927934169769f,0.754754373803734779358f,0.0447635021992027759552f,\
0.8463187487795948982239f,0.2000828566960990428925f,0.6944785490632057189941f,\
0.2820438765920698642731f,0.7954674167558550834656f,0.2028178661130368709564f,\
0.7807571645826101303101f,0.9360628505237400531769f,0.8880164856091141700745f,\
0.3384834821335971355438f,0.8976153172552585601807f}

#define FP2 {0.4503413387574255466461f,0.7080971030518412590027f,0.2459910525940358638763f,\
0.5369079094380140304565f,0.2288442556746304035187f,0.8762242654338479042053f,\
0.8204974154941737651825f,0.1096532605588436126709f,0.3977028490044176578522f,\
0.0387893309816718101501f,0.4764164215885102748871f,0.5613568071275949478149f,\
0.9855364081449806690216f,0.2565485062077641487122f,0.0636831256560981273651f,\
0.4720427915453910827637f,0.3494783216156065464020f,0.4271033955737948417664f,\
0.8822676776908338069916f,0.18796317838132381439f,0.8610891629941761493683f,\
0.0103648686781525611877f,0.9999243463389575481415f,0.3546787090599536895752f,\
0.4418791518546640872955f,0.7364388024434447288513f,0.5289249173365533351898f,\
0.3544368315488100051880f,0.5421899897046387195587f,0.0146836983039975166321f,\
0.2055264669470489025116f,0.1165965050458908081055f,0.6571860709227621555328f,\
0.2626901743933558464050f,0.1159235103987157344818f,0.2698498796671628952026f,\
0.9737050686962902545929f,0.8739323327317833900452f,0.9124345253221690654755f,\
0.1049908511340618133545f,0.2417178959585726261139f,0.0428410014137625694275f,\
0.3636728501878678798676f,0.3169804904609918594360f,0.4641480413265526294708f,\
0.1660488517954945564270f,0.5824519577436149120331f,0.9950593486428260803223f,\
0.4988002800382673740387f,0.0385573906823992729187f,0.7751751034520566463470f,\
0.8296566363424062728882f,0.1661487598903477191925f,0.5635758275166153907776f,\
0.8564593489281833171844f,0.0048462785780429840088f,0.9567344621755182743073f,\
0.1947818165645003318787f,0.7727439603768289089203f,0.7450998444110155105591f,\
0.9319220376200973987579f,0.8297540741041302680969f,0.8786331820301711559296f,\
0.9850863516330718994141f,0.9117660173214972019196f,0.3733268706128001213074f,\
0.2097233845852315425873f,0.1312689464539289474487f,0.5437363986857235431671f,\
0.6896163979545235633850f,0.9956645886413753032684f,0.3840484581887722015381f,\
0.3460536063648760318756f,0.1614690115675330162048f,0.25720636313781142235f,\
0.5892038289457559585571f,0.3193828281946480274200f,0.5760813476517796516418f,\
0.8309780987910926342010f,0.0873794183135032653809f,0.2206377261318266391754f,\
0.5555423153564333915710f,0.6657536565326154232025f,0.5303691830486059188843f,\
0.0926435221917927265167f,0.2510469639673829078674f,0.7339503909461200237274f,\
0.1329477317631244659424f,0.1434094593860208988190f,0.5195322250947356224060f,\
0.4021125487051904201508f,0.3289982546120882034302f,0.5687606376595795154572f,\
0.3014845298603177070618f,0.6041290420107543468475f,0.3006873279809951782227f,\
0.4120792248286306858063f,0.4186693010851740837097f,0.6609355970285832881927f,\
0.3494365941733121871948f,0.0549050425179302692413f,0.5105323204770684242249f,\
0.0904512773267924785614f,0.5774413160979747772217f,0.4321455270983278751373f,\
0.3280229708179831504822f,0.2514993823133409023285f,0.8484858069568872451782f,\
0.5656450656242668628693f,0.1035893531516194343567f,0.1654627206735312938690f,\
0.4968057349324226379395f,0.5098637067712843418121f,0.2160952789708971977234f,\
0.3594232588075101375580f,0.7527473028749227523804f,0.3034152467735111713409f,\
0.8694091374054551124573f,0.0745361442677676677704f,0.3539733029901981353760f,\
0.0202146903611719608307f,0.0034146374091506004333f,0.6833881041966378688812f,\
0.3109660465270280838013f,0.5139850866980850696564f,0.1561934249475598335266f,\
0.6600902187637984752655f,0.2955771684646606445312f,0.9498737403191626071930f,\
0.4961295751854777336121f,0.9468550696037709712982f,0.6213743072003126144409f,\
0.7169277970679104328156f,0.7426859596744179725647f,0.0608082632534205913544f,\
0.2845346592366695404053f,0.8151792050339281558990f,0.1946024885401129722595f,\
0.7847843295894563198090f,0.0340354088693857192993f,0.3110890504904091358185f,\
0.5842662276700139045715f,0.7858569952659308910370f,0.9398910328745841979980f,\
0.9551012688316404819489f,0.9770033909007906913757f,0.0053538321517407894135f,\
0.4281874801963567733765f,0.5550557305105030536652f,0.4340432072058320045471f,\
0.1641052807681262493134f,0.2516632266342639923096f,0.1992107019759714603424f,\
0.65790366288274526596f,0.226678048726171255112f,0.3645872045308351516724f,\
0.9226246816106140613556f,0.3389491187408566474915f,0.1683428841643035411835f,\
0.1706836074590682983398f,0.9106476106680929660797f,0.4218698022887110710144f,\
0.8885267241857945919037f,0.1128535699099302291870f,0.8332714592106640338898f,\
0.0108331749215722084045f,0.6144992182962596416473f,0.0734437219798564910889f,\
0.4040901870466768741608f,0.1320571741089224815369f,0.6390436268411576747894f,\
0.5538116190582513809204f,0.7576190796680748462677f,0.0725553305819630622864f,\
0.7358620944432914257050f,0.1019380465149879455566f,0.7387234591878950595856f,\
0.5138037605211138725281f,0.0964652984403073787689f,0.9568361993879079818726f,\
0.6979067702777683734894f,0.1790800327435135841370f,0.1322964723221957683563f,\
0.3785077370703220367432f,0.8862080411054193973541f,0.2132239108905196189880f,\
0.9858398041687905788422f,0.6321957129985094070435f,0.0434587192721664905548f,\
0.0135699706152081489563f,0.0944632100872695446014f,0.0956843793392181396484f,\
0.2736488827504217624664f,0.7308020917698740959167f,0.6507454826496541500092f,\
0.4583958666771650314331f,0.8011528258211910724640f,0.1584798255935311317444f,\
0.3030378143303096294403f,0.4810337387025356292725f}

#define FRes {0.1744912529357576791433f,0.2823742864225169957315f,0.2451052593884412711400f,\
0.5004402795138161996746f,0.0155952021804655512061f,0.6297831559001532131248f,\
0.5409455090315361536213f,0.0480083569003692950394f,0.3806040803034145825201f,\
0.0154295371430231906262f,0.257977685467529749275f,0.0828273707923430219102f,\
0.9064233444099463188337f,0.1073744637443841548619f,0.0576003141096106049956f,\
0.1511833966150217811730f,0.2008882664476865365089f,0.3234294236757639939839f,\
0.2871542132181882922559f,0.0942175789112195266606f,0.231306476470241606513f,\
0.0012133824877304738923f,0.3667293106274266967226f,0.3104817157264057603250f,\
0.2319123920839998853616f,0.5660351495083181250223f,0.4384747572539204885089f,\
0.2303496741346691967234f,0.3049852688101639119900f,0.0031861855904077316173f,\
0.1915982014560227986166f,0.1090290665768997024898f,0.6414669751193333713246f,\
0.2399699655172445322826f,0.0311180340698064966665f,0.0247913016148056282451f,\
0.1667929958984009919387f,0.6389954278891879502211f,0.7931134653350897512070f,\
0.0015547063882847961258f,0.1572904960949201291776f,0.0181022206184156195241f,\
0.0845979165659015430734f,0.1012927010519100584629f,0.3446850215525631422331f,\
0.1293219709178812792949f,0.3800438092639132903194f,0.8987814492511753128312f,\
0.4324421943462926076762f,0.0273293937030998496107f,0.5383748770034290087594f,\
0.7024833752242779505437f,0.1548962282848262428381f,0.5390835383288474780272f,\
0.1390881426235499873645f,0.0006168707728651384725f,0.9156652296068464869094f,\
0.1317584063853521059162f,0.3075374491015804290228f,0.0825710356322612165636f,\
0.4750149353525452977642f,0.4849627047297689896865f,0.2277392026712919681497f,\
0.2874713311779031332804f,0.0549878553904352973536f,0.3376097526832130268915f,\
0.1299116217371263370950f,0.0328670347156327785632f,0.4559278322250933657145f,\
0.5705347146251601442302f,0.7290276258356205296707f,0.1131344317595426168799f,\
0.1006705540469166465511f,0.1137690080263093483914f,0.0783595969578743251072f,\
0.4462079703492781712626f,0.2337267646996942227489f,0.3978062726778792690396f,\
0.5185533104706666618355f,0.0363490080574402352198f,0.0620124272747637136916f,\
0.0312328029897817466276f,0.3864060554321692708690f,0.0022524346871346696830f,\
0.0632585868588908389887f,0.2237670569906841377961f,0.6824290171913035552009f,\
0.0377571763724054293432f,0.0141766430709802434412f,0.2149257196483875254067f,\
0.2578407933391972939319f,0.2128380478225575245244f,0.2674689404085963673197f,\
0.1823436113853212359182f,0.4056056215333987968741f,0.2146748219054467332612f,\
0.223046689026648065068f,0.1634988110612213274564f,0.0073293650010406562884f,\
0.3150173837340161653309f,0.0076249132705958379275f,0.0434335216277395089191f,\
0.0313505053258816626660f,0.2444812036986294678798f,0.3466410955044766373234f,\
0.1042723904265626388987f,0.0453228084791582885860f,0.5912990853328871088124f,\
0.2007031359569984296787f,0.0167049995422212521623f,0.1246635280743631640776f,\
0.3089842628645015354394f,0.2626345091206789272853f,0.1465541876274137622627f,\
0.2216450586144267098643f,0.5285192198927095574845f,0.0413300203540647725919f,\
0.5292138833303512424067f,0.0141045991242647154873f,0.1685414827318337249729f,\
0.0034690439934227570301f,0.0014126709050284813954f,0.1046801480137381917812f,\
0.0711144568747612698667f,0.4926872994178387865638f,0.0616951426084962062379f,\
0.0165076615799914921956f,0.1327941181924368052591f,0.868033438078243735347f,\
0.0546360997224647759740f,0.7090011428942235571782f,0.0048974529292317055262f,\
0.1686471396630155883400f,0.5949381503962772876903f,0.0398028687794790766996f,\
0.1468791597298964024532f,0.5728412246724432499434f,0.0107325667316315806477f,\
0.4909924875028962021339f,0.0286963197327067993936f,0.0537998717694305322867f,\
0.2438185660472551308242f,0.6434233461520417751700f,0.2380516082128716348620f,\
0.8222033973236569925902f,0.1681678001302578939757f,0.0041792515466696263798f,\
0.0588148261782265452391f,0.0012143282530841621129f,0.0063615413133502824242f,\
0.0500028365202378755061f,0.2021051162170970916243f,0.1973234385130417933851f,\
0.5451384577040119250313f,0.1976862794373486775790f,0.1076667634679787238783f,\
0.5376697382791472135111f,0.0985248319409957051818f,0.0033678233038544891365f,\
0.1219272919799819776543f,0.2428156984917200222895f,0.2193419366816712900992f,\
0.4280317866296952655780f,0.0001036289015210918596f,0.3201301548639712835076f,\
0.0053154752388706117197f,0.271595185644301739813f,0.0482369297516522660407f,\
0.0423107104325134431022f,0.0565034955330471419521f,0.4799554874706279394836f,\
0.20470116123310294620f,0.6373039076500160993177f,0.0655714026521615894749f,\
0.3251362821081638099230f,0.0011131668175105025043f,0.1505519749814473728922f,\
0.4388826857083177879204f,0.0379370058772945314973f,0.9336139987593442546299f,\
0.0587631539765752775040f,0.0418948859295049033657f,0.0640275938091060398127f,\
0.1260139337205268827979f,0.8547818589992876026074f,0.1128395809574832958644f,\
0.0788356698867948707532f,0.4771524794855955819983f,0.0019453644757141607628f,\
0.0114845205520388293774f,0.0189004689269446496391f,0.0664507489315135924102f,\
0.0771809917160177494377f,0.5813292520999571166840f,0.1319828101737011150085f,\
0.3578958571232515595284f,0.7499293978433335672307f,0.140732697763512853983f,\
0.1025732946126776817808f,0.4317832519759596809905f}

#define DP1 {0.3874644362367689609528,0.3987790448591113090515,0.9963990836404263973236,\
0.9320784267038106918335,0.0681476672179996967316,0.7187465364113450050354,\
0.6592897172085940837860,0.437819693237543106079,0.9570061699487268924713,\
0.3977778619155287742615,0.5414962074719369411469,0.1475485283881425857544,\
0.9197258842177689075470,0.4185347454622387886047,0.9044831502251327037811,\
0.3202747702598571777344,0.5748232551850378513336,0.7572625903412699699402,\
0.3254728927277028560638,0.5012555103749036788940,0.2686208193190395832062,\
0.1170668462291359901428,0.3667570571415126324,0.8753886483609676361084,\
0.5248321653343737125397,0.7686112513765692710876,0.8289924389682710170746,\
0.6499033216387033462524,0.5625062701292335987091,0.216987949796020984650,\
0.932231280487030744553,0.9350972101092338562012,0.9760812097229063510895,\
0.9135094834491610527039,0.2684359191916882991791,0.0918707158416509628296,\
0.1712972451932728290558,0.7311726594343781471252,0.8692278112284839153290,\
0.0148080177605152130127,0.6507192836143076419830,0.4225442921742796897888,\
0.2326209298335015773773,0.3195550013333559036255,0.7426187139935791492462,\
0.7788188206031918525696,0.6524895387701690196991,0.9032440632581710815430,\
0.8669646182097494602203,0.7087978003546595573425,0.6945203407667577266693,\
0.8467157911509275436401,0.9322743569500744342804,0.9565412709489464759827,\
0.1623990009538829326630,0.1272875182330608367920,0.9570735306479036808014,\
0.6764409979805350303650,0.3979810453020036220551,0.1108187530189752578735,\
0.5097153154201805591583,0.5844655903056263923645,0.2591971340589225292206,\
0.2918234840035438537598,0.0603091740049421787262,0.9043274922296404838562,\
0.6194427101872861385345,0.2503793593496084213257,0.8385089416988193988800,\
0.8273218506947159767151,0.7322020228020846843719,0.2945837415754795074463,\
0.2909102872945368289948,0.7045872574672102928162,0.3046565256081521511078,\
0.7573066372424364089966,0.7318075490184128284454,0.6905383663251996040344,\
0.6240276503376662731171,0.415990501642227172852,0.2810599454678595066071,\
0.0562203852459788322449,0.5804039551876485347748,0.0042469184845685958862,\
0.6828171615488827228546,0.8913354435935616493225,0.9298026482574641704559,\
0.2840001545846462249756,0.0988543094135820865631,0.4136908343061804771423,\
0.6412154859863221645355,0.6469275895506143569946,0.4702662643976509571075,\
0.6048191310837864875793,0.6713890465907752513885,0.7139470204710960388184,\
0.5412713759578764438629,0.3905201805755496025085,0.0110893785022199153900,\
0.9015008416026830673218,0.1388745536096394062042,0.0850749695673584938049,\
0.3466010238043963909149,0.4233870990574359893799,0.8021397278644144535065,\
0.3178813671693205833435,0.1802104166708886623383,0.6968874204903841018677,\
0.3548216861672699451447,0.1612617420032620429993,0.7534236568026244640350,\
0.6219418197870254516602,0.5151072838343679904938,0.6781924543902277946472,\
0.6166686578653752803802,0.7021203767508268356323,0.1362160299904644489288,\
0.6087052235379815101624,0.1892316709272563457489,0.4761417917907238006592,\
0.1716100485064089298248,0.4137103697285056114197,0.1531781828962266445160,\
0.2286888156086206436157,0.9585634139366447925568,0.3949919315055012702942,\
0.0250081899575889110565,0.4492705538868904113770,0.91384086245670915,\
0.1101246578618884086609,0.7487958460114896297455,0.0078816469758749008179,\
0.2352358778007328510284,0.8010628754273056983948,0.6545634861104190349579,\
0.5162083245813846588135,0.7027181521989405155182,0.0551512306556105613708,\
0.6256400248967111110687,0.8431313354521989822388,0.1729404223151504993439,\
0.4173073070123791694641,0.8187537300400435924530,0.2532757520675659179688,\
0.8608546801842749118805,0.1721261171624064445496,0.7806093706749379634857,\
0.1373576503247022628784,0.0021877591498196125031,0.0146564701572060585022,\
0.3046997408382594585419,0.8030776642262935638428,0.9905262948013842105865,\
0.8285992136225104331970,0.8721015579067170619965,0.2953114155679941177368,\
0.5827610609121620655060,0.2906773509457707405090,0.020005736034363508224,\
0.7143468186259269714355,0.2666406803764402866364,0.5199280334636569023132,\
0.4817320345900952816010,0.0009182598441839218140,0.3841847111470997333527,\
0.4906664276495575904846,0.4419780815951526165009,0.6567876525223255157471,\
0.10470610717311501503,0.4278714573010802268982,0.7510527721606194972992,\
0.3696223665028810501099,0.8411930543370544910431,0.9037434207275509834290,\
0.441844041924923658371,0.0109200328588485717773,0.2038001813925802707672,\
0.854183482937514781952,0.3932710154913365840912,0.9757302235811948776245,\
0.0841991459019482135773,0.2339450428262352943420,0.483970529865473508835,\
0.3329230062663555145264,0.9645385951735079288483,0.5292069753631949424744,\
0.0799680328927934169769,0.754754373803734779358,0.0447635021992027759552,\
0.8463187487795948982239,0.2000828566960990428925,0.6944785490632057189941,\
0.2820438765920698642731,0.7954674167558550834656,0.2028178661130368709564,\
0.7807571645826101303101,0.9360628505237400531769,0.8880164856091141700745,\
0.3384834821335971355438,0.8976153172552585601807}

#define DP2  {0.4503413387574255466461,0.7080971030518412590027,0.2459910525940358638763,\
0.5369079094380140304565,0.2288442556746304035187,0.8762242654338479042053,\
0.8204974154941737651825,0.1096532605588436126709,0.3977028490044176578522,\
0.0387893309816718101501,0.4764164215885102748871,0.5613568071275949478149,\
0.9855364081449806690216,0.2565485062077641487122,0.0636831256560981273651,\
0.4720427915453910827637,0.3494783216156065464020,0.4271033955737948417664,\
0.8822676776908338069916,0.18796317838132381439,0.8610891629941761493683,\
0.0103648686781525611877,0.9999243463389575481415,0.3546787090599536895752,\
0.4418791518546640872955,0.7364388024434447288513,0.5289249173365533351898,\
0.3544368315488100051880,0.5421899897046387195587,0.0146836983039975166321,\
0.2055264669470489025116,0.1165965050458908081055,0.6571860709227621555328,\
0.2626901743933558464050,0.1159235103987157344818,0.2698498796671628952026,\
0.9737050686962902545929,0.8739323327317833900452,0.9124345253221690654755,\
0.1049908511340618133545,0.2417178959585726261139,0.0428410014137625694275,\
0.3636728501878678798676,0.3169804904609918594360,0.4641480413265526294708,\
0.1660488517954945564270,0.5824519577436149120331,0.9950593486428260803223,\
0.4988002800382673740387,0.0385573906823992729187,0.7751751034520566463470,\
0.8296566363424062728882,0.1661487598903477191925,0.5635758275166153907776,\
0.8564593489281833171844,0.0048462785780429840088,0.9567344621755182743073,\
0.1947818165645003318787,0.7727439603768289089203,0.7450998444110155105591,\
0.9319220376200973987579,0.8297540741041302680969,0.8786331820301711559296,\
0.9850863516330718994141,0.9117660173214972019196,0.3733268706128001213074,\
0.2097233845852315425873,0.1312689464539289474487,0.5437363986857235431671,\
0.6896163979545235633850,0.9956645886413753032684,0.3840484581887722015381,\
0.3460536063648760318756,0.1614690115675330162048,0.25720636313781142235,\
0.5892038289457559585571,0.3193828281946480274200,0.5760813476517796516418,\
0.8309780987910926342010,0.0873794183135032653809,0.2206377261318266391754,\
0.5555423153564333915710,0.6657536565326154232025,0.5303691830486059188843,\
0.0926435221917927265167,0.2510469639673829078674,0.7339503909461200237274,\
0.1329477317631244659424,0.1434094593860208988190,0.5195322250947356224060,\
0.4021125487051904201508,0.3289982546120882034302,0.5687606376595795154572,\
0.3014845298603177070618,0.6041290420107543468475,0.3006873279809951782227,\
0.4120792248286306858063,0.4186693010851740837097,0.6609355970285832881927,\
0.3494365941733121871948,0.0549050425179302692413,0.5105323204770684242249,\
0.0904512773267924785614,0.5774413160979747772217,0.4321455270983278751373,\
0.3280229708179831504822,0.2514993823133409023285,0.8484858069568872451782,\
0.5656450656242668628693,0.1035893531516194343567,0.1654627206735312938690,\
0.4968057349324226379395,0.5098637067712843418121,0.2160952789708971977234,\
0.3594232588075101375580,0.7527473028749227523804,0.3034152467735111713409,\
0.8694091374054551124573,0.0745361442677676677704,0.3539733029901981353760,\
0.0202146903611719608307,0.0034146374091506004333,0.6833881041966378688812,\
0.3109660465270280838013,0.5139850866980850696564,0.1561934249475598335266,\
0.6600902187637984752655,0.2955771684646606445312,0.9498737403191626071930,\
0.4961295751854777336121,0.9468550696037709712982,0.6213743072003126144409,\
0.7169277970679104328156,0.7426859596744179725647,0.0608082632534205913544,\
0.2845346592366695404053,0.8151792050339281558990,0.1946024885401129722595,\
0.7847843295894563198090,0.0340354088693857192993,0.3110890504904091358185,\
0.5842662276700139045715,0.7858569952659308910370,0.9398910328745841979980,\
0.9551012688316404819489,0.9770033909007906913757,0.0053538321517407894135,\
0.4281874801963567733765,0.5550557305105030536652,0.4340432072058320045471,\
0.1641052807681262493134,0.2516632266342639923096,0.1992107019759714603424,\
0.65790366288274526596,0.226678048726171255112,0.3645872045308351516724,\
0.9226246816106140613556,0.3389491187408566474915,0.1683428841643035411835,\
0.1706836074590682983398,0.9106476106680929660797,0.4218698022887110710144,\
0.8885267241857945919037,0.1128535699099302291870,0.8332714592106640338898,\
0.0108331749215722084045,0.6144992182962596416473,0.0734437219798564910889,\
0.4040901870466768741608,0.1320571741089224815369,0.6390436268411576747894,\
0.5538116190582513809204,0.7576190796680748462677,0.0725553305819630622864,\
0.7358620944432914257050,0.1019380465149879455566,0.7387234591878950595856,\
0.5138037605211138725281,0.0964652984403073787689,0.9568361993879079818726,\
0.6979067702777683734894,0.1790800327435135841370,0.1322964723221957683563,\
0.3785077370703220367432,0.8862080411054193973541,0.2132239108905196189880,\
0.9858398041687905788422,0.6321957129985094070435,0.0434587192721664905548,\
0.0135699706152081489563,0.0944632100872695446014,0.0956843793392181396484,\
0.2736488827504217624664,0.7308020917698740959167,0.6507454826496541500092,\
0.4583958666771650314331,0.8011528258211910724640,0.1584798255935311317444,\
0.3030378143303096294403,0.4810337387025356292725}

#define DRes {0.1744912529357576791433,0.2823742864225169957315,0.2451052593884412711400,\
0.5004402795138161996746,0.0155952021804655512061,0.6297831559001532131248,\
0.5409455090315361536213,0.0480083569003692950394,0.3806040803034145825201,\
0.0154295371430231906262,0.257977685467529749275,0.0828273707923430219102,\
0.9064233444099463188337,0.1073744637443841548619,0.0576003141096106049956,\
0.1511833966150217811730,0.2008882664476865365089,0.3234294236757639939839,\
0.2871542132181882922559,0.0942175789112195266606,0.231306476470241606513,\
0.0012133824877304738923,0.3667293106274266967226,0.3104817157264057603250,\
0.2319123920839998853616,0.5660351495083181250223,0.4384747572539204885089,\
0.2303496741346691967234,0.3049852688101639119900,0.0031861855904077316173,\
0.1915982014560227986166,0.1090290665768997024898,0.6414669751193333713246,\
0.2399699655172445322826,0.0311180340698064966665,0.0247913016148056282451,\
0.1667929958984009919387,0.6389954278891879502211,0.7931134653350897512070,\
0.0015547063882847961258,0.1572904960949201291776,0.0181022206184156195241,\
0.0845979165659015430734,0.1012927010519100584629,0.3446850215525631422331,\
0.1293219709178812792949,0.3800438092639132903194,0.8987814492511753128312,\
0.4324421943462926076762,0.0273293937030998496107,0.5383748770034290087594,\
0.7024833752242779505437,0.1548962282848262428381,0.5390835383288474780272,\
0.1390881426235499873645,0.0006168707728651384725,0.9156652296068464869094,\
0.1317584063853521059162,0.3075374491015804290228,0.0825710356322612165636,\
0.4750149353525452977642,0.4849627047297689896865,0.2277392026712919681497,\
0.2874713311779031332804,0.0549878553904352973536,0.3376097526832130268915,\
0.1299116217371263370950,0.0328670347156327785632,0.4559278322250933657145,\
0.5705347146251601442302,0.7290276258356205296707,0.1131344317595426168799,\
0.1006705540469166465511,0.1137690080263093483914,0.0783595969578743251072,\
0.4462079703492781712626,0.2337267646996942227489,0.3978062726778792690396,\
0.5185533104706666618355,0.0363490080574402352198,0.0620124272747637136916,\
0.0312328029897817466276,0.3864060554321692708690,0.0022524346871346696830,\
0.0632585868588908389887,0.2237670569906841377961,0.6824290171913035552009,\
0.0377571763724054293432,0.0141766430709802434412,0.2149257196483875254067,\
0.2578407933391972939319,0.2128380478225575245244,0.2674689404085963673197,\
0.1823436113853212359182,0.4056056215333987968741,0.2146748219054467332612,\
0.223046689026648065068,0.1634988110612213274564,0.0073293650010406562884,\
0.3150173837340161653309,0.0076249132705958379275,0.0434335216277395089191,\
0.0313505053258816626660,0.2444812036986294678798,0.3466410955044766373234,\
0.1042723904265626388987,0.0453228084791582885860,0.5912990853328871088124,\
0.2007031359569984296787,0.0167049995422212521623,0.1246635280743631640776,\
0.3089842628645015354394,0.2626345091206789272853,0.1465541876274137622627,\
0.2216450586144267098643,0.5285192198927095574845,0.0413300203540647725919,\
0.5292138833303512424067,0.0141045991242647154873,0.1685414827318337249729,\
0.0034690439934227570301,0.0014126709050284813954,0.1046801480137381917812,\
0.0711144568747612698667,0.4926872994178387865638,0.0616951426084962062379,\
0.0165076615799914921956,0.1327941181924368052591,0.868033438078243735347,\
0.0546360997224647759740,0.7090011428942235571782,0.0048974529292317055262,\
0.1686471396630155883400,0.5949381503962772876903,0.0398028687794790766996,\
0.1468791597298964024532,0.5728412246724432499434,0.0107325667316315806477,\
0.4909924875028962021339,0.0286963197327067993936,0.0537998717694305322867,\
0.2438185660472551308242,0.6434233461520417751700,0.2380516082128716348620,\
0.8222033973236569925902,0.1681678001302578939757,0.0041792515466696263798,\
0.0588148261782265452391,0.0012143282530841621129,0.0063615413133502824242,\
0.0500028365202378755061,0.2021051162170970916243,0.1973234385130417933851,\
0.5451384577040119250313,0.1976862794373486775790,0.1076667634679787238783,\
0.5376697382791472135111,0.0985248319409957051818,0.0033678233038544891365,\
0.1219272919799819776543,0.2428156984917200222895,0.2193419366816712900992,\
0.4280317866296952655780,0.0001036289015210918596,0.3201301548639712835076,\
0.0053154752388706117197,0.271595185644301739813,0.0482369297516522660407,\
0.0423107104325134431022,0.0565034955330471419521,0.4799554874706279394836,\
0.20470116123310294620,0.6373039076500160993177,0.0655714026521615894749,\
0.3251362821081638099230,0.0011131668175105025043,0.1505519749814473728922,\
0.4388826857083177879204,0.0379370058772945314973,0.9336139987593442546299,\
0.0587631539765752775040,0.0418948859295049033657,0.0640275938091060398127,\
0.1260139337205268827979,0.8547818589992876026074,0.1128395809574832958644,\
0.0788356698867948707532,0.4771524794855955819983,0.0019453644757141607628,\
0.0114845205520388293774,0.0189004689269446496391,0.0664507489315135924102,\
0.0771809917160177494377,0.5813292520999571166840,0.1319828101737011150085,\
0.3578958571232515595284,0.7499293978433335672307,0.140732697763512853983,\
0.1025732946126776817808,0.4317832519759596809905}



#define CR1 {0.4167818673886358737946f,0.7754927603527903556824f,0.6147445752285420894623f,\
0.2206868808716535568237f,0.4781269435770809650421f,0.1743857422843575477600f,\
0.2262396733276546001434f,0.8763213120400905609131f,0.6657514632679522037506f,\
0.9176845839247107505798f,0.5456351465545594692230f,0.9846978131681680679321f,\
0.6502424892969429492950f,0.6890702964738011360168f,0.5013572606258094310760f,\
0.7673201188445091247559f,0.5771855586208403110504f,0.3508661640807986259460f,\
0.6027267514728009700775f,0.8505915608257055282593f,0.0968277682550251483917f,\
0.1382516110315918922424f,0.3514578486792743206024f,0.0176461227238178253174f,\
0.7433502362109720706940f,0.3358979439362883567810f,0.1121416739188134670258f,\
0.3644763696938753128052f,0.2574999374337494373322f,0.1557759689167141914368f,\
0.7854640143923461437225f,0.3291082531213760375977f,0.9463309147395193576813f,\
0.0348854837939143180847f,0.1279074712656438350677f,0.5625727903097867965698f,\
0.6738048647530376911163f,0.0716566452756524085999f,0.0616879831068217754364f,\
0.1104246191680431365967f,0.5760010988451540470123f,0.8197732111439108848572f,\
0.8186757243238389492035f,0.8735574278980493545532f,0.0946858790703117847443f,\
0.1581676574423909187317f,0.2620503786019980907440f,0.8170662596821784973145f,\
0.4229911291040480136871f,0.4559381706640124320984f,0.2294407873414456844330f,\
0.8959066923707723617554f,0.9569525201804935932159f,0.7509375149384140968323f,\
0.2412989730946719646454f,0.1661008931696414947510f,0.8466569320298731327057f,\
0.1607837742194533348083f,0.4182585380040109157562f,0.0502405483275651931763f,\
0.2407492888160049915314f,0.2450429694727063179016f,0.9512274372391402721405f,\
0.2260366678237915039062f,0.318048770073801279068f,0.5373335508629679679871f,\
0.9679651274345815181732f,0.1066662650555372238159f,0.7000243966467678546906f,\
0.9661027649417519569397f,0.1398940901271998882294f,0.3816659115254878997803f,\
0.3378799916245043277740f,0.3828248968347907066345f,0.8728957301937043666840f,\
0.5871221665292978286743f,0.4679985162802040576935f,0.9163713874295353889465f,\
0.4258406492881476879120f,0.1739088818430900573730f,0.7294957810081541538239f,\
0.3723028255626559257507f,0.8006032942794263362885f,0.0427213814109563827515f,\
0.0376335312612354755402f,0.3958328152075409889221f,0.7473109806887805461884f,\
0.0146575160324573516846f,0.3068419084884226322174f,0.6172137176617980003357f,\
0.7285772911272943019867f,0.206095593050122261047f,0.6171012860722839832306f,\
0.4982942687347531318665f,0.1864698487333953380585f,0.7766191810369491577148f,\
0.9174334802664816379547f,0.0989990709349513053894f,0.9559624656103551387787f,\
0.0187387894839048385620f,0.8602523361332714557648f,0.4824799606576561927795f,\
0.1686216662637889385223f,0.2581604234874248504639f,0.8603236884810030460358f,\
0.9776892503723502159119f,0.4902775860391557216644f,0.5333510134369134902954f,\
0.9720846978016197681427f,0.0181248458102345466614f,0.0364292445592582225800f,\
0.5231507197022438049316f,0.6790725612081587314606f,0.7754972381517291069031f,\
0.8091341941617429256439f,0.6911821123212575912476f,0.1892125983722507953644f,\
0.3070683712139725685120f,0.9991325433366000652313f,0.1158062256872653961182f,\
0.3297157124616205692291f,0.4354123836383223533630f,0.9969553551636636257172f,\
0.9743754882365465164185f,0.6353352260775864124298f,0.0793482260778546333313f,\
0.4567674207501113414764f,0.1505335271358489990234f,0.7237330921925604343414f,\
0.2547941533848643302917f,0.2566944076679646968842f,0.9333118479698896408081f,\
0.5517054800875484943390f,0.4642940917983651161194f,0.6993843833915889263153f,\
0.2767733894288539886475f,0.6460177362896502017975f,0.6939658811315894126892f,\
0.7965537137351930141449f,0.5889529529958963394165f,0.9025987205095589160919f,\
0.7366213919594883918762f,0.9812673362903296947479f,0.5188445076346397399902f,\
0.0478445165790617465973f,0.0598085178062319755554f,0.0917034088633954524994f,\
0.7101853694766759872437f,0.3557815183885395526886f,0.9375250423327088356018f,\
0.9701523329131305217743f,0.9907872565090656280518f,0.7148388908244669437408f,\
0.0643543815240263938904f,0.5210001519881188869476f,0.9661642182618379592896f,\
0.6379804057069122791290f,0.3707732008770108222961f,0.5714463251642882823944f,\
0.4862074404954910278320f,0.3099456527270376682281f,0.2583809075877070426941f,\
0.3787058754824101924896f,0.9536569248884916305542f,0.2653506253845989704132f,\
0.9738010177388787269592f,0.1274459133855998516083f,0.9431200437247753143311f,\
0.7913976819254457950592f,0.3400043984875082969666f,0.2612065351568162441254f,\
0.0993869695812463760376f,0.6489448812790215015411f,0.5638043852522969245911f,\
0.9915560963563621044159f,0.7837929800152778625488f,0.2056846939958631992340f,\
0.3382737739011645317078f,0.8287308602593839168549f,0.4373776372522115707397f,\
0.5751820881851017475128f,0.9588336879387497901917f,0.4775090212933719158173f,\
0.1295908428728580474854f,0.8555219904519617557526f,0.6717643206939101219177f,\
0.9420691034756600856781f,0.2612957675009965896606f,0.0613161218352615833282f,\
0.9738875525072216987610f,0.1835827338509261608124f,0.8908186554908752441406f,\
0.8428192087449133396149f,0.0821714429184794425964f,0.1742917909286916255951f,\
0.6517955046147108078003f,0.5859045688994228839874f,0.2920065978541970252991f,\
0.6918199281208217144012f,0.7315656207501888275146f}

#define CI1 {0.9866490722633898258209f,0.4429044118151068687439f,0.6974684721790254116058f,\
0.8788620475679636001587f,0.6942774769850075244904f,0.2103671850636601448059f,\
0.6422466966323554515839f,0.9095488712191581726074f,0.1162161403335630893707f,\
0.4426801158115267753601f,0.54438647022470831871f,0.6791554000228643417358f,\
0.9790061046369373798370f,0.2613751674070954322815f,0.1820912803523242473602f,\
0.9909572191536426544189f,0.7388255582191050052643f,0.1441168105229735374451f,\
0.2452696315012872219086f,0.408354120329022407532f,0.4353716713376343250275f,\
0.7087596403434872627258f,0.7900028186850249767303f,0.4402949064970016479492f,\
0.0828518071211874485016f,0.4173278687521815299988f,0.8394970758818089962006f,\
0.0684990715235471725464f,0.1918341075070202350616f,0.9186666915193200111389f,\
0.4752700994722545146942f,0.0852253548800945281982f,0.5157074541784822940826f,\
0.2485155304893851280212f,0.2623219466768205165863f,0.2103371713310480117798f,\
0.6155008045025169849396f,0.6057531507685780525208f,0.3520403089933097362518f,\
0.4564149156212806701660f,0.3368119024671614170074f,0.9235646529123187065125f,\
0.1065901606343686580658f,0.7106651421636343002319f,0.7925953646190464496613f,\
0.9542803401127457618713f,0.58853778196498751640f,0.0023766197264194488525f,\
0.9455601410008966922760f,0.0866364603862166404724f,0.759459157940000295639f,\
0.4246732611209154129028f,0.3839263510890305042267f,0.6142078237608075141907f,\
0.7312827515415847301483f,0.1793139278888702392578f,0.3842914947308599948883f,\
0.6737622944638133049011f,0.9141166522167623043060f,0.7132891099900007247925f,\
0.8553560380823910236359f,0.5722871581092476844788f,0.4043100993148982524872f,\
0.4159644804894924163818f,0.2562583745457231998444f,0.7214373638853430747986f,\
0.4564993805252015590668f,0.8455213252454996109009f,0.0832691607065498828888f,\
0.8981556417420506477356f,0.3833881053142249584198f,0.9534438475966453552246f,\
0.0185950272716581821442f,0.0502144945785403251648f,0.7270118533633649349213f,\
0.2758033480495214462280f,0.3350416650064289569855f,0.3654300654307007789612f,\
0.0452371980063617229462f,0.5600892789661884307861f,0.6502862856723368167877f,\
0.823297879658639431000f,0.1572451046667993068695f,0.7963371742516756057739f,\
0.6245094579644501209259f,0.9478004621341824531555f,0.1917487042956054210663f,\
0.1213034540414810180664f,0.6951363184489309787750f,0.9801368294283747673035f,\
0.2816954418085515499115f,0.5644371043890714645386f,0.4424371575005352497101f,\
0.1901238569989800453186f,0.2492035995237529277802f,0.1043982319533824920654f,\
0.6797373802401125431061f,0.5450195213779807090759f,0.1244831955991685390472f,\
0.0048734936863183975220f,0.8619868424721062183380f,0.4545180173590779304504f,\
0.8424912574701011180878f,0.8984384015202522277832f,0.9064385616220533847809f,\
0.8106667501851916313171f,0.9610714702866971492767f,0.5872165020555257797241f,\
0.0191868026740849018097f,0.0414552027359604835510f,0.7443282003514468669891f,\
0.0290854312479496002197f,0.6213145391084253787994f,0.3968256777152419090271f,\
0.4549848935566842556000f,0.4781798440963029861450f,0.9684002888388931751251f,\
0.1858559148386120796204f,0.1994768488220870494843f,0.2484412193298339843750f,\
0.5571343251504004001617f,0.1838635830208659172058f,0.1695283665321767330170f,\
0.0689645390957593917847f,0.9127942626364529132843f,0.9281826475635170936584f,\
0.6239642719738185405731f,0.4998918436467647552490f,0.8513300181366503238678f,\
0.1213616123422980308533f,0.4545058137737214565277f,0.3776026610285043716431f,\
0.8098081466741859912872f,0.8605336369946599006653f,0.6793009373359382152557f,\
0.7579513117671012878418f,0.3389655523933470249176f,0.9117085291072726249695f,\
0.7079389332793653011322f,0.3263010885566473007202f,0.3516225744970142841339f,\
0.7477366114035248756409f,0.7216994608752429485321f,0.7431053109467029571533f,\
0.2207054481841623783112f,0.5686944639310240745544f,0.0127859464846551418304f,\
0.893785255029797554016f,0.3206281405873596668243f,0.0234425412490963935852f,\
0.626293356996029615402f,0.5116549581289291381836f,0.1057835617102682590485f,\
0.8511046646162867546082f,0.1486603482626378536224f,0.1426428984850645065f,\
0.3198941503651440143585f,0.1612193891778588294983f,0.9863557885400950908661f,\
0.9205605499446392059326f,0.4299718351103365421295f,0.5713132461532950401306f,\
0.9785496569238603115082f,0.1216678116470575332642f,0.8786373701877892017365f,\
0.9206458600237965583801f,0.6875183167867362499237f,0.9672853127121925354004f,\
0.2485490464605391025543f,0.7788769407197833061218f,0.2105341642163693904877f,\
0.6432035919278860092163f,0.9326907773502171039581f,0.4684051508083939552307f,\
0.8569896514527499675751f,0.0046391524374485015869f,0.4042695597745478153229f,\
0.8191288476809859275818f,0.5345056853257119655609f,0.9354873914271593093872f,\
0.6799723100848495960236f,0.3743787007406353950500f,0.1877744006924331188202f,\
0.8306224048137664794922f,0.0703320750035345554352f,0.2667721835896372795105f,\
0.1338863088749349117279f,0.1699936669319868087769f,0.8109536175616085529327f,\
0.4827399412170052528381f,0.6378918210975825786591f,0.6532695852220058441162f,\
0.6683483780361711978912f,0.7344740321859717369080f,0.5723471469245851039886f,\
0.8637779299169778823853f,0.114128809887915849686f,0.6580480458214879035950f,\
0.5045945676974952220917f,0.9304931387305259704590f}

#define CR2 {0.4259712868370115756989f,0.7602704120799899101257f,0.0969742774032056331635f,\
0.4801846649497747421265f,0.1877757241018116474152f,0.8814185047522187232971f,\
0.0292700375430285930634f,0.8533888049423694610596f,0.6302552805282175540924f,\
0.5044946586713194847107f,0.1639711013995110988617f,0.7960704732686281204224f,\
0.7220622044987976551056f,0.8315819846466183662415f,0.0036919671110808849335f,\
0.9424226135015487670898f,0.5196401872672140598297f,0.5065894601866602897644f,\
0.4127033217810094356537f,0.6533151101320981979370f,0.501574948895722627640f,\
0.520403296686708927155f,0.0206185649149119853973f,0.4165633432567119598389f,\
0.1275541991926729679108f,0.9734601816162467002869f,0.9600647068582475185394f,\
0.0264936182647943496704f,0.2156869736500084400177f,0.4144923957064747810364f,\
0.2820876422338187694550f,0.0115554705262184143066f,0.2319323443807661533356f,\
0.9741948051378130912781f,0.8930417983792722225189f,0.2787308450788259506226f,\
0.0853875060565769672394f,0.0125637287274003028870f,0.3567141587845981121063f,\
0.4434901513159275054932f,0.5231852368451654911041f,0.4986576801165938377380f,\
0.4054326615296304225922f,0.8140451926738023757935f,0.7187507343478500843048f,\
0.8415299849584698677063f,0.5039089727215468883514f,0.4986489713191986083984f,\
0.1471678265370428562164f,0.3910832731053233146667f,0.3095656349323689937592f,\
0.6046923678368330001831f,0.3414045576937496662140f,0.3275958457961678504944f,\
0.3730975906364619731903f,0.9983476959168910980225f,0.6231481493450701236725f,\
0.1586699178442358971f,0.9230180806480348110199f,0.5935091320425271987915f,\
0.4019993362016975879669f,0.5423517348244786262512f,0.0779389175586402416229f,\
0.6387800201773643493652f,0.1367760770954191684723f,0.6551735652610659599304f,\
0.3303351341746747493744f,0.9712570514529943466187f,0.5526766409166157245636f,\
0.8238675678148865699768f,0.6455440069548785686493f,0.7058613188564777374268f,\
0.2080520675517618656158f,0.6395015334710478782654f,0.0197484544478356838226f,\
0.3289662469178438186646f,0.0045380038209259510040f,0.2727865027263760566711f,\
0.8406948107294738292694f,0.6650723963975906372070f,0.7342959144152700901031f,\
0.2093062577769160270691f,0.8948949738405644893646f,0.6852791439741849899292f,\
0.2581136678345501422882f,0.1234186897054314613342f,0.3650629292242228984833f,\
0.6263032369315624237061f,0.4081154973246157169342f,0.1095790406689047813416f,\
0.6615356481634080410004f,0.3887942228466272354126f,0.2088313368149101734161f,\
0.9898350210860371589661f,0.4314283612184226512909f,0.6836967542767524719238f,\
0.5103755318559706211090f,0.9162438018247485160828f,0.5892742066644132137299f,\
0.8954097684472799301147f,0.6274849255569279193878f,0.9869608813896775245667f,\
0.7128982539288699626923f,0.1304925419390201568604f,0.0781663195230066776276f,\
0.0947508281096816062927f,0.6482759020291268825531f,0.4206676203757524490356f,\
0.0157033097930252552032f,0.7266698973253369331360f,0.6671256530098617076874f,\
0.5488706231117248535156f,0.4477724977768957614899f,0.9336705235764384269714f,\
0.0209862603805959224701f,0.4670969229191541671753f,0.8364190761931240558624f,\
0.1888776877894997596741f,0.2355282525531947612762f,0.7747952006757259368896f,\
0.1726417900063097476959f,0.3532871594652533531189f,0.9888498312793672084808f,\
0.2265578750520944595337f,0.1193372723646461963654f,0.467635613866150379181f,\
0.9175071450881659984589f,0.7378584071993827819824f,0.3163537555374205112457f,\
0.5891926242038607597351f,0.1940289377234876155853f,0.8575854804366827011108f,\
0.441404156852513551712f,0.3922245288267731666565f,0.2196655715815722942352f,\
0.1761240549385547637939f,0.1205885396338999271393f,0.7508801734074950218201f,\
0.2761224261485040187836f,0.6377332974225282669067f,0.2822759491391479969025f,\
0.0232485281303524971008f,0.4800276714377105236053f,0.2259713858366012573242f,\
0.0480956234969198703766f,0.255338179878890514374f,0.8838844164274632930756f,\
0.9909171890467405319214f,0.7547875796444714069366f,0.0237286994233727455139f,\
0.0672572324983775615692f,0.8869388215243816375732f,0.2006625742651522159576f,\
0.1356438836082816123962f,0.0619430518709123134613f,0.3897590730339288711548f,\
0.7104214397259056568146f,0.9051968725398182868958f,0.9548764410428702831268f,\
0.3615677133202552795410f,0.1120837950147688388824f,0.2245571417734026908875f,\
0.0125192492268979549408f,0.1329306717962026596069f,0.2197761316783726215363f,\
0.1487893695011734962463f,0.6704846317879855632782f,0.2702460922300815582275f,\
0.916129274759441614151f,0.2131141787394881248474f,0.2321454486809670925140f,\
0.9974972624331712722778f,0.4280352187342941761017f,0.2013407545164227485657f,\
0.6199770378880202770233f,0.7410524189472198486328f,0.8895133384503424167633f,\
0.5842213360592722892761f,0.0233843638561666011810f,0.7662614267319440841675f,\
0.7854359750635921955109f,0.346477583982050418854f,0.7867635409347712993622f,\
0.3745993338525295257568f,0.3698633969761431217194f,0.4212488224729895591736f,\
0.3815477318130433559418f,0.630106801167130470276f,0.6527381357736885547638f,\
0.4507121564820408821106f,0.8059874209575355052948f,0.0838774070143699645996f,\
0.0486886971630156040192f,0.091624463908374309540f,0.2564150630496442317963f,\
0.4653418269008398056030f,0.2816926469095051288605f,0.5845362627878785133362f,\
0.4137441064231097698212f,0.8090988881886005401611f}

#define CI2 {0.6393490717746317386627f,0.805427453480660915375f,0.1889523915015161037445f,\
0.9860434997826814651489f,0.1705104154534637928009f,0.5185149358585476875305f,\
0.2712999242357909679413f,0.1075414568185806274414f,0.9200236895121634006500f,\
0.0489821014925837516785f,0.3230310245417058467865f,0.7714011203497648239136f,\
0.7943310593254864215851f,0.0943802008405327796936f,0.1643108497373759746552f,\
0.6183919720351696014404f,0.1516798050142824649811f,0.8934515854343771934509f,\
0.7921462929807603359222f,0.1680600438266992568970f,0.7106916573829948902130f,\
0.4711248250678181648254f,0.5770412567071616649628f,0.4025902226567268371582f,\
0.8710415088571608066559f,0.1784316999837756156921f,0.481136301066726446152f,\
0.0674654301255941390991f,0.0399954994209110736847f,0.2460960680618882179260f,\
0.6415826673619449138641f,0.1576726771891117095947f,0.0585584775544703006744f,\
0.5705446070060133934021f,0.1629006764851510524750f,0.5582059938460588455200f,\
0.3209808361716568470001f,0.4510894315317273139954f,0.4620725023560225963593f,\
0.3076162338256835937500f,0.6813747235573828220367f,0.4970325855538249015808f,\
0.0101193203590810298920f,0.4533577542752027511597f,0.7411896293051540851593f,\
0.4234424093738198280334f,0.8139128307811915874481f,0.9676819704473018646240f,\
0.6112973452545702457428f,0.9543517818674445152283f,0.4819711572490632534027f,\
0.6928277853876352310181f,0.7424363014288246631622f,0.5521282376721501350403f,\
0.217989120166748762131f,0.7842588946223258972168f,0.9177652769722044467926f,\
0.1917659593746066093445f,0.5858528851531445980072f,0.6206979658454656600952f,\
0.0012764860875904560089f,0.8988496446982026100159f,0.3898889864794909954071f,\
0.6497076936066150665283f,0.5358180389739573001862f,0.2699402486905455589294f,\
0.514097725506871938705f,0.1375687289983034133911f,0.7844757777638733386993f,\
0.6941326009109616279602f,0.0641209441237151622772f,0.2922044843435287475586f,\
0.3090644874610006809235f,0.4945348976179957389832f,0.6556941731832921504974f,\
0.7279028128832578659058f,0.6794784818775951862335f,0.7084200689569115638733f,\
0.1933331559412181377411f,0.7405845634639263153076f,0.4076515645720064640045f,\
0.7247990211471915245056f,0.9830047464929521083832f,0.3623690102249383926392f,\
0.6998763647861778736115f,0.4981657536700367927551f,0.5225321832112967967987f,\
0.6641861572861671447754f,0.1212330483831465244293f,0.5571643514558672904968f,\
0.8134847371838986873627f,0.275185918435454368591f,0.7658774037845432758331f,\
0.5269278520718216896057f,0.5383017356507480144501f,0.5876941718161106109619f,\
0.0269383029080927371979f,0.3838389879092574119568f,0.9464009604416787624359f,\
0.6164656896144151687622f,0.5597745371051132678986f,0.1614628033712506294250f,\
0.7930214214138686656952f,0.9809839427471160888672f,0.5323410280980169773102f,\
0.3264011470600962638855f,0.1745505048893392086029f,0.9795577805489301681519f,\
0.7564144139178097248077f,0.5428190389648079872131f,0.6040854970924556255341f,\
0.2239649854600429534912f,0.7934280098415911197662f,0.0443929126486182212830f,\
0.1709794825874269008636f,0.8033927027136087417603f,0.6286661443300545215607f,\
0.3324307324364781379700f,0.1281216177158057689667f,0.4464247450232505798340f,\
0.0075678699649870395660f,0.4189139856025576591492f,0.7507017790339887142181f,\
0.64982577227056026459f,0.0278900493867695331573f,0.3332115495577454566956f,\
0.8102095867507159709930f,0.2428723461925983428955f,0.0814798162318766117096f,\
0.1112154340371489524841f,0.5074178031645715236664f,0.3559808600693941116333f,\
0.7394064110703766345978f,0.9856483982875943183899f,0.2081001061014831066132f,\
0.2623823434114456176758f,0.6742023923434317111969f,0.9962934432551264762878f,\
0.8252332373522222042084f,0.0615941416472196578979f,0.2129642223007977008820f,\
0.7388951787725090980530f,0.1914335261099040508270f,0.6734384708106517791748f,\
0.6150622279383242130280f,0.4714830657467246055603f,0.2653777874074876308441f,\
0.1113578472286462783813f,0.6682099369354546070099f,0.2968665333464741706848f,\
0.5159585955552756786346f,0.5037773922085762023926f,0.6966427885927259922028f,\
0.6400519711896777153015f,0.3279239325784146785736f,0.8322640117257833480835f,\
0.5751562197692692279816f,0.7393315965309739112854f,0.7727512116543948650360f,\
0.8552324511110782623291f,0.8427531258203089237213f,0.3697941964492201805115f,\
0.5885056755505502223969f,0.185948224738240242004f,0.5096506965346634387970f,\
0.5180077450349926948547f,0.7124331700615584850311f,0.9935774207115173339844f,\
0.6513966270722448825836f,0.2266238955780863761902f,0.2100372924469411373138f,\
0.296033380553126335144f,0.3838447039015591144562f,0.3276543477550148963928f,\
0.9443909148685634136200f,0.3133702538907527923584f,0.3127397657372057437897f,\
0.2831690898165106773376f,0.8294320828281342983246f,0.8504734281450510025024f,\
0.0516620394773781299591f,0.8521665157750248908997f,0.0109942886047065258026f,\
0.1777968332171440124512f,0.9020808511413633823395f,0.8023654175922274589539f,\
0.8193211196921765804291f,0.3788971211761236190796f,0.2892677118070423603058f,\
0.3856688523665070533752f,0.8368152822367846965790f,0.6335147209465503692627f,\
0.0478187785483896732330f,0.7960498845204710960388f,0.9247719994746148586273f,\
0.4049517679959535598755f,0.1505366903729736804962f,0.3286092029884457588196f,\
0.5528467851690948009491f,0.0004969090223312377930f}

#define CResR {-0.4532760601370298680912f,0.2328568279348733338630f,-0.0721739248448070302988f,\
-0.7606257532599224324699f,-0.0286009079979238634017f,0.0446282927443572285942f,\
-0.1676194364050221097262f,0.6500285865688182340705f,0.3126717730334664935299f,\
0.4412835685735998492163f,-0.0863853232804955989410f,0.2599876176861364296400f,\
-0.3081394309018399835232f,0.5483498039081077246593f,-0.0280685784873250555871f,\
0.1103398428388524532551f,0.1878638951594227557429f,0.0489837078099595035763f,\
0.0544579030846000788912f,0.4870763078789703826033f,-0.2608486317663467612959f,\
-0.2619676674188661236187f,-0.4486176628283578549095f,-0.1699076965638988134799f,\
0.0226500810131932545088f,0.2525187524366853675239f,-0.2962492545486477002470f,\
0.0050349784816676457222f,0.0478668812844439128806f,-0.161512306092542023972f,\
-0.0833553662573387199597f,-0.0096347091494573405823f,0.1892857042353479901653f,\
-0.1078039385912064745954f,0.0714942955946598623918f,0.0393949194957836229536f,\
-0.1400294459234943666992f,-0.2723485697759917556482f,-0.1406631695056576036862f,\
-0.0914284063414464026609f,0.0718601543879791859748f,-0.0502555196723774022516f,\
0.3308392578597269539920f,0.3889296718119258922108f,-0.5194079193768161850642f,\
-0.2709799400469976582428f,-0.3469689150581814485186f,0.4051294378302779941592f,\
-0.5157677188576927918007f,0.0956281317726613566688f,-0.2950104262230037743819f,\
0.2475225041547986504220f,0.0416670917625362458026f,-0.0931174729511790588710f,\
-0.0693836181169946164538f,0.0251979011091364446528f,0.1749033102248601090345f,\
-0.1036931245422025305025f,-0.1494776851046086263430f,-0.4129188753992821814265f,\
0.0956892042125161157440f,-0.381500629131777346803f,-0.0834984180348100207825f,\
-0.1258676160077962236095f,-0.0938063966240257895990f,0.1573017568314179215339f,\
0.0850675970242064927174f,-0.0127169319676398440144f,0.3215644924894006106975f,\
0.1725016235865347580258f,0.0657245842114690947966f,-0.0091973641655471172207f,\
0.0645495682688117383696f,0.2199842886414065112888f,-0.4594590945201037501811f,\
-0.0076146572424504455068f,-0.2255298228492429168934f,-0.0089042461759258062504f,\
0.3492561737977078473172f,-0.2991314773617905764524f,0.2705755498034173589517f,\
-0.5188001861108486600926f,0.5618831798406120903167f,-0.2592918419562091347785f,\
-0.4273656804273420206641f,-0.4233085641525572428989f,0.1726206665681528085177f,\
-0.0713880252688461475197f,0.0409534431553852107388f,-0.4784636138374023794917f,\
0.2528249080775029078438f,-0.0751963670383180432522f,-0.2099825350036476079296f,\
0.3930475624040330462350f,-0.0536983488983542034401f,0.4696177809171224182272f,\
0.4499246289866181136574f,-0.1184924563459542473653f,0.4455130076495959490224f,\
0.0137745535065977864342f,0.0572770873632376664730f,0.4028010939579977911507f,\
-0.5479035230736655215367f,-0.8476656355498256578684f,-0.4152860994745538603112f,\
-0.1719656910372130420583f,0.1500796339609139773419f,-0.3508489918077146718645f,\
0.0007517730549635760762f,-0.0093318934652646470806f,-0.4253349873439855599599f,\
0.2806279433177717441694f,-0.1888983413465122329633f,0.7064426647296654371289f,\
-0.0608123808038953800326f,-0.0613171594896803062724f,-0.4505394490178394883984f,\
-0.0037858539492685930328f,0.2097666454331615359941f,-0.0211842001217234093824f,\
0.0527063906668108692055f,0.0768025778411403764467f,0.8585738883942192201104f,\
0.1759375052405339756589f,0.0503612958523844411740f,-0.2721751218561426211018f,\
-0.0864544627613991201187f,-0.0103374763464706836968f,0.1595894682913722162354f,\
0.1366255514725323583214f,-0.1808181983112125135182f,0.6659753695010871554771f,\
-0.3552522431189574225741f,-0.6660760695837163458677f,0.0122680731984931845613f,\
-0.1501265897279337457881f,-0.1506290509488406037519f,-0.3872440085463784154030f,\
-0.3642683937636469471144f,0.3554966732726081435345f,0.1798988824024553845327f,\
-0.5353736140053680925277f,0.3328780019103673160075f,-0.3831916918313129638562f,\
-0.1334464728224985796690f,-0.2528584112494918212377f,0.0776621078396230318797f,\
0.6042048881391237635796f,0.0542925615451090859409f,0.0152869439779466861906f,\
-0.2578916798676885169250f,0.6210074811527457327998f,0.0697480566005716229316f,\
-0.5360219400392558508628f,-0.0164769465814076573884f,0.2578547191709110730784f,\
0.2692458480889036165351f,0.2164281534628332004377f,-0.2165469974967820787626f,\
-0.6114963430660671495076f,-0.3276202230479545729480f,-0.1532470446853400614096f,\
-0.5711409136688807564042f,0.1041463421049710486033f,-0.3894804137321275505634f,\
-0.3320104464777595687508f,-0.4043603275945338859643f,-0.7061983397762294778488f,\
0.563118573862244065076f,-0.104052368330380548556f,0.0164178824827940009201f,\
-0.0912715036235035442891f,-0.0802371510589425240845f,-0.0399581838468483496740f,\
-0.1945912294495280026041f,0.5793779114170104493908f,0.0565281114058220068852f,\
-0.0343252140979214692695f,-0.4239568198880452332133f,-0.4604615564320009846178f,\
0.4166399479456509569175f,0.0131813866470892881999f,0.3736222424672819841796f,\
-0.0991373897615358684599f,0.2529810514946274069281f,0.0689311545837876515908f,\
0.2497484491434210918115f,0.1002341291998606193081f,-0.1945593262740688278445f,\
0.2527651998409092271025f,-0.3858322501194685338888f,-0.3391363400421857909883f,\
0.0090761661352664196878f,-0.5771490540989443474018f,-0.4845995748950238657393f,\
-0.0464806889926007715808f,0.1478644355329177817460f,-0.0455521984464080931243f,\
0.0072729334007000101536f,0.5914465599501286252604f}

#define CResI {0.6867532750160018073515f,0.9613302788463532477792f,0.1837939587530955376504f,\
0.6396229422193046021405f,0.2118940797572615719613f,0.2758431416829634774679f,\
0.0801773911552379342504f,0.8704396947843597853733f,0.6857529536617394949616f,\
0.2682798733548960590234f,0.265520729527220722410f,1.3002525570030343260441f,\
1.22341111147360948053f,0.2823894734241773618599f,0.0830507125337052176661f,\
1.4084050938175196598934f,0.4714708444194484759926f,0.3864899878199242189147f,\
0.578671353512100639094f,0.4097343720866399863212f,0.2871862109036796839590f,\
0.4339746194558397052177f,0.2190944030815045462379f,0.1905148747457021396468f,\
0.6580570072675409054597f,0.4661869040666266617023f,0.8599269442495538484650f,\
0.0264043433044500661100f,0.0516749566895557260748f,0.4191162112725183019890f,\
0.6380079192550233146974f,0.0528761984310826271827f,0.1750249364921274419782f,\
0.262006263440240305673f,0.2551006766112977608429f,0.3726589610422177956117f,\
0.2688345275772468512265f,0.0399340736448891148180f,0.1540820834002836481336f,\
0.2363839254618368690419f,0.5686876044589181944389f,0.8679966059615636941871f,\
0.0514995744434985636140f,0.9745475763214328512873f,0.6398586919691986452108f,\
0.87003041421366145158f,0.5098556345730298478003f,0.7918453871370533247998f,\
0.3977293850986994838692f,0.4690074760926845609532f,0.3456862982279912954731f,\
0.8775057294133996599328f,0.8415504958063240170674f,0.6158257382443957927975f,\
0.3254403835162152369698f,0.3092837496266652719257f,1.016502867475419513710f,\
0.1377386626241807465743f,1.0887841690471091737891f,0.4545278067154325807309f,\
0.3441598726430060706249f,0.5306377190646557329146f,0.4023845929152815026342f,\
0.4125675613624649740174f,0.2054662834722358610851f,0.6177146421590287150849f,\
0.6484264545005361535246f,0.8358924918092586198171f,0.5951731030444011860681f,\
1.4105647290575316077366f,0.2564640348596678998128f,0.7845236225889706815906f,\
0.1082954403048045077806f,0.2214325174472631663214f,0.5867100045537700925280f,\
0.5180978688180153390874f,0.3195153417190086386768f,0.7488602710128838824133f,\
0.1203597942708250490007f,0.5012941523009060151850f,0.7748826592461299789250f,\
0.4421661217651661757166f,0.9277146921619219277488f,0.5611941617833399176263f,\
0.1875332458457515116823f,0.3141666438540002825874f,0.4604943819421867812203f,\
0.0857080651661168146926f,0.3208952842499418478539f,0.4512919342037237102616f,\
0.7790380828723415529424f,0.2761644904057471983094f,0.5650186739065693464212f,\
0.4507563807256466659190f,0.2078905437719839599531f,0.5277912987547750400807f,\
0.3716354279518757630640f,0.5373704615276944096536f,0.9780785319295863811107f,\
0.0159155946349303842324f,1.0224311029322552535348f,0.5264940700384401761625f,\
0.7343311398624580155214f,0.3704907408839669402667f,0.5288385630587791874646f,\
0.3959302386908920556863f,0.7086176744936288907084f,0.7694711035408567934013f,\
0.7356001732724122277318f,0.0399627592998382727418f,0.5185668150213963434325f,\
0.1331315821040593705415f,0.8170027538591018156922f,0.4049310194334793111537f,\
0.1478937773069877170684f,0.7786469990644202532337f,0.9289400296531356016061f,\
0.1371829990074564797897f,0.1749929113926765866793f,0.2441898291613232296893f,\
0.0986799128052451290927f,0.2473569799851849937422f,0.9160542553812340837993f,\
0.6487987635563003951944f,0.1266499083655910351531f,0.4604910075393342516747f,\
0.9425690210228523380209f,0.4054098304412955267040f,0.3282910877920472980662f,\
0.0998424092123958162315f,0.2184385926591740634262f,0.656067713825576603881f,\
0.7653872511944090906155f,0.7951531282252717325321f,0.2947609930653066756534f,\
0.2061139089866899365422f,0.4764220642520822779353f,1.3759775156473299518f,\
0.8528204157327108347886f,0.2443691207681686350384f,0.2914758305179087627401f,\
0.5616697707438699227467f,0.5342831779243247813938f,0.5173303887471423223587f,\
0.0400423211013342383868f,0.1734081126603988776136f,0.0356373465889542606622f,\
0.9647518864037544217283f,0.4797428841650468456237f,0.2788760702578375605398f,\
0.5426811930882043943924f,0.9529428659076060181832f,0.519214160106206801260f,\
0.1566372908148228326741f,0.1800568943774761565546f,0.8597000721649141752323f,\
0.5941980612955533036512f,0.4200596294318775236754f,1.3834337451293550191878f,\
0.7486653540997223466036f,0.3094005426987578855069f,0.2238402297126847184661f,\
0.2351212641216636478614f,0.1935041961305615509925f,0.3283396534211000528103f,\
0.6414187863585038007486f,0.5517671615629442527506f,1.1984678562974182547407f,\
0.7432168383550731283194f,0.2430428408595447509200f,0.1037376614284659104293f,\
0.6710156827233160203861f,0.6483185566975374625187f,0.2790420045943993176962f,\
1.4677304745898491766809f,0.2490552602808134563528f,0.4239289487649033905114f,\
0.5743412264612666184860f,0.6998750389577383934636f,1.0888059617925907041069f,\
0.5637897941342366880946f,0.9467997907854363015545f,0.1529839243771335122180f,\
0.3341914410029577231498f,0.7977632654942472534287f,0.6513779279028111268701f,\
0.8229411301591347260853f,0.2061183797708181497654f,0.5470771267862610809374f,\
0.5931748546354166373717f,0.6677576209776094895432f,0.6191412908370578227490f,\
0.0728435968768978286958f,0.1327083570997977524097f,0.3079385977540891605742f,\
0.6658977419097338312781f,0.1203493812224817605117f,0.4806090008275944458482f,\
0.5912434516954661045673f,0.7532244855713678965969f}

#define ZR1 {0.4167818673886358737946,0.7754927603527903556824,0.6147445752285420894623,\
0.2206868808716535568237,0.4781269435770809650421,0.1743857422843575477600,\
0.2262396733276546001434,0.8763213120400905609131,0.6657514632679522037506,\
0.9176845839247107505798,0.5456351465545594692230,0.9846978131681680679321,\
0.6502424892969429492950,0.6890702964738011360168,0.5013572606258094310760,\
0.7673201188445091247559,0.5771855586208403110504,0.3508661640807986259460,\
0.6027267514728009700775,0.8505915608257055282593,0.0968277682550251483917,\
0.1382516110315918922424,0.3514578486792743206024,0.0176461227238178253174,\
0.7433502362109720706940,0.3358979439362883567810,0.1121416739188134670258,\
0.3644763696938753128052,0.2574999374337494373322,0.1557759689167141914368,\
0.7854640143923461437225,0.3291082531213760375977,0.9463309147395193576813,\
0.0348854837939143180847,0.1279074712656438350677,0.5625727903097867965698,\
0.6738048647530376911163,0.0716566452756524085999,0.0616879831068217754364,\
0.1104246191680431365967,0.5760010988451540470123,0.8197732111439108848572,\
0.8186757243238389492035,0.8735574278980493545532,0.0946858790703117847443,\
0.1581676574423909187317,0.2620503786019980907440,0.8170662596821784973145,\
0.4229911291040480136871,0.4559381706640124320984,0.2294407873414456844330,\
0.8959066923707723617554,0.9569525201804935932159,0.7509375149384140968323,\
0.2412989730946719646454,0.1661008931696414947510,0.8466569320298731327057,\
0.1607837742194533348083,0.4182585380040109157562,0.0502405483275651931763,\
0.2407492888160049915314,0.2450429694727063179016,0.9512274372391402721405,\
0.2260366678237915039062,0.318048770073801279068,0.5373335508629679679871,\
0.9679651274345815181732,0.1066662650555372238159,0.7000243966467678546906,\
0.9661027649417519569397,0.1398940901271998882294,0.3816659115254878997803,\
0.3378799916245043277740,0.3828248968347907066345,0.8728957301937043666840,\
0.5871221665292978286743,0.4679985162802040576935,0.9163713874295353889465,\
0.4258406492881476879120,0.1739088818430900573730,0.7294957810081541538239,\
0.3723028255626559257507,0.8006032942794263362885,0.0427213814109563827515,\
0.0376335312612354755402,0.3958328152075409889221,0.7473109806887805461884,\
0.0146575160324573516846,0.3068419084884226322174,0.6172137176617980003357,\
0.7285772911272943019867,0.206095593050122261047,0.6171012860722839832306,\
0.4982942687347531318665,0.1864698487333953380585,0.7766191810369491577148,\
0.9174334802664816379547,0.0989990709349513053894,0.9559624656103551387787,\
0.0187387894839048385620,0.8602523361332714557648,0.4824799606576561927795,\
0.1686216662637889385223,0.2581604234874248504639,0.8603236884810030460358,\
0.9776892503723502159119,0.4902775860391557216644,0.5333510134369134902954,\
0.9720846978016197681427,0.0181248458102345466614,0.0364292445592582225800,\
0.5231507197022438049316,0.6790725612081587314606,0.7754972381517291069031,\
0.8091341941617429256439,0.6911821123212575912476,0.1892125983722507953644,\
0.3070683712139725685120,0.9991325433366000652313,0.1158062256872653961182,\
0.3297157124616205692291,0.4354123836383223533630,0.9969553551636636257172,\
0.9743754882365465164185,0.6353352260775864124298,0.0793482260778546333313,\
0.4567674207501113414764,0.1505335271358489990234,0.7237330921925604343414,\
0.2547941533848643302917,0.2566944076679646968842,0.9333118479698896408081,\
0.5517054800875484943390,0.4642940917983651161194,0.6993843833915889263153,\
0.2767733894288539886475,0.6460177362896502017975,0.6939658811315894126892,\
0.7965537137351930141449,0.5889529529958963394165,0.9025987205095589160919,\
0.7366213919594883918762,0.9812673362903296947479,0.5188445076346397399902,\
0.0478445165790617465973,0.0598085178062319755554,0.0917034088633954524994,\
0.7101853694766759872437,0.3557815183885395526886,0.9375250423327088356018,\
0.9701523329131305217743,0.9907872565090656280518,0.7148388908244669437408,\
0.0643543815240263938904,0.5210001519881188869476,0.9661642182618379592896,\
0.6379804057069122791290,0.3707732008770108222961,0.5714463251642882823944,\
0.4862074404954910278320,0.3099456527270376682281,0.2583809075877070426941,\
0.3787058754824101924896,0.9536569248884916305542,0.2653506253845989704132,\
0.9738010177388787269592,0.1274459133855998516083,0.9431200437247753143311,\
0.7913976819254457950592,0.3400043984875082969666,0.2612065351568162441254,\
0.0993869695812463760376,0.6489448812790215015411,0.5638043852522969245911,\
0.9915560963563621044159,0.7837929800152778625488,0.2056846939958631992340,\
0.3382737739011645317078,0.8287308602593839168549,0.4373776372522115707397,\
0.5751820881851017475128,0.9588336879387497901917,0.4775090212933719158173,\
0.1295908428728580474854,0.8555219904519617557526,0.6717643206939101219177,\
0.9420691034756600856781,0.2612957675009965896606,0.0613161218352615833282,\
0.9738875525072216987610,0.1835827338509261608124,0.8908186554908752441406,\
0.8428192087449133396149,0.0821714429184794425964,0.1742917909286916255951,\
0.6517955046147108078003,0.5859045688994228839874,0.2920065978541970252991,\
0.6918199281208217144012,0.7315656207501888275146}

#define ZI1 {0.9866490722633898258209,0.4429044118151068687439,0.6974684721790254116058,\
0.8788620475679636001587,0.6942774769850075244904,0.2103671850636601448059,\
0.6422466966323554515839,0.9095488712191581726074,0.1162161403335630893707,\
0.4426801158115267753601,0.54438647022470831871,0.6791554000228643417358,\
0.9790061046369373798370,0.2613751674070954322815,0.1820912803523242473602,\
0.9909572191536426544189,0.7388255582191050052643,0.1441168105229735374451,\
0.2452696315012872219086,0.408354120329022407532,0.4353716713376343250275,\
0.7087596403434872627258,0.7900028186850249767303,0.4402949064970016479492,\
0.0828518071211874485016,0.4173278687521815299988,0.8394970758818089962006,\
0.0684990715235471725464,0.1918341075070202350616,0.9186666915193200111389,\
0.4752700994722545146942,0.0852253548800945281982,0.5157074541784822940826,\
0.2485155304893851280212,0.2623219466768205165863,0.2103371713310480117798,\
0.6155008045025169849396,0.6057531507685780525208,0.3520403089933097362518,\
0.4564149156212806701660,0.3368119024671614170074,0.9235646529123187065125,\
0.1065901606343686580658,0.7106651421636343002319,0.7925953646190464496613,\
0.9542803401127457618713,0.58853778196498751640,0.0023766197264194488525,\
0.9455601410008966922760,0.0866364603862166404724,0.759459157940000295639,\
0.4246732611209154129028,0.3839263510890305042267,0.6142078237608075141907,\
0.7312827515415847301483,0.1793139278888702392578,0.3842914947308599948883,\
0.6737622944638133049011,0.9141166522167623043060,0.7132891099900007247925,\
0.8553560380823910236359,0.5722871581092476844788,0.4043100993148982524872,\
0.4159644804894924163818,0.2562583745457231998444,0.7214373638853430747986,\
0.4564993805252015590668,0.8455213252454996109009,0.0832691607065498828888,\
0.8981556417420506477356,0.3833881053142249584198,0.9534438475966453552246,\
0.0185950272716581821442,0.0502144945785403251648,0.7270118533633649349213,\
0.2758033480495214462280,0.3350416650064289569855,0.3654300654307007789612,\
0.0452371980063617229462,0.5600892789661884307861,0.6502862856723368167877,\
0.823297879658639431000,0.1572451046667993068695,0.7963371742516756057739,\
0.6245094579644501209259,0.9478004621341824531555,0.1917487042956054210663,\
0.1213034540414810180664,0.6951363184489309787750,0.9801368294283747673035,\
0.2816954418085515499115,0.5644371043890714645386,0.4424371575005352497101,\
0.1901238569989800453186,0.2492035995237529277802,0.1043982319533824920654,\
0.6797373802401125431061,0.5450195213779807090759,0.1244831955991685390472,\
0.0048734936863183975220,0.8619868424721062183380,0.4545180173590779304504,\
0.8424912574701011180878,0.8984384015202522277832,0.9064385616220533847809,\
0.8106667501851916313171,0.9610714702866971492767,0.5872165020555257797241,\
0.0191868026740849018097,0.0414552027359604835510,0.7443282003514468669891,\
0.0290854312479496002197,0.6213145391084253787994,0.3968256777152419090271,\
0.4549848935566842556000,0.4781798440963029861450,0.9684002888388931751251,\
0.1858559148386120796204,0.1994768488220870494843,0.2484412193298339843750,\
0.5571343251504004001617,0.1838635830208659172058,0.1695283665321767330170,\
0.0689645390957593917847,0.9127942626364529132843,0.9281826475635170936584,\
0.6239642719738185405731,0.4998918436467647552490,0.8513300181366503238678,\
0.1213616123422980308533,0.4545058137737214565277,0.3776026610285043716431,\
0.8098081466741859912872,0.8605336369946599006653,0.6793009373359382152557,\
0.7579513117671012878418,0.3389655523933470249176,0.9117085291072726249695,\
0.7079389332793653011322,0.3263010885566473007202,0.3516225744970142841339,\
0.7477366114035248756409,0.7216994608752429485321,0.7431053109467029571533,\
0.2207054481841623783112,0.5686944639310240745544,0.0127859464846551418304,\
0.893785255029797554016,0.3206281405873596668243,0.0234425412490963935852,\
0.626293356996029615402,0.5116549581289291381836,0.1057835617102682590485,\
0.8511046646162867546082,0.1486603482626378536224,0.1426428984850645065,\
0.3198941503651440143585,0.1612193891778588294983,0.9863557885400950908661,\
0.9205605499446392059326,0.4299718351103365421295,0.5713132461532950401306,\
0.9785496569238603115082,0.1216678116470575332642,0.8786373701877892017365,\
0.9206458600237965583801,0.6875183167867362499237,0.9672853127121925354004,\
0.2485490464605391025543,0.7788769407197833061218,0.2105341642163693904877,\
0.6432035919278860092163,0.9326907773502171039581,0.4684051508083939552307,\
0.8569896514527499675751,0.0046391524374485015869,0.4042695597745478153229,\
0.8191288476809859275818,0.5345056853257119655609,0.9354873914271593093872,\
0.6799723100848495960236,0.3743787007406353950500,0.1877744006924331188202,\
0.8306224048137664794922,0.0703320750035345554352,0.2667721835896372795105,\
0.1338863088749349117279,0.1699936669319868087769,0.8109536175616085529327,\
0.4827399412170052528381,0.6378918210975825786591,0.6532695852220058441162,\
0.6683483780361711978912,0.7344740321859717369080,0.5723471469245851039886,\
0.8637779299169778823853,0.114128809887915849686,0.6580480458214879035950,\
0.5045945676974952220917,0.9304931387305259704590}

#define ZR2 {0.4259712868370115756989,0.7602704120799899101257,0.0969742774032056331635,\
0.4801846649497747421265,0.1877757241018116474152,0.8814185047522187232971,\
0.0292700375430285930634,0.8533888049423694610596,0.6302552805282175540924,\
0.5044946586713194847107,0.1639711013995110988617,0.7960704732686281204224,\
0.7220622044987976551056,0.8315819846466183662415,0.0036919671110808849335,\
0.9424226135015487670898,0.5196401872672140598297,0.5065894601866602897644,\
0.4127033217810094356537,0.6533151101320981979370,0.501574948895722627640,\
0.520403296686708927155,0.0206185649149119853973,0.4165633432567119598389,\
0.1275541991926729679108,0.9734601816162467002869,0.9600647068582475185394,\
0.0264936182647943496704,0.2156869736500084400177,0.4144923957064747810364,\
0.2820876422338187694550,0.0115554705262184143066,0.2319323443807661533356,\
0.9741948051378130912781,0.8930417983792722225189,0.2787308450788259506226,\
0.0853875060565769672394,0.0125637287274003028870,0.3567141587845981121063,\
0.4434901513159275054932,0.5231852368451654911041,0.4986576801165938377380,\
0.4054326615296304225922,0.8140451926738023757935,0.7187507343478500843048,\
0.8415299849584698677063,0.5039089727215468883514,0.4986489713191986083984,\
0.1471678265370428562164,0.3910832731053233146667,0.3095656349323689937592,\
0.6046923678368330001831,0.3414045576937496662140,0.3275958457961678504944,\
0.3730975906364619731903,0.9983476959168910980225,0.6231481493450701236725,\
0.1586699178442358971,0.9230180806480348110199,0.5935091320425271987915,\
0.4019993362016975879669,0.5423517348244786262512,0.0779389175586402416229,\
0.6387800201773643493652,0.1367760770954191684723,0.6551735652610659599304,\
0.3303351341746747493744,0.9712570514529943466187,0.5526766409166157245636,\
0.8238675678148865699768,0.6455440069548785686493,0.7058613188564777374268,\
0.2080520675517618656158,0.6395015334710478782654,0.0197484544478356838226,\
0.3289662469178438186646,0.0045380038209259510040,0.2727865027263760566711,\
0.8406948107294738292694,0.6650723963975906372070,0.7342959144152700901031,\
0.2093062577769160270691,0.8948949738405644893646,0.6852791439741849899292,\
0.2581136678345501422882,0.1234186897054314613342,0.3650629292242228984833,\
0.6263032369315624237061,0.4081154973246157169342,0.1095790406689047813416,\
0.6615356481634080410004,0.3887942228466272354126,0.2088313368149101734161,\
0.9898350210860371589661,0.4314283612184226512909,0.6836967542767524719238,\
0.5103755318559706211090,0.9162438018247485160828,0.5892742066644132137299,\
0.8954097684472799301147,0.6274849255569279193878,0.9869608813896775245667,\
0.7128982539288699626923,0.1304925419390201568604,0.0781663195230066776276,\
0.0947508281096816062927,0.6482759020291268825531,0.4206676203757524490356,\
0.0157033097930252552032,0.7266698973253369331360,0.6671256530098617076874,\
0.5488706231117248535156,0.4477724977768957614899,0.9336705235764384269714,\
0.0209862603805959224701,0.4670969229191541671753,0.8364190761931240558624,\
0.1888776877894997596741,0.2355282525531947612762,0.7747952006757259368896,\
0.1726417900063097476959,0.3532871594652533531189,0.9888498312793672084808,\
0.2265578750520944595337,0.1193372723646461963654,0.467635613866150379181,\
0.9175071450881659984589,0.7378584071993827819824,0.3163537555374205112457,\
0.5891926242038607597351,0.1940289377234876155853,0.8575854804366827011108,\
0.441404156852513551712,0.3922245288267731666565,0.2196655715815722942352,\
0.1761240549385547637939,0.1205885396338999271393,0.7508801734074950218201,\
0.2761224261485040187836,0.6377332974225282669067,0.2822759491391479969025,\
0.0232485281303524971008,0.4800276714377105236053,0.2259713858366012573242,\
0.0480956234969198703766,0.255338179878890514374,0.8838844164274632930756,\
0.9909171890467405319214,0.7547875796444714069366,0.0237286994233727455139,\
0.0672572324983775615692,0.8869388215243816375732,0.2006625742651522159576,\
0.1356438836082816123962,0.0619430518709123134613,0.3897590730339288711548,\
0.7104214397259056568146,0.9051968725398182868958,0.9548764410428702831268,\
0.3615677133202552795410,0.1120837950147688388824,0.2245571417734026908875,\
0.0125192492268979549408,0.1329306717962026596069,0.2197761316783726215363,\
0.1487893695011734962463,0.6704846317879855632782,0.2702460922300815582275,\
0.916129274759441614151,0.2131141787394881248474,0.2321454486809670925140,\
0.9974972624331712722778,0.4280352187342941761017,0.2013407545164227485657,\
0.6199770378880202770233,0.7410524189472198486328,0.8895133384503424167633,\
0.5842213360592722892761,0.0233843638561666011810,0.7662614267319440841675,\
0.7854359750635921955109,0.346477583982050418854,0.7867635409347712993622,\
0.3745993338525295257568,0.3698633969761431217194,0.4212488224729895591736,\
0.3815477318130433559418,0.630106801167130470276,0.6527381357736885547638,\
0.4507121564820408821106,0.8059874209575355052948,0.0838774070143699645996,\
0.0486886971630156040192,0.091624463908374309540,0.2564150630496442317963,\
0.4653418269008398056030,0.2816926469095051288605,0.5845362627878785133362,\
0.4137441064231097698212,0.8090988881886005401611}

#define ZI2 {0.6393490717746317386627,0.805427453480660915375,0.1889523915015161037445,\
0.9860434997826814651489,0.1705104154534637928009,0.5185149358585476875305,\
0.2712999242357909679413,0.1075414568185806274414,0.9200236895121634006500,\
0.0489821014925837516785,0.3230310245417058467865,0.7714011203497648239136,\
0.7943310593254864215851,0.0943802008405327796936,0.1643108497373759746552,\
0.6183919720351696014404,0.1516798050142824649811,0.8934515854343771934509,\
0.7921462929807603359222,0.1680600438266992568970,0.7106916573829948902130,\
0.4711248250678181648254,0.5770412567071616649628,0.4025902226567268371582,\
0.8710415088571608066559,0.1784316999837756156921,0.481136301066726446152,\
0.0674654301255941390991,0.0399954994209110736847,0.2460960680618882179260,\
0.6415826673619449138641,0.1576726771891117095947,0.0585584775544703006744,\
0.5705446070060133934021,0.1629006764851510524750,0.5582059938460588455200,\
0.3209808361716568470001,0.4510894315317273139954,0.4620725023560225963593,\
0.3076162338256835937500,0.6813747235573828220367,0.4970325855538249015808,\
0.0101193203590810298920,0.4533577542752027511597,0.7411896293051540851593,\
0.4234424093738198280334,0.8139128307811915874481,0.9676819704473018646240,\
0.6112973452545702457428,0.9543517818674445152283,0.4819711572490632534027,\
0.6928277853876352310181,0.7424363014288246631622,0.5521282376721501350403,\
0.217989120166748762131,0.7842588946223258972168,0.9177652769722044467926,\
0.1917659593746066093445,0.5858528851531445980072,0.6206979658454656600952,\
0.0012764860875904560089,0.8988496446982026100159,0.3898889864794909954071,\
0.6497076936066150665283,0.5358180389739573001862,0.2699402486905455589294,\
0.514097725506871938705,0.1375687289983034133911,0.7844757777638733386993,\
0.6941326009109616279602,0.0641209441237151622772,0.2922044843435287475586,\
0.3090644874610006809235,0.4945348976179957389832,0.6556941731832921504974,\
0.7279028128832578659058,0.6794784818775951862335,0.7084200689569115638733,\
0.1933331559412181377411,0.7405845634639263153076,0.4076515645720064640045,\
0.7247990211471915245056,0.9830047464929521083832,0.3623690102249383926392,\
0.6998763647861778736115,0.4981657536700367927551,0.5225321832112967967987,\
0.6641861572861671447754,0.1212330483831465244293,0.5571643514558672904968,\
0.8134847371838986873627,0.275185918435454368591,0.7658774037845432758331,\
0.5269278520718216896057,0.5383017356507480144501,0.5876941718161106109619,\
0.0269383029080927371979,0.3838389879092574119568,0.9464009604416787624359,\
0.6164656896144151687622,0.5597745371051132678986,0.1614628033712506294250,\
0.7930214214138686656952,0.9809839427471160888672,0.5323410280980169773102,\
0.3264011470600962638855,0.1745505048893392086029,0.9795577805489301681519,\
0.7564144139178097248077,0.5428190389648079872131,0.6040854970924556255341,\
0.2239649854600429534912,0.7934280098415911197662,0.0443929126486182212830,\
0.1709794825874269008636,0.8033927027136087417603,0.6286661443300545215607,\
0.3324307324364781379700,0.1281216177158057689667,0.4464247450232505798340,\
0.0075678699649870395660,0.4189139856025576591492,0.7507017790339887142181,\
0.64982577227056026459,0.0278900493867695331573,0.3332115495577454566956,\
0.8102095867507159709930,0.2428723461925983428955,0.0814798162318766117096,\
0.1112154340371489524841,0.5074178031645715236664,0.3559808600693941116333,\
0.7394064110703766345978,0.9856483982875943183899,0.2081001061014831066132,\
0.2623823434114456176758,0.6742023923434317111969,0.9962934432551264762878,\
0.8252332373522222042084,0.0615941416472196578979,0.2129642223007977008820,\
0.7388951787725090980530,0.1914335261099040508270,0.6734384708106517791748,\
0.6150622279383242130280,0.4714830657467246055603,0.2653777874074876308441,\
0.1113578472286462783813,0.6682099369354546070099,0.2968665333464741706848,\
0.5159585955552756786346,0.5037773922085762023926,0.6966427885927259922028,\
0.6400519711896777153015,0.3279239325784146785736,0.8322640117257833480835,\
0.5751562197692692279816,0.7393315965309739112854,0.7727512116543948650360,\
0.8552324511110782623291,0.8427531258203089237213,0.3697941964492201805115,\
0.5885056755505502223969,0.185948224738240242004,0.5096506965346634387970,\
0.5180077450349926948547,0.7124331700615584850311,0.9935774207115173339844,\
0.6513966270722448825836,0.2266238955780863761902,0.2100372924469411373138,\
0.296033380553126335144,0.3838447039015591144562,0.3276543477550148963928,\
0.9443909148685634136200,0.3133702538907527923584,0.3127397657372057437897,\
0.2831690898165106773376,0.8294320828281342983246,0.8504734281450510025024,\
0.0516620394773781299591,0.8521665157750248908997,0.0109942886047065258026,\
0.1777968332171440124512,0.9020808511413633823395,0.8023654175922274589539,\
0.8193211196921765804291,0.3788971211761236190796,0.2892677118070423603058,\
0.3856688523665070533752,0.8368152822367846965790,0.6335147209465503692627,\
0.0478187785483896732330,0.7960498845204710960388,0.9247719994746148586273,\
0.4049517679959535598755,0.1505366903729736804962,0.3286092029884457588196,\
0.5528467851690948009491,0.0004969090223312377930}

#define ZResR {-0.4532760601370298680912,0.2328568279348733338630,-0.0721739248448070302988,\
-0.7606257532599224324699,-0.0286009079979238634017,0.0446282927443572285942,\
-0.1676194364050221097262,0.6500285865688182340705,0.3126717730334664935299,\
0.4412835685735998492163,-0.0863853232804955989410,0.2599876176861364296400,\
-0.3081394309018399835232,0.5483498039081077246593,-0.0280685784873250555871,\
0.1103398428388524532551,0.1878638951594227557429,0.0489837078099595035763,\
0.0544579030846000788912,0.4870763078789703826033,-0.2608486317663467612959,\
-0.2619676674188661236187,-0.4486176628283578549095,-0.1699076965638988134799,\
0.0226500810131932545088,0.2525187524366853675239,-0.2962492545486477002470,\
0.0050349784816676457222,0.0478668812844439128806,-0.161512306092542023972,\
-0.0833553662573387199597,-0.0096347091494573405823,0.1892857042353479901653,\
-0.1078039385912064745954,0.0714942955946598623918,0.0393949194957836229536,\
-0.1400294459234943666992,-0.2723485697759917556482,-0.1406631695056576036862,\
-0.0914284063414464026609,0.0718601543879791859748,-0.0502555196723774022516,\
0.3308392578597269539920,0.3889296718119258922108,-0.5194079193768161850642,\
-0.2709799400469976582428,-0.3469689150581814485186,0.4051294378302779941592,\
-0.5157677188576927918007,0.0956281317726613566688,-0.2950104262230037743819,\
0.2475225041547986504220,0.0416670917625362458026,-0.0931174729511790588710,\
-0.0693836181169946164538,0.0251979011091364446528,0.1749033102248601090345,\
-0.1036931245422025305025,-0.1494776851046086263430,-0.4129188753992821814265,\
0.0956892042125161157440,-0.381500629131777346803,-0.0834984180348100207825,\
-0.1258676160077962236095,-0.0938063966240257895990,0.1573017568314179215339,\
0.0850675970242064927174,-0.0127169319676398440144,0.3215644924894006106975,\
0.1725016235865347580258,0.0657245842114690947966,-0.0091973641655471172207,\
0.0645495682688117383696,0.2199842886414065112888,-0.4594590945201037501811,\
-0.0076146572424504455068,-0.2255298228492429168934,-0.0089042461759258062504,\
0.3492561737977078473172,-0.2991314773617905764524,0.2705755498034173589517,\
-0.5188001861108486600926,0.5618831798406120903167,-0.2592918419562091347785,\
-0.4273656804273420206641,-0.4233085641525572428989,0.1726206665681528085177,\
-0.0713880252688461475197,0.0409534431553852107388,-0.4784636138374023794917,\
0.2528249080775029078438,-0.0751963670383180432522,-0.2099825350036476079296,\
0.3930475624040330462350,-0.0536983488983542034401,0.4696177809171224182272,\
0.4499246289866181136574,-0.1184924563459542473653,0.4455130076495959490224,\
0.0137745535065977864342,0.0572770873632376664730,0.4028010939579977911507,\
-0.5479035230736655215367,-0.8476656355498256578684,-0.4152860994745538603112,\
-0.1719656910372130420583,0.1500796339609139773419,-0.3508489918077146718645,\
0.0007517730549635760762,-0.0093318934652646470806,-0.4253349873439855599599,\
0.2806279433177717441694,-0.1888983413465122329633,0.7064426647296654371289,\
-0.0608123808038953800326,-0.0613171594896803062724,-0.4505394490178394883984,\
-0.0037858539492685930328,0.2097666454331615359941,-0.0211842001217234093824,\
0.0527063906668108692055,0.0768025778411403764467,0.8585738883942192201104,\
0.1759375052405339756589,0.0503612958523844411740,-0.2721751218561426211018,\
-0.0864544627613991201187,-0.0103374763464706836968,0.1595894682913722162354,\
0.1366255514725323583214,-0.1808181983112125135182,0.6659753695010871554771,\
-0.3552522431189574225741,-0.6660760695837163458677,0.0122680731984931845613,\
-0.1501265897279337457881,-0.1506290509488406037519,-0.3872440085463784154030,\
-0.3642683937636469471144,0.3554966732726081435345,0.1798988824024553845327,\
-0.5353736140053680925277,0.3328780019103673160075,-0.3831916918313129638562,\
-0.1334464728224985796690,-0.2528584112494918212377,0.0776621078396230318797,\
0.6042048881391237635796,0.0542925615451090859409,0.0152869439779466861906,\
-0.2578916798676885169250,0.6210074811527457327998,0.0697480566005716229316,\
-0.5360219400392558508628,-0.0164769465814076573884,0.2578547191709110730784,\
0.2692458480889036165351,0.2164281534628332004377,-0.2165469974967820787626,\
-0.6114963430660671495076,-0.3276202230479545729480,-0.1532470446853400614096,\
-0.5711409136688807564042,0.1041463421049710486033,-0.3894804137321275505634,\
-0.3320104464777595687508,-0.4043603275945338859643,-0.7061983397762294778488,\
0.563118573862244065076,-0.104052368330380548556,0.0164178824827940009201,\
-0.0912715036235035442891,-0.0802371510589425240845,-0.0399581838468483496740,\
-0.1945912294495280026041,0.5793779114170104493908,0.0565281114058220068852,\
-0.0343252140979214692695,-0.4239568198880452332133,-0.4604615564320009846178,\
0.4166399479456509569175,0.0131813866470892881999,0.3736222424672819841796,\
-0.0991373897615358684599,0.2529810514946274069281,0.0689311545837876515908,\
0.2497484491434210918115,0.1002341291998606193081,-0.1945593262740688278445,\
0.2527651998409092271025,-0.3858322501194685338888,-0.3391363400421857909883,\
0.0090761661352664196878,-0.5771490540989443474018,-0.4845995748950238657393,\
-0.0464806889926007715808,0.1478644355329177817460,-0.0455521984464080931243,\
0.0072729334007000101536,0.5914465599501286252604}

#define ZResI {0.6867532750160018073515,0.9613302788463532477792,0.1837939587530955376504,\
0.6396229422193046021405,0.2118940797572615719613,0.2758431416829634774679,\
0.0801773911552379342504,0.8704396947843597853733,0.6857529536617394949616,\
0.2682798733548960590234,0.265520729527220722410,1.3002525570030343260441,\
1.22341111147360948053,0.2823894734241773618599,0.0830507125337052176661,\
1.4084050938175196598934,0.4714708444194484759926,0.3864899878199242189147,\
0.578671353512100639094,0.4097343720866399863212,0.2871862109036796839590,\
0.4339746194558397052177,0.2190944030815045462379,0.1905148747457021396468,\
0.6580570072675409054597,0.4661869040666266617023,0.8599269442495538484650,\
0.0264043433044500661100,0.0516749566895557260748,0.4191162112725183019890,\
0.6380079192550233146974,0.0528761984310826271827,0.1750249364921274419782,\
0.262006263440240305673,0.2551006766112977608429,0.3726589610422177956117,\
0.2688345275772468512265,0.0399340736448891148180,0.1540820834002836481336,\
0.2363839254618368690419,0.5686876044589181944389,0.8679966059615636941871,\
0.0514995744434985636140,0.9745475763214328512873,0.6398586919691986452108,\
0.87003041421366145158,0.5098556345730298478003,0.7918453871370533247998,\
0.3977293850986994838692,0.4690074760926845609532,0.3456862982279912954731,\
0.8775057294133996599328,0.8415504958063240170674,0.6158257382443957927975,\
0.3254403835162152369698,0.3092837496266652719257,1.016502867475419513710,\
0.1377386626241807465743,1.0887841690471091737891,0.4545278067154325807309,\
0.3441598726430060706249,0.5306377190646557329146,0.4023845929152815026342,\
0.4125675613624649740174,0.2054662834722358610851,0.6177146421590287150849,\
0.6484264545005361535246,0.8358924918092586198171,0.5951731030444011860681,\
1.4105647290575316077366,0.2564640348596678998128,0.7845236225889706815906,\
0.1082954403048045077806,0.2214325174472631663214,0.5867100045537700925280,\
0.5180978688180153390874,0.3195153417190086386768,0.7488602710128838824133,\
0.1203597942708250490007,0.5012941523009060151850,0.7748826592461299789250,\
0.4421661217651661757166,0.9277146921619219277488,0.5611941617833399176263,\
0.1875332458457515116823,0.3141666438540002825874,0.4604943819421867812203,\
0.0857080651661168146926,0.3208952842499418478539,0.4512919342037237102616,\
0.7790380828723415529424,0.2761644904057471983094,0.5650186739065693464212,\
0.4507563807256466659190,0.2078905437719839599531,0.5277912987547750400807,\
0.3716354279518757630640,0.5373704615276944096536,0.9780785319295863811107,\
0.0159155946349303842324,1.0224311029322552535348,0.5264940700384401761625,\
0.7343311398624580155214,0.3704907408839669402667,0.5288385630587791874646,\
0.3959302386908920556863,0.7086176744936288907084,0.7694711035408567934013,\
0.7356001732724122277318,0.0399627592998382727418,0.5185668150213963434325,\
0.1331315821040593705415,0.8170027538591018156922,0.4049310194334793111537,\
0.1478937773069877170684,0.7786469990644202532337,0.9289400296531356016061,\
0.1371829990074564797897,0.1749929113926765866793,0.2441898291613232296893,\
0.0986799128052451290927,0.2473569799851849937422,0.9160542553812340837993,\
0.6487987635563003951944,0.1266499083655910351531,0.4604910075393342516747,\
0.9425690210228523380209,0.4054098304412955267040,0.3282910877920472980662,\
0.0998424092123958162315,0.2184385926591740634262,0.656067713825576603881,\
0.7653872511944090906155,0.7951531282252717325321,0.2947609930653066756534,\
0.2061139089866899365422,0.4764220642520822779353,1.3759775156473299518,\
0.8528204157327108347886,0.2443691207681686350384,0.2914758305179087627401,\
0.5616697707438699227467,0.5342831779243247813938,0.5173303887471423223587,\
0.0400423211013342383868,0.1734081126603988776136,0.0356373465889542606622,\
0.9647518864037544217283,0.4797428841650468456237,0.2788760702578375605398,\
0.5426811930882043943924,0.9529428659076060181832,0.519214160106206801260,\
0.1566372908148228326741,0.1800568943774761565546,0.8597000721649141752323,\
0.5941980612955533036512,0.4200596294318775236754,1.3834337451293550191878,\
0.7486653540997223466036,0.3094005426987578855069,0.2238402297126847184661,\
0.2351212641216636478614,0.1935041961305615509925,0.3283396534211000528103,\
0.6414187863585038007486,0.5517671615629442527506,1.1984678562974182547407,\
0.7432168383550731283194,0.2430428408595447509200,0.1037376614284659104293,\
0.6710156827233160203861,0.6483185566975374625187,0.2790420045943993176962,\
1.4677304745898491766809,0.2490552602808134563528,0.4239289487649033905114,\
0.5743412264612666184860,0.6998750389577383934636,1.0888059617925907041069,\
0.5637897941342366880946,0.9467997907854363015545,0.1529839243771335122180,\
0.3341914410029577231498,0.7977632654942472534287,0.6513779279028111268701,\
0.8229411301591347260853,0.2061183797708181497654,0.5470771267862610809374,\
0.5931748546354166373717,0.6677576209776094895432,0.6191412908370578227490,\
0.0728435968768978286958,0.1327083570997977524097,0.3079385977540891605742,\
0.6658977419097338312781,0.1203493812224817605117,0.4806090008275944458482,\
0.5912434516954661045673,0.7532244855713678965969}



static void smulsTest(void){
  float P1[]=FP1;
  float P2[]=FP2;
  float Res[]=FRes;
  int i=0;
  float out;

  for (i=0;i<200;i++){
	out = smuls(P1[i],P2[i]);
	assert( ( fabs(out-Res[i]) / fabs(out) ) <1e-6);
  }
}


static void dmulsTest(void){
  double P1[]=DP1;
  double P2[]=DP2;
  double Res[]=DRes;
  int i=0;
  double out;

  for (i=0;i<200;i++){
	out = dmuls(P1[i],P2[i]);
	assert( ( fabs(out-Res[i]) / fabs(out) ) <3e-16);
  }	
}


static void cmulsTest(void){
  float P1_R[] = CR1;
  float P1_I[] = CI1;
  float P2_R[] = CR2;
  float P2_I[] = CI2;
  float Res_R[] = CResR;
  float Res_I[] = CResI;
  int i=0;
  floatComplex in1,in2,out;

  for (i=0;i<200;i++){
	in1=FloatComplex(P1_R[i],P1_I[i]);
	in2=FloatComplex(P2_R[i],P2_I[i]);
	out=cmuls(in1,in2);
	assert( ( fabs(creals(out)-Res_R[i]) / fabs(creals(out)) ) <3e-6);
	assert( ( fabs(cimags(out)-Res_I[i]) / fabs(cimags(out)) ) <1e-6);
  }	
}


static void zmulsTest(void){
  double P1_R[] = ZR1;
  double P1_I[] = ZI1;
  double P2_R[] = ZR2;
  double P2_I[] = ZI2;
  double Res_R[] = ZResR;
  double Res_I[] = ZResI;
  int i=0;
  doubleComplex in1,in2,out;

  for (i=0;i<200;i++){
	in1=DoubleComplex(P1_R[i],P1_I[i]);
	in2=DoubleComplex(P2_R[i],P2_I[i]);
	out=zmuls(in1,in2);
	assert( ( fabs(zreals(out)-Res_R[i]) / fabs(zreals(out)) ) <3e-15);
	assert( ( fabs(zimags(out)-Res_I[i]) / fabs(zimags(out)) ) <3e-15);
  }
}


static void smulaTest(void){
  float P1[]=FP1;
  float P2[]=FP2;
  float Res[]=FRes;
  int i=0;
  float out[200];

  smula(P1,P2,200,out);
  for(i=0;i<200;i++){
	assert( ( fabs(out[i]-Res[i]) / fabs(out[i]) ) <1e-6);
  }	
}


static void dmulaTest(void){
  double P1[]=DP1;
  double P2[]=DP2;
  double Res[]=DRes;
  int i=0;
  double out[200];

  dmula(P1,P2,200,out);
  for(i=0;i<200;i++){
	assert( ( fabs(out[i]-Res[i]) / fabs(out[i]) ) <1e-16);
  }	
}


static void cmulaTest(void){
  float P1_R[] = CR1;
  float P1_I[] = CI1;
  float P2_R[] = CR2;
  float P2_I[] = CI2;
  float Res_R[] = CResR;
  float Res_I[] = CResI;
  int i=0;
  floatComplex in1[200],in2[200],out[200];	

  for (i=0;i<200;i++){
	in1[i]=FloatComplex(P1_R[i],P1_I[i]);
	in2[i]=FloatComplex(P2_R[i],P2_I[i]);
  }
  
  cmula(in1,in2,200,out);
  for (i=0;i<200;i++){
  	assert( ( fabs(creals(out[i])-Res_R[i]) / fabs(creals(out[i])) ) <3e-6);
  	assert( ( fabs(cimags(out[i])-Res_I[i]) / fabs(cimags(out[i])) ) <1e-6);
  }
}


static void zmulaTest(void){
  double P1_R[] = ZR1;
  double P1_I[] = ZI1;
  double P2_R[] = ZR2;
  double P2_I[] = ZI2;
  double Res_R[] = ZResR;
  double Res_I[] = ZResI;
  int i=0;
  doubleComplex in1[200],in2[200],out[200];	

  for (i=0;i<200;i++){
	in1[i]=DoubleComplex(P1_R[i],P1_I[i]);
	in2[i]=DoubleComplex(P2_R[i],P2_I[i]);
  }
  
  zmula(in1,in2,200,out);
  for (i=0;i<200;i++){
  	assert( ( fabs(zreals(out[i])-Res_R[i]) / fabs(zreals(out[i])) ) <3e-15);
  	assert( ( fabs(zimags(out[i])-Res_I[i]) / fabs(zimags(out[i])) ) <3e-15);
  }
}



static int testMult(void) {
  smulsTest();
  dmulsTest();
  cmulsTest();
  zmulsTest();
  smulaTest();
  dmulaTest();
  cmulaTest();
  zmulaTest();
  return 0;
}



int main(void) {
  assert(testMult() == 0);
  return 0;
}
