/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include <assert.h>
#include <math.h>
#include "conv2d.h"
#include <stdio.h>
#define SOURCE1 {0.27602507699857836698,0.67970267685367480315,0.65509800397384065906,\
0.16261173519463056891,0.11899768155837664452,0.49836405198214295265,\
0.95974395851608107488,0.34038572666613320372,0.58526775097977734585}

#define SOURCE2 {0.22381193949113697972,0.75126705930565285119,0.25509511545926910614,0.50595705166514237661,\
0.69907672265668596712,0.89090325253579849551,0.95929142520544430361,0.54721552996380307121,\
0.13862444282867913969,0.14929400555905747439,0.25750825412373645751,0.84071725598366253696,\
0.25428217897153104765,0.81428482606881635864,0.24352496872498929914,0.92926362318722777189}

#define RESULT {0.06177770783124224979,0.35949412227527688390,0.72766963495480452284,0.80519921797623728033,0.51101266335063399993,0.33145145464232411703,\
0.22935715403715500882,0.86987390060810976244,1.57072190340944928266,1.87374187807601977340,1.18771170991100438741,0.61063060781955358358,\
0.36674405818143579472,1.16069853832181757447,1.50530552987165244794,2.16413391928651943630,1.60484415693162763006,1.11958509084199531181,\
0.76366488032771995265,1.53136700662003777396,2.54906722776044070145,2.57034999375695782931,1.76723864513866257830,1.34800960550190063181,\
0.17439323785911495235,0.35314105985283195110,0.64231507683460742353,1.56780077060808920031,0.66882373773691206065,0.95515628223064197311,\
0.24404578502623180958,0.86805896659833670093,0.65971570871717122309,1.45132222047376413521,0.45883538439608340109,0.54386803081010803851}


#define REAL1 {0.66538110421970486641,0.62839178834110498428, 0.84974523587152361870,0.68573101982474327087 }

#define IMAG1 {-0.87821648130193352699,-0.06837403681129217148,\
-0.56084860628470778465,-0.66235693730413913727}

#define REAL2 {0.33217189135029911995,0.59350947011262178421,0.50153415976092219353,0.43685875833034515381,\
0.26931248093023896217,0.63257448654621839523,0.40519540151581168175,0.91847078315913677216,\
0.04373343335464596748,0.48185089323669672012,0.26395560009405016899,0.41481037065386772156,\
0.28064980218186974525,0.12800584640353918076,0.77831285959109663963,0.21190304495394229889}

#define IMAG2 {-0.11213546665385365486,-0.68568959552794694901,-0.15312166837975382805,-0.69708506017923355103,\
-0.84155184263363480568,-0.40620247554033994675,-0.40948254754766821861,-0.87841258011758327484,\
-0.11383596854284405708,-0.19983377400785684586,-0.56186607433483004570,-0.58961773291230201721,\
-0.68539796629920601845,-0.89062247332185506821,-0.50422128057107329369,-0.34936154074966907501}

#define REALRES {0.12254168490351219356,-0.00620698294409172124,0.52531049188577938480,-0.01682362473694332117,0.22685593683438345924,\
-0.34049880015190781002,0.44913351267544954215,0.57284073382943700992,0.28907598257968836197,0.35494736024841355704,\
-0.31400940398865162528,0.10179275637972534652,0.25069879068018435797,0.18008660250348096366,0.26835012662172041953,\
-0.44187118264088443009,-0.31552872228703227053,0.20183362693927198173,0.11943448752613922137,0.00318181727621991151,\
-0.14592366179695342998,-0.65225983747193394535,-0.12355655213817345883,0.18386347752483947482,-0.08609354902257074227}

#define IMAGRES {-0.36633165023340091837,-1.07065163823997133719,-1.01380217936246941335,-0.97799610277246618040,-0.46791232441530977715,\
-1.07805207455505658309,-2.58549659104333517945,-2.20153008389715321158,-2.95066686999604854691,-1.38215608568270642564,\
-0.98029992300656176862,-2.08606516328413960082,-2.03693007812789206312,-2.93846237331332016396,-1.60958345050271689480,\
-0.82378154448145179956,-1.70198901954439785200,-2.66911026836615317137,-2.08241271540499273129,-0.91309628593039071642,\
-0.73981570694656195730,-1.48448309406143419409,-1.56048833083614346684,-1.27699492716519591440,-0.37992349748692871847}
 
static void dconv2daTest(void){
	int i;
	double in1[] = SOURCE1;
	double in2[] = SOURCE2;
	double res[] = RESULT;
	double out[36],outTest[9],outTest2[12*16];
	double test1[] = {1,2,3};
	double resTest[] ={1,2,3,2,4,6,3,6,9};
	double inTest1[] = {1,2,3,4,5,6,7,8,9,10,11,12};
	double inTest2[] = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16}; 
	dconv2da(in1,3,3,in2,4,4,out);
	for (i=0;i<36;i++){
		assert( ( fabs(out[i]-res[i]) / fabs(out[i]) ) <3e-16);
	}
	
	dconv2da(test1,1,3,test1,3,1,outTest);
	for (i=0;i<9;i++){
		assert( ( fabs(outTest[i]-resTest[i]) / fabs(outTest[i]) ) <3e-16);
	}
	
	dconv2da(inTest1,12,1,inTest2,1,16,outTest2);
	for (i=0;i<12*16;i++){
		printf("out[%d] : %f\n",i,outTest2[i]);
	}
	
}


static void zconv2daTest(void){
	int i;
	double rin1[] = REAL1;
	double iin1[] = IMAG1;
	double rin2[] = REAL2;
	double iin2[] = IMAG2;
	double rres[] = REALRES;
	double ires[] = IMAGRES;
	doubleComplex *in1, *in2,out[25];
	
	in1=DoubleComplexMatrix(rin1,iin1,4);
	in2=DoubleComplexMatrix(rin2,iin2,16);
	zconv2da(in1,2,2,in2,4,4,out);
	for (i=0;i<25;i++){
		assert( ( fabs(zreals(out[i])-rres[i]) / fabs(zreals(out[i])) ) <3e-14);
		assert( ( fabs(zimags(out[i])-ires[i]) / fabs(zimags(out[i])) ) <3e-14);
	}
}


static int conv2dTest(void){
	dconv2daTest();
	zconv2daTest();
	return 0;
}

int main (void){
	assert(conv2dTest()==0);
	return 0;
}

