/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
 
#include <assert.h>
#include <math.h>
#include <stdio.h>
#include "conv2d.h"

#define SOURCE1 {0.27602507699857836698f,0.67970267685367480315f,0.65509800397384065906f,\
0.16261173519463056891f,0.11899768155837664452f,0.49836405198214295265f,\
0.95974395851608107488f,0.34038572666613320372f,0.58526775097977734585f}

#define SOURCE2 {0.22381193949113697972f,0.75126705930565285119f,0.25509511545926910614f,0.50595705166514237661f,\
0.69907672265668596712f,0.89090325253579849551f,0.95929142520544430361f,0.54721552996380307121f,\
0.13862444282867913969f,0.14929400555905747439f,0.25750825412373645751f,0.84071725598366253696f,\
0.25428217897153104765f,0.81428482606881635864f,0.24352496872498929914f,0.92926362318722777189f}

#define RESULT {0.06177770783124224979f,0.35949412227527688390f,0.72766963495480452284f,0.80519921797623728033f,0.51101266335063399993f,0.33145145464232411703f,\
0.22935715403715500882f,0.86987390060810976244f,1.57072190340944928266f,1.87374187807601977340f,1.18771170991100438741f,0.61063060781955358358f,\
0.36674405818143579472f,1.16069853832181757447f,1.50530552987165244794f,2.16413391928651943630f,1.60484415693162763006f,1.11958509084199531181f,\
0.76366488032771995265f,1.53136700662003777396f,2.54906722776044070145f,2.57034999375695782931f,1.76723864513866257830f,1.34800960550190063181f,\
0.17439323785911495235f,0.35314105985283195110f,0.64231507683460742353f,1.56780077060808920031f,0.66882373773691206065f,0.95515628223064197311f,\
0.24404578502623180958f,0.86805896659833670093f,0.65971570871717122309f,1.45132222047376413521f,0.45883538439608340109f,0.54386803081010803851f}


#define REAL1 {0.66538110421970486641f,0.62839178834110498428f, 0.84974523587152361870f,0.68573101982474327087f }

#define IMAG1 {-0.87821648130193352699f,-0.06837403681129217148f,\
-0.56084860628470778465f,-0.66235693730413913727f}

#define REAL2 {0.33217189135029911995f,0.59350947011262178421f,0.50153415976092219353f,0.43685875833034515381f,\
0.26931248093023896217f,0.63257448654621839523f,0.40519540151581168175f,0.91847078315913677216f,\
0.04373343335464596748f,0.48185089323669672012f,0.26395560009405016899f,0.41481037065386772156f,\
0.28064980218186974525f,0.12800584640353918076f,0.77831285959109663963f,0.21190304495394229889f}

#define IMAG2 {-0.11213546665385365486f,-0.68568959552794694901f,-0.15312166837975382805f,-0.69708506017923355103f,\
-0.84155184263363480568f,-0.40620247554033994675f,-0.40948254754766821861f,-0.87841258011758327484f,\
-0.11383596854284405708f,-0.19983377400785684586f,-0.56186607433483004570f,-0.58961773291230201721f,\
-0.68539796629920601845f,-0.89062247332185506821f,-0.50422128057107329369f,-0.34936154074966907501f}

#define REALRES {0.12254168490351219356f,-0.00620698294409172124f,0.52531049188577938480f,-0.01682362473694332117f,0.22685593683438345924f,\
-0.34049880015190781002f,0.44913351267544954215f,0.57284073382943700992f,0.28907598257968836197f,0.35494736024841355704f,\
-0.31400940398865162528f,0.10179275637972534652f,0.25069879068018435797f,0.18008660250348096366f,0.26835012662172041953f,\
-0.44187118264088443009f,-0.31552872228703227053f,0.20183362693927198173f,0.11943448752613922137f,0.00318181727621991151f,\
-0.14592366179695342998f,-0.65225983747193394535f,-0.12355655213817345883f,0.18386347752483947482f,-0.08609354902257074227f}

#define IMAGRES {-0.36633165023340091837f,-1.07065163823997133719f,-1.01380217936246941335f,-0.97799610277246618040f,-0.46791232441530977715f,\
-1.07805207455505658309f,-2.58549659104333517945f,-2.20153008389715321158f,-2.95066686999604854691f,-1.38215608568270642564f,\
-0.98029992300656176862f,-2.08606516328413960082f,-2.03693007812789206312f,-2.93846237331332016396f,-1.60958345050271689480f,\
-0.82378154448145179956f,-1.70198901954439785200f,-2.66911026836615317137f,-2.08241271540499273129f,-0.91309628593039071642f,\
-0.73981570694656195730f,-1.48448309406143419409f,-1.56048833083614346684f,-1.27699492716519591440f,-0.37992349748692871847f}


static void sconv2daTest(void){
	int i;
	float in1[] = SOURCE1;
	float in2[] = SOURCE2;
	float res[] = RESULT;
	float out[36];
	
	sconv2da(in1,3,3,in2,4,4,out);
	for (i=0;i<36;i++){
		assert( ( fabs(out[i]-res[i]) / fabs(out[i]) ) <1e-6);
	}
}


static void cconv2daTest(void){
	int i;
	float rin1[] = REAL1;
	float iin1[] = IMAG1;
	float rin2[] = REAL2;
	float iin2[] = IMAG2;
	float rres[] = REALRES;
	float ires[] = IMAGRES;
	floatComplex *in1, *in2,out[25];
	
	in1=FloatComplexMatrix(rin1,iin1,4);
	in2=FloatComplexMatrix(rin2,iin2,16);
	cconv2da(in1,2,2,in2,4,4,out);
	for (i=0;i<25;i++){
		assert( ( fabs(creals(out[i])-rres[i]) / fabs(creals(out[i])) ) <3e-5);
		assert( ( fabs(cimags(out[i])-ires[i]) / fabs(cimags(out[i])) ) <1e-5);
	}
}


static int conv2dTest(void){
	sconv2daTest();
	cconv2daTest();
	return 0;
}

int main (void){
	assert(conv2dTest()==0);
	return 0;
}
