/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2008 - INRIA - Arnaud TORSET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

#include <math.h>
#include <stdio.h>
#include <assert.h>
#include "levin.h"



static void dlevinaTest(void) {

	int i=0;
  
	double in[20]={0.9932627780362963676453,0.8074779896996915340424,0.8554796632379293441773,
	0.5031460602767765522003,0.0963323051109910011292,0.7058098311536014080048,0.8630577065050601959229,
	0.0076185003854334354401,0.8048951094970107078552,0.5963762304745614528656,0.1176836211234331130981,
	0.8010095250792801380158,0.5132340090349316596985,0.2010910022072494029999,0.7860820889472961425781,
	0.7865035482682287693024,0.6951530007645487785339,0.4248132123611867427826,0.3446625452488660812378,
	0.6497785751707851886749};
	
	double result_la[48]={1,-0.3865652298877474413175,0,0,
	0,- 0.3434956227371184778185,0,0,
	0,- 0.5839401384584462784133,0,0,
	1, - 0.2005808775714553182645,0,0,
	1, - 0.9800896173744618744550, 1.690821697485581420750,0,
	0,- 0.0829753946826485844213, 0.1706850739778944525682,0,
	0,- 1.5024216979529190219012, - 0.2246231721723708774086,0,
	1, - 0.1137930279260921523354, - 0.9252347371003220022345,0,
	1, 0.9890664402902992202726, 0.5787159455904740124055,1.2930051366411721147642,
	0,- 0.8505434486601569643582,0.6053315910573954239382, - 0.5028225952598519565839,
	0,2.1236994816779066752588, - 2.0487578989503822946006, - 3.9701563399198689374714,
	1, - 1.4716550983021570164766, - 0.2144135496153387610008, 1.4891952441184541644503};
	
	double result_sig[12]={0.9932627780362963676453, 0.8074779896996915340424,0.3628661470549920387008,0.4106795421050958294629,
	- 0.6299693698364057237171,- 0.0327761932052800242232,0.1176836211234331130981,0.8010095250792801380158,
	- 0.1942402590062223821654, 0.5878460460823274891240,	0.3391635613203383137204,0.1291488276492920306282};
	
	double result_lb[48]={- 0.3981923483861428136876,1,0,0,
	- 0.3550295998674473652024,0,0,0,
	- 0.5696378489005990974903,0,0,0,
	- 0.1988863157065166586968,1,0,0,
	1.62419596196504145702, - 0.9819754657045941526050,1,0,
	0.0329804805798983302623, - 0.0396945499933941681192,0,0,
	- 0.1283118770193089619447, - 1.492334154918740996010,0,0,
	- 0.9551334433810730883963, - 0.0265634378315470209841,1,0,
	1.1913835764722526810999,0.0301096362936850159286, 1.909619275538441574014,1,
	0.4767865147665533709365 ,- 0.2016469880890300325760,0.2878592385656049135179,0,
	5.1391578635011887499218, - 2.5030727471739586675881, - 6.5148738878935787965929,0,
	- 2.8040366068494293472213 ,- 1.3523880325486907771904, 2.4607313355305917568217,1};
 
	double la[48],lb[48],sig[12];

	dlevina(3,in,10,2,la,sig,lb);

	/* FIXME : assert à 10^-13 */
	/* FIXME : sig est rangé différemment qu'à l'habitude */

	for (i=0;i<48;i++){
		if (la[i]!=0)
			assert( (fabs(la[i]-result_la[i]) / fabs(la[i]) ) <3e-15);
		else 
			assert( fabs(la[i]-result_la[i]) == 0);
	}
	
	for (i=0;i<12;i++){
		if (sig[i]!=0)
			assert( (fabs(sig[i]-result_sig[i]) / fabs(sig[i]) ) <3e-15);
		else 
			assert( fabs(sig[i]-result_sig[i]) == 0);
	}
	
	
	for (i=0;i<48;i++){
		if (lb[i]!=0)
			assert( (fabs(lb[i]-result_lb[i]) / fabs(lb[i]) ) <3e-13);
		else 
			assert( fabs(lb[i]-result_lb[i]) == 0);
	}
	
}



static int levinTest(void) {
  printf("\n>>>> Levin Tests\n");
  dlevinaTest();
  return 0;
}

int main(void) {
  assert( levinTest()== 0);
  return 0;
}
